//---------------------------------------------------------------------------

#ifndef TabletSimulation_FormH
#define TabletSimulation_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include "CSPIN.h"
#include <ComCtrls.hpp>

#include "CPB_Module.h"
#include "CPB_Module_Main.h"
#include <Chart.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>
#include "TntForms.hpp"
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include <Grids.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>

#define SIM_MANUAL_MODE   0
#define SIM_AUTO_MODE     1
#define SIM_SELECT_IMAGE  2

#define SMALL_SIZE_ANGLE1_RANGE 16
#define SMALL_SIZE_ANGLE2_RANGE 8
#define SMALL_SIZE_ANGLE3_RANGE 90

#define SMALL_WIDTH   320
#define SMALL_HEIGHT  240

typedef struct
{
  unsigned short SideShapeEdgePointSideWall[(MAX_TABLET_HEIGHT / 2)*2];
  unsigned short SideShapeEdgePointBottom[240*2];
  unsigned short SideShapeEdgePointCountSideWall;
  unsigned short SideShapeEdgePointCountBottom;
  unsigned short startX1, startY1, endX1, endY1;
  unsigned short startX2, startY2, endX2, endY2;
  unsigned short start_Number, end_Number;
  unsigned short ShapeEndY;

  short shiftTopLineX[MAX_TABLET_HEIGHT / 2];
  short shiftTopLineY[MAX_TABLET_HEIGHT / 2];
}TSideSmallSizeShapeData;

typedef union
{
    TSideSmallSizeShapeData SideShapeData[SMALL_SIZE_ANGLE3_RANGE*2 + 1][SMALL_SIZE_ANGLE1_RANGE*2+1];
}TSideSmallSizeData;

//---------------------------------------------------------------------------
class TTabletSimulationForm : public TTntForm
{
__published:	// IDE-managed Components
    TTntLabel *Label4;
    TTntLabel *Label5;
    TTntEdit *Edit12;
    TTntEdit *Edit13;
    TTntEdit *Edit14;
    TTntEdit *Edit15;
    TTntEdit *Edit16;
    TTntEdit *Edit17;
    TTntEdit *Edit18;
    TTntEdit *Edit19;
    TTntLabel *Label6;
  TPanel *Panel1;
  TTntImage *InspectionCam1;
  TTntImage *InspectionCam2;
  TTntImage *InspectionCam3;
  TTntImage *InspectionCam4;
  TTntImage *InspectionCam5;
  TTntImage *InspectionCam6;
  TTntImage *InspectionCam7;
  TTntImage *InspectionCam8;
  TTntImage *InspectionCam9;
  TTntImage *InspectionCam10;
  TTntImage *InspectionCam11;
  TTntImage *InspectionCam12;
  TTntImage *InspectionCam13;
  TTntImage *InspectionCam14;
  TTntImage *InspectionCam15;
  TTntImage *InspectionCam16;
  TPanel *Panel2;
  TGroupBox *GroupBox1;
  TTntLabel *Label1;
  TTntEdit *ImagePathEdit;
  TTntButton *FindImageFolderButton;
  TTntLabel *Label2;
  TTntEdit *ImageIndexEdit;
  TTntLabel *Label3;
  TTntEdit *CameraIndexEdit;
  TTntUpDown *UpDown2;
  TGroupBox *GroupBox2;
  TLabel *X;
  TTntEdit *XAxisEdit;
  TLabel *Y;
  TTntEdit *YAxisEdit;
  TTntLabel *Label9;
  TTntLabel *Label7;
  TTntEdit *InspectionResultEdit;
  TTntEdit *DefectInfoEdit;
  TTntLabel *TntLabel4;
  TTntLabel *TntLabel1;
  TTntEdit *PrintNumEdit;
  TTntEdit *PrintResultEdit;
  TPanel *Panel3;
  TTntImage *Image11;
  TTntImage *Image12;
  TGroupBox *GroupBox3;
  TGroupBox *GroupBox4;
  TCheckBox *CameraMaskChkBox1;
  TCheckBox *CameraMaskChkBox2;
  TCheckBox *CameraMaskChkBox3;
  TCheckBox *CameraMaskChkBox4;
  TCheckBox *CameraMaskChkBox5;
  TCheckBox *CameraMaskChkBox6;
  TCheckBox *CameraMaskChkBox7;
  TCheckBox *CameraMaskChkBox8;
  TCheckBox *CameraMaskChkBox12;
  TCheckBox *CameraMaskChkBox11;
  TCheckBox *CameraMaskChkBox10;
  TCheckBox *CameraMaskChkBox9;
  TCheckBox *CameraMaskChkBox16;
  TCheckBox *CameraMaskChkBox15;
  TCheckBox *CameraMaskChkBox14;
  TCheckBox *CameraMaskChkBox13;
  TCheckBox *CameraMaskAllChkBox;
  TButton *AutoStartBtn;
  TButton *AutoStopBtn;
  TProgressBar *ProgressBar1;
  TStringGrid *AutoInspectionResultGrid;
  TTntImage *AutoProcessedImage;
  TEdit *GoodRateEdit;
  TTntLabel *TntLabel2;
  TTntLabel *DefectSizeCaption;
  TTntEdit *DefectSizeEdit;
  TPanel *PagePanel1;
  TTntImage *DebugData1;
  TTntImage *DebugData2;
  TTrackBar *TrackBar1;
  TTntImage *DebugData3;
  TTntImage *DebugData4;
  TTntImage *DebugData5;
  TEdit *Edit5;
  TTntImage *DebugData6;
  TTntImage *DebugData7;
  TTrackBar *TrackBar2;
  TOpenPictureDialog *OpenPictureDialog1;
  TButton *Button2;
  TButton *Button3;
  TImage *histoImage;
  TButton *Button4;
  TTrackBar *TrackBar3;
  TButton *Button5;
  TTrackBar *TrackBar4;
  TButton *Button6;
  TUpDown *UpDown12;
  TTntImage *DebugData8;
  TGroupBox *GroupBox5;
  TUpDown *UpDown7;
  TUpDown *UpDown8;
  TUpDown *UpDown9;
  TUpDown *UpDown5;
  TUpDown *UpDown4;
  TLabel *Label8;
  TLabel *Label10;
  TLabel *Label11;
  TLabel *Label12;
  TLabel *Label13;
  TEdit *Edit1;
  TEdit *Edit2;
  TEdit *Edit3;
  TEdit *Edit4;
  TLabel *Label14;
  TLabel *helpLabel1;
  TLabel *helpLabel2;
  TLabel *helpLabel3;
  TLabel *helpLabel4;
  TLabel *helpLabel7;
  TLabel *helpLabel8;
  TLabel *helpLabel6;
  TLabel *helpLabel5;
  TUpDown *UpDown1;
  TUpDown *UpDown3;
  TButton *Button1;
  TUpDown *UpDown13;
  TUpDown *UpDown14;
  TUpDown *UpDown15;
  TButton *Button7;
  TButton *Button8;
  TLabel *printBColorLabel;
  TLabel *printGColorLabel;
  TLabel *printRColorLabel;
  TCheckBox *SaveBMPCheck;
  TLabel *Label15;
  TTntEdit *TntEdit1;
  TTntEdit *TntEdit2;
  TLabel *Label16;
  TLabel *Label17;
  TTntEdit *TntEdit3;
  TTrackBar *TrackBar5;
  TButton *Button9;
  TButton *Button10;
  TButton *Button11;
  TUpDown *UpDown6;
  TEdit *Edit6;
  TTrackBar *TrackBar6;
  TPanel *PagePanel2;
  TTntUpDown *TntUpDown1;
  TEdit *ImageRootEdit;
  TLabel *Label18;
  TImage *BackGroundImage1;
  TImage *BackGroundImage9;
  TImage *BackGroundImage2;
  TImage *BackGroundImage3;
  TImage *BackGroundImage4;
  TImage *BackGroundImage6;
  TImage *Image6;
  TImage *Image7;
  TImage *BackGroundImage7;
  TImage *BackGroundImage8;
  TImage *BackGroundImage10;
  TImage *BackGroundImage11;
  TImage *BackGroundImage12;
  TImage *BackGroundImage14;
  TImage *BackGroundImage15;
  TImage *BackGroundImage16;
  TBitBtn *BitBtn1;
  TTntUpDown *TntUpDown2;
  TButton *Button12;
  TCheckBox *CheckBox1;
  TTrackBar *TrackBar7;
  TTrackBar *TrackBar8;
  TEdit *Edit7;
  TEdit *Edit8;
  TEdit *Edit9;
  TEdit *Edit10;
  TEdit *Edit11;
  TButton *Button17;
  TImage *RealThreeDImage;
  TImage *ySliceThreeDImage;
  TImage *xSliceThreeDImage;
  TLabel *Label19;
  TTimer *KeyboardInputCheckingTimer;
  TButton *Button13;
  TPanel *ThreeDDebugPanel;
  TGroupBox *GroupBox6;
  TImage *ThreeDRotationImage;
  TLabel *Label20;
  TLabel *Label21;
  TLabel *Label22;
  TUpDown *Disk1RotationAngle1;
  TUpDown *Disk1RotationAngle2;
  TUpDown *Disk1RotationAngle3;
  TLabel *Label23;
  TImage *ThreeDDebug_OriginalImage;
  TImage *ThreeDDebug_MaxLabelingImage;
  TLabel *Label24;
  TImage *ThreeDDebug_BasicTabletAreaImage;
  TLabel *Label25;
  TImage *ThreeDDebug_ScaleDownImage;
  TLabel *Label26;
  TImage *ThreeDDebug_OverlapAreaImage;
  TLabel *Label27;
  TImage *ThreeDDebug_ApplyOverlapRemoveImage;
  TLabel *Label28;
  TImage *ThreeDDebug_RemoveNoiseImage;
  TLabel *Label29;
  TImage *ThreeDDebug_COGResultImage;
  TLabel *Label30;
  TLabel *Label31;
  TImage *ThreeDDebug_RotationImage;
  TImage *SliceResult1;
  TImage *SliceResult2;
  TLabel *Label32;
  TLabel *Label33;
  TTntUpDown *ThreeDImageUpdown;
  TImage *ThreeDDebug_DentedImage;
  TLabel *Label34;
  TCheckBox *CheckBox2;
  TLabel *Label35;
  TImage *ThreeDDebug_SaturationArea;
  TLabel *Label36;
  TLabel *Label37;
  TLabel *ThreeDYZRotationAngleLabel;
  TLabel *ThreeDXZRotationAngleLabel;
  TLabel *Label38;
  TImage *ThreeDDebug_BeforeRotationResult;
  TLabel *Label39;
  TImage *SliceResult3;
  TImage *SliceResult4;
  TLabel *Label40;
  TTntLabel *TntLabel3;
  TTntLabel *TntLabel5;
  TTntEdit *ThreeDCameraNumberEdit;
  TTntEdit *ThreeDImageNumberEdit;
  TLabel *Label41;
  TImage *ThreeDDebug_PrintMatchingResult;
  TLabel *Label42;
  TLabel *Label43;
  TImage *ThreeDDebug_ThreeDShellImage;
  TLabel *Label44;
  TLabel *Label45;
  TImage *ThreeDDebug_ExpecteDefectArea;
  TTrackBar *TrackBar9;
  TImage *ThreeDDebug_Planazation;
  TLabel *Label46;
  TCheckBox *CheckBox3;
  TCheckBox *CheckBox4;
  TButton *Button14;
  TImage *Image1;
  TImage *Image2;
  TTrackBar *TrackBar10;
  TShape *Shape1;
  TLabel *Label47;
  TLabel *Label48;
  TLabel *Label49;
  TImage *ModelingTestImage;
  TImage *ModelingResultImage;
  TTrackBar *TrackBar11;
  TImage *SugarCoatingTestImage;
  TButton *Button15;
  TButton *Button16;
  TTrackBar *TrackBar12;
  TEdit *Edit20;
  TEdit *Edit21;
  TUpDown *UpDown11;
  TUpDown *UpDown16;
  TTrackBar *TrackBar13;
  TTntButton *TntButton1;
	TLabel *Label50;
	TLabel *Label51;
	TLabel *Label52;
	TLabel *Label53;
	TEdit *Edit22;
	TCheckBox *LoadFromBMPCheckBox;
	TCheckBox *cameraNumSetCheckBox;
	TEdit *cameraNumSetEdit;
	TPanel *InspectionTimePanel;
	TMemo *InspectionTimeMemo;
	TButton *SpeedCheckPanelCloseButton;
	TTntButton *TntButton2;

    void __fastcall FindImageFolderButtonClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
    void __fastcall UpDown2Click(TObject *Sender, TUDBtnType Button);
    void __fastcall InspectionCameraClick(TObject *Sender);
    void __fastcall Inspection3DCamClick(TObject *Sender);
  void __fastcall ImageIndexEditKeyPress(TObject *Sender, char &Key);
  void __fastcall Image12MouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall TntFormActivate(TObject *Sender);
  void __fastcall CameraMaskAllChkBoxClick(TObject *Sender);
  void __fastcall AutoStartBtnClick(TObject *Sender);
  void __fastcall AutoStopBtnClick(TObject *Sender);
  void __fastcall AutoInspectionResultGridSelectCell(TObject *Sender,
          int ACol, int ARow, bool &CanSelect);
  void __fastcall TrackBar1Change(TObject *Sender);
  void __fastcall UpDown8Click(TObject *Sender, TUDBtnType Button);
  void __fastcall TrackBar2Change(TObject *Sender);
  void __fastcall Button2Click(TObject *Sender);
  void __fastcall Button3Click(TObject *Sender);
  void __fastcall histoImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall Button4Click(TObject *Sender);
  void __fastcall TrackBar3Change(TObject *Sender);
  void __fastcall Button5Click(TObject *Sender);
  void __fastcall TrackBar4Change(TObject *Sender);
  void __fastcall Button6Click(TObject *Sender);
  void __fastcall UpDown12Click(TObject *Sender, TUDBtnType Button);
  void __fastcall UpDown15Click(TObject *Sender, TUDBtnType Button);
  void __fastcall Button7Click(TObject *Sender);
  void __fastcall Button8Click(TObject *Sender);
  void __fastcall DebugData1DblClick(TObject *Sender);
  void __fastcall Image11MouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall TrackBar5Change(TObject *Sender);
  void __fastcall Button9Click(TObject *Sender);
  void __fastcall Button10Click(TObject *Sender);
  void __fastcall UpDown6Click(TObject *Sender, TUDBtnType Button);
  void __fastcall TntUpDown1Click(TObject *Sender, TUDBtnType Button);
  void __fastcall BitBtn1Click(TObject *Sender);
  void __fastcall TntUpDown2Click(TObject *Sender, TUDBtnType Button);
  void __fastcall Button12Click(TObject *Sender);
  void __fastcall TrackBar7Change(TObject *Sender);
  void __fastcall TrackBar8Change(TObject *Sender);
  void __fastcall Button17Click(TObject *Sender);
  void __fastcall RealThreeDImageMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall Button13Click(TObject *Sender);
  void __fastcall Disk1RotationAngle1Click(TObject *Sender,
          TUDBtnType Button);
  void __fastcall ThreeDDebug_RotationImageMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall ThreeDImageUpdownClick(TObject *Sender, TUDBtnType Button);
  void __fastcall TrackBar9Change(TObject *Sender);
  void __fastcall Button14Click(TObject *Sender);
  void __fastcall TrackBar10Change(TObject *Sender);
  void __fastcall RealThreeDImageDblClick(TObject *Sender);
  void __fastcall ModelingTestImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall TrackBar11Change(TObject *Sender);
  void __fastcall SugarCoatingTestImageMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall Button15Click(TObject *Sender);
  void __fastcall TrackBar12Change(TObject *Sender);
  void __fastcall TrackBar13Change(TObject *Sender);
  void __fastcall UpDown16Click(TObject *Sender, TUDBtnType Button);
  void __fastcall UpDown11Click(TObject *Sender, TUDBtnType Button);
  void __fastcall TntButton1Click(TObject *Sender);
	void __fastcall TntButton2Click(TObject *Sender);
	void __fastcall SpeedCheckPanelCloseButtonClick(TObject *Sender);
private:	// User declarations
	  int ImageHeight;
	  int ImageWidth;
    int ImageCount;
    int InspectionFlag;

    int AvgHeight;
    int AvgHeightCnt;

    int xAngle;
    int yAngle;

    bool bStop;

    int SelectedCameraIndex;

    short shiftInfoArray_PC[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT][3];
    
    int print1MatchingCount;
    int print2MatchingCount;
    unsigned char print1MatchingData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
    unsigned char print2MatchingData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

    unsigned char PCBackgroundImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
    short PCColorRateImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
    unsigned char PCRGBFactorArrayBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

    TSideData tempSideData[SYSTEM_TOTAL_CAMERA_COUNT - 4];
    TSideSmallSizeData SmallSizeSideData[SIDE_ANGLE_TOTAL_COUNT];

    unsigned char OutlineData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
    unsigned short bottomLine[2000][2];
    int bottomLineCount;

    unsigned int testBackgroundImage[SYSTEM_TOTAL_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
    int stdCount[SYSTEM_TOTAL_CAMERA_COUNT];

    int objStartNum[SYSTEM_TOTAL_CAMERA_COUNT];
    int objEndNum[SYSTEM_TOTAL_CAMERA_COUNT];

    unsigned char smallBinaryImage[(MAX_IMAGE_WIDTH / 2) * (MAX_IMAGE_HEIGHT / 2)];
    short HalfLabelImage[(MAX_IMAGE_WIDTH / 2) * (MAX_IMAGE_HEIGHT / 2)];

  double timeDoubleArray[100];
  int imgCntForAvg;
  double timeDoubleMin;
  double timeDoubleMax;
  double timeDoubleAvg;

    bool __fastcall SaveBMPImage(int imageIndex, int cameraIndex, bool bThreeD);

    void __fastcall ImageLoad(int imageIndex, int cameraIndex, int mode);
    bool __fastcall ReadSetupData(TTabletSetupData *tabletSetupData);
    bool __fastcall ReadStudyData(TTabletStudyData *tabletStudyData);
    bool __fastcall Read3DSetupData(TTablet3DSetupData *tablet3DSetupData);

    void __fastcall DoProcessing(int imageIndex, int cameraIndex, int mode);
    void __fastcall DoProcessingFor3D(int imageIndex, int cameraIndex, int mode);
    void __fastcall ProcessingResultDisplay(int cameraIndex);

    void __fastcall MakeRotationTabletShapeData();
    void __fastcall LoadFrontFaceDebugData();
    void __fastcall LoadSideFaceDebugData();
    void __fastcall tSideFaceSetUpDataTransForm();
    void __fastcall ImageRotation(int cameraIndex);
    int __fastcall LabellingForTabletImage(short *label_Image, unsigned char *smallSizeBinaryImage, int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);
    void __fastcall AccPrintMachingData();
    void __fastcall threeDRotation_PC(unsigned char *srcImage, int xyR, int xzR, int yzR);
    void __fastcall threeDRotation2(unsigned char *srcImage, int xyR, int xzR, int yzR);

    void __fastcall LoadFrontFace3DDebugData();
    void __fastcall Load3DPositionInfo();

    void  __fastcall SideFaceShapeMatchingForETC(int cameraIndex);

    TColor __fastcall ThreeDDepth(int srcValue, int maxValue);
	void _fastcall SpeedCheckDisplay(int cameraIndex);    

    bool bMakeMatchingData;
public:		// User declarations
    __fastcall TTabletSimulationForm(TComponent* Owner);

    unsigned char ColorSourceDefectImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT * 3];
    int GlobalCameraIndexForDefectImage;
};
//---------------------------------------------------------------------------
extern PACKAGE TTabletSimulationForm *TabletSimulationForm;
void MakeINVMatrix(double *input[], double *output[], int size);
//---------------------------------------------------------------------------
#endif
