#ifndef __cpb_module_h__
#define __cpb_module_h__

#include "Processing.h"

#ifdef PC_SIM
	#include "time.h"
#endif

#include <string.h>
#include <stdlib.h>

#define STUDY_MODE        1
#define INSPECTION_MODE   2
#define FIRST_STUDY_MODE  3

#define SMALL_WIDTH 160
#define SMALL_HEIGHT 120

#define THREE_D_CAMERA_ZOOM 40

#define SIDE_FACE_DIVISION_LINE_DATA_COUNT  400
#define SIDE_FACE_ROTATION_LINE_DATA_COUNT  600

#define CASE1    1
#define CASE2    2
#define CASE3    3
#define CASE4    4
#define CASE5    5

#define FIRST  1
#define SECOND  2

#define SHAPE_MATCHING_RANGE 8
#define SHAPE_SHELL_DEPTH 50

#define ACCEPTABLE_ROTATION_RANGE 17
#define ACCEPTABLE_ROTATION  20.0

#define PI    3.141592

#define FRONT_FACE            1
#define SIDE_FACE_M45         2
#define SIDE_FACE_0           3
#define SIDE_FACE_P45         4
#define FRONT_FACE_SPECIAL    5
#define FRONT_FACE_3D 6
#define REAR_FACE 7
#define SIDE_FACE_ALL 8

#define MAX_ANGLE1_RANGE 28
#define MAX_ANGLE2_RANGE 16
#define MAX_ANGLE3_RANGE 20


#define MAX_SIDE_WALL_ROT_RANGE 70

#define SIDE_FACE_ROTATION_ANGLE 5

#define MAX_ANGLE1_RANGE_ETC 5
#define MAX_ANGLE2_RANGE_ETC 4

#define NORMAL_INPECTION_AREA                 1
#define FRONT_SHAPE_EDGE_NEIGHBOR             2
#define FRONT_SHAPE_EDGE                      3
#define PRINT_AREA                            4
#define PRINT_NEIGHBOR_SHORT                  5
#define PRINT_NEIGHBOR_LONG                   6
#define FRONT_SHAPE_EDGE_AND_PRINT_SHORT      7
#define FRONT_SHAPE_EDGE_AND_PRINT_LONG       8
#define FRONT_MASKING_AREA                    9
#define FRONT_FACE_SPLIT_AREA                 10
#define EXPANDED_PRINT_AREA                   11

#define FRONT_SHAPE_FST_SHELL_AREA  1
#define FRONT_SHAPE_SEC_SHELL_AREA  2
#define FRONT_SHAPE_TRD_SHELL_AREA  3
#define FRONT_SHAPE_4TH_SHELL_AREA  4

#define NORMAL_INPECTION_AREA2                              2
#define SIDE_SHAPE_UNINSPECTION_AREA                        3
#define SIDE_SHAPE_BOTTOM_EDGE_SHORT_NEIGHBOR               4
#define SIDE_SHAPE_BOTTOM_EDGE_LONG_NEIGHBOR                5
#define SIDE_SHAPE_TOP_EDGE_UPPER_NEIGHBOR                  6
#define SIDE_SHAPE_TOP_NORMAL_BOUNDARY_AREA                 7
#define SIDE_SHAPE_MULTI_TABLET_BOUNDARY_AREA               8

//////⺻ threshold////////////////////
#define SIDE_NORMAL_AREA_THRESH                 8
#define SIDE_EDGE_LONG_NEIGHBOR_THRESH          16
#define SIDE_EDGE_SHORT_NEIGHBOR_THRESH         24
#define SIDE_EDGE_DARK_THRESH                   6
#define SIDE_NORMAL_AREA_BRIGHT_THRESH          12
#define SIDE_TOP_EDGE_BRIGHT_THRESH             22
#define SIDE_BOTTOM_EDGE_BRIGHT_THRESH          15

#define SIDE_DIRTY_THRESH                       10
/////////////////////////////////////////////////////////
#define FORNT_NORMAL_INPECTION_AREA_BRIGHT_THRESH                 10
#define FORNT_NORMAL_INPECTION_AREA_THRESH                        4 // 8
#define FORNT_PRINT_NEIGHBOR_SHORT_THRESH                         16
#define FORNT_PRINT_NEIGHBOR_LONG_THRESH                          11
#define FORNT_SHAPE_EDGE_NEIGHBOR_THRESH                          7
#define FORNT_DIRTY_THRESH                                        16
#define FORNT_DIRTY_THRESH2                                       2
///////////////////////////////////////////////////
#define FORNT_FRONT_SHAPE_STICKING_NORMAL_AREA_THRESH           6
#define FORNT_FRONT_SHAPE_STICKING_PRINT_NEIGHBOR_SHORT_THRESH  12
#define FORNT_FRONT_SHAPE_STICKING_PRINT_NEIGHBOR_LONG_THRESH   8
/////////////////////////////////////////////////////////////
#define TOP_LEFT      -1282
#define TOP_MIDDLE    -1280
#define TOP_RIGHT     -1278
#define MIDDLE_LEFT   -2
#define MIDDLE_MIDDLE 0
#define MIDDLE_RIGHT  2
#define BOTTOM_LEFT   1278
#define BOTTOM_MIDDLE 1280
#define BOTTOM_RIGHT  1282

#define SIDE_CAMERA_ANGLE 40

#define FOR_PRINT_MATCHING  1
#define FOR_DEFECT 2

#define NOT_THREED  1
#define THREED      2

#define MAX_THREED_EDGE_POINT_COUNT 3000

#define MAX_LABEL_COUNT 2000
#define MAX_DEFECT_POINT_COUNT 10000

#define max(a, b) (a > b ? a : b)
#define min(a, b) (a < b ? a : b)
#define GRID_SIZE 20

#define MAX_IMAGE_PIXEL_COUNT MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT

#define I_QUADRANT      0
#define II_QUADRANT     1
#define III_QUADRANT    2
#define IV_QUADRANT     3

#define THREED_EDGE_XY_ROTATION_ANGLE 20
#define THREED_EDGE_YZ_ROTATION_ANGLE 16
#define THREED_EDGE_XZ_ROTATION_ANGLE 8

#define SMALL_SIZE_DEFECT_MAX_LABEL_N 10000

#define SIDE_ANGLE_TOTAL_COUNT 3

#define PLUS_45_ANGLE_CAM   0
#define ZERO_ANGLE_CAM      1
#define MINUS_45_ANGLE_CAM  2

#define MAX_TABLET_HEIGHT  200

#define FRONT_FACE_ROTATION_Z_ANGLE 20 // x2
#define FRONT_FACE_ROTATION_X_ANGLE 30 // x2

#define DIRECTION_TOP_TILT      0
#define DIRECTION_BOTTOM_TILT   1

#define MAX_INBOARD_PROCESSING_CAMERA_COUNT 3

#define AREA_INFO_ST_X_ADDRESS      0
#define AREA_INFO_END_X_ADDRESS     1
#define AREA_INFO_ST_Y_ADDRESS      2
#define AREA_INFO_END_Y_ADDRESS     3

#define MAX_RADIAL                40
#define MAX_RADIAL_CASE_COUNT     MAX_RADIAL / 8
#define MAX_ROUND_LENGTH          (2 * MAX_RADIAL * 3 * 130) / 100

#define MAX_SHAPE_RADIAL  600

#ifdef TARGET_CPB
#define RESTRICT(pointer) restrict pointer			// ̰ ޸𸮰 ٸ ޸𸮿 ġ ʴ´ٴ  ִ Ű̴. Ϸ ȭ  ش.
#define RESTRICT_ARRAY(pointer) pointer[restrict]	//   迭 ̴.
#else
#define RESTRICT(pointer) pointer					//  C++ Builder 6 restrict Ű尡  д.
#define RESTRICT_ARRAY(pointer) pointer[]
#endif

#ifdef PC_SIM
#define THREAD_VARIABLE __declspec(thread)			// 帶   ϴ ۷ι  . PC Ƽ带  ۷ι   ʵ ϴ 뵵.
#else
#define THREAD_VARIABLE
#endif

typedef struct
{
    short Transform_position_printData[PRINT_DATA_SIZE][2];
    int printDataCount;
}TTransform_printData;

typedef struct
{
    int PrintBrightness;
    int theta;
    int x;
    int y;
}TPrintMarkingInformation;

typedef struct
{
    unsigned short SideShapeEdgePointLeft[MAX_TABLET_HEIGHT*2];
    unsigned short SideShapeEdgePointRight[MAX_TABLET_HEIGHT*2];
    unsigned short SideShapeEdgePointBottom[480*2];

    unsigned short SideShapeEdgePointCountLeft;
    unsigned short SideShapeEdgePointCountRight;
    unsigned short SideShapeEdgePointCountBottom;
    unsigned short startX1, startY1, endX1, endY1;
    unsigned short startX2, startY2, endX2, endY2;
    unsigned short start_Number, end_Number;

    unsigned short ShapeEndY;

    short shiftTopLineX[MAX_TABLET_HEIGHT];
    short shiftTopLineY[MAX_TABLET_HEIGHT];
}TSideShapeData;

typedef struct
{
    unsigned short SideWallPxData[360*2];
    unsigned short SideWallPxDataCount;
}TSideWallData;

typedef union
{
    TSideShapeData SideShapeData[MAX_ANGLE2_RANGE*2+1][MAX_ANGLE1_RANGE*2+1];
}TSideData;

typedef union
{ 
    TSideWallData SideWallData[MAX_SIDE_WALL_ROT_RANGE*2+1];
}TSideWallMatchingData;

extern TSideWallMatchingData SideWallMatchingData;

#ifdef TARGET_CPB
extern TSideData SideData[SIDE_ANGLE_TOTAL_COUNT];
#else
extern TSideData *SideData;
#endif


typedef struct
{
    int dataNumberWithMaxValue;
    int PrintRotationAngle;
    int PrintShiftX;
    int PrintShiftY;

    int SplitRotationAngle;
    int SplitShiftX;
    int SplitShiftY;

}TPrintMatchingResult;

typedef struct
{
    int AdjustCenterXInImage;
    int AdjustCenterYInImage;
    int TabletSideShapeShiftX;
    int TabletSideShapeShiftY;
    int TabletSideShapeTopLineShiftX;
    int TabletSideShapeTopLineShiftY;
    int TabletSideShapeXTotion;
    int TabletSideShapeYTotion;
    int TabletSideShapeZTotion;
    int TabletFrontShapeXTotion;
    int TabletFrontShapeYTotion;
    int TabletRotationAngle;
    int SearchStartXForSideShape;
    int SearchEndXForSideShape;
    int SideShapeStartX;
    int SideShapeEndX;
    int SideShapeEndY;
    int PrintCenterX;
    int PrintCenterY;
    int TalbletTopFaceRotation;
    int StXForSideShapeImage;
    int EndXForSideShapeImage;
    int AdjustResolution;

}TTabletMatchingResult;

typedef struct
{
  int topLeftWallInfo[2];
  int botLeftWallInfo[2];
  int topRightWallInfo[2];
  int botRightWallInfo[2];

  short tabletShapeTopLine[MAX_IMAGE_WIDTH * 2];
  int tabletShapeTopLineCount;
  short tabletShapeBottomLine[MAX_IMAGE_WIDTH * 2];
  int tabletShapeBottomLineCount;
  short tabletShapeLeftLine[MAX_IMAGE_HEIGHT * 2];
  int tabletShapeLeftLineCount;
  short tabletShapeRightLine[MAX_IMAGE_HEIGHT * 2];
  int tabletShapeRightLineCount;

  int tabletShapeTopLineMinX;
  int tabletShapeTopLineMinY;
  int tabletShapeBottomLineMinX;
  int tabletShapeBottomLineMinY;

  int tabletCenterX;
  int tabletCenterY;
}TTabletETCMatchingResult;

typedef struct
{
    int px;
    int py;
    int pz;
}TThreeDPoint;

extern int ProtoEngraveDistinguishV_Cam1;
extern int ProtoEngraveDistinguishV_Cam9;
extern int BlurredEngraveSW;

extern int ThreeDRealCenterX, ThreeDRealCenterY, ThreeDRealLength;

extern int TabletSlopeInfoStartPoint[2];
extern int TabletSlopeInfoEndPoint[2];

extern short SideShapeEdgeMatchingPointTop[MAX_IMAGE_WIDTH * 2];
extern short SideShapeEdgeMatchingPointBottom[MAX_IMAGE_WIDTH * 2];
extern int SideShapeEdgeMatchingPointTopCount;
extern int SideShapeEdgeMatchingPointBottomCount;

extern int MeanOneColor;

extern int selectedRGB;
extern int SetupDataPrint1CenterXFor2D;
extern int SetupDataPrint1CenterYFor2D;
extern int SetupDataPrint2CenterXFor2D;
extern int SetupDataPrint2CenterYFor2D;

extern int ProtoTabletCenterX;
extern int ProtoTabletCenterY;
extern int ProtoTabletCenterZ;

extern int AdjustTabletCenterX;
extern int AdjustTabletCenterY;
extern int AdjustTabletCenterZ;

extern int GlobalTabletRotationXZAngle;
extern int GlobalTabletRotationYZAngle;

extern int ExecutiveSearchingRotationAngle;
extern int ProtoTabletRotationAngle;
extern int AdjustTabletCenterInfo[2];

extern int ETCShape_ForwardProtoRotationAngle;
extern int ETCShape_ReverseProtoRotationAngle;

extern int SelectedFace;
extern int ImageWidth;
extern int ImageHeight;
extern int Max3DHeight;
extern int Center3DHeight;
extern unsigned char  ThickErrorSW;

extern int EdgeLineCountForThreeDImage;
extern int TabletAreaSize;

extern int dummyCounter;

extern int ProcessingModeGlobal;
extern int Camera1RecordedColorCount_Of_InspectionProcess;
extern int Camera9RecordedColorCount_Of_InspectionProcess;

extern int tabletETCShape_UpSideDownSW;

extern int OnePrintIncludeOtherPrintSWFor2D;
extern int OnePrintIncludeOtherPrintSWFor3D;
extern int TheOhterSideShapeMatchingSW;

extern int arcCosTable[20001];
extern unsigned int sqrtTable[MAX_SHAPE_RADIAL * MAX_SHAPE_RADIAL];
extern int sinTable[361];
extern int cosTable[361];
extern int CosData[720];              //3k
extern int SinData[720];              //3k
extern unsigned int SqrtData[9*10000];

extern short PixelNInShapeSideEdge[MAX_LABEL_COUNT];
extern short PixelNInShapeSideNormal[MAX_LABEL_COUNT];
extern short PixelNInShapeEdgeNeighbor[MAX_LABEL_COUNT]; //4k
extern unsigned short Pixel_N_Of_Label[MAX_LABEL_COUNT]; //4k
extern short StartX_Label[MAX_LABEL_COUNT]; //4k
extern short EndX_Label[MAX_LABEL_COUNT]; //4k
extern short StartY_Label[MAX_LABEL_COUNT]; //4k
extern short EndY_Label[MAX_LABEL_COUNT]; //4k

extern short Pixel_N_Of_MoreDarkOfLabel[MAX_LABEL_COUNT];//4k
extern short Position_SmallPrintData1[3000][2]; //12k
extern short Position_SmallPrintData2[3000][2]; //12k

extern short Position_SmallPrintCoreData1[3000][2]; //12k
extern short Position_SmallPrintCoreData2[3000][2]; //12k

extern int corePrintDataAddStepForCam5;
extern int corePrintDataAddStepForCam13;

extern int globalPrintSelectedRGB;

extern TPrintMarkingInformation PrintMarkingInformation;

extern unsigned short EdgeLineForThreeDImage[MAX_THREED_EDGE_POINT_COUNT][3];

extern unsigned char PrintLabelArea[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern int PrintLabelAvgColor[THREED_PRINT_MAX_LABEL_COUNT];
extern short tempPosition_printData[PRINT_DATA_SIZE][2];

extern int tabletAreaInfo[20];

extern int sideFacePreProcessingAngleX;
extern int sideFacePreProcessingAngleZ;
extern int sideFacePreProcessingShiftX;
extern int sideFacePreProcessingShiftY;

#ifdef PC_SIM
extern unsigned char BayerImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT * 3];
#else
extern unsigned char BayerImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT];
#endif

extern unsigned char smallSizeBinaryImage[(MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4)];		  // 19k
extern unsigned char smallSizeShrinkBinaryImage[(MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4)]; // 19k
extern short smallSizeLabelImage[(MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4)];				  // 38k
extern unsigned char smallSizeOneColorImage[(MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4)];	  // 19k
extern unsigned char smallSizeGradientImage[(MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4)];	  // 19k

#ifdef PC_SIM
extern int PrintStateForDebug;
extern int labelCount;
extern int PrintMatchingDiff;
#endif

extern unsigned char ColorSourceImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT * 3];
extern unsigned char tempColorSourceImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT * 3];

extern unsigned char SideFaceBreakCheckArea[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char SideEdgeMaskingArea[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

extern unsigned char GradientImage[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];      //300k
extern unsigned char OneColorImage[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char MeanOneColorImage[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char BrightPixelNeighborPrint[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char DarkPixelNeighborPrint[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char DarkPixelNeighborPrint2[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char ExtractedSplitLineImage[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern TTabletSetupData TabletSetupData;                   // 1M
extern TWhiteBalanceInfo WhiteBalanceInfo[SYSTEM_TOTAL_CAMERA_COUNT]; 

extern TTablet3DSetupData Tablet3DSetupData;
extern TDefectInformation DefectInformation;                   // 1M
extern TThreeDPositionInfo ThreeDPositionInfo_CPB;
extern unsigned char InspectionArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];      //300k
extern unsigned char realPrintMaskingArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char ShapeBinaryImage[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern short ShapeShellGrayLebel[SHAPE_SHELL_DEPTH][360]; //Length-Anlge
extern short ShapeShellData[SHAPE_SHELL_DEPTH][2000][3];
extern short ShapeShellDataCount[SHAPE_SHELL_DEPTH];

extern short ArcSinData[10001];
extern short ArcSinData2[10001];

extern unsigned char HalfShapeData[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT/4];
extern unsigned char PrintIsSW;
extern unsigned char Front_Rear;
extern unsigned char CorePrint1Weight[3000];
extern unsigned char CorePrint2Weight[3000];

extern unsigned char colorMaskingArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char tShellInspectionArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char TempImage2[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char TempImage3[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char TempImage4[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];

extern unsigned char noneGradientArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern int limitBinaryAreaInfo[MAX_IMAGE_WIDTH];
extern unsigned char realBinaryArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern short ColorRateImageSrcArr[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];

extern unsigned char RotationThreeDImage[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char *ExpectedThreeDDefectArea;
extern unsigned char *threeDShellImage;

extern unsigned char *ThreeDOutlineImage;

extern unsigned char DentedArea[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];
extern unsigned char tempDentedArea[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];
extern unsigned char ThreeDPrintPartialCheckArea[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];

extern unsigned char AdjustThreeD_Data[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];
extern unsigned char PlanariztionThreeDEdgeImage[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT];
extern unsigned char ThreeD_Data[HALF_MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];  //900k
extern unsigned char ThreeD_Image[IMAGE_3D_WIDTH*MAX_IMAGE_HEIGHT];  //900k
extern unsigned char TempImage[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];            //300k
extern unsigned char HalfTempImage[(MAX_IMAGE_WIDTH/2)*(MAX_IMAGE_HEIGHT/2)];
extern unsigned char HalfExtendShapeBinaryImage[(MAX_IMAGE_WIDTH/2)*(MAX_IMAGE_HEIGHT/2)];
extern unsigned char HalfGradientImage[(MAX_IMAGE_WIDTH/2)*(MAX_IMAGE_HEIGHT/2)];
extern unsigned char HalfShapeBinaryImage[(MAX_IMAGE_WIDTH/2)*(MAX_IMAGE_HEIGHT/2)];
extern unsigned char HalfShrinkShapeBinaryImage[(MAX_IMAGE_WIDTH/2)*(MAX_IMAGE_HEIGHT/2)];
extern short HalfLabelImage[(MAX_IMAGE_WIDTH/2)*(MAX_IMAGE_HEIGHT/2)];
extern unsigned char ShapeBinaryImageForPrintArea[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];    //300k

extern unsigned short outlineSectionInfo[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];  //900k
extern short  RotationEdgeImage[MAX_IMAGE_WIDTH*MAX_IMAGE_WIDTH];        //600k

extern int CurrentPrintType;

extern short ThreeDRotationShiftArray[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT][2];

extern unsigned char ProtoShapeArea[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];
extern unsigned char NormalizedThreeDImage[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];

extern int GlobalPrintColor[3];

extern int DefectSW;

extern TTabletMatchingResult TabletMatchingResult;
extern TTabletETCMatchingResult TabletETCMatchingResult;
extern TTabletCharacter TabletCharacter;
extern TTabletStudyData TabletStudyData;
extern TTabletGradeData TabletGradeData;
extern TPrintMatchingResult PrintMatchingResult;

extern int MeanColorR;
extern int MeanColorG;
extern int MeanColorB;

extern int SmallPrintData1Count;
extern int SmallPrintData2Count;

extern int SmallPrintCoreData1Count;
extern int SmallPrintCoreData2Count;

extern int SmallPrintCoreData1CountFor3D;
extern int SmallPrintCoreData2CountFor3D;

extern int SmallSplitLineDataCount;
extern short SmallSplitLineData[2000][2];

extern THREAD_VARIABLE unsigned int AddressTable[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];
extern THREAD_VARIABLE unsigned short shiftInfoArray[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT][3];
extern unsigned char ThreeDEraseArea[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];
extern unsigned char TabletShapeData[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];

extern int TabletShapeMinX, TabletShapeMaxX;
extern int TabletShapeMinY, TabletShapeMaxY;

extern int MeanColorRForNormal1;
extern int MeanColorGForNormal1;
extern int MeanColorBForNormal1;

extern int MeanColorRForNormal2;
extern int MeanColorGForNormal2;
extern int MeanColorBForNormal2;

extern int threeDshapeMinX, threeDshapeMaxX;

extern int detailedCorePrintRotationAddress1[720][1500];
extern int detailedCorePrintRotationAddress2[720][1500];

extern int detailedSplitLineRotationAddress[720][2000];

extern int detailedCorePrintRotationAddress1For3D[720][2500];
extern int detailedCorePrintRotationAddress2For3D[720][2500];

extern char ThreeDSplitLineData1[2500];
extern char ThreeDSplitLineData2[2500];

extern int ThreeDSplitLineLabel[2][2][THREED_PRINT_MAX_LABEL_COUNT];

extern int labelingPxCount[SMALL_SIZE_DEFECT_MAX_LABEL_N];
extern int LabelStX[SMALL_SIZE_DEFECT_MAX_LABEL_N];
extern int LabelStY[SMALL_SIZE_DEFECT_MAX_LABEL_N];
extern int LabelEdX[SMALL_SIZE_DEFECT_MAX_LABEL_N];
extern int LabelEdY[SMALL_SIZE_DEFECT_MAX_LABEL_N];

extern TSideShapeData finalMatchingShapeData;

extern int tempShiftTopLine[520];

extern unsigned short SideFaceDivisionLineData[180][SIDE_FACE_DIVISION_LINE_DATA_COUNT * 2];
extern int SideFaceDivisionLineDataCount;

extern short LabelImageHighResolution[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT];
extern unsigned char OneColorImageHighResolution[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT];

extern int globalFrontFaceSplitLineMatchingSW;

extern short globalTabletSplitLineData[PRINT_DATA_SIZE][2];
extern int globalTabletSplitLineDataCount;

#ifdef PC_SIM
extern unsigned char InspectionArea_Virtual[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];
extern unsigned char GradientImageForFstStudy[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char *currentBackgroundImage;

extern unsigned char Debug_RealThreeD_Image[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char Debug_LabelingImage[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char Debug_ProtoShapeArea[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];
extern unsigned char Debug_NormalizedThreeDImage[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];
extern unsigned char Debug_OvelapRemoveResult[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char Debug_SatAreaImage[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
extern unsigned char Debug_BeforeRotationResult[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

#endif
extern short LabelImage_Virtual[MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT];

// COMMON
void DataInitiate(int option, int cameraIndex);
int DefectLabeling(short *RESTRICT(label_Image), short *RESTRICT(defectPointData), int defectPointDataCnt, int cameraIndex);
void ColorChange(int cameraIndex, int ImageConvertOption);
void ColorCountClear_Func(void);
void DefectInformationWrite(int defectSeries, int cameraIndex, int defectStartX, int defectEndX, int defectStartY, int defectEndY, int size);
int LabellingForTabletImage(short *RESTRICT(label_Image), unsigned char *RESTRICT(smallSizeBinaryImage), int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);
int ColorDotLabeling(short *RESTRICT(label_Image), short *RESTRICT(defectPointData), int defectPointDataCnt, int cameraIndex);
int SmallSizePixelLabeling(unsigned char *RESTRICT(srcImage), short *RESTRICT(dstLabelImage), int startX, int endX, int startY, int endY, int imageWidth);
void CheckPrintMatchingResult(int bThreeD);
void CPBCommonVariableInitial();
void ApplyWhiteBalance(unsigned char *RESTRICT(srcImage), int startX, int endX, int startY, int endY, int imageWidth, TWhiteBalanceInfo *RESTRICT(pWhiteBalance));
int GetGlobalCameraIndex(int spbIndex, int SideAngle);
//void Erode(unsigned char *RESTRICT(srcImage), unsigned char *RESTRICT(dstImage), int startX, int endX, int startY, int endY, int maskSize);
//void Dilate(unsigned char *RESTRICT(srcImage), unsigned char *RESTRICT(dstImage), int startX, int endX, int startY, int endY, int maskSize);
int PrintLabeling(unsigned char *RESTRICT(srcImage), short *RESTRICT(dstLabelImage), int startX, int endX, int startY, int endY);

void ImageFlipX(unsigned char *RESTRICT(colorSourceImage), unsigned char *RESTRICT(bayerImage), int startX, int endX, int startY, int endY, int currentImageWidth, int currentImageHeight);
void ImageFlipY(unsigned char *RESTRICT(colorSourceImage), unsigned char *RESTRICT(bayerImage), int startX, int endX, int startY, int endY, int currentImageWidth, int currentImageHeight);
//void ImageFlipXY(unsigned char *RESTRICT(colorSourceImage), unsigned char *RESTRICT(bayerImage), int startX, int endX, int startY, int endY, int currentImageWidth, int currentImageHeight);
void ImageFlipNone(unsigned char *RESTRICT(colorSourceImage), unsigned char *RESTRICT(bayerImage), int startX, int endX, int startY, int endY, int currentImageWidth, int currentImageHeight);

//TPB
void ProcessingStartForTPBImage(int TabletWidth, int TabletHeight, int WhiteBalanceB, int WhiteBalanceG, int WhiteBalanceR, int InsAreaLeft, int InsAreaRight, int InsAreaTop, int InsAreaBottom, int Threshold);
void ColorChangeForTPB(int WhiteBalanceB, int WhiteBalanceG, int WhiteBalanceR);
void InspectionTPBImage(int TabletWidth, int TabletHeight, int InsAreaLeft, int InsAreaRight, int InsAreaTop, int InsAreaBottom, int Threshold);

// 2D Utils
void LineDataDialation(short *RESTRICT(src), short *RESTRICT(dst), int size, int step, int srcSize);
void LineDataErosion(short *RESTRICT(src), short *RESTRICT(dst), int size, int step, int srcSize);

// 3D Utils
void Make_ThreeD_Data_From_Src(int cameraIndex, int copyToImage);
void SetThreeDSourceImage(int cameraIndex, int option);
void threeDRotation(unsigned char *RESTRICT(threeDEraseArea), unsigned char *RESTRICT(halfRotationThreeDImage), unsigned int *RESTRICT(addressTable), unsigned short RESTRICT_ARRAY(shiftInfoArray)[3], unsigned char *RESTRICT(srcImage), int xzR, int yzR, int centerX, int centerY, int centerZ, int startX, int endX, int startY, int endY);

//---------------------------------------------------------------------------
#include "CPB_Module_Front.h"
#include "CPB_Module_Front_3D.h"
#include "CPB_Module_Side.h"
#include "PrintMatching.h"
#include "PrintMatching3D.h"
#include "DentedExtract.h"
#include "SideFaceShapeMatching.h"
//---------------------------------------------------------------------------
#ifdef PC_SIM
extern void __fastcall WriteCheckBeginTime(); //  ڵ  μ Ÿ ϱ  Լ. GetCheckElapsedTime()    ִ.
extern void __fastcall WriteCheckEndTime();
#endif
//---------------------------------------------------------------------------

#endif	/* __cpb_module_h__ */


