#ifdef PC_SIM
#include <mem.h>
#endif
#ifdef TARGET_PC
#include <mem.h>
#endif
#include <math.h>
#include "CPB_Module_Front.h"

//---------------------------------------------------------------------------
int globalPositionErrorSuspectedTablet;

#pragma DATA_ALIGN(8)
#pragma DATA_SECTION(".sdram")
short transformFrontShapeEdgePoint[2000][2];

#pragma DATA_ALIGN(8)
#pragma DATA_SECTION(".sdram")
unsigned char ShapeShellCountGrayLebel[SHAPE_SHELL_DEPTH][360];

#pragma DATA_ALIGN(8)
int shellAvgColor[4];

int shapeSetupDataCountDisk1;
int shapeSetupDataCountDisk2;

//---------------------------------------------------------------------------
void ProcessingStartForFrontFace(int processingMode, int cameraIndex, int ImageConvertOption)
{
	GlobalPrintColor[0] = GlobalPrintColor[1] = GlobalPrintColor[2] = 0;

	globalFrontFaceSplitLineMatchingSW = 0;
	PrintIsSW = 0;
	DefectSW = 0;
	PrintMatchingResult.dataNumberWithMaxValue = -1; // ʱⰪ
	globalPositionErrorSuspectedTablet = 0;
	memset(&PrintMarkingInformation, 0, sizeof(TPrintMarkingInformation));

	ProcessingModeGlobal = processingMode;

	DataInitiate(NOT_THREED, cameraIndex);

	ColorChange(cameraIndex, ImageConvertOption); // ̰ 5.6ms  ҿȴ.

	PreProcessingForFrontFace(cameraIndex); // ̰ 2.6ms ҿ.  PC 6.8ms  ҿ. ()

	if (DefectSW == 0)
	{
		if (TabletCharacter.shape == ROUND)
		{
			FrontFaceShapeMatchingForEachCase(CASE1, cameraIndex);
		}
		else
		{
			FrontFaceShapeMatchingForEachCase(CASE2, cameraIndex); // PC 5.5ms  ҿ.
		}

		if (TabletCharacter.discriminationDisplay_kind != NONE) 
		{
			if (processingMode != INSPECTION_MODE || TabletGradeData.EngravePrintMatching2DInActive == 0)
			{
				PrintMatching(cameraIndex); // PC 12ms  ҿ.   ð ҿȴ.
			}
		}


		if (processingMode == INSPECTION_MODE && DefectSW == 0)
		{
			if (!TabletCharacter.MarvelingTablet &&
				TabletCharacter.kind != SUGARCOATING &&
				TabletCharacter.discriminationDisplay_kind == PRINT &&
				TabletCharacter.tabletDivisionLineInfo)
			{
				if (TabletGradeData.SplitLineMatchingSWForPrintTablet)
				{
					// ҼĪ
					ExtractFrontFaceSplitLine(cameraIndex);
					FrontFaceSplitLineMatching(cameraIndex);
				}
			}
		}

		if (TabletCharacter.tabletColorN == ONECOLOR)
			DefectColor(processingMode, cameraIndex); // 0.1ms ̳.
		else
			DefectColorForMuliLayerTablet(processingMode, cameraIndex);

		if (processingMode == INSPECTION_MODE && DefectSW == 0)
		{
			CalculateShapeShellData(cameraIndex);
			SetBrightnessAreaForPrintNeighbor(cameraIndex); // CalculateShapeShellData() ļ 2ms ̳.

			if (!TabletCharacter.MarvelingTablet) // Ϲ
			{
				DefectSearchInEdgeNeighborArea(); // 1ms ҿ.

				if (TabletGradeData.ETC_RemoveBrightDotSW)
					removeBrightDot(cameraIndex);

				if (!DefectSW)
				{
					if (TabletCharacter.kind != SUGARCOATING)
					{
						if (TabletCharacter.HighResolutionImage)
						{
							HighResolutionDefectSearchForFrontShape(cameraIndex);
						}
						else
						{
							DefectSearchForFrontShape(cameraIndex); // PC 6ms  ҿȴ.
						}
					}
					else
					{
						DefectSearchForFrontShapeForSugarCoating(cameraIndex); // ̰ DefectSearchForFrontShape()  ӵ̴.
					}
				}

				if (processingMode == INSPECTION_MODE && DefectSW <= 1 && TabletCharacter.kind != SUGARCOATING)
					DefectSearchForColorDirty(cameraIndex); // 1ms ̳ ҿ.
				else if (processingMode == INSPECTION_MODE && DefectSW <= 1 && TabletCharacter.kind == SUGARCOATING)
					DefectSearchForColorDirtyForSugarCoating(cameraIndex);
			}
			else
			{
				makeFrontFaceInspectionAreaForMarvelingTablet(cameraIndex); // PC 0.27ms  ҿȴ.

				if (!DefectSW)
					DefectSearchForMarvelingTablet(cameraIndex); // PC 20ms  ҿȴ.

				/*
				// 2021-07-13
				// ޸   Ƶ
				// ñ ࿡ ۿ  ʴµ, ü  ǰ  ҷ  Ȯ   ʴ´ٰ
						if (!DefectSW && TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm)
							ColorStainCheck(cameraIndex);
				*/
			}			
		}
	}

	if (TabletCharacter.discriminationDisplay_kind == STAMP)
	{
		if ((processingMode == INSPECTION_MODE && TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm && DefectSW == 0) || processingMode == STUDY_MODE)
		{
			if (DefectSW < 2)
			{
				if (TabletCharacter.discriminationDisplay_num == ONE_FACE || TabletCharacter.discriminationDisplay_num == TWO_FACE_SAME)
				{
					if (PrintMatchingResult.dataNumberWithMaxValue > -1 && PrintMatchingResult.dataNumberWithMaxValue < 2)
					{
						EngraveWhiteDefectCheck(cameraIndex);
					}
				}
				else // diff
				{
					if (PrintMatchingResult.dataNumberWithMaxValue > -1)
					{
						EngraveWhiteDefectCheck(cameraIndex);
					}
				}
			}
		}
	}

	CheckPrintMatchingResult(NOT_THREED);

	if (processingMode == INSPECTION_MODE)
	{
		if (TabletCharacter.discriminationDisplay_kind == PRINT)
		{
			if (PrintIsSW)
			{
				PrintPositionDefectCheck(cameraIndex);
			}
		}
	}

#ifdef PC_SIM
	memcpy(InspectionArea_Virtual, InspectionArea, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
}
//---------------------------------------------------------------------------
void FrontFaceSetUpDataTransForm(int option, int sdNum)
{
	int m, x, y, n;
	int tempCountPrint[4];
	int tempX, tempY;
	int tempAddress;
	int rotateX;
	int rotateY;
	int addStep;
	int r;

	// 2018-02-09
	// CPBҴ  ǵ ϴ  Resolution  ī޶󸶴  ٸ Ͽ   ߻  
	// ̹ SELMA100 ...(鿡 PC CPB ˻  ٸ  ̰ ΰʹ)
	// SELMA100 ߿ ϵ ϰ SELMA200  ٷ RES  Ѵ.
	const int FrontFaceCamera1Resolution = 410;
	const int FrontFaceCamera9Resolution = 410;
	const int SUCTION_DISK_1_NUM = SUCTION_DISK_NUM1;

	////// For 2D Front Face Camera Initial
	SetupDataPrint1CenterXFor2D = 0;
	SetupDataPrint1CenterYFor2D = 0;

	SetupDataPrint2CenterXFor2D = 0;
	SetupDataPrint2CenterYFor2D = 0;

	for (m = 0; m < TabletSetupData.printData1Count; m++)
	{
		SetupDataPrint1CenterXFor2D += TabletSetupData.position_printData1[m][0];
		SetupDataPrint1CenterYFor2D += TabletSetupData.position_printData1[m][1];
	}
	if (TabletSetupData.printData1Count)
	{
		SetupDataPrint1CenterXFor2D /= TabletSetupData.printData1Count;
		SetupDataPrint1CenterYFor2D /= TabletSetupData.printData1Count;
	}
	for (m = 0; m < TabletSetupData.printData2Count; m++)
	{
		SetupDataPrint2CenterXFor2D += TabletSetupData.position_printData2[m][0];
		SetupDataPrint2CenterYFor2D += TabletSetupData.position_printData2[m][1];
	}
	if (TabletSetupData.printData2Count)
	{
		SetupDataPrint2CenterXFor2D /= TabletSetupData.printData2Count;
		SetupDataPrint2CenterYFor2D /= TabletSetupData.printData2Count;
	}

	if (sdNum == SUCTION_DISK_1_NUM)
	{
		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			TabletSetupData.FrontShapeEdgePoint[m][0] = (TabletSetupData.FrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH;
			TabletSetupData.FrontShapeEdgePoint[m][1] = (TabletSetupData.FrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
		}
	}
	else
	{
		TabletSetupData.FrontShapeEdgePointCount = TabletSetupData.FrontShapeEdgePointCount2;
		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			TabletSetupData.FrontShapeEdgePoint[m][0] = (TabletSetupData.FrontShapeEdgePoint2[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH;
			TabletSetupData.FrontShapeEdgePoint[m][1] = (TabletSetupData.FrontShapeEdgePoint2[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
			TabletSetupData.FrontShapeEdgePoint[m][2] = TabletSetupData.FrontShapeEdgePoint2[m][2];
		}
	}

	memset(TempImage, 0, MAX_IMAGE_HEIGHT * MAX_IMAGE_WIDTH);
	for (y = 0; y < HALF_IMAGE_HEIGHT; y++)
	{
		for (x = 0; x < HALF_IMAGE_WIDTH; x++)
		{
			if (TabletSetupData.FrontshapeAreaData[HALF_IMAGE_WIDTH * y + x])
			{
				tempX = (x - HALF_IMAGE_WIDTH / 2) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH / 2;
				tempY = (y - HALF_IMAGE_HEIGHT / 2) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT / 2;
				TempImage[tempY * HALF_IMAGE_WIDTH + tempX] = TabletSetupData.FrontshapeAreaData[y * HALF_IMAGE_WIDTH + x];
				TempImage[(tempY + 1) * HALF_IMAGE_WIDTH + tempX] = TabletSetupData.FrontshapeAreaData[y * HALF_IMAGE_WIDTH + x];
				TempImage[tempY * HALF_IMAGE_WIDTH + tempX] = TabletSetupData.FrontshapeAreaData[y * HALF_IMAGE_WIDTH + x];
				TempImage[tempY * HALF_IMAGE_WIDTH + tempX + 1] = TabletSetupData.FrontshapeAreaData[y * HALF_IMAGE_WIDTH + x];
			}
		}
	}

	shapeSetupDataCountDisk1 = 0;
	for (y = 0; y < HALF_IMAGE_HEIGHT; y++)
	{
		for (x = 0; x < HALF_IMAGE_WIDTH; x++)
		{
			TabletSetupData.FrontshapeAreaData[y * HALF_IMAGE_WIDTH + x] = TempImage[y * HALF_IMAGE_WIDTH + x];
			if (TempImage[y * HALF_IMAGE_WIDTH + x])
				shapeSetupDataCountDisk1++;
		}
	}

	memset(TempImage, 0, MAX_IMAGE_HEIGHT * MAX_IMAGE_WIDTH);
	for (y = 0; y < HALF_IMAGE_HEIGHT; y++)
	{
		for (x = 0; x < HALF_IMAGE_WIDTH; x++)
		{
			if (TabletSetupData.FrontshapeAreaData2[HALF_IMAGE_WIDTH * y + x])
			{
				tempX = (x - HALF_IMAGE_WIDTH / 2) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH / 2;
				tempY = (y - HALF_IMAGE_HEIGHT / 2) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT / 2;
				TempImage[tempY * HALF_IMAGE_WIDTH + tempX] = TabletSetupData.FrontshapeAreaData2[y * HALF_IMAGE_WIDTH + x];
				TempImage[(tempY + 1) * HALF_IMAGE_WIDTH + tempX] = TabletSetupData.FrontshapeAreaData2[y * HALF_IMAGE_WIDTH + x];
				TempImage[tempY * HALF_IMAGE_WIDTH + tempX] = TabletSetupData.FrontshapeAreaData2[y * HALF_IMAGE_WIDTH + x];
				TempImage[tempY * HALF_IMAGE_WIDTH + tempX + 1] = TabletSetupData.FrontshapeAreaData2[y * HALF_IMAGE_WIDTH + x];
			}
		}
	}

	shapeSetupDataCountDisk2 = 0;
	for (y = 0; y < HALF_IMAGE_HEIGHT; y++)
	{
		for (x = 0; x < HALF_IMAGE_WIDTH; x++)
		{
			TabletSetupData.FrontshapeAreaData2[y * HALF_IMAGE_WIDTH + x] = TempImage[y * HALF_IMAGE_WIDTH + x];
			if (TempImage[y * HALF_IMAGE_WIDTH + x])
				shapeSetupDataCountDisk2++;
		}
	}

	for (m = 0; m < TabletSetupData.printData1Count; m++)
	{
		TabletSetupData.position_printData1[m][0] = ((TabletSetupData.position_printData1[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH);
		TabletSetupData.position_printData1[m][1] = (TabletSetupData.position_printData1[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
	}

	for (m = 0; m < TabletSetupData.printData2Count; m++)
	{
		TabletSetupData.position_printData2[m][0] = ((TabletSetupData.position_printData2[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH);
		TabletSetupData.position_printData2[m][1] = (TabletSetupData.position_printData2[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
	}

	for (m = 0; m < TabletSetupData.expansion_printData1Count; m++)
	{
		TabletSetupData.expansion_position_printData1[m][0] = ((TabletSetupData.expansion_position_printData1[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH);
		TabletSetupData.expansion_position_printData1[m][1] = (TabletSetupData.expansion_position_printData1[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
	}

	for (m = 0; m < TabletSetupData.expansion_printData2Count; m++)
	{
		TabletSetupData.expansion_position_printData2[m][0] = ((TabletSetupData.expansion_position_printData2[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH);
		TabletSetupData.expansion_position_printData2[m][1] = (TabletSetupData.expansion_position_printData2[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
	}

	for (n = 0; n < TabletSetupData.printLabelCount[0]; n++)
	{
		for (m = 0; m < TabletSetupData.printLabelDataCnt[0][n]; m++)
		{
			TabletSetupData.printLabelData[0][n][m][0] = (TabletSetupData.printLabelData[0][n][m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH;
			TabletSetupData.printLabelData[0][n][m][1] = (TabletSetupData.printLabelData[0][n][m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
		}
	}

	for (n = 0; n < TabletSetupData.printLabelCount[1]; n++)
	{
		for (m = 0; m < TabletSetupData.printLabelDataCnt[1][n]; m++)
		{
			TabletSetupData.printLabelData[1][n][m][0] = (TabletSetupData.printLabelData[1][n][m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH;
			TabletSetupData.printLabelData[1][n][m][1] = (TabletSetupData.printLabelData[1][n][m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
		}
	}

	OnePrintIncludeOtherPrintSWFor2D = 0;

	if (TabletCharacter.discriminationDisplay_num == TWO_FACE_DIFF)
	{
		if (TabletSetupData.printData1Count > 2000 || TabletSetupData.printData2Count > 2000)
			addStep = 3;
		else if (TabletSetupData.printData1Count > 1000 || TabletSetupData.printData2Count > 1000)
			addStep = 2;
		else
			addStep = 1;
	}

	memset(CorePrint1Weight, 0, 3000);
	memset(CorePrint2Weight, 0, 3000);
	memset(TempImage, 0, MAX_IMAGE_HEIGHT * MAX_IMAGE_WIDTH);
	memset(&Position_SmallPrintData1[0][0], 0, 2 * 2 * 3000);
	memset(&Position_SmallPrintCoreData1[0][0], 0, 2 * 2 * 3000);
	SmallPrintData1Count = 0;
	SmallPrintCoreData1Count = 0;

	tempCountPrint[0] = 0;
	tempCountPrint[1] = 0;
	tempCountPrint[2] = 0;
	tempCountPrint[3] = 0;
	for (m = 0; m < TabletSetupData.expansion_printData1Count; m++)
	{
		tempX = TabletSetupData.expansion_position_printData1[m][0];
		tempY = TabletSetupData.expansion_position_printData1[m][1];
		TempImage[MAX_IMAGE_WIDTH * tempY + tempX] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY - 1) + tempX] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY + 1) + tempX] = 1;
		TempImage[MAX_IMAGE_WIDTH * tempY + tempX - 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * tempY + tempX + 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY - 1) + tempX - 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY + 1) + tempX + 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY + 1) + tempX - 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY - 1) + tempX + 1] = 1;
	}

	for (m = 0; m < TabletSetupData.printData1Count; m++)
	{
		tempX = TabletSetupData.position_printData1[m][0];
		tempY = TabletSetupData.position_printData1[m][1];
		for (y = tempY - 1; y < tempY + 1; y++)
		{
			for (x = tempX - 1; x < tempX + 1; x++)
			{
				TempImage[MAX_IMAGE_WIDTH * y + x] = 2;
			}
		}
	}

	for (y = 0; y < MAX_IMAGE_HEIGHT; y++)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x++)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] == 1)
			{
				tempCountPrint[0]++;
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 2)
			{
				tempCountPrint[1]++;
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 3)
			{
				tempCountPrint[2]++;
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 4)
			{
				tempCountPrint[3]++;
			}
		}
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[0] + tempCountPrint[2] < 1500)
			addStep = 1;
		else if (tempCountPrint[0] + tempCountPrint[2] < 6400)
			addStep = 2;
		else
			addStep = 3;
	}

	for (y = 0; y < MAX_IMAGE_HEIGHT; y += addStep)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x += addStep)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] == 1 || TempImage[MAX_IMAGE_WIDTH * y + x] == 3)
			{
				if (SmallPrintData1Count < 2000)
				{
					Position_SmallPrintData1[SmallPrintData1Count][0] = x;
					Position_SmallPrintData1[SmallPrintData1Count][1] = y;
					SmallPrintData1Count++;
				}
			}
		}
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[1] + tempCountPrint[3] < 1500)
			addStep = 1;
		else if (tempCountPrint[1] + tempCountPrint[3] < 6400)
			addStep = 2;
		else
			addStep = 3;
	}

	for (y = 0; y < MAX_IMAGE_HEIGHT; y += addStep)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x += addStep)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] == 2)
			{
				if (SmallPrintCoreData1Count < 1500)
				{
					Position_SmallPrintCoreData1[SmallPrintCoreData1Count][0] = x;
					Position_SmallPrintCoreData1[SmallPrintCoreData1Count][1] = y;
					CorePrint1Weight[SmallPrintCoreData1Count] = 4;
					SmallPrintCoreData1Count++;
				}
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 4)
			{
				if (SmallPrintCoreData1Count < 1500)
				{
					Position_SmallPrintCoreData1[SmallPrintCoreData1Count][0] = x;
					Position_SmallPrintCoreData1[SmallPrintCoreData1Count][1] = y;
					CorePrint1Weight[SmallPrintCoreData1Count] = 1;
					SmallPrintCoreData1Count++;
				}
			}
		}
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[2] < 1500)
			addStep = 1;
		else if (tempCountPrint[2] < 3000)
			addStep = 2;
		else
			addStep = 3;
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[3] < 1500)
			addStep = 1;
		else if (tempCountPrint[3] < 3000)
			addStep = 2;
		else
			addStep = 3;
	}

	memset(TempImage, 0, MAX_IMAGE_HEIGHT * MAX_IMAGE_WIDTH);
	memset(&Position_SmallPrintData2[0][0], 0, 2 * 2 * 3000);
	memset(&Position_SmallPrintCoreData2[0][0], 0, 2 * 2 * 3000);
	SmallPrintData2Count = 0;
	SmallPrintCoreData2Count = 0;

	tempCountPrint[0] = 0;
	tempCountPrint[1] = 0;
	tempCountPrint[2] = 0;
	tempCountPrint[3] = 0;

	for (m = 0; m < TabletSetupData.expansion_printData2Count; m++)
	{
		tempX = TabletSetupData.expansion_position_printData2[m][0];
		tempY = TabletSetupData.expansion_position_printData2[m][1];
		TempImage[MAX_IMAGE_WIDTH * tempY + tempX] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY - 1) + tempX] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY + 1) + tempX] = 1;
		TempImage[MAX_IMAGE_WIDTH * tempY + tempX - 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * tempY + tempX + 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY - 1) + tempX - 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY + 1) + tempX + 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY + 1) + tempX - 1] = 1;
		TempImage[MAX_IMAGE_WIDTH * (tempY - 1) + tempX + 1] = 1;
	}

	for (m = 0; m < TabletSetupData.printData2Count; m++)
	{
		tempX = TabletSetupData.position_printData2[m][0];
		tempY = TabletSetupData.position_printData2[m][1];
		for (y = tempY - 1; y < tempY + 1; y++)
		{
			for (x = tempX - 1; x < tempX + 1; x++)
			{
				TempImage[MAX_IMAGE_WIDTH * y + x] = 2;
			}
		}
	}

	for (y = 0; y < MAX_IMAGE_HEIGHT; y++)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x++)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] == 1)
			{
				tempCountPrint[0]++;
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 2)
			{
				tempCountPrint[1]++;
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 3)
			{
				tempCountPrint[2]++;
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 4)
			{
				tempCountPrint[3]++;
			}
		}
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[0] + tempCountPrint[2] < 1500)
			addStep = 1;
		else if (tempCountPrint[0] + tempCountPrint[2] < 6400)
			addStep = 2;
		else
			addStep = 3;
	}

	for (y = 0; y < MAX_IMAGE_HEIGHT; y += addStep)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x += addStep)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] == 1 || TempImage[MAX_IMAGE_WIDTH * y + x] == 3)
			{
				if (SmallPrintData2Count < 2000)
				{
					Position_SmallPrintData2[SmallPrintData2Count][0] = x;
					Position_SmallPrintData2[SmallPrintData2Count][1] = y;
					SmallPrintData2Count++;
				}
			}
		}
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[1] + tempCountPrint[3] < 1500)
			addStep = 1;
		else if (tempCountPrint[1] + tempCountPrint[3] < 6400)
			addStep = 2;
		else
			addStep = 3;
	}

	for (y = 0; y < MAX_IMAGE_HEIGHT; y += addStep)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x += addStep)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] == 2)
			{
				if (SmallPrintCoreData2Count < 1500)
				{
					Position_SmallPrintCoreData2[SmallPrintCoreData2Count][0] = x;
					Position_SmallPrintCoreData2[SmallPrintCoreData2Count][1] = y;
					CorePrint2Weight[SmallPrintCoreData2Count] = 4;
					SmallPrintCoreData2Count++;
				}
			}
			else if (TempImage[MAX_IMAGE_WIDTH * y + x] == 4)
			{
				if (SmallPrintCoreData2Count < 1500)
				{
					Position_SmallPrintCoreData2[SmallPrintCoreData2Count][0] = x;
					Position_SmallPrintCoreData2[SmallPrintCoreData2Count][1] = y;
					CorePrint2Weight[SmallPrintCoreData2Count] = 1;
					SmallPrintCoreData2Count++;
				}
			}
		}
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[2] < 1500)
			addStep = 1;
		else if (tempCountPrint[2] < 3000)
			addStep = 2;
		else
			addStep = 3;
	}

	if (TabletCharacter.discriminationDisplay_num != TWO_FACE_DIFF)
	{
		if (tempCountPrint[3] < 1500)
			addStep = 1;
		else if (tempCountPrint[3] < 3000)
			addStep = 2;
		else
			addStep = 3;
	}

	for (r = 0; r < 720; r++) // PRINT - CASE1 
	{
		for (m = 0; m < SmallPrintCoreData1Count; m++)
		{
			tempX = Position_SmallPrintCoreData1[m][0];
			tempY = Position_SmallPrintCoreData1[m][1];
			rotateX = ((tempX - 320) * CosData[r] - (tempY - 240) * SinData[r]) / 1024;
			rotateY = ((tempX - 320) * SinData[r] + (tempY - 240) * CosData[r]) / 1024;
			tempAddress = rotateY * MAX_IMAGE_WIDTH + rotateX;
			detailedCorePrintRotationAddress1[r][m] = tempAddress;
		}

		for (m = 0; m < SmallPrintCoreData2Count; m++)
		{
			tempX = Position_SmallPrintCoreData2[m][0];
			tempY = Position_SmallPrintCoreData2[m][1];
			rotateX = ((tempX - 320) * CosData[r] - (tempY - 240) * SinData[r]) / 1024;
			rotateY = ((tempX - 320) * SinData[r] + (tempY - 240) * CosData[r]) / 1024;
			tempAddress = rotateY * MAX_IMAGE_WIDTH + rotateX;
			detailedCorePrintRotationAddress2[r][m] = tempAddress;
		}
	}

	// 2020-01-31
	// add split line info
	if (TabletSetupData.tabletSplitLineDataCount < 0)
		TabletSetupData.tabletSplitLineDataCount = 0;

	if (TabletSetupData.tabletSplitLineDataCount >= PRINT_DATA_SIZE)
		TabletSetupData.tabletSplitLineDataCount = 0;

	for (m = 0; m < TabletSetupData.tabletSplitLineDataCount; m++)
	{
		TabletSetupData.tabletSplitLineData[m][0] = (TabletSetupData.tabletSplitLineData[m][0] - HALF_IMAGE_WIDTH) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_WIDTH;
		TabletSetupData.tabletSplitLineData[m][1] = (TabletSetupData.tabletSplitLineData[m][1] - HALF_IMAGE_HEIGHT) * FrontFaceCamera1Resolution / FrontFaceCamera9Resolution + HALF_IMAGE_HEIGHT;
	}

	memset(TempImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	for (m = 0; m < TabletSetupData.tabletSplitLineDataCount; m++)
	{
		tempX = TabletSetupData.tabletSplitLineData[m][0];
		tempY = TabletSetupData.tabletSplitLineData[m][1];
		for (y = tempY - 1; y < tempY + 1; y++)
		{
			for (x = tempX - 1; x < tempX + 1; x++)
			{
				if (x > 0 && x < MAX_IMAGE_WIDTH && y > 0 && y < MAX_IMAGE_HEIGHT)
				{
					TempImage[MAX_IMAGE_WIDTH * y + x] = 1;
				}
			}
		}
	}

	addStep = 2;

	SmallSplitLineDataCount = 0;
	memset(SmallSplitLineData, 0, sizeof(short) * 2000 * 2);

	for (y = 0; y < MAX_IMAGE_HEIGHT; y += addStep)
	{
		for (x = 0; x < MAX_IMAGE_WIDTH; x += addStep)
		{
			if (TempImage[MAX_IMAGE_WIDTH * y + x] && SmallSplitLineDataCount < 2000)
			{
				SmallSplitLineData[SmallSplitLineDataCount][0] = x;
				SmallSplitLineData[SmallSplitLineDataCount][1] = y;
				SmallSplitLineDataCount++;
			}
		}
	}

	for (r = 0; r < 720; r++)
	{
		for (m = 0; m < SmallSplitLineDataCount; m++)
		{
			tempX = SmallSplitLineData[m][0];
			tempY = SmallSplitLineData[m][1];
			rotateX = ((tempX - 320) * CosData[r] - (tempY - 240) * SinData[r]) / 1024;
			rotateY = ((tempX - 320) * SinData[r] + (tempY - 240) * CosData[r]) / 1024;

			tempAddress = rotateY * MAX_IMAGE_WIDTH + rotateX;
			detailedSplitLineRotationAddress[r][m] = tempAddress;
		}
	}
	////// End 2D Front Face Camera Initial
}
//---------------------------------------------------------------------------
void PreProcessingForFrontFace(int cameraIndex)
{
	int x, y, r, m;
	int protoThrshold;	
	int tempCount;	
	int startX, endX, startY, endY;
	int tempAddress, tempAddress2;	
	int smallSizeImagWidth;
	int smallSizeImagHeight;
	int maxLabelN;
	//int histo[256];
	int halfImageWidth;
	int halfImageHeight;
	unsigned char *tempOneColorImage;
	
	tempOneColorImage = TempImage4;

	startX = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	endX = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	startY = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	endY = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	if (startX < 5)
		startX = 5;
	if (endX > ImageWidth - 5)
		endX = ImageWidth - 5;
	if (startY < 5)
		startY = 5;
	if (endY > ImageHeight - 5)
		endY = ImageHeight - 5;

	smallSizeImagWidth = MAX_IMAGE_WIDTH / 4;
	smallSizeImagHeight = MAX_IMAGE_HEIGHT / 4;

	memset(smallSizeBinaryImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));
	memset(smallSizeShrinkBinaryImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));
	memset(smallSizeLabelImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4) * 2);
	memset(smallSizeGradientImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));
	memset(smallSizeOneColorImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));
	memset(tempOneColorImage, 0, (MAX_IMAGE_WIDTH) * (MAX_IMAGE_HEIGHT));

	ProtoTabletRotationAngle = 0;

	halfImageWidth = HALF_IMAGE_WIDTH;
	halfImageHeight = HALF_IMAGE_HEIGHT;

	protoThrshold = 40;
	if (ProcessingModeGlobal == INSPECTION_MODE)
	{
		protoThrshold = 40 + TabletGradeData.ETC_TabletFrontFaceThreshold * 3;
		if (protoThrshold < 10)
			protoThrshold = 10;
	}

	memcpy(tempOneColorImage, OneColorImage, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

	ProtoTabletCenterX = 0;
	ProtoTabletCenterY = 0;
	tempCount = 0;	

	//  ȭ   ´.
	{
		int x4, y4;
		for (y = startY, y4 = y / 4; y < endY; y += 4, ++y4)
		{
			for (x = startX, x4 = x / 4; x < endX; x += 4, ++x4)
			{
				tempAddress = y * MAX_IMAGE_WIDTH + x;

				smallSizeOneColorImage[smallSizeImagWidth * y4 + x4] = tempOneColorImage[tempAddress];
				if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 25)
				{
					smallSizeBinaryImage[smallSizeImagWidth * y4 + x4] = 1;
				}
			}
		}
	}

	maxLabelN = LabellingForTabletImage(smallSizeLabelImage, smallSizeBinaryImage, startX / 4, endX / 4, startY / 4, endY / 4, smallSizeImagWidth, smallSizeImagHeight);

	//  ÷ ϰ  .
	{
		int meanColor[3];
		int tempColorCount = 0;

		meanColor[0] = 0;
		meanColor[1] = 0;
		meanColor[2] = 0;

		{
			int xmax, ymax;
			for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
			{
				for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
				{
					tempAddress2 = y * smallSizeImagWidth + x;
					if (smallSizeLabelImage[tempAddress2] == maxLabelN)
					{
						tempAddress = ((MAX_IMAGE_WIDTH * y) + x) * 3 * 4;
						meanColor[0] += ColorSourceImage[tempAddress];
						meanColor[1] += ColorSourceImage[tempAddress + 1];
						meanColor[2] += ColorSourceImage[tempAddress + 2];
						tempColorCount++;

						smallSizeBinaryImage[tempAddress2] = 2;
						smallSizeBinaryImage[tempAddress2 + 1] = 2;
						smallSizeBinaryImage[tempAddress2 - 1] = 2;
						smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth] = 2;
						smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth] = 2;
						smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth + 1] = 2;
						smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth - 1] = 2;
						smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth - 1] = 2;
						smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth + 1] = 2;

						smallSizeShrinkBinaryImage[tempAddress2] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 + 1] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 - 1] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth + 1] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth - 1] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth - 1] = 1;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth + 1] = 1;
					}
				}
			}
			if (tempColorCount)
			{
				meanColor[0] /= tempColorCount;
				meanColor[1] /= tempColorCount;
				meanColor[2] /= tempColorCount;
			}
		}

		///////////////////////////// 3   ٽ  ÷ Ѵ.//////////////////////////////////

		SelectedFace = FRONT_FACE_FOR_COLOR;
		Front_Rear = FRONT_FACE_FOR_COLOR;
		if (TabletCharacter.tabletColorN != ONECOLOR)
		{
			int tempSqrtColorSum1, tempSqrtColorSum2;
			if (ProcessingModeGlobal == INSPECTION_MODE)
			{
				if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
				{
					tempSqrtColorSum1 = (TabletStudyData.tabletColorB_ForCamera1 - meanColor[0]) * (TabletStudyData.tabletColorB_ForCamera1 - meanColor[0]) + (TabletStudyData.tabletColorG_ForCamera1 - meanColor[1]) * (TabletStudyData.tabletColorG_ForCamera1 - meanColor[1]) + (TabletStudyData.tabletColorR_ForCamera1 - meanColor[2]) * (TabletStudyData.tabletColorR_ForCamera1 - meanColor[2]);
					tempSqrtColorSum2 = (TabletStudyData.tabletRearColorB_ForCamera1 - meanColor[0]) * (TabletStudyData.tabletRearColorB_ForCamera1 - meanColor[0]) + (TabletStudyData.tabletRearColorG_ForCamera1 - meanColor[1]) * (TabletStudyData.tabletRearColorG_ForCamera1 - meanColor[1]) + (TabletStudyData.tabletRearColorR_ForCamera1 - meanColor[2]) * (TabletStudyData.tabletRearColorR_ForCamera1 - meanColor[2]);
				}
				else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
				{
					tempSqrtColorSum1 = (TabletStudyData.tabletColorB_ForCamera9 - meanColor[0]) * (TabletStudyData.tabletColorB_ForCamera9 - meanColor[0]) + (TabletStudyData.tabletColorG_ForCamera9 - meanColor[1]) * (TabletStudyData.tabletColorG_ForCamera9 - meanColor[1]) + (TabletStudyData.tabletColorR_ForCamera9 - meanColor[2]) * (TabletStudyData.tabletColorR_ForCamera9 - meanColor[2]);
					tempSqrtColorSum2 = (TabletStudyData.tabletRearColorB_ForCamera9 - meanColor[0]) * (TabletStudyData.tabletRearColorB_ForCamera9 - meanColor[0]) + (TabletStudyData.tabletRearColorG_ForCamera9 - meanColor[1]) * (TabletStudyData.tabletRearColorG_ForCamera9 - meanColor[1]) + (TabletStudyData.tabletRearColorR_ForCamera9 - meanColor[2]) * (TabletStudyData.tabletRearColorR_ForCamera9 - meanColor[2]);
				}
			}
			else
			{
				tempSqrtColorSum1 = (TabletSetupData.protoStudyColorB - meanColor[0]) * (TabletSetupData.protoStudyColorB - meanColor[0]) + (TabletSetupData.protoStudyColorG - meanColor[1]) * (TabletSetupData.protoStudyColorG - meanColor[1]) + (TabletSetupData.protoStudyColorR - meanColor[2]) * (TabletSetupData.protoStudyColorR - meanColor[2]);
				tempSqrtColorSum2 = (TabletSetupData.rear_protoStudyColorB - meanColor[0]) * (TabletSetupData.rear_protoStudyColorB - meanColor[0]) + (TabletSetupData.rear_protoStudyColorG - meanColor[1]) * (TabletSetupData.rear_protoStudyColorG - meanColor[1]) + (TabletSetupData.rear_protoStudyColorR - meanColor[2]) * (TabletSetupData.rear_protoStudyColorR - meanColor[2]);
			}
			if (tempSqrtColorSum2 < tempSqrtColorSum1)
			{
				SelectedFace = REAR_FACE_FOR_COLOR;
				Front_Rear = REAR_FACE_FOR_COLOR;
				if (TabletSetupData.rear_protoStudyColorR != 0 && TabletSetupData.rear_protoStudyColorG != 0 && TabletSetupData.rear_protoStudyColorB != 0)
				{
					if (TabletSetupData.rear_protoStudyColorR > TabletSetupData.rear_protoStudyColorG * 110 / 100)
					{
						if (TabletSetupData.rear_protoStudyColorR > TabletSetupData.rear_protoStudyColorB * 110 / 100)
						{
							selectedRGB = 2;
						}
					}
					if (TabletSetupData.rear_protoStudyColorB > TabletSetupData.rear_protoStudyColorG * 110 / 100)
					{
						if (TabletSetupData.rear_protoStudyColorB > TabletSetupData.rear_protoStudyColorR * 110 / 100)
						{
							selectedRGB = 0;
						}
					}
				}
			}
			for (y = startY; y < endY; y++)
			{
				for (x = startX; x < endX; x++)
				{
					tempAddress = y * MAX_IMAGE_WIDTH + x;
					OneColorImage[tempAddress] = ColorSourceImage[tempAddress * 3 + selectedRGB];
					tempOneColorImage[tempAddress] = OneColorImage[tempAddress];
				}
			}

			memset(smallSizeBinaryImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));
			memset(smallSizeShrinkBinaryImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));
			memset(smallSizeLabelImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4) * 2);
			memset(smallSizeOneColorImage, 0, (MAX_IMAGE_WIDTH / 4) * (MAX_IMAGE_HEIGHT / 4));

			{
				int x4, y4;
				for (y = startY, y4 = y / 4; y < endY; y += 4, ++y4)
				{
					for (x = startX, x4 = x / 4; x < endX; x += 4, ++x4)
					{
						tempAddress = y * MAX_IMAGE_WIDTH + x;

						smallSizeOneColorImage[smallSizeImagWidth * y4 + x4] = tempOneColorImage[y * MAX_IMAGE_WIDTH + x];
						if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 25)
						{
							smallSizeBinaryImage[smallSizeImagWidth * y4 + x4] = 1;
						}
					}
				}
			}

			maxLabelN = LabellingForTabletImage(smallSizeLabelImage, smallSizeBinaryImage, startX / 4, endX / 4, startY / 4, endY / 4, smallSizeImagWidth, smallSizeImagHeight);

			{
				int xmax, ymax;
				for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
				{
					for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
					{
						tempAddress2 = y * smallSizeImagWidth + x;
						if (smallSizeLabelImage[tempAddress2] == maxLabelN)
						{
							smallSizeBinaryImage[tempAddress2] = 2;
							smallSizeBinaryImage[tempAddress2 + 1] = 2;
							smallSizeBinaryImage[tempAddress2 - 1] = 2;
							smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth] = 2;
							smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth] = 2;
							smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth + 1] = 2;
							smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth - 1] = 2;
							smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth - 1] = 2;
							smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth + 1] = 2;

							smallSizeShrinkBinaryImage[tempAddress2] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 + 1] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 - 1] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth + 1] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth - 1] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth - 1] = 1;
							smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth + 1] = 1;
						}
					}
				}
			}
		}
	}

	//   ÷  .

	// shrink ̹ Ѵ.
	{
		int xmax, ymax;
		int edgeCheckSW;
		for (y = startY / 4 + 2, ymax = endY / 4 - 2; y < ymax; y++)
		{
			for (x = startX / 4 + 2, xmax = endX / 4 - 2; x < xmax; x++)
			{
				tempAddress2 = y * smallSizeImagWidth + x;
				if (smallSizeBinaryImage[tempAddress2] == 2)
				{								
					if (smallSizeBinaryImage[tempAddress2 - 1] == 0 ||
						smallSizeBinaryImage[tempAddress2 + 1] == 0 ||
						smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth] == 0 ||
						smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth] == 0 ||
						smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth + 1] == 0 ||
						smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth - 1] == 0 ||
						smallSizeBinaryImage[tempAddress2 - smallSizeImagWidth - 1] == 0 ||
						smallSizeBinaryImage[tempAddress2 + smallSizeImagWidth + 1] == 0)
					{
						edgeCheckSW = 1;
					}
					else
					{
						edgeCheckSW = 0;
					}

					if (edgeCheckSW == 1)
					{
						smallSizeShrinkBinaryImage[tempAddress2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth + 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth - 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth + 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - smallSizeImagWidth - 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth + 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth - 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth + 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + smallSizeImagWidth - 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 2 * smallSizeImagWidth] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 2 * smallSizeImagWidth + 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 2 * smallSizeImagWidth - 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 2 * smallSizeImagWidth + 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 - 2 * smallSizeImagWidth - 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 2 * smallSizeImagWidth] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 2 * smallSizeImagWidth + 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 2 * smallSizeImagWidth - 1] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 2 * smallSizeImagWidth + 2] = 0;
						smallSizeShrinkBinaryImage[tempAddress2 + 2 * smallSizeImagWidth - 2] = 0;
					}
				}
			}
		}
	}

	//for (x = 0; x < 256; x++)
	//{
	//	histo[x] = 0;
	//}

	if (maxLabelN == 0)
	{
		DefectSW = 3;
		return;
	}

	// , ׷,  . (0.45ms ҿ)
	{
		int x4, y4;
		int tempCount2 = 0;
		for (y = startY, y4 = y / 4; y < endY; ++y, ((y & 3) == 0 && ++y4))		
		{
			for (x = startX, x4 = x / 4; x < endX; ++x, ((x & 3) == 0 && ++x4))			
			{
				tempAddress = y * MAX_IMAGE_WIDTH + x;
				tempAddress2 = y4 * smallSizeImagWidth + x4;
				if (smallSizeBinaryImage[tempAddress2] == 2 &&
					(tempOneColorImage[tempAddress] > protoThrshold || smallSizeShrinkBinaryImage[tempAddress2] == 1))
				{
					ShapeBinaryImage[tempAddress] = 1;
					ProtoTabletCenterX += x;
					ProtoTabletCenterY += y;
					tempCount2++;
					//histo[tempOneColorImage[tempAddress]]++;
				}
			}
		}
		tempCount = tempCount2;
	}

	if (tempCount < 80 * 80)
	{
		// 80 by 80
		DefectSW = 3;
		return;
	}

	// 5ȼ mean ̹ . (0.7ms ҿ)
	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + x;
			MeanOneColorImage[tempAddress] = ((tempOneColorImage[tempAddress] + tempOneColorImage[tempAddress - 1] + tempOneColorImage[tempAddress + 1] + tempOneColorImage[tempAddress + MAX_IMAGE_WIDTH] + tempOneColorImage[tempAddress - MAX_IMAGE_WIDTH]) / 5);
		}
	}

	if (ProcessingModeGlobal == INSPECTION_MODE || ProcessingModeGlobal == STUDY_MODE)
	{
		int tempCount2 = 0, tempCount3 = 0;
		for (y = startY; y < endY; y++)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + startX + 4;
			if (ShapeBinaryImage[tempAddress] == 1)
			{
				tempCount2++;
			}
			tempAddress = y * MAX_IMAGE_WIDTH + endX - 4;
			if (ShapeBinaryImage[tempAddress] == 1)
			{
				tempCount3++;
			}
		}
		if (tempCount2 >= 1 + TabletGradeData.BeltPowderSensitivity * 2 || 
			tempCount3 >= 1 + TabletGradeData.BeltPowderSensitivity * 2) // Ʈ Ǿ  츦 ɷ Ͽ  ȼ ̻  ̰ó.
		{
			globalPositionErrorSuspectedTablet = 1;
		}

		for (x = startX; x < endX; x++)
		{
			tempAddress = (startY + 4) * MAX_IMAGE_WIDTH + x;
			if (ShapeBinaryImage[tempAddress] == 1)
			{
				DefectSW = 3;
			}
			tempAddress = (endY - 4) * MAX_IMAGE_WIDTH + x;
			if (ShapeBinaryImage[tempAddress] == 1)
			{
				DefectSW = 3;
			}
		}
	}

	if (DefectSW == 3)
	{
		// ϴ    ڼҾ̸ Ʒ  
		globalPositionErrorSuspectedTablet = 0;
	}

	if (TabletCharacter.kind != UNCOATING)
	{
		if (globalPositionErrorSuspectedTablet)
		{
			DefectSW = 3;
			globalPositionErrorSuspectedTablet = 0;
		}
	}

	if (tempCount)
	{
		ProtoTabletCenterX /= tempCount;
		ProtoTabletCenterY /= tempCount;
	}
	else
	{
		DefectSW = 3;
	}

	ProtoTabletRotationAngle = 0;

	if (ProtoTabletCenterX < 0)
		ProtoTabletCenterX = 0;
	if (ProtoTabletCenterX >= MAX_IMAGE_WIDTH)
		ProtoTabletCenterX = MAX_IMAGE_WIDTH - 1;
	if (ProtoTabletCenterY < 0)
		ProtoTabletCenterY = 0;
	if (ProtoTabletCenterY >= MAX_IMAGE_HEIGHT)
		ProtoTabletCenterY = MAX_IMAGE_HEIGHT - 1;

	//  y ̸ ϴ ڵ (ſ )
	if (ProcessingModeGlobal == INSPECTION_MODE || ProcessingModeGlobal == STUDY_MODE)
	{
		int tempValue1;
		int tempValue2;
		int rightNeighborTabletPosi;
		int leftNeighborTabletPosi;

		rightNeighborTabletPosi = 1000;
		leftNeighborTabletPosi = -1000;

		tempValue1 = ProtoTabletCenterX - TabletCharacter.length / 2 - (TabletCharacter.width / 2 * 261 / 1000);
		tempValue2 = ProtoTabletCenterX + TabletCharacter.length / 2 + (TabletCharacter.width / 2 * 261 / 1000);

		for (y = ProtoTabletCenterY; y < endY; y++)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + (tempValue1 - (y - ProtoTabletCenterY) * 77 / 100);

			if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
			{
				tempCount = 0;
				for (m = y; m <= y + 5; m++)
				{
					tempAddress = m * MAX_IMAGE_WIDTH + (tempValue1 - (m - ProtoTabletCenterY) * 77 / 100);
					if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
					{
						tempCount++;
					}
				}
				if (tempCount >= 5)
				{
					rightNeighborTabletPosi = y;
					break;
				}
			}
		}
		for (y = ProtoTabletCenterY; y < endY; y++)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + (tempValue2 + (y - ProtoTabletCenterY) * 77 / 100);
			if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
			{
				tempCount = 0;
				for (m = y; m <= y + 5; m++)
				{
					tempAddress = m * MAX_IMAGE_WIDTH + (tempValue2 + (m - ProtoTabletCenterY) * 77 / 100);
					if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
					{
						tempCount++;
					}
				}
				if (tempCount >= 5)
				{
					rightNeighborTabletPosi = y;
					break;
				}
			}
		}

		for (y = ProtoTabletCenterY; y >= startY; y--)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + (tempValue1 + (y - ProtoTabletCenterY) * 77 / 100);
			if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
			{
				tempCount = 0;
				for (m = y; m >= y - 5; m--)
				{
					tempAddress = m * MAX_IMAGE_WIDTH + (tempValue1 + (m - ProtoTabletCenterY) * 77 / 100);
					if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
					{
						tempCount++;
					}
				}
				if (tempCount >= 5)
				{
					rightNeighborTabletPosi = y;
					break;
				}
			}
		}
		for (y = ProtoTabletCenterY; y >= startY; y--)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + (tempValue2 - (y - ProtoTabletCenterY) * 77 / 100);
			if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
			{
				tempCount = 0;
				for (m = y; m >= y - 5; m--)
				{
					tempAddress = m * MAX_IMAGE_WIDTH + (tempValue2 - (m - ProtoTabletCenterY) * 77 / 100);
					if (tempOneColorImage[tempAddress] > protoThrshold || abs(ColorSourceImage[tempAddress * 3 + 2] - ColorSourceImage[tempAddress * 3]) > 20)
					{
						tempCount++;
					}
				}
				if (tempCount >= 5)
				{
					rightNeighborTabletPosi = y;
					break;
				}
			}
		}
		if (rightNeighborTabletPosi != 1000 && leftNeighborTabletPosi != -1000) // 0.414r + 10
			DefectSW = 2;
	}

	// Ʒ  PC 1ms ҿȴ.
	{
		int grad;
		int gradX, gradY;
		for (y = startY + 4; y < endY - 4; y++)
		{
			for (x = startX + 4; x < endX - 4; x++)
			{
				tempAddress = y * MAX_IMAGE_WIDTH + x;

				if (x < ProtoTabletCenterX)
				{
					gradX = tempOneColorImage[tempAddress] - tempOneColorImage[tempAddress - 4];
				}
				else
				{
					gradX = tempOneColorImage[tempAddress] - tempOneColorImage[tempAddress + 4];
				}

				if (y < ProtoTabletCenterY)
				{
					gradY = tempOneColorImage[tempAddress] - tempOneColorImage[tempAddress - MAX_IMAGE_WIDTH * 4];
				}
				else
				{
					gradY = tempOneColorImage[tempAddress] - tempOneColorImage[tempAddress + MAX_IMAGE_WIDTH * 4];
				}

				grad = max(gradX, gradY);

				GradientImage[tempAddress] = (grad < 3) ? 0 : grad;
			}
		}
	}

	if (TabletCharacter.shape == OBLONG || TabletCharacter.shape == OVAL)
	{
		{		
			int xmax, ymax;
			int gradX, gradY;
			for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
			{
				for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
				{
					tempAddress = y * smallSizeImagWidth + x;
					gradX = abs(smallSizeOneColorImage[tempAddress + 1] - smallSizeOneColorImage[tempAddress - 1]);
					gradY = abs(smallSizeOneColorImage[tempAddress + smallSizeImagWidth] - smallSizeOneColorImage[tempAddress - smallSizeImagWidth]);				
					smallSizeGradientImage[smallSizeImagWidth * (y) + x] = max(gradX, gradY);
				}
			}
		}
		int matchingValue;
		int maxG = -1;
		int rotateX, rotateY;
		for (r = 0; r <= 60; r += 4)
		{
			matchingValue = 0;
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				rotateX = ((CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) - SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterX;
				rotateY = ((SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) + CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterY;

				//if (rotateX > 1 && rotateX < MAX_IMAGE_WIDTH - 1 && rotateY > 1 && rotateY < MAX_IMAGE_HEIGHT - 1) // б⸸ϹǷ ӵ ؼ  .
					matchingValue += (smallSizeGradientImage[(rotateY / 4) * smallSizeImagWidth + (rotateX / 4)]);
			}
			if (maxG < (matchingValue))
			{
				maxG = (matchingValue);
				ProtoTabletRotationAngle = r;
			}
		}
		for (r = 300; r <= 360; r += 4)
		{
			matchingValue = 0;
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				rotateX = ((CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) - SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterX;
				rotateY = ((SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) + CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterY;

				//if (rotateX > 1 && rotateX < MAX_IMAGE_WIDTH - 1 && rotateY > 1 && rotateY < MAX_IMAGE_HEIGHT - 1) // б⸸ϹǷ ӵ ؼ  .
					matchingValue += (smallSizeGradientImage[(rotateY / 4) * smallSizeImagWidth + (rotateX / 4)]);
			}
			if (maxG < (matchingValue))
			{
				maxG = (matchingValue);
				ProtoTabletRotationAngle = r;
			}
		}

		if (ProcessingModeGlobal == INSPECTION_MODE || ProcessingModeGlobal == STUDY_MODE)
		{
			if (ProtoTabletRotationAngle > 60 && ProtoTabletRotationAngle < 300)
				DefectSW = 3;
		}
	}
	else if (TabletCharacter.shape == TRIANGLE)
	{
		{
			int xmax, ymax;
			int gradX, gradY;
			for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
			{
				for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
				{
					tempAddress = y * smallSizeImagWidth + x;
					gradX = abs(smallSizeOneColorImage[tempAddress + 1] - smallSizeOneColorImage[tempAddress - 1]);
					gradY = abs(smallSizeOneColorImage[tempAddress + smallSizeImagWidth] - smallSizeOneColorImage[tempAddress - smallSizeImagWidth]);
					smallSizeGradientImage[smallSizeImagWidth * (y) + x] = max(gradX, gradY);
				}
			}
		}
		int matchingValue;
		int maxG = -1;
		int rotateX, rotateY;
		for (r = 0; r <= 720 / 3; r += 6) // ﰢ\ 720/3
		{
			matchingValue = 0;
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				rotateX = ((CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) - SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterX;
				rotateY = ((SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) + CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterY;

				//if (rotateX > 1 && rotateX < MAX_IMAGE_WIDTH - 1 && rotateY > 1 && rotateY < MAX_IMAGE_HEIGHT - 1) // б⸸ϹǷ ӵ ؼ  .
					matchingValue += (smallSizeGradientImage[(rotateY / 4) * smallSizeImagWidth + (rotateX / 4)]);
			}
			if (maxG < (matchingValue))
			{
				maxG = (matchingValue);
				ProtoTabletRotationAngle = r;
			}
		}
	}
	else if (TabletCharacter.shape == HEXA)
	{
		{
			int xmax, ymax;
			int gradX, gradY;
			for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
			{
				for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
				{
					tempAddress = y * smallSizeImagWidth + x;
					gradX = abs(smallSizeOneColorImage[tempAddress + 1] - smallSizeOneColorImage[tempAddress - 1]);
					gradY = abs(smallSizeOneColorImage[tempAddress + smallSizeImagWidth] - smallSizeOneColorImage[tempAddress - smallSizeImagWidth]);				
					smallSizeGradientImage[smallSizeImagWidth * (y) + x] = max(gradX, gradY);
				}
			}
		}
		int matchingValue;
		int maxG = -1;
		int rotateX, rotateY;
		for (r = 0; r <= 240; r += 6)
		{
			matchingValue = 0;
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				rotateX = ((CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) - SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterX;
				rotateY = ((SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) + CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterY;

				//if (rotateX > 1 && rotateX < MAX_IMAGE_WIDTH - 1 && rotateY > 1 && rotateY < MAX_IMAGE_HEIGHT - 1) // б⸸ϹǷ ӵ ؼ  .
					matchingValue += (smallSizeGradientImage[(rotateY / 4) * smallSizeImagWidth + (rotateX / 4)]);
			}
			if (maxG < (matchingValue))
			{
				maxG = (matchingValue);
				ProtoTabletRotationAngle = r;
			}
		}
	}
	else if (TabletCharacter.shape == SQUARE)
	{
		{
			int xmax, ymax;
			int gradX, gradY;
			for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
			{
				for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
				{
					tempAddress = y * smallSizeImagWidth + x;
					gradX = abs(smallSizeOneColorImage[tempAddress + 1] - smallSizeOneColorImage[tempAddress - 1]);
					gradY = abs(smallSizeOneColorImage[tempAddress + smallSizeImagWidth] - smallSizeOneColorImage[tempAddress - smallSizeImagWidth]);
					smallSizeGradientImage[smallSizeImagWidth * (y) + x] = max(gradX, gradY);
				}
			}
		}

		short tempRotationShapePoint[3000][2];
		int matchingValue;
		int maxG = -1;
		int rotateX, rotateY;
		int i, j;
		for (r = 0; r < 720; r += 6)
		{
			matchingValue = 0;
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m += 3)
			{
				rotateX = ((CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) - SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterX;
				rotateY = ((SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) + CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterY;
				rotateX /= 4;
				rotateY /= 4;
				tempRotationShapePoint[m][0] = rotateX;
				tempRotationShapePoint[m][1] = rotateY;
			}

			for (i = -2; i <= 2; i += 1)
			{
				for (j = -2; j <= 2; j += 1)
				{
					for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m += 3)
					{
						//if (tempRotationShapePoint[m][0] + j > 1 && tempRotationShapePoint[m][0] + j < smallSizeImagWidth - 1 && tempRotationShapePoint[m][1] + i > 1 && tempRotationShapePoint[m][1] + i < smallSizeImagHeight - 1) // б⸸ϹǷ ӵ ؼ  .
						{
							tempAddress = (tempRotationShapePoint[m][1] + i) * smallSizeImagWidth + (tempRotationShapePoint[m][0] + j);
							matchingValue += smallSizeGradientImage[tempAddress];
						}
					}
				}
			}
			if (maxG < (matchingValue))
			{
				maxG = (matchingValue);
				ProtoTabletRotationAngle = r;
			}
		}
	}
	else if (TabletCharacter.shape == ETC)
	{
		if (TabletCharacter.symmetric_line_count == ASYMMETRY_TABLET)
		{
			int forwardMaxMatchingValue;
			int reverseMaxMatchingValue;
			int forwardAngle;
			int reverseAngle;

			{
				int x4, y4;
				int gradX, gradY;
				for (y = startY + 2, y4 = y / 4; y < endY - 2; ++y, ((y & 3) == 0 && ++y4))				
				{
					for (x = startX + 2, x4 = x / 4; x < endX - 2; ++x, ((x & 3) == 0 && ++x4))					
					{
						tempAddress = y * MAX_IMAGE_WIDTH + x;

						gradX = abs(OneColorImage[tempAddress + 2] - OneColorImage[tempAddress - 2]);
						gradY = abs(OneColorImage[tempAddress + MAX_IMAGE_WIDTH * 2] - OneColorImage[tempAddress - MAX_IMAGE_WIDTH * 2]);

						tempAddress = y4 * smallSizeImagWidth + x4;
						smallSizeGradientImage[tempAddress] = max(smallSizeGradientImage[tempAddress], max(gradX, gradY));
					}
				}
			}

			int shiftX, shiftY;
			shiftX = ProtoTabletCenterX - HALF_IMAGE_WIDTH;
			shiftY = ProtoTabletCenterY - HALF_IMAGE_HEIGHT;

			//  ȸ
			forwardMaxMatchingValue = 0;

			{
				int rX, rY;
				int tempX, tempY;
				int matchingValue;
				for (r = 0; r < 720; r++)
				{
					int cosValue, sinValue;
					if (r >= 0)
					{
						sinValue = SinData[r];
						cosValue = CosData[r];
					}
					else
					{
						sinValue = -SinData[-r];
						cosValue = CosData[-r];
					}

					matchingValue = 0;
					for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
					{
						tempX = TabletSetupData.FrontShapeEdgePoint[m][0] + shiftX;
						tempY = TabletSetupData.FrontShapeEdgePoint[m][1] + shiftY;

						rX = ((tempX - ProtoTabletCenterX) * cosValue - (tempY - ProtoTabletCenterY) * sinValue) / 1024 + ProtoTabletCenterX;
						rY = ((tempX - ProtoTabletCenterX) * sinValue + (tempY - ProtoTabletCenterY) * cosValue) / 1024 + ProtoTabletCenterY;

						rX /= 4;
						rY /= 4;

						//if (rX > 10 && rX < MAX_IMAGE_WIDTH - 10 && rY > 10 && rY < MAX_IMAGE_HEIGHT - 10 && (*(smallSizeGradientImage + smallSizeImagWidth * rY + rX))) // б⸸ϹǷ ӵ ؼ  .
						{
							matchingValue += *(smallSizeGradientImage + smallSizeImagWidth * rY + rX);
						}
					}

					if (matchingValue > forwardMaxMatchingValue)
					{
						forwardMaxMatchingValue = matchingValue;
						forwardAngle = r;
					}
				}
			}

			//   ȸ
			reverseMaxMatchingValue = 0;
			
			{
				int rX, rY;
				int tempX, tempY;
				int matchingValue;
				for (r = 0; r < 720; r++)
				{
					int cosValue, sinValue;
					if (r >= 0)
					{
						sinValue = SinData[r];
						cosValue = CosData[r];
					}
					else
					{
						sinValue = -SinData[-r];
						cosValue = CosData[-r];
					}

					matchingValue = 0;
					for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
					{
						tempX = (MAX_IMAGE_WIDTH - TabletSetupData.FrontShapeEdgePoint[m][0]) + shiftX;
						tempY = TabletSetupData.FrontShapeEdgePoint[m][1] + shiftY;

						rX = ((tempX - ProtoTabletCenterX) * cosValue - (tempY - ProtoTabletCenterY) * sinValue) / 1024 + ProtoTabletCenterX;
						rY = ((tempX - ProtoTabletCenterX) * sinValue + (tempY - ProtoTabletCenterY) * cosValue) / 1024 + ProtoTabletCenterY;

						rX /= 4;
						rY /= 4;

						//if (rX > 10 && rX < MAX_IMAGE_WIDTH - 10 && rY > 10 && rY < MAX_IMAGE_HEIGHT - 10 && (*(smallSizeGradientImage + smallSizeImagWidth * rY + rX))) // б⸸ϹǷ ӵ ؼ  .
						{
							matchingValue += *(smallSizeGradientImage + smallSizeImagWidth * rY + rX);
						}
					}

					if (matchingValue > reverseMaxMatchingValue)
					{
						reverseMaxMatchingValue = matchingValue;
						reverseAngle = r;
					}
				}
			}

			/*
			shiftX = ProtoTabletCenterX - HALF_IMAGE_WIDTH;
			shiftY = ProtoTabletCenterY - HALF_IMAGE_HEIGHT;

			//  ȸ
			forwardMaxMatchingValue = 0;

			for(r = 0; r < 720; r += 4)
			{
			for(detailedShiftY = -8; detailedShiftY <= 8; detailedShiftY += 4)
			{
			for(detailedShiftX = -8; detailedShiftX <= 8; detailedShiftX += 4)
			{
			matchingValue = 0;
			for(m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m += 4)
			{
			tempX = TabletSetupData.FrontShapeEdgePoint[m][0] + shiftX;
			tempY = TabletSetupData.FrontShapeEdgePoint[m][1] + shiftY;

			if(r >= 0)
			{
			rX = ((tempX-ProtoTabletCenterX) * CosData[r] - (tempY - ProtoTabletCenterY)* SinData[r])/1024 + ProtoTabletCenterX + detailedShiftX;
			rY = ((tempX-ProtoTabletCenterX) * SinData[r] + (tempY - ProtoTabletCenterY)* CosData[r])/1024 + ProtoTabletCenterY + detailedShiftY;
			}
			else
			{
			rX = ((tempX-ProtoTabletCenterX) * CosData[-r] + (tempY - ProtoTabletCenterY) * SinData[-r])/1024 + ProtoTabletCenterX + detailedShiftX;
			rY = (-(tempX-ProtoTabletCenterX) * SinData[-r] + (tempY - ProtoTabletCenterY) * CosData[-r])/1024 + ProtoTabletCenterY + detailedShiftY;
			}

			if(rX > 10 && rX < MAX_IMAGE_WIDTH - 10 && rY > 10 && rY < MAX_IMAGE_HEIGHT - 10)
			{
			tempAddress = MAX_IMAGE_WIDTH * rY + rX;
			matchingValue += GradientImage[tempAddress];
			matchingValue += GradientImage[tempAddress - 2];
			matchingValue += GradientImage[tempAddress + 2];
			matchingValue += GradientImage[tempAddress - 2 * MAX_IMAGE_WIDTH];
			matchingValue += GradientImage[tempAddress + 2 * MAX_IMAGE_WIDTH];
			}
			}

			if(matchingValue > forwardMaxMatchingValue)
			{
			forwardMaxMatchingValue = matchingValue;
			forwardAngle = r;
			}
			}
			}
			}

			//   ȸ
			reverseMaxMatchingValue = 0;

			for(r = 0; r < 720; r += 4)
			{
			//for(detailedShiftY = -8; detailedShiftY <= 8; detailedShiftY += 4)
			{
			//for(detailedShiftX = -8; detailedShiftX <= 8; detailedShiftX += 4)
			{
			matchingValue = 0;
			for(m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m += 4)
			{
			tempX = (MAX_IMAGE_WIDTH - TabletSetupData.FrontShapeEdgePoint[m][0]) + shiftX;
			tempY = TabletSetupData.FrontShapeEdgePoint[m][1] + shiftY;

			if(r >= 0)
			{
			rX = ((tempX-ProtoTabletCenterX) * CosData[r] - (tempY - ProtoTabletCenterY)* SinData[r])/1024 + ProtoTabletCenterX + detailedShiftX;
			rY = ((tempX-ProtoTabletCenterX) * SinData[r] + (tempY - ProtoTabletCenterY)* CosData[r])/1024 + ProtoTabletCenterY + detailedShiftY;
			}
			else
			{
			rX = ((tempX-ProtoTabletCenterX) * CosData[-r] + (tempY - ProtoTabletCenterY) * SinData[-r])/1024 + ProtoTabletCenterX + detailedShiftX;
			rY = (-(tempX-ProtoTabletCenterX) * SinData[-r] + (tempY - ProtoTabletCenterY) * CosData[-r])/1024 + ProtoTabletCenterY + detailedShiftY;
			}

			if(rX > 10 && rX < MAX_IMAGE_WIDTH - 10 && rY > 10 && rY < MAX_IMAGE_HEIGHT - 10)
			{
			tempAddress = MAX_IMAGE_WIDTH * rY + rX;
			matchingValue += GradientImage[tempAddress];
			matchingValue += GradientImage[tempAddress - 2];
			matchingValue += GradientImage[tempAddress + 2];
			matchingValue += GradientImage[tempAddress - 2 * MAX_IMAGE_WIDTH];
			matchingValue += GradientImage[tempAddress + 2 * MAX_IMAGE_WIDTH];
			}
			}

			if(matchingValue > reverseMaxMatchingValue)
			{
			reverseMaxMatchingValue = matchingValue;
			reverseAngle = r;
			}
			}
			}
			}
			*/

			ETCShape_ForwardProtoRotationAngle = forwardAngle;
			ETCShape_ReverseProtoRotationAngle = reverseAngle;

			if (forwardMaxMatchingValue > reverseMaxMatchingValue)
			{
				tabletETCShape_UpSideDownSW = 0;
				ProtoTabletRotationAngle = forwardAngle;
			}
			else
			{
				tabletETCShape_UpSideDownSW = 1;
				ProtoTabletRotationAngle = reverseAngle;
			}
		}
		else
		{
			{
				int xmax, ymax;
				int gradX, gradY;
				for (y = startY / 4 + 1, ymax = endY / 4 - 1; y < ymax; y++)
				{
					for (x = startX / 4 + 1, xmax = endX / 4 - 1; x < xmax; x++)
					{
						tempAddress = y * smallSizeImagWidth + x;
						gradX = abs(smallSizeOneColorImage[tempAddress + 1] - smallSizeOneColorImage[tempAddress - 1]);
						gradY = abs(smallSizeOneColorImage[tempAddress + smallSizeImagWidth] - smallSizeOneColorImage[tempAddress - smallSizeImagWidth]);
						smallSizeGradientImage[smallSizeImagWidth * (y) + x] = max(gradX, gradY);
					}
				}
			}
			short tempRotationShapePoint[3000][2];
			int matchingValue;
			int maxG = -1;
			int rotateX, rotateY;
			int i, j;
			for (r = 0; r < 720; r += 6)
			{
				matchingValue = 0;
				for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m += 3)
				{
					rotateX = ((CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) - SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterX;
					rotateY = ((SinData[r] * (TabletSetupData.FrontShapeEdgePoint[m][0] - halfImageWidth) + CosData[r] * (TabletSetupData.FrontShapeEdgePoint[m][1] - halfImageHeight)) / 1024) + ProtoTabletCenterY;
					rotateX /= 4;
					rotateY /= 4;
					tempRotationShapePoint[m][0] = rotateX;
					tempRotationShapePoint[m][1] = rotateY;
				}

				for (i = -2; i <= 2; i += 1)
				{
					for (j = -2; j <= 2; j += 1)
					{
						for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m += 3)
						{
							//if (tempRotationShapePoint[m][0] + j > 1 && tempRotationShapePoint[m][0] + j < smallSizeImagWidth - 1 && tempRotationShapePoint[m][1] + i > 1 && tempRotationShapePoint[m][1] + i < smallSizeImagHeight - 1) // б⸸ϹǷ ӵ ؼ  .
							{
								tempAddress = (tempRotationShapePoint[m][1] + i) * smallSizeImagWidth + (tempRotationShapePoint[m][0] + j);
								matchingValue += smallSizeGradientImage[tempAddress];
							}
						}
					}
				}
				if (maxG < (matchingValue))
				{
					maxG = (matchingValue);
					ProtoTabletRotationAngle = r;
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
void CalculateShapeShellData(int cameraIndex)
{
	int i, j, m, r, n, x, y, k;
	int edgeSW[8];
	int tempCX, tempCY;
	int pX, pY;
	int uLength;
	int sinV;
	int tempAddress;
	int tempAngle;
	int conversionM;
	int range;
	int areaValue;

	int directionX[8];
	int directionY[8];
	int NotAcceptableRange[10];
	int startAngle, endAngle;
	int rightMean, leftMean;
	int tempCount;
	int shellColorCount[4];

	directionX[0] = -1;
	directionY[0] = 0;

	directionX[1] = 1;
	directionY[1] = 0;

	directionX[2] = 0;
	directionY[2] = 1;

	directionX[3] = 0;
	directionY[3] = -1;

	directionX[4] = -1;
	directionY[4] = -1;

	directionX[5] = 1;
	directionY[5] = -1;

	directionX[6] = -1;
	directionY[6] = 1;

	directionX[7] = 1;
	directionY[7] = 1;
	tempCX = TabletMatchingResult.AdjustCenterXInImage;
	tempCY = TabletMatchingResult.AdjustCenterYInImage;

	range = TabletGradeData.frontShapeEdgeNeighborRange;

	for (n = 0; n < 10; n++)
	{
		NotAcceptableRange[n] = 1;
		if (n == PRINT_AREA || n == PRINT_NEIGHBOR_SHORT || n == PRINT_NEIGHBOR_LONG || n == FRONT_SHAPE_EDGE_AND_PRINT_SHORT || n == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
			NotAcceptableRange[n] = 0;
	}

	memset(ShapeShellGrayLebel, 0, sizeof(short) * SHAPE_SHELL_DEPTH * 360);
	memset(ShapeShellCountGrayLebel, 0, sizeof(unsigned char) * SHAPE_SHELL_DEPTH * 360);

	if (TabletGradeData.ETC_FrontFaceEdgeInspectionSW)
	{
		memset(tShellInspectionArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		memset(shellAvgColor, 0, sizeof(int) * 4);
		memset(shellColorCount, 0, sizeof(int) * 4);

		for (m = 0; m < ShapeShellDataCount[0]; m++)
		{
			j = ShapeShellData[0][m][0];
			i = ShapeShellData[0][m][1];

			tempAddress = MAX_IMAGE_WIDTH * i + j;

			tShellInspectionArea[tempAddress] = FRONT_SHAPE_FST_SHELL_AREA;
			shellAvgColor[0] += (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]) / 3;
			shellColorCount[0]++;
		}
	}

	int rmod;
	int nmax;
	for (r = 1; r <= range; r++)
	{
		edgeSW[0] = 0;
		edgeSW[1] = 0;
		edgeSW[2] = 0;
		edgeSW[3] = 0;
		edgeSW[4] = 0;
		edgeSW[5] = 0;
		edgeSW[6] = 0;
		edgeSW[7] = 0;
		rmod = (r & 1); // r % 2
		for (m = 0; m < ShapeShellDataCount[r - 1]; m++)
		{
			x = ShapeShellData[r - 1][m][0];
			y = ShapeShellData[r - 1][m][1];
			tempAddress = y * MAX_IMAGE_WIDTH + x;
			if (ShapeBinaryImage[tempAddress - 1] == 1 || ShapeBinaryImage[tempAddress - 1] == 2)
			{
				edgeSW[0] = 1;
			}
			if (ShapeBinaryImage[tempAddress + 1] == 1 || ShapeBinaryImage[tempAddress + 1] == 2)
			{
				edgeSW[1] = 2;
			}
			if (ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH] == 1 || ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH] == 2)
			{
				edgeSW[2] = 3;
			}
			if (ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH] == 1 || ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH] == 2)
			{
				edgeSW[3] = 4;
			}
			if (rmod == 0)
			{
				if (ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH - 1] == 1 || ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH - 1] == 2)
				{
					edgeSW[4] = 5;
				}
				if (ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH + 1] == 1 || ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH + 1] == 2)
				{
					edgeSW[5] = 6;
				}
				if (ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH - 1] == 1 || ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH - 1] == 2)
				{
					edgeSW[6] = 7;
				}
				if (ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH + 1] == 1 || ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH + 1] == 2)
				{
					edgeSW[7] = 8;
				}
			}
			
			for (n = 0, nmax = 8 / (rmod + 1); n < nmax; n++)
			{
				if (edgeSW[n])
				{
					i = y + directionY[edgeSW[n] - 1];
					j = x + directionX[edgeSW[n] - 1];
					edgeSW[n] = 0;
					if (ShapeShellDataCount[r] < 2000)
					{
						ShapeShellData[r][ShapeShellDataCount[r]][0] = j;
						ShapeShellData[r][ShapeShellDataCount[r]][1] = i;

						if (TabletGradeData.ETC_FrontFaceEdgeInspectionSW)
						{
							tempAddress = MAX_IMAGE_WIDTH * i + j;

							if (r == 1)
							{
								tShellInspectionArea[tempAddress] = FRONT_SHAPE_SEC_SHELL_AREA;
								shellAvgColor[1] += (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]) / 3;
								shellColorCount[1]++;
							}
							else if (r == 2)
							{
								tShellInspectionArea[tempAddress] = FRONT_SHAPE_TRD_SHELL_AREA;
								shellAvgColor[2] += (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]) / 3;
								shellColorCount[2]++;
							}
							else if (r == 3)
							{
								tShellInspectionArea[tempAddress] = FRONT_SHAPE_4TH_SHELL_AREA;
								shellAvgColor[3] += (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]) / 3;
								shellColorCount[3]++;
							}
						}

						pX = j - tempCX;
						pY = i - tempCY;
						uLength = pX * pX + pY * pY;
						if (uLength < 90000)
						{
							uLength = SqrtData[uLength]; // sqrtdata 128   .
							sinV = 1280000 * pX / uLength;
							if (sinV > 10000)
								sinV = 10000;
							if (pX >= 0 && pY <= 0)
								ShapeShellData[r][ShapeShellDataCount[r]][2] = ArcSinData[sinV];
							else if (pX >= 0 && pY > 0)
								ShapeShellData[r][ShapeShellDataCount[r]][2] = 180 - ArcSinData[sinV];

							else if (pX < 0 && pY > 0)
								ShapeShellData[r][ShapeShellDataCount[r]][2] = 180 + ArcSinData[-sinV];
							else
								ShapeShellData[r][ShapeShellDataCount[r]][2] = 360 - ArcSinData[-sinV];
						}
						ShapeShellDataCount[r]++;
						ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] = 3;
					}
				}
			}
		}
	}

	if (TabletGradeData.ETC_FrontFaceEdgeInspectionSW)
	{
		if (shellColorCount[0])
			shellAvgColor[0] /= shellColorCount[0];
		if (shellColorCount[1])
			shellAvgColor[1] /= shellColorCount[1];
		if (shellColorCount[2])
			shellAvgColor[2] /= shellColorCount[2];
		if (shellColorCount[3])
			shellAvgColor[3] /= shellColorCount[3];
	}

	for (r = 0; r <= range; r++)
	{
		for (m = 0; m < ShapeShellDataCount[r]; m++)
		{
			x = ShapeShellData[r][m][0];
			y = ShapeShellData[r][m][1];
			tempAddress = y * MAX_IMAGE_WIDTH + x;
			areaValue = (InspectionArea[tempAddress] > 9) ? 0 : InspectionArea[tempAddress];

			if (NotAcceptableRange[areaValue])
			{
				if (r < 2)
				{
					InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
				}
				else
				{
					InspectionArea[tempAddress] = FRONT_SHAPE_EDGE_NEIGHBOR;
				}
			}
			else
			{
				if (r >= 2)
				{
					if (areaValue == PRINT_NEIGHBOR_SHORT)
						InspectionArea[tempAddress] = FRONT_SHAPE_EDGE_AND_PRINT_SHORT;
					if (areaValue == PRINT_NEIGHBOR_LONG)
						InspectionArea[tempAddress] = FRONT_SHAPE_EDGE_AND_PRINT_LONG;
				}
			}
		}
	}

	/*    if(TabletGradeData.frontBorderIsSW == 1)
	{
	if(TabletGradeData.frontBorderIsSW == 1)
	{
	ShapeEdgeEmbossingErase();
	}
	for(r= 0; r <= range; r++)
	{
	for(m = 0 ; m < ShapeShellDataCount[r]; m++)
	{
	x = ShapeShellData[r][m][0];
	y = ShapeShellData[r][m][1];
	tempAngle = ShapeShellData[r][m][2];
	tempAddress = y*MAX_IMAGE_WIDTH + x;
	areaValue = InspectionArea[tempAddress]%10;
	if(NotAcceptableRange[areaValue])
	{
	ShapeShellGrayLebel[r][tempAngle] += OpenCloseResultImage[tempAddress];
	ShapeShellCountGrayLebel[r][tempAngle]++;
	}
	}
	}
	}
	else */
	{
		for (n = 0; n <= range; n++)
		{
			for (m = 0; m < ShapeShellDataCount[n]; m++)
			{
				x = ShapeShellData[n][m][0];
				y = ShapeShellData[n][m][1];
				tempAngle = ShapeShellData[n][m][2];
				tempAddress = y * MAX_IMAGE_WIDTH + x;
				areaValue = (InspectionArea[tempAddress] > 9) ? 0 : InspectionArea[tempAddress];

				if (NotAcceptableRange[areaValue])
				{
					// ShapeShellGrayLebel[n][tempAngle] += OneColorImage[tempAddress];
					// ShapeShellCountGrayLebel[n][ShapeShellData[n][m][2]] = ShapeShellCountGrayLebel[n][ShapeShellData[n][m][2]] + 1;
					ShapeShellGrayLebel[n][tempAngle] += OneColorImage[tempAddress];
					ShapeShellCountGrayLebel[n][tempAngle]++;
				}
			}
		}
	}
	for (n = 0; n <= range; n++)
	{
		for (m = 0; m < 360; m++)
		{
			if (ShapeShellCountGrayLebel[n][m])
			{
				ShapeShellGrayLebel[n][m] /= ShapeShellCountGrayLebel[n][m];
			}
		}
	}

	for (n = 0; n <= range; n++)
	{
		for (m = 0; m < 360; m++)
		{
			if (ShapeShellGrayLebel[n][m] == 0)
			{
				startAngle = m;
				endAngle = m + 1;
				for (k = m + 1; k < 360; k++)
				{
					if (ShapeShellGrayLebel[n][k])
					{
						endAngle = k;
						break;
					}
					else
					{
						endAngle = k + 1;
					}
				}

				tempCount = 0;
				leftMean = 0;
				for (k = startAngle - 4; k > startAngle - 90; k--)
				{
					conversionM = (k + 720) % 360;
					if (ShapeShellGrayLebel[n][conversionM])
					{
						leftMean += ShapeShellGrayLebel[n][conversionM];
						tempCount++;
						if (tempCount >= 5)
							break;
					}
				}
				leftMean /= 5;
				rightMean = 0;
				tempCount = 0;
				for (k = endAngle + 4; k < endAngle + 90; k++)
				{
					conversionM = (k + 720) % 360;
					if (ShapeShellGrayLebel[n][conversionM])
					{
						rightMean += ShapeShellGrayLebel[n][conversionM];
						tempCount++;
						if (tempCount >= 5)
							break;
					}
				}
				rightMean /= 5;

				for (k = startAngle; k < endAngle; k++)
				{
					ShapeShellGrayLebel[n][k] = (rightMean + leftMean) / 2;
				}
				m = endAngle;
			}
		}
	}
}
//---------------------------------------------------------------------------
void SetBrightnessAreaForPrintNeighbor(int cameraIndex)
{
	int brightAreaCheckSW;
	int symX, symY;
	int breakSW;
	int tabletColor;
	int x, y;
	int st_y, end_y, st_x, end_x;
	int tempAddress;
	int selfPositionValueAvg;
	int tempX, tempY;
	int tempAddress2;
	int colorDiff;

	st_x = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	end_x = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	st_y = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	end_y = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	if (st_x < 20)
		st_x = 20;
	if (end_x > MAX_IMAGE_WIDTH - 20)
		end_x = MAX_IMAGE_WIDTH - 20;
	if (st_y < 20)
		st_y = 20;
	if (end_y > MAX_IMAGE_HEIGHT - 20)
		end_y = MAX_IMAGE_HEIGHT - 20;

	//  ֺ  κ ũ
	brightAreaCheckSW = 0;
	if (TabletCharacter.discriminationDisplay_kind == STAMP && !TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm)
	{
		if (TabletCharacter.discriminationDisplay_num == ONE_FACE || TabletCharacter.discriminationDisplay_num == TWO_FACE_SAME)
		{
			if (PrintMatchingResult.dataNumberWithMaxValue > -1 && PrintMatchingResult.dataNumberWithMaxValue < 2)
			{
				brightAreaCheckSW = 1;
			}
		}
		else // diff
		{
			if (PrintMatchingResult.dataNumberWithMaxValue > -1)
			{
				brightAreaCheckSW = 1;
			}
		}
	}

	if (brightAreaCheckSW)
	{
		memcpy(TempImage2, BrightPixelNeighborPrint, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		memset(BrightPixelNeighborPrint, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

		for (y = st_y; y < end_y; y++)
		{
			for (x = st_x; x < end_x; x++)
			{
				tempAddress = MAX_IMAGE_WIDTH * y + x;

				if (InspectionArea[tempAddress] != PRINT_AREA)
				{
					if (InspectionArea[tempAddress - 4] == PRINT_AREA ||
						InspectionArea[tempAddress + 4] == PRINT_AREA ||
						InspectionArea[tempAddress - 4 * MAX_IMAGE_WIDTH] == PRINT_AREA ||
						InspectionArea[tempAddress + 4 * MAX_IMAGE_WIDTH] == PRINT_AREA ||
						InspectionArea[tempAddress - 4 * MAX_IMAGE_WIDTH - 4] == PRINT_AREA ||
						InspectionArea[tempAddress + 4 * MAX_IMAGE_WIDTH - 4] == PRINT_AREA ||
						InspectionArea[tempAddress - 4 * MAX_IMAGE_WIDTH + 4] == PRINT_AREA ||
						InspectionArea[tempAddress + 4 * MAX_IMAGE_WIDTH + 4] == PRINT_AREA)
					{
						if (TempImage2[tempAddress])
						{
							BrightPixelNeighborPrint[tempAddress] = 1;
						}
					}
				}
			}
		}

		/*
		memcpy(TempImage2, BrightPixelNeighborPrint, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		memset(BrightPixelNeighborPrint, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		for (y = st_y; y < end_y; y++)
		{
		  for (x = st_x; x < end_x; x++)
		  {
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if(TempImage2[tempAddress])
			{
			  breakSW = 0;
			  selfPositionValueAvg = OneColorImage[tempAddress];

			  for(tempY = y - 8; tempY <= y + 8; tempY += 2)
			  {
				for(tempX = x - 8; tempX <= x + 8; tempX += 2)
				{
				  tempAddress2 = MAX_IMAGE_WIDTH * tempY + tempX;

				  if(InspectionArea[tempAddress2] == PRINT_AREA)
				  {
					colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

					if(colorDiff > 8)
					{
					  symX = x + (x - tempX);
					  symY = y + (y - tempY);

					  tempAddress2 = MAX_IMAGE_WIDTH * symY + symX;

					  if(InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != PRINT_AREA)
					  {
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if(colorDiff > 8)
						{
						  BrightPixelNeighborPrint[tempAddress] = 1;
						  breakSW = 1;
						  break;
						}
					  }
					}
				  }
				}

				if(breakSW) break;
			  }
			}
		  }
		}
		*/
	}
	else
	{
		memset(BrightPixelNeighborPrint, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	}
}
//---------------------------------------------------------------------------
void removeBrightDot(int cameraIndex)
{
	int x, y;
	int tempAddress;
	int r;
	int startX, endX, startY, endY;
	int maxSearchRange;
	int maxColorDiff;
	int selfBValue, selfGValue, selfRValue;
	int tempAddress2;
	int BColorDiff, GColorDiff, RColorDiff;
	int DefectCount;
	int colorDiff;
	int defectThreshold;

	defectThreshold = 10;

	startX = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	endX = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	startY = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	endY = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	maxSearchRange = 16;

	memset(GradientImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionArea[tempAddress] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress])
			{
				DefectCount = 0;
				maxColorDiff = 0;

				selfBValue = ColorSourceImage[tempAddress * 3 + 0];
				selfGValue = ColorSourceImage[tempAddress * 3 + 1];
				selfRValue = ColorSourceImage[tempAddress * 3 + 2];

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				if (DefectCount < 1)
					continue;

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				if (DefectCount < 2)
					continue;

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH - r;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				if (DefectCount < 3)
					continue;

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH + r;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				if (DefectCount < 4)
					continue;

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH - r;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				if (DefectCount < 5)
					continue;

				for (r = maxSearchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH + r;

					if (InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress2])
					{
						BColorDiff = selfBValue - ColorSourceImage[tempAddress2 * 3 + 0];
						GColorDiff = selfGValue - ColorSourceImage[tempAddress2 * 3 + 1];
						RColorDiff = selfRValue - ColorSourceImage[tempAddress2 * 3 + 2];

						colorDiff = max(BColorDiff, max(GColorDiff, RColorDiff));

						if (colorDiff > defectThreshold)
						{
							DefectCount++;
							if (maxColorDiff < colorDiff)
								maxColorDiff = colorDiff;
							break;
						}
					}
				}

				if (DefectCount >= 6)
				{
					GradientImage[tempAddress] = 255;
				}
			}
		}
	}

	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (GradientImage[tempAddress])
			{
				InspectionArea[tempAddress] = FRONT_MASKING_AREA;
				InspectionArea[tempAddress - 1] = FRONT_MASKING_AREA;
				InspectionArea[tempAddress + 1] = FRONT_MASKING_AREA;
				InspectionArea[tempAddress - MAX_IMAGE_WIDTH] = FRONT_MASKING_AREA;
				InspectionArea[tempAddress + MAX_IMAGE_WIDTH] = FRONT_MASKING_AREA;
			}
		}
	}
}
//---------------------------------------------------------------------------
void FrontFaceShapeMatchingForEachCase(int option, int cameraIndex)
{
	int rotationTempPoint[2000][2];			
	short tempFrontShapeEdgePoint[2000][2];
	short tempFrontShapeEdgePointForAngle[4][1000][2];
	int tempFrontShapeEdgePointCountForAngle[4];
	int shapeEdgeMaskSize;	
	int startX, endX, startY, endY;
	unsigned char *setupShapeData;
		
	if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
	{
		setupShapeData = TabletSetupData.FrontshapeAreaData;
	}
	else
	{
		setupShapeData = TabletSetupData.FrontshapeAreaData2;
	}

	shapeEdgeMaskSize = 5;

	startX = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	endX = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	startY = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	endY = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	/////////////////////////////////////////////////////////////

	memset(tempFrontShapeEdgePointCountForAngle, 0, sizeof(int) * 4);
	memset(tempFrontShapeEdgePointForAngle, 0, sizeof(short) * 1000 * 2);
	memset(realBinaryArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);	

	if (!(TabletCharacter.shape == ETC && TabletCharacter.symmetric_line_count == ASYMMETRY_TABLET))
	{
		for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; ++m)
		{
			if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 >= 0 && (TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 < 180)
			{
				if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 3 == 0)
				{
					tempFrontShapeEdgePointForAngle[0][tempFrontShapeEdgePointCountForAngle[0]][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
					tempFrontShapeEdgePointForAngle[0][tempFrontShapeEdgePointCountForAngle[0]][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
					tempFrontShapeEdgePointCountForAngle[0]++;
				}
			}
			if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 >= 90 && (TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 < 270)
			{
				if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 3 == 0)
				{
					tempFrontShapeEdgePointForAngle[1][tempFrontShapeEdgePointCountForAngle[1]][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
					tempFrontShapeEdgePointForAngle[1][tempFrontShapeEdgePointCountForAngle[1]][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
					tempFrontShapeEdgePointCountForAngle[1]++;
				}
			}
			if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 >= 180 && (TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 < 360)
			{
				if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 3 == 0)
				{
					tempFrontShapeEdgePointForAngle[2][tempFrontShapeEdgePointCountForAngle[2]][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
					tempFrontShapeEdgePointForAngle[2][tempFrontShapeEdgePointCountForAngle[2]][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
					tempFrontShapeEdgePointCountForAngle[2]++;
				}
			}
			if (((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 >= 270 && (TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 < 360) || ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 >= 0 && (TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 360 < 90))
			{
				if ((TabletSetupData.FrontShapeEdgePoint[m][2] + ProtoTabletRotationAngle / 2) % 3 == 0)
				{
					tempFrontShapeEdgePointForAngle[3][tempFrontShapeEdgePointCountForAngle[3]][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
					tempFrontShapeEdgePointForAngle[3][tempFrontShapeEdgePointCountForAngle[3]][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
					tempFrontShapeEdgePointCountForAngle[3]++;
				}
			}
		}

		for (int m = 0; m < 2000; ++m)
		{
			tempFrontShapeEdgePoint[m][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
			tempFrontShapeEdgePoint[m][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
		}
	}
	else
	{
		if (tabletETCShape_UpSideDownSW)
		{
			for (int m = 0; m < 2000; ++m)
			{
				tempFrontShapeEdgePoint[m][0] = MAX_IMAGE_WIDTH - TabletSetupData.FrontShapeEdgePoint[m][0];
				tempFrontShapeEdgePoint[m][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
			}
		}
		else
		{
			for (int m = 0; m < 2000; ++m)
			{
				tempFrontShapeEdgePoint[m][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
				tempFrontShapeEdgePoint[m][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
			}
		}
	}

	int shiftSize = SHAPE_MATCHING_RANGE;
	int rotationRange = ACCEPTABLE_ROTATION_RANGE;

	if (option == CASE1) // Ϲ   x,y Ī
	{
		TabletMatchingResult.AdjustCenterXInImage = ProtoTabletCenterX;
		TabletMatchingResult.AdjustCenterYInImage = ProtoTabletCenterY;

		{		
			int tempShiftXForAngleRange[4];
			int tempShiftYForAngleRange[4];
			int tempTabletRotationAngleForAngleRange[4];
			int maxMatchingValue[4];

			{
				int i, j, m, n;
				int shiftSizeTemp = shiftSize;
				int ProtoTabletCenterXTemp = ProtoTabletCenterX;
				int ProtoTabletCenterYTemp = ProtoTabletCenterY;
				int maxG = -1;
				int matchingValue;
				int tempX, tempY;
				short (*tempFrontShapeEdgePointForAngleTemp)[1000][2] = tempFrontShapeEdgePointForAngle;
				int cnt;
				for (n = 0; n < 4; n++)
				{
					maxG = -1;
					tempShiftXForAngleRange[n] = 0;
					tempShiftYForAngleRange[n] = 0;
					tempTabletRotationAngleForAngleRange[n] = 0;
					cnt = tempFrontShapeEdgePointCountForAngle[n];
					for (i = -shiftSizeTemp; i <= shiftSizeTemp; i += 2)
					{
						for (j = -shiftSizeTemp; j <= shiftSizeTemp; j += 2)
						{
							matchingValue = 0;
							for (m = 0; m < cnt; m += 4)
							{
								tempX = tempFrontShapeEdgePointForAngleTemp[n][m][0] + (ProtoTabletCenterXTemp - HALF_IMAGE_WIDTH) + j;
								tempY = tempFrontShapeEdgePointForAngleTemp[n][m][1] + (ProtoTabletCenterYTemp - HALF_IMAGE_HEIGHT) + i;

								//if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10) // б⸸ϹǷ ӵ ؼ  .
									matchingValue += (GradientImage[tempY * MAX_IMAGE_WIDTH + tempX]);
							}
							if (maxG < (matchingValue))
							{
								maxG = (matchingValue);
								tempShiftXForAngleRange[n] = j;
								tempShiftYForAngleRange[n] = i;
							}
						}
					}
				}
			}

			TabletMatchingResult.TabletRotationAngle = 0;
			TabletMatchingResult.AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage + (2 * tempShiftXForAngleRange[0] + tempShiftXForAngleRange[1] + 2 * tempShiftXForAngleRange[2] + tempShiftXForAngleRange[3]) / 6;
			TabletMatchingResult.AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage + (tempShiftYForAngleRange[0] + 2 * tempShiftYForAngleRange[1] + tempShiftYForAngleRange[2] + 2 * tempShiftYForAngleRange[3]) / 6;
		}

		if (TabletGradeData.RemoveBeltActive) //   ĿƮ. Ʈ     
		{
			memset(ShapeBinaryImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		}

		////////ʹ  ҷ ȭ ȵż  ä ֱ 
		{
			int i, j;
			int tempAddress;
			int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
			int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
			int tempX, tempY;
			int startXTemp = startX;
			int endXTemp = endX;
			int startYTemp = startY;
			int endYTemp = endY;
			unsigned char *setupShapeDataTemp = setupShapeData;
			for (i = startYTemp; i < endYTemp; i++)
			{
				for (j = startXTemp; j < endXTemp; j++)
				{
					tempX = j + HALF_IMAGE_WIDTH - AdjustCenterXInImage;
					tempY = i + HALF_IMAGE_HEIGHT - AdjustCenterYInImage;

					if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10 &&
						setupShapeDataTemp[HALF_IMAGE_WIDTH * (tempY / 2) + (tempX / 2)])
					{
						tempAddress = MAX_IMAGE_WIDTH * i + j;
						ShapeBinaryImage[tempAddress] = 1;
						realBinaryArea[tempAddress] = 1;
					}
				}
			}
		}

		FindRealBinaryData(option, cameraIndex);

		{
			int i, j;
			int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage; // FindRealBinaryData() ߽ ¦ ̵  ִ.
			int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
			int tempX, tempY;
			int startXTemp = startX;
			int endXTemp = endX;
			int startYTemp = startY;
			int endYTemp = endY;
			unsigned char *setupShapeDataTemp = setupShapeData;
			for (i = startYTemp; i < endYTemp; i++)
			{
				for (j = startXTemp; j < endXTemp; j++)
				{
					tempX = j + HALF_IMAGE_WIDTH - AdjustCenterXInImage;
					tempY = i + HALF_IMAGE_HEIGHT - AdjustCenterYInImage;

					if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10 &&
						setupShapeDataTemp[HALF_IMAGE_WIDTH * (tempY / 2) + (tempX / 2)])
					{
						InspectionArea[MAX_IMAGE_WIDTH * i + j] = NORMAL_INPECTION_AREA;
					}
				}
			}
		}

		{
			int i, j, m;
			int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
			int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
			int tempX, tempY;
			int shapeEdgeMaskSizeTemp = shapeEdgeMaskSize;
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempX = tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH + AdjustCenterXInImage;
				tempY = tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT + AdjustCenterYInImage;
				for (i = tempY - shapeEdgeMaskSizeTemp; i <= tempY + shapeEdgeMaskSizeTemp; i++)
				{
					for (j = tempX - shapeEdgeMaskSizeTemp; j <= tempX + shapeEdgeMaskSizeTemp; j++)
					{
						if (j > 10 && j < MAX_IMAGE_WIDTH - 10 && i > 10 && i < MAX_IMAGE_HEIGHT - 10)
							InspectionArea[MAX_IMAGE_WIDTH * i + j] = 0;
					}
				}
			}
		}

		//   ///////
		if (TabletCharacter.middle_height != 0 && TabletCharacter.shape != ROUND)
		{
			FindTortionAngleInFrontFace(cameraIndex);
		}
		else
		{
			TabletMatchingResult.TabletFrontShapeXTotion = 0;
			TabletMatchingResult.TabletFrontShapeYTotion = 0;
		}
	}
	else if (option == CASE2) // , ٰ  .
	{
		TabletMatchingResult.AdjustCenterXInImage = ProtoTabletCenterX;
		TabletMatchingResult.AdjustCenterYInImage = ProtoTabletCenterY;

		if (!(TabletCharacter.shape == ETC && TabletCharacter.symmetric_line_count == ASYMMETRY_TABLET)) // Ī Ÿ  ƴ .
		{
			unsigned char *MultiLayerTabletEraseArea = TempImage2;
			int addShiftSizeForMultiLayerTablet = 0;
			int binaryRemoveSW = 0;
			if (ProcessingModeGlobal == INSPECTION_MODE && TabletCharacter.tabletLayerCount == 2)
			{
				int frontColor[3];
				int rearColor[3];
				if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
				{
					frontColor[0] = TabletStudyData.tabletColorB_ForCamera1;
					frontColor[1] = TabletStudyData.tabletColorG_ForCamera1;
					frontColor[2] = TabletStudyData.tabletColorR_ForCamera1;

					rearColor[0] = TabletStudyData.tabletRearColorB_ForCamera1;
					rearColor[1] = TabletStudyData.tabletRearColorG_ForCamera1;
					rearColor[2] = TabletStudyData.tabletRearColorR_ForCamera1;
				}
				else
				{
					frontColor[0] = TabletStudyData.tabletColorB_ForCamera9;
					frontColor[1] = TabletStudyData.tabletColorG_ForCamera9;
					frontColor[2] = TabletStudyData.tabletColorR_ForCamera9;

					rearColor[0] = TabletStudyData.tabletRearColorB_ForCamera9;
					rearColor[1] = TabletStudyData.tabletRearColorG_ForCamera9;
					rearColor[2] = TabletStudyData.tabletRearColorR_ForCamera9;
				}

				int frontColorValue = frontColor[selectedRGB];
				int rearColorValue = rearColor[selectedRGB];

				if (frontColorValue > rearColorValue && SelectedFace == REAR_FACE_FOR_COLOR)
				{
					binaryRemoveSW = 1;
					addShiftSizeForMultiLayerTablet = 16;
				}
				else if (frontColorValue < rearColorValue && SelectedFace == FRONT_FACE_FOR_COLOR)
				{
					binaryRemoveSW = 1;
					addShiftSizeForMultiLayerTablet = 16;
				}
			}

			if (binaryRemoveSW)
			{
				// ī޶󿡼  ̴ κ ϴ process
				//   ī޶ Ե   ο    ƿõǾ  ̴   κ   

				//   Ȯ  
				int tabletSideFaceCheckAreaSize = 28;
				memset(TempImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
				{
					int x, y, r;
					int tempAddress;
					int startXTemp = startX;
					int endXTemp = endX;
					int startYTemp = startY;
					int endYTemp = endY;
					for (y = startYTemp; y < endYTemp; y++)
					{
						for (x = startXTemp; x < endXTemp; x++)
						{
							tempAddress = MAX_IMAGE_WIDTH * y + x;
							if (ShapeBinaryImage[tempAddress])
							{
								for (r = tabletSideFaceCheckAreaSize; r >= 0; r -= 4)
								{
									if (y - r > startY && ShapeBinaryImage[tempAddress - r * MAX_IMAGE_WIDTH] == 0)
									{
										TempImage[tempAddress] = 1;
										break;
									}
									if (y + r < endY && ShapeBinaryImage[tempAddress + r * MAX_IMAGE_WIDTH] == 0)
									{
										TempImage[tempAddress] = 1;
										break;
									}
								}
							}
						}
					}
				}
				// layerData 
				memcpy(TempImage2, TempImage, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
				memset(TempImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

				int topLayerLengthCount[30];
				int bottomLayerLengthCount[30];
				memset(topLayerLengthCount, 0, sizeof(int) * 30);
				memset(bottomLayerLengthCount, 0, sizeof(int) * 30);
				
				{					
					int x, y, r;
					int tempAddress;
					int startXTemp = startX;
					int endXTemp = endX;
					int startYTemp = startY;
					int endYTemp = endY;
					int layerN = 1;
					for (r = 1; r <= tabletSideFaceCheckAreaSize; r++)
					{
						for (x = startXTemp; x < endXTemp; x++)
						{
							for (y = startYTemp; y < ProtoTabletCenterY; y++)
							{
								tempAddress = MAX_IMAGE_WIDTH * y + x;
								if (TempImage2[tempAddress] && TempImage[tempAddress] == 0)
								{
									TempImage[tempAddress] = layerN;
									topLayerLengthCount[layerN]++;
									break;
								}
							}
						}

						layerN++;
					}
				}
				
				{					
					int x, y, r;
					int tempAddress;
					int startXTemp = startX;
					int endXTemp = endX;
					int startYTemp = startY;
					int endYTemp = endY;
					int layerN = 1;
					for (r = 1; r <= tabletSideFaceCheckAreaSize; r++)
					{
						for (x = startXTemp; x < endXTemp; x++)
						{
							for (y = endYTemp - 1; y > ProtoTabletCenterY; y--)
							{
								tempAddress = MAX_IMAGE_WIDTH * y + x;
								if (TempImage2[tempAddress] && TempImage[tempAddress] == 0)
								{
									TempImage[tempAddress] = layerN;
									bottomLayerLengthCount[layerN]++;
									break;
								}
							}
						}

						layerN++;
					}
				}

				//       κ üũ								
				memset(MultiLayerTabletEraseArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
				{
					int x, y, r;
					int tempAddress;
					int startXTemp = startX;
					int endXTemp = endX;
					int startYTemp = startY;
					int endYTemp = endY;
					int threshold = 10;
					int srcColor;
					int topSW, bottomSW;
					for (y = startYTemp; y < endYTemp; y++)
					{
						for (x = startXTemp; x < endXTemp; x++)
						{
							tempAddress = MAX_IMAGE_WIDTH * y + x;
							if (TempImage[tempAddress])
							{
								topSW = bottomSW = 0;
								srcColor = OneColorImage[tempAddress];

								if (y < ProtoTabletCenterY)
								{
									for (r = tabletSideFaceCheckAreaSize; r >= 4; r -= 4)
									{
										if (y - r > startY && srcColor - OneColorImage[tempAddress - r * MAX_IMAGE_WIDTH] > threshold)
										{
											topSW = 1;
											break;
										}
									}

									if (topSW)
									{
										for (r = tabletSideFaceCheckAreaSize; r >= 4; r -= 4)
										{
											if (y + r < endY && TempImage[tempAddress + r * MAX_IMAGE_WIDTH] && srcColor - OneColorImage[tempAddress + r * MAX_IMAGE_WIDTH] > threshold)
											{
												bottomSW = 1;
												break;
											}
										}
									}
								}
								else
								{
									for (r = tabletSideFaceCheckAreaSize; r >= 4; r -= 4)
									{
										if (y + r < endY && srcColor - OneColorImage[tempAddress + r * MAX_IMAGE_WIDTH] > threshold)
										{
											bottomSW = 1;
											break;
										}
									}

									if (bottomSW)
									{
										for (r = tabletSideFaceCheckAreaSize; r >= 4; r -= 4)
										{
											if (y - r > startY && TempImage[tempAddress - r * MAX_IMAGE_WIDTH] && srcColor - OneColorImage[tempAddress - r * MAX_IMAGE_WIDTH] > threshold)
											{
												topSW = 1;
												break;
											}
										}
									}
								}

								if (topSW && bottomSW)
								{
									MultiLayerTabletEraseArea[tempAddress] = 1;
								}
							}
						}
					}
				}

				// error check
				int topErrorLayerLengthCount[30];
				int bottomErrorLayerLengthCount[30];
				memset(topErrorLayerLengthCount, 0, sizeof(int) * 30);
				memset(bottomErrorLayerLengthCount, 0, sizeof(int) * 30);

				{
					int x, y;
					int tempAddress;
					int startXTemp = startX;
					int endXTemp = endX;
					int startYTemp = startY;
					int endYTemp = endY;
					int layerN = 1;
					for (y = startYTemp; y < endYTemp; y++)
					{
						for (x = startXTemp; x < endXTemp; x++)
						{
							tempAddress = MAX_IMAGE_WIDTH * y + x;
							if (MultiLayerTabletEraseArea[tempAddress])
							{
								layerN = TempImage[tempAddress];

								if (y < ProtoTabletCenterY)
								{
									topErrorLayerLengthCount[layerN]++;									
								}
								else
								{
									bottomErrorLayerLengthCount[layerN]++;									
								}
							}
						}
					}
				}

				int topErrorCount;
				int bottomErrorCount;
				int topMaxEraseLayer;
				int bottomMaxEraseLayer;
				topMaxEraseLayer = bottomMaxEraseLayer = 0;
				topErrorCount = bottomErrorCount = 0;
				for (int r = 1; r <= tabletSideFaceCheckAreaSize; r++)
				{
					if (topErrorLayerLengthCount[r] > topLayerLengthCount[r] * 50 / 100)
					{
						topErrorCount++;

						if (topMaxEraseLayer < r)
						{
							topMaxEraseLayer = r;
						}
					}

					if (bottomErrorLayerLengthCount[r] > bottomLayerLengthCount[r] * 50 / 100)
					{
						bottomErrorCount++;

						if (bottomMaxEraseLayer < r)
						{
							bottomMaxEraseLayer = r;
						}
					}
				}

				int maxLayerPosition[MAX_IMAGE_WIDTH];

				memset(MultiLayerTabletEraseArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
				memset(maxLayerPosition, 0, sizeof(int) * MAX_IMAGE_WIDTH);

				if (topErrorCount || bottomErrorCount)
				{
					if (topErrorCount > bottomErrorCount)
					{
						int x, y;
						int tempAddress;
						int startXTemp = startX;
						int endXTemp = endX;
						int startYTemp = startY;
						int endYTemp = endY;
						for (x = startXTemp; x < endXTemp; x++)
						{
							for (y = startYTemp; y < ProtoTabletCenterY; y++)
							{
								tempAddress = MAX_IMAGE_WIDTH * y + x;
								if (TempImage[tempAddress] <= topMaxEraseLayer && TempImage[tempAddress])
								{
									MultiLayerTabletEraseArea[tempAddress] = 1;

									if (TempImage[tempAddress] == topMaxEraseLayer)
									{
										maxLayerPosition[x] = y;
									}
								}
							}
						}

						for (x = startXTemp; x < endXTemp; x++)
						{
							if (maxLayerPosition[x])
							{
								for (y = startYTemp; y <= maxLayerPosition[x]; y++)
								{
									tempAddress = MAX_IMAGE_WIDTH * y + x;
									GradientImage[tempAddress] = 0;
								}
							}
						}
					}
					else
					{
						int x, y;
						int tempAddress;
						int startXTemp = startX;
						int endXTemp = endX;
						int startYTemp = startY;
						int endYTemp = endY;
						for (x = startXTemp; x < endXTemp; x++)
						{
							for (y = endYTemp - 1; y > ProtoTabletCenterY; y--)
							{
								tempAddress = MAX_IMAGE_WIDTH * y + x;
								if (TempImage[tempAddress] <= bottomMaxEraseLayer && TempImage[tempAddress])
								{
									MultiLayerTabletEraseArea[tempAddress] = 1;

									if (TempImage[tempAddress] == bottomMaxEraseLayer)
									{
										maxLayerPosition[x] = y;
									}
								}
							}
						}

						for (x = startXTemp; x < endXTemp; x++)
						{
							if (maxLayerPosition[x])
							{
								for (y = endYTemp - 1; y >= maxLayerPosition[x]; y--)
								{
									tempAddress = MAX_IMAGE_WIDTH * y + x;
									GradientImage[tempAddress] = 0;
								}
							}
						}
					}
				}
			}

			{
				int tempShiftXForAngleRange[4];
				int tempShiftYForAngleRange[4];
				int tempTabletRotationAngleForAngleRange[4];
				int maxMatchingValue[4];

				{
					int i, j, m, n, r;
					int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
					int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
					int addShiftSizeForMultiLayerTabletTemp = addShiftSizeForMultiLayerTablet;
					int maxG = -1;
					int matchingValue;
					int (*rotationTempPointTemp)[2] = rotationTempPoint;
					short (*tempFrontShapeEdgePointForAngleTemp)[1000][2] = tempFrontShapeEdgePointForAngle;
					int tempX, tempY;
					int tempR;
					int cnt;
					for (n = 0; n < 4; n++)
					{
						maxG = -1;
						maxMatchingValue[n] = 0;
						tempShiftXForAngleRange[n] = 0;
						tempShiftYForAngleRange[n] = 0;
						tempTabletRotationAngleForAngleRange[n] = 0;
						cnt = tempFrontShapeEdgePointCountForAngle[n];
						for (r = -rotationRange + ProtoTabletRotationAngle; r <= rotationRange + ProtoTabletRotationAngle; r += 2)
						{
							tempR = (r + 720) % 720;

							int cosValue, sinValue;
							if (tempR >= 0)
							{
								sinValue = SinData[tempR];
								cosValue = CosData[tempR];
							}
							else
							{
								sinValue = -SinData[-tempR];
								cosValue = CosData[-tempR];
							}

							for (m = 0; m < cnt; m++)
							{
								rotationTempPointTemp[m][0] = ((cosValue * (tempFrontShapeEdgePointForAngleTemp[n][m][0] - HALF_IMAGE_WIDTH) - sinValue * (tempFrontShapeEdgePointForAngleTemp[n][m][1] - HALF_IMAGE_HEIGHT)) / 1024) + AdjustCenterXInImage;
								rotationTempPointTemp[m][1] = ((sinValue * (tempFrontShapeEdgePointForAngleTemp[n][m][0] - HALF_IMAGE_WIDTH) + cosValue * (tempFrontShapeEdgePointForAngleTemp[n][m][1] - HALF_IMAGE_HEIGHT)) / 1024) + AdjustCenterYInImage;
							}
							for (i = -shiftSize - addShiftSizeForMultiLayerTabletTemp; i <= shiftSize + addShiftSizeForMultiLayerTabletTemp; i += 2)
							{
								for (j = -shiftSize; j <= shiftSize; j += 2)
								{
									matchingValue = 0;
									for (m = 0; m < cnt; m += 2) // HEXA    ʹ ̸ Ȯ  ־ 2 ǳ .
									{
										tempX = rotationTempPointTemp[m][0] + j;
										tempY = rotationTempPointTemp[m][1] + i;

										//if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10) // б⸸ϹǷ ӵ ؼ  .
											matchingValue += (GradientImage[tempY * MAX_IMAGE_WIDTH + tempX]);
									}
									if (maxG < (matchingValue))
									{
										maxG = (matchingValue);
										maxMatchingValue[n] = maxG * 1024 / cnt;
										tempShiftXForAngleRange[n] = j;
										tempShiftYForAngleRange[n] = i;
										tempTabletRotationAngleForAngleRange[n] = tempR;
									}
								}
							}
						}
					}
				}

				int sum = 0;
				int baseAngle = tempTabletRotationAngleForAngleRange[0];
				int angleDiff = tempTabletRotationAngleForAngleRange[1] - baseAngle;
				if (angleDiff > 360)
					angleDiff -= 720;
				if (angleDiff < -360)
					angleDiff += 720;
				sum += angleDiff * maxMatchingValue[1];
				angleDiff = tempTabletRotationAngleForAngleRange[2] - baseAngle;
				if (angleDiff > 360)
					angleDiff -= 720;
				if (angleDiff < -360)
					angleDiff += 720;
				sum += angleDiff * maxMatchingValue[2];
				angleDiff = tempTabletRotationAngleForAngleRange[3] - baseAngle;
				if (angleDiff > 360)
					angleDiff -= 720;
				if (angleDiff < -360)
					angleDiff += 720;
				sum += angleDiff * maxMatchingValue[3];
				TabletMatchingResult.TabletRotationAngle = baseAngle + sum / (maxMatchingValue[0] + maxMatchingValue[1] + maxMatchingValue[2] + maxMatchingValue[3]);
				TabletMatchingResult.TabletRotationAngle = (TabletMatchingResult.TabletRotationAngle + 720) % 720;

				TabletMatchingResult.AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage +
															(tempShiftXForAngleRange[0] * maxMatchingValue[0] + tempShiftXForAngleRange[1] * maxMatchingValue[1] + tempShiftXForAngleRange[2] * maxMatchingValue[2] + tempShiftXForAngleRange[3] * maxMatchingValue[3]) / (maxMatchingValue[0] + maxMatchingValue[1] + maxMatchingValue[2] + maxMatchingValue[3]);
				TabletMatchingResult.AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage +
															(tempShiftYForAngleRange[0] * maxMatchingValue[0] + tempShiftYForAngleRange[1] * maxMatchingValue[1] + tempShiftYForAngleRange[2] * maxMatchingValue[2] + tempShiftYForAngleRange[3] * maxMatchingValue[3]) / (maxMatchingValue[0] + maxMatchingValue[1] + maxMatchingValue[2] + maxMatchingValue[3]);
			}

			int constCosV, constSinV;
			if (TabletMatchingResult.TabletRotationAngle > 0)
			{
				constCosV = CosData[TabletMatchingResult.TabletRotationAngle];
				constSinV = SinData[TabletMatchingResult.TabletRotationAngle];
			}
			else
			{
				constCosV = CosData[-TabletMatchingResult.TabletRotationAngle];
				constSinV = -SinData[-TabletMatchingResult.TabletRotationAngle];
			}

			memset(transformFrontShapeEdgePoint, 0, sizeof(short) * 2000 * 2);
			{			
				int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
				int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
				int rotateX, rotateY;

				for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
				{
					rotateX = (constCosV * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) - constSinV * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
					rotateY = (constSinV * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) + constCosV * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

					transformFrontShapeEdgePoint[m][0] = rotateX;
					transformFrontShapeEdgePoint[m][1] = rotateY;
				}
			}			

			if (TabletGradeData.RemoveBeltActive || binaryRemoveSW)
			{
				memset(ShapeBinaryImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
			}

			{
				int i, j, i2, j2;
				int tempAddress;
				int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
				int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
				int tempX, tempY;
				unsigned char *setupShapeDataTemp = setupShapeData;
				for (i = 1, i2 = i / 2; i < ImageHeight - 1; ++i, ((i & 1) == 0 && ++i2))				
				{
					for (j = 1, j2 = j / 2; j < ImageWidth - 1; ++j, ((j & 1) == 0 && ++j2))					
					{
						if (setupShapeDataTemp[HALF_IMAGE_WIDTH * i2 + j2])						
						{
							tempX = (constCosV * (j - HALF_IMAGE_WIDTH) - constSinV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
							tempY = (constSinV * (j - HALF_IMAGE_WIDTH) + constCosV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

							if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10)
							{
								tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
								ShapeBinaryImage[tempAddress] = 1;
								ShapeBinaryImage[tempAddress + 1] = 1; // ȸ       . +1 ġ ä.

								realBinaryArea[tempAddress] = 1;
								realBinaryArea[tempAddress + 1] = 1;
							}
						}
					}
				}
			}

			if (binaryRemoveSW)
			{
				int x, y;
				int tempAddress;
				int startXTemp = startX;
				int endXTemp = endX;
				int startYTemp = startY;
				int endYTemp = endY;
				for (y = startYTemp; y < endYTemp; y++)
				{
					for (x = startXTemp; x < endXTemp; x++)
					{
						tempAddress = MAX_IMAGE_WIDTH * y + x;
						if (MultiLayerTabletEraseArea[tempAddress])
						{
							ShapeBinaryImage[tempAddress] = 0;
							ShapeBinaryImage[tempAddress + 1] = 0; // ȸ       . +1 ġ ä.

							realBinaryArea[tempAddress] = 0;
							realBinaryArea[tempAddress + 1] = 0;
						}
					}
				}
				FindRealBinaryData(CASE3, cameraIndex);
			}
			else
			{
				FindRealBinaryData(option, cameraIndex);
			}

			{
				int x, y, i, j, i2, j2;
				int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
				int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;				
				int tempX, tempY;
				unsigned char *setupShapeDataTemp = setupShapeData;
				for (i = 1, i2 = i / 2; i < ImageHeight - 1; ++i, ((i & 1) == 0 && ++i2))				
				{
					for (j = 1, j2 = j / 2; j < ImageWidth - 1; ++j, ((j & 1) == 0 && ++j2))					
					{
						if (setupShapeDataTemp[HALF_IMAGE_WIDTH * i2 + j2])						
						{
							tempX = (constCosV * (j - HALF_IMAGE_WIDTH) - constSinV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
							tempY = (constSinV * (j - HALF_IMAGE_WIDTH) + constCosV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

							if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10 && 
								ShapeBinaryImage[MAX_IMAGE_WIDTH * tempY + tempX])
							{
								for (y = tempY - 1; y <= tempY + 1; y++)
								{
									for (x = tempX - 1; x <= tempX + 1; x++)
									{
										InspectionArea[MAX_IMAGE_WIDTH * y + x] = NORMAL_INPECTION_AREA;
									}
								}
							}
						}
					}
				}
			}

			{
				int i, j, m;
				int rotateX, rotateY;
				int shapeEdgeMaskSizeTemp = shapeEdgeMaskSize;
				for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
				{
					rotateX = transformFrontShapeEdgePoint[m][0];
					rotateY = transformFrontShapeEdgePoint[m][1];

					for (i = rotateY - shapeEdgeMaskSizeTemp; i <= rotateY + shapeEdgeMaskSizeTemp; i++)
					{
						for (j = rotateX - shapeEdgeMaskSizeTemp; j <= rotateX + shapeEdgeMaskSizeTemp; j++)
						{
							if (j > 10 && j < MAX_IMAGE_WIDTH - 10 && i > 10 && i < MAX_IMAGE_HEIGHT - 10)
								InspectionArea[MAX_IMAGE_WIDTH * i + j] = 0;
						}
					}
				}
			}

			//   ///////
			if (TabletCharacter.middle_height != 0)
			{
				FindTortionAngleInFrontFace(cameraIndex);
			}
			else
			{
				TabletMatchingResult.TabletFrontShapeXTotion = 0;
				TabletMatchingResult.TabletFrontShapeYTotion = 0;
			}
		}
		else
		{	
			{
				int adjustAngle;
				int shiftX, shiftY;	
				{
					int maxG = -1;
					int matchingValue;
					int tempR;
					int cosValue, sinValue;
					int (*rotationTempPointTemp)[2] = rotationTempPoint;
					for (int r = -rotationRange + ProtoTabletRotationAngle; r <= rotationRange + ProtoTabletRotationAngle; r += 2)
					{
						tempR = (r + 720) % 720;
						
						if (tempR >= 0)
						{
							sinValue = SinData[tempR];
							cosValue = CosData[tempR];
						}
						else
						{
							sinValue = -SinData[-tempR];
							cosValue = CosData[-tempR];
						}

						int i, j, m;
						int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
						int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
						int tempX, tempY;
						int cnt = TabletSetupData.FrontShapeEdgePointCount;
						for (m = 0; m < cnt; m++)
						{
							rotationTempPointTemp[m][0] = ((cosValue * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) - sinValue * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024) + AdjustCenterXInImage;
							rotationTempPointTemp[m][1] = ((sinValue * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) + cosValue * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024) + AdjustCenterYInImage;
						}
						for (i = -shiftSize; i <= shiftSize; i += 2)
						{
							for (j = -shiftSize; j <= shiftSize; j += 2)
							{
								matchingValue = 0;
								for (m = 0; m < cnt; m += 2)
								{
									tempX = rotationTempPointTemp[m][0] + j;
									tempY = rotationTempPointTemp[m][1] + i;

									//if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10) // б⸸ϹǷ ӵ ؼ  .
										matchingValue += (GradientImage[tempY * MAX_IMAGE_WIDTH + tempX]);
								}
								if (maxG < matchingValue)
								{
									maxG = (matchingValue);
									shiftX = j;
									shiftY = i;

									adjustAngle = tempR;
								}
							}
						}
					}
				}

				TabletMatchingResult.TabletRotationAngle = (adjustAngle + 720) % 720;

				TabletMatchingResult.AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage + shiftX;
				TabletMatchingResult.AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage + shiftY;
			}

			int constCosV, constSinV;
			if (TabletMatchingResult.TabletRotationAngle > 0)
			{
				constCosV = CosData[TabletMatchingResult.TabletRotationAngle];
				constSinV = SinData[TabletMatchingResult.TabletRotationAngle];
			}
			else
			{
				constCosV = CosData[-TabletMatchingResult.TabletRotationAngle];
				constSinV = -SinData[-TabletMatchingResult.TabletRotationAngle];
			}

			memset(transformFrontShapeEdgePoint, 0, sizeof(short) * 2000 * 2);
			{
				int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
				int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
				int rotateX, rotateY;
				for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
				{
					rotateX = (constCosV * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) - constSinV * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
					rotateY = (constSinV * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) + constCosV * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

					transformFrontShapeEdgePoint[m][0] = rotateX;
					transformFrontShapeEdgePoint[m][1] = rotateY;
				}
			}

			if (TabletGradeData.RemoveBeltActive)
			{
				memset(ShapeBinaryImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
			}

			if (!tabletETCShape_UpSideDownSW)
			{
				{
					int i, j, i2, j2;
					int tempAddress;
					int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
					int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
					int tempX, tempY;
					unsigned char *setupShapeDataTemp = setupShapeData;
					for (i = 1, i2 = i / 2; i < ImageHeight - 1; ++i, ((i & 1) == 0 && ++i2))
					{
						for (j = 1, j2 = j / 2; j < ImageWidth - 1; ++j, ((j & 1) == 0 && ++j2))
						{
							if (setupShapeDataTemp[HALF_IMAGE_WIDTH * i2 + j2])						
							{
								tempX = (constCosV * (j - HALF_IMAGE_WIDTH) - constSinV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
								tempY = (constSinV * (j - HALF_IMAGE_WIDTH) + constCosV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

								if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10)
								{
									tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
									ShapeBinaryImage[tempAddress] = 1;
									ShapeBinaryImage[tempAddress + 1] = 1; // ȸ       . +1 ġ ä.

									realBinaryArea[tempAddress] = 1;
									realBinaryArea[tempAddress + 1] = 1;
								}
							}
						}
					}
				}

				FindRealBinaryData(option, cameraIndex);

				{
					int x, y, i, j, i2, j2;
					int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
					int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
					int tempX, tempY;
					unsigned char *setupShapeDataTemp = setupShapeData;
					for (i = 1, i2 = i / 2; i < ImageHeight - 1; ++i, ((i & 1) == 0 && ++i2))				
					{
						for (j = 1, j2 = j / 2; j < ImageWidth - 1; ++j, ((j & 1) == 0 && ++j2))					
						{
							if (setupShapeDataTemp[HALF_IMAGE_WIDTH * i2 + j2])
							{
								tempX = (constCosV * (j - HALF_IMAGE_WIDTH) - constSinV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
								tempY = (constSinV * (j - HALF_IMAGE_WIDTH) + constCosV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

								if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10 &&
									ShapeBinaryImage[MAX_IMAGE_WIDTH * tempY + tempX])
								{
									for (y = tempY - 1; y <= tempY + 1; y++)
									{
										for (x = tempX - 1; x <= tempX + 1; x++)
										{
											InspectionArea[MAX_IMAGE_WIDTH * y + x] = NORMAL_INPECTION_AREA;
										}
									}
								}
							}						
						}
					}
				}
			}
			else
			{
				{
					int i, j, i2, j2;
					int tempAddress;
					int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
					int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
					int tempX, tempY;
					unsigned char *setupShapeDataTemp = setupShapeData;
					for (i = 1, i2 = i / 2; i < ImageHeight - 1; ++i, ((i & 1) == 0 && ++i2))
					{
						for (j = 1, j2 = j / 2; j < ImageWidth - 1; ++j, ((j & 1) == 0 && ++j2))
						{
							if (setupShapeDataTemp[HALF_IMAGE_WIDTH * i2 + (HALF_IMAGE_WIDTH - j2)])
							{
								tempX = (constCosV * (j - HALF_IMAGE_WIDTH) - constSinV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
								tempY = (constSinV * (j - HALF_IMAGE_WIDTH) + constCosV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

								if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10)
								{
									tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
									ShapeBinaryImage[tempAddress] = 1;
									ShapeBinaryImage[tempAddress + 1] = 1; // ȸ       . +1 ġ ä.

									realBinaryArea[tempAddress] = 1;
									realBinaryArea[tempAddress + 1] = 1;
								}
							}
						}
					}
				}

				FindRealBinaryData(option, cameraIndex);

				{
					int x, y, i, j, i2, j2;
					int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
					int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
					int tempX, tempY;
					unsigned char *setupShapeDataTemp = setupShapeData;
					for (i = 1, i2 = i / 2; i < ImageHeight - 1; ++i, ((i & 1) == 0 && ++i2))				
					{
						for (j = 1, j2 = j / 2; j < ImageWidth - 1; ++j, ((j & 1) == 0 && ++j2))					
						{
							if (setupShapeDataTemp[HALF_IMAGE_WIDTH * i2 + (HALF_IMAGE_WIDTH - j2)])						
							{
								tempX = (constCosV * (j - HALF_IMAGE_WIDTH) - constSinV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
								tempY = (constSinV * (j - HALF_IMAGE_WIDTH) + constCosV * (i - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;

								if (tempX > 10 && tempX < MAX_IMAGE_WIDTH - 10 && tempY > 10 && tempY < MAX_IMAGE_HEIGHT - 10 &&
									ShapeBinaryImage[MAX_IMAGE_WIDTH * tempY + tempX])
								{
									for (y = tempY - 1; y <= tempY + 1; y++)
									{
										for (x = tempX - 1; x <= tempX + 1; x++)
										{
											InspectionArea[MAX_IMAGE_WIDTH * y + x] = NORMAL_INPECTION_AREA;
										}
									}
								}
							}
						}
					}
				}
			}
			
			{
				int cosValue, sinValue;
				if (TabletMatchingResult.TabletRotationAngle >= 0)
				{
					sinValue = SinData[TabletMatchingResult.TabletRotationAngle];
					cosValue = CosData[TabletMatchingResult.TabletRotationAngle];
				}
				else
				{
					sinValue = -SinData[-TabletMatchingResult.TabletRotationAngle];
					cosValue = CosData[-TabletMatchingResult.TabletRotationAngle];
				}

				{
					int i, j;
					int AdjustCenterXInImage = TabletMatchingResult.AdjustCenterXInImage;
					int AdjustCenterYInImage = TabletMatchingResult.AdjustCenterYInImage;
					int rotateX, rotateY;
					int shapeEdgeMaskSizeTemp = shapeEdgeMaskSize;
					for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
					{
						rotateX = (cosValue * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) - sinValue * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterXInImage;
						rotateY = (sinValue * (tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH) + cosValue * (tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT)) / 1024 + AdjustCenterYInImage;
						
						for (i = rotateY - shapeEdgeMaskSizeTemp; i <= rotateY + shapeEdgeMaskSizeTemp; i++)
						{
							for (j = rotateX - shapeEdgeMaskSizeTemp; j <= rotateX + shapeEdgeMaskSizeTemp; j++)
							{
								if (j > 10 && j < MAX_IMAGE_WIDTH - 10 && i > 10 && i < MAX_IMAGE_HEIGHT - 10)
									InspectionArea[MAX_IMAGE_WIDTH * i + j] = 0;
							}
						}
					}
				}
			}

			//   ///////
			if (TabletCharacter.middle_height != 0)
			{
				FindTortionAngleInFrontFace(cameraIndex);
			}
			else
			{
				TabletMatchingResult.TabletFrontShapeXTotion = 0;
				TabletMatchingResult.TabletFrontShapeYTotion = 0;
			}
		}
	}

	int space = 20;

	tabletAreaInfo[AREA_INFO_ST_X_ADDRESS] = -(space + TabletCharacter.length / 2) + TabletMatchingResult.AdjustCenterXInImage;
	tabletAreaInfo[AREA_INFO_END_X_ADDRESS] = (TabletCharacter.length / 2 + space) + TabletMatchingResult.AdjustCenterXInImage;
	tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS] = -(space + TabletCharacter.width / 2) + TabletMatchingResult.AdjustCenterYInImage;
	tabletAreaInfo[AREA_INFO_END_Y_ADDRESS] = (TabletCharacter.width / 2 + space) + TabletMatchingResult.AdjustCenterYInImage;

	tabletAreaInfo[AREA_INFO_ST_X_ADDRESS] = max(startX, tabletAreaInfo[AREA_INFO_ST_X_ADDRESS]);
	tabletAreaInfo[AREA_INFO_END_X_ADDRESS] = min(endX, tabletAreaInfo[AREA_INFO_END_X_ADDRESS]);
	tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS] = max(startY, tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS]);
	tabletAreaInfo[AREA_INFO_END_Y_ADDRESS] = min(endY, tabletAreaInfo[AREA_INFO_END_Y_ADDRESS]);
}
//---------------------------------------------------------------------------
void FindTortionAngleInFrontFace(int cameraIndex)
{
	int x, y, m;
	int tempCount1, tempCount2;
	int tempCount3, tempCount4;
	int min;
	int tortionXSinValue, tortionYSinValue;
	int tempAddress;
	int divideValue;

	divideValue = 1;

	tempCount1 = 0;
	tempCount2 = 0;
	tempCount3 = 0;
	tempCount4 = 0;
	TabletMatchingResult.TabletFrontShapeXTotion = 0;

	for (y = TabletMatchingResult.AdjustCenterYInImage; y >= 0; y--)
	{
		tempAddress = MAX_IMAGE_WIDTH * y + TabletMatchingResult.AdjustCenterXInImage;
		if (ShapeBinaryImage[tempAddress] == 0)
		{
			if (MeanOneColorImage[tempAddress] > 60 || (ColorSourceImage[tempAddress * 3 + 2] / divideValue - ColorSourceImage[tempAddress * 3]) > 20)
			{
				tempCount1++;
			}
			else
				break;
		}
	}
	for (y = TabletMatchingResult.AdjustCenterYInImage; y < ImageHeight; y++)
	{
		tempAddress = MAX_IMAGE_WIDTH * y + TabletMatchingResult.AdjustCenterXInImage;
		if (ShapeBinaryImage[tempAddress] == 0)
		{
			if (MeanOneColorImage[tempAddress] > 60 || (ColorSourceImage[tempAddress * 3 + 2] / divideValue - ColorSourceImage[tempAddress * 3]) > 20)

			{
				tempCount2++;
			}
			else
				break;
		}
	}
	for (x = TabletMatchingResult.AdjustCenterXInImage; x >= 0; x--)
	{
		tempAddress = MAX_IMAGE_WIDTH * TabletMatchingResult.AdjustCenterYInImage + x;
		if (ShapeBinaryImage[MAX_IMAGE_WIDTH * TabletMatchingResult.AdjustCenterYInImage + x] == 0)
		{
			if (MeanOneColorImage[tempAddress] > 60 || (ColorSourceImage[tempAddress * 3 + 2] / divideValue - ColorSourceImage[tempAddress * 3]) > 20)

			{
				tempCount3++;
			}
			else
				break;
		}
	}
	for (x = TabletMatchingResult.AdjustCenterXInImage; x < ImageWidth; x++)
	{
		tempAddress = MAX_IMAGE_WIDTH * TabletMatchingResult.AdjustCenterYInImage + x;
		if (ShapeBinaryImage[tempAddress] == 0)
		{
			if (MeanOneColorImage[tempAddress] > 60 || (ColorSourceImage[tempAddress * 3 + 2] / divideValue - ColorSourceImage[tempAddress * 3]) > 20)

			{
				tempCount4++;
			}
			else
				break;
		}
	}
	min = 1000000;
	if (tempCount1 > tempCount2)
	{

		tortionXSinValue = tempCount1 * 1024 / TabletCharacter.middle_height;
		for (m = 0; m < 40; m++) // ִ 20 ̻   ٴ 
		{
			if (abs(tortionXSinValue - SinData[m]) < min)
			{
				min = abs(tortionXSinValue - SinData[m]);
				TabletMatchingResult.TabletFrontShapeXTotion = m;
			}
		}
	}
	else
	{
		tortionXSinValue = tempCount2 * 1024 / TabletCharacter.middle_height;
		for (m = 0; m < 40; m++) // ִ 20 ̻   ٴ 
		{
			if (abs(tortionXSinValue - SinData[m]) < min)
			{
				min = abs(tortionXSinValue - SinData[m]);
				TabletMatchingResult.TabletFrontShapeXTotion = -m;
			}
		}
	}
	min = 1000000;
	if (tempCount3 > tempCount4)
	{

		tortionYSinValue = tempCount3 * 1024 / TabletCharacter.middle_height;
		for (m = 0; m < 40; m++) // ִ 20 ̻   ٴ 
		{
			if (abs(tortionYSinValue - SinData[m]) < min)
			{
				min = abs(tortionYSinValue - SinData[m]);
				TabletMatchingResult.TabletFrontShapeYTotion = m;
			}
		}
	}
	else
	{
		tortionYSinValue = tempCount4 * 1024 / TabletCharacter.middle_height;
		for (m = 0; m < 40; m++) // ִ 20 ̻   ٴ 
		{
			if (abs(tortionYSinValue - SinData[m]) < min)
			{
				min = abs(tortionYSinValue - SinData[m]);
				TabletMatchingResult.TabletFrontShapeYTotion = -m;
			}
		}
	}
}
//---------------------------------------------------------------------------
void FindRealBinaryData(int option, int cameraIndex)
{
	int m, i, j, n, x, y;
	int uLengthFromTabletCenter[2000];
	int compareGrayLebelForEachEdgePoint[2000];
	int tempCount;
	int uLength;
	int tempX, tempY;
	int transX, transY;
	int st_x, end_x, st_y, end_y;
	int space;
	int tempCenterX;
	int tempCenterY;
	int centerDiffX;
	int centerDiffY;
	int tempAngle;
	int tempDiffRealBoundaryFromSetupBoundary;
	int conversionN;
	int tempAddress;
	int edgeSW;
	int tempCX, tempCY;
	int pX, pY;
	int sinV;
	int closingSize;
	int step;
	int compareGrayLebelSearchRange;
	int innerAreaEraseRange;
	short diffRealShapeBoundaryForAngleCoordinate[360];
	short diffRealShapeBoundaryCntForAngleCoordinate[360];
	short tempDiffRealShapeBoundaryForAngleCoordinate[360];
	short tempFrontShapeEdgePoint[2000][2];
	int range;
	int threshold;
	int avgColor;
	int tabletBinaryCount;
	int calculatedTabletBinaryCount;
	int defaultThreshold;
	int tabletThreshold;
	int startX, startY, endX, endY;
	int errorAreaAvgColor;
	int tabletBorderThreshold;
	int checkStartRange;
	int checkEndRange;
	int EraseActiveSW;
	unsigned char *tempBinaryImage;
	int maskSize;

	tempBinaryImage = BrightPixelNeighborPrint;

	EraseActiveSW = 1;
	if (TabletCharacter.plateInformation)
	{
		EraseActiveSW = 0;
	}

	memset(tempFrontShapeEdgePoint, 0, sizeof(short) * 2000 * 2);
	if (TabletCharacter.shape == ETC && TabletCharacter.symmetric_line_count == ASYMMETRY_TABLET && tabletETCShape_UpSideDownSW)
	{
		for (m = 0; m < 2000; m++)
		{
			tempFrontShapeEdgePoint[m][0] = MAX_IMAGE_WIDTH - TabletSetupData.FrontShapeEdgePoint[m][0];
			tempFrontShapeEdgePoint[m][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
		}
	}
	else
	{
		for (m = 0; m < 2000; m++)
		{
			tempFrontShapeEdgePoint[m][0] = TabletSetupData.FrontShapeEdgePoint[m][0];
			tempFrontShapeEdgePoint[m][1] = TabletSetupData.FrontShapeEdgePoint[m][1];
		}
	}

	space = 20;

	for (m = 0; m < 2000; m++)
	{
		uLengthFromTabletCenter[m] = 0;
		compareGrayLebelForEachEdgePoint[m] = 0;
	}
	for (m = 0; m < 360; m++)
	{
		diffRealShapeBoundaryForAngleCoordinate[m] = 0;
		diffRealShapeBoundaryCntForAngleCoordinate[m] = 0;
		tempDiffRealShapeBoundaryForAngleCoordinate[m] = 0;
	}

	st_x = -(space + TabletCharacter.length / 2) + (TabletMatchingResult.AdjustCenterXInImage);
	end_x = (TabletCharacter.length / 2 + space) + (TabletMatchingResult.AdjustCenterXInImage);
	st_y = -(space + TabletCharacter.width / 2) + (TabletMatchingResult.AdjustCenterYInImage);
	end_y = (TabletCharacter.width / 2 + space) + (TabletMatchingResult.AdjustCenterYInImage);

	if (TabletCharacter.shape == ETC)
	{
		space = 20;
		st_y = -(space + TabletCharacter.length / 2) + (TabletMatchingResult.AdjustCenterYInImage);
		end_y = (TabletCharacter.length / 2 + space) + (TabletMatchingResult.AdjustCenterYInImage);
	}

	if (st_x < TabletSetupData.ImageCutStartX[cameraIndex - 1])
		st_x = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	if (end_x > TabletSetupData.ImageCutEndX[cameraIndex - 1])
		end_x = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	if (st_y < TabletSetupData.ImageCutStartY[cameraIndex - 1])
		st_y = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	if (end_y > TabletSetupData.ImageCutEndY[cameraIndex - 1])
		end_y = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	if (TabletCharacter.kind == UNCOATING)
	{
		startX = TabletSetupData.ImageCutStartX[cameraIndex - 1] + 4;
		endX = TabletSetupData.ImageCutEndX[cameraIndex - 1] - 4;
		startY = TabletSetupData.ImageCutStartY[cameraIndex - 1] + 4;
		endY = TabletSetupData.ImageCutEndY[cameraIndex - 1] - 4;

		avgColor = tempCount = 0;
		for (y = startY; y < endY; y += 4)
		{
			for (x = startX; x < endX; x += 4)
			{
				tempAddress = MAX_IMAGE_WIDTH * y + x;

				if (realBinaryArea[tempAddress])
				{
					avgColor += OneColorImage[tempAddress];
					tempCount++;
				}
			}
		}

		if (tempCount)
		{
			avgColor = avgColor / tempCount;
		}
		else
		{
			DefectSW = 3;
		}

		defaultThreshold = 40;

		if (avgColor < defaultThreshold)
		{
			if (globalPositionErrorSuspectedTablet)
			{
				DefectSW = 3;
			}
		}
		else
		{
			tabletBinaryCount = tempCount;
			tabletThreshold = defaultThreshold;
			for (threshold = avgColor; threshold >= defaultThreshold; threshold -= 4)
			{
				calculatedTabletBinaryCount = 0;
				for (y = startY; y < endY; y += 4)
				{
					for (x = startX; x < endX; x += 4)
					{
						tempAddress = MAX_IMAGE_WIDTH * y + x;

						if (realBinaryArea[tempAddress] && OneColorImage[tempAddress] > threshold)
						{
							calculatedTabletBinaryCount++;
						}
					}
				}

				if (calculatedTabletBinaryCount > tabletBinaryCount * 90 / 100)
				{
					tabletThreshold = threshold;
					break;
				}
			}

			startX = TabletSetupData.ImageCutStartX[cameraIndex - 1];
			endX = TabletSetupData.ImageCutEndX[cameraIndex - 1];

			if (globalPositionErrorSuspectedTablet)
			{
				for (y = startY; y < endY; y++)
				{
					tempAddress = y * MAX_IMAGE_WIDTH + startX + 4;
					if (ShapeBinaryImage[tempAddress] == 1 && OneColorImage[tempAddress] > tabletThreshold)
					{
						DefectSW = 3;
					}
					else if (realBinaryArea[tempAddress] == 1)
					{
						DefectSW = 3;
					}
					tempAddress = y * MAX_IMAGE_WIDTH + endX - 4;
					if (ShapeBinaryImage[tempAddress] == 1 && OneColorImage[tempAddress] > tabletThreshold)
					{
						DefectSW = 3;
					}
					else if (realBinaryArea[tempAddress] == 1)
					{
						DefectSW = 3;
					}
				}
			}

			if (DefectSW == 0)
			{
				errorAreaAvgColor = tempCount = 0;
				int xmax, ymax;
				for (y = max(30, startY), ymax = min(MAX_IMAGE_HEIGHT - 30, endY); y < ymax; y++)
				{
					for (x = max(10, startX), xmax = min(MAX_IMAGE_WIDTH - 10, endX); x < xmax; x++)
					{
						tempAddress = MAX_IMAGE_WIDTH * y + x;
						if (ShapeBinaryImage[tempAddress] &&
							realBinaryArea[tempAddress + 0] == 0 &&
							realBinaryArea[tempAddress - 10] == 0 &&
							realBinaryArea[tempAddress + 10] == 0 &&
							realBinaryArea[tempAddress - 30 * MAX_IMAGE_WIDTH] == 0 &&
							realBinaryArea[tempAddress + 30 * MAX_IMAGE_WIDTH] == 0)
						{
							errorAreaAvgColor += OneColorImage[tempAddress];
							tempCount++;
						}
					}
				}

				if (tempCount)
				{
					errorAreaAvgColor = errorAreaAvgColor / tempCount;
					tabletBorderThreshold = (errorAreaAvgColor + tabletThreshold) / 2;

					for (y = startY; y < endY; y++)
					{
						for (x = startX; x < endX; x++)
						{
							tempAddress = MAX_IMAGE_WIDTH * y + x;

							if (realBinaryArea[tempAddress] == 0 && ShapeBinaryImage[tempAddress] && OneColorImage[tempAddress] < tabletBorderThreshold)
							{
								ShapeBinaryImage[tempAddress] = 0; // ⿡  翡 Ͽ  Ƣ  κ ŵȴ.  ڵ  .  츸  Ƣµ?
							}
						}
					}
				}
			}
		}
	}	

	if (option == CASE1)
	{
		//   𼭸 κ ׶̼ ߻ϸ鼭  ߻ɼۿ 
		//   Ư¡⿡  shape  ״ Ī õϵ 
		//   Ʒ  pass

		if (TabletCharacter.kind == SUGARCOATING || !EraseActiveSW)
		{
			// pass
		}
		else
		{
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempX = tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH + TabletMatchingResult.AdjustCenterXInImage;
				tempY = tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT + TabletMatchingResult.AdjustCenterYInImage;
				uLength = (tempX - TabletMatchingResult.AdjustCenterXInImage) * (tempX - TabletMatchingResult.AdjustCenterXInImage) + (tempY - TabletMatchingResult.AdjustCenterYInImage) * (tempY - TabletMatchingResult.AdjustCenterYInImage);
				if (uLength < 90000)
				{
					uLength = SqrtData[uLength]; // sqrtdata 128   .
					uLengthFromTabletCenter[m] = uLength;
					tempCount = 0;
					for (n = -14; n <= -12; n++)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
						if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2)
						{
							for (i = transY - 1; i <= transY + 1; i++)
							{
								for (j = transX - 1; j <= transX + 1; j++)
								{
									compareGrayLebelForEachEdgePoint[m] += MeanOneColorImage[i * MAX_IMAGE_WIDTH + j];
									tempCount++;
								}
							}
						}
					}

					if (tempCount)
						compareGrayLebelForEachEdgePoint[m] /= tempCount;
				}
			}

			if (TabletCharacter.shape == ROUND && TabletCharacter.length > TabletCharacter.height * 2)
			{
				//  ȣ ɼ , Ȯ  ٿ
				checkStartRange = 8;
				checkEndRange = -8;

				closingSize = 8;
				step = 2;
			}
			else
			{
				checkStartRange = 15;
				checkEndRange = -12;

				closingSize = 15;
				step = 3;
			}

			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempAngle = TabletSetupData.FrontShapeEdgePoint[m][2];
				tempX = tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH + TabletMatchingResult.AdjustCenterXInImage;
				tempY = tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT + TabletMatchingResult.AdjustCenterYInImage;
				uLength = uLengthFromTabletCenter[m];
				tempDiffRealBoundaryFromSetupBoundary = 0;
				for (n = checkStartRange; n >= checkEndRange; n--)
				{
					if (n <= 0)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
					}
					else
					{
						transX = (tempX * (uLength + n * 128) - TabletMatchingResult.AdjustCenterXInImage * (n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) - TabletMatchingResult.AdjustCenterYInImage * (n * 128)) / uLength;
					}
					if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2 &&
						MeanOneColorImage[transY * MAX_IMAGE_WIDTH + transX] * 5 >= compareGrayLebelForEachEdgePoint[m] * 4)
					{
						tempDiffRealBoundaryFromSetupBoundary = n;
						break;
					}
				}
				diffRealShapeBoundaryForAngleCoordinate[tempAngle] += tempDiffRealBoundaryFromSetupBoundary;
				diffRealShapeBoundaryCntForAngleCoordinate[tempAngle]++;
			}
			for (m = 0; m < 360; m++)
			{
				if (diffRealShapeBoundaryCntForAngleCoordinate[m])
					diffRealShapeBoundaryForAngleCoordinate[m] /= diffRealShapeBoundaryCntForAngleCoordinate[m];
			}

			for (m = 0; m < 360; m++)
			{
				for (n = m - 2; n <= m + 2; n++)
				{
					conversionN = (n + 360) % 360;
					tempDiffRealShapeBoundaryForAngleCoordinate[m] += diffRealShapeBoundaryForAngleCoordinate[conversionN];
				}
				tempDiffRealShapeBoundaryForAngleCoordinate[m] = (tempDiffRealShapeBoundaryForAngleCoordinate[m] + 2) / 5;
			}

			FrontShapeEdgeAreaExtension(tempDiffRealShapeBoundaryForAngleCoordinate, closingSize, step);

			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempAngle = TabletSetupData.FrontShapeEdgePoint[m][2];
				tempX = tempFrontShapeEdgePoint[m][0] - HALF_IMAGE_WIDTH + TabletMatchingResult.AdjustCenterXInImage;
				tempY = tempFrontShapeEdgePoint[m][1] - HALF_IMAGE_HEIGHT + TabletMatchingResult.AdjustCenterYInImage;
				uLength = uLengthFromTabletCenter[m];
				for (n = closingSize; n >= tempDiffRealShapeBoundaryForAngleCoordinate[tempAngle]; n--)
				{
					if (n <= 0)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
					}
					else
					{
						transX = (tempX * (uLength + n * 128) - TabletMatchingResult.AdjustCenterXInImage * (n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) - TabletMatchingResult.AdjustCenterYInImage * (n * 128)) / uLength;
					}
					if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2)
					{
						for (i = transY - 1; i <= transY + 1; i++)
						{
							for (j = transX - 1; j <= transX + 1; j++)
							{
								if (ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] && MeanOneColorImage[i * MAX_IMAGE_WIDTH + j] * 5 < compareGrayLebelForEachEdgePoint[m] * 4)
								{
									ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] = 0; //  ̹
								}
							}
						}
					}
				}
			}
		}
	}
	else if (option == CASE2)
	{
		if (TabletCharacter.kind == SUGARCOATING || !EraseActiveSW)
		{
			// pass
		}
		else
		{
			compareGrayLebelSearchRange = 12;
			innerAreaEraseRange = 9;
			if (TabletCharacter.shape == OVAL || TabletCharacter.shape == OBLONG) // ڼ ʹ Ҿؼ  ʹ  δ. ׷  Ÿ    Ϳ   ÷  Ѵ.
			{
				innerAreaEraseRange = TabletCharacter.middle_height * sin(20.0 / 180.0 * 3.14);			// atan( (float)(TabletCharacter.height - TabletCharacter.middle_height)/(float)TabletCharacter.width));
				compareGrayLebelSearchRange = TabletCharacter.middle_height * sin(20.0 / 180.0 * 3.14); // atan( (float)(TabletCharacter.height - TabletCharacter.middle_height)/(float)TabletCharacter.width));
			}

			if (innerAreaEraseRange > 25)
				innerAreaEraseRange = 25;
			if (compareGrayLebelSearchRange > 25)
				compareGrayLebelSearchRange = 25;

			if (innerAreaEraseRange < 9)
				innerAreaEraseRange = 9;
			if (compareGrayLebelSearchRange < 12)
				compareGrayLebelSearchRange = 12;

			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempX = transformFrontShapeEdgePoint[m][0];
				tempY = transformFrontShapeEdgePoint[m][1];

				uLength = (tempX - TabletMatchingResult.AdjustCenterXInImage) * (tempX - TabletMatchingResult.AdjustCenterXInImage) + (tempY - TabletMatchingResult.AdjustCenterYInImage) * (tempY - TabletMatchingResult.AdjustCenterYInImage);
				if (uLength < 90000)
				{
					uLength = SqrtData[uLength]; // sqrtdata 128   .
					uLengthFromTabletCenter[m] = uLength;
					tempCount = 0;
					for (n = -(compareGrayLebelSearchRange + 2); n <= -compareGrayLebelSearchRange; n++)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
						if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2)
						{
							for (i = transY - 1; i <= transY + 1; i++)
							{
								for (j = transX - 1; j <= transX + 1; j++)
								{
									compareGrayLebelForEachEdgePoint[m] += MeanOneColorImage[i * MAX_IMAGE_WIDTH + j];
									tempCount++;
								}
							}
						}
					}
					if (tempCount)
						compareGrayLebelForEachEdgePoint[m] /= tempCount;
				}
			}
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempAngle = TabletSetupData.FrontShapeEdgePoint[m][2];

				tempX = transformFrontShapeEdgePoint[m][0];
				tempY = transformFrontShapeEdgePoint[m][1];

				uLength = uLengthFromTabletCenter[m];
				tempDiffRealBoundaryFromSetupBoundary = 0;
				for (n = 18; n >= -innerAreaEraseRange; n--)
				{
					if (n <= 0)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
					}
					else
					{
						transX = (tempX * (uLength + n * 128) - TabletMatchingResult.AdjustCenterXInImage * (n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) - TabletMatchingResult.AdjustCenterYInImage * (n * 128)) / uLength;
					}
					if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2 &&
						MeanOneColorImage[transY * MAX_IMAGE_WIDTH + transX] * 10 >= compareGrayLebelForEachEdgePoint[m] * 9)
					{
						tempDiffRealBoundaryFromSetupBoundary = n;
						break;
					}
				}
				diffRealShapeBoundaryForAngleCoordinate[tempAngle] += tempDiffRealBoundaryFromSetupBoundary;
				diffRealShapeBoundaryCntForAngleCoordinate[tempAngle]++;
			}
			for (m = 0; m < 360; m++)
			{
				if (diffRealShapeBoundaryCntForAngleCoordinate[m])
					diffRealShapeBoundaryForAngleCoordinate[m] /= diffRealShapeBoundaryCntForAngleCoordinate[m];
			}

			for (m = 0; m < 360; m++)
			{
				for (n = m - 1; n <= m + 1; n++)
				{
					conversionN = (n + 360) % 360;
					tempDiffRealShapeBoundaryForAngleCoordinate[m] += diffRealShapeBoundaryForAngleCoordinate[conversionN];
				}
				tempDiffRealShapeBoundaryForAngleCoordinate[m] = (tempDiffRealShapeBoundaryForAngleCoordinate[m] + 1) / 3;
			}

			closingSize = 15;
			step = 3;

			range = 18;

			FrontShapeEdgeAreaExtension(tempDiffRealShapeBoundaryForAngleCoordinate, closingSize, step);

			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempAngle = TabletSetupData.FrontShapeEdgePoint[m][2];

				tempX = transformFrontShapeEdgePoint[m][0];
				tempY = transformFrontShapeEdgePoint[m][1];

				uLength = uLengthFromTabletCenter[m];
				for (n = range; n > tempDiffRealShapeBoundaryForAngleCoordinate[tempAngle]; n--)
				{
					if (n <= 0)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
					}
					else
					{
						transX = (tempX * (uLength + n * 128) - TabletMatchingResult.AdjustCenterXInImage * (n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) - TabletMatchingResult.AdjustCenterYInImage * (n * 128)) / uLength;
					}
					if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2)
					{
						for (i = transY - 1; i <= transY + 1; i++)
						{
							for (j = transX - 1; j <= transX + 1; j++)
							{
								if (ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] && MeanOneColorImage[i * MAX_IMAGE_WIDTH + j] * 10 < compareGrayLebelForEachEdgePoint[m] * 9)
								{
									ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] = 0; //  ̹
								}
							}
						}
					}
				}
			}
		}
	}
	else if (option == CASE3)
	{
		if (TabletCharacter.kind == SUGARCOATING || !EraseActiveSW)
		{
			// pass
		}
		else
		{
			// 
			compareGrayLebelSearchRange = 12;
			innerAreaEraseRange = 9;
			if (TabletCharacter.shape == OVAL || TabletCharacter.shape == OBLONG)
			{
				innerAreaEraseRange = TabletCharacter.middle_height * sin(20.0 / 180.0 * 3.14);
				compareGrayLebelSearchRange = TabletCharacter.middle_height * sin(20.0 / 180.0 * 3.14);
			}

			if (innerAreaEraseRange > 25)
				innerAreaEraseRange = 25;
			if (compareGrayLebelSearchRange > 25)
				compareGrayLebelSearchRange = 25;

			if (innerAreaEraseRange < 9)
				innerAreaEraseRange = 9;
			if (compareGrayLebelSearchRange < 12)
				compareGrayLebelSearchRange = 12;

			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempX = transformFrontShapeEdgePoint[m][0];
				tempY = transformFrontShapeEdgePoint[m][1];

				uLength = (tempX - TabletMatchingResult.AdjustCenterXInImage) * (tempX - TabletMatchingResult.AdjustCenterXInImage) + (tempY - TabletMatchingResult.AdjustCenterYInImage) * (tempY - TabletMatchingResult.AdjustCenterYInImage);
				if (uLength < 90000)
				{
					uLength = SqrtData[uLength]; // sqrtdata 128   .
					uLengthFromTabletCenter[m] = uLength;
					tempCount = 0;
					for (n = -(compareGrayLebelSearchRange + 2); n <= -compareGrayLebelSearchRange; n++)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
						if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2)
						{
							for (i = transY - 1; i <= transY + 1; i++)
							{
								for (j = transX - 1; j <= transX + 1; j++)
								{
									compareGrayLebelForEachEdgePoint[m] += MeanOneColorImage[i * MAX_IMAGE_WIDTH + j];
									tempCount++;
								}
							}
						}
					}
					if (tempCount)
						compareGrayLebelForEachEdgePoint[m] /= tempCount;
				}
			}
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempAngle = TabletSetupData.FrontShapeEdgePoint[m][2];

				tempX = transformFrontShapeEdgePoint[m][0];
				tempY = transformFrontShapeEdgePoint[m][1];

				uLength = uLengthFromTabletCenter[m];
				tempDiffRealBoundaryFromSetupBoundary = 0;
				for (n = 18; n >= -innerAreaEraseRange; n--)
				{
					if (n <= 0)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
					}
					else
					{
						transX = (tempX * (uLength + n * 128) - TabletMatchingResult.AdjustCenterXInImage * (n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) - TabletMatchingResult.AdjustCenterYInImage * (n * 128)) / uLength;
					}
					if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2 &&
						MeanOneColorImage[transY * MAX_IMAGE_WIDTH + transX] * 5 >= compareGrayLebelForEachEdgePoint[m] * 4)
					{
						tempDiffRealBoundaryFromSetupBoundary = n;
						break;
					}
				}
				diffRealShapeBoundaryForAngleCoordinate[tempAngle] += tempDiffRealBoundaryFromSetupBoundary;
				diffRealShapeBoundaryCntForAngleCoordinate[tempAngle]++;
			}
			for (m = 0; m < 360; m++)
			{
				if (diffRealShapeBoundaryCntForAngleCoordinate[m])
					diffRealShapeBoundaryForAngleCoordinate[m] /= diffRealShapeBoundaryCntForAngleCoordinate[m];
			}

			for (m = 0; m < 360; m++)
			{
				for (n = m - 1; n <= m + 1; n++)
				{
					conversionN = (n + 360) % 360;
					tempDiffRealShapeBoundaryForAngleCoordinate[m] += diffRealShapeBoundaryForAngleCoordinate[conversionN];
				}
				tempDiffRealShapeBoundaryForAngleCoordinate[m] = (tempDiffRealShapeBoundaryForAngleCoordinate[m] + 1) / 3;
			}

			closingSize = 15;
			step = 3;

			range = 18;

			FrontShapeEdgeAreaExtension(tempDiffRealShapeBoundaryForAngleCoordinate, closingSize, step);

			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempAngle = TabletSetupData.FrontShapeEdgePoint[m][2];

				tempX = transformFrontShapeEdgePoint[m][0];
				tempY = transformFrontShapeEdgePoint[m][1];

				uLength = uLengthFromTabletCenter[m];
				for (n = range; n > tempDiffRealShapeBoundaryForAngleCoordinate[tempAngle]; n--)
				{
					if (n <= 0)
					{
						transX = (tempX * (uLength + n * 128) + TabletMatchingResult.AdjustCenterXInImage * (-n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) + TabletMatchingResult.AdjustCenterYInImage * (-n * 128)) / uLength;
					}
					else
					{
						transX = (tempX * (uLength + n * 128) - TabletMatchingResult.AdjustCenterXInImage * (n * 128)) / uLength;
						transY = (tempY * (uLength + n * 128) - TabletMatchingResult.AdjustCenterYInImage * (n * 128)) / uLength;
					}
					if (transX > 2 && transX < MAX_IMAGE_WIDTH - 2 && transY > 2 && transY < MAX_IMAGE_HEIGHT - 2)
					{
						for (i = transY - 1; i <= transY + 1; i++)
						{
							for (j = transX - 1; j <= transX + 1; j++)
							{
								if (ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] && MeanOneColorImage[i * MAX_IMAGE_WIDTH + j] * 5 < compareGrayLebelForEachEdgePoint[m] * 4)
								{
									ShapeBinaryImage[i * MAX_IMAGE_WIDTH + j] = 0; //  ̹
								}
							}
						}
					}
				}
			}
		}
	}

	tempCount = 0;
	tempCenterX = 0;
	tempCenterY = 0;

	for (n = 0; n < SHAPE_SHELL_DEPTH; n++)
	{
		ShapeShellDataCount[n] = 0;
		for (m = 0; m < 2000; m++)
		{
			ShapeShellData[n][m][0] = 0;
			ShapeShellData[n][m][1] = 0;
			ShapeShellData[n][m][2] = 0;
		}
	}

	if (!EraseActiveSW)
	{
		maskSize = 6;
		memcpy(tempBinaryImage, ShapeBinaryImage, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

		for (y = st_y; y < end_y; y++)
		{
			for (x = st_x; x < end_x; x++)
			{
				tempAddress = y * MAX_IMAGE_WIDTH + x;
				if (tempBinaryImage[tempAddress] &&
					(tempBinaryImage[tempAddress - maskSize] == 0 || tempBinaryImage[tempAddress + maskSize] == 0 || tempBinaryImage[tempAddress - maskSize * MAX_IMAGE_WIDTH] == 0 || tempBinaryImage[tempAddress + maskSize * MAX_IMAGE_WIDTH] == 0))
				{
					ShapeBinaryImage[tempAddress] = 0;
				}
			}
		}
	}

	int bgPixelCount = 0;
	int bgMinX = MAX_IMAGE_WIDTH - 1;
	int bgMaxX = 0;
	int bgMinY = MAX_IMAGE_HEIGHT - 1;
	int bgMaxY = 0;
	int protoThrshold = 40 + TabletGradeData.ETC_TabletFrontFaceThreshold * 3;
	if (protoThrshold < 10)
		protoThrshold = 10;

	tempCX = TabletMatchingResult.AdjustCenterXInImage;
	tempCY = TabletMatchingResult.AdjustCenterYInImage;
	for (y = st_y; y < end_y; y++)
	{
		for (x = st_x; x < end_x; x++)
		{
			tempAddress = y * MAX_IMAGE_WIDTH + x;
			if (ShapeBinaryImage[tempAddress] != 1) //    ƴϸ .
				continue;

			if (OneColorImage[tempAddress] < protoThrshold)
			{
				if (realBinaryArea[tempAddress] == 1)
				{
					bgPixelCount++;
					if (bgMinX > x)
						bgMinX = x;
					if (bgMaxX < x)
						bgMaxX = x;
					if (bgMinY > y)
						bgMinY = y;
					if (bgMaxY < y)
						bgMaxY = y;
				}
			}
			
			tempCenterX += x;
			tempCenterY += y;
			tempCount++;
			edgeSW = 0;
			if (ShapeBinaryImage[tempAddress - 1] == 0)
			{
				edgeSW = 1;
			}
			else if (ShapeBinaryImage[tempAddress + 1] == 0)
			{
				edgeSW = 1;
			}
			else if (ShapeBinaryImage[tempAddress + MAX_IMAGE_WIDTH] == 0)
			{
				edgeSW = 1;
			}
			else if (ShapeBinaryImage[tempAddress - MAX_IMAGE_WIDTH] == 0)
			{
				edgeSW = 1;
			}

			if (edgeSW == 1 && ShapeShellDataCount[0] < 2000)
			{
				ShapeShellData[0][ShapeShellDataCount[0]][0] = x;
				ShapeShellData[0][ShapeShellDataCount[0]][1] = y;
				pX = x - tempCX;
				pY = y - tempCY;
				uLength = pX * pX + pY * pY;
				if (uLength < 90000)
				{
					uLength = SqrtData[uLength]; // sqrtdata 128   .
					sinV = 1280000 * pX / uLength;
					if (sinV > 10000)
						sinV = 10000;
					if (pX >= 0 && pY <= 0)
						ShapeShellData[0][ShapeShellDataCount[0]][2] = ArcSinData[sinV];
					else if (pX >= 0 && pY > 0)
						ShapeShellData[0][ShapeShellDataCount[0]][2] = 180 - ArcSinData[sinV];

					else if (pX < 0 && pY > 0)
						ShapeShellData[0][ShapeShellDataCount[0]][2] = 180 + ArcSinData[-sinV];
					else
						ShapeShellData[0][ShapeShellDataCount[0]][2] = 360 - ArcSinData[-sinV];
				}
				ShapeShellDataCount[0]++;
				ShapeBinaryImage[tempAddress] = 3;
			}			
		}
	}

	//   ũ⸦ üũ.
	{
		int shapeSetupDataCountDisk;
		if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
		{
			shapeSetupDataCountDisk = shapeSetupDataCountDisk1 * 4; // half    ȼ .
		}
		else
		{
			shapeSetupDataCountDisk = shapeSetupDataCountDisk2 * 4;
		}

		if (bgPixelCount > shapeSetupDataCountDisk * 5 / 100) //  5% ̻.
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_TABLET_SIZE, cameraIndex, bgMinX, bgMaxX, bgMinY, bgMaxY, bgPixelCount);
			return;
		}
	}

	if (tempCount)
	{
		tempCenterX = (tempCenterX + tempCount / 2) / tempCount;
		tempCenterY = (tempCenterY + tempCount / 2) / tempCount;
	}

	centerDiffX = tempCenterX - TabletMatchingResult.AdjustCenterXInImage;
	centerDiffY = tempCenterY - TabletMatchingResult.AdjustCenterYInImage;

	/// ũ ʴ (6?) ̵Ų.
	if (abs(centerDiffX) <= 6)
	{
		TabletMatchingResult.AdjustCenterXInImage = tempCenterX;
	}
	else
	{
		if (centerDiffX < -6)
			TabletMatchingResult.AdjustCenterXInImage -= 5;
		else
			TabletMatchingResult.AdjustCenterXInImage += 5;
	}
	if (abs(centerDiffY) <= 6)
	{
		TabletMatchingResult.AdjustCenterYInImage = tempCenterY;
	}
	else
	{
		if (centerDiffY < -6)
			TabletMatchingResult.AdjustCenterYInImage -= 5;
		else
			TabletMatchingResult.AdjustCenterYInImage += 5;
	}
}
//---------------------------------------------------------------------------
void FrontShapeEdgeAreaExtension(short *RESTRICT(tempDiffRealShapeBoundaryForAngleCoordinate), int closingSize, int step)
{
	int m;
	short tempData[360];
	short resultData[360];
	short tempDiffRealShapeBoundaryForAngleCoordinateShift0[360];
	short tempDiffRealShapeBoundaryForAngleCoordinateShift120[360];
	short tempDiffRealShapeBoundaryForAngleCoordinateShift240[360];
	int max;

	for (m = 0; m < 360; m++)
	{
		tempDiffRealShapeBoundaryForAngleCoordinateShift0[m] = tempDiffRealShapeBoundaryForAngleCoordinate[(m) % 360];
		tempDiffRealShapeBoundaryForAngleCoordinateShift120[m] = tempDiffRealShapeBoundaryForAngleCoordinate[(m + 120) % 360];
		tempDiffRealShapeBoundaryForAngleCoordinateShift240[m] = tempDiffRealShapeBoundaryForAngleCoordinate[(m + 240) % 360];
	}

	for (m = 0; m < 360; m++)
	{
		tempData[m] = 0;
		resultData[m] = 0;
	}
	LineDataDialation(tempDiffRealShapeBoundaryForAngleCoordinateShift0, tempData, closingSize, step, 360);
	LineDataErosion(tempData, resultData, closingSize, step, 360);
	for (m = 0; m < 360; m++)
	{
		tempDiffRealShapeBoundaryForAngleCoordinateShift0[m] = resultData[m];
	}
	for (m = 0; m < 360; m++)
	{
		tempData[m] = 0;
		resultData[m] = 0;
	}
	LineDataDialation(tempDiffRealShapeBoundaryForAngleCoordinateShift120, tempData, closingSize, step, 360);
	LineDataErosion(tempData, resultData, closingSize, step, 360);
	for (m = 0; m < 360; m++)
	{
		tempDiffRealShapeBoundaryForAngleCoordinateShift120[m] = resultData[m];
	}
	for (m = 0; m < 360; m++)
	{
		tempData[m] = 0;
		resultData[m] = 0;
	}
	LineDataDialation(tempDiffRealShapeBoundaryForAngleCoordinateShift240, tempData, closingSize, step, 360);
	LineDataErosion(tempData, resultData, closingSize, step, 360);
	for (m = 0; m < 360; m++)
	{
		tempDiffRealShapeBoundaryForAngleCoordinateShift240[m] = resultData[m];
	}
	for (m = 0; m < 45; m++)
	{
		tempDiffRealShapeBoundaryForAngleCoordinateShift0[m] = -100;
		tempDiffRealShapeBoundaryForAngleCoordinateShift120[m] = -100;
		tempDiffRealShapeBoundaryForAngleCoordinateShift240[m] = -100;
	}
	for (m = 360 - 45; m < 360; m++)
	{
		tempDiffRealShapeBoundaryForAngleCoordinateShift0[m] = -100;
		tempDiffRealShapeBoundaryForAngleCoordinateShift120[m] = -100;
		tempDiffRealShapeBoundaryForAngleCoordinateShift240[m] = -100;
	}

	for (m = 0; m < 360; m++)
	{
		max = -100;
		if (tempDiffRealShapeBoundaryForAngleCoordinateShift0[m] > max)
			max = tempDiffRealShapeBoundaryForAngleCoordinateShift0[m];
		if (tempDiffRealShapeBoundaryForAngleCoordinateShift120[(m + 240) % 360] > max)
			max = tempDiffRealShapeBoundaryForAngleCoordinateShift120[(m + 240) % 360];
		if (tempDiffRealShapeBoundaryForAngleCoordinateShift240[(m + 120) % 360] > max)
			max = tempDiffRealShapeBoundaryForAngleCoordinateShift240[(m + 120) % 360];

		tempDiffRealShapeBoundaryForAngleCoordinate[m] = max;
	}
}
//---------------------------------------------------------------------------
void DefectSearchForFrontShape(int cameraIndex)
{
	int defectGroupN;
	int m, i, j, r, x, y;
	int darkDefectCheckSW;
	int brightDefectCheckSW;
	int selfPositionValueAvg;
	int selfPositionValueB;
	int selfPositionValueG;
	int selfPositionValueR;
	int thresholdDark;
	int thresholdBright;
	int tempAddress;
	int tempAddress2;
	int tempCount;
	int areaValue;
	int colorDiffB, colorDiffG, colorDiffR;
	int colorDiff;
	int alpha;
	int tagetPositionValue;

	int searchRange;

	short defectPointData[MAX_DEFECT_POINT_COUNT * 3];
	int defectPointDataCnt;
	
	int inspectionAcceptArea[12];
	int compareAcceptArea[12][12];
	int thresholdForEaceArea[12];
	int defectCheckPointCount[12];
	
	int maxPixelDefectLabelN;
	int tMax;
	int maxDiff;
	int yShift;
	int PrintNeighbotThreshold_Short;
	int PrintNeighbotThreshold_Long;
	int interestedColor;
	int notInterestedColor[2];
	int colorValue[3];	
	int edgeDefectLeftSW, edgeDefectRightSW, edgeDefectUpSW, edgeDefectDownSW;
	int edgeDefectLeftUpSW, edgeDefectLeftDownSW, edgeDefectRightUpSW, edgeDefectRightDownSW;

	int edgeCheckResult;
	int shellValue;
	int printLabelNum;
	int edgeNeighborBlurThreshold;
	int edgeNeighborSpotThreshold;
	int normalAreaBlurThreshold;
	int normalAreaSpotThreshold;

	int topSW, bottomSW, leftSW, rightSW, topLeftSW, topRightSW, bottomLeftSW, bottomRightSW;

	int tabletColor;
	int printThreshold;

	int tempX, tempY;

	int tempEdgeIntensity;
	int tempEdgeMask;

	int printAreaMask;

	int st_x, end_x, st_y, end_y;

	st_x = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	end_x = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	st_y = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	end_y = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	if (st_x < 20)
		st_x = 20;
	if (end_x > MAX_IMAGE_WIDTH - 20)
		end_x = MAX_IMAGE_WIDTH - 20;
	if (st_y < 20)
		st_y = 20;
	if (end_y > MAX_IMAGE_HEIGHT - 20)
		end_y = MAX_IMAGE_HEIGHT - 20;

	if (SelectedFace == FRONT_FACE_FOR_COLOR)
	{
		tempEdgeIntensity = TabletGradeData.front_edge_Intensity;
	}
	else
	{
		tempEdgeIntensity = TabletGradeData.rear_edge_Intensity;
	}

	tempEdgeMask = TabletGradeData.front_unInspectionIntensity_ForEdge;

	for (m = 0; m < ShapeShellDataCount[0]; m++)
	{
		x = ShapeShellData[0][m][0];
		y = ShapeShellData[0][m][1];
		for (i = y - tempEdgeMask; i <= y + tempEdgeMask; i++)
		{
			for (j = x - tempEdgeMask; j <= x + tempEdgeMask; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				if (InspectionArea[tempAddress])
					InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
			}
		}
	}

	if (tempEdgeIntensity <= 3)
	{
		for (m = 0; m < ShapeShellDataCount[0]; m++)
		{
			x = ShapeShellData[0][m][0];
			y = ShapeShellData[0][m][1];
			for (i = y - 1; i <= y + 1; i++)
			{
				for (j = x - 1; j <= x + 1; j++)
				{
					tempAddress = MAX_IMAGE_WIDTH * i + j;
					InspectionArea[tempAddress] = 0;
				}
			}
		}
	}
	else if (tempEdgeIntensity > 3)
	{
		for (m = 0; m < ShapeShellDataCount[0]; m++)
		{
			x = ShapeShellData[0][m][0];
			y = ShapeShellData[0][m][1];
			for (i = y - 2; i <= y + 2; i++)
			{
				for (j = x - 2; j <= x + 2; j++)
				{
					tempAddress = MAX_IMAGE_WIDTH * i + j;
					InspectionArea[tempAddress] = 0;
				}
			}
		}
	}

	for (m = 0; m < ShapeShellDataCount[0]; m++)
	{
		x = ShapeShellData[0][m][0];
		y = ShapeShellData[0][m][1];
		for (i = y - 2; i <= y + 2; i++)
		{
			for (j = x - 2; j <= x + 2; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
			}
		}
	}

	if (globalFrontFaceSplitLineMatchingSW)
	{
		printAreaMask = TabletGradeData.front_unInspectionIntensity_ForPrint + 4;

		for (m = 0; m < globalTabletSplitLineDataCount; m++)
		{
			x = globalTabletSplitLineData[m][0];
			y = globalTabletSplitLineData[m][1];

			for (tempY = y - printAreaMask; tempY <= y + printAreaMask; tempY++)
			{
				for (tempX = x - printAreaMask; tempX <= x + printAreaMask; tempX++)
				{
					tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;

					if (InspectionArea[tempAddress] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress])
					{
						InspectionArea[tempAddress] = FRONT_FACE_SPLIT_AREA;
					}
				}
			}
		}

		for (i = st_y; i < end_y; i++)
		{
			for (j = st_x; j < end_x; j++)
			{
				tempAddress = i * MAX_IMAGE_WIDTH + j;
				if (InspectionArea[tempAddress] == FRONT_FACE_SPLIT_AREA)
				{
					for (y = i - 5; y <= i + 5; y++)
					{
						for (x = j - 5; x <= j + 5; x++)
						{
							tempAddress = MAX_IMAGE_WIDTH * y + x;

							if (InspectionArea[tempAddress] &&
								InspectionArea[tempAddress] != FRONT_FACE_SPLIT_AREA &&
								InspectionArea[tempAddress] != PRINT_AREA &&
								InspectionArea[tempAddress] != FRONT_SHAPE_EDGE)
							{
								InspectionArea[tempAddress] = PRINT_NEIGHBOR_SHORT;
							}
						}
					}
				}
			}
		}
	}

	unsigned char *tempInspectionArea = ThreeD_Image; // ӽ .
	unsigned char *candidateDefectPoint = PlanariztionThreeDEdgeImage; // ӽ .
	unsigned char *tempMaskBuf = DentedArea; // ӽ .
	short *label_Image = RotationEdgeImage;

	memset(tempMaskBuf, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);	
	memset(tempInspectionArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	for (i = st_y; i < end_y; i++)
	{
		for (j = st_x; j < end_x; j++)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;

			if (InspectionArea[tempAddress] == FRONT_MASKING_AREA)
				tempInspectionArea[tempAddress] = 0;
			else
				tempInspectionArea[tempAddress] = InspectionArea[tempAddress];
		}
	}

	thresholdDark = 30;
	memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
	defectPointDataCnt = 0;

	if (SelectedFace == FRONT_FACE_FOR_COLOR)
	{
		int factor1 = 2;
		int factor2 = 2;
		if (TabletCharacter.CurvedSurfaceTablet)
		{
			factor1 = 4;
			factor2 = 12; // ǥ鿡  ִ       帰  Ȧ  ſ  Ͽ.  μ 帰    ȵȴ.
		}
		
		alpha = (TabletGradeData.front_stain_Intensity - 1) * factor2;
		normalAreaBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + alpha;
		normalAreaSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.front_dirty_Intensity * factor1;

		edgeNeighborBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + (TabletGradeData.front_edge_Intensity - 1) * 3;
		edgeNeighborSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.front_edge_dirty_Intensity * 2;
	}
	else
	{
		alpha = (TabletGradeData.rear_stain_Intensity - 1) * 2;
		normalAreaBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + alpha;
		normalAreaSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.rear_dirty_Intensity * 2;

		edgeNeighborBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + (TabletGradeData.rear_edge_Intensity - 1) * 3;
		edgeNeighborSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.rear_edge_dirty_Intensity * 2;
	}

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH;
		PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH;
	}
	else
	{
		if (BlurredEngraveSW)
		{
			PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH / 4;
			PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH / 4;
		}
		else
		{
			PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH / 2;
			PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH / 2;
		}
	}

	thresholdBright = FORNT_NORMAL_INPECTION_AREA_BRIGHT_THRESH + alpha;
	tabletColor = max(2, MeanColorG / 20);

	for (m = 0; m < 12; m++)
	{
		thresholdForEaceArea[m] = 15;
		if (m == NORMAL_INPECTION_AREA)
		{
			thresholdForEaceArea[m] = normalAreaBlurThreshold;
		}
		else if (m == PRINT_NEIGHBOR_SHORT || m == PRINT_NEIGHBOR_LONG)
		{
			thresholdForEaceArea[m] = normalAreaBlurThreshold + FORNT_NORMAL_INPECTION_AREA_THRESH;
		}
		else if (m == FRONT_SHAPE_EDGE_NEIGHBOR || m == FRONT_SHAPE_EDGE)
		{
			thresholdForEaceArea[m] = edgeNeighborBlurThreshold;
		}
		else if (m == PRINT_AREA)
		{
			if (SelectedFace == FRONT_FACE_FOR_COLOR)
			{
				if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint)
				{
					if (TabletGradeData.front_print_dirty_Inetensity == 1)
					{
						thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity;
					}
					else
					{
						thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity * (TabletGradeData.front_print_dirty_Inetensity - 1);
					}
				}
				else
				{
					thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity;
				}
			}
			else
			{
				if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint)
				{
					if (TabletGradeData.rear_print_dirty_Inetensity == 1)
					{
						thresholdForEaceArea[m] = tabletColor * TabletGradeData.rear_print_dirty_Inetensity;
					}
					else
					{
						thresholdForEaceArea[m] = tabletColor * TabletGradeData.rear_print_dirty_Inetensity * (TabletGradeData.rear_print_dirty_Inetensity - 1);
					}
				}
				else
				{
					thresholdForEaceArea[m] = tabletColor * TabletGradeData.rear_print_dirty_Inetensity;
				}
			}
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
		{
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Short + alpha * 2;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
		{
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Long + alpha * 2;
		}
	}

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		printThreshold = 2 * TabletGradeData.front_print_dirty_Inetensity2;
		if (TabletGradeData.front_print_dirty_Inetensity2 == 30) // max
		{
			printThreshold = 255;
		}
	}
	else
	{
		printThreshold = thresholdForEaceArea[PRINT_AREA];
	}

	for (m = 0; m < 12; m++)
	{
		inspectionAcceptArea[m] = 1;
		if (m == FRONT_SHAPE_EDGE)
		{
			if (TabletGradeData.ETC_FrontFaceEdgeInspectionSW)
				inspectionAcceptArea[m] = 4;
			else
				inspectionAcceptArea[m] = 0;
		}

		if (m == PRINT_AREA)
		{
			inspectionAcceptArea[m] = 3;
		}

		if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
		{
			inspectionAcceptArea[m] = 1;
			if (TabletCharacter.kind == SUGARCOATING)
				inspectionAcceptArea[m] = 2;
		}

		if (m == FRONT_FACE_SPLIT_AREA)
		{
			inspectionAcceptArea[m] = 0;
		}
	}
	inspectionAcceptArea[0] = 0;

	for (m = 0; m < 12; m++)
	{
		defectCheckPointCount[m] = 3;
		if (m == FRONT_SHAPE_EDGE)
			defectCheckPointCount[m] = 2;
		if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
			defectCheckPointCount[m] = 2;
		if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
			defectCheckPointCount[m] = 2;
		if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
			defectCheckPointCount[m] = 2;
		if (m == PRINT_AREA || m == FRONT_FACE_SPLIT_AREA)
			defectCheckPointCount[m] = 3;
	}

	for (m = 0; m < 12; m++)
	{
		for (i = 0; i < 12; i++)
			compareAcceptArea[m][i] = 0;

		if (m == NORMAL_INPECTION_AREA)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
		{
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
		{
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == PRINT_NEIGHBOR_SHORT)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
		}
		else if (m == PRINT_NEIGHBOR_LONG)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
		}
		else if (m == PRINT_AREA || m == FRONT_FACE_SPLIT_AREA)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_SHORT] = 1;
			compareAcceptArea[m][PRINT_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
	}

	if (globalFrontFaceSplitLineMatchingSW)
	{
		// 2021-04-02
		// Ҽ Ī 
		// μ + Ҽ ȥ  شϴ  ش ̽ 
		// ̶, ΰ & ޼   ̹ ȭ  뿡  ݿ ȵǾ
		//   ϵ,   Ǵ   ʿ
		thresholdDark = thresholdForEaceArea[PRINT_AREA];

		for (i = st_y; i < end_y; i++)
		{
			for (j = st_x; j < end_x; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				areaValue = tempInspectionArea[tempAddress];

				if (areaValue == FRONT_FACE_SPLIT_AREA)
				{
					darkDefectCheckSW = 0;
					tempCount = 0;

					selfPositionValueAvg = MeanOneColorImage[tempAddress];

					searchRange = 12;
					for (r = searchRange; r >= 8; r -= 4)
					{
						yShift = r * MAX_IMAGE_WIDTH;
						tempAddress2 = tempAddress - yShift;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;
							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress + yShift;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress - r;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress + r;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress + yShift + r;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress - yShift - r;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress + yShift - r;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}
						tempAddress2 = tempAddress - yShift + r;
						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							tempCount++;
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						if (tempCount >= 3 && darkDefectCheckSW >= defectCheckPointCount[areaValue])
						{
							if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
							{
								defectPointData[defectPointDataCnt * 3] = j;
								defectPointData[defectPointDataCnt * 3 + 1] = i;
								defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

								defectPointDataCnt++;
							}
							break;
						}
					}
				}
			}
		}
	}

	if (TabletGradeData.DirtyGradeSensitivity == GRADE_SENSITIVITY_NORMAL)
	{
		if (!TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm)
		{
			//  ̹  ó ʴ .
			for (i = st_y; i < end_y; i++)
			{
				for (j = st_x; j < end_x; j++)
				{
					tempAddress = MAX_IMAGE_WIDTH * i + j;
					areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];
					
					if (inspectionAcceptArea[areaValue])
					{
						if (TempImage[tempAddress]) // Ƽŷ ̳  ׵θ αٿ ҷ üũ. DefectSearchInEdgeNeighborArea()   ̴.
						{
							if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
							{
								defectPointData[defectPointDataCnt * 3] = j;
								defectPointData[defectPointDataCnt * 3 + 1] = i;
								defectPointData[defectPointDataCnt * 3 + 2] = TempImage[tempAddress];
								defectPointDataCnt++;
							}
						}
						else
						{
							brightDefectCheckSW = 0;
							darkDefectCheckSW = 0;
							tempCount = 0;
							thresholdDark = thresholdForEaceArea[areaValue];
							if (inspectionAcceptArea[areaValue] == 1) // Print  ƴ 
							{
								searchRange = 12;
								if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation == NOT_PLATE)
										searchRange = 9 - TabletGradeData.front_edge_Intensity;
									else if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation != NOT_PLATE)
										searchRange = 3;
									else if (TabletCharacter.shape == ETC && TabletCharacter.plateInformation != NOT_PLATE)
										searchRange = 3;
									else
										searchRange = 9 - TabletGradeData.front_edge_Intensity;
								}

								selfPositionValueAvg = OneColorImage[tempAddress];

								maxDiff = -1;
								for (r = searchRange; r >= 2; r -= 4)
								{
									yShift = r * MAX_IMAGE_WIDTH;
									tempAddress2 = tempAddress - yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress - yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress - yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									if (tempCount >= 3)
									{
										if (darkDefectCheckSW >= defectCheckPointCount[areaValue]) // 帰  ˻    ߿.  а ִٰ ϹǷ.
										{
											if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
											{
												defectPointData[defectPointDataCnt * 3] = j;
												defectPointData[defectPointDataCnt * 3 + 1] = i;
												defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

												defectPointDataCnt++;
											}
											break;
										}
										else if (brightDefectCheckSW >= 4)
										{
											if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
											{
												defectPointData[defectPointDataCnt * 3] = j;
												defectPointData[defectPointDataCnt * 3 + 1] = i;
												defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;
												defectPointDataCnt++;
											}
											break;
										}
										if (r == 4)
											break;
									}
								}
							}
							else if (inspectionAcceptArea[areaValue] == 3)
							{
								if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint && TabletCharacter.discriminationDisplay_kind != PRINT)
								{
									selfPositionValueAvg = MeanOneColorImage[tempAddress];

									maxDiff = 0;
									searchRange = 12;
									for (r = searchRange; r >= 8; r -= 4)
									{
										yShift = r * MAX_IMAGE_WIDTH;
										tempAddress2 = tempAddress - yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;
											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress - yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress - yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										if (tempCount >= 3 && darkDefectCheckSW >= defectCheckPointCount[areaValue])
										{
											if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
											{
												defectPointData[defectPointDataCnt * 3] = j;
												defectPointData[defectPointDataCnt * 3 + 1] = i;
												defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

												defectPointDataCnt++;
											}
											break;
										}
									}
								}
								else
								{
									printLabelNum = PrintLabelArea[tempAddress] & 0x0F;

									if (printLabelNum)
									{
										selfPositionValueAvg = MeanOneColorImage[tempAddress];
										tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > printThreshold && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = j;
											defectPointData[defectPointDataCnt * 3 + 1] = i;
											defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

											defectPointDataCnt++;
										}
									}
								}
							}
							else if (inspectionAcceptArea[areaValue] == 4)
							{
								selfPositionValueAvg = (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]); //  ӵ  Ͽ 3  .

								searchRange = 5;
								edgeCheckResult = 0;

								edgeDefectLeftSW = edgeDefectRightSW = edgeDefectUpSW = edgeDefectDownSW = 0;
								edgeDefectLeftUpSW = edgeDefectLeftDownSW = edgeDefectRightUpSW = edgeDefectRightDownSW = 0;
								for (r = searchRange; r >= 2; r--)
								{
									yShift = r * MAX_IMAGE_WIDTH;

									tempAddress2 = tempAddress - yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectUpSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectUpSW = 1;
										}
									}
									tempAddress2 = tempAddress + yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectDownSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectDownSW = 1;
										}
									}
									tempAddress2 = tempAddress - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectLeftSW = 1;
										}
									}
									tempAddress2 = tempAddress + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectRightSW = 1;
										}
									}
									tempAddress2 = tempAddress - yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftUpSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectLeftUpSW = 1;
										}
									}
									tempAddress2 = tempAddress + yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftDownSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectLeftDownSW = 1;
										}
									}
									tempAddress2 = tempAddress - yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightUpSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectRightUpSW = 1;
										}
									}
									tempAddress2 = tempAddress + yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightDownSW)
									{
										colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
										if (colorDiff > thresholdDark * 3)
										{
											edgeDefectRightDownSW = 1;
										}
									}

									if (((edgeDefectUpSW || edgeDefectLeftUpSW || edgeDefectRightUpSW) && edgeDefectDownSW && edgeDefectRightSW && edgeDefectLeftSW) ||
										(edgeDefectUpSW && (edgeDefectDownSW || edgeDefectLeftDownSW || edgeDefectRightDownSW) && edgeDefectRightSW && edgeDefectLeftSW) ||
										(edgeDefectUpSW && edgeDefectDownSW && (edgeDefectRightSW || edgeDefectRightUpSW || edgeDefectRightDownSW) && edgeDefectLeftSW) ||
										(edgeDefectUpSW && edgeDefectDownSW && edgeDefectRightSW && (edgeDefectLeftSW || edgeDefectLeftUpSW || edgeDefectLeftDownSW)) ||
										(edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW && edgeDefectRightSW && edgeDefectRightUpSW) ||
										(edgeDefectLeftUpSW && edgeDefectLeftSW && edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW) ||
										(edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW && edgeDefectRightSW && edgeDefectRightDownSW) ||
										(edgeDefectLeftDownSW && edgeDefectLeftSW && edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW))
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = j;
											defectPointData[defectPointDataCnt * 3 + 1] = i;
											defectPointData[defectPointDataCnt * 3 + 2] = colorDiff / 3;

											defectPointDataCnt++;

											edgeCheckResult = 1; // defectCheck

											break;
										}
									}
								}

								if (!edgeCheckResult) // ҷ ƴ 
								{
									shellValue = tShellInspectionArea[tempAddress];

									if (shellValue)
									{
										tagetPositionValue = shellAvgColor[shellValue - 1];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = j;
											defectPointData[defectPointDataCnt * 3 + 1] = i;
											defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

											defectPointDataCnt++;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
			//  ̹  óϴ .

			// 1 ҷ 
			//  ̹ ϴ  ŷ óϿ 2 ҷ 
			memset(colorMaskingArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

			// colorMaskingArea ҷ ĺ  ŷ ó.
			for (i = st_y; i < end_y; i++)
			{
				for (j = st_x; j < end_x; j++)
				{
					tempAddress = MAX_IMAGE_WIDTH * i + j;
					areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];

					if (inspectionAcceptArea[areaValue])
					{
						if (TempImage[tempAddress])
						{
							colorMaskingArea[tempAddress] = 1;
						}
						else
						{
							brightDefectCheckSW = 0;
							darkDefectCheckSW = 0;
							tempCount = 0;
							thresholdDark = thresholdForEaceArea[areaValue];
							if (inspectionAcceptArea[areaValue] == 1) // Print  ƴ 
							{
								searchRange = 12;
								if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation == NOT_PLATE)
										searchRange = 9 - TabletGradeData.front_edge_Intensity;
									else if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation != NOT_PLATE)
										searchRange = 3;
									else if (TabletCharacter.shape == ETC && TabletCharacter.plateInformation != NOT_PLATE)
										searchRange = 3;
									else
										searchRange = 9 - TabletGradeData.front_edge_Intensity;
								}

								selfPositionValueAvg = OneColorImage[tempAddress];

								maxDiff = -1;
								for (r = searchRange; r >= 2; r -= 4)
								{
									yShift = r * MAX_IMAGE_WIDTH;
									tempAddress2 = tempAddress - yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress - yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress + yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									tempAddress2 = tempAddress - yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										if (BrightPixelNeighborPrint[tempAddress2])
											continue;

										tempCount++;
										colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;
											if (maxDiff < colorDiff)
												maxDiff = colorDiff;
										}
										if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
										{
											brightDefectCheckSW++;
										}
									}
									if (tempCount >= 3)
									{
										if (darkDefectCheckSW >= defectCheckPointCount[areaValue])
										{
											colorMaskingArea[tempAddress] = 1;
											break;
										}
										else if (brightDefectCheckSW >= 4)
										{
											colorMaskingArea[tempAddress] = 1;
											break;
										}
										if (r == 4)
											break;
									}
								}
							}
							else if (inspectionAcceptArea[areaValue] == 3)
							{
								if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint && TabletCharacter.discriminationDisplay_kind != PRINT)
								{
									selfPositionValueAvg = MeanOneColorImage[tempAddress];

									maxDiff = 0;
									searchRange = 12;
									for (r = searchRange; r >= 8; r -= 4)
									{
										yShift = r * MAX_IMAGE_WIDTH;
										tempAddress2 = tempAddress - yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;
											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress - yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress + yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										tempAddress2 = tempAddress - yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											tempCount++;
											tagetPositionValue = MeanOneColorImage[tempAddress2];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;

												if (maxDiff < colorDiff)
												{
													maxDiff = colorDiff;
												}
											}
										}
										if (tempCount >= 3)
										{
											if (darkDefectCheckSW >= defectCheckPointCount[areaValue])
											{
												colorMaskingArea[tempAddress] = 1;
												break;
											}
											if (r == 8)
												break;
										}
									}
								}
								else
								{
									printLabelNum = PrintLabelArea[tempAddress] & 0x0F;

									if (printLabelNum)
									{
										selfPositionValueAvg = MeanOneColorImage[tempAddress];
										tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > printThreshold)
										{
											colorMaskingArea[tempAddress] = 1;
										}
									}
								}
							}
							else if (inspectionAcceptArea[areaValue] == 4)
							{
								selfPositionValueAvg = (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]); //  ӵ  Ͽ 3  .

								searchRange = 5;

								edgeCheckResult = 0;

								edgeDefectLeftSW = edgeDefectRightSW = edgeDefectUpSW = edgeDefectDownSW = 0;
								edgeDefectLeftUpSW = edgeDefectLeftDownSW = edgeDefectRightUpSW = edgeDefectRightDownSW = 0;
								for (r = searchRange; r >= 2; r--)
								{
									yShift = r * MAX_IMAGE_WIDTH;

									tempAddress2 = tempAddress - yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectUpSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectUpSW = 1;
									}
									tempAddress2 = tempAddress + yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectDownSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectDownSW = 1;
									}
									tempAddress2 = tempAddress - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectLeftSW = 1;
									}
									tempAddress2 = tempAddress + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectRightSW = 1;
									}
									tempAddress2 = tempAddress - yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftUpSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectLeftUpSW = 1;
									}
									tempAddress2 = tempAddress + yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftDownSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectLeftDownSW = 1;
									}
									tempAddress2 = tempAddress - yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightUpSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectRightUpSW = 1;
									}
									tempAddress2 = tempAddress + yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightDownSW &&
										(ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg > thresholdDark * 3)
									{
										edgeDefectRightDownSW = 1;
									}

									if (((edgeDefectUpSW || edgeDefectLeftUpSW || edgeDefectRightUpSW) && edgeDefectDownSW && edgeDefectRightSW && edgeDefectLeftSW) ||
										(edgeDefectUpSW && (edgeDefectDownSW || edgeDefectLeftDownSW || edgeDefectRightDownSW) && edgeDefectRightSW && edgeDefectLeftSW) ||
										(edgeDefectUpSW && edgeDefectDownSW && (edgeDefectRightSW || edgeDefectRightUpSW || edgeDefectRightDownSW) && edgeDefectLeftSW) ||
										(edgeDefectUpSW && edgeDefectDownSW && edgeDefectRightSW && (edgeDefectLeftSW || edgeDefectLeftUpSW || edgeDefectLeftDownSW)) ||
										(edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW && edgeDefectRightSW && edgeDefectRightUpSW) ||
										(edgeDefectLeftUpSW && edgeDefectLeftSW && edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW) ||
										(edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW && edgeDefectRightSW && edgeDefectRightDownSW) ||
										(edgeDefectLeftDownSW && edgeDefectLeftSW && edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW))
									{
										colorMaskingArea[tempAddress] = 1;

										edgeCheckResult = 1;
										break;
									}
								}

								if (!edgeCheckResult) // ҷ ƴ 
								{
									shellValue = tShellInspectionArea[tempAddress];

									if (shellValue)
									{
										tagetPositionValue = shellAvgColor[shellValue - 1];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											colorMaskingArea[tempAddress] = 1;
										}
									}
								}
							}
						}
					}
				}
			}

			interestedColor = TabletGradeData.ETC_InterestedColor;

			if (interestedColor == 0)
			{
				notInterestedColor[0] = 1;
				notInterestedColor[1] = 2;
			}
			else if (interestedColor == 1)
			{
				notInterestedColor[0] = 0;
				notInterestedColor[1] = 2;
			}
			else if (interestedColor == 2)
			{
				notInterestedColor[0] = 0;
				notInterestedColor[1] = 1;
			}

			memcpy(candidateDefectPoint, colorMaskingArea, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

			// ̹ ǴܵǴ  ŷ ó
			for (i = st_y; i < end_y; i++)
			{
				for (j = st_x; j < end_x; j++)
				{
					tempAddress = MAX_IMAGE_WIDTH * i + j;

					if (colorMaskingArea[tempAddress])
					{
						colorValue[interestedColor] = ColorSourceImage[tempAddress * 3 + interestedColor];
						colorValue[notInterestedColor[0]] = ColorSourceImage[tempAddress * 3 + notInterestedColor[0]];
						colorValue[notInterestedColor[1]] = ColorSourceImage[tempAddress * 3 + notInterestedColor[1]];

						if (!(colorValue[interestedColor] > colorValue[notInterestedColor[0]] + TabletGradeData.ETC_ColorDirtyIgnoreLevel &&
							  colorValue[interestedColor] > colorValue[notInterestedColor[1]] + TabletGradeData.ETC_ColorDirtyIgnoreLevel))
						{
							colorMaskingArea[tempAddress] = 0;
						}
					}
				}
			}

			// ũ  .      ũ⺸ ū쿡 ҷ ó  (ݸ)
			for (i = st_y; i < end_y; i++)
			{
				for (j = st_x; j < end_x; j++)
				{
					tempAddress = MAX_IMAGE_WIDTH * i + j;

					if (colorMaskingArea[tempAddress] && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
					{
						defectPointData[defectPointDataCnt * 3] = j;
						defectPointData[defectPointDataCnt * 3 + 1] = i;
						defectPointData[defectPointDataCnt * 3 + 2] = 1;
						defectPointDataCnt++;
					}
				}
			}

			// ҷ θ .
			{
				defectGroupN = ColorDotLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

				tMax = 1;
				maxPixelDefectLabelN = -1;

				for (m = 1; m <= defectGroupN; m++)
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.ETC_ColorDirtySize)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_COLOR_LARGE_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN],
											EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
					}
				}
			}

			if (!DefectSW)
			{
				memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
				defectPointDataCnt = 0;

				// ҷ ĺ  Ȯ.
				for (i = st_y + 2; i < end_y - 2; i++)
				{
					for (j = st_x + 2; j < end_x - 2; j++)
					{
						if (colorMaskingArea[MAX_IMAGE_WIDTH * i + j])
						{
							for (y = i - 2; y <= i + 2; y++)
							{
								for (x = j - 2; x <= j + 2; x++)
								{
									tempMaskBuf[MAX_IMAGE_WIDTH * y + x] = 1;
								}
							}
						}
					}
				}

#ifdef PC_SIM
				memcpy(colorMaskingArea, tempMaskBuf, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif

				for (i = st_y; i < end_y; i++)
				{
					for (j = st_x; j < end_x; j++)
					{
						tempAddress = MAX_IMAGE_WIDTH * i + j;
						areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];

						if (candidateDefectPoint[tempAddress] && !tempMaskBuf[tempAddress])
						{
							if (TempImage[tempAddress])
							{
								if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
								{
									defectPointData[defectPointDataCnt * 3] = j;
									defectPointData[defectPointDataCnt * 3 + 1] = i;
									defectPointData[defectPointDataCnt * 3 + 2] = TempImage[tempAddress];
									defectPointDataCnt++;
								}
							}
							else
							{
								brightDefectCheckSW = 0;
								darkDefectCheckSW = 0;
								tempCount = 0;
								thresholdDark = thresholdForEaceArea[areaValue];
								if (inspectionAcceptArea[areaValue] == 1) // Print  ƴ 
								{
									searchRange = 12;
									if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
									{
										if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation == NOT_PLATE)
											searchRange = 9 - TabletGradeData.front_edge_Intensity;
										else if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation != NOT_PLATE)
											searchRange = 3;
										else if (TabletCharacter.shape == ETC && TabletCharacter.plateInformation != NOT_PLATE)
											searchRange = 3;
										else
											searchRange = 9 - TabletGradeData.front_edge_Intensity;
									}

									selfPositionValueAvg = OneColorImage[tempAddress];

									maxDiff = -1;
									for (r = searchRange; r >= 2; r -= 4)
									{
										yShift = r * MAX_IMAGE_WIDTH;
										tempAddress2 = tempAddress - yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress + yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress + yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress - yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress + yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										tempAddress2 = tempAddress - yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
										{
											if (BrightPixelNeighborPrint[tempAddress2])
												continue;

											tempCount++;
											colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

											if (colorDiff > thresholdDark)
											{
												darkDefectCheckSW++;
												if (maxDiff < colorDiff)
													maxDiff = colorDiff;
											}
											if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
											{
												brightDefectCheckSW++;
											}
										}
										if (tempCount >= 3)
										{
											if (darkDefectCheckSW >= defectCheckPointCount[areaValue])
											{
												if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
												{
													defectPointData[defectPointDataCnt * 3] = j;
													defectPointData[defectPointDataCnt * 3 + 1] = i;
													defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

													defectPointDataCnt++;
												}
												break;
											}
											else if (brightDefectCheckSW >= 4)
											{
												if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
												{
													defectPointData[defectPointDataCnt * 3] = j;
													defectPointData[defectPointDataCnt * 3 + 1] = i;
													defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;
													defectPointDataCnt++;
												}
												break;
											}
											if (r == 4)
												break;
										}
									}
								}
								else if (inspectionAcceptArea[areaValue] == 3)
								{
									if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint && TabletCharacter.discriminationDisplay_kind != PRINT)
									{
										selfPositionValueAvg = MeanOneColorImage[tempAddress];

										maxDiff = 0;
										searchRange = 12;
										for (r = searchRange; r >= 8; r -= 4)
										{
											yShift = r * MAX_IMAGE_WIDTH;
											tempAddress2 = tempAddress - yShift;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;
												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress + yShift;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress - r;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress + r;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress + yShift + r;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress - yShift - r;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress + yShift - r;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											tempAddress2 = tempAddress - yShift + r;
											if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
											{
												tempCount++;
												tagetPositionValue = MeanOneColorImage[tempAddress2];

												colorDiff = tagetPositionValue - selfPositionValueAvg;

												if (colorDiff > thresholdDark)
												{
													darkDefectCheckSW++;

													if (maxDiff < colorDiff)
													{
														maxDiff = colorDiff;
													}
												}
											}
											if (tempCount >= 3 && darkDefectCheckSW >= defectCheckPointCount[areaValue])
											{
												if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
												{
													defectPointData[defectPointDataCnt * 3] = j;
													defectPointData[defectPointDataCnt * 3 + 1] = i;
													defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

													defectPointDataCnt++;
												}
												break;
											}
										}
									}
									else
									{
										printLabelNum = PrintLabelArea[tempAddress] & 0x0F;

										if (printLabelNum)
										{
											selfPositionValueAvg = MeanOneColorImage[tempAddress];
											tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > printThreshold && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
											{
												defectPointData[defectPointDataCnt * 3] = j;
												defectPointData[defectPointDataCnt * 3 + 1] = i;
												defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

												defectPointDataCnt++;
											}
										}
									}
								}
								else if (inspectionAcceptArea[areaValue] == 4)
								{
									selfPositionValueAvg = (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]); //  ӵ  Ͽ 3  .

									searchRange = 5;

									edgeCheckResult = 0;

									edgeDefectLeftSW = edgeDefectRightSW = edgeDefectUpSW = edgeDefectDownSW = 0;
									edgeDefectLeftUpSW = edgeDefectLeftDownSW = edgeDefectRightUpSW = edgeDefectRightDownSW = 0;
									for (r = searchRange; r >= 2; r--)
									{
										yShift = r * MAX_IMAGE_WIDTH;

										tempAddress2 = tempAddress - yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectUpSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectUpSW = 1;
											}
										}
										tempAddress2 = tempAddress + yShift;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectDownSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectDownSW = 1;
											}
										}
										tempAddress2 = tempAddress - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectLeftSW = 1;
											}
										}
										tempAddress2 = tempAddress + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectRightSW = 1;
											}
										}
										tempAddress2 = tempAddress - yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftUpSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectLeftUpSW = 1;
											}
										}
										tempAddress2 = tempAddress + yShift - r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftDownSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectLeftDownSW = 1;
											}
										}
										tempAddress2 = tempAddress - yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightUpSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectRightUpSW = 1;
											}
										}
										tempAddress2 = tempAddress + yShift + r;
										if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightDownSW)
										{
											colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
											if (colorDiff > thresholdDark * 3)
											{
												edgeDefectRightDownSW = 1;
											}
										}

										if (((edgeDefectUpSW || edgeDefectLeftUpSW || edgeDefectRightUpSW) && edgeDefectDownSW && edgeDefectRightSW && edgeDefectLeftSW) ||
											(edgeDefectUpSW && (edgeDefectDownSW || edgeDefectLeftDownSW || edgeDefectRightDownSW) && edgeDefectRightSW && edgeDefectLeftSW) ||
											(edgeDefectUpSW && edgeDefectDownSW && (edgeDefectRightSW || edgeDefectRightUpSW || edgeDefectRightDownSW) && edgeDefectLeftSW) ||
											(edgeDefectUpSW && edgeDefectDownSW && edgeDefectRightSW && (edgeDefectLeftSW || edgeDefectLeftUpSW || edgeDefectLeftDownSW)) ||
											(edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW && edgeDefectRightSW && edgeDefectRightUpSW) ||
											(edgeDefectLeftUpSW && edgeDefectLeftSW && edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW) ||
											(edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW && edgeDefectRightSW && edgeDefectRightDownSW) ||
											(edgeDefectLeftDownSW && edgeDefectLeftSW && edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW))
										{
											if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
											{
												defectPointData[defectPointDataCnt * 3] = j;
												defectPointData[defectPointDataCnt * 3 + 1] = i;
												defectPointData[defectPointDataCnt * 3 + 2] = colorDiff / 3;

												defectPointDataCnt++;

												edgeCheckResult = 1;

												break;
											}
										}
									}

									if (!edgeCheckResult) // ҷ ƴ 
									{
										shellValue = tShellInspectionArea[tempAddress];

										if (shellValue)
										{
											tagetPositionValue = shellAvgColor[shellValue - 1];

											colorDiff = tagetPositionValue - selfPositionValueAvg;

											if (colorDiff > thresholdDark && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
											{
												defectPointData[defectPointDataCnt * 3] = j;
												defectPointData[defectPointDataCnt * 3 + 1] = i;
												defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

												defectPointDataCnt++;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	else // SENSITIVITY HIGH
	{
		for (i = st_y; i < end_y; i++)
		{
			for (j = st_x; j < end_x; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];
				
				if (inspectionAcceptArea[areaValue])
				{
					if (TempImage[tempAddress]) // Ƽŷ ̳  ׵θ αٿ ҷ üũ
					{
						if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
						{
							defectPointData[defectPointDataCnt * 3] = j;
							defectPointData[defectPointDataCnt * 3 + 1] = i;
							defectPointData[defectPointDataCnt * 3 + 2] = TempImage[tempAddress];
							defectPointDataCnt++;
						}
					}
					else
					{
						brightDefectCheckSW = 0;
						darkDefectCheckSW = 0;
						tempCount = 0;
						thresholdDark = thresholdForEaceArea[areaValue];
						if (inspectionAcceptArea[areaValue] == 1) // Print  ƴ 
						{
							searchRange = 12;
							if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
							{
								if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation == NOT_PLATE)
									searchRange = 9 - TabletGradeData.front_edge_Intensity;
								else if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation != NOT_PLATE)
									searchRange = 3;
								else if (TabletCharacter.shape == ETC && TabletCharacter.plateInformation != NOT_PLATE)
									searchRange = 3;
								else
									searchRange = 9 - TabletGradeData.front_edge_Intensity;
							}

							selfPositionValueB = ColorSourceImage[tempAddress * 3 + 0];
							selfPositionValueG = ColorSourceImage[tempAddress * 3 + 1];
							selfPositionValueR = ColorSourceImage[tempAddress * 3 + 2];

							maxDiff = -1;
							for (r = searchRange; r >= 2; r -= 4)
							{
								yShift = r * MAX_IMAGE_WIDTH;
								tempAddress2 = tempAddress - yShift;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress + yShift;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress + yShift + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress - yShift - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress + yShift - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								tempAddress2 = tempAddress - yShift + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									if (BrightPixelNeighborPrint[tempAddress2])
										continue;

									tempCount++;
									colorDiffB = ColorSourceImage[tempAddress2 * 3 + 0] - selfPositionValueB;
									colorDiffG = ColorSourceImage[tempAddress2 * 3 + 1] - selfPositionValueG;
									colorDiffR = ColorSourceImage[tempAddress2 * 3 + 2] - selfPositionValueR;

									colorDiff = max(max(colorDiffB, colorDiffG), colorDiffR);
									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 4 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								if (tempCount >= 3)
								{
									if (darkDefectCheckSW >= defectCheckPointCount[areaValue])
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = j;
											defectPointData[defectPointDataCnt * 3 + 1] = i;
											defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

											defectPointDataCnt++;
										}
										break;
									}
									else if (brightDefectCheckSW >= 4)
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = j;
											defectPointData[defectPointDataCnt * 3 + 1] = i;
											defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;
											defectPointDataCnt++;
										}
										break;
									}
									if (r == 4)
										break;
								}
							}
						}
						else if (inspectionAcceptArea[areaValue] == 3)
						{
							if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint && TabletCharacter.discriminationDisplay_kind != PRINT)
							{
								selfPositionValueAvg = MeanOneColorImage[tempAddress];

								maxDiff = 0;
								searchRange = 12;
								for (r = searchRange; r >= 8; r -= 4)
								{
									yShift = r * MAX_IMAGE_WIDTH;
									tempAddress2 = tempAddress - yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;
										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress + yShift;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress + yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress - yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress + yShift - r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									tempAddress2 = tempAddress - yShift + r;
									if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
									{
										tempCount++;
										tagetPositionValue = MeanOneColorImage[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									if (tempCount >= 3 && darkDefectCheckSW >= defectCheckPointCount[areaValue])
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = j;
											defectPointData[defectPointDataCnt * 3 + 1] = i;
											defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

											defectPointDataCnt++;
										}
										break;
									}
								}
							}
							else
							{
								printLabelNum = PrintLabelArea[tempAddress] & 0x0F;

								if (printLabelNum)
								{
									selfPositionValueAvg = MeanOneColorImage[tempAddress];
									tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > printThreshold && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
									{
										defectPointData[defectPointDataCnt * 3] = j;
										defectPointData[defectPointDataCnt * 3 + 1] = i;
										defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

										defectPointDataCnt++;
									}
								}
							}
						}
						else if (inspectionAcceptArea[areaValue] == 4)
						{
							selfPositionValueAvg = (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]); //  ӵ  Ͽ 3  .

							searchRange = 5;

							edgeCheckResult = 0;

							edgeDefectLeftSW = edgeDefectRightSW = edgeDefectUpSW = edgeDefectDownSW = 0;
							edgeDefectLeftUpSW = edgeDefectLeftDownSW = edgeDefectRightUpSW = edgeDefectRightDownSW = 0;
							for (r = searchRange; r >= 2; r--)
							{
								yShift = r * MAX_IMAGE_WIDTH;

								tempAddress2 = tempAddress - yShift;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectUpSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectUpSW = 1;
									}
								}
								tempAddress2 = tempAddress + yShift;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectDownSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectDownSW = 1;
									}
								}
								tempAddress2 = tempAddress - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectLeftSW = 1;
									}
								}
								tempAddress2 = tempAddress + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectRightSW = 1;
									}
								}
								tempAddress2 = tempAddress - yShift - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftUpSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectLeftUpSW = 1;
									}
								}
								tempAddress2 = tempAddress + yShift - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectLeftDownSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectLeftDownSW = 1;
									}
								}
								tempAddress2 = tempAddress - yShift + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightUpSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectRightUpSW = 1;
									}
								}
								tempAddress2 = tempAddress + yShift + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]] && !edgeDefectRightDownSW)
								{
									colorDiff = (ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2]) - selfPositionValueAvg;
									if (colorDiff > thresholdDark * 3)
									{
										edgeDefectRightDownSW = 1;
									}
								}

								if (((edgeDefectUpSW || edgeDefectLeftUpSW || edgeDefectRightUpSW) && edgeDefectDownSW && edgeDefectRightSW && edgeDefectLeftSW) ||
									(edgeDefectUpSW && (edgeDefectDownSW || edgeDefectLeftDownSW || edgeDefectRightDownSW) && edgeDefectRightSW && edgeDefectLeftSW) ||
									(edgeDefectUpSW && edgeDefectDownSW && (edgeDefectRightSW || edgeDefectRightUpSW || edgeDefectRightDownSW) && edgeDefectLeftSW) ||
									(edgeDefectUpSW && edgeDefectDownSW && edgeDefectRightSW && (edgeDefectLeftSW || edgeDefectLeftUpSW || edgeDefectLeftDownSW)) ||
									(edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW && edgeDefectRightSW && edgeDefectRightUpSW) ||
									(edgeDefectLeftUpSW && edgeDefectLeftSW && edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW) ||
									(edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW && edgeDefectRightSW && edgeDefectRightDownSW) ||
									(edgeDefectLeftDownSW && edgeDefectLeftSW && edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW))
								{
									if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
									{
										defectPointData[defectPointDataCnt * 3] = j;
										defectPointData[defectPointDataCnt * 3 + 1] = i;
										defectPointData[defectPointDataCnt * 3 + 2] = colorDiff / 3;

										defectPointDataCnt++;

										edgeCheckResult = 1;

										break;
									}
								}
							}

							if (!edgeCheckResult)
							{
								shellValue = tShellInspectionArea[tempAddress];

								if (shellValue)
								{
									tagetPositionValue = shellAvgColor[shellValue - 1];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > thresholdDark && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
									{
										defectPointData[defectPointDataCnt * 3] = j;
										defectPointData[defectPointDataCnt * 3 + 1] = i;
										defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

										defectPointDataCnt++;
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// 帰  .
	if (!DefectSW)
	{	
		// ҷ θ .
		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

			//  
			if (SelectedFace == FRONT_FACE_FOR_COLOR)
			{
				for (m = 1; m <= defectGroupN; m++)
				{
					if (Pixel_N_Of_MoreDarkOfLabel[m] > TabletGradeData.front_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[m], EndX_Label[m], StartY_Label[m], EndY_Label[m], Pixel_N_Of_MoreDarkOfLabel[m]);
						break;
					}
				}
			}
			else
			{
				for (m = 1; m <= defectGroupN; m++)
				{
					if (Pixel_N_Of_MoreDarkOfLabel[m] > TabletGradeData.rear_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[m], EndX_Label[m], StartY_Label[m], EndY_Label[m], Pixel_N_Of_MoreDarkOfLabel[m]);
						break;
					}
				}
			}

			if (DefectSW == 0)
			{
				// 帰 
				// 𼭸 ҷ ƴ 
				tMax = 1;
				maxPixelDefectLabelN = -1;
				for (m = 1; m <= defectGroupN; m++)
				{
					if (PixelNInShapeEdgeNeighbor[m] * 100 < Pixel_N_Of_Label[m] * 90)
					{
						if (Pixel_N_Of_Label[m] > tMax)
						{
							tMax = Pixel_N_Of_Label[m];
							maxPixelDefectLabelN = m;
						}
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (SelectedFace == FRONT_FACE_FOR_COLOR)
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_stain_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
					else
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_stain_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
				}
			}

			if (DefectSW == 0)
			{
				// 帰 
				// 𼭸 ҷ 
				tMax = 1;
				maxPixelDefectLabelN = -1;
				for (m = 1; m <= defectGroupN; m++)
				{
					if (PixelNInShapeEdgeNeighbor[m] * 100 >= Pixel_N_Of_Label[m] * 90)
					{
						if (SelectedFace == FRONT_FACE_FOR_COLOR)
						{
							if (Pixel_N_Of_Label[m] > TabletGradeData.front_edge_Size)
							{
								if (Pixel_N_Of_Label[m] > tMax)
								{
									tMax = Pixel_N_Of_Label[m];
									maxPixelDefectLabelN = m;
								}
							}
						}
						else
						{
							if (Pixel_N_Of_Label[m] > TabletGradeData.rear_edge_Size)
							{
								if (Pixel_N_Of_Label[m] > tMax)
								{
									tMax = Pixel_N_Of_Label[m];
									maxPixelDefectLabelN = m;
								}
							}
						}
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (SelectedFace == FRONT_FACE_FOR_COLOR)
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_edge_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN],
												   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
					else
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_edge_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN],
												   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
				}
			}
		}
	}

	if (!DefectSW)
	{
		// 帰  ó Ϸ, £ ̹ ó (  )

		memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
		defectPointDataCnt = 0;

		searchRange = 12;

		compareAcceptArea[NORMAL_INPECTION_AREA][NORMAL_INPECTION_AREA] = 1;
		compareAcceptArea[NORMAL_INPECTION_AREA][FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 1;
		compareAcceptArea[NORMAL_INPECTION_AREA][FRONT_SHAPE_EDGE_AND_PRINT_SHORT] = 1;
		compareAcceptArea[NORMAL_INPECTION_AREA][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;

		for (y = st_y; y < end_y; y++)
		{
			for (x = st_x; x < end_x; x++)
			{
				tempAddress = MAX_IMAGE_WIDTH * y + x;

				if (tempMaskBuf[tempAddress])
					continue; // color spot
				
				areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];

				if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
				{
					topSW = bottomSW = leftSW = rightSW = topLeftSW = topRightSW = bottomLeftSW = bottomRightSW = 0;
					darkDefectCheckSW = 0;

					thresholdDark = edgeNeighborSpotThreshold;

					selfPositionValueAvg = OneColorImage[tempAddress];

					maxDiff = 0;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								leftSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								rightSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								topSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								bottomSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 1)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH - r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								topLeftSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 2)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH + r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								topRightSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 3)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH - r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								bottomLeftSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 4)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH + r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								bottomRightSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					if (darkDefectCheckSW < 5)
						continue;

					if (((topSW && bottomSW) ||
						(leftSW && rightSW) ||
						(topRightSW && bottomLeftSW) ||
						(topLeftSW && bottomRightSW)) && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
					{
						defectPointData[defectPointDataCnt * 3] = x;
						defectPointData[defectPointDataCnt * 3 + 1] = y;
						defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;
						defectPointDataCnt++;
					}
				}
				else if (areaValue == NORMAL_INPECTION_AREA)
				{
					topSW = bottomSW = leftSW = rightSW = topLeftSW = topRightSW = bottomLeftSW = bottomRightSW = 0;
					darkDefectCheckSW = 0;

					thresholdDark = normalAreaSpotThreshold;

					selfPositionValueAvg = OneColorImage[tempAddress];

					maxDiff = 0;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								leftSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								rightSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								topSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								bottomSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 1)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH - r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								topLeftSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 2)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH + r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								topRightSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 3)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH - r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								bottomLeftSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}
					if (darkDefectCheckSW < 4)
						continue;

					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH + r;

						if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								if (maxDiff < colorDiff)
									maxDiff = maxDiff;

								bottomRightSW = 1;
								darkDefectCheckSW++;
								break;
							}
						}
					}

					if (darkDefectCheckSW < 5)
						continue;

					if (((topSW && bottomSW) ||
						(leftSW && rightSW) ||
						(topRightSW && bottomLeftSW) ||
						(topLeftSW && bottomRightSW)) && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
					{
						defectPointData[defectPointDataCnt * 3] = x;
						defectPointData[defectPointDataCnt * 3 + 1] = y;
						defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;
						defectPointDataCnt++;
					}
				}
			}
		}
		
		// ҷ θ .
		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

			// £ ̹
			// 𼭸 ҷ ƴ 
			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (PixelNInShapeEdgeNeighbor[m] * 100 < Pixel_N_Of_Label[m] * 90)
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (SelectedFace == FRONT_FACE_FOR_COLOR)
				{
					if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
					}
				}
				else
				{
					if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
					}
				}
			}

			if (DefectSW == 0)
			{
				// £ ̹
				// 𼭸 ҷ 
				tMax = 1;
				maxPixelDefectLabelN = -1;
				for (m = 1; m <= defectGroupN; m++)
				{
					if (PixelNInShapeEdgeNeighbor[m] * 100 >= Pixel_N_Of_Label[m] * 90)
					{
						if (Pixel_N_Of_Label[m] > tMax)
						{
							tMax = Pixel_N_Of_Label[m];
							maxPixelDefectLabelN = m;
						}
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (SelectedFace == FRONT_FACE_FOR_COLOR)
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_edge_dirty_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
					else
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_edge_dirty_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
				}
			}
		}
	}

#ifdef PC_SIM
	memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif

}
//---------------------------------------------------------------------------
void HighResolutionDefectSearchForFrontShape(int cameraIndex)
{
	int defectGroupN;
	int m, r, x, y;
	int tempX, tempY;
	int darkDefectCheckSW;
	int brightDefectCheckSW;
	int selfPositionValueAvg;

	int thresholdDark;
	int thresholdBright;
	int tempAddress;
	int tempAddress2;
	int tempCount;
	int areaValue;

	int colorDiff;
	int alpha;
	int tagetPositionValue;

	int searchRange;

	short defectPointData[MAX_DEFECT_POINT_COUNT * 3];
	int defectPointDataCnt;

	int inspectionAcceptArea[12];
	int compareAcceptArea[12][12];
	int thresholdForEaceArea[12];
	int defectCheckPointCount[12];

	int maxPixelDefectLabelN;
	int tMax;
	int maxDiff;

	int tempEdgeIntensity;
	int tempEdgeMask;

	int PrintNeighbotThreshold_Short;
	int PrintNeighbotThreshold_Long;

	int edgeDefectLeftSW, edgeDefectRightSW, edgeDefectUpSW, edgeDefectDownSW;
	int edgeDefectLeftUpSW, edgeDefectLeftDownSW, edgeDefectRightUpSW, edgeDefectRightDownSW;

	int edgeCheckResult;
	int shellValue;
	int printLabelNum;
	int tempImageWidth;
	int smallSizeAddress;
	int smallSizeAddress2;
	int i;
	int edgeNeighborBlurThreshold;
	int edgeNeighborSpotThreshold;
	int normalAreaBlurThreshold;
	int normalAreaSpotThreshold;

	int printAreaMask;

	int topSW, bottomSW, leftSW, rightSW, topLeftSW, topRightSW, bottomLeftSW, bottomRightSW;
	int tabletColor;
	int printThreshold;

	int st_x, end_x, st_y, end_y;

	st_x = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	end_x = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	st_y = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	end_y = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	if (st_x < 20)
		st_x = 20;
	if (end_x > MAX_IMAGE_WIDTH - 20)
		end_x = MAX_IMAGE_WIDTH - 20;
	if (st_y < 20)
		st_y = 20;
	if (end_y > MAX_IMAGE_HEIGHT - 20)
		end_y = MAX_IMAGE_HEIGHT - 20;

	if (SelectedFace == FRONT_FACE_FOR_COLOR)
	{
		tempEdgeIntensity = TabletGradeData.front_edge_Intensity;
	}
	else
	{
		tempEdgeIntensity = TabletGradeData.rear_edge_Intensity;
	}

	tempEdgeMask = TabletGradeData.front_unInspectionIntensity_ForEdge;

	for (m = 0; m < ShapeShellDataCount[0]; m++)
	{
		x = ShapeShellData[0][m][0];
		y = ShapeShellData[0][m][1];
		for (tempY = y - tempEdgeMask; tempY <= y + tempEdgeMask; tempY++)
		{
			for (tempX = x - tempEdgeMask; tempX <= x + tempEdgeMask; tempX++)
			{
				tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
				if (InspectionArea[tempAddress])
					InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
			}
		}
	}

	if (tempEdgeIntensity <= 3)
	{
		for (m = 0; m < ShapeShellDataCount[0]; m++)
		{
			x = ShapeShellData[0][m][0];
			y = ShapeShellData[0][m][1];
			for (tempY = y - 1; tempY <= y + 1; tempY++)
			{
				for (tempX = x - 1; tempX <= x + 1; tempX++)
				{
					tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
					InspectionArea[tempAddress] = 0;
				}
			}
		}
	}
	else if (tempEdgeIntensity > 3)
	{
		for (m = 0; m < ShapeShellDataCount[0]; m++)
		{
			x = ShapeShellData[0][m][0];
			y = ShapeShellData[0][m][1];
			for (tempY = y - 2; tempY <= y + 2; tempY++)
			{
				for (tempX = x - 2; tempX <= x + 2; tempX++)
				{
					tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
					InspectionArea[tempAddress] = 0;
				}
			}
		}
	}

	for (m = 0; m < ShapeShellDataCount[0]; m++)
	{
		x = ShapeShellData[0][m][0];
		y = ShapeShellData[0][m][1];
		for (tempY = y - 2; tempY <= y + 2; tempY++)
		{
			for (tempX = x - 2; tempX <= x + 2; tempX++)
			{
				tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
				InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
			}
		}
	}

	if (globalFrontFaceSplitLineMatchingSW)
	{
		printAreaMask = TabletGradeData.front_unInspectionIntensity_ForPrint + 4;

		for (m = 0; m < globalTabletSplitLineDataCount; m++)
		{
			x = globalTabletSplitLineData[m][0];
			y = globalTabletSplitLineData[m][1];

			for (tempY = y - printAreaMask; tempY <= y + printAreaMask; tempY++)
			{
				for (tempX = x - printAreaMask; tempX <= x + printAreaMask; tempX++)
				{
					tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;

					if (InspectionArea[tempAddress] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress])
					{
						InspectionArea[tempAddress] = FRONT_FACE_SPLIT_AREA;
					}
				}
			}
		}

		for (y = st_y; y < end_y; y++)
		{
			for (x = st_x; x < end_x; x++)
			{
				tempAddress = MAX_IMAGE_WIDTH * y + x;
				if (InspectionArea[tempAddress] == FRONT_FACE_SPLIT_AREA)
				{
					for (tempY = y - 5; tempY <= y + 5; tempY++)
					{
						for (tempX = x - 5; tempX <= x + 5; tempX++)
						{
							tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;

							if (InspectionArea[tempAddress])
							{
								if (InspectionArea[tempAddress] != FRONT_FACE_SPLIT_AREA &&
									InspectionArea[tempAddress] != PRINT_AREA &&
									InspectionArea[tempAddress] != FRONT_SHAPE_EDGE)
								{
									InspectionArea[tempAddress] = PRINT_NEIGHBOR_SHORT;
								}
							}
						}
					}
				}
			}
		}
	}

	unsigned char *tempInspectionArea = ThreeD_Image; // ӽ .
	short *label_Image = RotationEdgeImage;
	
	memset(tempInspectionArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	for (y = st_y; y < end_y; y++)
	{
		for (x = st_x; x < end_x; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionArea[tempAddress] == FRONT_MASKING_AREA)
				tempInspectionArea[tempAddress] = 0;
			else
				tempInspectionArea[tempAddress] = InspectionArea[tempAddress];
		}
	}

	tempImageWidth = HD_IMAGE_WIDTH;

	thresholdDark = 30;

	memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
	defectPointDataCnt = 0;

	if (SelectedFace == FRONT_FACE_FOR_COLOR)
	{
		alpha = (TabletGradeData.front_stain_Intensity - 1) * 2;
		normalAreaBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + alpha;
		normalAreaSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.front_dirty_Intensity * 2;

		edgeNeighborBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + (TabletGradeData.front_edge_Intensity - 1) * 3;
		edgeNeighborSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.front_edge_dirty_Intensity * 2;
	}
	else
	{
		alpha = (TabletGradeData.rear_stain_Intensity - 1) * 2;
		normalAreaBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + alpha;
		normalAreaSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.rear_dirty_Intensity * 2;

		edgeNeighborBlurThreshold = FORNT_NORMAL_INPECTION_AREA_THRESH + (TabletGradeData.rear_edge_Intensity - 1) * 3;
		edgeNeighborSpotThreshold = FORNT_DIRTY_THRESH2 + TabletGradeData.rear_edge_dirty_Intensity * 2;
	}

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH;
		PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH;
	}
	else
	{
		if (BlurredEngraveSW)
		{
			PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH / 4;
			PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH / 4;
		}
		else
		{
			PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH / 2;
			PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH / 2;
		}
	}

	thresholdBright = FORNT_NORMAL_INPECTION_AREA_BRIGHT_THRESH + alpha;
	tabletColor = max(2, MeanColorG / 20);

	for (m = 0; m < 12; m++)
	{
		thresholdForEaceArea[m] = 15;
		if (m == NORMAL_INPECTION_AREA)
		{
			thresholdForEaceArea[m] = normalAreaBlurThreshold;
		}
		else if (m == PRINT_NEIGHBOR_SHORT || m == PRINT_NEIGHBOR_LONG)
		{
			thresholdForEaceArea[m] = normalAreaBlurThreshold + FORNT_NORMAL_INPECTION_AREA_THRESH;
		}
		else if (m == FRONT_SHAPE_EDGE_NEIGHBOR || m == FRONT_SHAPE_EDGE)
		{
			thresholdForEaceArea[m] = edgeNeighborBlurThreshold;
		}
		else if (m == PRINT_AREA)
		{
			if (SelectedFace == FRONT_FACE_FOR_COLOR)
			{
				if (TabletGradeData.front_print_dirty_Inetensity == 1)
				{
					thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity;
				}
				else
				{
					thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity * (TabletGradeData.front_print_dirty_Inetensity - 1);
				}
			}
			else
			{
				if (TabletGradeData.rear_print_dirty_Inetensity == 1)
				{
					thresholdForEaceArea[m] = tabletColor * TabletGradeData.rear_print_dirty_Inetensity;
				}
				else
				{
					thresholdForEaceArea[m] = tabletColor * TabletGradeData.rear_print_dirty_Inetensity * (TabletGradeData.rear_print_dirty_Inetensity - 1);
				}
			}
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
		{
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Short + alpha * 2;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
		{
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Long + alpha * 2;
		}
	}

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		printThreshold = 2 * TabletGradeData.front_print_dirty_Inetensity2;
		if (TabletGradeData.front_print_dirty_Inetensity2 == 30) // max
		{
			printThreshold = 255;
		}
	}
	else
	{
		printThreshold = thresholdForEaceArea[PRINT_AREA];
	}

	for (m = 0; m < 12; m++)
	{
		inspectionAcceptArea[m] = 1;
		if (m == FRONT_SHAPE_EDGE)
		{
			if (TabletGradeData.ETC_FrontFaceEdgeInspectionSW)
				inspectionAcceptArea[m] = 4;
			else
				inspectionAcceptArea[m] = 0;
		}

		if (m == PRINT_AREA)
		{
			inspectionAcceptArea[m] = 3;
		}

		if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
		{
			inspectionAcceptArea[m] = 1;
			if (TabletCharacter.kind == SUGARCOATING)
				inspectionAcceptArea[m] = 2;
		}

		if (m == FRONT_FACE_SPLIT_AREA)
		{
			inspectionAcceptArea[m] = 0;
		}
	}
	inspectionAcceptArea[0] = 0;

	for (m = 0; m < 12; m++)
	{
		defectCheckPointCount[m] = 3;
		if (m == FRONT_SHAPE_EDGE)
			defectCheckPointCount[m] = 2;
		if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
			defectCheckPointCount[m] = 2;
		if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
			defectCheckPointCount[m] = 2;
		if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
			defectCheckPointCount[m] = 2;
		if (m == PRINT_AREA || m == FRONT_FACE_SPLIT_AREA)
			defectCheckPointCount[m] = 3;
	}

	for (m = 0; m < 12; m++)
	{
		for (i = 0; i < 12; i++)
			compareAcceptArea[m][i] = 0;

		if (m == NORMAL_INPECTION_AREA)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
		{
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
		{
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == PRINT_NEIGHBOR_SHORT)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
		}
		else if (m == PRINT_NEIGHBOR_LONG)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
		}
		else if (m == PRINT_AREA || m == FRONT_FACE_SPLIT_AREA)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_SHORT] = 1;
			compareAcceptArea[m][PRINT_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
	}

	// ػ 忡 °  Ȯ.
	st_x = st_x * 2;
	end_x = end_x * 2;
	st_y = st_y * 2;
	end_y = end_y * 2;

	memset(OneColorImageHighResolution, 0, HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT);
	for (y = st_y; y < end_y; y++)
	{
		for (x = st_x; x < end_x; x++)
		{
			tempAddress = tempImageWidth * y + x;

			OneColorImageHighResolution[tempAddress] = tempColorSourceImage[tempAddress * 3 + selectedRGB];
		}
	}

	if (globalFrontFaceSplitLineMatchingSW)
	{
		// 2021-04-02
		// Ҽ Ī 
		// μ + Ҽ ȥ  شϴ  ش ̽ 
		// ̶, ΰ & ޼   ̹ ȭ  뿡  ݿ ȵǾ
		//   ϵ,   Ǵ   ʿ
		thresholdDark = thresholdForEaceArea[PRINT_AREA];
		
		int xhalf, yhalf;
		for (y = st_y, yhalf = y / 2; y < end_y; ++y, ((y & 1) == 0 && ++yhalf))		
		{
			for (x = st_x, xhalf = x / 2; x < end_x; ++x, ((x & 1) == 0 && ++xhalf))			
			{
				tempAddress = tempImageWidth * y + x;
				smallSizeAddress = MAX_IMAGE_WIDTH * yhalf + xhalf;

				areaValue = tempInspectionArea[smallSizeAddress];

				if (areaValue == FRONT_FACE_SPLIT_AREA)
				{
					darkDefectCheckSW = 0;
					tempCount = 0;

					selfPositionValueAvg = OneColorImageHighResolution[tempAddress];

					searchRange = 12;
					for (r = searchRange; r >= 4; r -= 4)
					{
						tempAddress2 = tempAddress - r * 2 * tempImageWidth;
						smallSizeAddress2 = smallSizeAddress - r * MAX_IMAGE_WIDTH;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;
							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress + r * 2 * tempImageWidth;
						smallSizeAddress2 = smallSizeAddress + r * MAX_IMAGE_WIDTH;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress - r * 2;
						smallSizeAddress2 = smallSizeAddress - r;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress + r * 2;
						smallSizeAddress2 = smallSizeAddress + r;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress + r * 2 * tempImageWidth + r * 2;
						smallSizeAddress2 = smallSizeAddress + r * MAX_IMAGE_WIDTH + r;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress - r * 2 * tempImageWidth - r * 2;
						smallSizeAddress2 = smallSizeAddress - r * MAX_IMAGE_WIDTH - r;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress + r * 2 * tempImageWidth - r * 2;
						smallSizeAddress2 = smallSizeAddress + r * MAX_IMAGE_WIDTH - r;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						tempAddress2 = tempAddress - r * 2 * tempImageWidth + r * 2;
						smallSizeAddress2 = smallSizeAddress - r * MAX_IMAGE_WIDTH + r;
						if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
						{
							tempCount++;
							tagetPositionValue = OneColorImageHighResolution[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > thresholdDark)
							{
								darkDefectCheckSW++;
							}
						}

						if (tempCount >= 3)
						{
							if (darkDefectCheckSW >= defectCheckPointCount[areaValue])
							{
								if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
								{
									defectPointData[defectPointDataCnt * 3] = xhalf;
									defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
									defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

									defectPointDataCnt++;
								}
								break;
							}
							if (r == 4)
								break;
						}
					}
				}
			}
		}
	}

	{
		int xhalf, yhalf;
		for (y = st_y, yhalf = y / 2; y < end_y; ++y, ((y & 1) == 0 && ++yhalf))
		{
			for (x = st_x, xhalf = x / 2; x < end_x; ++x, ((x & 1) == 0 && ++xhalf))
			{
				tempAddress = tempImageWidth * y + x;
				smallSizeAddress = MAX_IMAGE_WIDTH * yhalf + xhalf;

				areaValue = tempInspectionArea[smallSizeAddress];

				if (inspectionAcceptArea[areaValue])
				{
					if (TempImage[smallSizeAddress])
					{
						if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
						{
							defectPointData[defectPointDataCnt * 3] = xhalf;
							defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
							defectPointData[defectPointDataCnt * 3 + 2] = TempImage[smallSizeAddress];
							defectPointDataCnt++;
						}
					}
					else
					{
						brightDefectCheckSW = 0;
						darkDefectCheckSW = 0;
						tempCount = 0;
						thresholdDark = thresholdForEaceArea[areaValue];

						if (inspectionAcceptArea[areaValue] == 1) // Print  ƴ 
						{
							searchRange = 24;
							if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
							{
								if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation == NOT_PLATE)
									searchRange = 9 - TabletGradeData.front_edge_Intensity;
								else if (TabletCharacter.shape == ROUND && TabletCharacter.plateInformation != NOT_PLATE)
									searchRange = 3;
								else if (TabletCharacter.shape == ETC && TabletCharacter.plateInformation != NOT_PLATE)
									searchRange = 3;
								else
									searchRange = 9 - TabletGradeData.front_edge_Intensity;

								searchRange *= 2;
							}

							selfPositionValueAvg = OneColorImageHighResolution[tempAddress];

							maxDiff = -1;
							int r2;
							for (r = searchRange, r2 = r / 2; r >= 4; r -= 8, r2 -= 4)
							{
								tempAddress2 = tempAddress - r * tempImageWidth;
								smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress + r * tempImageWidth;
								smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress - r;
								smallSizeAddress2 = smallSizeAddress - r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress + r;
								smallSizeAddress2 = smallSizeAddress + r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress + r * tempImageWidth + r;
								smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH + r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress - r * tempImageWidth - r;
								smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH - r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress + r * tempImageWidth - r;
								smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH - r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}

								tempAddress2 = tempAddress - r * tempImageWidth + r;
								smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH + r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
								{
									if (BrightPixelNeighborPrint[smallSizeAddress2])
										continue;

									tempCount++;
									colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;
									}
									if (r <= 8 && -colorDiff > thresholdBright && areaValue == NORMAL_INPECTION_AREA)
									{
										brightDefectCheckSW++;
									}
								}
								if (tempCount >= 3)
								{
									if (darkDefectCheckSW >= defectCheckPointCount[areaValue])
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = xhalf;
											defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
											defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

											defectPointDataCnt++;
										}
										break;
									}
									else if (brightDefectCheckSW >= 4)
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = xhalf;
											defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
											defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;
											defectPointDataCnt++;
										}
										break;
									}
									if (r == 8 || r == 4)
										break;
								}
							}
						}
						else if (inspectionAcceptArea[areaValue] == 3)
						{
							if (!TabletGradeData.DirtyDefectCheckSWInNeighborPrint && TabletCharacter.discriminationDisplay_kind != PRINT)
							{
								selfPositionValueAvg = OneColorImageHighResolution[tempAddress];

								maxDiff = 0;
								searchRange = 24;
								int r2;
								for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
								{
									tempAddress2 = tempAddress - r * tempImageWidth;
									smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;
										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress + r * tempImageWidth;
									smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress - r;
									smallSizeAddress2 = smallSizeAddress - r2;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress + r;
									smallSizeAddress2 = smallSizeAddress + r2;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress + r * tempImageWidth + r;
									smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH + r2;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress - r * tempImageWidth - r;
									smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH - r2;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress + r * tempImageWidth - r;
									smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH - r2;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}

									tempAddress2 = tempAddress - r * tempImageWidth + r;
									smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH + r2;
									if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
									{
										tempCount++;
										tagetPositionValue = OneColorImageHighResolution[tempAddress2];

										colorDiff = tagetPositionValue - selfPositionValueAvg;

										if (colorDiff > thresholdDark)
										{
											darkDefectCheckSW++;

											if (maxDiff < colorDiff)
											{
												maxDiff = colorDiff;
											}
										}
									}
									if (tempCount >= 3 && darkDefectCheckSW >= defectCheckPointCount[areaValue])
									{
										if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
										{
											defectPointData[defectPointDataCnt * 3] = xhalf;
											defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
											defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

											defectPointDataCnt++;
										}
										break;
									}
								}
							}
							else
							{
								printLabelNum = PrintLabelArea[smallSizeAddress] & 0x0F;

								if (printLabelNum)
								{
									selfPositionValueAvg = OneColorImageHighResolution[tempAddress];
									tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > printThreshold && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
									{
										defectPointData[defectPointDataCnt * 3] = xhalf;
										defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
										defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

										defectPointDataCnt++;
									}
								}
							}
						}
						else if (inspectionAcceptArea[areaValue] == 4)
						{
							selfPositionValueAvg = OneColorImageHighResolution[tempAddress];

							searchRange = 10;
							edgeCheckResult = 0;

							edgeDefectLeftSW = edgeDefectRightSW = edgeDefectUpSW = edgeDefectDownSW = 0;
							edgeDefectLeftUpSW = edgeDefectLeftDownSW = edgeDefectRightUpSW = edgeDefectRightDownSW = 0;
							int r2;
							for (r = searchRange, r2 = r / 2; r >= 4; r -= 2, --r2)
							{
								tempAddress2 = tempAddress - r * tempImageWidth;
								smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectUpSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;
									if (colorDiff > thresholdDark)
									{
										edgeDefectUpSW = 1;
									}
								}

								tempAddress2 = tempAddress + r * tempImageWidth;
								smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectDownSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										edgeDefectDownSW = 1;
									}
								}

								tempAddress2 = tempAddress - r;
								smallSizeAddress2 = smallSizeAddress - r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectLeftSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										edgeDefectLeftSW = 1;
									}
								}

								tempAddress2 = tempAddress + r;
								smallSizeAddress2 = smallSizeAddress + r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectRightSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										edgeDefectRightSW = 1;
									}
								}

								tempAddress2 = tempAddress - r * tempImageWidth - r;
								smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH - r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectLeftUpSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;
									if (colorDiff > thresholdDark)
									{
										edgeDefectLeftUpSW = 1;
									}
								}

								tempAddress2 = tempAddress + r * tempImageWidth - r;
								smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH - r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectLeftDownSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;
									if (colorDiff > thresholdDark)
									{
										edgeDefectLeftDownSW = 1;
									}
								}

								tempAddress2 = tempAddress - r * tempImageWidth + r;
								smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH + r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectRightUpSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;
									if (colorDiff > thresholdDark)
									{
										edgeDefectRightUpSW = 1;
									}
								}

								tempAddress2 = tempAddress + r * tempImageWidth + r;
								smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH + r2;
								if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]] && !edgeDefectRightDownSW)
								{
									tagetPositionValue = OneColorImageHighResolution[tempAddress2];

									colorDiff = tagetPositionValue - selfPositionValueAvg;
									if (colorDiff > thresholdDark)
									{
										edgeDefectRightDownSW = 1;
									}
								}

								if (((edgeDefectUpSW || edgeDefectLeftUpSW || edgeDefectRightUpSW) && edgeDefectDownSW && edgeDefectRightSW && edgeDefectLeftSW) ||
									(edgeDefectUpSW && (edgeDefectDownSW || edgeDefectLeftDownSW || edgeDefectRightDownSW) && edgeDefectRightSW && edgeDefectLeftSW) ||
									(edgeDefectUpSW && edgeDefectDownSW && (edgeDefectRightSW || edgeDefectRightUpSW || edgeDefectRightDownSW) && edgeDefectLeftSW) ||
									(edgeDefectUpSW && edgeDefectDownSW && edgeDefectRightSW && (edgeDefectLeftSW || edgeDefectLeftUpSW || edgeDefectLeftDownSW)) ||
									(edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW && edgeDefectRightSW && edgeDefectRightUpSW) ||
									(edgeDefectLeftUpSW && edgeDefectLeftSW && edgeDefectLeftDownSW && edgeDefectDownSW && edgeDefectRightDownSW) ||
									(edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW && edgeDefectRightSW && edgeDefectRightDownSW) ||
									(edgeDefectLeftDownSW && edgeDefectLeftSW && edgeDefectLeftUpSW && edgeDefectUpSW && edgeDefectRightUpSW))
								{
									if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
									{
										defectPointData[defectPointDataCnt * 3] = xhalf;
										defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
										defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

										defectPointDataCnt++;

										edgeCheckResult = 1;

										break;
									}
								}
							}

							if (!edgeCheckResult)
							{
								shellValue = tShellInspectionArea[smallSizeAddress];

								if (shellValue)
								{
									tagetPositionValue = shellAvgColor[shellValue - 1];

									colorDiff = tagetPositionValue - selfPositionValueAvg;

									if (colorDiff > thresholdDark && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
									{
										defectPointData[defectPointDataCnt * 3] = xhalf;
										defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
										defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

										defectPointDataCnt++;
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// ҷ θ .
	{
		defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			// £ ̹
			//  
			if (SelectedFace == FRONT_FACE_FOR_COLOR)
			{
				for (m = 1; m <= defectGroupN; m++)
				{
					if (Pixel_N_Of_MoreDarkOfLabel[m] > TabletGradeData.front_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[m], EndX_Label[m], StartY_Label[m], EndY_Label[m], Pixel_N_Of_MoreDarkOfLabel[m]);
						break;
					}
				}
			}
			else
			{
				for (m = 1; m <= defectGroupN; m++)
				{
					if (Pixel_N_Of_MoreDarkOfLabel[m] > TabletGradeData.rear_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[m], EndX_Label[m], StartY_Label[m], EndY_Label[m], Pixel_N_Of_MoreDarkOfLabel[m]);
						break;
					}
				}
			}

			if (DefectSW == 0)
			{
				// 帰 
				// 𼭸 ҷ ƴ 
				tMax = 1;
				maxPixelDefectLabelN = -1;
				for (m = 1; m <= defectGroupN; m++)
				{
					if (PixelNInShapeEdgeNeighbor[m] * 100 < Pixel_N_Of_Label[m] * 90)
					{
						if (Pixel_N_Of_Label[m] > tMax)
						{
							tMax = Pixel_N_Of_Label[m];
							maxPixelDefectLabelN = m;
						}
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (SelectedFace == FRONT_FACE_FOR_COLOR)
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_stain_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
					else
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_stain_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
				}
			}

			if (DefectSW == 0)
			{
				// 帰 
				// 𼭸 ҷ 
				tMax = 1;
				maxPixelDefectLabelN = -1;
				for (m = 1; m <= defectGroupN; m++)
				{
					if (PixelNInShapeEdgeNeighbor[m] * 100 >= Pixel_N_Of_Label[m] * 90)
					{
						if (SelectedFace == FRONT_FACE_FOR_COLOR)
						{
							if (Pixel_N_Of_Label[m] > TabletGradeData.front_edge_Size)
							{
								if (Pixel_N_Of_Label[m] > tMax)
								{
									tMax = Pixel_N_Of_Label[m];
									maxPixelDefectLabelN = m;
								}
							}
						}
						else
						{
							if (Pixel_N_Of_Label[m] > TabletGradeData.rear_edge_Size)
							{
								if (Pixel_N_Of_Label[m] > tMax)
								{
									tMax = Pixel_N_Of_Label[m];
									maxPixelDefectLabelN = m;
								}
							}
						}
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (SelectedFace == FRONT_FACE_FOR_COLOR)
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_edge_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN],
												   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
					else
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_edge_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN],
												   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
				}
			}
		}
	}

	if (!DefectSW)
	{
		// 帰  ó Ϸ, £ ̹ ó (  )
		memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
		defectPointDataCnt = 0;

		searchRange = 24;

		compareAcceptArea[NORMAL_INPECTION_AREA][NORMAL_INPECTION_AREA] = 1;
		compareAcceptArea[NORMAL_INPECTION_AREA][FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 1;
		compareAcceptArea[NORMAL_INPECTION_AREA][FRONT_SHAPE_EDGE_AND_PRINT_SHORT] = 1;
		compareAcceptArea[NORMAL_INPECTION_AREA][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;

		{
			int xhalf, yhalf;
			for (y = st_y, yhalf = y / 2; y < end_y; ++y, ((y & 1) == 0 && ++yhalf))
			{
				for (x = st_x, xhalf = x / 2; x < end_x; ++x, ((x & 1) == 0 && ++xhalf))
				{
					tempAddress = tempImageWidth * y + x;
					smallSizeAddress = MAX_IMAGE_WIDTH * yhalf + xhalf;

					areaValue = (tempInspectionArea[smallSizeAddress] > 11) ? 0 : tempInspectionArea[smallSizeAddress];

					if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
					{
						topSW = bottomSW = leftSW = rightSW = topLeftSW = topRightSW = bottomLeftSW = bottomRightSW = 0;
						darkDefectCheckSW = 0;

						if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
							thresholdDark = edgeNeighborSpotThreshold;
						else
							thresholdDark = normalAreaSpotThreshold;

						selfPositionValueAvg = OneColorImageHighResolution[tempAddress];

						maxDiff = 0;

						int r2;
						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r;
							smallSizeAddress2 = smallSizeAddress - r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									leftSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r;
							smallSizeAddress2 = smallSizeAddress + r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									rightSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r * tempImageWidth;
							smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									topSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r * tempImageWidth;
							smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									bottomSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 1)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r * tempImageWidth - r;
							smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH - r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									topLeftSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 2)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r * tempImageWidth + r;
							smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH + r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									topRightSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 3)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r * tempImageWidth - r;
							smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH - r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									bottomLeftSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 4)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r * tempImageWidth + r;
							smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH + r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									bottomRightSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						if (darkDefectCheckSW < 5)
							continue;

						if (((topSW && bottomSW) ||
							(leftSW && rightSW) ||
							(topRightSW && bottomLeftSW) ||
							(topLeftSW && bottomRightSW)) && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
						{
							defectPointData[defectPointDataCnt * 3] = xhalf;
							defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
							defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;
							defectPointDataCnt++;
						}
					}
					else if (areaValue == NORMAL_INPECTION_AREA)
					{
						topSW = bottomSW = leftSW = rightSW = topLeftSW = topRightSW = bottomLeftSW = bottomRightSW = 0;
						darkDefectCheckSW = 0;

						if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
							thresholdDark = edgeNeighborSpotThreshold;
						else
							thresholdDark = normalAreaSpotThreshold;

						selfPositionValueAvg = OneColorImageHighResolution[tempAddress];

						maxDiff = 0;
						
						int r2;
						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r;
							smallSizeAddress2 = smallSizeAddress - r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									leftSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r;
							smallSizeAddress2 = smallSizeAddress + r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									rightSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r * tempImageWidth;
							smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									topSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r * tempImageWidth;
							smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									bottomSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 1)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r * tempImageWidth - r;
							smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH - r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									topLeftSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 2)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress - r * tempImageWidth + r;
							smallSizeAddress2 = smallSizeAddress - r2 * MAX_IMAGE_WIDTH + r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									topRightSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 3)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r * tempImageWidth - r;
							smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH - r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									bottomLeftSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}
						if (darkDefectCheckSW < 4)
							continue;

						for (r = searchRange, r2 = r / 2; r >= 8; r -= 8, r2 -= 4)
						{
							tempAddress2 = tempAddress + r * tempImageWidth + r;
							smallSizeAddress2 = smallSizeAddress + r2 * MAX_IMAGE_WIDTH + r2;

							if (compareAcceptArea[areaValue][tempInspectionArea[smallSizeAddress2]])
							{
								if (BrightPixelNeighborPrint[smallSizeAddress2])
									continue;

								colorDiff = OneColorImageHighResolution[tempAddress2] - selfPositionValueAvg;

								if (colorDiff > thresholdDark)
								{
									if (maxDiff < colorDiff)
										maxDiff = maxDiff;

									bottomRightSW = 1;
									darkDefectCheckSW++;
									break;
								}
							}
						}

						if (darkDefectCheckSW < 5)
							continue;

						if (((topSW && bottomSW) ||
							(leftSW && rightSW) ||
							(topRightSW && bottomLeftSW) ||
							(topLeftSW && bottomRightSW)) && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
						{
							defectPointData[defectPointDataCnt * 3] = xhalf;
							defectPointData[defectPointDataCnt * 3 + 1] = yhalf;
							defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;
							defectPointDataCnt++;
						}
					}
				}
			}			
		}

		// ҷ θ .
		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

			// £ ̹
			// 𼭸 ҷ ƴ 
			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (PixelNInShapeEdgeNeighbor[m] * 100 < Pixel_N_Of_Label[m] * 90)
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (SelectedFace == FRONT_FACE_FOR_COLOR)
				{
					if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
					}
				}
				else
				{
					if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_dirty_Size)
					{
						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
					}
				}
			}

			if (DefectSW == 0)
			{
				// £ ̹
				// 𼭸 ҷ 
				tMax = 1;
				maxPixelDefectLabelN = -1;
				for (m = 1; m <= defectGroupN; m++)
				{
					if (PixelNInShapeEdgeNeighbor[m] * 100 >= Pixel_N_Of_Label[m] * 90)
					{
						if (Pixel_N_Of_Label[m] > tMax)
						{
							tMax = Pixel_N_Of_Label[m];
							maxPixelDefectLabelN = m;
						}
					}
				}
				if (maxPixelDefectLabelN > 0)
				{
					if (SelectedFace == FRONT_FACE_FOR_COLOR)
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_edge_dirty_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
					else
					{
						if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.rear_edge_dirty_Size)
						{
							DefectSW = 1;
							DefectInformationWrite(DEFECT_FRONT_EDGE_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN], EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
						}
					}
				}
			}
		}
	}

#ifdef PC_SIM
	memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif

}
//---------------------------------------------------------------------------
void DefectSearchForFrontShapeForSugarCoating(int cameraIndex)
{
	int defectGroupN;
	int m, i, j, r, x, y;
	int darkDefectCheckSW;
	int selfPositionValueAvg;
	int thresholdDark;
	int tempAddress;
	int tempAddress2;
	int tempCount;
	int areaValue;
	int colorDiff;
	int alpha;
	int searchRange;	
	short defectPointData[MAX_DEFECT_POINT_COUNT * 3];
	int defectPointDataCnt;

	int inspectionAcceptArea[12];
	int compareAcceptArea[12][12];
	int thresholdForEaceArea[12];

	int maxPixelDefectLabelN;
	int tMax;
	int maxDiff;
	int tempEdgeIntensity;
	int tempEdgeMask;
	int PrintNeighbotThreshold_Short;
	int PrintNeighbotThreshold_Long;
	int spotThreshold;
	int n;
	int topSW, bottomSW, leftSW, rightSW, topleftSW, toprightSW, bottomleftSW, bottomrightSW;
	int maxShellN;
	int blurThreshold;
	int tabletColor;
	int printThreshold;
	int printLabelNum;
	int tagetPositionValue;

	int st_x, end_x, st_y, end_y;
	
	st_x = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	end_x = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	st_y = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	end_y = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	if (st_x < 20)
		st_x = 20;
	if (end_x > MAX_IMAGE_WIDTH - 20)
		end_x = MAX_IMAGE_WIDTH - 20;
	if (st_y < 20)
		st_y = 20;
	if (end_y > MAX_IMAGE_HEIGHT - 20)
		end_y = MAX_IMAGE_HEIGHT - 20;

	tempEdgeIntensity = TabletGradeData.front_edge_Intensity;

	tempEdgeMask = TabletGradeData.front_unInspectionIntensity_ForEdge + 1;

	for (m = 0; m < ShapeShellDataCount[0]; m++)
	{
		x = ShapeShellData[0][m][0];
		y = ShapeShellData[0][m][1];
		for (i = y - tempEdgeMask; i <= y + tempEdgeMask; i++)
		{
			for (j = x - tempEdgeMask; j <= x + tempEdgeMask; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				if (InspectionArea[tempAddress])
					InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
			}
		}
	}

	unsigned char *tempInspectionArea = ThreeD_Image; // ӽ .
	short *label_Image = RotationEdgeImage;

	memset(tempInspectionArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	for (i = st_y; i < end_y; i++)
	{
		for (j = st_x; j < end_x; j++)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;

			if (InspectionArea[tempAddress] == FRONT_MASKING_AREA)
				tempInspectionArea[tempAddress] = 0;
			else
				tempInspectionArea[tempAddress] = InspectionArea[tempAddress];
		}
	}
	
	thresholdDark = 30;
	memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
	defectPointDataCnt = 0;

	alpha = (TabletGradeData.front_stain_Intensity - 1) * 2;

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH;
		PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH;
	}
	else
	{
		if (BlurredEngraveSW)
		{
			PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH / 4;
			PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH / 4;
		}
		else
		{
			PrintNeighbotThreshold_Short = FORNT_PRINT_NEIGHBOR_SHORT_THRESH / 2;
			PrintNeighbotThreshold_Long = FORNT_PRINT_NEIGHBOR_LONG_THRESH / 2;
		}
	}

	tabletColor = max(2, MeanColorG / 20);

	for (m = 0; m < 12; m++)
	{
		thresholdForEaceArea[m] = 15;
		if (m == NORMAL_INPECTION_AREA)
		{
			thresholdForEaceArea[m] = FORNT_NORMAL_INPECTION_AREA_THRESH + alpha;
		}
		if (m == PRINT_AREA)
		{
			if (TabletGradeData.front_print_dirty_Inetensity == 1)
			{
				thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity;
			}
			else
			{
				thresholdForEaceArea[m] = tabletColor * TabletGradeData.front_print_dirty_Inetensity * (TabletGradeData.front_print_dirty_Inetensity - 1);
			}
		}
		if (m == PRINT_NEIGHBOR_SHORT)
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Short + alpha * 2;
		if (m == PRINT_NEIGHBOR_LONG)
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Long + alpha * 2;
		if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Short + alpha * 2;
		if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
			thresholdForEaceArea[m] = PrintNeighbotThreshold_Long + alpha * 2;

		if (m == FRONT_SHAPE_EDGE_NEIGHBOR || m == FRONT_SHAPE_EDGE)
		{
			thresholdForEaceArea[m] = FORNT_NORMAL_INPECTION_AREA_THRESH + (TabletGradeData.front_edge_Intensity - 1) * 3;
		}
	}

	printThreshold = 2 * TabletGradeData.front_print_dirty_Inetensity2;
	if (TabletGradeData.front_print_dirty_Inetensity2 == 30) // max
	{
		printThreshold = 255;
	}

	for (m = 0; m < 12; m++)
	{
		inspectionAcceptArea[m] = 1;
		if (m == FRONT_SHAPE_EDGE)
		{
			inspectionAcceptArea[m] = 0;
		}

		if (m == PRINT_AREA)
		{
			if (TabletCharacter.discriminationDisplay_kind == PRINT)
			{
				inspectionAcceptArea[m] = 3;
			}
			else
			{
				inspectionAcceptArea[m] = 0;
			}
		}

		if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
		{
			inspectionAcceptArea[m] = 2;
		}
	}

	inspectionAcceptArea[0] = 0;

	for (m = 0; m < 12; m++)
	{
		for (i = 0; i < 12; i++)
			compareAcceptArea[m][i] = 0;
		if (m == NORMAL_INPECTION_AREA)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_LONG)
		{
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_AND_PRINT_SHORT)
		{
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == PRINT_NEIGHBOR_SHORT)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == PRINT_NEIGHBOR_LONG)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
		}
		else if (m == PRINT_AREA)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_LONG] = 1;
			compareAcceptArea[m][PRINT_NEIGHBOR_SHORT] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_AND_PRINT_SHORT] = 1;
			compareAcceptArea[m][PRINT_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE_NEIGHBOR)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
		else if (m == FRONT_SHAPE_EDGE)
		{
			compareAcceptArea[m][NORMAL_INPECTION_AREA] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
			compareAcceptArea[m][FRONT_SHAPE_EDGE] = 1;
		}
	}

	for (i = st_y; i < end_y; i++)
	{
		for (j = st_x; j < end_x; j++)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;
			areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];

			if (inspectionAcceptArea[areaValue] == 1 || inspectionAcceptArea[areaValue] == 2)
			{
				if (inspectionAcceptArea[areaValue] == 1)
					spotThreshold = FORNT_DIRTY_THRESH / 2 + TabletGradeData.front_dirty_Intensity * 2;
				else
					spotThreshold = FORNT_DIRTY_THRESH / 2 + TabletGradeData.front_edge_dirty_Intensity * 2;

				darkDefectCheckSW = 0;
				thresholdDark = thresholdForEaceArea[areaValue];

				searchRange = 12;

				selfPositionValueAvg = OneColorImage[tempAddress];

				maxDiff = -1;
				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 0)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 1)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH + r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 2)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH - r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 3)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH - r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 4)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH + r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 5)
					continue;

				if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
				{
					defectPointData[defectPointDataCnt * 3] = j;
					defectPointData[defectPointDataCnt * 3 + 1] = i;
					defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

					defectPointDataCnt++;
				}
			}
			else if (inspectionAcceptArea[areaValue] == 3)
			{
				printLabelNum = PrintLabelArea[tempAddress] & 0x0F;

				if (printLabelNum)
				{
					selfPositionValueAvg = MeanOneColorImage[tempAddress];
					tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

					colorDiff = tagetPositionValue - selfPositionValueAvg;

					if (colorDiff > printThreshold && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
					{
						defectPointData[defectPointDataCnt * 3] = j;
						defectPointData[defectPointDataCnt * 3 + 1] = i;
						defectPointData[defectPointDataCnt * 3 + 2] = colorDiff;

						defectPointDataCnt++;
					}
				}
			}
		}
	}

	for (i = st_y; i < end_y; i++)
	{
		for (j = st_x; j < end_x; j++)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;
			areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];

			if (inspectionAcceptArea[areaValue] == 1 || inspectionAcceptArea[areaValue] == 2)
			{
				if (inspectionAcceptArea[areaValue] == 1)
					spotThreshold = FORNT_DIRTY_THRESH / 2 + TabletGradeData.front_dirty_Intensity * 2;
				else
					spotThreshold = FORNT_DIRTY_THRESH / 2 + TabletGradeData.front_edge_dirty_Intensity * 2;

				darkDefectCheckSW = 0;
				thresholdDark = thresholdForEaceArea[areaValue];

				searchRange = 12;

				selfPositionValueAvg = OneColorImage[tempAddress];

				maxDiff = -1;
				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 0)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 1)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH + r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 2)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH - r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 3)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH - r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 4)
					continue;

				for (r = searchRange; r >= 4; r -= 4)
				{
					tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH + r;
					if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
					{
						colorDiff = selfPositionValueAvg - OneColorImage[tempAddress2];

						if (colorDiff > spotThreshold)
						{
							darkDefectCheckSW++;
							if (maxDiff < colorDiff)
								maxDiff = colorDiff;

							break;
						}
					}
				}

				if (darkDefectCheckSW <= 5)
					continue;

				if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
				{
					defectPointData[defectPointDataCnt * 3] = j;
					defectPointData[defectPointDataCnt * 3 + 1] = i;
					defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

					defectPointDataCnt++;
				}
			}
		}
	}

	// ҷ θ .
	{
		defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (Pixel_N_Of_Label[m] > tMax)
				{
					tMax = Pixel_N_Of_Label[m];
					maxPixelDefectLabelN = m;
				}
			}

			for (m = 1; m <= defectGroupN; m++)
			{
				if (PixelNInShapeEdgeNeighbor[m] * 100 < Pixel_N_Of_Label[m] * 90) // 𼭸 ҷ ƴ 
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_dirty_Size)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_FRONT_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN],
										   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
				}
			}

			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (PixelNInShapeEdgeNeighbor[m] * 100 >= Pixel_N_Of_Label[m] * 90) // 𼭸 ҷ 
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_edge_dirty_Size)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_FRONT_EDGE_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN],
										   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
				}
			}
		}
	}

	if (!DefectSW)
	{
		maxShellN = 0;
		for (n = 0; n < SHAPE_SHELL_DEPTH; n++)
		{
			if (ShapeShellDataCount[n])
			{
				maxShellN = n;
			}
		}

		blurThreshold = tempCount = 0;
		searchRange = max(0, maxShellN - 2);
		for (n = maxShellN; n >= searchRange; n--)
		{
			for (m = 0; m < ShapeShellDataCount[n]; m++)
			{
				x = ShapeShellData[n][m][0];
				y = ShapeShellData[n][m][1];
				tempAddress = y * MAX_IMAGE_WIDTH + x;

				if (tempInspectionArea[tempAddress] && tempInspectionArea[tempAddress] != PRINT_AREA)
				{
					blurThreshold += OneColorImage[tempAddress];
					tempCount++;
				}
			}
		}

		if (tempCount)
		{
			blurThreshold /= tempCount;
			blurThreshold = blurThreshold * 110 / 100;
		}
		else
		{
			blurThreshold = 255;
		}

		//memset(BrightPixelNeighborPrint, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
		defectPointDataCnt = 0;

		searchRange = 24;

		for (i = st_y; i < end_y; i++)
		{
			for (j = st_x; j < end_x; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				areaValue = (tempInspectionArea[tempAddress] > 11) ? 0 : tempInspectionArea[tempAddress];

				if (inspectionAcceptArea[areaValue])
				{
					if (TempImage[tempAddress]) // Ƽŷ ̳  ׵θ αٿ ҷ üũ
					{
						if (defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
						{
							defectPointData[defectPointDataCnt * 3] = j;
							defectPointData[defectPointDataCnt * 3 + 1] = i;
							defectPointData[defectPointDataCnt * 3 + 2] = TempImage[tempAddress];
							defectPointDataCnt++;
						}
					}
					else
					{
						topSW = bottomSW = leftSW = rightSW = topleftSW = toprightSW = bottomleftSW = bottomrightSW = 0;
						darkDefectCheckSW = 0;

						thresholdDark = thresholdForEaceArea[areaValue];
						selfPositionValueAvg = OneColorImage[tempAddress];

						if (inspectionAcceptArea[areaValue] == 1 && selfPositionValueAvg < blurThreshold) // Print  ƴ 
						{
							maxDiff = -1;
							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										topSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										leftSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										topleftSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH - r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										bottomleftSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										bottomSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										rightSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							if (darkDefectCheckSW <= 0)
								continue;

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										bottomrightSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							if (darkDefectCheckSW <= 1)
								continue;

							for (r = searchRange; r >= 4; r -= 4)
							{
								tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH + r;
								if (compareAcceptArea[areaValue][tempInspectionArea[tempAddress2]])
								{
									colorDiff = OneColorImage[tempAddress2] - selfPositionValueAvg;

									if (colorDiff > thresholdDark)
									{
										toprightSW = 1;
										darkDefectCheckSW++;
										if (maxDiff < colorDiff)
											maxDiff = colorDiff;

										break;
									}
								}
							}

							if (darkDefectCheckSW <= 2)
								continue;

							if (((topSW && bottomSW) ||
								(leftSW && rightSW) ||
								(topleftSW && bottomrightSW) ||
								(toprightSW && bottomleftSW)) && darkDefectCheckSW >= 3 && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
							{
								defectPointData[defectPointDataCnt * 3] = j;
								defectPointData[defectPointDataCnt * 3 + 1] = i;
								defectPointData[defectPointDataCnt * 3 + 2] = maxDiff;

								defectPointDataCnt++;								
							}
						}
					}
				}
			}
		}

		// ҷ θ .
		defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

		///////////////𼭸 ҷ ƴ  ////////////////////////////
		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (PixelNInShapeEdgeNeighbor[m] * 100 < Pixel_N_Of_Label[m] * 90) // 𼭸 ҷ ƴ 
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_stain_Size)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_FRONT_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN],
											EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
				}
			}
			///////////////𼭸 ҷ  ////////////////////////////
			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (PixelNInShapeEdgeNeighbor[m] * 100 >= Pixel_N_Of_Label[m] * 90) // 𼭸 ҷ 
				{
					if (Pixel_N_Of_Label[m] > tMax)
					{
						tMax = Pixel_N_Of_Label[m];
						maxPixelDefectLabelN = m;
					}
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (Pixel_N_Of_Label[maxPixelDefectLabelN] > TabletGradeData.front_edge_Size)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_FRONT_EDGE_STAIN, cameraIndex, StartX_Label[maxPixelDefectLabelN],
											EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN]);
				}
			}
		}		
	}

#ifdef PC_SIM
	memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif

}
//---------------------------------------------------------------------------
void DefectSearchForMarvelingTablet(int cameraIndex)
{
	int x, y;
	int tempAddress;
	int tempAddress2;
	int SpotDefectCount, StainDefectCount;	
	int searchRange;
	int AddStep;

	int selfValue[3];
	int ColorDiff2[3];
	int ColorDiff;
	int r;
	int darkIntensity, brightIntensity;	

	int tMax;
	int maxPixelDefectLabelN;
	int defectGroupN;
	int m;
	int leftSW1, rightSW1, topSW1, bottomSW1, leftTopSW1, leftBottomSW1, rightTopSW1, rightBottomSW1;
	int leftSW2, rightSW2, topSW2, bottomSW2, leftTopSW2, leftBottomSW2, rightTopSW2, rightBottomSW2;
	int darkStainIntensity, brightStainIntensity;
	int selfPositionValueAvg;
	int maxDiff;
	int yShift;
	int darkDefectCheckSW;
	int tagetPositionValue;
	int colorDiff;
	int PrintAreaDefectIntensity;
	int tabletColor;
	int printLabelNum;
	int inspectionAcceptArea[12];
	int printAreaMask;
	int tempX, tempY;
	int printThreshold;

	int startX, endX, startY, endY;

	startX = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	endX = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	startY = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	endY = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	unsigned char *DefectImage1 = GradientImage; // ӽ 
	unsigned char *DefectImage2 = TempImage; // ӽ 
	short *label_Image = RotationEdgeImage;

	memset(DefectImage1, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	memset(DefectImage2, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	
	searchRange = 32;

	darkIntensity = 6 + TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet * 2;
	brightIntensity = 6 + TabletGradeData.BrightSpotDefectIntensityGradeForMarvelingTablet * 2;

	darkStainIntensity = 6 + TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet * 2;
	brightStainIntensity = 6 + TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet * 2;

	if (globalFrontFaceSplitLineMatchingSW)
	{
		printAreaMask = TabletGradeData.front_unInspectionIntensity_ForPrint + 4;

		for (m = 0; m < globalTabletSplitLineDataCount; m++)
		{
			x = globalTabletSplitLineData[m][0];
			y = globalTabletSplitLineData[m][1];

			for (tempY = y - printAreaMask; tempY <= y + printAreaMask; tempY++)
			{
				for (tempX = x - printAreaMask; tempX <= x + printAreaMask; tempX++)
				{
					tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;

					if (InspectionArea[tempAddress] != FRONT_SHAPE_EDGE && InspectionArea[tempAddress])
					{
						InspectionArea[tempAddress] = FRONT_FACE_SPLIT_AREA;
					}
				}
			}
		}

		for (y = startY; y < endY; y++)
		{
			for (x = startX; x < endX; x++)
			{
				tempAddress = y * MAX_IMAGE_WIDTH + x;
				if (InspectionArea[tempAddress] == FRONT_FACE_SPLIT_AREA)
				{
					for (tempY = y - 5; y <= y + 5; y++)
					{
						for (tempX = x - 5; x <= x + 5; x++)
						{
							tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;

							if (InspectionArea[tempAddress] &&
								InspectionArea[tempAddress] != FRONT_FACE_SPLIT_AREA &&
								InspectionArea[tempAddress] != PRINT_AREA &&
								InspectionArea[tempAddress] != FRONT_SHAPE_EDGE)
							{
								InspectionArea[tempAddress] = PRINT_NEIGHBOR_SHORT;
							}
						}
					}
				}
			}
		}
	}

	tabletColor = max(2, MeanColorG / 20);
	if (SelectedFace == FRONT_FACE_FOR_COLOR)
	{
		if (TabletGradeData.front_print_dirty_Inetensity == 1)
		{
			PrintAreaDefectIntensity = tabletColor * TabletGradeData.front_print_dirty_Inetensity;
		}
		else
		{
			PrintAreaDefectIntensity = tabletColor * TabletGradeData.front_print_dirty_Inetensity * (TabletGradeData.front_print_dirty_Inetensity - 1);
		}
	}
	else
	{
		if (TabletGradeData.rear_print_dirty_Inetensity == 1)
		{
			PrintAreaDefectIntensity = tabletColor * TabletGradeData.rear_print_dirty_Inetensity;
		}
		else
		{
			PrintAreaDefectIntensity = tabletColor * TabletGradeData.rear_print_dirty_Inetensity * (TabletGradeData.rear_print_dirty_Inetensity - 1);
		}
	}

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		printThreshold = 2 * TabletGradeData.front_print_dirty_Inetensity2;
		if (TabletGradeData.front_print_dirty_Inetensity2 == 30) // max
		{
			printThreshold = 255;
		}
	}
	else
	{
		printThreshold = PrintAreaDefectIntensity;
	}

	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionArea[tempAddress] == PRINT_AREA || InspectionArea[tempAddress] == FRONT_FACE_SPLIT_AREA)
			{
				if ((!TabletGradeData.DirtyDefectCheckSWInNeighborPrint && TabletCharacter.discriminationDisplay_kind != PRINT) || InspectionArea[tempAddress] == FRONT_FACE_SPLIT_AREA)
				{
					// 2021-04-02
					// Ҽ Ī 
					// μ + Ҽ ȥ  شϴ  ش ̽  (InspectionArea[tempAddress] == FRONT_FACE_SPLIT_AREA)
					// ̶, ΰ & ޼   ̹ ȭ  뿡  ݿ ȵǾ
					//   ϵ,   Ǵ   ʿ

					selfPositionValueAvg = MeanOneColorImage[tempAddress];

					darkDefectCheckSW = 0;
					maxDiff = 0;
					searchRange = 12;
					for (r = searchRange; r >= 8; r -= 4)
					{
						yShift = r * MAX_IMAGE_WIDTH;
						tempAddress2 = tempAddress - yShift;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;
							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress + yShift;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress - r;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress + r;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress + yShift + r;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress - yShift - r;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress + yShift - r;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						tempAddress2 = tempAddress - yShift + r;
						if (InspectionArea[tempAddress2] && InspectionArea[tempAddress2] != FRONT_SHAPE_EDGE)
						{
							tagetPositionValue = MeanOneColorImage[tempAddress2];

							colorDiff = tagetPositionValue - selfPositionValueAvg;

							if (colorDiff > PrintAreaDefectIntensity)
							{
								darkDefectCheckSW++;

								if (maxDiff < colorDiff)
								{
									maxDiff = colorDiff;
								}
							}
						}
						if (darkDefectCheckSW >= 3)
						{
							DefectImage1[tempAddress] = 1;
							break;
						}
					}
				}
				else
				{
					printLabelNum = PrintLabelArea[tempAddress] & 0x0F;

					if (printLabelNum)
					{
						selfPositionValueAvg = MeanOneColorImage[tempAddress];
						tagetPositionValue = PrintLabelAvgColor[printLabelNum - 1];

						colorDiff = tagetPositionValue - selfPositionValueAvg;

						if (colorDiff > printThreshold)
						{
							DefectImage1[tempAddress] = 1;
						}
					}
				}
			}
		}
	}

	memset(inspectionAcceptArea, 0, sizeof(int) * 12);
	inspectionAcceptArea[NORMAL_INPECTION_AREA] = 1;
	inspectionAcceptArea[FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
	inspectionAcceptArea[PRINT_NEIGHBOR_SHORT] = 1;
	inspectionAcceptArea[PRINT_NEIGHBOR_LONG] = 1;

	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (inspectionAcceptArea[InspectionArea[tempAddress]])
			{
				leftSW1 = rightSW1 = topSW1 = bottomSW1 = leftTopSW1 = leftBottomSW1 = rightTopSW1 = rightBottomSW1 = 0;
				leftSW2 = rightSW2 = topSW2 = bottomSW2 = leftTopSW2 = leftBottomSW2 = rightTopSW2 = rightBottomSW2 = 0;

				SpotDefectCount = StainDefectCount = 0;
				selfValue[0] = ColorSourceImage[tempAddress * 3 + 0];
				selfValue[1] = ColorSourceImage[tempAddress * 3 + 1];
				selfValue[2] = ColorSourceImage[tempAddress * 3 + 2];

				AddStep = 2;
				for (r = 4; r <= searchRange; r += AddStep)
				{
					AddStep *= 2;

					if (!(leftSW1 && leftSW2))
					{
						tempAddress2 = tempAddress - r;
						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !leftSW1)
							{
								leftSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !leftSW2)
							{
								leftSW2 = 1;
								StainDefectCount++;
							}
						}
						else
						{
							leftSW1 = leftSW2 = 1;
						}
					}

					if (!(rightSW1 && rightSW2))
					{
						tempAddress2 = tempAddress + r;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !rightSW1)
							{
								rightSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !rightSW2)
							{
								rightSW2 = 1;
								StainDefectCount++;
							}
						}
					}

					if (!(topSW1 && topSW2))
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !topSW1)
							{
								topSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !topSW2)
							{
								topSW2 = 1;
								StainDefectCount++;
							}
						}
					}

					if (!(bottomSW1 && bottomSW2))
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !bottomSW1)
							{
								bottomSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !bottomSW2)
							{
								bottomSW2 = 1;
								StainDefectCount++;
							}
						}
					}

					if (!(leftTopSW1 && leftTopSW2))
					{
						tempAddress2 = tempAddress - r - r * MAX_IMAGE_WIDTH;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !leftTopSW1)
							{
								leftTopSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !leftTopSW2)
							{
								leftTopSW2 = 1;
								StainDefectCount++;
							}
						}
					}

					if (!(leftBottomSW1 && leftBottomSW2))
					{
						tempAddress2 = tempAddress - r + r * MAX_IMAGE_WIDTH;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !leftBottomSW1)
							{
								leftBottomSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !leftBottomSW2)
							{
								leftBottomSW2 = 1;
								StainDefectCount++;
							}
						}
					}

					if (!(rightTopSW1 && rightTopSW2))
					{
						tempAddress2 = tempAddress + r - r * MAX_IMAGE_WIDTH;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !rightTopSW1)
							{
								rightTopSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !rightTopSW2)
							{
								rightTopSW2 = 1;
								StainDefectCount++;
							}
						}
					}

					if (!(rightBottomSW1 && rightBottomSW2))
					{
						tempAddress2 = tempAddress + r + r * MAX_IMAGE_WIDTH;

						if (inspectionAcceptArea[InspectionArea[tempAddress2]])
						{
							if (BrightPixelNeighborPrint[tempAddress2])
								continue;

							ColorDiff2[0] = ColorSourceImage[tempAddress2 * 3 + 0] - selfValue[0];
							ColorDiff2[1] = ColorSourceImage[tempAddress2 * 3 + 1] - selfValue[1];
							ColorDiff2[2] = ColorSourceImage[tempAddress2 * 3 + 2] - selfValue[2];

							ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

							if (ColorDiff > darkIntensity && !rightBottomSW1)
							{
								rightBottomSW1 = 1;
								SpotDefectCount++;
							}

							if (ColorDiff > darkStainIntensity && !rightBottomSW2)
							{
								rightBottomSW2 = 1;
								StainDefectCount++;
							}
						}
					}
				}

				if (SpotDefectCount >= 8)
					DefectImage1[tempAddress] = 1;

				if (StainDefectCount >= 4)
				{
					//   ҷ    ߱ ߻  ƴ   ̴
					if ((leftSW2 && leftTopSW2 && leftBottomSW2) ||
						(rightSW2 && rightTopSW2 && rightBottomSW2) ||
						(topSW2 && leftTopSW2 && rightTopSW2) ||
						(bottomSW2 && leftBottomSW2 && leftBottomSW2) ||
						(leftTopSW2 && topSW2 && leftSW2) ||
						(rightTopSW2 && topSW2 && rightSW2) ||
						(leftBottomSW2 && bottomSW2 && leftSW2) ||
						(rightBottomSW2 && bottomSW2 && rightSW2))
					{
						DefectImage2[tempAddress] = 2;
					}
				}
			}
		}
	}

	// ҷ θ .	
	{
		memset(label_Image, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		defectGroupN = SmallSizePixelLabeling(DefectImage1, label_Image, startX, endX, startY, endY, MAX_IMAGE_WIDTH);

		tMax = 1;
		maxPixelDefectLabelN = -1;
		for (m = 1; m <= defectGroupN; m++)
		{
			if (labelingPxCount[m] > tMax)
			{
				tMax = labelingPxCount[m];
				maxPixelDefectLabelN = m;
			}
		}
		if (maxPixelDefectLabelN > 0)
		{
			if (labelingPxCount[maxPixelDefectLabelN] > TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_2D_DARK_SPOT_MARVELING, cameraIndex, LabelStX[maxPixelDefectLabelN],
									LabelEdX[maxPixelDefectLabelN], LabelStY[maxPixelDefectLabelN], LabelEdY[maxPixelDefectLabelN], labelingPxCount[maxPixelDefectLabelN]);
#ifdef PC_SIM
				memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
			}
		}
	}

	if (!DefectSW)
	{
		// ҷ θ .		
		memset(label_Image, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		defectGroupN = SmallSizePixelLabeling(DefectImage2, label_Image, startX, endX, startY, endY, MAX_IMAGE_WIDTH);

		tMax = 1;
		maxPixelDefectLabelN = -1;
		for (m = 1; m <= defectGroupN; m++)
		{
			if (labelingPxCount[m] > tMax)
			{
				tMax = labelingPxCount[m];
				maxPixelDefectLabelN = m;
			}
		}
		if (maxPixelDefectLabelN > 0)
		{
			if (labelingPxCount[maxPixelDefectLabelN] > TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_2D_DARK_STAIN_MARVELING, cameraIndex, LabelStX[maxPixelDefectLabelN],
									LabelEdX[maxPixelDefectLabelN], LabelStY[maxPixelDefectLabelN], LabelEdY[maxPixelDefectLabelN], labelingPxCount[maxPixelDefectLabelN]);
#ifdef PC_SIM
				memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
			}
		}
	}

	if (!DefectSW)
	{
		memset(DefectImage1, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		memset(DefectImage2, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

		for (y = startY; y < endY; y++)
		{
			for (x = startX; x < endX; x++)
			{
				tempAddress = MAX_IMAGE_WIDTH * y + x;

				if (inspectionAcceptArea[InspectionArea[tempAddress]])
				{
					if (BrightPixelNeighborPrint[tempAddress])
						continue;

					leftSW1 = rightSW1 = topSW1 = bottomSW1 = leftTopSW1 = leftBottomSW1 = rightTopSW1 = rightBottomSW1 = 0;
					leftSW2 = rightSW2 = topSW2 = bottomSW2 = leftTopSW2 = leftBottomSW2 = rightTopSW2 = rightBottomSW2 = 0;

					SpotDefectCount = StainDefectCount = 0;
					selfValue[0] = ColorSourceImage[tempAddress * 3 + 0];
					selfValue[1] = ColorSourceImage[tempAddress * 3 + 1];
					selfValue[2] = ColorSourceImage[tempAddress * 3 + 2];

					AddStep = 2;
					for (r = 4; r <= searchRange; r += AddStep)
					{
						AddStep *= 2;

						if (!(leftSW1 && leftSW2))
						{
							tempAddress2 = tempAddress - r;
							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !leftSW1)
								{
									leftSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !leftSW2)
								{
									leftSW2 = 1;
									StainDefectCount++;
								}
							}
							else
							{
								leftSW1 = leftSW2 = 1;
							}
						}

						if (!(rightSW1 && rightSW2))
						{
							tempAddress2 = tempAddress + r;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !rightSW1)
								{
									rightSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !rightSW2)
								{
									rightSW2 = 1;
									StainDefectCount++;
								}
							}
						}

						if (!(topSW1 && topSW2))
						{
							tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !topSW1)
								{
									topSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !topSW2)
								{
									topSW2 = 1;
									StainDefectCount++;
								}
							}
						}

						if (!(bottomSW1 && bottomSW2))
						{
							tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !bottomSW1)
								{
									bottomSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !bottomSW2)
								{
									bottomSW2 = 1;
									StainDefectCount++;
								}
							}
						}

						if (!(leftTopSW1 && leftTopSW2))
						{
							tempAddress2 = tempAddress - r - r * MAX_IMAGE_WIDTH;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !leftTopSW1)
								{
									leftTopSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !leftTopSW2)
								{
									leftTopSW2 = 1;
									StainDefectCount++;
								}
							}
						}

						if (!(leftBottomSW1 && leftBottomSW2))
						{
							tempAddress2 = tempAddress - r + r * MAX_IMAGE_WIDTH;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !leftBottomSW1)
								{
									leftBottomSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !leftBottomSW2)
								{
									leftBottomSW2 = 1;
									StainDefectCount++;
								}
							}
						}

						if (!(rightTopSW1 && rightTopSW2))
						{
							tempAddress2 = tempAddress + r - r * MAX_IMAGE_WIDTH;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !rightTopSW1)
								{
									rightTopSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !rightTopSW2)
								{
									rightTopSW2 = 1;
									StainDefectCount++;
								}
							}
						}

						if (!(rightBottomSW1 && rightBottomSW2))
						{
							tempAddress2 = tempAddress + r + r * MAX_IMAGE_WIDTH;

							if (inspectionAcceptArea[InspectionArea[tempAddress2]])
							{
								ColorDiff2[0] = selfValue[0] - ColorSourceImage[tempAddress2 * 3 + 0];
								ColorDiff2[1] = selfValue[1] - ColorSourceImage[tempAddress2 * 3 + 1];
								ColorDiff2[2] = selfValue[2] - ColorSourceImage[tempAddress2 * 3 + 2];

								ColorDiff = max(ColorDiff2[0], max(ColorDiff2[1], ColorDiff2[2]));

								if (ColorDiff > brightIntensity && !rightBottomSW1)
								{
									rightBottomSW1 = 1;
									SpotDefectCount++;
								}

								if (ColorDiff > brightStainIntensity && !rightBottomSW2)
								{
									rightBottomSW2 = 1;
									StainDefectCount++;
								}
							}
						}
					}

					if (SpotDefectCount >= 8)
						DefectImage1[tempAddress] = 1;

					if (StainDefectCount >= 4)
					{
						//   ҷ    ߱ ߻  ƴ   ̴
						if ((leftSW2 && leftTopSW2 && leftBottomSW2) ||
							(rightSW2 && rightTopSW2 && rightBottomSW2) ||
							(topSW2 && leftTopSW2 && rightTopSW2) ||
							(bottomSW2 && leftBottomSW2 && leftBottomSW2) ||
							(leftTopSW2 && topSW2 && leftSW2) ||
							(rightTopSW2 && topSW2 && rightSW2) ||
							(leftBottomSW2 && bottomSW2 && leftSW2) ||
							(rightBottomSW2 && bottomSW2 && rightSW2))
						{
							DefectImage2[tempAddress] = 2;
						}
					}
				}
			}
		}

		// ҷ θ .		
		{
			memset(label_Image, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
			defectGroupN = SmallSizePixelLabeling(DefectImage1, label_Image, startX, endX, startY, endY, MAX_IMAGE_WIDTH);

			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (labelingPxCount[m] > tMax)
				{
					tMax = labelingPxCount[m];
					maxPixelDefectLabelN = m;
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (labelingPxCount[maxPixelDefectLabelN] > TabletGradeData.BrightSpotDefectSizeGradeForMarvelingTablet)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_2D_BRIGHT_SPOT_MARVELING, cameraIndex, LabelStX[maxPixelDefectLabelN],
										LabelEdX[maxPixelDefectLabelN], LabelStY[maxPixelDefectLabelN], LabelEdY[maxPixelDefectLabelN], labelingPxCount[maxPixelDefectLabelN]);
#ifdef PC_SIM
					memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
				}
			}
		}

		if (!DefectSW)
		{
			// ҷ θ .
			memset(label_Image, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
			defectGroupN = SmallSizePixelLabeling(DefectImage2, label_Image, startX, endX, startY, endY, MAX_IMAGE_WIDTH);

			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (labelingPxCount[m] > tMax)
				{
					tMax = labelingPxCount[m];
					maxPixelDefectLabelN = m;
				}
			}
			if (maxPixelDefectLabelN > 0)
			{
				if (labelingPxCount[maxPixelDefectLabelN] > TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_2D_BRIGHT_STAIN_MARVELING, cameraIndex, LabelStX[maxPixelDefectLabelN],
										LabelEdX[maxPixelDefectLabelN], LabelStY[maxPixelDefectLabelN], LabelEdY[maxPixelDefectLabelN], labelingPxCount[maxPixelDefectLabelN]);
#ifdef PC_SIM
					memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
void DefectSearchForColorDirty(int cameraIndex)
{
	// 20160906
	// ̹ غ  츸 üũ
	//    ˰  ʾƵ  
	int defectGroupN;
	int m, i, j;
	int selfPositionValue;
	int space;
	int tempAddress;
	int areaValue;
	int st_x, end_x, st_y, end_y;
	short defectPointData[MAX_DEFECT_POINT_COUNT * 3];
	int defectPointDataCnt;
	short *label_Image;
	int inspectionAcceptArea[12];
	int maxPixelDefectLabelN;
	int tMax;
	int defectCheckSW;
	int brightNormalization[256];
	int thresholdG[4];
	int thresholdB[4];
	int thresholdR[4];
	int selfPositionValueColorR;
	int selfPositionValueColorG;
	int selfPositionValueColorB;
	int targetPositionValueColorR;
	int targetPositionValueColorG;
	int targetPositionValueColorB;
	int normalizedValueR;
	int normalizedValueG;
	int normalizedValueB;
	int tempAddress2;
	int alpha;
	int searchRange;
	int defectCount;
	int selfColor, targetColor, tempThreshold;
	int beta;

	alpha = 1;
	label_Image = RotationEdgeImage;
	space = 20;
	memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);

	defectPointDataCnt = 0;

	st_x = -(space + TabletCharacter.length / 2) + (TabletMatchingResult.AdjustCenterXInImage);
	end_x = (TabletCharacter.length / 2 + space) + (TabletMatchingResult.AdjustCenterXInImage);
	st_y = -(space + TabletCharacter.width / 2) + (TabletMatchingResult.AdjustCenterYInImage);
	end_y = (TabletCharacter.width / 2 + space) + (TabletMatchingResult.AdjustCenterYInImage);

	if (st_x < TabletSetupData.ImageCutStartX[cameraIndex - 1])
		st_x = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	if (end_x > TabletSetupData.ImageCutEndX[cameraIndex - 1])
		end_x = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	if (st_y < TabletSetupData.ImageCutStartY[cameraIndex - 1])
		st_y = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	if (end_y > TabletSetupData.ImageCutEndY[cameraIndex - 1])
		end_y = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	if (TabletCharacter.kind == UNCOATING)
	{
		for (m = 0; m < 12; m++)
		{
			inspectionAcceptArea[m] = 1;
			if (m == PRINT_AREA)
				inspectionAcceptArea[m] = 1;
			if (m == 0)
				inspectionAcceptArea[m] = 0;
			if (m == FRONT_SHAPE_EDGE)
				inspectionAcceptArea[m] = 0;
			if (m == FRONT_MASKING_AREA)
				inspectionAcceptArea[m] = 0;
		}
	}
	else
	{
		for (m = 0; m < 12; m++)
		{
			inspectionAcceptArea[m] = 1;
			if (m == PRINT_AREA)
				inspectionAcceptArea[m] = 2;
			if (m == 0)
				inspectionAcceptArea[m] = 0;
			if (m == FRONT_SHAPE_EDGE)
			{
				if (TabletCharacter.kind == FILMCOATING)
					inspectionAcceptArea[m] = 0;
				else
					inspectionAcceptArea[m] = 3;
			}
			if (m == FRONT_MASKING_AREA)
				inspectionAcceptArea[m] = 0;
		}
	}

	if (TabletCharacter.discriminationDisplay_kind == STAMP && TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm)
	{
		if (PrintMatchingResult.dataNumberWithMaxValue > -1) // μ Ī  쿡
		{
			inspectionAcceptArea[PRINT_AREA] = 0;
		}
	}

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
	{
		// For SELMA200, Rev by moon. (20180208) Camera Index
		if (SelectedFace == FRONT_FACE_FOR_COLOR)
		{
			if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletColorR_ForCamera1;
				MeanColorG = TabletStudyData.tabletColorG_ForCamera1;
				MeanColorB = TabletStudyData.tabletColorB_ForCamera1;
			}
			else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletColorR_ForCamera9;
				MeanColorG = TabletStudyData.tabletColorG_ForCamera9;
				MeanColorB = TabletStudyData.tabletColorB_ForCamera9;
			}
		}
		else
		{
			if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletRearColorR_ForCamera1;
				MeanColorG = TabletStudyData.tabletRearColorG_ForCamera1;
				MeanColorB = TabletStudyData.tabletRearColorB_ForCamera1;
			}
			else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletRearColorR_ForCamera9;
				MeanColorG = TabletStudyData.tabletRearColorG_ForCamera9;
				MeanColorB = TabletStudyData.tabletRearColorB_ForCamera9;
			}
		}

		// 2016-09-13 moon
		// κ μ  ̹  ߻ϹǷ μ  alpha  20 ϱ Ѵ.
		//  ϴ    alpha 
		alpha = 20;
	}
	else
	{
		// For SELMA200, Rev by moon. (20180208) Camera Index
		if (SelectedFace == FRONT_FACE_FOR_COLOR)
		{
			if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletColorR_ForCamera1;
				MeanColorG = TabletStudyData.tabletColorG_ForCamera1;
				MeanColorB = TabletStudyData.tabletColorB_ForCamera1;
			}
			else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletColorR_ForCamera9;
				MeanColorG = TabletStudyData.tabletColorG_ForCamera9;
				MeanColorB = TabletStudyData.tabletColorB_ForCamera9;
			}
		}
		else
		{
			if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletRearColorR_ForCamera1;
				MeanColorG = TabletStudyData.tabletRearColorG_ForCamera1;
				MeanColorB = TabletStudyData.tabletRearColorB_ForCamera1;
			}
			else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
			{
				MeanColorR = TabletStudyData.tabletRearColorR_ForCamera9;
				MeanColorG = TabletStudyData.tabletRearColorG_ForCamera9;
				MeanColorB = TabletStudyData.tabletRearColorB_ForCamera9;
			}
		}
	}

	if (selectedRGB == 2)
	{
		beta = 0;

		if (ProcessingModeGlobal == INSPECTION_MODE)
		{
			if (TabletCharacter.tabletColorN == ONECOLOR) //   
			{
				if (MeanColorG < 55 && MeanColorB < 55 && MeanColorR > MeanColorG * 170 / 100 && MeanColorR > MeanColorB * 170 / 100)
					beta = -40;
			}
		}

		thresholdB[0] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 4 * MeanColorB / (200 + beta);
		thresholdG[0] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 4 * MeanColorG / (200 + beta);
		thresholdR[0] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorR / (200 + beta);
		thresholdB[1] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 5 * MeanColorB / (200 + beta);
		thresholdG[1] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 5 * MeanColorG / (200 + beta);
		thresholdR[1] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorR / (200 + beta);
		thresholdB[2] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorB / (200 + beta);
		thresholdG[2] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorG / (200 + beta);
		thresholdR[2] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 7 * MeanColorR / (200 + beta);

		// 2015-10-12 revision by moon
		// Print  ̹   ߻
		thresholdB[3] = (TabletGradeData.front_Color_Dirty_Intensity + alpha) * 7 * MeanColorB / (200 + beta);
		thresholdG[3] = (TabletGradeData.front_Color_Dirty_Intensity + alpha) * 7 * MeanColorG / (200 + beta);
		thresholdR[3] = (TabletGradeData.front_Color_Dirty_Intensity + alpha) * 8 * MeanColorR / (200 + beta);
	}
	else
	{
		thresholdB[0] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 5 * MeanColorB / 200;
		thresholdG[0] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 5 * MeanColorG / 200;
		thresholdR[0] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorR / 200;
		thresholdB[1] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 5 * MeanColorB / 200;
		thresholdG[1] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 5 * MeanColorG / 200;
		thresholdR[1] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorR / 200;
		thresholdB[2] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorB / 200;
		thresholdG[2] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 6 * MeanColorG / 200;
		thresholdR[2] = (TabletGradeData.front_Color_Dirty_Intensity + 2) * 7 * MeanColorR / 200;

		// 2015-10-12 revision by moon
		// Print  ̹   ߻
		thresholdB[3] = (TabletGradeData.front_Color_Dirty_Intensity + alpha) * 7 * MeanColorB / 200;
		thresholdG[3] = (TabletGradeData.front_Color_Dirty_Intensity + alpha) * 7 * MeanColorG / 200;
		thresholdR[3] = (TabletGradeData.front_Color_Dirty_Intensity + alpha) * 8 * MeanColorR / 200;
	}

	int MeanGray = 0;

	if (selectedRGB == 0)
	{
		MeanGray = MeanColorB;
		for (m = 1; m < 256; m++)
			brightNormalization[m] = 1024 * MeanColorB / m;
	}
	else if (selectedRGB == 1)
	{
		MeanGray = MeanColorG;
		for (m = 1; m < 256; m++)
			brightNormalization[m] = 1024 * MeanColorG / m;
	}
	else if (selectedRGB == 2)
	{
		MeanGray = MeanColorR;
		for (m = 1; m < 256; m++)
			brightNormalization[m] = 1024 * MeanColorR / m;
	}

	for (i = st_y; i < end_y; i++)
	{
		for (j = st_x; j < end_x; j++)
		{
			defectCheckSW = 0;
			tempAddress = MAX_IMAGE_WIDTH * i + j;
			areaValue = InspectionArea[tempAddress];
			selfPositionValue = OneColorImage[tempAddress];
			if (inspectionAcceptArea[areaValue])
			{
				selfPositionValueColorR = ColorSourceImage[tempAddress * 3 + 2];
				selfPositionValueColorB = ColorSourceImage[tempAddress * 3];
				selfPositionValueColorG = ColorSourceImage[tempAddress * 3 + 1];
				if (inspectionAcceptArea[areaValue] <= 2)
				{
					normalizedValueR = selfPositionValueColorR * brightNormalization[selfPositionValue] / 1024;
					normalizedValueG = selfPositionValueColorG * brightNormalization[selfPositionValue] / 1024;
					normalizedValueB = selfPositionValueColorB * brightNormalization[selfPositionValue] / 1024;

					if (!TabletGradeData.DirtyGradeSensitivity)
					{
						if (TabletGradeData.DefectSearchForColorDirtyOption == 0)
						{
							if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
							{
								if ((normalizedValueR - MeanColorR) > thresholdR[1])
								{
									defectCheckSW = 1;
								}
								else if ((normalizedValueG - MeanColorG) > thresholdG[1])
								{
									defectCheckSW = 1;
								}
								else if ((normalizedValueB - MeanColorB) > thresholdB[1])
								{
									defectCheckSW = 1;
								}
							}
							else if (areaValue == PRINT_AREA && TabletCharacter.discriminationDisplay_kind == PRINT && selfPositionValue < MeanGray) // μ̰ Ӵٸ μ ̹Ƿ ϰ ˻. ٸ μⰡ ƴϹǷ Ϲ  .
							{
								if (selfPositionValue > 40) //   40 ̸ ʹ ο ְ ϹǷ .  40 ̸ μ ڰ  Ȯ.
								{
									if ((normalizedValueR - MeanColorR) > thresholdR[3])
									{
										defectCheckSW = 1;
									}
									else if ((normalizedValueG - MeanColorG) > thresholdG[3])
									{
										defectCheckSW = 1;
									}
									else if ((normalizedValueB - MeanColorB) > thresholdB[3])
									{
										defectCheckSW = 1;
									}
								}
							}
							else
							{
								if ((normalizedValueR - MeanColorR) > thresholdR[0])
								{
									defectCheckSW = 1;
								}
								else if ((normalizedValueG - MeanColorG) > thresholdG[0])
								{
									defectCheckSW = 1;
								}
								else if ((normalizedValueB - MeanColorB) > thresholdB[0])
								{
									defectCheckSW = 1;
								}
							}
						}
						else
						{
							if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
							{
								if (normalizedValueR - MeanColorR > thresholdR[1] || normalizedValueR - MeanColorR < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdR[1])
								{
									defectCheckSW = 1;
								}
								else if (normalizedValueG - MeanColorG > thresholdG[1] || normalizedValueG - MeanColorG < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdG[1])
								{
									defectCheckSW = 1;
								}
								else if (normalizedValueB - MeanColorB > thresholdB[1] || normalizedValueB - MeanColorB < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdB[1])
								{
									defectCheckSW = 1;
								}
							}
							else if (areaValue == PRINT_AREA && TabletCharacter.discriminationDisplay_kind == PRINT && selfPositionValue < MeanGray)
							{
								if (selfPositionValue > 40) //   40 ̸ ʹ ο ְ ϹǷ .  40 ̸ μ ڰ  Ȯ.
								{
									if (normalizedValueR - MeanColorR > thresholdR[3] || normalizedValueR - MeanColorR < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdR[3])
									{
										defectCheckSW = 1;
									}
									else if (normalizedValueG - MeanColorG > thresholdG[3] || normalizedValueG - MeanColorG < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdG[3])
									{
										defectCheckSW = 1;
									}
									else if (normalizedValueB - MeanColorB > thresholdB[3] || normalizedValueB - MeanColorB < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdB[3])
									{
										defectCheckSW = 1;
									}
								}
							}
							else
							{
								if (normalizedValueR - MeanColorR > thresholdR[0] || normalizedValueR - MeanColorR < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdR[0])
								{
									defectCheckSW = 1;
								}
								else if (normalizedValueG - MeanColorG > thresholdG[0] || normalizedValueG - MeanColorG < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdG[0])
								{
									defectCheckSW = 1;
								}
								else if (normalizedValueB - MeanColorB > thresholdB[0] || normalizedValueB - MeanColorB < (-1.0 * TabletGradeData.DefectSearchForColorDirtyOptOffset) * thresholdB[0])
								{
									defectCheckSW = 1;
								}
							}
						}
					}
					else
					{
						// ΰ  "" λ¿ ȭ  ̿ ʴ´.
						// , , μ  
						if (areaValue == PRINT_AREA && TabletCharacter.discriminationDisplay_kind == PRINT && selfPositionValue < MeanGray)
						{
							if (selfPositionValue > 40) //   40 ̸ ʹ ο ְ ϹǷ .  40 ̸ μ ڰ  Ȯ.
							{
								if ((normalizedValueR - MeanColorR) > thresholdR[3])
								{
									defectCheckSW = 1;
								}
								else if ((normalizedValueG - MeanColorG) > thresholdG[3])
								{
									defectCheckSW = 1;
								}
								else if ((normalizedValueB - MeanColorB) > thresholdB[3])
								{
									defectCheckSW = 1;
								}
							}
						}
						else if (areaValue == PRINT_AREA || areaValue == PRINT_NEIGHBOR_SHORT || areaValue == PRINT_NEIGHBOR_LONG)
						{
							if ((normalizedValueR - MeanColorR) > thresholdR[0])
							{
								defectCheckSW = 1;
							}
							else if ((normalizedValueG - MeanColorG) > thresholdG[0])
							{
								defectCheckSW = 1;
							}
							else if ((normalizedValueB - MeanColorB) > thresholdB[0])
							{
								defectCheckSW = 1;
							}
						}
						/*
						else if (areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
						{
						if ((selfPositionValueColorR - MeanColorR) > thresholdR[1])
						{
						defectCheckSW = 1;
						}
						else if ((selfPositionValueColorG - MeanColorG) > thresholdG[1])
						{
						defectCheckSW = 1;
						}
						else if ((selfPositionValueColorB - MeanColorB) > thresholdB[1])
						{
						defectCheckSW = 1;
						}
						}
						else
						{
						if ((selfPositionValueColorR - MeanColorR) > thresholdR[0])
						{
						defectCheckSW = 1;
						}
						else if ((selfPositionValueColorG - MeanColorG) > thresholdG[0])
						{
						defectCheckSW = 1;
						}
						else if ((selfPositionValueColorB - MeanColorB) > thresholdB[0])
						{
						defectCheckSW = 1;
						}
						}
						*/
						else
						{
							// ̹ҷ ó 2
							// Color Differcence Ͽ  ̾Ƴ meanColor ̹ ҷ ó(AND)
							defectCount = 0;
							for (searchRange = 12; searchRange >= 4; searchRange -= 4)
							{
								tempAddress2 = MAX_IMAGE_WIDTH * (i - searchRange) + (j);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i + searchRange) + (j);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i) + (j - searchRange);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i) + (j + searchRange);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i - searchRange) + (j - searchRange);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i + searchRange) + (j + searchRange);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i - searchRange) + (j + searchRange);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								tempAddress2 = MAX_IMAGE_WIDTH * (i + searchRange) + (j - searchRange);

								areaValue = InspectionArea[tempAddress2];
								if (areaValue == NORMAL_INPECTION_AREA || areaValue == FRONT_SHAPE_EDGE_NEIGHBOR)
								{
									targetPositionValueColorB = ColorSourceImage[tempAddress2 * 3 + 0];
									targetPositionValueColorG = ColorSourceImage[tempAddress2 * 3 + 1];
									targetPositionValueColorR = ColorSourceImage[tempAddress2 * 3 + 2];

									if (selfPositionValueColorB - targetPositionValueColorB > thresholdB[0] ||
										selfPositionValueColorG - targetPositionValueColorG > thresholdG[0] ||
										selfPositionValueColorR - targetPositionValueColorR > thresholdR[0])
									{
										defectCount++;
									}
								}

								if (defectCount >= 4)
								{
									if ((selfPositionValueColorR - MeanColorR) > thresholdR[0])
									{
										defectCheckSW = 1;
									}
									else if ((selfPositionValueColorG - MeanColorG) > thresholdG[0])
									{
										defectCheckSW = 1;
									}
									else if ((selfPositionValueColorB - MeanColorB) > thresholdB[0])
									{
										defectCheckSW = 1;
									}
									break;
								}
							}
						}
					}
				}
				else if (inspectionAcceptArea[areaValue] == 3)
				{
					if (selfPositionValueColorR > 60 || selfPositionValueColorG > 60 || selfPositionValueColorB > 60)
					{
						normalizedValueR = selfPositionValueColorR * brightNormalization[selfPositionValue] / 1024;
						normalizedValueG = selfPositionValueColorG * brightNormalization[selfPositionValue] / 1024;
						normalizedValueB = selfPositionValueColorB * brightNormalization[selfPositionValue] / 1024;
						if ((normalizedValueR - MeanColorR) > thresholdR[2])
						{
							defectCheckSW = 3; // R
							selfColor = normalizedValueR;

							tempThreshold = thresholdR[2];
						}
						else if ((normalizedValueG - MeanColorG) > thresholdG[2])
						{
							defectCheckSW = 2; // G
							selfColor = normalizedValueG;

							tempThreshold = thresholdG[2];
						}
						else if ((normalizedValueB - MeanColorB) > thresholdB[2])
						{
							defectCheckSW = 1; // B
							selfColor = normalizedValueB;

							tempThreshold = thresholdB[2];
						}

						if (defectCheckSW)
						{
							defectCount = 0;

							tempAddress2 = MAX_IMAGE_WIDTH * (i - 8) + (j);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i - 8) + (j + 8);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i + 8) + (j);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i + 8) + (j + 8);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i - 8) + (j);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i - 8) + (j - 8);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i + 8) + (j);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							tempAddress2 = MAX_IMAGE_WIDTH * (i + 8) + (j - 8);

							areaValue = InspectionArea[tempAddress2];
							if (areaValue)
							{
								targetColor = ColorSourceImage[tempAddress2 * 3 + defectCheckSW - 1];
								targetColor = targetColor * brightNormalization[selfPositionValue] / 1024;

								if (selfColor - targetColor > tempThreshold)
								{
									defectCount++;
								}
							}

							if (defectCount < 2)
								defectCheckSW = 0;
						}

						/*
						pX = tempCX - j;
						pY = tempCY - i;
						uLength = pX*pX + pY*pY;
						if (uLength < 90000)
						{
						uLength = SqrtData[uLength]; //sqrtdata 128   .
						sinV = 768 * pX / uLength; //6*128 = 768
						cosV = 768 * pY / uLength; //6*128 = 768
						tempAddress2 = (tempAddress + cosV * 640 + sinV);
						tempAddress3 = (tempAddress + (cosV * 640 + sinV) * 2);

						if( tempAddress2 > 0 && tempAddress2 < MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT &&
						tempAddress3 > 0 && tempAddress3 < MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT)
						if (InspectionArea[tempAddress2] != PRINT_AREA && InspectionArea[tempAddress3] != PRINT_AREA)
						{
						if (selfPositionValueColorB - ColorSourceImage[tempAddress2 * 3] > thresholdB[1])
						{
						if (selfPositionValueColorB - ColorSourceImage[tempAddress3 * 3] > thresholdB[2])
						{
						defectCheckSW = 1;
						}
						}
						else if (selfPositionValueColorG - ColorSourceImage[tempAddress2 * 3 + 1] > thresholdG[1])
						{
						if (selfPositionValueColorG - ColorSourceImage[tempAddress3 * 3 + 1] > thresholdG[2])
						{
						defectCheckSW = 1;
						}
						}
						else if (selfPositionValueColorR - ColorSourceImage[tempAddress2 * 3 + 2] > thresholdR[1])
						{
						if (selfPositionValueColorR - ColorSourceImage[tempAddress3 * 3 + 2] > thresholdR[2])
						{
						defectCheckSW = 1;
						}
						}
						}
						}
						*/
					}
				}
			}
			if (defectCheckSW && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
			{
				defectPointData[defectPointDataCnt * 3] = j;
				defectPointData[defectPointDataCnt * 3 + 1] = i;
				defectPointDataCnt++;
			}
		}
	}

	defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);
	
	if (ProcessingModeGlobal == INSPECTION_MODE)
	{
		tMax = 1;
		maxPixelDefectLabelN = -1;
		for (m = 1; m <= defectGroupN; m++)
		{
			if (Pixel_N_Of_Label[m] + Pixel_N_Of_MoreDarkOfLabel[m] > tMax)
			{
				tMax = Pixel_N_Of_Label[m] + Pixel_N_Of_MoreDarkOfLabel[m];
				maxPixelDefectLabelN = m;
			}
		}
		if (maxPixelDefectLabelN > 0)
		{
			if (Pixel_N_Of_Label[maxPixelDefectLabelN] + Pixel_N_Of_MoreDarkOfLabel[maxPixelDefectLabelN] > TabletGradeData.front_Color_Dirty_Size)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_FRONT_COLOR_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN],
									   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN] + Pixel_N_Of_MoreDarkOfLabel[maxPixelDefectLabelN]);
#ifdef PC_SIM
				memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
			}
		}
	}
}
//---------------------------------------------------------------------------
void DefectSearchForColorDirtyForSugarCoating(int cameraIndex)
{
	int defectGroupN;
	int m, i, j, x, y;
	int selfPositionValue;
	int space;
	int tempAddress;
	int areaValue;
	int st_x, end_x, st_y, end_y;
	short defectPointData[MAX_DEFECT_POINT_COUNT * 3];
	int defectPointDataCnt;
	short *label_Image;
	int inspectionAcceptArea[12];
	int maxPixelDefectLabelN;
	int tMax;
	int defectCheckSW;
	int defectIntensity;

	int maxColorDiff;
	int defectCount;
	int searchRange;
	int tempAddress2;
	int targetPositionValue;
	int colorDiff;
	int value[3];

	label_Image = RotationEdgeImage;
	space = 20;
	memset(defectPointData, 0, MAX_DEFECT_POINT_COUNT * 3 * 2);
	defectPointDataCnt = 0;

	st_x = -(space + TabletCharacter.length / 2) + (TabletMatchingResult.AdjustCenterXInImage);
	end_x = (TabletCharacter.length / 2 + space) + (TabletMatchingResult.AdjustCenterXInImage);
	st_y = -(space + TabletCharacter.width / 2) + (TabletMatchingResult.AdjustCenterYInImage);
	end_y = (TabletCharacter.width / 2 + space) + (TabletMatchingResult.AdjustCenterYInImage);

	if (st_x < TabletSetupData.ImageCutStartX[cameraIndex - 1])
		st_x = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	if (end_x > TabletSetupData.ImageCutEndX[cameraIndex - 1])
		end_x = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	if (st_y < TabletSetupData.ImageCutStartY[cameraIndex - 1])
		st_y = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	if (end_y > TabletSetupData.ImageCutEndY[cameraIndex - 1])
		end_y = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	for (m = 0; m < 12; m++)
	{
		inspectionAcceptArea[m] = 0;
	}

	inspectionAcceptArea[NORMAL_INPECTION_AREA] = 1;
	inspectionAcceptArea[FRONT_SHAPE_EDGE_NEIGHBOR] = 1;
	inspectionAcceptArea[PRINT_AREA] = 3;
	inspectionAcceptArea[PRINT_NEIGHBOR_SHORT] = 3;
	inspectionAcceptArea[PRINT_NEIGHBOR_LONG] = 3;
	inspectionAcceptArea[FRONT_SHAPE_EDGE_AND_PRINT_SHORT] = 3;
	inspectionAcceptArea[FRONT_SHAPE_EDGE_AND_PRINT_LONG] = 3;

	defectIntensity = TabletGradeData.front_Color_Dirty_Intensity * 4;

	memset(TempImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

	for (i = st_y; i < end_y; i++)
	{
		for (j = st_x; j < end_x; j++)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;

			areaValue = InspectionArea[tempAddress];

			if (inspectionAcceptArea[areaValue] == 1 || inspectionAcceptArea[areaValue] == 3)
			{
				value[0] = ColorSourceImage[tempAddress * 3 + 0];
				value[1] = ColorSourceImage[tempAddress * 3 + 1];
				value[2] = ColorSourceImage[tempAddress * 3 + 2];

				value[selectedRGB] = value[selectedRGB] * 255 / (value[0] + value[1] + value[2]);

				TempImage[tempAddress] = value[selectedRGB];
			}
		}
	}

	for (y = st_y; y < end_y; y++)
	{
		for (x = st_x; x < end_x; x++)
		{
			defectCheckSW = 0;
			tempAddress = MAX_IMAGE_WIDTH * y + x;
			areaValue = InspectionArea[tempAddress];

			if (inspectionAcceptArea[areaValue])
			{
				if (inspectionAcceptArea[areaValue] == 1)
				{
					selfPositionValue = TempImage[tempAddress];

					maxColorDiff = 0;
					defectCount = 0;
					for (searchRange = 16; searchRange >= 4; searchRange -= 4)
					{
						tempAddress2 = MAX_IMAGE_WIDTH * (y - searchRange) + (x);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							//  ġ 񱳽ÿ Binary 
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y + searchRange) + (x);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y) + (x - searchRange);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y) + (x + searchRange);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y - searchRange) + (x - searchRange);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y + searchRange) + (x + searchRange);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y - searchRange) + (x + searchRange);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						tempAddress2 = MAX_IMAGE_WIDTH * (y + searchRange) + (x - searchRange);

						if (inspectionAcceptArea[InspectionArea[tempAddress2]] == 1)
						{
							targetPositionValue = TempImage[tempAddress2];

							colorDiff = abs(selfPositionValue - targetPositionValue);

							if (colorDiff > defectIntensity)
							{
								defectCount++;

								if (maxColorDiff < colorDiff)
								{
									maxColorDiff = colorDiff;
								}
							}
						}

						if (defectCount >= 4)
						{
							defectCheckSW = 1;
							break;
						}
					}
				}
				else if (inspectionAcceptArea[areaValue] == 3)
				{
					selfPositionValue = TempImage[tempAddress];

					maxColorDiff = 0;
					defectCount = 0;

					searchRange = 4;

					tempAddress2 = MAX_IMAGE_WIDTH * (y - searchRange) + (x);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						//  ġ 񱳽ÿ Binary 
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y + searchRange) + (x);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y) + (x - searchRange);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y) + (x + searchRange);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y - searchRange) + (x - searchRange);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y + searchRange) + (x + searchRange);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y - searchRange) + (x + searchRange);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					tempAddress2 = MAX_IMAGE_WIDTH * (y + searchRange) + (x - searchRange);

					if (inspectionAcceptArea[InspectionArea[tempAddress2]])
					{
						targetPositionValue = TempImage[tempAddress2];

						colorDiff = abs(selfPositionValue - targetPositionValue);

						if (colorDiff > defectIntensity)
						{
							defectCount++;

							if (maxColorDiff < colorDiff)
							{
								maxColorDiff = colorDiff;
							}
						}
					}

					if (defectCount == 8)
					{
						defectCheckSW = 1;
					}
				}
			}
			if (defectCheckSW && defectPointDataCnt < MAX_DEFECT_POINT_COUNT)
			{
				defectPointData[defectPointDataCnt * 3] = x;
				defectPointData[defectPointDataCnt * 3 + 1] = y;
				defectPointDataCnt++;
			}
		}
	}

	defectGroupN = DefectLabeling(label_Image, defectPointData, defectPointDataCnt, cameraIndex);

	if (ProcessingModeGlobal == INSPECTION_MODE)
	{
		tMax = 1;
		maxPixelDefectLabelN = -1;
		for (m = 1; m <= defectGroupN; m++)
		{
			if (Pixel_N_Of_Label[m] + Pixel_N_Of_MoreDarkOfLabel[m] > tMax)
			{
				tMax = Pixel_N_Of_Label[m] + Pixel_N_Of_MoreDarkOfLabel[m];
				maxPixelDefectLabelN = m;
			}
		}
		if (maxPixelDefectLabelN > 0)
		{
			if (Pixel_N_Of_Label[maxPixelDefectLabelN] + Pixel_N_Of_MoreDarkOfLabel[maxPixelDefectLabelN] > TabletGradeData.front_Color_Dirty_Size)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_FRONT_COLOR_DIRTY, cameraIndex, StartX_Label[maxPixelDefectLabelN],
									   EndX_Label[maxPixelDefectLabelN], StartY_Label[maxPixelDefectLabelN], EndY_Label[maxPixelDefectLabelN], Pixel_N_Of_Label[maxPixelDefectLabelN] + Pixel_N_Of_MoreDarkOfLabel[maxPixelDefectLabelN]);

#ifdef PC_SIM
				memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
			}
		}
	}
}
//---------------------------------------------------------------------------
void DefectColor(int processingMode, int cameraIndex)
{
	int i, j;
	int space;
	int meanCount;
	int tempAddress;
	int st_x, end_x, st_y, end_y;

	int diffR;
	int diffG;
	int diffB;
	int diffC;

	diffR = TabletGradeData.front_color_Intensity * 7 + 9;
	diffG = TabletGradeData.front_color_Intensity * 7 + 9;
	diffB = TabletGradeData.front_color_Intensity * 7 + 9;
	diffC = TabletGradeData.front_color_Intensity * 7 + 4;

	space = 10;
	MeanColorR = 0;
	MeanColorG = 0;
	MeanColorB = 0;
	meanCount = 0;

	st_x = -(space + TabletCharacter.length / 2) + (TabletMatchingResult.AdjustCenterXInImage);
	end_x = (TabletCharacter.length / 2 + space) + (TabletMatchingResult.AdjustCenterXInImage);
	st_y = -(space + TabletCharacter.width / 2) + (TabletMatchingResult.AdjustCenterYInImage);
	end_y = (TabletCharacter.width / 2 + space) + (TabletMatchingResult.AdjustCenterYInImage);

	if (st_x < TabletSetupData.ImageCutStartX[cameraIndex - 1])
		st_x = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	if (end_x > TabletSetupData.ImageCutEndX[cameraIndex - 1])
		end_x = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	if (st_y < TabletSetupData.ImageCutStartY[cameraIndex - 1])
		st_y = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	if (end_y > TabletSetupData.ImageCutEndY[cameraIndex - 1])
		end_y = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	for (i = st_y; i < end_y; i += 2)
	{
		for (j = st_x; j < end_x; j += 2)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;
			if (InspectionArea[tempAddress] == NORMAL_INPECTION_AREA)
			{
				MeanColorB += ColorSourceImage[tempAddress * 3];
				MeanColorG += ColorSourceImage[tempAddress * 3 + 1];
				MeanColorR += ColorSourceImage[tempAddress * 3 + 2];
				meanCount++;
			}
		}
	}

	if (meanCount)
	{
		MeanColorR /= meanCount;
		MeanColorG /= meanCount;
		MeanColorB /= meanCount;
	}

	if (ProcessingModeGlobal == INSPECTION_MODE && DefectSW == 0)
	{
		if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
		{
			if (abs(MeanColorB - TabletStudyData.tabletColorB_ForCamera1) > diffB)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs(MeanColorG - TabletStudyData.tabletColorG_ForCamera1) > diffG)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_G, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs(MeanColorR - TabletStudyData.tabletColorR_ForCamera1) > diffR)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_R, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs((MeanColorB - MeanColorG) - (TabletStudyData.tabletColorB_ForCamera1 - TabletStudyData.tabletColorG_ForCamera1)) > diffC)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs((MeanColorB - MeanColorR) - (TabletStudyData.tabletColorB_ForCamera1 - TabletStudyData.tabletColorR_ForCamera1)) > diffC)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs((MeanColorG - MeanColorR) - (TabletStudyData.tabletColorG_ForCamera1 - TabletStudyData.tabletColorR_ForCamera1)) > diffC)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
		}
		else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
		{
			if (abs(MeanColorB - TabletStudyData.tabletColorB_ForCamera9) > diffB)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs(MeanColorG - TabletStudyData.tabletColorG_ForCamera9) > diffG)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_G, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs(MeanColorR - TabletStudyData.tabletColorR_ForCamera9) > diffR)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_R, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs((MeanColorB - MeanColorG) - (TabletStudyData.tabletColorB_ForCamera9 - TabletStudyData.tabletColorG_ForCamera9)) > diffC)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs((MeanColorB - MeanColorR) - (TabletStudyData.tabletColorB_ForCamera9 - TabletStudyData.tabletColorR_ForCamera9)) > diffC)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
			if (abs((MeanColorG - MeanColorR) - (TabletStudyData.tabletColorG_ForCamera9 - TabletStudyData.tabletColorR_ForCamera9)) > diffC)
			{
				DefectSW = 1;
				DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
			}
		}
	}
	else if (ProcessingModeGlobal == STUDY_MODE) // For SELMA200, Rev by moon. (20180208) Camera Index
	{
		TabletStudyData.selectedFace = FRONT_FACE_FOR_COLOR;
		if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
		{
			TabletStudyData.tabletColorR_ForCamera1 = MeanColorR;
			TabletStudyData.tabletColorG_ForCamera1 = MeanColorG;
			TabletStudyData.tabletColorB_ForCamera1 = MeanColorB;
			TabletStudyData.tabletRearColorR_ForCamera1 = 0;
			TabletStudyData.tabletRearColorG_ForCamera1 = 0;
			TabletStudyData.tabletRearColorB_ForCamera1 = 0;
		}
		else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
		{
			TabletStudyData.tabletColorR_ForCamera9 = MeanColorR;
			TabletStudyData.tabletColorG_ForCamera9 = MeanColorG;
			TabletStudyData.tabletColorB_ForCamera9 = MeanColorB;
			TabletStudyData.tabletRearColorR_ForCamera9 = 0;
			TabletStudyData.tabletRearColorG_ForCamera9 = 0;
			TabletStudyData.tabletRearColorB_ForCamera9 = 0;
		}
	}
}
//---------------------------------------------------------------------------
void DefectColorForMuliLayerTablet(int processingMode, int cameraIndex)
{
	int i, j;
	int space;
	int meanCount;
	int tempAddress;
	int st_x, end_x, st_y, end_y;
	int diffR;
	int diffG;
	int diffB;
	int StudyColorR;
	int StudyColorG;
	int StudyColorB;

	diffR = TabletGradeData.front_color_Intensity * 3 + 7;
	diffG = TabletGradeData.front_color_Intensity * 3 + 7;
	diffB = TabletGradeData.front_color_Intensity * 3 + 7;

	space = 10;
	MeanColorR = 0;
	MeanColorG = 0;
	MeanColorB = 0;
	meanCount = 0;

	st_x = -(space + TabletCharacter.length / 2) + (TabletMatchingResult.AdjustCenterXInImage);
	end_x = (TabletCharacter.length / 2 + space) + (TabletMatchingResult.AdjustCenterXInImage);
	st_y = -(space + TabletCharacter.width / 2) + (TabletMatchingResult.AdjustCenterYInImage);
	end_y = (TabletCharacter.width / 2 + space) + (TabletMatchingResult.AdjustCenterYInImage);

	if (st_x < TabletSetupData.ImageCutStartX[cameraIndex - 1])
		st_x = TabletSetupData.ImageCutStartX[cameraIndex - 1];
	if (end_x > TabletSetupData.ImageCutEndX[cameraIndex - 1])
		end_x = TabletSetupData.ImageCutEndX[cameraIndex - 1];
	if (st_y < TabletSetupData.ImageCutStartY[cameraIndex - 1])
		st_y = TabletSetupData.ImageCutStartY[cameraIndex - 1];
	if (end_y > TabletSetupData.ImageCutEndY[cameraIndex - 1])
		end_y = TabletSetupData.ImageCutEndY[cameraIndex - 1];

	if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX) // For SELMA200, Rev by moon. (20180208) Camera Index
	{
		if (SelectedFace == FRONT_FACE_FOR_COLOR)
		{
			StudyColorR = TabletStudyData.tabletColorR_ForCamera1;
			StudyColorG = TabletStudyData.tabletColorG_ForCamera1;
			StudyColorB = TabletStudyData.tabletColorB_ForCamera1;
		}
		else
		{
			StudyColorR = TabletStudyData.tabletRearColorR_ForCamera1;
			StudyColorG = TabletStudyData.tabletRearColorG_ForCamera1;
			StudyColorB = TabletStudyData.tabletRearColorB_ForCamera1;
		}
	}
	else
	{
		if (SelectedFace == FRONT_FACE_FOR_COLOR)
		{
			StudyColorR = TabletStudyData.tabletColorR_ForCamera9;
			StudyColorG = TabletStudyData.tabletColorG_ForCamera9;
			StudyColorB = TabletStudyData.tabletColorB_ForCamera9;
		}
		else
		{
			StudyColorR = TabletStudyData.tabletRearColorR_ForCamera9;
			StudyColorG = TabletStudyData.tabletRearColorG_ForCamera9;
			StudyColorB = TabletStudyData.tabletRearColorB_ForCamera9;
		}
	}

	for (i = st_y; i < end_y; i += 2)
	{
		for (j = st_x; j < end_x; j += 2)
		{
			tempAddress = MAX_IMAGE_WIDTH * i + j;
			if (InspectionArea[tempAddress] == NORMAL_INPECTION_AREA)
			{
				MeanColorB += ColorSourceImage[tempAddress * 3];
				MeanColorG += ColorSourceImage[tempAddress * 3 + 1];
				MeanColorR += ColorSourceImage[tempAddress * 3 + 2];
				meanCount++;
			}
		}
	}

	if (meanCount)
	{
		MeanColorR /= meanCount;
		MeanColorG /= meanCount;
		MeanColorB /= meanCount;
	}

	if (ProcessingModeGlobal == INSPECTION_MODE && DefectSW == 0)
	{
		if (abs(MeanColorB - StudyColorB) > diffB)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_COLOR_B, cameraIndex, 0, 0, 0, 0, 0);
		}
		if (abs(MeanColorG - StudyColorG) > diffG)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_COLOR_G, cameraIndex, 0, 0, 0, 0, 0);
		}
		if (abs(MeanColorR - StudyColorR) > diffR)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_COLOR_R, cameraIndex, 0, 0, 0, 0, 0);
		}
	}
	else if (ProcessingModeGlobal == STUDY_MODE) // For SELMA200, Rev by moon. (20180208) Camera Index
	{
		TabletStudyData.selectedFace = SelectedFace;
		if (SelectedFace == FRONT_FACE_FOR_COLOR)
		{
			if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
			{
				TabletStudyData.tabletColorR_ForCamera1 = MeanColorR;
				TabletStudyData.tabletColorG_ForCamera1 = MeanColorG;
				TabletStudyData.tabletColorB_ForCamera1 = MeanColorB;

				TabletStudyData.tabletRearColorR_ForCamera1 = 0;
				TabletStudyData.tabletRearColorG_ForCamera1 = 0;
				TabletStudyData.tabletRearColorB_ForCamera1 = 0;
			}
			else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
			{
				TabletStudyData.tabletColorR_ForCamera9 = MeanColorR;
				TabletStudyData.tabletColorG_ForCamera9 = MeanColorG;
				TabletStudyData.tabletColorB_ForCamera9 = MeanColorB;

				TabletStudyData.tabletRearColorR_ForCamera9 = 0;
				TabletStudyData.tabletRearColorG_ForCamera9 = 0;
				TabletStudyData.tabletRearColorB_ForCamera9 = 0;
			}
		}
		else
		{
			if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
			{
				TabletStudyData.tabletColorR_ForCamera1 = 0;
				TabletStudyData.tabletColorG_ForCamera1 = 0;
				TabletStudyData.tabletColorB_ForCamera1 = 0;

				TabletStudyData.tabletRearColorR_ForCamera1 = MeanColorR;
				TabletStudyData.tabletRearColorG_ForCamera1 = MeanColorG;
				TabletStudyData.tabletRearColorB_ForCamera1 = MeanColorB;
			}
			else if (cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
			{
				TabletStudyData.tabletColorR_ForCamera9 = 0;
				TabletStudyData.tabletColorG_ForCamera9 = 0;
				TabletStudyData.tabletColorB_ForCamera9 = 0;

				TabletStudyData.tabletRearColorR_ForCamera9 = MeanColorR;
				TabletStudyData.tabletRearColorG_ForCamera9 = MeanColorG;
				TabletStudyData.tabletRearColorB_ForCamera9 = MeanColorB;
			}
		}
	}
}
//---------------------------------------------------------------------------
void DefectSearchInEdgeNeighborArea(void)
{
	int n, i, j, r, m, x, y;
	unsigned char ShellMeanImage[SHAPE_SHELL_DEPTH][540];
	short ShellMeanImageSmall[SHAPE_SHELL_DEPTH][180]; // 1/3
	unsigned char ShellDefectImage[SHAPE_SHELL_DEPTH][540];
	unsigned char ShellSmallDefectImage[SHAPE_SHELL_DEPTH][180]; // 1/3
	int closingSize;
	int step;
	int conversionN;
	int tempSum;
	int defectCount;
	int maxDiff;
	short tempData[180];
	short resultData[180];
	int grayDiff;

	int range;
	int tempAngle;
	int addthresh;
	int tempCount;
	int defectRowPosition;
	int rowMeanForSmallShelImage[SHAPE_SHELL_DEPTH];
	int alpha;
	int areaValue;
	int newRange;
	int compareDepth;
	int acceptableArea[10];
	range = TabletGradeData.frontShapeEdgeNeighborRange;

	if (SelectedFace == FRONT_FACE_FOR_COLOR)
		alpha = TabletGradeData.front_edge_Intensity;
	else
		alpha = TabletGradeData.rear_edge_Intensity;

	if (TabletCharacter.shape == OBLONG || TabletCharacter.shape == OVAL)
	{
		if (SelectedFace == FRONT_FACE_FOR_COLOR)
			alpha = TabletGradeData.front_edge_Intensity + 1; //   ѵ ø.
		else
			alpha = TabletGradeData.rear_edge_Intensity + 1; //   ѵ ø.
	}

	memset(TempImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	memset(ShellDefectImage, 0, sizeof(unsigned char) * SHAPE_SHELL_DEPTH * 540);
	memset(ShellSmallDefectImage, 0, sizeof(unsigned char) * SHAPE_SHELL_DEPTH * 180);

	for (i = 0; i < SHAPE_SHELL_DEPTH; i++)
	{
		for (j = 0; j < 540; j++)
		{
			tempSum = 0;
			for (n = j - 1; n <= j + 1; n++)
			{
				conversionN = (n + 360) % 360;
				tempSum += ShapeShellGrayLebel[i][conversionN];
			}
			ShellMeanImage[i][j] = tempSum / 3;

			tempSum = 0;
			for (n = j - 4; n <= j + 4; n += 2)
			{
				conversionN = (n + 360) % 360;
				tempSum += ShapeShellGrayLebel[i][conversionN];
			}
			ShellMeanImageSmall[i][j / 3] = tempSum / 5;
		}
	}

	for (i = 1 + (alpha - 2); i < range; i++)
	{
		if (i < 2)
			addthresh = 6 + alpha;
		else
			addthresh = alpha;
		for (j = 20; j < 540 - 20; j++)
		{
			defectCount = 0;
			maxDiff = 0;
			grayDiff = (ShellMeanImage[i][j - 15] - ShellMeanImage[i][j]);
			if (grayDiff > 9 + addthresh)
			{
				if (maxDiff < grayDiff)
					maxDiff = grayDiff;
				defectCount++;
			}
			grayDiff = (ShellMeanImage[i][j + 15] - ShellMeanImage[i][j]);
			if (grayDiff > 9 + addthresh)
			{
				if (maxDiff < grayDiff)
					maxDiff = grayDiff;
				defectCount++;
			}
			grayDiff = (ShellMeanImage[i][j - 10] - ShellMeanImage[i][j]);
			if (grayDiff > 8 + addthresh)
			{
				if (maxDiff < grayDiff)
					maxDiff = grayDiff;
				defectCount++;
			}
			grayDiff = (ShellMeanImage[i][j + 10] - ShellMeanImage[i][j]);
			if (grayDiff > 8 + addthresh)
			{
				if (maxDiff < grayDiff)
					maxDiff = grayDiff;
				defectCount++;
			}
			grayDiff = (ShellMeanImage[i][j - 5] - ShellMeanImage[i][j]);
			if (grayDiff > 8 + addthresh)
			{
				if (maxDiff < grayDiff)
					maxDiff = grayDiff;
				defectCount++;
			}
			grayDiff = (ShellMeanImage[i][j + 5] - ShellMeanImage[i][j]);
			if (grayDiff > 8 + addthresh)
			{
				if (maxDiff < grayDiff)
					maxDiff = grayDiff;
				defectCount++;
			}

			if (defectCount >= 3)
			{
				ShellDefectImage[i][j] = maxDiff;
			}
		}
	}

	if (range > 15)
		newRange = range - 2;
	else
		newRange = range;

	if (alpha <= 5)
	{
		// ū ĵ
		closingSize = 16 - alpha * 2;
		step = 3;

		for (i = 0; i < SHAPE_SHELL_DEPTH; i++)
			rowMeanForSmallShelImage[i] = 0;

		for (i = 1 + (alpha - 2); i < newRange; i++)
		{
			LineDataDialation(&ShellMeanImageSmall[i][0], tempData, closingSize, step, 180);
			LineDataErosion(tempData, resultData, closingSize, step, 180);
			tempCount = 0;
			for (j = 14; j < 180 - 14; j++)
			{
				rowMeanForSmallShelImage[i] += ShellMeanImageSmall[i][j];
				tempCount++;
				if (i < 2)
				{
					if (resultData[j] - ShellMeanImageSmall[i][j] > 14 + alpha * 2)
					{
						ShellSmallDefectImage[i][j] = resultData[j] - ShellMeanImageSmall[i][j];
					}
				}
				else if (i < 4)
				{
					if (resultData[j] - ShellMeanImageSmall[i][j] > 11 + alpha * 2)
					{
						ShellSmallDefectImage[i][j] = resultData[j] - ShellMeanImageSmall[i][j];
					}
				}
				else
				{
					if (resultData[j] - ShellMeanImageSmall[i][j] > 8 + alpha * 2)
					{
						ShellSmallDefectImage[i][j] = resultData[j] - ShellMeanImageSmall[i][j];
					}
				}
			}
			rowMeanForSmallShelImage[i] /= tempCount;
		}

		//////ª ĵ////////
		closingSize = 5;
		step = 2;
		for (i = 2 + (alpha - 2); i < newRange; i++)
		{
			//  ptr = (byte*) img2->ScanLine[i+80];
			LineDataDialation(&ShellMeanImageSmall[i][0], tempData, closingSize, step, 180);
			LineDataErosion(tempData, resultData, closingSize, step, 180);
			for (j = 14; j < 180 - 14; j++)
			{

				if (i <= 3)
				{
					if (resultData[j] - ShellMeanImageSmall[i][j] > 7 + alpha * 2)
					{
						ShellSmallDefectImage[i][j] = resultData[j] - ShellMeanImageSmall[i][j];
					}
				}
				else
				{
					if (resultData[j] - ShellMeanImageSmall[i][j] > 5 + alpha * 2)
					{
						ShellSmallDefectImage[i][j] = resultData[j] - ShellMeanImageSmall[i][j];
					}
				}
			}
		}

		//////// ҷ////////////////
		closingSize = 5;
		step = 2;
		for (i = 2 + (alpha - 2); i < newRange; i++)
		{
			LineDataErosion(&ShellMeanImageSmall[i][0], tempData, closingSize, step, 180);
			LineDataDialation(tempData, resultData, closingSize, step, 180);
			for (j = 14; j < 180 - 14; j++)
			{

				if (ShellSmallDefectImage[i][j] == 0)
				{
					if (i <= 2)
					{
						if (ShellMeanImageSmall[i][j] - resultData[j] > 6 + alpha * 2)
						{
							ShellSmallDefectImage[i][j] = ShellMeanImageSmall[i][j] - resultData[j];
						}
					}
					else
					{
						if (ShellMeanImageSmall[i][j] - resultData[j] > 5 + alpha * 2)
						{
							ShellSmallDefectImage[i][j] = ShellMeanImageSmall[i][j] - resultData[j];
						}
					}
				}
			}
		}

		compareDepth = 12;
		if (range <= 12)
			compareDepth = range - 2;
		if (TabletCharacter.kind != SUGARCOATING)
		{
			for (j = 10; j < 540 - 10; j++)
			{
				defectRowPosition = 0;
				for (i = 1; i < compareDepth; i++)
				{
					if (i == 1)
					{
						if ((ShellMeanImage[compareDepth][j] + rowMeanForSmallShelImage[i] - (ShellMeanImage[i][j] + rowMeanForSmallShelImage[compareDepth])) > 8 + alpha * 2)
						{
							defectRowPosition = i;
						}
						else
						{
							break;
						}
					}
					else if (i == 2)
					{
						if ((ShellMeanImage[compareDepth][j] + rowMeanForSmallShelImage[i] - (ShellMeanImage[i][j] + rowMeanForSmallShelImage[compareDepth])) > 8 + alpha * 2)
						{
							defectRowPosition = i;
						}
						else
						{
							break;
						}
					}
					else
					{
						if ((ShellMeanImage[compareDepth][j] + rowMeanForSmallShelImage[i] - (ShellMeanImage[i][j] + rowMeanForSmallShelImage[compareDepth])) > 10 + alpha * 2)
						{
							defectRowPosition = i;
						}
						else
						{
							break;
						}
					}
				}
				if (defectRowPosition >= 4 + (alpha - 2))
				{
					for (i = 1; i <= defectRowPosition; i++)
					{
						if (ShellDefectImage[i][j] == 0)
							ShellDefectImage[i][j] = (ShellMeanImage[compareDepth][j] + rowMeanForSmallShelImage[i] - ShellMeanImage[i][j] - rowMeanForSmallShelImage[compareDepth]);
					}
				}
			}
		}
	}
	for (m = 0; m < 10; m++)
	{
		acceptableArea[m] = 0;
		if (m == FRONT_SHAPE_EDGE_NEIGHBOR || m == FRONT_SHAPE_EDGE)
			acceptableArea[m] = 1;
	}
	for (r = 0; r < range; r++)
	{
		for (m = 0; m < ShapeShellDataCount[r]; m++)
		{
			tempAngle = ShapeShellData[r][m][2];
			if (ShellDefectImage[r][tempAngle] != 0)
			{
				x = ShapeShellData[r][m][0];
				y = ShapeShellData[r][m][1];
				areaValue = InspectionArea[y * MAX_IMAGE_WIDTH + x];
				if (acceptableArea[areaValue])
					TempImage[y * MAX_IMAGE_WIDTH + x] = ShellDefectImage[r][tempAngle];
			}
			else if (ShellSmallDefectImage[r][tempAngle / 3] != 0)
			{
				x = ShapeShellData[r][m][0];
				y = ShapeShellData[r][m][1];
				areaValue = InspectionArea[y * MAX_IMAGE_WIDTH + x];
				if (acceptableArea[areaValue])
					TempImage[y * MAX_IMAGE_WIDTH + x] = ShellSmallDefectImage[r][tempAngle / 3];
			}
			tempAngle = ShapeShellData[r][m][2] + 360;
			if (tempAngle < 540)
			{
				if (ShellDefectImage[r][tempAngle] != 0)
				{
					x = ShapeShellData[r][m][0];
					y = ShapeShellData[r][m][1];
					areaValue = InspectionArea[y * MAX_IMAGE_WIDTH + x];
					if (acceptableArea[areaValue])
						TempImage[y * MAX_IMAGE_WIDTH + x] = ShellDefectImage[r][tempAngle];
				}
				else if (ShellSmallDefectImage[r][tempAngle / 3] != 0)
				{
					x = ShapeShellData[r][m][0];
					y = ShapeShellData[r][m][1];
					areaValue = InspectionArea[y * MAX_IMAGE_WIDTH + x];
					if (acceptableArea[areaValue])
						TempImage[y * MAX_IMAGE_WIDTH + x] = ShellSmallDefectImage[r][tempAngle / 3];
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
/*
void ColorStainCheck(int cameraIndex)
{
	int startX, endX, startY, endY;
	int tempAddress;
	int tempAddress2;
	int searchRange;
	int x, y;
	int removeSize;
	unsigned char *InspectionBinaryArea;
	unsigned char *DefectImage;
	short *label_Image;
	int srcColor[3];
	int defectGroupN;
	char DefectMatrix[3][3];
	int DefectCount;
	int unDefectCount1, unDefectCount2, unDefectCount3, unDefectCount4;
	int tempX, tempY;
	int colorThreshold;
	int maxColorDiff;
	int n, m;
	int tMax;
	int maxPixelDefectLabelN;
	int srcSum;
	int dstSum;
	int DefectPixelCount;
	int r;

	char unDefectMat1[3][3] =
	{
		{ 1, 0, 0 },
	{ 1, 0, 0 },
	{ 1, 1, 1 }
	};

	char unDefectMat2[3][3] =
	{
		{ 1, 1, 1 },
	{ 0, 0, 1 },
	{ 0, 0, 1 }
	};

	char unDefectMat3[3][3] =
	{
		{ 1, 1, 1 },
	{ 1, 0, 0 },
	{ 1, 0, 0 }
	};

	char unDefectMat4[3][3] =
	{
		{ 0, 0, 1 },
	{ 0, 0, 1 },
	{ 1, 1, 1 }
	};

	startX = TabletSetupData.ImageCutStartX[cameraIndex - 1] + 4;
	endX = TabletSetupData.ImageCutEndX[cameraIndex - 1] - 4;
	startY = TabletSetupData.ImageCutStartY[cameraIndex - 1] + 4;
	endY = TabletSetupData.ImageCutEndY[cameraIndex - 1] - 4;

	InspectionBinaryArea = ShapeBinaryImage;
	DefectImage = GradientImage;

	memset(InspectionBinaryArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
	memset(DefectImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

	removeSize = TabletGradeData.EnforcementStainDefectInspectionAreaSize;

	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionArea[tempAddress])
			{
				tempX = (x - TabletMatchingResult.AdjustCenterXInImage) * removeSize / 100 + TabletMatchingResult.AdjustCenterXInImage;
				tempY = (y - TabletMatchingResult.AdjustCenterYInImage) * removeSize / 100 + TabletMatchingResult.AdjustCenterYInImage;

				if (tempX > startX && tempX < endX && tempY > startY && tempY < endY)
				{
					tempAddress2 = MAX_IMAGE_WIDTH * tempY + tempX;
					if (InspectionArea[tempAddress2] != PRINT_AREA &&
						InspectionArea[tempAddress2] != PRINT_NEIGHBOR_SHORT &&
						InspectionArea[tempAddress2] != PRINT_NEIGHBOR_LONG)
					{
						InspectionBinaryArea[tempAddress2] = 1;
					}
				}
			}
		}
	}

	colorThreshold = TabletGradeData.EnforcementStainDefectThreshold * 2;

	DefectPixelCount = 0;
	searchRange = 20;
	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionBinaryArea[tempAddress])
			{
				srcColor[0] = ColorSourceImage[tempAddress * 3 + 0];
				srcColor[1] = ColorSourceImage[tempAddress * 3 + 1];
				srcColor[2] = ColorSourceImage[tempAddress * 3 + 2];

				srcSum = srcColor[0] + srcColor[1] + srcColor[2];

				DefectCount = 0;
				memset(DefectMatrix, 0, sizeof(char) * 3 * 3);

				for (r = searchRange; r >= 4; r -= 4)
				{
					if (DefectMatrix[1][0] == 0)
					{
						tempAddress2 = tempAddress - r;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[1][0] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[1][2] == 0)
					{
						tempAddress2 = tempAddress + r;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[1][2] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[0][1] == 0)
					{
						tempAddress2 = tempAddress - r * MAX_IMAGE_WIDTH;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[0][1] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[2][1] == 0)
					{
						tempAddress2 = tempAddress + r * MAX_IMAGE_WIDTH;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[2][1] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[0][0] == 0)
					{
						tempAddress2 = tempAddress - r - r * MAX_IMAGE_WIDTH;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[0][0] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[2][0] == 0)
					{
						tempAddress2 = tempAddress - r + r * MAX_IMAGE_WIDTH;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[2][0] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[0][2] == 0)
					{
						tempAddress2 = tempAddress + r - r * MAX_IMAGE_WIDTH;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[0][2] = 1;
								DefectCount++;
							}
						}
					}

					if (DefectMatrix[2][2] == 0)
					{
						tempAddress2 = tempAddress + r + r * MAX_IMAGE_WIDTH;
						if (InspectionBinaryArea[tempAddress2])
						{
			  if(BrightPixelNeighborPrint[tempAddress2]) continue;

							dstSum = ColorSourceImage[tempAddress2 * 3 + 0] + ColorSourceImage[tempAddress2 * 3 + 1] + ColorSourceImage[tempAddress2 * 3 + 2];

							maxColorDiff = srcSum - dstSum;

							if (maxColorDiff >= colorThreshold)
							{
								DefectMatrix[2][2] = 1;
								DefectCount++;
							}
						}
					}
				}

				unDefectCount1 = 0;
				for (n = 0; n < 3; n++)
				{
					for (m = 0; m < 3; m++)
					{
						if (unDefectMat1[n][m] && DefectMatrix[n][m])
						{
							unDefectCount1++;
						}
					}
				}

				unDefectCount2 = 0;
				for (n = 0; n < 3; n++)
				{
					for (m = 0; m < 3; m++)
					{
						if (unDefectMat2[n][m] && DefectMatrix[n][m])
						{
							unDefectCount2++;
						}
					}
				}

				unDefectCount3 = 0;
				for (n = 0; n < 3; n++)
				{
					for (m = 0; m < 3; m++)
					{
						if (unDefectMat3[n][m] && DefectMatrix[n][m])
						{
							unDefectCount3++;
						}
					}
				}

				unDefectCount4 = 0;
				for (n = 0; n < 3; n++)
				{
					for (m = 0; m < 3; m++)
					{
						if (unDefectMat4[n][m] && DefectMatrix[n][m])
						{
							unDefectCount4++;
						}
					}
				}

				if (DefectCount >= 6)
				{
					DefectImage[tempAddress] = 1;
					DefectPixelCount++;
				}
				else
				{
					if ((unDefectCount1 < 3 && unDefectCount2 < 3 && unDefectCount3 < 3 && unDefectCount4 < 3) && DefectCount >= 3)
					{
						DefectImage[tempAddress] = 2;
						DefectPixelCount++;
					}
				}
			}
		}
	}

	label_Image = RotationEdgeImage;
	memset(label_Image, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

	defectGroupN = SmallSizePixelLabeling(DefectImage, label_Image, startX, endX, startY, endY, MAX_IMAGE_WIDTH);

	tMax = 1;
	maxPixelDefectLabelN = -1;
	for (m = 1; m <= defectGroupN; m++)
	{
		if (labelingPxCount[m] > tMax)
		{
			tMax = labelingPxCount[m];
			maxPixelDefectLabelN = m;
		}
	}

	if (maxPixelDefectLabelN > 0)
	{
		if (labelingPxCount[maxPixelDefectLabelN] > TabletGradeData.EnforcementStainDefectMaxLabelSize)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_FRONT_BRIGHT_STAIN_LABEL, cameraIndex, LabelStX[maxPixelDefectLabelN],
				LabelEdX[maxPixelDefectLabelN], LabelStY[maxPixelDefectLabelN], LabelEdY[maxPixelDefectLabelN], labelingPxCount[maxPixelDefectLabelN]);
#ifdef PC_SIM
			memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
		}
	}

	if (DefectSW == 0)
	{
		if (DefectPixelCount > TabletGradeData.EnforcementStainDefectAllGroupSize)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_FRONT_BRIGHT_STAIN_ALL, cameraIndex, 10, MAX_IMAGE_WIDTH - 10, 10, MAX_IMAGE_HEIGHT - 10, DefectPixelCount);
#ifdef PC_SIM
			memcpy(LabelImage_Virtual, label_Image, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
#endif
		}
	}
}
*/
//---------------------------------------------------------------------------
void makeFrontFaceInspectionAreaForMarvelingTablet(int cameraIndex)
{
	int x, y;
	int tempAddress;
	int startX, endX, startY, endY;
	int tempEdgeMask;
	int m;
	int i, j;

	startX = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	endX = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	startY = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	endY = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	tempEdgeMask = 2 + TabletGradeData.front_unInspectionIntensity_ForEdge;

	for (m = 0; m < ShapeShellDataCount[0]; m++)
	{
		x = ShapeShellData[0][m][0];
		y = ShapeShellData[0][m][1];
		for (i = y - tempEdgeMask; i <= y + tempEdgeMask; i++)
		{
			for (j = x - tempEdgeMask; j <= x + tempEdgeMask; j++)
			{
				tempAddress = MAX_IMAGE_WIDTH * i + j;
				if (InspectionArea[tempAddress])
					InspectionArea[tempAddress] = FRONT_SHAPE_EDGE;
			}
		}
	}

	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionArea[tempAddress] == FRONT_SHAPE_EDGE_NEIGHBOR)
			{
				InspectionArea[tempAddress] = NORMAL_INPECTION_AREA;
			}
		}
	}
}
//---------------------------------------------------------------------------
void EngraveWhiteDefectCheck(int cameraIndex)
{
	int x, y;
	int tempAddress;
	int tempAddress2;
	int startX, endX, startY, endY;
	int printColor[3];
	int printLabelColor[THREED_PRINT_MAX_LABEL_COUNT][3];
	int printLabelColorCount[THREED_PRINT_MAX_LABEL_COUNT];
	int labelNum;
	int n, m;
	int tempCount;
	int bColorDiff, gColorDiff, rColorDiff;
	int maxColorDiff;
	int colorThreshold;
	int searchRange;
	int selfColor[3];
	unsigned char *tempPrintArea;
	unsigned char *whiteSpotArea;
	int tempX, tempY;
	char DefectMatrix[3][3];
	int DefectCount;
	int unDefectCount1, unDefectCount2, unDefectCount3, unDefectCount4;
	int whiteSpotCount;
	int uninsAreaSize;
	short *label_Image;
	int defectGroupN;
	int tMax;
	int maxPixelDefectLabelN;
#ifdef PC_SIM
	int defectLabelN;
#endif

	char unDefectMat1[3][3] =
		{
			{1, 0, 0},
			{1, 0, 0},
			{1, 1, 1}};

	char unDefectMat2[3][3] =
		{
			{1, 1, 1},
			{0, 0, 1},
			{0, 0, 1}};

	char unDefectMat3[3][3] =
		{
			{1, 1, 1},
			{1, 0, 0},
			{1, 0, 0}};

	char unDefectMat4[3][3] =
		{
			{0, 0, 1},
			{0, 0, 1},
			{1, 1, 1}};

	startX = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	endX = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	startY = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	endY = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	tempPrintArea = TempImage2;
	whiteSpotArea = TempImage3;

	memset(tempPrintArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT); // print area

	memset(printLabelColor, 0, sizeof(int) * THREED_PRINT_MAX_LABEL_COUNT * 3);
	memset(printLabelColorCount, 0, sizeof(int) * THREED_PRINT_MAX_LABEL_COUNT);
	for (y = startY; y < endY; y++)
	{
		for (x = startX; x < endX; x++)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (PrintLabelArea[tempAddress] & 0xF0)
			{
				labelNum = ((PrintLabelArea[tempAddress] & 0xF0) >> 4);

				printLabelColor[labelNum][0] += ColorSourceImage[tempAddress * 3 + 0];
				printLabelColor[labelNum][1] += ColorSourceImage[tempAddress * 3 + 1];
				printLabelColor[labelNum][2] += ColorSourceImage[tempAddress * 3 + 2];
				printLabelColorCount[labelNum]++;

				tempPrintArea[tempAddress] = 1;
			}
		}
	}

	printColor[0] = printColor[1] = printColor[2] = tempCount = 0;
	for (n = 0; n < THREED_PRINT_MAX_LABEL_COUNT; n++)
	{
		if (printLabelColorCount[n])
		{
			printLabelColor[n][0] /= printLabelColorCount[n];
			printLabelColor[n][1] /= printLabelColorCount[n];
			printLabelColor[n][2] /= printLabelColorCount[n];

			printColor[0] += printLabelColor[n][0];
			printColor[1] += printLabelColor[n][1];
			printColor[2] += printLabelColor[n][2];
			tempCount++;
		}
	}

	if (tempCount)
	{
		printColor[0] /= tempCount;
		printColor[1] /= tempCount;
		printColor[2] /= tempCount;
	}

	GlobalPrintColor[0] = printColor[0];
	GlobalPrintColor[1] = printColor[1];
	GlobalPrintColor[2] = printColor[2];

	if (ProcessingModeGlobal == STUDY_MODE)
	{
		TabletStudyData.tabletEngraveColorForCamera1[0] = 0;
		TabletStudyData.tabletEngraveColorForCamera1[1] = 0;
		TabletStudyData.tabletEngraveColorForCamera1[2] = 0;

		TabletStudyData.tabletRearEngraveColorForCamera1[0] = 0;
		TabletStudyData.tabletRearEngraveColorForCamera1[1] = 0;
		TabletStudyData.tabletRearEngraveColorForCamera1[2] = 0;

		TabletStudyData.tabletEngraveColorForCamera9[0] = 0;
		TabletStudyData.tabletEngraveColorForCamera9[1] = 0;
		TabletStudyData.tabletEngraveColorForCamera9[2] = 0;

		TabletStudyData.tabletRearEngraveColorForCamera9[0] = 0;
		TabletStudyData.tabletRearEngraveColorForCamera9[1] = 0;
		TabletStudyData.tabletRearEngraveColorForCamera9[2] = 0;

		if (cameraIndex == 1)
		{
			if (SelectedFace == FRONT_FACE_FOR_COLOR)
			{
				TabletStudyData.tabletEngraveColorForCamera1[0] = printColor[0];
				TabletStudyData.tabletEngraveColorForCamera1[1] = printColor[1];
				TabletStudyData.tabletEngraveColorForCamera1[2] = printColor[2];
			}
			else
			{
				TabletStudyData.tabletRearEngraveColorForCamera1[0] = printColor[0];
				TabletStudyData.tabletRearEngraveColorForCamera1[1] = printColor[1];
				TabletStudyData.tabletRearEngraveColorForCamera1[2] = printColor[2];
			}
		}
		else
		{
			if (SelectedFace == FRONT_FACE_FOR_COLOR)
			{
				TabletStudyData.tabletEngraveColorForCamera9[0] = printColor[0];
				TabletStudyData.tabletEngraveColorForCamera9[1] = printColor[1];
				TabletStudyData.tabletEngraveColorForCamera9[2] = printColor[2];
			}
			else
			{
				TabletStudyData.tabletRearEngraveColorForCamera9[0] = printColor[0];
				TabletStudyData.tabletRearEngraveColorForCamera9[1] = printColor[1];
				TabletStudyData.tabletRearEngraveColorForCamera9[2] = printColor[2];
			}
		}
	}
	else
	{
		if (tempCount) // μⰡ Ī 
		{
			colorThreshold = TabletGradeData.FrontFaceEngraveColorGrade;

			if (colorThreshold < 20) // MAX
			{
#ifdef PC_SIM
				defectLabelN = 0;
#endif
				for (n = 1; n < tempCount + 1; n++)
				{
					if (cameraIndex == 1)
					{
						if (SelectedFace == FRONT_FACE_FOR_COLOR)
						{
							bColorDiff = printLabelColor[n][0] - TabletStudyData.tabletEngraveColorForCamera1[0];
							gColorDiff = printLabelColor[n][1] - TabletStudyData.tabletEngraveColorForCamera1[1];
							rColorDiff = printLabelColor[n][2] - TabletStudyData.tabletEngraveColorForCamera1[2];
						}
						else
						{
							bColorDiff = printLabelColor[n][0] - TabletStudyData.tabletRearEngraveColorForCamera1[0];
							gColorDiff = printLabelColor[n][1] - TabletStudyData.tabletRearEngraveColorForCamera1[1];
							rColorDiff = printLabelColor[n][2] - TabletStudyData.tabletRearEngraveColorForCamera1[2];
						}
					}
					else
					{
						if (SelectedFace == FRONT_FACE_FOR_COLOR)
						{
							bColorDiff = printLabelColor[n][0] - TabletStudyData.tabletEngraveColorForCamera9[0];
							gColorDiff = printLabelColor[n][1] - TabletStudyData.tabletEngraveColorForCamera9[1];
							rColorDiff = printLabelColor[n][2] - TabletStudyData.tabletEngraveColorForCamera9[2];
						}
						else
						{
							bColorDiff = printLabelColor[n][0] - TabletStudyData.tabletRearEngraveColorForCamera9[0];
							gColorDiff = printLabelColor[n][1] - TabletStudyData.tabletRearEngraveColorForCamera9[1];
							rColorDiff = printLabelColor[n][2] - TabletStudyData.tabletRearEngraveColorForCamera9[2];
						}
					}

					maxColorDiff = max(bColorDiff, max(gColorDiff, rColorDiff));

					if (maxColorDiff >= colorThreshold)
					{
#ifdef PC_SIM
						defectLabelN = n;
#endif

						DefectSW = 1;
						DefectInformationWrite(DEFECT_FRONT_WHITE_ENGRAVE, cameraIndex, 0, 0, 0, 0, maxColorDiff);
						break;
					}
				}
			}
		}

#ifdef PC_SIM
		if (DefectSW)
		{
			memset(LabelImage_Virtual, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

			for (y = startY; y < endY; y++)
			{
				for (x = startX; x < endX; x++)
				{
					tempAddress = MAX_IMAGE_WIDTH * y + x;

					if (((PrintLabelArea[tempAddress] & 0xF0) >> 4) == defectLabelN)
					{
						LabelImage_Virtual[tempAddress] = ((PrintLabelArea[tempAddress] & 0xF0) >> 4);
					}
				}
			}
		}
#endif

		if (DefectSW == 0 && tempCount)
		{
			uninsAreaSize = TabletGradeData.dummy[0];

			// ũ 
			memcpy(whiteSpotArea, tempPrintArea, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT); // ӽ  Ҵ
			for (y = startY; y < endY; y++)
			{
				for (x = startX; x < endX; x++)
				{
					tempAddress = MAX_IMAGE_WIDTH * y + x;

					if (whiteSpotArea[tempAddress] &&
						(whiteSpotArea[tempAddress - uninsAreaSize] == 0 ||
							whiteSpotArea[tempAddress + uninsAreaSize] == 0 ||
							whiteSpotArea[tempAddress - uninsAreaSize * MAX_IMAGE_WIDTH] == 0 ||
							whiteSpotArea[tempAddress + uninsAreaSize * MAX_IMAGE_WIDTH] == 0))
					{
						tempPrintArea[tempAddress] = 0;
					}
				}
			}

			memset(whiteSpotArea, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

			searchRange = 16;
			colorThreshold = TabletGradeData.FrontFaceEngraveWhiteSpotIntensity * 2;
			whiteSpotCount = 0;

			// 2 ҷ 
			for (y = startY; y < endY; y++)
			{
				for (x = startX; x < endX; x++)
				{
					tempAddress = MAX_IMAGE_WIDTH * y + x;

					if (tempPrintArea[tempAddress])
					{
						selfColor[0] = ColorSourceImage[tempAddress * 3 + 0];
						selfColor[1] = ColorSourceImage[tempAddress * 3 + 1];
						selfColor[2] = ColorSourceImage[tempAddress * 3 + 2];

						memset(DefectMatrix, 0, sizeof(char) * 3 * 3);

						for (tempY = y - searchRange; tempY <= y + searchRange; tempY += 2)
						{
							for (tempX = x - searchRange; tempX <= x + searchRange; tempX += 2)
							{
								tempAddress2 = MAX_IMAGE_WIDTH * tempY + tempX;
								// if(tempPrintArea[tempAddress2])
								{
									bColorDiff = selfColor[0] - ColorSourceImage[tempAddress2 * 3 + 0];
									gColorDiff = selfColor[1] - ColorSourceImage[tempAddress2 * 3 + 1];
									rColorDiff = selfColor[2] - ColorSourceImage[tempAddress2 * 3 + 2];

									maxColorDiff = max(bColorDiff, max(gColorDiff, rColorDiff));

									if (maxColorDiff >= colorThreshold)
									{
										if (tempX < x && tempY < y)
											DefectMatrix[0][0] = 1;
										else if (tempX < x && tempY > y)
											DefectMatrix[2][0] = 1;
										else if (tempX > x && tempY < y)
											DefectMatrix[0][2] = 1;
										else if (tempX > x && tempY > y)
											DefectMatrix[2][2] = 1;
										else if (tempX < x)
											DefectMatrix[1][0] = 1;
										else if (tempX > x)
											DefectMatrix[1][2] = 1;
										else if (tempY < y)
											DefectMatrix[0][1] = 1;
										else if (tempY > y)
											DefectMatrix[2][1] = 1;
									}
								}
							}
						}

						DefectCount = 0;
						for (n = 0; n < 3; n++)
						{
							for (m = 0; m < 3; m++)
							{
								if (DefectMatrix[n][m])
								{
									DefectCount++;
								}
							}
						}

						unDefectCount1 = 0;
						for (n = 0; n < 3; n++)
						{
							for (m = 0; m < 3; m++)
							{
								if (unDefectMat1[n][m] && DefectMatrix[n][m])
								{
									unDefectCount1++;
								}
							}
						}

						unDefectCount2 = 0;
						for (n = 0; n < 3; n++)
						{
							for (m = 0; m < 3; m++)
							{
								if (unDefectMat2[n][m] && DefectMatrix[n][m])
								{
									unDefectCount2++;
								}
							}
						}

						unDefectCount3 = 0;
						for (n = 0; n < 3; n++)
						{
							for (m = 0; m < 3; m++)
							{
								if (unDefectMat3[n][m] && DefectMatrix[n][m])
								{
									unDefectCount3++;
								}
							}
						}

						unDefectCount4 = 0;
						for (n = 0; n < 3; n++)
						{
							for (m = 0; m < 3; m++)
							{
								if (unDefectMat4[n][m] && DefectMatrix[n][m])
								{
									unDefectCount4++;
								}
							}
						}

						if (DefectCount >= 6)
						{
							whiteSpotArea[tempAddress] = 1;
							whiteSpotCount++;
						}
						else
						{
							if ((unDefectCount1 < 3 && unDefectCount2 < 3 && unDefectCount3 < 3 && unDefectCount4 < 3) && DefectCount >= 3)
							{
								whiteSpotArea[tempAddress] = 2;
								whiteSpotCount++;
							}
						}
					}
				}
			}

#ifdef PC_SIM
			memset(LabelImage_Virtual, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

			for (y = startY; y < endY; y++)
			{
				for (x = startX; x < endX; x++)
				{
					tempAddress = MAX_IMAGE_WIDTH * y + x;

					if (whiteSpotArea[tempAddress] == 1)
					{
						LabelImage_Virtual[tempAddress] = 7;
					}
					else if (whiteSpotArea[tempAddress] == 2)
					{
						LabelImage_Virtual[tempAddress] = 255;
					}
				}
			}
#endif

			label_Image = RotationEdgeImage;
			memset(label_Image, 0, sizeof(short) * MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

			defectGroupN = SmallSizePixelLabeling(whiteSpotArea, label_Image, startX, endX, startY, endY, MAX_IMAGE_WIDTH);

			tMax = 1;
			maxPixelDefectLabelN = -1;
			for (m = 1; m <= defectGroupN; m++)
			{
				if (labelingPxCount[m] > tMax)
				{
					tMax = labelingPxCount[m];
					maxPixelDefectLabelN = m;
				}
			}

			if (maxPixelDefectLabelN > 0)
			{
				if (labelingPxCount[maxPixelDefectLabelN] > TabletGradeData.FrontFaceEngraveWhiteSpotSize)
				{
					DefectSW = 1;
					DefectInformationWrite(DEFECT_FRONT_ENGRAVE_WHITE_SPOT, cameraIndex, LabelStX[maxPixelDefectLabelN],
										   LabelEdX[maxPixelDefectLabelN], LabelStY[maxPixelDefectLabelN], LabelEdY[maxPixelDefectLabelN], labelingPxCount[maxPixelDefectLabelN]);
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
void PrintPositionDefectCheck(int cameraIndex)
{
	int x, y;
	int startX, endX, startY, endY;
	int tempAddress;
	int printMinX, printMaxX, printMinY, printMaxY;
	int printCenterX, printCenterY;
	int positionErrorGrade;
	int DefectSize;
	int tempPrintAngle;
	int tempTabletAngle;
	int angleDiff;
	int printRotateDegree;
	int tabletRotateDegree;
	int printBrightness;
	int tempCount;
	int tabletCenterX, tabletCenterY, tempCount2;
	int GrayV;

	startX = tabletAreaInfo[AREA_INFO_ST_X_ADDRESS];
	endX = tabletAreaInfo[AREA_INFO_END_X_ADDRESS];
	startY = tabletAreaInfo[AREA_INFO_ST_Y_ADDRESS];
	endY = tabletAreaInfo[AREA_INFO_END_Y_ADDRESS];

	printMinX = MAX_IMAGE_WIDTH;
	printMaxX = 0;
	printMinY = MAX_IMAGE_HEIGHT;
	printMaxY = 0;

	tabletCenterX = tabletCenterY = tempCount2 = 0;
	printBrightness = tempCount = 0;
	for (y = startY; y < endY; y += 2)
	{
		for (x = startX; x < endX; x += 2)
		{
			tempAddress = MAX_IMAGE_WIDTH * y + x;

			if (InspectionArea[tempAddress] == PRINT_AREA)
			{
				if (printMinX >= x)
				{
					printMinX = x;
				}

				if (printMaxX <= x)
				{
					printMaxX = x;
				}

				if (printMinY >= y)
				{
					printMinY = y;
				}

				if (printMaxY <= y)
				{
					printMaxY = y;
				}

				if (realPrintMaskingArea[tempAddress])
				{
					GrayV = (ColorSourceImage[tempAddress * 3 + 0] + ColorSourceImage[tempAddress * 3 + 1] + ColorSourceImage[tempAddress * 3 + 2]) / 3;
					printBrightness += GrayV;
					tempCount++;
				}
			}

			if (InspectionArea[tempAddress])
			{
				tabletCenterX += x;
				tabletCenterY += y;
				tempCount2++;
			}
		}
	}

	if (tempCount)
	{
		printBrightness /= tempCount;
	}

	if (tempCount2)
	{
		tabletCenterX /= tempCount2;
		tabletCenterY /= tempCount2;
	}

	printCenterX = (printMinX + printMaxX) / 2;
	printCenterY = (printMinY + printMaxY) / 2;

	tempPrintAngle = PrintMatchingResult.PrintRotationAngle % 360;
	tempTabletAngle = TabletMatchingResult.TabletRotationAngle % 360;

	if (tempPrintAngle > 180)
	{
		printRotateDegree = -(360 - tempPrintAngle);
	}
	else
	{
		printRotateDegree = tempPrintAngle;
	}

	if (tempTabletAngle > 180)
	{
		tabletRotateDegree = -(360 - tempTabletAngle);
	}
	else
	{
		tabletRotateDegree = tempTabletAngle;
	}

	PrintMarkingInformation.PrintBrightness = printBrightness;
	PrintMarkingInformation.theta = tabletRotateDegree - printRotateDegree;
	PrintMarkingInformation.x = tabletCenterX - printCenterX;
	PrintMarkingInformation.y = printCenterY - tabletCenterY; // RT   ̹ Կ   ó

	if (TabletGradeData.ETC_PrintPositionDefectIntensity)
	{
		positionErrorGrade = TabletGradeData.ETC_PrintPositionDefectIntensity;

		DefectSize = abs(printCenterX - TabletMatchingResult.AdjustCenterXInImage) / 2;
		if (DefectSize > positionErrorGrade)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_PRINT_POSITION_ERROR, cameraIndex, 0, 0, 0, 0, DefectSize);
		}

		DefectSize = abs(printCenterY - TabletMatchingResult.AdjustCenterYInImage) / 2;
		if (DefectSize > positionErrorGrade)
		{
			DefectSW = 1;
			DefectInformationWrite(DEFECT_PRINT_POSITION_ERROR, cameraIndex, 0, 0, 0, 0, DefectSize);
		}
	}

	if (TabletGradeData.ETC_PrintPositionRotationDefectIntensity)
	{
		angleDiff = abs(printRotateDegree - tabletRotateDegree);

		if (angleDiff > TabletGradeData.ETC_PrintPositionRotationDefectIntensity * 2)
		{
			DefectSize = angleDiff;
			DefectSW = 1;
			DefectInformationWrite(DEFECT_PRINT_ROTATION_ERROR, cameraIndex, 0, 0, 0, 0, DefectSize);
		}
	}
}
//---------------------------------------------------------------------------
