#ifndef __cpb_module_front_h__
#define __cpb_module_front_h__

#include "cpb_module.h"

//---------------------------------------------------------------------------
void ProcessingStartForFrontFace(int processingMode, int cameraIndex, int ImageConvertOption);
void FrontFaceSetUpDataTransForm(int option, int sdNum);
void PreProcessingForFrontFace(int cameraIndex);
void CalculateShapeShellData(int cameraIndex);
void SetBrightnessAreaForPrintNeighbor(int cameraIndex);
void removeBrightDot(int cameraIndex);
void FrontFaceShapeMatchingForEachCase(int option, int cameraIndex);
void FindTortionAngleInFrontFace(int cameraIndex);
void FindRealBinaryData(int option, int cameraIndex);
void FrontShapeEdgeAreaExtension(short *RESTRICT(tempDiffRealShapeBoundaryForAngleCoordinate), int closingSize, int step);
void DefectSearchForFrontShape(int cameraIndex);
void HighResolutionDefectSearchForFrontShape(int cameraIndex);
void DefectSearchForFrontShapeForSugarCoating(int cameraIndex);
void DefectSearchForMarvelingTablet(int cameraIndex);
void DefectSearchForColorDirty(int cameraIndex);
void DefectSearchForColorDirtyForSugarCoating(int cameraIndex);
void DefectColor(int processingMode, int cameraIndex);
void DefectColorForMuliLayerTablet(int processingMode, int cameraIndex);
void DefectSearchInEdgeNeighborArea(void);
//void ColorStainCheck(int cameraIndex);
void makeFrontFaceInspectionAreaForMarvelingTablet(int cameraIndex);
void EngraveWhiteDefectCheck(int cameraIndex);
void PrintPositionDefectCheck(int cameraIndex);
//---------------------------------------------------------------------------

#endif	/* __cpb_module_front_h__ */