#ifndef _PROCESSING_H_
#define _PROCESSING_H_

#include "common.h"

#define CAPTURE_WIDTH 			640
#define CAPTURE_HEIGHT			480

#define PROCESSING_WIDTH 		640
#define PROCESSING_HEIGHT		480

#define IMAGE_3D_WIDTH 			640
#define IMAGE_3D_HEIGHT			480

#define HD_IMAGE_WIDTH      1280
#define HD_IMAGE_HEIGHT     960

#define PRINT_DATA_SIZE               20000
#define THREED_PRINT_DATA_SIZE        24000 // 16mm  ˻    ũⰡ Ŀ  ۿ µ ̶  ߻.. 15000  24000 Size (2016-05-18)
#define THREED_SLICE_PRINT_DATA_SIZE  10000
#define THREED_PRINT_MAX_LABEL_COUNT  28

#define ASYMMETRY_TABLET  3

#define PRINT_LABEL_DATA_SIZE           4000
#define PRINT_EXPAND_MASKING_DATA_SIZE  2000

#define UNCOATING     1
#define FILMCOATING   2
#define SUGARCOATING  3

#define ROUND     1
#define OBLONG    2
#define OVAL      3
#define HEXA      4
#define TRIANGLE  5
#define SQUARE    6
#define ETC       10

#define NONE      0
#define STAMP     1
#define PRINT     2

#define DARK      1
#define BRIGHT    2

#define ONE_FACE        1
#define TWO_FACE_SAME   2
#define TWO_FACE_DIFF   3

#define NONE_DIVISION_LINE      0
#define ONESIDE_DIVISION_LINE   1
#define BOTHSIDE_DIVISION_LINE  2

#define	INSPECTION_MASK_FRONT_FACE				    0x00000001
#define	INSPECTION_MASK_SIDE_FACE_M45			    0x00000010
#define	INSPECTION_MASK_SIDE_FACE_0				    0x00000100
#define	INSPECTION_MASK_SIDE_FACE_P45			    0x00001000
#define	INSPECTION_MASK_3D						        0x00010000

#define DEFECT_COLOR_R                          1
#define DEFECT_COLOR_G                          2
#define DEFECT_COLOR_B                          3
#define DEFECT_FRONT_DIRTY                      4
#define DEFECT_FRONT_STICKING                   5
#define DEFECT_FRONT_STAIN                      6
#define DEFECT_SIDE_DIRTY                       7
#define DEFECT_SIDE_STAIN                       8
#define DEFECT_FRONT_EDGE_STAIN                 9
#define DEFECT_TABLET_SIZE                      10
#define DEFECT_FRONT_COLOR_LARGE_DIRTY          11
#define DEFECT_PRINT_ERASE                      12
#define DEFECT_PRINT_SPREAD                     13
#define DEFECT_3D_BREAKING_FOR_NORMAL_AREA      14
#define DEFECT_3D_PRINT_ERASE                   15
#define DEFECT_FRONT_COLOR_DIRTY                16
#define DEFECT_UNPRINT                          17
#define DEFECT_SIDE_COLOR_DIRTY                 18
#define DEFECT_3D_BREAKING_FOR_EDGE_AREA        19
#define DEFECT_FRONT_EDGE_DIRTY                 20
#define DEFECT_SIDE_EDGE_NEIGHBOR               21
#define DEFECT_SIDE_COLOR_LARGE_DIRTY           22
#define DEFECT_2D_AND_3D_PRINT_NOT_MATCHING     23
#define DEFECT_NOT_APPLICABLE_8                 24
#define DEFECT_2D_DARK_SPOT_MARVELING           25
#define DEFECT_2D_BRIGHT_SPOT_MARVELING         26
#define DEFECT_2D_DARK_STAIN_MARVELING          27
#define DEFECT_2D_BRIGHT_STAIN_MARVELING        28
#define DEFECT_SIDE_EDGE_DARK                   29
#define DEFECT_SIDE_EDGE_BRIGHT                 30
#define DEFECT_SIDE_EDGE_NEIGHBOR_BREAK         31
#define DEFECT_FRONT_WHITE_ENGRAVE              32
#define DEFECT_FRONT_ENGRAVE_WHITE_SPOT         33

#define DEFECT_FRONT_BRIGHT_STAIN_LABEL         34
#define DEFECT_FRONT_BRIGHT_STAIN_ALL           35
#define DEFECT_PRINT_POSITION_ERROR             36
#define DEFECT_PRINT_ROTATION_ERROR             37
#define DEFECT_3D_BREAKING_FOR_EDGE_NEIGHBOR    38
#define DEFECT_3D_SUGAR_SHAPE_DEFORMATION       39
#define DEFECT_3D_PRINT_ERASE_PARTIAL           40
#define DEFECT_SIDE_EDGE_DIRTY_OPTION           41


#define UNINS_CLOSED 				      256
#define UNINS_TABLET_POSITION		  257
#define UNINS_BRIGHTNESS_DROPPED	258
#define UNINS_BRIGHTNESS_CHASE		259
#define THIN_TALBET					      260
#define FAT_TALBET					      261

#define NOT_PLATE 0
#define PLATE     1

#define THREE_D_CAMERA_ZOOM 40

#define ONECOLOR    0
#define TWOCOLOR    1
#define THREECOLOR  2

#define FRONT_FACE_FOR_COLOR  0
#define REAR_FACE_FOR_COLOR   1

#define CONSTANT_ADJUST_VALUE_BY_LASER   26

#define NOT_ARRANGE 0
#define ARRANGE     1
                     
#define GRADE_SENSITIVITY_NORMAL    0
#define GRADE_SENSITIVITY_HIGH      1

#define DISABLED_COLOR_FACTOR_CHECK   0
#define FST_FACTOR_CHECK_METHOD       1
#define SEC_FACTOR_CHECK_METHOD       2
#define TRD_FACTOR_CHECK_METHOD       3

#define TABLET_SINGLE_COLOR     0
#define TABLET_COMBINE_COLOR    1

#define SIMILAR_COLOR_STANDARD_VALUE  50

#define SRC_DOWNL_SCALE_IMAGE 0
#define SRC_FULL_SCALE_IMAGE  1

#define HALF_IMAGE_WIDTH 320
#define HALF_IMAGE_HEIGHT 240

#define HALF_MAX_IMAGE_WIDTH 320

#define MIN_OBJECT_COLOR_DIFF 10
#define MAX_OBJECT_COLOR_DIFF 20
#define CHROMATIC_TABLET_VALUE 40
#define CHROMATIC_TABLET_VALUE2 36

#define CACHE_CONTROL_DUMMY_SIZE  32 // 4 bytes (data type) * 32 = 128 = CACHE_L2_LINESIZE ... DSP L2 ĳ  ũⰡ ϸ ̰͵ ٲ .

#define MAX_PROCESSING_CORE_COUNT 8

#define SPLIT_PROCESSING_MODE_NONE  0
#define SPLIT_PROCESSING_MODE_MAIN  1
#define SPLIT_PROCESSING_MODE_SUB   2

#define MAX_IMAGE_WIDTH   640
#define MAX_IMAGE_HEIGHT  480

#define SIDE_COLORATE_SET_EACH_DISABLE	0
#define SIDE_COLORATE_SET_EACH_INABLE	1

typedef struct
{
	int IsDefectA;
	int IsDefectB;
	int TPBInsDefect;
	int ImageIndex;
	int TPBMinX1, TPBMinX2, TPBMinX3;
	int TPBMaxX1, TPBMaxX2, TPBMaxX3;
	int TPBMinY1, TPBMinY2, TPBMinY3;
	int TPBMaxY1, TPBMaxY2, TPBMaxY3;
	unsigned int EvalValue;
	short PrintIsSW;
	short PrintType;
	short ThickErrorSW;
	int Front_Rear;

	int PrintMatchingResult_PrintBrightness;
	int PrintMatchingResult_PrintTheta;
	int PrintMatchingResult_PrintX;
	int PrintMatchingResult_PrintY;
} TDefectData;

typedef struct
{
	short TabletCenterX;
	short TabletCenterY;
	short TabletCenterZ;
	short TabletRotationAngle;
	short TabletHorizonalLength;
	short TabletVerticalLength;
} TThreeDPositionInfo;

typedef struct
{
	int CamMask;
	int StudyCount;
	unsigned short ShutterSpeed[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short ShutterDelay[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short TriggerFreq[SYSTEM_SPB_CAMERA_MAX_COUNT];  // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned char SubSamplingMode[SYSTEM_SPB_CAMERA_MAX_COUNT];
	int TabletType;
	int SensorLength;
} TStudySetupData; // For SELMA200, Rev by moon.

typedef struct
{
	int CurrentCameraIndex;
} TStudyData_SPB;

typedef struct
{
	int DataCount;
	unsigned short ColorB[256];
	unsigned short ColorG[256];
	unsigned short ColorR[256];
	unsigned short PrintMatchingValue1[3000];
	unsigned short PrintMatchingValue2[3000];
	unsigned short ThreeDMaxHeight1[256];
	unsigned short ThreeDMaxHeight2[256];
	unsigned short ThreeDCenterHeight1[256];
	unsigned short ThreeDCenterHeight2[256];
	unsigned short RearColorB[256];
	unsigned short RearColorG[256];
	unsigned short RearColorR[256];

	int AccTabletEngraveMisMatchCount_Remaining;
	int AccTabletEngraveMisMatchCount_Empty;
	int AccTabletEngraveMisMatch_AddCount_Remaining;
	int AccTabletEngraveMisMatch_AddCount_Empty;

	unsigned short TabletPrintColorB[256];
	unsigned short TabletPrintColorG[256];
	unsigned short TabletPrintColorR[256];

	unsigned short TabletRearPrintColorB[256];
	unsigned short TabletRearPrintColorG[256];
	unsigned short TabletRearPrintColorR[256];
} TStudyResultData_SPB;

typedef struct
{
	int height;
	unsigned char color[3];
	char dummy;
	unsigned short print_matching_value[2];
} TStudyData_CPB;

typedef struct
{
	int CamMask;
	unsigned short ShutterSpeed[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short ShutterDelay[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short TriggerFreq[SYSTEM_SPB_CAMERA_MAX_COUNT];  // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned char SubSamplingMode[SYSTEM_SPB_CAMERA_MAX_COUNT];
	int MaxProcessingWaitingTime;
	int CurrentCameraIndex;
	int TotalTabletCount;
	int ActiveSplitProcessing;
	int CoreProcessingMode[MAX_PROCESSING_CORE_COUNT];
	int TabletType;
	int LaserStatus;
	int SensorLength;
} TInspectData; // For SELMA200, Rev by moon.

typedef struct
{
	unsigned char kind;
	unsigned char shape;
	unsigned char color;
	unsigned char discriminationDisplay_kind;
	int length;
	int width;
	int height;
	int middle_height;
	unsigned char discriminationDisplay_num;
	unsigned char print;
	unsigned char printColor;
	unsigned char printGrayLebelForTablet;
	unsigned char plateInformation;
	unsigned char dummy[3];

	int tabletColorN;
	int tabletLayerCount;
	int arrangeInfo;
	int symmetric_line_count;
	int GradImgSW;
	int SpecialTabletForHwanIn;
	int MarvelingTablet;
	int CurvedSurfaceTablet;

	int tabletDivisionLineInfo;

	int HighResolutionImage;

	int Disk1ThreeDImageCenterXForLaser;
	int Disk1ThreeDImageCenterYForLaser;
	int Disk2ThreeDImageCenterXForLaser;
	int Disk2ThreeDImageCenterYForLaser;

	int Disk1ThreeDImageLengthForLaser;
	int Disk2ThreeDImageLengthForLaser;

	int dummy2[84];
} TTabletCharacter;

typedef struct
{
	short FrontShapeEdgePoint[2000][3];
	int FrontShapeEdgePointCount;

	short FrontShapeEdgePoint2[2000][3];
	int FrontShapeEdgePointCount2;

	unsigned char FrontshapeAreaData[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];
	unsigned char FrontshapeAreaData2[HALF_IMAGE_WIDTH * HALF_IMAGE_HEIGHT];

	unsigned char OpenCloseSearchArea[640 * 480];

	short position_printData1[PRINT_DATA_SIZE][2];
	short expansion_position_printData1[PRINT_DATA_SIZE][2];
	short position_printData2[PRINT_DATA_SIZE][2];
	short expansion_position_printData2[PRINT_DATA_SIZE][2];
	int printData1Count;
	int printData2Count;
	int expansion_printData1Count;
	int expansion_printData2Count;

	int DiskBaseHeightPosition[SYSTEM_TOTAL_CAMERA_COUNT];
	int cameraZoom[SYSTEM_TOTAL_CAMERA_COUNT];
	int ImageCutStartX[SYSTEM_TOTAL_CAMERA_COUNT];
	int ImageCutEndX[SYSTEM_TOTAL_CAMERA_COUNT];
	int ImageCutStartY[SYSTEM_TOTAL_CAMERA_COUNT];
	int ImageCutEndY[SYSTEM_TOTAL_CAMERA_COUNT];

	int protoStudyColorR;
	int protoStudyColorG;
	int protoStudyColorB;

	short SimilarPrint1MaskInfo[PRINT_DATA_SIZE];
	short SimilarPrint2MaskInfo[PRINT_DATA_SIZE];

	short printLabelData[2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_LABEL_DATA_SIZE][2];
	int printLabelDataCnt[2][THREED_PRINT_MAX_LABEL_COUNT];
	int printLabelCount[2];

	int rear_protoStudyColorR;
	int rear_protoStudyColorG;
	int rear_protoStudyColorB;

	int PrintColor[2][3];

	int realPrintPixelCntCam1;
	int realPrintPixelCntCam9;

	int PrintThreshold;
	int ProtoEngraveDistinguishV_Cam1;
	int ProtoEngraveDistinguishV_Cam9;

	unsigned char ThreeDExceptEngraveData[2][2][IMAGE_3D_WIDTH * IMAGE_3D_HEIGHT];

	int SideFaceShapeExtractThreshold;

	int tabletSplitLineDataCount;
	short tabletSplitLineData[PRINT_DATA_SIZE][2];

	int ApplySimilarPrintMatchingAlgorithm;

	int Disk1ThreeDMinThreshold;
	int Disk2ThreeDMinThreshold;

	int Disk1ThreeDNormalizedValue;
	int Disk2ThreeDNormalizedValue;

	int Disk1AverageMaxHeight;
	int Disk2AverageMaxHeight;

	int ImageOffSetSW[SYSTEM_TOTAL_CAMERA_COUNT];
	unsigned char referenceImageForOffset[SYSTEM_TOTAL_CAMERA_COUNT][CAPTURE_WIDTH / 2 * CAPTURE_HEIGHT / 2];

	int TabletColorRatio[3];
	int TabletColorRange;
	int ActiveColorRatioCheck;
	int HigherColorFactor;
	int TabletColorType;

	int SideThresholdForEachCamera[SYSTEM_TOTAL_CAMERA_COUNT];

	int TabletColorRatio_Rear[3];
	int TabletColorRange_Rear;
	int HigherColorFactor_Rear;
	int TabletColorType_Rear;

	int TabletColorRangeEach[SYSTEM_TOTAL_CAMERA_COUNT]; 
  	int TabletColorRangeEachActive;
	int dummy[38];	//  int dummy[55];  

} TTabletSetupData;

typedef struct
{
	short Disk1FrontShapeEdgePoint[2000][3];
	short Disk1FrontShapeEdgePoint_Shrink[2000][2];
	short Disk1FrontShapeEdgePoint_Expansion[2000][2];
	int Disk1FrontShapeEdgePointCount;
	int Disk1FrontShapeEdgePointShrinkCount;
	int Disk1FrontShapeEdgePointExpansionCount;

	int Disk1SensitiveStickingAreaData1Count[20];
	int Disk1SensitiveStickingAreaData2Count[20];

	int Disk1SensitiveStickingAreaLabelN1;
	int Disk1SensitiveStickingAreaLabelN2;

	short Disk1position_printData1[THREED_PRINT_DATA_SIZE][2];
	short Disk1position_printData2[THREED_PRINT_DATA_SIZE][2];
	int Disk1printData1Count;
	int Disk1printData2Count;

	short Disk1position_slice_printData1[THREED_SLICE_PRINT_DATA_SIZE][2];
	short Disk1position_slice_printData2[THREED_SLICE_PRINT_DATA_SIZE][2];
	int Disk1slice_printData1Count;
	int Disk1slice_printData2Count;

	short Disk2FrontShapeEdgePoint[2000][3];
	short Disk2FrontShapeEdgePoint_Shrink[2000][2];
	short Disk2FrontShapeEdgePoint_Expansion[2000][2];
	int Disk2FrontShapeEdgePointCount;
	int Disk2FrontShapeEdgePointShrinkCount;
	int Disk2FrontShapeEdgePointExpansionCount;

	int Disk2SensitiveStickingAreaData1Count[20];
	int Disk2SensitiveStickingAreaData2Count[20];

	int Disk2SensitiveStickingAreaLabelN1;
	int Disk2SensitiveStickingAreaLabelN2;

	short Disk2position_printData1[THREED_PRINT_DATA_SIZE][2];
	short Disk2position_printData2[THREED_PRINT_DATA_SIZE][2];
	int Disk2printData1Count;
	int Disk2printData2Count;

	short Disk2position_slice_printData1[THREED_SLICE_PRINT_DATA_SIZE][2];
	short Disk2position_slice_printData2[THREED_SLICE_PRINT_DATA_SIZE][2];
	int Disk2slice_printData1Count;
	int Disk2slice_printData2Count;

	short printLabelData[2][2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_LABEL_DATA_SIZE][2]; // DISK, FORNT/Front_reverse/REAR/Rear_reverse/ LABEL N, x/y; // 640,000 Byte
	int printLabelDataCnt[2][2][THREED_PRINT_MAX_LABEL_COUNT];
	int printLabelCount[2][2];

	short printLabelDataForExpandMasking[2][2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_EXPAND_MASKING_DATA_SIZE][2]; // DISK, FORNT/Front_reverse/REAR/Rear_reverse/ LABEL N, x/y; // 320,000 Byte
	int printLabelDataCntForExpandMasking[2][2][THREED_PRINT_MAX_LABEL_COUNT];

	int disk1EdgeHeightDiff[30];
	int disk2EdgeHeightDiff[30];

	int disk1OneSideEdgeHeightDiff[30];
	int disk1OtherSideEdgeHeightDiff[30];
	int disk2OneSideEdgeHeightDiff[30];
	int disk2OtherSideEdgeHeightDiff[30];

	short printMaskData[2][2][THREED_PRINT_MAX_LABEL_COUNT][PRINT_LABEL_DATA_SIZE];

	int PrintAverageDepth[2][2];
	int dummy[9816];
} TTablet3DSetupData;

typedef struct
{
	int tabletColorR_ForCamera1;
	int tabletColorG_ForCamera1;
	int tabletColorB_ForCamera1;
	int tabletColorR_ForCamera9;
	int tabletColorG_ForCamera9;
	int tabletColorB_ForCamera9;
	int Print1_IsOrNotThreshold_ForCamera1;
	int Print2_IsOrNotThreshold_ForCamera1;
	int Print1_IsOrNotThreshold_ForCamera5;
	int Print2_IsOrNotThreshold_ForCamera5;
	int Print1_IsOrNotThreshold_ForCamera9;
	int Print2_IsOrNotThreshold_ForCamera9;
	int Print1_IsOrNotThreshold_ForCamera13;
	int Print2_IsOrNotThreshold_ForCamera13;
	int middleHeight;

	int goodProductRatio_ForFrontStainDefect[3][20];
	int goodProductRatio_ForFrontDirtyDefect[3][20];
	int goodProductRatio_ForFrontSpecicalStickingDefect[3][20];
	int goodProductRatio_ForFrontEdgeBreakingDefect[3][20];
	int goodProductRatio_ForFrontEdgeDirtyDefect[3][20];

	int height1;
	int height2;

	int tabletRearColorR_ForCamera1;
	int tabletRearColorG_ForCamera1;
	int tabletRearColorB_ForCamera1;
	int tabletRearColorR_ForCamera9;
	int tabletRearColorG_ForCamera9;
	int tabletRearColorB_ForCamera9;
	int selectedFace;
	int tabletMaxThickForFirstDisk;
	int tabletMaxThickForSecondDisk;

	int TabletEngraveMisMatchCount_Remaining_CAM1;
	int TabletEngraveMisMatchCount_Remaining_CAM9;
	int TabletEngraveMisMatchCount_Empty_CAM1;
	int TabletEngraveMisMatchCount_Empty_CAM9;

	int SideFaceTabletRColor[SYSTEM_TOTAL_CAMERA_COUNT];
	int SideFaceTabletGColor[SYSTEM_TOTAL_CAMERA_COUNT];
	int SideFaceTabletBColor[SYSTEM_TOTAL_CAMERA_COUNT];

	int tabletEngraveColorForCamera1[3];
	int tabletEngraveColorForCamera9[3];
	int tabletRearEngraveColorForCamera1[3];
	int tabletRearEngraveColorForCamera9[3];

	int tabletCenterThickForFirstDisk;
	int tabletCenterThickForSecondDisk;

	int dummy[24];
} TTabletStudyData;

typedef struct
{
	int tabletColorR_ForCamera1;
	int tabletColorG_ForCamera1;
	int tabletColorB_ForCamera1;
	int tabletColorR_ForCamera9;
	int tabletColorG_ForCamera9;
	int tabletColorB_ForCamera9;
	int Print1_IsOrNotThreshold_ForCamera1;
	int Print2_IsOrNotThreshold_ForCamera1;
	int Print1_IsOrNotThreshold_ForCamera5;
	int Print2_IsOrNotThreshold_ForCamera5;
	int Print1_IsOrNotThreshold_ForCamera9;
	int Print2_IsOrNotThreshold_ForCamera9;
	int Print1_IsOrNotThreshold_ForCamera13;
	int Print2_IsOrNotThreshold_ForCamera13;
	int middleHeight;
	int goodProductRatio_ForFrontStainDefect[3][20];
	int goodProductRatio_ForFrontDirtyDefect[3][20];
	int goodProductRatio_ForFrontSpecicalStickingDefect[3][20];
	int goodProductRatio_ForFrontEdgeBreakingDefect[3][20];
	int goodProductRatio_ForFrontEdgeDirtyDefect[3][20];

	int height1;
	int height2;
	int tabletRearColorR_ForCamera1;
	int tabletRearColorG_ForCamera1;
	int tabletRearColorB_ForCamera1;
	int tabletRearColorR_ForCamera9;
	int tabletRearColorG_ForCamera9;
	int tabletRearColorB_ForCamera9;
	int selectedFace;
	int tabletMaxThickForFirstDisk;
	int tabletMaxThickForSecondDisk;

	int TabletEngraveMisMatchCount_Remaining_CAM1;
	int TabletEngraveMisMatchCount_Remaining_CAM9;
	int TabletEngraveMisMatchCount_Empty_CAM1;
	int TabletEngraveMisMatchCount_Empty_CAM9;

	int SideFaceTabletRColor[SYSTEM_TOTAL_CAMERA_COUNT];
	int SideFaceTabletGColor[SYSTEM_TOTAL_CAMERA_COUNT];
	int SideFaceTabletBColor[SYSTEM_TOTAL_CAMERA_COUNT];

	int tabletEngraveColorForCamera1[3];
	int tabletEngraveColorForCamera9[3];
	int tabletRearEngraveColorForCamera1[3];
	int tabletRearEngraveColorForCamera9[3];

	int tabletCenterThickForFirstDisk;
	int tabletCenterThickForSecondDisk;

	int dummy[24];
} TTabletStudyResultData; // For SELMA200, Rev by moon.

typedef struct
{
	////Front//////////
	int option_front_edgeBreaking_Intensity_Type1; // option
	int front_stain_Intensity;
	int front_stain_Size;
	int front_edge_Intensity;
	int front_edge_Size;
	int front_edge_dirty_Intensity;
	int front_edge_dirty_Size;
	int front_dirty_Intensity;
	int front_dirty_Size;
	int front_color_Intensity;
	int frontShapeEdgeNeighborRange;
	int frontBorderIsSW;
	int frontSmallSizeGrade;
	////option//////////
	int option_Breaking_Intensity;	// option
	int option_PrintMark_Intensity; // option
	int option_Breaking_Size;
	////Side//////////
	int side_stain_Intensity;
	int side_stain_Size;
	int side_dirty_Intensity;
	int side_dirty_Size;
	int side_Edge_Top_Neighbor_Intensity;
	int side_Edge_Bottom_Neighbor_Intensity;
	int sideShapeEdgeMaskRange;

	////////////////
	int FrontEdgeAreaExtendSW;
	///////////////////

	int frontShaepEdgeSaturationEraseSW;
	int front_print_dirty_Inetensity;
	int option_front_edgeBreaking_Size_Type1; // option
	int front_print_erase_Intensity;
	int front_print_spread_Intensity;

	int front_Color_Dirty_Intensity;
	int front_Color_Dirty_Size;
	//////////////////////////////////////////////////////
	int front_unInspectionIntensity_ForPrint;
	int front_unInspectionIntensity_ForEdge;
	int front_unInspectionIntensity_ForOptionPrint;
	int front_unInspectionIntensity_ForOptionEdge;

	int rear_stain_Intensity;
	int rear_stain_Size;
	int rear_edge_Intensity;
	int rear_edge_Size;
	int rear_edge_dirty_Intensity;
	int rear_edge_dirty_Size;
	int rear_dirty_Intensity;
	int rear_dirty_Size;
	int rear_print_dirty_Inetensity;
	int rear_Color_Dirty_Intensity;
	int rear_Color_Dirty_Size;

	int side_height_Intensity;
	int side_Color_Dirty_Intensity;
	int side_Color_Dirty_Size;
	int threeDEdgeAreaExtend;
	int threeD_Height_Plus_Limit;
	int threeD_Height_Minus_Limit;
	int Saturation_Erase_SW;
	int EngraveDistinguishGrade;
	int EngraveDistinguishGradeFor3D;

	int Side_Edge_Neighbor_Intensity;
	int Side_Edge_Neighbor_Defect_Size;

	int EngraveMatchingOrNotValue;
	int EngravePositionDefectCheckSW;

	int DirtyGradeSensitivity;

	int SideFaceEdgeAreaSize;
	int SideFaceEdgeUnInsAreaSize;

	int ETC_ApplyColorDirtyIgnoreAlgorithm;
	int ETC_InterestedColor;
	int ETC_ColorDirtyIgnoreLevel;
	int ETC_AdjustPrintAreaSW;
	int ETC_ColorDirtySize;
	int ETC_ThreeDCenterSize;

	int oldGradeDummy1;

	int ETC_FrontFaceEdgeInspectionSW;

	int oldGradeDummy2;

	int ETC_Partial3DPrintCheckSW;

	//  int oldGradeDummy3[9];
	int LaserAllowX;
	int LaserAllowY;
	int LaserAllowDegree;	
	int SideRemovalAlgorithm3DPassing;
	int oldGradeDummy3[2];
	int DefectSearchForColorDirtyOption;
	float DefectSearchForColorDirtyOptOffset;
	int SideCamMathingOption;

	int ETC_RemoveBrightDotSW;

	int oldGradeDummy4;

	int ETC_ApplyTiltTabletAlgorithm;
	int ETC_SideFaceMultiTabletUnInspectionSize;

	int oldGradeDummy5[9];

	// 20180102 ADD
	int DarkSpotDefectIntensityGradeForMarvelingTablet;
	int DarkSpotDefectSizeGradeForMarvelingTablet;
	int BrightSpotDefectIntensityGradeForMarvelingTablet;
	int BrightSpotDefectSizeGradeForMarvelingTablet;

	int DarkStainDefectIntensityGradeForMarvelingTablet;
	int DarkStainDefectSizeGradeForMarvelingTablet;
	int BrightStainDefectIntensityGradeForMarvelingTablet;
	int BrightStainDefectSizeGradeForMarvelingTablet;

	// 20180119 ADD
	int DirtyDefectCheckSWInNeighborPrint;

	// 20180307 ADD
	int ETC_ApplyWhiteEngraveAlgorithm; //   ̴   ˰.

	int Side_Edge_Dark_Intensity;
	int Side_Edge_Dark_Defect_Size;
	int Side_Edge_Bright_Intensity;
	int Side_Edge_Bright_Defect_Size;

	int ETC_AdjustUnalignedTabletAlgorithm;

	int Side_Edge_Neighbor_Break_Intensity;
	int Side_Edge_Neighbor_Break_Size;
	int Side_Edge_Neighbor_Min_Break_Depth_Size;

	int ETC_Side_None_Horizontality_Tablet;
	int ETC_Side_Split_Line_UnInspection_Area_Setting;

	int ETC_EngraveWhiteDefectCheckAlgorithm;

	int FrontFaceEngraveColorGrade;
	int FrontFaceEngraveWhiteSpotIntensity;
	int FrontFaceEngraveWhiteSpotSize;

	int ETC_EnforcementStainDefectCheckAlgorithm;

	int EnforcementStainDefectInspectionAreaSize;
	int EnforcementStainDefectThreshold;
	int EnforcementStainDefectMaxLabelSize;
	int EnforcementStainDefectAllGroupSize;

	int SplitLineMatchingSWForPrintTablet;
	int SplitLineMatchingThreshold;

	int ETC_EngraveMatchingOption_ReflectedTabletShape;
	int ETC_EngraveMatchingOption_LightEngrave;

	int ETC_ThreeD_DiffShapeTabletSW;

	int ETC_PrintPositionDefectIntensity;
	int ETC_PrintPositionRotationDefectIntensity;

	int option_front_edgeBreaking_Intensity_Type2;
	int option_front_edgeBreaking_Size_Type2;

	int CoatedTablet_SideInspectionAreaSize;

	int ETC_CoatedTablet_ShapeCheck;

	int ThreeD_CoatedTablet_ShapeError_Height;
	int ThreeD_CoatedTablet_ShapeError_Size;

	int front_print_dirty_Inetensity2;

	int ETC_PartialThreeDStampDefectIntensity;
	int ETC_PartialThreeDStampDefectSize;

	int ETC_ActiveSideEdgeDefectCheck;
	int ETC_SideEdgeDefectIntensity;
	int ETC_SideEdgeDefectSize;

	int ETC_TabletFrontFaceThreshold;

	int Side_Edge_Color_NoneInspection_Option;

	int side_Edge_Color_Dirty_Intensity;
	int side_Edge_Color_Dirty_Size;

	int LIMA_ThreeD_Side_EraseLevel;
	int LIMA_ThreeD_MaxHeight;
	int LIMA_ThreeD_OverHeightSize;
   	int BeltPowderSensitivity;
        int RemoveBeltActive;

    int EngravePrintMatching2DInActive;
    //int StainInsUpgrade; //뷮 ڸ..
	int dummy[1];
} TTabletGradeData;	
// TabletGradeData ü   ũ Ͽ ü   ũ⿡   dummy Ѵ
// ü ũⰡ ٸ 쿡   ߻(ӵ   ߻Ͽ Rev 6551 )

typedef struct
{
	int defectSeries;
	int cameraIndex;
	int defectPositionStartX;
	int defectPositionEndX;
	int defectPositionStartY;
	int defectPositionEndY;
	int size;
	int dummy[10];
} TDefectInformation;

typedef struct
{
	int TabletNumber;
	int GlobalCameraIndex;
	TDefectInformation CPBDefectInfo;
} TDefectData_SPB;

typedef struct
{
	int TabletNumber;
	int GlobalCameraIndex;
	int CameraInspectPosition;
	int dummy[4];
	TDefectInformation CPBDefectInfo;
} TDefectData_PC;

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
