#include "SPB_Module_Main.h"
#include "data_indicator.h"

#include "common.h"
#include "SPB_Processing.h"
#ifdef PC_SIM
#include <stdlib.h>
#include "virtual_spb_system.h"
//    #include "virtual_data_transfer.h"
#else
#include "system_setup.h"
#include "nfa_camera.h"
#include "system_control.h"
#include "environment.h"
#include "spb_system.h"
#include "timer.h"
#endif

int VirtualInspectionSWFromHCB = 0;
int VirtualDataLoadChk = 0;
int VirtualInspectionSW = 0;
unsigned int VirtualTriggerTime = 0;
int VirtualInspectionCount = 0;
int VirtualProcessedDataCount = 0;
TVirtualCPBProcessedData VirtualCPBProcessedData[800];
TVirtualCPBProcessedData tempVirtualCPBProcessedData;
int	VirtualCPBProcessingIndex[SYSTEM_CPB_COUNT];
TVirtualCPBStatus VirtualCPBStatus[SYSTEM_CPB_COUNT];
int VirtualTabletNumberSensor1;
int VirtualTabletNumberSensor2;
TVirtualSPBProcessedData VirtualSPBProcessedData[SPB_TABLET_LIST_COUNT + 1];
int VirtualDataRenewalSW;

TCPBVirtualInspectionData CPBVirtualInspectionData;
TCPBVirtualInspectionData CPBVirtualInspectionDataForRenewal;

#pragma	DATA_SECTION(VirtualSPBProcessedData, ".sdram")
#pragma	DATA_SECTION(VirtualCPBProcessedData, ".sdram")
#pragma	DATA_SECTION(tempVirtualCPBProcessedData, ".sdram")
#pragma	DATA_SECTION(VirtualCPBStatus, ".sdram")
#pragma	DATA_SECTION(VirtualCPBProcessingIndex, ".sdram")

#pragma DATA_ALIGN(SPBProcessingSetupInfo, 8);
TSPBProcessingSetupInfo SPBProcessingSetupInfo;

#define COM_END_WAITING_TIME		250


//---------------------------------------------------------------------------
void SPB_Module_Init(void)
{
#ifdef PC_SIM
#endif
	VirtualDataLoadChk = 0;
	VirtualInspectionSW = 0;
	VirtualDataRenewalSW = 0;
	SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_NONE;
	SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_NONE;
	SPB_Processing_Init();
}
//---------------------------------------------------------------------------
void SPB_Processing_Exit(void)
{
#ifdef PC_SIM
#endif
}
//---------------------------------------------------------------------------
void SPB_Processing_Main(void)
{
	int cpbIndex, camIndex, dataIndex;
	int currentTime;

#ifdef TARGET_SPB
	if (VirtualInspectionSW)// && VirtualDataLoadChk == 0)
	{
		/*
		if(Board1MSTmr - VirtualTriggerTime >= CPBVirtualInspectionData.Period)
		{
		VirtualIntCapture(CPBVirtualInspectionData.EnabledSPB);
		}
		*/

		Virtual_Inspection(CPBVirtualInspectionData.CameraMask);
	}
#endif

	if (SPBProcessingSetupInfo.SetupKind != PROCESSING_SETUP_KIND_NONE)
	{
		if (SPBProcessingSetupInfo.SetupKind == PROCESSING_SETUP_KIND_STUDY)
		{
			if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_READY)
			{
				ClearCPBDownState();
				SPBProcessingSetupInfo.WaitingStartTime = Board1MSTmr;
				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_WAITING;
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_WAITING)
			{
				if (Board1MSTmr - SPBProcessingSetupInfo.WaitingStartTime > COM_END_WAITING_TIME)
				{
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_INIT;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_INIT)
			{
				SPBProcessingSetupInfo.AvailCPBCount = 0;
				for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
				{
					if (IsAvailableCPB(cpbIndex))
					{
						SPBProcessingSetupInfo.AvailCPBCount++;
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_READY;
					}
					else
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_INVALID;
					}
				}
				SPBProcessingSetupInfo.SetupCPBCount = 0;
				SPBProcessingSetupInfo.FailCPBCount = 0;
				SPBProcessingSetupInfo.CurrentCPBIndex = 0;
				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_SETUP;
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_SETUP)
			{
				cpbIndex = SPBProcessingSetupInfo.CurrentCPBIndex;
				if (SPBProcessingSetupInfo.CPBStep[cpbIndex] == PROCESSING_SETUP_CPB_STEP_READY)
				{
					if (!Request_SendData(IND_CHARACTER_DATA, &TabletCharacter_SPB, sizeof(TTabletCharacter), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto study_setup_fail;
					}

					if (!Request_SendData(IND_WHITE_BALANCE_DATA, WhiteBalanceInfo_SPB, sizeof(TWhiteBalanceInfo) * SYSTEM_TOTAL_CAMERA_COUNT, cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto study_setup_fail;
					}

					if (!Request_SendData(IND_SETUP_DATA_3D, &Tablet3DSetupData_SPB, sizeof(TTablet3DSetupData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto study_setup_fail;
					}

					if (!Request_SendData(IND_SETUP_DATA, &TabletSetupData_SPB, sizeof(TTabletSetupData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto study_setup_fail;
					}
					SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_COMPLETE;
					SPBProcessingSetupInfo.SetupCPBCount++;
				}
			study_setup_fail:
				SPBProcessingSetupInfo.CurrentCPBIndex++;
				if (SPBProcessingSetupInfo.CurrentCPBIndex >= SYSTEM_CPB_COUNT)
				{
					for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
					{
						if (SPBProcessingSetupInfo.CPBStep[cpbIndex] == PROCESSING_SETUP_CPB_STEP_FAIL)
						{
							CPBStatus[cpbIndex].IsDown = 1;
							ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL, ERROR_CODE_CPB_BOARD_DOWN, __LINE__, 0, cpbIndex);
						}
					}
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_CLEAR;
				}
				else
				{
					SPBProcessingSetupInfo.WaitingStartTime = Board1MSTmr;
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_COM_WAITING;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_COM_WAITING)
			{
				if (Board1MSTmr - SPBProcessingSetupInfo.WaitingStartTime > COM_END_WAITING_TIME)
				{
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_SETUP;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_CLEAR)
			{
				// init result data
				for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; camIndex++)
				{
					StudyResultData_SPB[camIndex].DataCount = 0;
					for (dataIndex = 0; dataIndex < 256; dataIndex++)
					{
						StudyResultData_SPB[camIndex].ThreeDMaxHeight1[dataIndex] = 0;
						StudyResultData_SPB[camIndex].ThreeDMaxHeight2[dataIndex] = 0;
						StudyResultData_SPB[camIndex].ThreeDCenterHeight1[dataIndex] = 0;
						StudyResultData_SPB[camIndex].ThreeDCenterHeight2[dataIndex] = 0;
					}
					for (dataIndex = 0; dataIndex < 256; dataIndex++)
					{
						StudyResultData_SPB[camIndex].ColorB[dataIndex] = 0;
						StudyResultData_SPB[camIndex].ColorG[dataIndex] = 0;
						StudyResultData_SPB[camIndex].ColorR[dataIndex] = 0;
					}
					for (dataIndex = 0; dataIndex < 3000; dataIndex++)
					{
						StudyResultData_SPB[camIndex].PrintMatchingValue1[dataIndex] = 0;
						StudyResultData_SPB[camIndex].PrintMatchingValue2[dataIndex] = 0;
					}
				}

				InitCPBStep();
				ClearCPBStatus();
				ClearInspectImage();
				//SPB_Inspection_Clear();
				ProcessingData.ProcessingMode = PROCESSING_MODE_STUDY;

				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_COMPLETE;
				SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_NONE;
			}
		}
		else if (SPBProcessingSetupInfo.SetupKind == PROCESSING_SETUP_KIND_INSPECTION)
		{
			if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_READY)
			{
				ClearCPBDownState();
				InitProcessingResultData();
				SPBProcessingSetupInfo.WaitingStartTime = Board1MSTmr;
				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_WAITING;
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_WAITING)
			{
				if (Board1MSTmr - SPBProcessingSetupInfo.WaitingStartTime > COM_END_WAITING_TIME)
				{
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_INIT;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_INIT)
			{
				SPBProcessingSetupInfo.AvailCPBCount = 0;
				for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
				{
					if (IsAvailableCPB(cpbIndex))
					{
						SPBProcessingSetupInfo.AvailCPBCount++;
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_READY;
					}
					else
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_INVALID;
					}
				}
				SPBProcessingSetupInfo.SetupCPBCount = 0;
				SPBProcessingSetupInfo.FailCPBCount = 0;
				SPBProcessingSetupInfo.CurrentCPBIndex = 0;
				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_SETUP;
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_SETUP)
			{
				cpbIndex = SPBProcessingSetupInfo.CurrentCPBIndex;
				if (SPBProcessingSetupInfo.CPBStep[cpbIndex] == PROCESSING_SETUP_CPB_STEP_READY)
				{
					if (!Request_SendData(IND_CHARACTER_DATA, &TabletCharacter_SPB, sizeof(TTabletCharacter), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto insp_setup_fail;
					}
					if (!Request_SendData(IND_STUDY_DATA, &TabletStudyResultData_SPB, sizeof(TTabletStudyResultData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto insp_setup_fail;
					}
					if (!Request_SendData(IND_GRADE_DATA, &TabletGradeData_SPB, sizeof(TTabletGradeData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto insp_setup_fail;
					}

					if (!Request_SendData(IND_WHITE_BALANCE_DATA, WhiteBalanceInfo_SPB, sizeof(TWhiteBalanceInfo) * SYSTEM_TOTAL_CAMERA_COUNT, cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto insp_setup_fail;
					}
					if (!Request_SendData(IND_SETUP_DATA_3D, &Tablet3DSetupData_SPB, sizeof(TTablet3DSetupData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto insp_setup_fail;
					}
					if (!Request_SendData(IND_SETUP_DATA, &TabletSetupData_SPB, sizeof(TTabletSetupData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto insp_setup_fail;
					}
					SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_COMPLETE;
					SPBProcessingSetupInfo.SetupCPBCount++;
				}
			insp_setup_fail:

				SPBProcessingSetupInfo.CurrentCPBIndex++;
				if (SPBProcessingSetupInfo.CurrentCPBIndex >= SYSTEM_CPB_COUNT)
				{
					for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
					{
						if (SPBProcessingSetupInfo.CPBStep[cpbIndex] == PROCESSING_SETUP_CPB_STEP_FAIL)
						{
							CPBStatus[cpbIndex].IsDown = 1;
							ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL, ERROR_CODE_CPB_BOARD_DOWN, __LINE__, 0, cpbIndex);
						}
					}
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_CLEAR;
				}
				else
				{
					SPBProcessingSetupInfo.WaitingStartTime = Board1MSTmr;
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_COM_WAITING;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_COM_WAITING)
			{
				if (Board1MSTmr - SPBProcessingSetupInfo.WaitingStartTime > COM_END_WAITING_TIME)
				{
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_SETUP;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_CLEAR)
			{
				InitCPBStep();
				ClearCPBStatus();
				ClearInspectImage();
				//SPB_Inspection_Clear();
				ProcessingData.ProcessingMode = PROCESSING_MODE_INSPECTION;

				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_COMPLETE;
				SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_NONE;
			}
		}
		else if (SPBProcessingSetupInfo.SetupKind == PROCESSING_SETUP_KIND_GRADE_CHANGE)
		{
			if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_READY)
			{
				SPBProcessingSetupInfo.WaitingStartTime = Board1MSTmr;
				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_WAITING;
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_WAITING)
			{
				if (Board1MSTmr - SPBProcessingSetupInfo.WaitingStartTime > COM_END_WAITING_TIME)
				{
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_INIT;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_INIT)
			{
				SPBProcessingSetupInfo.AvailCPBCount = 0;
				for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
				{
					if (IsAvailableCPB(cpbIndex))
					{
						SPBProcessingSetupInfo.AvailCPBCount++;
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_READY;
					}
					else
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_INVALID;
					}
				}
				SPBProcessingSetupInfo.SetupCPBCount = 0;
				SPBProcessingSetupInfo.FailCPBCount = 0;
				SPBProcessingSetupInfo.CurrentCPBIndex = 0;
				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_SETUP;
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_SETUP)
			{
				cpbIndex = SPBProcessingSetupInfo.CurrentCPBIndex;
				if (SPBProcessingSetupInfo.CPBStep[cpbIndex] == PROCESSING_SETUP_CPB_STEP_READY)
				{
					if (!Request_SendData(IND_GRADE_DATA, &TabletGradeData_SPB, sizeof(TTabletGradeData), cpbIndex, 0))
					{
						SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_FAIL;
						SPBProcessingSetupInfo.FailCPBCount++;
						goto grade_change_setup_fail;
					}
					SPBProcessingSetupInfo.CPBStep[cpbIndex] = PROCESSING_SETUP_CPB_STEP_COMPLETE;
					SPBProcessingSetupInfo.SetupCPBCount++;
				}
			grade_change_setup_fail:

				SPBProcessingSetupInfo.CurrentCPBIndex++;
				if (SPBProcessingSetupInfo.CurrentCPBIndex >= SYSTEM_CPB_COUNT)
				{
					for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
					{
						if (SPBProcessingSetupInfo.CPBStep[cpbIndex] == PROCESSING_SETUP_CPB_STEP_FAIL)
						{
							CPBStatus[cpbIndex].IsDown = 1;
							ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL, ERROR_CODE_CPB_BOARD_DOWN, __LINE__, 0, cpbIndex);
						}
					}
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_CLEAR;
				}
				else
				{
					//SPBProcessingSetupInfo.WaitingStartTime = Board1MSTmr;
					//SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_COM_WAITING;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_COM_WAITING)
			{
				if (Board1MSTmr - SPBProcessingSetupInfo.WaitingStartTime > COM_END_WAITING_TIME)
				{
					SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_SETUP;
				}
			}
			else if (SPBProcessingSetupInfo.SetupStep == PROCESSING_SETUP_STEP_CLEAR)
			{
				InitCPBStep();
				ClearCPBStatus();
				ClearInspectImage();

				SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_COMPLETE;
				SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_NONE;
			}
		}
		else
		{
			SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_NONE;
		}
	}
	else
	{
		if (!VirtualInspectionSW)
			SPB_Processing_Loop();
	}
}

void MakeCPBSetupData()
{
	int cpbIndex, spbIndex;
	TCPBSystemSetupData cpbSystemSetupData;
	int camIndex;
	int globalCameraIndex;
	int inspectionType;
	int sdNum;

	inspectionType = 0;
	for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
	{
		globalCameraIndex = SystemSetupData.GlobalCameraIndex[camIndex];

		if(SystemSetupData.CamMask & ((0x01) << camIndex))
		{
			if (SystemSetupData.CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_FRONT_FACE)
			{
				if ((inspectionType & INSPECTION_MASK_FRONT_FACE) == 0)
				{
					inspectionType |= INSPECTION_MASK_FRONT_FACE;
				}
			}
			else if (SystemSetupData.CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_SIDE_FACE_M45)
			{
				if ((inspectionType & INSPECTION_MASK_SIDE_FACE_M45) == 0)
				{
					inspectionType |= INSPECTION_MASK_SIDE_FACE_M45;
				}
			}
			else if (SystemSetupData.CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_SIDE_FACE_0)
			{
				if ((inspectionType & INSPECTION_MASK_SIDE_FACE_0) == 0)
				{
					inspectionType |= INSPECTION_MASK_SIDE_FACE_0;
				}
			}
			else if (SystemSetupData.CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_SIDE_FACE_P45)
			{
				if ((inspectionType & INSPECTION_MASK_SIDE_FACE_P45) == 0)
				{
					inspectionType |= INSPECTION_MASK_SIDE_FACE_P45;
				}
			}
			else if (SystemSetupData.CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
			{
				if ((inspectionType & INSPECTION_MASK_3D) == 0)
				{
					inspectionType |= INSPECTION_MASK_3D;
				}
			}
		}
	}

	sdNum = SUCTION_DISK_NONE;
	for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
	{
		globalCameraIndex = SystemSetupData.GlobalCameraIndex[camIndex];

		if(SystemSetupData.CamMask & ((0x01) << camIndex))
		{
			if(globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX - 1 || globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX - 1)
			{
				sdNum = SUCTION_DISK_NUM1;
	      		break;
			}
			else if(globalCameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX - 1 || globalCameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX - 1)
			{
				sdNum = SUCTION_DISK_NUM2;
	      		break;		
			}
		}
	}

	for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
	{
		if (!CPBStatus[cpbIndex].IsDown)
		{
			// For SELMA200, 20180222, Rev by moon
			// CPB  Ϻ 
			// CameraInspectPosition -> bCameraConnection
			// CPB Core Initial θ Ȯϴ 
			// Core ī޶  ǵ Ͽ   θ Ȯϵ 

			// GlobalCameraIndex -> SuctionDiskNumber
			// CPB Core Initial θ Ȯ  ˻ ˰ 뿡 ݿϴ 
			// CPB  Initial Ҷ 3D ī޶ SD1, SD2  ʱⰪ ٸ

			if (SystemSetupData.CPBEnabled[cpbIndex])
				cpbSystemSetupData.bCameraConnection = CAMERA_CONNECTION;
			else
				cpbSystemSetupData.bCameraConnection = CAMERA_DISCONNECTION;

			cpbSystemSetupData.SuctionDiskNumber = sdNum;
			cpbSystemSetupData.SDRSizeType = SystemSetupData.CPBSDRSizeType[cpbIndex];
			cpbSystemSetupData.InspectionType = inspectionType;

			for (spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
			{
				if (BoardID == BOARD_ID_SPB(spbIndex + 1))
				{
					cpbSystemSetupData.spbBoardID = spbIndex;
					break;
				}
			}
			if (SystemSetupData.CPBEnabled[cpbIndex])
			{
				if (!Request_SendData(IND_SYS_SETUP, &cpbSystemSetupData, sizeof(TCPBSystemSetupData), cpbIndex, 0))
				{
					CPBStatus[cpbIndex].IsDown = TRUE;
					CPBStatus[cpbIndex].Status = CPB_STATUS_DISABLED;
					ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL, ERROR_CODE_CPB_BOARD_DOWN, __LINE__, 0, cpbIndex);
				}
			}
		}
	}
}

//---------------------------------------------------------------------------
void SPB_Study_Setup_Start(void)
{
	MakeCPBSetupData();
	SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_READY;
	SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_STUDY;
}
//---------------------------------------------------------------------------
void SPB_Inspection_Setup_Start(void)
{
	MakeCPBSetupData();
	SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_READY;
	SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_INSPECTION;
}
//---------------------------------------------------------------------------
void SPB_Grade_Change_Start(void)
{
	SPBProcessingSetupInfo.SetupStep = PROCESSING_SETUP_STEP_READY;
	SPBProcessingSetupInfo.SetupKind = PROCESSING_SETUP_KIND_GRADE_CHANGE;
}
//---------------------------------------------------------------------------
int Virtual_SPB_GET_ProcessingData(void)
{
	int i;
	for (i = 0; i < SPB_TABLET_LIST_COUNT; i++)
	{
		if (VirtualSPBProcessedData[i].ProcessingDataSetSW)
		{
			return i;
		}
	}

	return -1;
}
//---------------------------------------------------------------------------
