#ifndef __SideFaceShapeMatching_h__
#define __SideFaceShapeMatching_h__

#include "Processing.h"
#include "cpb_module.h"

#define MAX_EXPECTED_BOTTOM_LINE_COUNT  100
#define MAX_VALID_TABLET_LAYER_COUNT  3

typedef struct
{
  unsigned short tabletLayerBoundaryPositionInfo[520 * 2];
  int tabletLayerBoundaryPositionInfoCount;
  int labelN;
}
TTabletMultiLayerBoundaryInfo;

void SideFaceShapeMatchingForEachCase(int option, int cameraIndex);
void SideFaceShapeMatchingForSugarCoating(int cameraIndex);
void SideFaceShapeMatchingForETC(int cameraIndex);
void tabletShapeInfoModeling(short *RESTRICT(shapeData), int stPoint, int endPoint, int shapeMinX, int shapeMinY, unsigned char *RESTRICT(dstImage));
int SideFaceEdgeAreaSetting(int stX, int stY, int endX, int endY);
int LineInspectionAreaSetting(int stX, int stY, int endX, int endY, int m, int cameraIndex);
void MaskingForLeftEdgeLine(int stX, int stY, int endX, int endY, int cameraIndex, int areaValue, int makeBoundary, int maskArea);
void MaskingForRightEdgeLine(int stX, int stY, int endX, int endY, int cameraIndex, int areaValue, int makeBoundary, int maskArea);
void makeSideTiltCameraInspectionArea(int stX, int stY, int endX, int endY, int areaValue);

#endif	/* __cpb_module_h__ */


