//---------------------------------------------------------------------------
// ̹ μ DSP ƴ ũ̼  PC(HEDT) óѴٸ OpenCV ̺귯 ״ ϴ  ϳ
// ϴ DSP ϰ ȣȯ ϱ Ͽ OpenCV ߿ ʿ ͸  ⿡  Ѵ.
//---------------------------------------------------------------------------

#include "open_cv.h"

#include <algorithm>

//---------------------------------------------------------------------------
// ϴ ׶ ˰(Grahams scan) ̿Ͽ ConvexHull ϴ ̴.
// :
// 1.  CVPointInitSource() ȣش.
// 2.  ܰ ̷ 鿡 Ͽ CVPointAddSource(x, y) ȣش (ȣ  .  ԵǾ )
// 3. CVPointConvexHull() ȣѴ. ׷ CVPointStack CVPointStackTop ܰ .
// 4.    鼭 ܰ鿡   ִ.
//    for (int i = 0; i < CVPointStackTop; i++)
//    {
//      int x = CVPointSources[CVPointStack[i]].x;
//      int y = CVPointSources[CVPointStack[i]].y;
//    }
//
// :
// CVPointStack ִ  ð(?)  ִ.    ֱ  ٸ ˰  ſ ϴ.
// ̰͵     ó ϸ   ϰ       ִ.
// ̷  籸 Contour ϸ  ȣ踦 ̿Ͽ ȸ/Ī ׽Ʈ  ſ    ִ.
//  ȸ/Ī/߽ǥ/߽    ã  Ƿ  Ī ˰ ̰ ϸ ӵ ũ ų    Ѵ.
//---------------------------------------------------------------------------
TCVPoint CVPointSources[MAX_CV_POINT];
int CVPointSourceCount;

int CVPointStack[MAX_CV_POINT];
int CVPointStackTop;

bool CVPointCompareY(const TCVPoint &a, const TCVPoint &b)
{
	return a.y == b.y ? a.x > b.x : a.y > b.y;
}

bool CVPointCompareAngle(const TCVPoint &a, const TCVPoint &b)
{
	int c = CVPointCCW(CVPointSources[0], a, b);
	//       
	if (c == 0)
	{
		return CVPointDist(CVPointSources[0], a) < CVPointDist(CVPointSources[0], b);
	}
	return c > 0;
}

bool CVPointConvexHull()
{
	CVPointStackTop = 0;

	// ־ CVPointSources Ͽ Graham's Scan (׶ ĵ) ˰ Convex Hull (Ͽ) ϰ CVPointStack .
	if (CVPointSourceCount >= 2)
	{
		std::sort(CVPointSources, CVPointSources + CVPointSourceCount, CVPointCompareY); //Y  .
		std::sort(CVPointSources + 1, CVPointSources + CVPointSourceCount, CVPointCompareAngle); // ʿ ִ   ݽð 

		// ׶ ĵ ˰
		CVPointPushStack(0);
		CVPointPushStack(1);
		for (int i = 2; i < CVPointSourceCount; i++)
		{
			while (CVPointStackTop >= 2 && CVPointCCW(CVPointSources[i], CVPointSources[CVPointStack[CVPointStackTop - 2]], CVPointSources[CVPointStack[CVPointStackTop - 1]]) <= 0)
			{
				CVPointStackTop--;
			}
			CVPointPushStack(i);
		}
		return true;
	}
	return false;
}
//---------------------------------------------------------------------------
