//---------------------------------------------------------------------------

#ifndef __open_cv_h__
#define __open_cv_h__
//---------------------------------------------------------------------------

#define MAX_CV_POINT 10000

typedef struct
{
	int x, y;
} TCVPoint;

extern TCVPoint CVPointSources[MAX_CV_POINT];
extern int CVPointSourceCount;

extern int CVPointStack[MAX_CV_POINT];
extern int CVPointStackTop;

//---------------------------------------------------------------------------

inline void CVPointInitSource()
{
	CVPointSourceCount = 0;
}

inline void CVPointAddSource(int x, int y)
{
	if (CVPointSourceCount < MAX_CV_POINT)
	{
		CVPointSources[CVPointSourceCount].x = x;
		CVPointSources[CVPointSourceCount].y = y;
		CVPointSourceCount++;
	}
}

inline void CVPointPushStack(int n)
{
	CVPointStack[CVPointStackTop++] = n;
}

inline int CVPointCCW(const TCVPoint &a, const TCVPoint &b, const TCVPoint &c)
{
	return a.x * b.y + b.x * c.y + c.x * a.y - b.x * a.y - c.x * b.y - a.x * c.y;
}

inline int CVPointDist(TCVPoint a, TCVPoint b)
{
	return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

bool CVPointCompareY(const TCVPoint &a, const TCVPoint &b);
bool CVPointCompareAngle(const TCVPoint &a, const TCVPoint &b);

bool CVPointConvexHull();

//---------------------------------------------------------------------------
#endif /* __open_cv_h__ */
