#ifndef _SPB_MODULE_MAIN_H_
#define _SPB_MODULE_MAIN_H_

#include "Processing.h"

#ifdef PC_SIM
	#include "virtual_spb_system.h"
#else
	#include "spb_system.h"
#endif

typedef struct{
	int ProcessingNumber;
	int camIndex;
	int ProcessingResult;
	unsigned char processedImg[64 * 48];
}TVirtualCPBProcessedData;

typedef struct{
	unsigned int TabletNumber;
	int Result;
	int State;
	unsigned int ProcessStartTime;
	
	unsigned char CameraEnabled[SYSTEM_SPB_CAMERA_COUNT];
	unsigned short CapturedTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ImageSendTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned short CPBProcessingTime[SYSTEM_SPB_CAMERA_COUNT];
	int	ProcessingResult[SYSTEM_SPB_CAMERA_COUNT];
	
	unsigned char ProcessingDataSetSW;
	unsigned char TabletAssignSW;
}TVirtualSPBProcessedData;

extern int VirtualInspectionSWFromHCB;
extern int VirtualDataLoadChk;
extern int VirtualInspectionSW;
extern unsigned int VirtualTriggerTime;
extern int VirtualInspectionCount;
extern int VirtualProcessedDataCount;
extern TVirtualCPBProcessedData VirtualCPBProcessedData[800];
extern TVirtualCPBProcessedData tempVirtualCPBProcessedData;
extern int	VirtualCPBProcessingIndex[SYSTEM_CPB_COUNT];
extern TVirtualCPBStatus VirtualCPBStatus[SYSTEM_CPB_COUNT];
extern int VirtualTabletNumberSensor1;
extern int VirtualTabletNumberSensor2;
extern TVirtualSPBProcessedData VirtualSPBProcessedData[SPB_TABLET_LIST_COUNT + 1];
extern int VirtualDataRenewalSW;

typedef struct
{
	int Period;
    int CameraMask;
	int EnabledSPB;
	int ProcessOption;
} TCPBVirtualInspectionData;


extern TCPBVirtualInspectionData CPBVirtualInspectionData;
extern TCPBVirtualInspectionData CPBVirtualInspectionDataForRenewal;
extern TSPBProcessingSetupInfo SPBProcessingSetupInfo;
#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */
void MakeCPBSetupData(void);
void SPB_Module_Init(void);
void SPB_Processing_Exit(void);
void SPB_Processing_Main(void);
void SPB_Study_Setup_Start(void);
void SPB_Inspection_Setup_Start(void);
void SPB_Grade_Change_Start(void);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif

