#ifndef _SPB_PROCESSING_H_
#define _SPB_PROCESSING_H_

#include "common.h"
#include "Processing.h"

#define PROCESSING_MODE_NONE			0
#define PROCESSING_MODE_STUDY			1
#define PROCESSING_MODE_INSPECTION		2

#define PROCESSING_STEP_NONE					0
#define PROCESSING_STEP_INIT					1
#define PROCESSING_STEP_CAPTURE_READY			2
#define PROCESSING_STEP_CAPTURE_AND_PROCESS		3
#define PROCESSING_STEP_FINISHED				4

#define PROCESSING_UNIT_STATUS_IDLE				0
#define PROCESSING_UNIT_STATUS_INIT				1
#define PROCESSING_UNIT_STATUS_READY			2
#define PROCESSING_UNIT_STATUS_PROCESSING		3
#define PROCESSING_UNIT_STATUS_PROCESSING_END	4
#define PROCESSING_UNIT_STATUS_COMPELETE		5

// whole processing info
typedef struct
{
	int Processing_Exist;
	int Processing_End;
    int ProcessingMode;
	int ProcessingStep;
} TProcessingInfo;
extern TProcessingInfo ProcessingInfo;

// each processing unit info
typedef struct
{
	int Status;
    int CurrentProcessingLine;
    int ProcessingHeight;
} TProcessingUnit;
extern TProcessingUnit NormalProcessingUnit[SYSTEM_SPB_CAMERA_COUNT];
extern TProcessingUnit ExtendedProcessingUnit[SYSTEM_SPB_CAMERA_COUNT];

extern TStudySetupData StudySetupData_SPB;
extern TInspectData InspectData_SPB;
extern TStudyResultData_SPB StudyResultData_SPB[SYSTEM_SPB_CAMERA_COUNT];

extern TTabletCharacter TabletCharacter_SPB;
extern TTabletStudyResultData TabletStudyResultData_SPB;
extern TTabletGradeData TabletGradeData_SPB;
extern TTabletSetupData TabletSetupData_SPB;
extern TTablet3DSetupData Tablet3DSetupData_SPB;
extern TWhiteBalanceInfo WhiteBalanceInfo_SPB[SYSTEM_TOTAL_CAMERA_COUNT]; 

extern unsigned int PrintMatchingResult_SPB[512][3];

extern char CPBStep[SYSTEM_CPB_COUNT];
extern int CPBCamIndex[SYSTEM_CPB_COUNT];
extern int CPBProcessingTabletListIndex[SYSTEM_CPB_COUNT];
extern unsigned int CPBProcessingStartTime[SYSTEM_CPB_COUNT];

extern TProcessingTime ProcessingTimeList[SPB_TABLET_LIST_COUNT];
extern TThreeDPositionInfo ThreeDPositionInfo_SPB;
typedef struct
{
	int ProcessingMode;
	int MaxProcessingWaitingTime;
} TProcessingData;

extern TProcessingData ProcessingData;
extern TCPBProcessingInfo CPBProcessingInfo_SPB;

extern TTabletCaptureSetupData TabletCaptureSetupData;

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */
void InitCPBStep(void);
void SPB_Processing_Init(void);
void SPB_Inspection_Ready(int maxProcessingWaitingTime);
void SPB_Study_Ready(void);
void ReadyToProcessing(int processingMode);
void InitProcessingUnits(void);
void SPB_Processing_Loop(void);
void Virtual_Inspection(int maxCameraIndex);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif
