#ifndef _CISACAM_H_
#define _CISACAM_H_

#define FRAME_WIDTH_CIS							640
#define FRAME_HEIGHT_CIS						480
#define CAPTURE_TOP_POS_FULL_CAPTURE			0
#define CAPTURE_TOP_POS_PARTIAL_CAPTURE1		82
#define CAPTURE_TOP_POS_PARTIAL_CAPTURE2		120
#define CAPTURE_TOP_POS_PARTIAL_CAPTURE3		178		// (508 - 152) / 2
#define AREA_CAPTURE_HEIGHT_FULL_CAPTURE		480
#define AREA_CAPTURE_HEIGHT_PARTIAL_CAPTURE1	310
#define AREA_CAPTURE_HEIGHT_PARTIAL_CAPTURE2	222
#define AREA_CAPTURE_HEIGHT_PARTIAL_CAPTURE3	124
#define MAX_IMAGE_SIZE_CIS						(FRAME_WIDTH_CIS * FRAME_HEIGHT_CIS)

#define CIS_PARTIAL_CAPTURE_MODE_0				0	// full capture
#define CIS_PARTIAL_CAPTURE_MODE_1				1
#define CIS_PARTIAL_CAPTURE_MODE_2				2
#define CIS_PARTIAL_CAPTURE_MODE_3				3


typedef struct
{
	int CaptureStep;
	int CaptureTimeout1ms;

	unsigned short FrameWidth;
	unsigned short FrameHeight;
	unsigned short CaptureTopPos;
	unsigned short AreaCaptureHeight;
	unsigned short ShutterSpeed;
	unsigned short dummyShort[1];
	unsigned char CaptureReadLineCount;
	unsigned char HWCamIndex;
	unsigned char ImageBufferIndex;
	unsigned char PartialCaptureMode;
	
	unsigned short PrimaryReadLineCount;
	unsigned short SecondaryReadLineCount;

	unsigned int CaptureErrorCount;
	unsigned int CaptureStartTime;

	unsigned int DMATriggerCount;

	int *CaptureStatusPtr;

} TCIS_ACamCaptureInfo;

extern TCIS_ACamCaptureInfo CIS_ACamCaptureInfo[SYSTEM_SPB_CAMERA_COUNT];

void CIS_IsrCapture(int hardwareCamIndex);

#endif

