#ifndef _MASTER_H_
#define _MASTER_H_

#include "common.h"
#include <csl_mcbsp.h>

#define LASER_MCBSP_PACKET_SIZE			4		// 5*4 = 20byte
#define LASER_MCBSP_PACKET_HEADER		0xA7A7
#define LASER_MCBSP_NONE					0
#define LASER_MCBSP_TRANSFER_READY		1
#define LASER_MCBSP_TRANSMITTING			2
#define LASER_MCBSP_TRANSMIT_RETRY		3
#define LASER_MCBSP_RECEIVE_READY			4
#define LASER_MCBSP_HEADER_RECEIVED		5
#define LASER_MCBSP_RECEIVE_COMPLETE		6
#define LASER_MCBSP_RECEIVE_ERROR			7


#define LASER_MCBSP_TIMEOUT				100   // 50 *200 = 10ms

typedef struct 
{
	unsigned short 		header;	
	unsigned short 		theta; 				//
	unsigned short 		x_coordinate; 			//xǥ
	unsigned short		y_coordinate; 			//yǥ
	unsigned short		print_status;                        //μ 
  	unsigned short             reserved;
 	unsigned int 			checksum;				/* data & checksum */
	unsigned int 			dummy;
} TLaserMcbspPacket;

struct
{
	unsigned int LastReceiveTime;
	unsigned short PacketLength;
	unsigned short ReadCount;
	union
	{
		unsigned int Buffer[LASER_MCBSP_PACKET_SIZE];
		TLaserMcbspPacket Data;
	} UPacket;
} Laser_RXControlData;

struct
{
	unsigned int TransmitStartTime;
	unsigned int TransmitEndTime;
	int RetryCount;
	int RetryEnabled;
	unsigned short PacketLength;
	unsigned short WriteCount;
	union								
	{
		unsigned int Buffer[LASER_MCBSP_PACKET_SIZE];
		TLaserMcbspPacket Data;
	} UPacket;
} Laser_TXControlData;

struct
{
	int FSM;
} LaserMcbspControlData;

int LaserMcbspInit(void);									// master ʱȭ
void LaserMcbsp_Process(void);								// master loop
int LaserMcbsp_SendPacket(short theta, short x_coordinate, short y_coordinate);
#endif
