#ifndef _RANGER3DCAM_H_
#define _RANGER3DCAM_H_

#include "common.h"

#define MAX_FRAME_WIDTH_RANGER_3D				512
#define MAX_FRAME_HEIGHT_RANGER_3D				512
#define FRAME_WIDTH_RANGER_3D					512
#define AREA_FRAME_HEIGHT_RANGER_3D				512
#define LINE_FRAME_HEIGHT_RANGER_3D				368
//#define FRAME_HEIGHT_RANGER_3D					368
#define AREA_CAPTURE_HEIGHT_RANGER_3D			512
#define MAX_IMAGE_SIZE_RANGER_3D				(MAX_FRAME_WIDTH_RANGER_3D * MAX_FRAME_HEIGHT_RANGER_3D)

typedef struct
{
	int State;
	int WaitingTime;
	int CamIndex;
	int ComState;
	int Command;
	int CommandState;
	int PacketID;
	int CommandResult;
	int Config;
	unsigned int ComStartTime;
	unsigned int ComRXReadPosition;
	unsigned int ComTimeout;
	unsigned int ComTXWriteLength;
	unsigned int ComTXWritePosition;
	unsigned int ComRetryWaitingRemain;
	int ComRetryCount;
	char ComData[4096];
} TRangerCameraInfo;
extern TRangerCameraInfo RangerCameraInfo;

extern TRangerCameraParamData RangerCameraParamData;

void Ranger3DCameraSetup(void);
void Ranger3DCameraSet_Param(void);
void Ranger_IsrCapture(int hardwareCamIndex);

#endif
