#include "capture.h"
#include "common.h"
#include "system_setup.h"
#include "capture_camera.h"
#include "environment.h"
#include "nfa_camera.h"

int CameraIndexMap[SYSTEM_SPB_CAMERA_COUNT];
int global3DCameraFrameCaptureSW;

void InitCapture(void)		// must call after systemsetup
{
	int cisCamCount = 0, rangerCamCount = 0, nfa2DCamCount=0,nfa3DCamCount=0;
	int ranger3DCamIndex = -1;
	int spbCamIndex;

	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		CameraIndexMap[spbCamIndex] = -1;
	}

	NFA_Area_Cam_Init();
	
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		NFA_Area_Cam_Setup(spbCamIndex, SystemSetupData.CameraHardwarePosition[spbCamIndex], spbCamIndex);
		if(SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D)
			AllocateImageBuffer(spbCamIndex, SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT);
		else
			AllocateImageBuffer(spbCamIndex, NFA_3D_MAX_IMAGE_SIZE);

		CameraIndexMap[spbCamIndex] = spbCamIndex;
	}
	global3DCameraFrameCaptureSW = 0;
}
//---------------------------------------------------------------------------
int CaptureStart(unsigned char captureKind, int spbCamIndex, unsigned short *shutterSpeed, unsigned char *SubSamplingMode,
	unsigned char *captureImage, int *ptrStatus)
{
	if (CameraIndexMap[spbCamIndex] >= 0)
	{
		if(SystemSetupData.CamMask & ((0x01) << spbCamIndex))
			{
			if  (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D || SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
			{
				if(SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D)
				{			
					NFA_2D_CaptureSetup(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex], CAPTURE_KIND_FRAME, SubSamplingMode[spbCamIndex]);			
					global3DCameraFrameCaptureSW = 0;
					return NFA_FrameCaptureStart(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex],captureImage, ptrStatus);
				}
				else if(SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
				{
					NFA_3D_CaptureSetup(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex], captureKind, shutterSpeed[spbCamIndex]);

					if (captureKind == CAPTURE_KIND_LINE)
					{
						global3DCameraFrameCaptureSW = 0;
						return NFA_LineCaptureStart(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex],captureImage, ptrStatus);
					}
					else
					{
						global3DCameraFrameCaptureSW = 1;
						return NFA_FrameCaptureStart(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex],captureImage, ptrStatus);				
					}			
				}
			}
		}
	}
	else
	{
		return -1;
	}
	return -1;
}
//---------------------------------------------------------------------------
void CaptureStop(int spbCamIndex)
{
	if (CameraIndexMap[spbCamIndex] >= 0)
	{

		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D || SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{
			NFA_CaptureStop(CameraIndexMap[spbCamIndex]);
		}		

	}
}
//---------------------------------------------------------------------------
void CaptureSetup(unsigned short *shutterSpeed, unsigned short *triggerFreq, unsigned char *SubSamplingMode, int stopCaptureSW)
{
	int spbCamIndex;
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		if (CameraIndexMap[spbCamIndex] >= 0)
		{
			if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D)
			{
				NFA_2D_CaptureSetup(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex], CAPTURE_KIND_FRAME, SubSamplingMode[spbCamIndex]);				
			}
			else if(SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
			{
				if(0)//SystemSetupData.Laser_complexer_Enable==1)
				{
					if(stopCaptureSW)
					{
						NFA_3D_CaptureSetup(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex], CAPTURE_KIND_LINE, triggerFreq[spbCamIndex]);
					}
				}
				else
				{
					NFA_3D_CaptureSetup(CameraIndexMap[spbCamIndex], shutterSpeed[spbCamIndex], CAPTURE_KIND_LINE, triggerFreq[spbCamIndex]);				
				}
			}
		}
	}
}
//---------------------------------------------------------------------------
int NextCaptureTrigger(int spbCamIndex, unsigned char *captureImage, int *ptrStatus)
{
	if (CameraIndexMap[spbCamIndex] >= 0)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D || (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D))
		{
			if(SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D || 
				(global3DCameraFrameCaptureSW && SPBTabletProcessInfo.CaptureMode == MACHINE_CAPTURE_MODE_NONE))
				return NFA_Frame2DCaptureTrigger(CameraIndexMap[spbCamIndex], captureImage, ptrStatus);
			else
				return NFA_LineScan3DCaptureTrigger(CameraIndexMap[spbCamIndex], captureImage, ptrStatus);
		}
	}
	else
	{
		return -1;
	}
	return -1;
}
//---------------------------------------------------------------------------
void SetCaptureTime(int spbCamIndex)
{	
	if (CameraIndexMap[spbCamIndex] >= 0)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D)
		{
		}
		else if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{
		}		
	}
}

//---------------------------------------------------------------------------
void CaptureAbort(int spbCamIndex)
{	
	if (CameraIndexMap[spbCamIndex] >= 0)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D || (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D))
		{
			NFA_CaptureAbort(CameraIndexMap[spbCamIndex]);
		}		
	}
}

//---------------------------------------------------------------------------
int GetCameraStatus(int spbCamIndex)
{
	if (CameraIndexMap[spbCamIndex] >= 0)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_2D || (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D))
		{
			return NFA_GetCameraStatus(CameraIndexMap[spbCamIndex]);
		}		
	}
	else
	{
		return CAMERA_STATUS_NONE;
	}
	return CAMERA_STATUS_NONE;
}

//---------------------------------------------------------------------------
