#include "capture_camera.h"
#include "timer.h"
#include "environment.h"
#include <csl_intc.h>
#include <csl_intcAux.h>
#include <csl_gpio.h>

#pragma DATA_ALIGN(Capture_Temp_Buffer, 8)	// 8  Ǿ EDMA ۵.
//#pragma	DATA_SECTION(Capture_Temp_Buffer, ".sdram")
unsigned short Capture_Temp_Buffer[2][MAX_CAPTURE_READ_SIZE];	
#pragma DATA_ALIGN(Capture_Empty_Buffer, 8)	// 8  Ǿ EDMA ۵.
#pragma	DATA_SECTION(Capture_Empty_Buffer, ".sdram")
unsigned char Capture_Empty_Buffer[9600];	
#pragma DATA_ALIGN(Capture_Full_Buffer, 8)	// 8  Ǿ EDMA ۵.
#pragma	DATA_SECTION(Capture_Full_Buffer, ".sdram")
unsigned char Capture_Full_Buffer[9600];	

unsigned short CaptureFlag;
extern unsigned short NFA_triger;

void CaptureStartLine(int cameraIndex, unsigned short shutterSpeed)
{
	volatile unsigned int i;	
	NFA_SET_BIT(NFA_triger,cameraIndex);
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
	Lamp2Toggle();
}

void CaptureStartFrame(int cameraIndex, unsigned short shutterSpeed)
{
	volatile unsigned int i;	
	CSL_IntcGlobalEnableState gie;
	NFA_SET_BIT(NFA_triger,cameraIndex);
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
	Lamp2Toggle();

}

void CaptureStopOne(int cameraIndex)
{	
	NFA_RESET_BIT(NFA_triger,cameraIndex);
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
}

//---------------------------------------------------------------------------
