#ifndef _DATA_TRANSFER_H_
#define _DATA_TRANSFER_H_

#define MAX_SDRAM_COPY_SIZE		16 * 1024
#define MAX_HPI_PACKET_SIZE		518		// words
//#define MAX_HPI_TRANSFER_SIZE_WORD	512
//#define MAX_HPI_TRANSFER_SIZE_WORD	256
#define MAX_HPI_READ_SIZE		128
#define MAX_HPI_READ_SIZE_WORD	MAX_HPI_READ_SIZE/4

typedef struct
{
	int Step;
	unsigned char *DataAddress;
	int DataSize;
	unsigned int Checksum;
} TSendDataPC;

typedef struct
{
	int Step;
	unsigned char *DataAddress;
	int DataSize;
	int RespectedStep;
	unsigned int DataReceive_SW;
	unsigned int ReceiveTime;
} TReceiveDataPC;

extern TReceiveDataPC ReceiveDataPC;


typedef struct
{
	unsigned int TotalSendWord;
	unsigned int TotalErrorWord;
	unsigned int ActualTransferDataWord;
	unsigned int TotalSendCount;
	unsigned int AckPacketCount;
	unsigned int ErrPacketCount;
	unsigned int RetryCount;
	unsigned int ReadErrorCount;
	unsigned int LazeInterruptCount;
	unsigned int CritErrorCount;
	unsigned int RetryExceededCount;
	unsigned int SendTime;
	unsigned int IntStateRetryCount;
	unsigned int CPBErrorPacketCount;
	unsigned int CPBTOPacketCount;
	unsigned int ChecksumErrorPacketCount;
} THPIStat;

extern THPIStat HPIStat;


void Request_Copy_SDR_to_SDR_Aligned(void *dst_address, void *src_address, int size);
void Request_CopyData(void *dst_address, void *src_address, int size);
void Request_ClearData_Aligned(void *dst_address, unsigned int fill_value, int size);
void Request_CopyData_Reverse_Aligned(void *dst_address, void *src_address, int size);
void Request_ImageScaleConversion(void *src_address, void *dst_address, int width, int height);

// data transfer function

//int Request_SendData(unsigned short indicator, void *data_address, int data_size, int cpbIndex, unsigned int dst_address);
int Request_SendImage_Buffer(int captureIndex, int width, int height, int cpbIndex, int bufferIndex, int imageMode);

#endif

