#ifndef DESCRIPTOR_H_
#define DESCRIPTOR_H_

#define DESCRIPTOR_TYPE_DEVICE						1
#define USB_DEVICE_DESCRIPTOR_TYPE					0x01
#define DESCRIPTOR_TYPE_CONFIGURATION				2
#define USB_CONFIGURATION_DESCRIPTOR_TYPE			0x02
#define DESCRIPTOR_TYPE_STRING						3
#define USB_STRING_DESCRIPTOR_TYPE					0x03
#define DESCRIPTOR_TYPE_INTERFACE					4
#define USB_INTERFACE_DESCRIPTOR_TYPE				0x04
#define DESCRIPTOR_TYPE_ENDPOINT					5
#define USB_ENDPOINT_DESCRIPTOR_TYPE				0x05
#define DESCRIPTOR_TYPE_DEVICE_QUALIFIER			6
#define USB_DEVICEQUALIFIER_DESCRIPTOR_TYPE		  	0x06
#define DESCRIPTOR_TYPE_OTHER_SPEED_CONFIGURATION	7
#define USB_OTEHRSPEEDCONFIGURATION_DESCRIPTOR_TYPE	0x07
#define DESCRIPTOR_TYPE_INTERFACE_POWER				8
#define USB_INTERFACEPOWER_DESCRIPTOR_TYPE		  	0x08

typedef struct _USB_DEVICE_DESCRIPTOR
{
	unsigned char 	bLength;					// byte count
	unsigned char 	bDescriptorType;
	unsigned char 	bcdUSB_L;						// version;
	unsigned char 	bcdUSB_H;						// version;
	unsigned char   bDeviceClass;
	unsigned char	bDeviceSubClass;
	unsigned char	bDeviceProtocol; 			//deviceSubSubClass;
	unsigned char 	bMaxPacketSize0;
	unsigned char	idVendor_L;
	unsigned char	idVendor_H;
	unsigned char	idProduct_L;
	unsigned char	idProduct_H;
	unsigned char	bcdDevice_L;					//productVersionID;			// bcdDevice;
	unsigned char	bcdDevice_H;					//productVersionID;			// bcdDevice;
	unsigned char 	iManufacturer;
	unsigned char	iProduct;
	unsigned char	iSerialNumber;
	unsigned char	bNumConfigurations;
} TUSBDeviceDescriptor;

typedef struct _USB_DEVICEQUALIFIER_DESCRIPTOR
{
	unsigned char 	bLength;
	unsigned char 	bDescriptorType;
	unsigned char 	bcdUSB_L;
	unsigned char 	bcdUSB_H;
	unsigned char   bDeviceClass;
	unsigned char	bDeviceSubClass;
	unsigned char	bDeviceProtocol;
	unsigned char 	bMaxPacketSize0;
	unsigned char	bNumConfigurations;
	unsigned char	bReserved;
} TUSBDeviceQualifierDescriptor;

typedef struct _USB_CONFIGURATION_DESCRIPTOR
{
	unsigned char 	bLength;
	unsigned char	bDescriptorType;
	unsigned char	wTotalLength_L;
	unsigned char	wTotalLength_H;
	unsigned char	bNumInterfaces;
	unsigned char	bConfigurationValue;
	unsigned char 	iConfiguration;
	unsigned char	bmAttributes;
	unsigned char	bMaxPower;
} TUSBConfigurationDescriptor;

typedef struct _USB_OTHER_SPEED_CONFIGURATION_DESCRIPTOR
{
	unsigned char 	bLength;
	unsigned char	bDescriptorType;
	unsigned char	wTotalLength_L;
	unsigned char	wTotalLength_H;
	unsigned char	bNumInterfaces;
	unsigned char	bConfigurationValue;
	unsigned char 	iConfiguration;
	unsigned char	bmAttributes;
	unsigned char	bMaxPower;
} TUSBOtherSpeedConfigurationDescriptor;

typedef struct _USB_INTERFACE_DESCRIPTOR
{
	unsigned char 	bLength;
	unsigned char	bDescriptorType;
	unsigned char 	bInterfaceNumber;
	unsigned char	bAlternateSetting;
	unsigned char	bNumEndPoints;
	unsigned char	bInterfaceClass;
	unsigned char	bInterfaceSubClass;
	unsigned char	bInterfaceProtocol;
	unsigned char	iInterface;
} TUSBInterfaceDescriptor;

#define USB_ENDPOINT_TYPE_MASK                    	0x03
#define USB_ENDPOINT_TYPE_SHIFT						0

#define USB_ENDPOINT_TYPE_CONTROL					0x00
#define USB_ENDPOINT_TYPE_ISOCHRONOUS				0x01
#define USB_ENDPOINT_TYPE_BULK						0x02
#define USB_ENDPOINT_TYPE_INTERRUPT					0x03 


#define SETUP_DMA_REQUEST 							0x0471
#define GET_FIRMWARE_VERSION    					0x0472
#define TWIN_CONFIGURATION							0x0473

#define USB_ENDPOINT_DIRECTION_MASK               	0x80

typedef struct _USB_ENDPOINT_DESCRIPTOR
{
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	bEndpointAddress;
	unsigned char	bmAttributes;
	unsigned char	wMaxPacketSize_L;
	unsigned char	wMaxPacketSize_H;
	unsigned char	bInterval;
} TUSBEndpointDescriptor;

#define USB_STRING_DESCRIPTOR_MAX_STRING_COUNT		18
typedef struct _USB_STRING_DESCRIPTOR
{
	unsigned char 	bLength;
	unsigned char 	bDescriptorType;
	unsigned char	bString[USB_STRING_DESCRIPTOR_MAX_STRING_COUNT];
} TUSBStringDescriptor;


#define STR_INDEX_LANGUAGE						  0x00
#define STR_INDEX_MANUFACTURER					  0x01
#define STR_INDEX_PRODUCT						  0x02
#define STR_INDEX_SERIALNUMBER					  0x03
#define STR_INDEX_CONFIGURATION					  0x04
#define STR_INDEX_INTERFACE						  0x05

typedef struct _USB_STRING_LANGUAGE_DESCRIPTOR {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned short	ulanguageID;
} TUSBStringLanguageDescriptor;

typedef struct _USB_STRING_INTERFACE_DESCRIPTOR {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	Interface[22];
} TUSBStringInterfaceDescriptor;

typedef struct _USB_STRING_CONFIGURATION_DESCRIPTOR {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	Configuration[16];
} TUSBStringConfigurationDescriptor;

typedef struct _USB_STRING_SERIALNUMBER_DESCRIPTOR {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	SerialNum[24];
} TUSBStringSerialNumberDescriptor;

typedef struct _USB_STRING_PRODUCT_DESCRIPTOR {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	Product[28];
} TUSBStringProductDescriptor;

typedef struct _USB_STRING_MANUFACTURER_DESCRIPTOR {
	unsigned char	bLength;
	unsigned char	bDescriptorType;
	unsigned char	Manufacturer[22];
} TUSBStringManufacturerDescriptor;

#endif
