#ifndef _ENVIRONMENT_H_
#define _ENVIRONMENT_H_

#include "common.h"
#include "command.h"
#include "flash.h"

extern unsigned short BoardID;
extern TSPBSetupInfo SetupInfo;

#ifdef BOARD_TYPE_SPB06
#define DOWNLOAD_MAX_SIZE					0x00300000		// 3Mb
#define CPB_MAX_HEX_SIZE					0x00300000
#define CPB_MAX_CODE_SIZE					0x00180000		// 1.5Mb
#elif BOARD_TYPE_IPB
#define DOWNLOAD_MAX_SIZE					0x00C00000		// 12Mb
#define CPB_MAX_HEX_SIZE					0x00180000
#define CPB_MAX_CODE_SIZE					0x00180000		// 1.5Mb
#endif 
extern unsigned char ProgramBuffer[DOWNLOAD_MAX_SIZE];

extern unsigned char *CaptureBuffer[SYSTEM_SPB_CAMERA_COUNT];

#define CAPTURE_STATUS_NONE					0
#define CAPTURE_STATUS_ON_CAPTURE			1
#define CAPTURE_STATUS_COMPLETE				2
#define CAPTURE_STATUS_TIMEOUT				3

#define THREED_CAMERA_SENSOR_OFF				3
#define THREED_CAMERA_SENSOR_SD1_BIT			0
#define THREED_CAMERA_SENSOR_SD2_BIT			1

#define THREED_CAMERA_CAPTURE_MODE_NONE			0
#define THREED_CAMERA_CAPTURE_MODE_CALIB			1
#define THREED_CAMERA_CAPTURE_MODE_CAPTURE			2
#define THREED_CAMERA_CAPTURE_MODE_PROCESSING		3
#define THREED_CAMERA_CAPTURE_MODE_SENSOR			4




#define CAMERA_STATUS_NONE					0
#define CAMERA_STATUS_READY					1
#define CAMERA_STATUS_ON_CAPTURE			2


#define MACHINE_CAPTURE_MODE_NONE				0
#define MACHINE_CAPTURE_MODE_CAPTURE			2
#define MACHINE_CAPTURE_MODE_PROCESSING			3


typedef struct
{
	unsigned char CameraEnable[4];
	unsigned short ShutterSpeed[4];
	unsigned short ShutterDelay[4];
	unsigned short TriggerFreq[4];
	unsigned char SubsamplingMode[4];
	unsigned int CaptureMode;	
	int FrameBufferCount;
	int TabletType;
	int SensorLength;
} TCameraSetupData;

extern TRanger3DCameraInfo Ranger3DCameraInfo;
extern TCameraSetupData CameraSetupData;
extern unsigned int Max_Laser_Position_Processing_Time;
extern int LaserCalInPutDataX;
extern int LaserCalInPutDataY;
extern unsigned int HCB_Interrupt_Delay_Time;
extern TSPBProgramHeader SPBProgramHeader;
extern TSPBDBHeader SPBDBHeader;
extern TSPBFPGAVersion SPBFPGAVersion;
extern TSPBTabletProcessInfo SPBTabletProcessInfo;

extern TSPBProcessingResultData SPBProcessingResultData;

extern TProgramVersion ProgramVersion;
extern TSPBCompatibility SPBCompatibility;
extern TSPBFPGAVersion FPGAnewVersion2; //sjm Add
extern unsigned int Selma200CameraCount;
extern unsigned char G_C_CAMERA_SD_POS_INFO[2][6][4];
#endif
