/**
 *   @file  evminit.h
 *
 *   @brief
 *      EVM and EMAC PHY initializations for the EVM.
 *
 *  \par
 *  NOTE:
 *      (C) Copyright 2008, Texas Instruments, Inc.
 *
 *  \par
 */

#ifndef EVMINIT_
#define EVMINIT_

#ifdef __cplusplus
extern "C" {
#endif

#include <netmain.h>
#include <stdio.h>
#include <std.h>
#include <sys.h>
#include <csl_pllc.h>
#include <c6x.h>
#include <csl_types.h>
#include <soc.h>
#include <cslr_mdio.h>
#include <evm.h>
#include <EVM_GPIO.h>


#define MDIO_REGS   ((CSL_MdioRegs *) CSL_MDIO_0_REGS)

/* MAC ID */
#define DEVICE_REG_MAC_ADDR(x)  *((volatile unsigned int *)(0x02880914 + (x)*4))

/** @name Power saver
 *  Definitions for the power saver registers
 */
//@{ 
#define PWR_BASE_ADDR            (0x02AC0000)           ///< Power saver base address
#define PWR_LCK_REG_ADDR         (PWR_BASE_ADDR + 0x04)
#define PWR_MDCTL0_REG_ADDR      (PWR_BASE_ADDR + 0x08)

#define PWR_LCK_REG_VAL          (0x0F0A0B00)
#define PWR_MDCTL0_EMAC_EN_VAL   (0x00000010)
//@}

#define REG_WRITE(addr, val)    (*((Uint32 *)(addr)) = (val))  ///< Register write macro        

// This string array corresponds to link state as defined in csl_mdio.h
static char *LinkStr[] = { "No Link",
                           "10Mb/s Half Duplex",
                           "10Mb/s Full Duplex",
                           "100Mb/s Half Duplex",
                           "100Mb/s Full Duplex",
                           "1000Mb/s Full Duplex" };


/* Function Declarations */

extern void EMAC_getConfig( UINT8 *pMacAddr);
extern void EMAC_linkStatus( uint phy, uint linkStatus );
extern void Init_EVM();
extern int EVM_getCPUID(void);
extern int EVM_getPHYID(int cpuID);
extern void EVM_powerOnEMAC();
extern void EVM_wait(Uint32 delay);
extern void EVM_waitusec(Uint32 delay);

#ifdef __cplusplus
}
#endif

#endif
