#ifndef _FLASH_H_
#define _FLASH_H_

#include "fm_samsung.h"
#include "fm_spansion.h"

#ifdef FM_K9F2808
#define FFS_INFO_MAX_COUNT	BLOCKS_PER_DEIVCE
#endif
#ifdef S29GL032N
#define FFS_INFO_MAX_COUNT	FLASH_PAGES
#endif

#define FFS_FAT_UNUSED		0x0000
#define FFS_FAT_INVALID		0xFFFF

#define FFS_OPEN_READ		0
#define FFS_OPEN_WRITE		1

typedef int TFFID;
typedef int TFFHandle;

typedef struct
{
	TFFID id;
	int startBlock;
	int size;
    int updatedTime;
	int reserved[4];
} TFFInfo;
#ifdef FM_K9F2808
typedef struct {
	unsigned short fat[BLOCKS_PER_DEIVCE];
	TFFInfo fileInfo[FFS_INFO_MAX_COUNT];
} TFFSystem;
#endif
#ifdef S29GL032N
typedef struct {
	unsigned short fat[FLASH_PAGES];
	TFFInfo fileInfo[FFS_INFO_MAX_COUNT];
} TFFSystem;
#endif

typedef struct {
	unsigned int byte_for_page;
	unsigned int page_per_block;
	unsigned int block_per_deviec;
	unsigned int block_max_size;
} TFFSize;

TFFHandle FlashOpen(TFFID id, int attr);
int FlashSize(TFFHandle handle);
int FlashRead(TFFHandle handle, unsigned char *buffer, int size);
int FlashWrite(TFFHandle handle, unsigned char *buffer, int size, int time);
int FlashFormat();

#endif


