#include "heap_control.h"

#pragma DATA_ALIGN(HPIHeap, 8);
#pragma	DATA_SECTION(HPIHeap, ".sdram");
unsigned char HPIHeap[8192];
int HPIHeapPosition = 0;


//---------------------------------------------------------------------------
void ClearHPIHeap(void)
{
	HPIHeapPosition = 0;
}
//---------------------------------------------------------------------------
void AddL2DataToHPIHeap(void *data, int size)
{
	memcpy(&HPIHeap[HPIHeapPosition], data, size);
	HPIHeapPosition += size;
}
//---------------------------------------------------------------------------
void *GetHPIHeapAddr(void)
{
	return HPIHeap;
}
//---------------------------------------------------------------------------
int GetHPIHeapSize(void)
{
	return HPIHeapPosition;
}
//---------------------------------------------------------------------------
void GoTopOfHPIHeap(void)
{
	HPIHeapPosition = 0;
}
//---------------------------------------------------------------------------
void ReadL2DataFromHPIHeap(void *data, int size)
{
	memcpy(data, &HPIHeap[HPIHeapPosition], size);
	HPIHeapPosition += size;
}
//---------------------------------------------------------------------------
