#include "DMAScheduler.h"
#include "image_control.h"
#include "timer.h"
#include "capture_camera.h"
#include "NFA_camera.h"
#include "hardware.h"
#include "environment.h"
#include "system_setup.h"
#include "spb_processing.h"
#include "calibration.h"

extern CSL_Edma3Handle 				hNFAEdma;
CSL_Edma3CmdDrae            		nfaRegionSetup;
int Capture_drae,Capture_draeh;

CSL_Edma3ChannelAttr        		nfaChannelSetup[SYSTEM_SPB_CAMERA_MAX_COUNT];
CSL_Edma3ChannelObj         		nfaChObj[SYSTEM_SPB_CAMERA_MAX_COUNT];
CSL_Edma3CmdIntr            		nfaRegionIntr[SYSTEM_SPB_CAMERA_MAX_COUNT];

CSL_Edma3ParamHandle			hNFACamEdmaParam[SYSTEM_SPB_CAMERA_MAX_COUNT];
CSL_Edma3ChannelHandle			hNFAChannel[SYSTEM_SPB_CAMERA_MAX_COUNT];
CSL_Edma3ParamSetup				NFACamEdmaParamSet[SYSTEM_SPB_CAMERA_MAX_COUNT];
CSL_Edma3ParamSetup				NFA3DCamEdmaParamSet[SYSTEM_SPB_CAMERA_MAX_COUNT][MAX_REGISTABLE_FRAME_COUNT];

TNFACaptureInfo NFACaptureInfo[SYSTEM_SPB_CAMERA_MAX_COUNT];
TNFACamCommend NFACommendRx[SYSTEM_SPB_CAMERA_MAX_COUNT];
TNFACamCommend NFACommendTx[SYSTEM_SPB_CAMERA_MAX_COUNT];

TNFA2DCameraAreaInfo NFA2DCameraAreaInfo;
TNFACamCheckInfo NfaCamCheckInfo;

int nfaCaptureEDMAChannelNumber[SYSTEM_SPB_CAMERA_MAX_COUNT];
int nfaCaptureEDMATCCNumber[SYSTEM_SPB_CAMERA_MAX_COUNT];

int NFAUnHandledStatus;
int init_Process;
int Uart_process;
int Uart_Polarity;
int link_camera_count;
int camera_init_current_time;
int uart_txbuf[MAX_COMM_DATA_LENGTH], uart_rxbuf[MAX_COMM_DATA_LENGTH];
int tx_ptr, rx_ptr;
int camera_cnt;
char ReceivedData[MAX_COMM_DATA_LENGTH];

int threed_time_check[SYSTEM_SPB_CAMERA_MAX_COUNT][100];
int threed_time_check_count[SYSTEM_SPB_CAMERA_MAX_COUNT]={0,0,0,0};
int start_3d_time[SYSTEM_SPB_CAMERA_MAX_COUNT] = {0,0,0,0}, end_3d_time[SYSTEM_SPB_CAMERA_MAX_COUNT]= {0,0,0,0};
int threed_capture_period[SYSTEM_SPB_CAMERA_MAX_COUNT] = {0,0,0,0},threed_capture_sum[SYSTEM_SPB_CAMERA_MAX_COUNT] = {0,0,0,0};
int test_cam_count[10];
int camera_rData=0;
int test_trg_one=0;
int pola_cng_one = 0;
unsigned short NFA_triger;
extern CSL_TmrHandle TimerHandle1;
int cam_init_complete= 0;
int cam_int_err[SYSTEM_SPB_CAMERA_MAX_COUNT];
int cam_timeout_cnt[SYSTEM_SPB_CAMERA_MAX_COUNT];
int cam_trig_count[SYSTEM_SPB_CAMERA_MAX_COUNT];
int cam_int_count[SYSTEM_SPB_CAMERA_MAX_COUNT];
int cam_complete_count[SYSTEM_SPB_CAMERA_MAX_COUNT];
int init_camera_type[SYSTEM_SPB_CAMERA_MAX_COUNT];
extern TCalibCaptureInfo CalibCaptureInfo[SYSTEM_SPB_CAMERA_MAX_COUNT];
unsigned int CapturedImageStAddress[SYSTEM_SPB_CAMERA_MAX_COUNT];
int FIFOReadSize;
int dstShiftCount;
int camera_ttt[10];
unsigned short Sensor_3D_triger;
int ExpectedRS232ReceiveDataCount;
unsigned int MakeIdleChannelProcessingStartTime;

#define MAX_RS232_RECEIVE_WAITING_TIME_US	500 // 500ms
//---------------------------------------------------------------------------
// EDMA	Event handler
void NFA_CaptureComplete0(void);
void NFA_CaptureComplete1(void);
void NFA_CaptureComplete2(void);
void NFA_CaptureComplete3(void);
//---------------------------------------------------------------------------
void NFA_Area_Cam_Init(void)
{
	int	camIndex;
	CSL_Edma3Context            context;
	CSL_Status                  status; 
	NFA_triger = 0;
	memset(NFACommendRx,0x00,sizeof(NFACommendRx));
	memset(NFACommendTx,0x00,sizeof(NFACommendRx));
	memset(test_cam_count,0x00,sizeof(test_cam_count));
	memset(threed_time_check,0x00,sizeof(threed_time_check));
	memset(init_camera_type,0x00,sizeof(init_camera_type));
	memset(Capture_Empty_Buffer, 0x00, sizeof(Capture_Empty_Buffer));
	memset(Capture_Full_Buffer, 0xFF, sizeof(Capture_Full_Buffer));
	memset(Capture_Temp_Buffer, 0x00, sizeof(Capture_Temp_Buffer));
	memset(camera_ttt,0x00, sizeof(camera_ttt));
	Sensor_3D_triger = 3;
	for	(camIndex =	0; camIndex	< SYSTEM_SPB_CAMERA_MAX_COUNT; camIndex++)
	{
		NFACaptureInfo[camIndex].CaptureReadLineCount = CAPUTRE_READ_LINE_COUNT_NFA;
		NFACaptureInfo[camIndex].CaptureErrorCount = 0;
		NFACaptureInfo[camIndex].CaptureStartTime = 0;
		NFACaptureInfo[camIndex].ShutterSpeed = 0;
		NFACaptureInfo[camIndex].CaptureKind = CAPTURE_KIND_FRAME;
		NFACaptureInfo[camIndex].CaptureTopPos = NFA_2D_CAPTURE_TOP_POS_FULL_CAPTURE;
		NFACaptureInfo[camIndex].FrameWidth = SYSTEM_CAMERA_WIDTH;
		NFACaptureInfo[camIndex].FrameHeight = SYSTEM_CAMERA_HEIGHT;
		NFACaptureInfo[camIndex].DMATriggerCount = 18;
		NFACommendTx[camIndex].Header = 0xA1;
		NFACommendTx[camIndex].Tail = 0xAE;
		NFACommendTx[camIndex].Id = (camIndex+1)*16;

		NFA3D_Streaming_Control_Clear(camIndex);
	}
	
	nfaCaptureEDMAChannelNumber[0]= CSL_EDMA3_CHA_4;
	nfaCaptureEDMAChannelNumber[1]= CSL_EDMA3_CHA_5;
	nfaCaptureEDMAChannelNumber[2]= CSL_EDMA3_CHA_6;
	nfaCaptureEDMAChannelNumber[3]= CSL_EDMA3_CHA_7;

	memset(cam_int_err, 0x00, sizeof(cam_int_err));
	memset(cam_trig_count, 0x00, sizeof(cam_trig_count));
	memset(cam_int_count, 0x00, sizeof(cam_int_count));
	memset(cam_complete_count, 0x00, sizeof(cam_complete_count));
	memset(cam_timeout_cnt, 0x00, sizeof(cam_timeout_cnt));
	
	for	(camIndex =	0; camIndex	< SYSTEM_SPB_CAMERA_MAX_COUNT; camIndex++)
	{
		nfaChannelSetup[camIndex].regionNum = CSL_EDMA3_REGION_1;
		nfaChannelSetup[camIndex].chaNum = nfaCaptureEDMAChannelNumber[camIndex];
		hNFAChannel[camIndex] = CSL_edma3ChannelOpen(&nfaChObj[camIndex], CSL_EDMA3, &nfaChannelSetup[camIndex], &status);
		CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_ENABLE, NULL);
		
		switch (camIndex)
		{
			case 0:
				nfaCaptureEDMATCCNumber[camIndex] = AllocEDMAInterruptHandler(NFA_CaptureComplete0,CSL_EDMA3_CHA_4);
				break;
			case 1:
				nfaCaptureEDMATCCNumber[camIndex] = AllocEDMAInterruptHandler(NFA_CaptureComplete1,CSL_EDMA3_CHA_5);
				break;
			case 2:
				nfaCaptureEDMATCCNumber[camIndex] = AllocEDMAInterruptHandler(NFA_CaptureComplete2,CSL_EDMA3_CHA_6);
				break;
			case 3:
				nfaCaptureEDMATCCNumber[camIndex] = AllocEDMAInterruptHandler(NFA_CaptureComplete3,CSL_EDMA3_CHA_7);
				break;		
		}		
	}

	nfaRegionSetup.region = CSL_EDMA3_REGION_1;
	nfaRegionSetup.drae = 0xF0;   //edma channel 4,5,6,7 bit
	nfaRegionSetup.draeh= 0x0;

	ThreeDBufferCheckSW2 = 0;
	dstShiftCount = 0;

	NFA2DCameraAreaInfo.topPosition = 0;
	NFA2DCameraAreaInfo.bottomPosition = SYSTEM_CAMERA_HEIGHT;

	CSL_edma3HwControl(hNFAEdma,CSL_EDMA3_CMD_DMAREGION_ENABLE,&nfaRegionSetup);

	ExpectedRS232ReceiveDataCount = 0;
	ThreeDCameraCalibrationMode = 0;
	NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
}
//---------------------------------------------------------------------------
void NFA_Area_Cam_Setup(int	camIndex, int camPhysicalPos, int imageBufferIndex)
{	
	CSL_Status                  status; 
	int rFrameIndex;

	
	if (camPhysicalPos < 0 || camPhysicalPos >=	SYSTEM_SPB_CAMERA_MAX_COUNT) return;


	NFACaptureInfo[camIndex].CaptureReadLineCount = CAPUTRE_READ_LINE_COUNT_NFA;
	NFACaptureInfo[camIndex].HWCamIndex = camPhysicalPos;
	NFACaptureInfo[camIndex].ImageBufferIndex = imageBufferIndex;
	NFACaptureInfo[camIndex].CaptureErrorCount	= 0;

	NFACaptureInfo[camIndex].CaptureStep =	CAPTURE_STEP_NONE;
	NFACaptureInfo[camIndex].CaptureTimeout1ms	= 0;
	NFACaptureInfo[camIndex].CaptureTopPos = NFA_2D_CAPTURE_TOP_POS_FULL_CAPTURE;
	NFACaptureInfo[camIndex].FrameWidth = SYSTEM_CAMERA_WIDTH;
	NFACaptureInfo[camIndex].FrameHeight = SYSTEM_CAMERA_HEIGHT;
	NFACaptureInfo[camIndex].Capture_Temp_index = 0;

	NFACamEdmaParamSet[camIndex].option = CSL_EDMA3_OPT_MAKE( CSL_EDMA3_ITCCH_DIS, CSL_EDMA3_TCCH_DIS, CSL_EDMA3_ITCINT_DIS, CSL_EDMA3_TCINT_EN,\
                                              nfaCaptureEDMATCCNumber[camIndex], CSL_EDMA3_TCC_NORMAL, CSL_EDMA3_FIFOWIDTH_64BIT, CSL_EDMA3_STATIC_DIS, CSL_EDMA3_SYNC_A, CSL_EDMA3_ADDRMODE_INCR, CSL_EDMA3_ADDRMODE_INCR); 

	NFACamEdmaParamSet[camIndex].srcAddr= (Uint32) MMIO_FIFO_ADDR(camPhysicalPos);
	NFACamEdmaParamSet[camIndex].aCntbCnt	=  CSL_EDMA3_CNT_MAKE(NFA_HALF_FIFO_SIZE, 1);				 						
	NFACamEdmaParamSet[camIndex].srcDstBidx = CSL_EDMA3_BIDX_MAKE(8,0);     
	NFACamEdmaParamSet[camIndex].linkBcntrld = CSL_EDMA3_LINKBCNTRLD_MAKE(CSL_EDMA3_LINK_NULL,0);     
	NFACamEdmaParamSet[camIndex].srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,0);     
	NFACamEdmaParamSet[camIndex].cCnt = 1;
	
	for(rFrameIndex = 0; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
	{
		if(0)//(SystemSetupData.Laser_complexer_Enable==1)
		{
			NFA3DCamEdmaParamSet[camIndex][rFrameIndex].option = CSL_EDMA3_OPT_MAKE( CSL_EDMA3_ITCCH_DIS, CSL_EDMA3_TCCH_DIS, CSL_EDMA3_ITCINT_DIS, CSL_EDMA3_TCINT_DIS,\
                                  nfaCaptureEDMATCCNumber[camIndex], CSL_EDMA3_TCC_NORMAL, CSL_EDMA3_FIFOWIDTH_64BIT, CSL_EDMA3_STATIC_DIS, CSL_EDMA3_SYNC_A, CSL_EDMA3_ADDRMODE_INCR, CSL_EDMA3_ADDRMODE_INCR); 
		}
		else
		{
			NFA3DCamEdmaParamSet[camIndex][rFrameIndex].option = CSL_EDMA3_OPT_MAKE( CSL_EDMA3_ITCCH_DIS, CSL_EDMA3_TCCH_DIS, CSL_EDMA3_ITCINT_DIS, CSL_EDMA3_TCINT_EN,\
                                              nfaCaptureEDMATCCNumber[camIndex], CSL_EDMA3_TCC_NORMAL, CSL_EDMA3_FIFOWIDTH_64BIT, CSL_EDMA3_STATIC_DIS, CSL_EDMA3_SYNC_A, CSL_EDMA3_ADDRMODE_INCR, CSL_EDMA3_ADDRMODE_INCR); 
		}
		NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr= (Uint32) Capture_Temp_Buffer[0];	
		NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt	=  CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);				 						
		NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcDstBidx = CSL_EDMA3_BIDX_MAKE(8,0);     
		NFA3DCamEdmaParamSet[camIndex][rFrameIndex].linkBcntrld = CSL_EDMA3_LINKBCNTRLD_MAKE(CSL_EDMA3_LINK_NULL,0);     
		NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,0);     
		NFA3DCamEdmaParamSet[camIndex][rFrameIndex].cCnt = 1;
	}
	
	if(nfaCaptureEDMATCCNumber[camIndex] < 32)
	{
		nfaRegionIntr[camIndex].region = CSL_EDMA3_REGION_1;
		nfaRegionIntr[camIndex].intr =  (0x1 << nfaCaptureEDMATCCNumber[camIndex]);
		nfaRegionIntr[camIndex].intrh =  0x0;
	}
	else
	{
		nfaRegionIntr[camIndex].region = CSL_EDMA3_REGION_1;
		nfaRegionIntr[camIndex].intr =  0x0;		
		nfaRegionIntr[camIndex].intrh = (0x1 << (nfaCaptureEDMATCCNumber[camIndex] - 32));
	}
	CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_ENABLE,&nfaRegionIntr[camIndex]); 

	hNFACamEdmaParam[camIndex] = CSL_edma3GetParamHandle(hNFAChannel[camIndex], nfaCaptureEDMAChannelNumber[camIndex], &status);
}
//---------------------------------------------------------------------------
void NFA_SetPartialCapture(int camIndex, int partialCaptureMode)
{

}
//---------------------------------------------------------------------------
void NFA_SetCaptureTime(int	camIndex)
{
//	SetShutterSpeed(NFACaptureInfo[camIndex].HWCamIndex, NFACaptureInfo[camIndex].ShutterSpeed);
}
//---------------------------------------------------------------------------
int	NFA_Frame2DCaptureTrigger(int camIndex, unsigned char *captureImage, int *ptrStatus)
{
	TNFACaptureInfo *captureInfo;
	CSL_Edma3CmdIntr            regionIntr;
	CSL_Status                  status;
	CSL_IntcGlobalEnableState 	state;

	captureInfo	= &NFACaptureInfo[camIndex];
	if (captureInfo->CaptureStep !=	CAPTURE_STEP_NONE)
	{
		return -1;
	}
	
	CSL_intcGlobalDisable(&state);	

	if (ptrStatus != NULL)
	{
		captureInfo->CaptureStatusPtr =	ptrStatus;
	}
	else
	{
		captureInfo->CaptureStatusPtr =	&NFAUnHandledStatus;
	}

	NFA_SetImageArea(camIndex);

	captureInfo->CaptureTimeout1ms = CAPTURE_READ_TIMEOUT +	captureInfo->ShutterSpeed/1000;
	captureInfo->CaptureStep = CAPTURE_STEP_ON_CAPTURE;
	*(captureInfo->CaptureStatusPtr) = CAPTURE_STATUS_ON_CAPTURE;
	captureInfo->DMATriggerCount = ((NFACaptureInfo[camIndex].FrameWidth * (NFACaptureInfo[camIndex].FrameHeight - NFACaptureInfo[camIndex].CaptureTopPos)) / NFA_HALF_FIFO_SIZE)-1;
	NFACamEdmaParamSet[camIndex].aCntbCnt = CSL_EDMA3_CNT_MAKE(NFA_HALF_FIFO_SIZE, 1);
	NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) (captureImage + captureInfo->CaptureTopPos * NFACaptureInfo[camIndex].FrameWidth);
	CapturedImageStAddress[camIndex] = (Uint32) (captureImage + captureInfo->CaptureTopPos * NFACaptureInfo[camIndex].FrameWidth);

	CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);

	captureInfo->CaptureStartTime = Board1MSTmr;

	NFA_SET_BIT(NFA_triger,camIndex);
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
	cam_trig_count[camIndex]++;	
//	Lamp2Toggle();
	CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_ENABLE,&nfaRegionIntr[camIndex]);
	CSL_intcGlobalEnable(&state);	
	return 0;
}
//---------------------------------------------------------------------------
int	NFA_LineScan3DCaptureTrigger(int camIndex, unsigned char *captureImage, int *ptrStatus)
{
	return NFA3D_Streaming_Control_RegisterFrame(camIndex, captureImage, ptrStatus);
}
//---------------------------------------------------------------------------

void NFA_SetImageArea(int camIndex)
{
	int ImageTopPos, ImageHeight;
	int CaptureKind;


	if(SystemSetupData.CameraKind[camIndex] == CAMERA_KIND_NFA_3D)
	{
		CaptureKind = NFACaptureInfo[camIndex].CaptureKind;

		NFACaptureInfo[camIndex].CaptureTopPos = 0;

		if(CaptureKind == CAPTURE_KIND_FRAME)
		{
			NFACaptureInfo[camIndex].FrameWidth = NFA_3D_FRAME_WIDTH;
			NFACaptureInfo[camIndex].FrameHeight = NFA_3D_FRAME_HEIGHT;
		}
		else
		{
			NFACaptureInfo[camIndex].FrameWidth = NFA_3D_LINE_WIDTH;
			NFACaptureInfo[camIndex].FrameHeight = NFA_3D_LINE_HEIGHT;
		}
	}
}
//---------------------------------------------------------------------------
void NFA_2D_CaptureSetup(int camIndex, unsigned short shutterSpeed, int CaptureKind, unsigned char SubSamplingMode)
{
	NFACaptureInfo[camIndex].CaptureKind = CaptureKind;
	NFACaptureInfo[camIndex].Camera_kind = CAMERA_KIND_NFA_2D;
	NFACaptureInfo[camIndex].ShutterSpeed = shutterSpeed;

	if(SubSamplingMode)
	{	
		AllocateImageBuffer(camIndex, SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT);
		if(SystemSetupData.CameraKind[camIndex] == CAMERA_KIND_NFA_2D)
		{
			if(SPBTabletProcessInfo.CaptureMode == MACHINE_CAPTURE_MODE_PROCESSING && SPBTabletProcessInfo.ProcessingMode == TABLET_PROCESSING_MODE_INSPECTION)
			{
				NFACaptureInfo[camIndex].FrameWidth = SYSTEM_CAMERA_HD_WIDTH;
				NFACaptureInfo[camIndex].FrameHeight = NFA2DCameraAreaInfo.bottomPosition;
				NFACaptureInfo[camIndex].CaptureTopPos = NFA2DCameraAreaInfo.topPosition;
				
			}
			else
			{
				NFACaptureInfo[camIndex].FrameWidth = SYSTEM_CAMERA_HD_WIDTH;
				NFACaptureInfo[camIndex].FrameHeight = SYSTEM_CAMERA_HD_HEIGHT;
				NFACaptureInfo[camIndex].CaptureTopPos = 0;
			}
		}
	}
	else
	{
		AllocateImageBuffer(camIndex, SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT);
		if(SystemSetupData.CameraKind[camIndex] == CAMERA_KIND_NFA_2D)
		{
			if(SPBTabletProcessInfo.CaptureMode == MACHINE_CAPTURE_MODE_PROCESSING && SPBTabletProcessInfo.ProcessingMode == TABLET_PROCESSING_MODE_INSPECTION)
			{
				NFACaptureInfo[camIndex].FrameWidth = SYSTEM_CAMERA_WIDTH;
				NFACaptureInfo[camIndex].FrameHeight = NFA2DCameraAreaInfo.bottomPosition / 2;
				NFACaptureInfo[camIndex].CaptureTopPos = NFA2DCameraAreaInfo.topPosition / 2;
			}
			else
			{
				NFACaptureInfo[camIndex].FrameWidth = SYSTEM_CAMERA_WIDTH;
				NFACaptureInfo[camIndex].FrameHeight = SYSTEM_CAMERA_HEIGHT;
				NFACaptureInfo[camIndex].CaptureTopPos = 0;
			}				
		}
	}
}
//---------------------------------------------------------------------------
void NFA_3D_CaptureSetup(int camIndex, unsigned short shutterSpeed, int CaptureKind, int trigFreq)
{
	
	Set_3D_LineScanTime(trigFreq, camIndex);
	
	if(CaptureKind == CAPTURE_KIND_FRAME)
	{
		AllocateImageBuffer(camIndex, NFA_3D_MAX_IMAGE_SIZE);
		CHANGE_2D3D_REG = 0x00;
	}
	else
	{
		AllocateImageBuffer(camIndex, SYSTEM_CAMERA_WIDTH_3D * SYSTEM_CAMERA_HEIGHT_3D);
		CHANGE_2D3D_REG = (0x01 << camIndex);
	}

	NFACaptureInfo[camIndex].CaptureKind = CaptureKind;
	NFACaptureInfo[camIndex].Camera_kind = CAMERA_KIND_NFA_3D;
	NFACaptureInfo[camIndex].ShutterSpeed = shutterSpeed;
	NFACaptureInfo[camIndex].LineScanTime = trigFreq;

	ThreeDBufferCheckSW = ThreeDBufferCheckSW2 = 0;
	if(CameraSetupData.CameraEnable[camIndex] ==1)
	{
		if(CaptureKind == CAPTURE_KIND_LINE)
		{
			NFA3D_Streaming_Control_Close(camIndex);
			NFA3D_Streaming_Control_Clear(camIndex);
			NFA3D_Streaming_Control_Open(camIndex);
		}
		else
		{
			NFA3D_Streaming_Control_Close(camIndex);
			NFA3D_Streaming_Control_Clear(camIndex);	
		}
	}
}

void NFA_3D_SensorModeOn(int trigFreq)
{
	int camIndex;
	for(camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_MAX_COUNT ; camIndex++)
	{
		if(init_camera_type[camIndex] == CAMERA_KIND_NFA_3D)
		{
			NFA3D_Streaming_Control_Close(camIndex);
			NFA3D_Streaming_Control_Clear(camIndex);
			SetWaveTable(camIndex,3);	
			Init3DOutPutMode(camIndex);		
			Set_3D_LineScanTime(trigFreq, camIndex);
			CHANGE_2D3D_REG = (0x01 << camIndex);
			NFACaptureInfo[camIndex].LineScanTime = trigFreq;

			NFA3D_Streaming_Control_Open(camIndex);
			break;
		}			
	}
}

void NFA_3D_SensorModeOff()
{
	int camIndex;

	// Capture Stop ߻ϸ Sensor  initial
	Sensor_3d_Status = SENSOR_3D_STATUS_OFF;
	check_3d_image = 0; 
	// end

	for(camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_MAX_COUNT ; camIndex++)
	{
		if(init_camera_type[camIndex] == CAMERA_KIND_NFA_3D)
		{
			NFA3D_Streaming_Control_Close(camIndex);
			NFA3D_Streaming_Control_Clear(camIndex);
			return ;
		}
	}
}

//---------------------------------------------------------------------------
int	NFA_FrameCaptureStart(int camIndex, unsigned short shutterSpeed,	unsigned char *captureImage, int *ptrStatus)
{
	return NFA_Frame2DCaptureTrigger(camIndex,	captureImage, ptrStatus);
}
//---------------------------------------------------------------------------
int	NFA_LineCaptureStart(int camIndex, unsigned	short shutterSpeed,	unsigned char *captureImage, int *ptrStatus)
{
	return NFA_LineScan3DCaptureTrigger(camIndex, captureImage, ptrStatus);
}
//---------------------------------------------------------------------------
void NFA_CaptureStop(int camIndex)
{
	if (NFACaptureInfo[camIndex].CaptureStep != CAPTURE_STEP_NONE)
	{
		CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_DISABLE,&nfaRegionIntr[camIndex]); 
//		CSL_edma3HwChannelControl (hNFAChannel[camIndex], CSL_EDMA3_CMD_CHANNEL_DISABLE, NULL);
		CaptureStopOne(camIndex);
	}
	else
	{
		NFA_RESET_BIT(NFA_triger,camIndex);
		NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
	}

	NFACaptureInfo[camIndex].CaptureStep = CAPTURE_STEP_NONE;
	ThreeDBufferCheckSW = ThreeDBufferCheckSW2 = 0;
}
//---------------------------------------------------------------------------
void NFA_CaptureAbort(int camIndex)
{
	if (NFACaptureInfo[camIndex].CaptureStep != CAPTURE_STEP_NONE)
	{
		CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTRPEND_CLEAR,&nfaRegionIntr[camIndex]); 
		CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_DISABLE,&nfaRegionIntr[camIndex]); 
//		CSL_edma3HwChannelControl (hNFAChannel[camIndex], CSL_EDMA3_CMD_CHANNEL_DISABLE, NULL);
		CaptureStopOne(camIndex);
	}
	NFACaptureInfo[camIndex].CaptureTimeout1ms	= 0;
	NFACaptureInfo[camIndex].CaptureStep = CAPTURE_STEP_NONE;
	NFACaptureInfo[camIndex].CaptureErrorCount++;
	
}
//---------------------------------------------------------------------------
// check capture timeout
void NFA_Capture_Process(void)
{
	int	camIndex;
	TNFACaptureInfo *captureInfo;
	unsigned int frmCount;
	int rFrameIndex;

	for	(camIndex =	0; camIndex	< SYSTEM_SPB_CAMERA_MAX_COUNT; camIndex++)
	{
		captureInfo	= &NFACaptureInfo[camIndex];
		if (captureInfo->CaptureKind == CAPTURE_KIND_FRAME)
		{
			if (captureInfo->CaptureStep !=	CAPTURE_STEP_NONE)
			{
				if (captureInfo->CaptureTimeout1ms)
				{
					captureInfo->CaptureTimeout1ms--;
				}
				else
				{		
					NFA_CaptureAbort(camIndex);
					ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL,	ERROR_CODE_CAPTURE_TIMEOUT,	camIndex, NFACaptureInfo[camIndex].DMATriggerCount,	cam_timeout_cnt[camIndex]++);
					*(captureInfo->CaptureStatusPtr) = CAPTURE_STATUS_TIMEOUT;
					CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_DISABLE,&nfaRegionIntr[camIndex]); 
				}
			}
		}
		else
		{
			if(0)//(SystemSetupData.Laser_complexer_Enable==1)
			{
				rFrameIndex = NFACaptureInfo[camIndex].CurrentCaptureFrameIndex;
				if (captureInfo->CaptureStep !=	CAPTURE_STEP_NONE)
				{
					if (captureInfo->RegisteredFrame[rFrameIndex].Registered)
					{
						if (captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms)
						{
							captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms--;
							if (captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms == 0)
							{
								*(captureInfo->RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_TIMEOUT;
								captureInfo->RegisteredFrame[rFrameIndex].Registered = 0;
								ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_CAPTURE_TIMEOUT, camIndex, captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain, cam_timeout_cnt[camIndex]++);
							}
						}
					}
				}
			}
			else
			{
				if (captureInfo->CaptureStep !=	CAPTURE_STEP_NONE)
				{
					for (rFrameIndex = 0; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
					{
						if (captureInfo->RegisteredFrame[rFrameIndex].Registered)
						{
							if (captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms)
							{
								captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms--;
								if (captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms == 0)
								{
									// timeout
									NFA3D_Streaming_Control_Close(camIndex);
									NFA3D_Streaming_Control_Open(camIndex);
									*(captureInfo->RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_TIMEOUT;
									captureInfo->RegisteredFrame[rFrameIndex].Registered = 0;
									ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_CAPTURE_TIMEOUT, camIndex, captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain, cam_timeout_cnt[camIndex]++);
								}
							}
						}
					}
				}		
			}
		}
	}
}

//---------------------------------------------------------------------------
int	NFA_GetCameraStatus(int	camIndex)
{
	switch (NFACaptureInfo[camIndex].CaptureStep)
	{
		case CAPTURE_STEP_NONE:
			return CAMERA_STATUS_READY;
		case CAPTURE_STEP_ON_CAPTURE:
			return CAMERA_STATUS_ON_CAPTURE;
	}
	return CAMERA_STATUS_NONE;
}
//---------------------------------------------------------------------------
void NFA_CaptureComplete0(void)
{
	int camIndex = 0;
	int rFrameIndex;
	int delay = 0;
	int delay_line= 0;
	int i = 0;

	cam_int_count[camIndex]++;
	if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
	{
		if (NFACaptureInfo[camIndex].DMATriggerCount == 0)
		{
			cam_complete_count[camIndex]++;
			CaptureStopOne(NFACaptureInfo[camIndex].HWCamIndex);
			
			*(NFACaptureInfo[camIndex].CaptureStatusPtr) = CAPTURE_STATUS_COMPLETE;
			NFACaptureInfo[camIndex].CaptureStep = CAPTURE_STEP_NONE;	
			NFACaptureInfo[camIndex].DMATriggerCount = ((NFACaptureInfo[camIndex].FrameWidth * (NFACaptureInfo[camIndex].FrameHeight - NFACaptureInfo[camIndex].CaptureTopPos)) / NFA_HALF_FIFO_SIZE)-1;
		}
		else
		{
			NFACaptureInfo[camIndex].DMATriggerCount--;
		}
	}
	else
	{
		if(0)//(SystemSetupData.Laser_complexer_Enable==1) && !ThreeDCameraCalibrationMode)
		{
			check_3d_image = camIndex+1;
		}
		else
		{
			if(!ThreeDBufferCheckSW2)
			{
				for (rFrameIndex = NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
				{
					if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
					{
						if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain == 0)
						{
							if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
								*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
						}
						else
						{
							if((Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > CameraSetupData.ShutterDelay[camIndex]+12)  && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
							{
								delay = Board50usTimer - (SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex].CaptureIntTime +CameraSetupData.ShutterDelay[camIndex]+ 13);
								if(delay < 0) delay = 0;
								delay_line = (delay*0.5);
							}
							else 
							{
								delay = 0;
								delay_line = 0;
							}
							
							
							if(delay_line > 0)
							{
								NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+= 960*delay_line;
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
	
							}
							else
							{
								if(Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > (CameraSetupData.ShutterDelay[camIndex] + 20) && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
								{
									NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+=9600;
									delay = 40;
								}
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (Uint32) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
							}	
							
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32) Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr += (Uint32) NFA3D_HALF_FIFO_SIZE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain--;
							NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = rFrameIndex;
							CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
							CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);	
							break;
						}	
					}
				}
				if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT)	// registered frame does not exist or all frame(s) have been written
				{
					NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = -1;
					CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
				}
			}
		}
	}
}

void NFA_CaptureComplete1(void)
{
	int camIndex = 1;
	int rFrameIndex;
	int delay = 0;
	int delay_line= 0;	
	int i = 0;
	cam_int_count[camIndex]++;
	if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
	{
		if (NFACaptureInfo[camIndex].DMATriggerCount == 0)
		{
			cam_complete_count[camIndex]++;
			CaptureStopOne(NFACaptureInfo[camIndex].HWCamIndex);
			*(NFACaptureInfo[camIndex].CaptureStatusPtr) = CAPTURE_STATUS_COMPLETE;
			NFACaptureInfo[camIndex].CaptureStep = CAPTURE_STEP_NONE;	
		}
		else
		{
			NFACaptureInfo[camIndex].DMATriggerCount--;
		}
	}
	else
	{
		if(0)//(SystemSetupData.Laser_complexer_Enable==1)&& !ThreeDCameraCalibrationMode)
		{
			check_3d_image = camIndex+1;
		}
		else
		{
			if(!ThreeDBufferCheckSW2)
			{
				for (rFrameIndex = NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
				{
					if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
					{
						if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain == 0)
						{
							if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
								*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
						}
						else
						{
							if((Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > CameraSetupData.ShutterDelay[camIndex]+12)  && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
							{
								delay = Board50usTimer - (SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex].CaptureIntTime +CameraSetupData.ShutterDelay[camIndex]+ 13);
								if(delay < 0) delay = 0;
								delay_line = (delay*0.5);
							}
							else 
							{
								delay = 0;
								delay_line = 0;
							}
							
							
							if(delay_line > 0)
							{
								NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+= 960*delay_line;
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
	
							}
							else
							{
								if(Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > (CameraSetupData.ShutterDelay[camIndex] + 20) && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
								{
									NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+=9600;
									delay = 40;
								}
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (Uint32) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
							}	
							
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32) Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr += (Uint32) NFA3D_HALF_FIFO_SIZE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain--;
							NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = rFrameIndex;
							CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
							CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);	
							break;
						}	
					}
				}
				if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT)	// registered frame does not exist or all frame(s) have been written
				{
					NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = -1;
					CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
				}
			}
			
		}
	}
}

void NFA_CaptureComplete2(void)
{
	int camIndex = 2;
	int rFrameIndex;
	int delay = 0;
	int delay_line= 0;
	int i = 0;
	cam_int_count[camIndex]++;
	if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
	{
		if (NFACaptureInfo[camIndex].DMATriggerCount == 0)
		{
			cam_complete_count[camIndex]++;
			CaptureStopOne(NFACaptureInfo[camIndex].HWCamIndex);
			*(NFACaptureInfo[camIndex].CaptureStatusPtr) = CAPTURE_STATUS_COMPLETE;
			NFACaptureInfo[camIndex].CaptureStep = CAPTURE_STEP_NONE;	
		}
		else
		{
			NFACaptureInfo[camIndex].DMATriggerCount--;
		}
	}
	else
	{
		if(0)//(SystemSetupData.Laser_complexer_Enable==1) && !ThreeDCameraCalibrationMode)
		{
			check_3d_image = camIndex+1;
		}
		else
		{
			if(!ThreeDBufferCheckSW2)
			{
				for (rFrameIndex = NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
				{
					if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
					{
						if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain == 0)
						{
							if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
								*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
						}
						else
						{
							if((Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > CameraSetupData.ShutterDelay[camIndex]+12)  && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
							{
								delay = Board50usTimer - (SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex].CaptureIntTime +CameraSetupData.ShutterDelay[camIndex]+ 13);
								if(delay < 0) delay = 0;
								delay_line = (delay*0.5);
							}
							else 
							{
								delay = 0;
								delay_line = 0;
							}
							
							
							if(delay_line > 0)
							{
								NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+= 960*delay_line;
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
	
							}
							else
							{
								if(Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > (CameraSetupData.ShutterDelay[camIndex] + 20) && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
								{
									NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+=9600;
									delay = 40;
								}
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (Uint32) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
							}	
							
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32) Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr += (Uint32) NFA3D_HALF_FIFO_SIZE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain--;
							NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = rFrameIndex;
							CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
							CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);	
							break;
						}	
					}
				}
				if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT)	// registered frame does not exist or all frame(s) have been written
				{
					NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = -1;
					CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
				}
			}
			
		}
	}
}

void NFA_CaptureComplete3(void)
{
	int camIndex = 3;
	int rFrameIndex;
	int delay = 0;
	int delay_line= 0;
	int i = 0;
	
	cam_int_count[camIndex]++;
	if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
	{
		if (NFACaptureInfo[camIndex].DMATriggerCount == 0)
		{
			cam_complete_count[camIndex]++;
			CaptureStopOne(NFACaptureInfo[camIndex].HWCamIndex);
			*(NFACaptureInfo[camIndex].CaptureStatusPtr) = CAPTURE_STATUS_COMPLETE;
			NFACaptureInfo[camIndex].CaptureStep = CAPTURE_STEP_NONE;	
		}
		else
		{
			NFACaptureInfo[camIndex].DMATriggerCount--;
		}
	}
	else
	{
		if(0)//(SystemSetupData.Laser_complexer_Enable==1) && !ThreeDCameraCalibrationMode)
		{
			check_3d_image = camIndex+1;
		}
		else
		{
			if(!ThreeDBufferCheckSW2)
			{
				for (rFrameIndex = NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
				{
					if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
					{
						if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain == 0)
						{
							if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
								*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
						}
						else
						{
							if((Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > CameraSetupData.ShutterDelay[camIndex]+12)  && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
							{
								delay = Board50usTimer - (SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex].CaptureIntTime +CameraSetupData.ShutterDelay[camIndex]+ 13);
								if(delay < 0) delay = 0;
								delay_line = (delay*0.5);
							}
							else 
							{
								delay = 0;
								delay_line = 0;
							}
							
							
							if(delay_line > 0)
							{
								NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+= 960*delay_line;
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
	
							}
							else
							{
								if(Board50usTimer- SPBTabletProcessInfo.TabletList[NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].ThreeDCaptureIndex ].CaptureIntTime > (CameraSetupData.ShutterDelay[camIndex] + 20) && NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain==32)
								{
									NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+=9600;
									delay = 40;
								}
								NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (Uint32) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
							}	
							
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32) Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
							NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr += (Uint32) NFA3D_HALF_FIFO_SIZE;
							NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain--;
							NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = rFrameIndex;
							CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
							CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);	
							break;
						}	
					}
				}
				if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT)	// registered frame does not exist or all frame(s) have been written
				{
					NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = -1;
					CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
				}
			}
			
		}
	}
}

void NFACamera_Init()
{	
	int i,j;
	int result = 0;
	
	NFA_RS232_Init(); // RS232 ʱȭ
	NFA_Hardware_Init(); // ϵ ʱȭ 
	Process_Parameter_clear();

	NFA_CAMERA_CONTROL_TRIG = 0x0010;
	NFA_FIFO_ENABLE = 0x0000;
	NFA_FIFO_RESET = 0x00FF;

	camera_cnt = 1;
		
	// Received Borad Camera ID Set
	for(i = 0 ; i < SYSTEM_SPB_CAMERA_MAX_COUNT;i ++)
	{
		NFA_CAMERA_ID(i) = 0x31+i;
	}

	
	if (NFA_CAMERA_RX_CONTROL_REG & ((0x1<<RX_CONTROL_HOT_PLUG_DETECT_1_BIT )|(0x1<<RX_CONTROL_HOT_PLUG_DETECT_2_BIT ))) // Cable Hot Plug Detection//0.1ms 
	{	
		if(!Uart_connectction_enable())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Camera_id_set())
			{
			Camera_Init_Error();
			return ;
			}
			
		if(!Camera_hardware_reset())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Camera_output_enable())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Polarity_request())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Polarity_set())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Valid_line_number_set())
		{
			Camera_Init_Error();
			return ;
			}
		
		if(!Trigger_line_check())
			{
			Camera_Init_Error();
			return ;
		}			
		
		NFA_FIFO_ENABLE = 0x00;
		NFA_FIFO_RESET = 0x00;
		NFA_FIFO_RESET = 0xFF;
		NFA_FIFO_ENABLE = 0x00;		
		NFA_CAMERA_CONTROL_TRIG = 0x8000;
	
		for(i = 0; i < SYSTEM_SPB_CAMERA_MAX_COUNT ; i++)
		{
			if(init_camera_type[i]== CAMERA_KIND_NFA_2D)
			{
				NFA_Frame2DCaptureTrigger(i,InvalidImage,NULL);
			}

			if(init_camera_type[i] == CAMERA_KIND_NFA_3D)
			{
				
				SetWaveTable(i,3);	
				Init3DOutPutMode(i);			
				THREED_CAMERA_SENSOR = 3;						
			}		
		}
		cam_init_complete = 1;
		
	}
	else
	{
		printf("Camera HOT_PLUG_DETECT Error!!\n");
	}	
}

void NFA_RS232_Init()
{
	int dummy;
	NFA_RS232_BAUDRATE_REG = (NFA_CAMERA_CLK / NFA_CAMERA_BAUDRATE) - 1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	
	NFA_RS232_STATUS_CONTROL_REG = 0x0;
	
	while(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT)) dummy = NFA_RS232_DATA_REG;
	while(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT));
}
void NFA_Hardware_Init()
{
	//RX
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_RESET_BIT);
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_VLN_RESET_BIT);
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_PACKET_ERR_RESET_BIT);
	
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_RESET_BIT);
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_VLN_RESET_BIT);
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_PACKET_ERR_RESET_BIT);

	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_ENABLE_BIT);

	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_RESET_BIT);     
	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_DISPARITY_ERR_RESET_BIT);  
	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_10TO8_ERR_RESET_BIT);  
	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_CHANNEL_BOND_ERR_BIT);

	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_RESET_BIT);     
	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_DISPARITY_ERR_RESET_BIT);  
	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_10TO8_ERR_RESET_BIT);  
	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_CHANNEL_BOND_ERR_BIT);
}

void Process_Parameter_clear()
{
	camera_init_current_time = Board1MSTmr;
	init_Process = NFA_INIT_HOT_FLUG_DETECT_DONE;
	Uart_process = UART_READY;
	Uart_Polarity = 0;
}

int Uart_connectction_enable()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x05;
				NFACommendTx[camIndex].Data[0]= 0x00;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];			
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if(camera_init_current_time + 10 < Board1MSTmr)
				{
					if(Uart_Polarity)
					{
						NFA_CAMERA_RX_POLARITY_REG &= 0x0fff;
						NFA_CAMERA_RX_POLARITY_REG |= 0x5000;
						Uart_process = UART_READY;
						Uart_Polarity = 0;
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
					}
					else
					{
						NFA_CAMERA_RX_POLARITY_REG &= 0x0fff;
						NFA_CAMERA_RX_POLARITY_REG |= 0xA000;
						Uart_process = UART_READY;
						Uart_Polarity = 1;
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);					
					}
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}


int Camera_id_set()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x7B;
				NFACommendTx[camIndex].Data[0]= 0x01;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];			
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}


int Camera_hardware_reset()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x01;
				NFACommendTx[camIndex].Data[0]= 0x00;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];			
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

int Camera_output_enable()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x10;
				NFACommendTx[camIndex].Data[0]= 0x00;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];				
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

int Polarity_request()
{

	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
				Sleep(10);
				NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x20;
				NFACommendTx[camIndex].Data[0]=  0x00;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];				
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				camera_rData =(NFA_CAMERA_POLARITY_STATUS_REG >> 8) & 0x0F;
				NFA_CAMERA_RX_CORE_REG = (NFA_CAMERA_RX_CORE_REG & 0xFF0F)|(camera_rData << 4);
				NFA_CAMERA_RX_POLARITY_REG = ( NFA_CAMERA_RX_POLARITY_REG & 0xFFF0 ) | camera_rData;
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
	
}
int Polarity_set()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x22;
				NFACommendTx[camIndex].Data[0]=  0x00;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];			
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}


int Valid_line_number_set()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx[camIndex].Length[0] = 0x01;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6A;
				NFACommendTx[camIndex].Code2= 0x25;
				NFACommendTx[camIndex].Data[0]=  0x00;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];	
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];
						Uart_process = UART_CAMERA_ID_CHECK;
						
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if(Uart_process == UART_CAMERA_ID_CHECK)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>9)
					{
						i =0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];
						NFACommendRx[camIndex].Data[1]= temp[7];				
						NFACommendRx[camIndex].Tail= temp[8];
						NFACommendRx[camIndex].chksum= temp[9];
						if(NFACommendRx[camIndex].Data[1] == 2)
						{ 
							init_camera_type[camIndex] = 2;
//							printf("%d Cam is 2D Cam\n",NFACommendRx[camIndex].Data1);
						}
						else
						{
							init_camera_type[camIndex] = 3;
//							printf("%d Cam is 3D Cam\n",NFACommendRx[camIndex].Data1);
						}
						if(camera_cnt != Selma200CameraCount)
						{
							camera_cnt++;
							camera_init_current_time = Board1MSTmr;
						}
						else
						{
							Uart_process = UART_COMPLETE;							
						}
					}
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT*3)<Board1MSTmr)
				{
					Uart_process = UART_COMPLETE;
					camera_cnt--;
				}
			}

			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				link_camera_count = camera_cnt;
				camera_cnt = 1;
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

int Trigger_line_check()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_CAMERA_CONTROL_TRIG = 0x8000;

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{				
// jhkim 230724
#if 0 // OLD Versio 2.4
                Lamp2Toggle();
                NFA_RESET_BIT(NFA_triger,camIndex);
                NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
//                printf("%d camera Read current pola check\n", camera_cnt);
                Lamp2Toggle();
                NFA_SET_BIT(NFA_triger,camIndex);
                NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;               
                Lamp2Toggle();
                NFA_RESET_BIT(NFA_triger,camIndex);
                NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
#else // New Version  3.0
                Lamp2Toggle();
                NFA_RESET_BIT(NFA_triger,camIndex);
                if(init_camera_type[camIndex] != CAMERA_KIND_NFA_3D)
                {
                    NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
                }
//                printf("%d camera Read current pola check\n", camera_cnt);
                Lamp2Toggle();
                NFA_SET_BIT(NFA_triger,camIndex);
                if(init_camera_type[camIndex] != CAMERA_KIND_NFA_3D)
                {
                    NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
                }
                Lamp2Toggle();
                NFA_RESET_BIT(NFA_triger,camIndex);
                if(init_camera_type[camIndex] != CAMERA_KIND_NFA_3D)
                {
                    NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
                }
#endif                           
                Sleep(100);
                NFACommendTx[camIndex].Length[0] = 0x02;
                NFACommendTx[camIndex].Length[1] = 0x00;
                NFACommendTx[camIndex].Code1= 0x6C;
                NFACommendTx[camIndex].Code2= 0x62;
                NFACommendTx[camIndex].Data[0]=  0x40;
                NFACommendTx[camIndex].Data[1]=  0x90;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>11)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];
						NFACommendRx[camIndex].Data[1]= temp[7];	
						NFACommendRx[camIndex].Data[2]= temp[8];	
						NFACommendRx[camIndex].Data[3]= temp[9];	
						NFACommendRx[camIndex].Tail= temp[10];
						NFACommendRx[camIndex].chksum= temp[11];
						if(init_camera_type[camIndex] == 2){
							if( NFACommendRx[camIndex].Data[1] != 0 && NFACommendRx[camIndex].Data[1] != 32 )
							{
//								printf("%d camera pola change\n", camera_cnt);
								Uart_process = UART_CAMERA_POLARITY_CHANGE_SEND;
								if(NFACommendRx[camIndex].Data[0]&0x02)
								{
									NFACommendTx[camIndex].Data[2] = camIndex*16 + 0x8; //
									NFACommendTx[camIndex].Data[3] = 0x00;
									NFACommendTx[camIndex].Data[4] = 0x00;
									NFACommendTx[camIndex].Data[5] = 0x00;
								}
								else
								{
									NFACommendTx[camIndex].Data[2] = camIndex*16 + 0x8 + 0x02; //
									NFACommendTx[camIndex].Data[3] = 0x00;
									NFACommendTx[camIndex].Data[4] = 0x00;
									NFACommendTx[camIndex].Data[5] = 0x00;
								}								
							}
							else 
							{					
								Uart_process = UART_CAMERA_POLARITY_CHANGE_SEND;
								if(NFACommendRx[camIndex].Data[0]&0x02){
									NFACommendTx[camIndex].Data[2] = camIndex*16 + 0x8+ 0x02; //
									NFACommendTx[camIndex].Data[3] = 0x00;
									NFACommendTx[camIndex].Data[4] = 0x00;
									NFACommendTx[camIndex].Data[5] = 0x00;
								}
								else
								{
									NFACommendTx[camIndex].Data[2] = camIndex*16 + 0x8; //
									NFACommendTx[camIndex].Data[3] = 0x00;
									NFACommendTx[camIndex].Data[4] = 0x00;
									NFACommendTx[camIndex].Data[5] = 0x00;
								}
							}
						}
						else
						{
							Uart_process = UART_CAMERA_POLARITY_CHANGE_DONE;
						}
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if(Uart_process == UART_CAMERA_POLARITY_CHANGE_SEND)
			{
				//set command
				NFACommendTx[camIndex].Length[0] = 0x06;
				NFACommendTx[camIndex].Length[1] = 0x00;
				NFACommendTx[camIndex].Code1= 0x6C;
				NFACommendTx[camIndex].Code2= 0x61;
				NFACommendTx[camIndex].Data[0]=  0x40;
				NFACommendTx[camIndex].Data[1]=  0x90;

				//make checksum
				NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[5];				
				NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[5];
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
				NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;
				Uart_process = UART_CAMERA_POLARITY_CHANGE_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_CAMERA_POLARITY_CHANGE_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx[camIndex].Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];
						NFACommendRx[camIndex].Tail= temp[7];
						NFACommendRx[camIndex].chksum= temp[8];						
						Uart_process = UART_CAMERA_POLARITY_CHANGE_DONE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_CAMERA_POLARITY_CHANGE_DONE)
			{
				if(camera_cnt == link_camera_count)
				{
					Uart_process = UART_COMPLETE;
				}
				else
				{
					camera_cnt++;
					Uart_process = UART_READY;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;	
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

void Shutter_speed_change()
{
	int i;	
	camera_cnt = 1;
	while(1) 
	{
		if (!Uart_process)
		{		
			uart_txbuf[0] = 0xA1; uart_txbuf[1] = 0x02; uart_txbuf[2] = 0x00; uart_txbuf[3] = camera_cnt * 16;
			uart_txbuf[4] = 0x6C; uart_txbuf[5] = 0x46; uart_txbuf[6] = 0xE8; uart_txbuf[7] = 0x03;
			uart_txbuf[8] = 0xAE; uart_txbuf[9] = uart_txbuf[0];
			for (i = 1; i < 9; i++) uart_txbuf[9] ^= uart_txbuf[i];

			Uart_process = UART_TRANS;
			tx_ptr = 0;
			rx_ptr = 0;
		}
		else if (Uart_process == UART_TRANS)
		{
			if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty ?
			{
				NFA_RS232_DATA_REG = uart_txbuf[tx_ptr];
				tx_ptr++;
				if (tx_ptr>9)
				{
					Uart_process = UART_RECEIVE;
				}
			}
		}
		else if (Uart_process == UART_RECEIVE)
		{
			if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
			{
				uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
				if(uart_rxbuf[0] == 0xA1) {
					rx_ptr++;
				}
				if (rx_ptr>8)
				{
					Uart_process = UART_COMPLETE;	
//					printf("%d cam speed change\n", camera_cnt);				
				}
			}
			else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT/5)<Board1MSTmr)
			{
			Uart_process=UART_COMPLETE;
			}
		}
		else if (Uart_process == UART_COMPLETE)
		{
			if(camera_cnt == Selma200CameraCount) 
			{
		 		init_Process = NFA_INIT_SHUTTER_SPEED_DONE;	
				Uart_process = UART_READY;	
		        break;
			}	
			else {
				
				camera_cnt++;
				Uart_process = UART_READY;
			}		
		}
	}
}

void Camera_Init_Error()
{
	Uart_process = UART_READY;
	NFA_RS232_Init();
	NFA_Hardware_Init();
	Process_Parameter_clear();
}
//---------------------------------------------------------------------------
char *NFACameraControl(unsigned int SendDataLength, unsigned int ReceiveDataLength, char *SendData, int SkipDataReceiveSW)
{
	unsigned int sendtime;
	int CameraProcessingStep;
	int errorSW;

	memset(ReceivedData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

	sendtime = Board1MSTmr;
	CameraProcessingStep = UART_READY; 
	
	if(SkipDataReceiveSW == 0)
	{
		while(CameraProcessingStep != UART_COMPLETE) 
		{
			CameraProcessing(SendDataLength, ReceiveDataLength, SendData, ReceivedData, &CameraProcessingStep);
			
			if (Board1MSTmr - sendtime > 1000)
			{
				ReceivedData[0] = 'T';
				ReceivedData[1] = 'O';
				break;
			}
		}

		ExpectedRS232ReceiveDataCount = 0;
	}
	else
	{
		errorSW = 0;
		while(CameraProcessingStep <= UART_TRANS) 
		{
			CameraProcessing(SendDataLength, ReceiveDataLength, SendData, ReceivedData, &CameraProcessingStep);
			
			if (Board1MSTmr - sendtime > 1000)
			{
				ReceivedData[0] = 'T';
				ReceivedData[1] = 'O';
				errorSW = 1;
				break;
			}
		}

		if(!errorSW)
		{
			ExpectedRS232ReceiveDataCount = ReceiveDataLength;
			MakeIdleChannelProcessingStartTime = Board50usTimer;
		}
		else
		{
			ExpectedRS232ReceiveDataCount = 0;
		}
	}
	
	return ReceivedData;
}
//---------------------------------------------------------------------------
void CameraProcessing(unsigned int SendDataLength, unsigned int ReceiveDataLength, char *SendData, char *ReceiveData, int *CameraProcessingStep)
{
	int i;

	if(*CameraProcessingStep == UART_READY)
	{
		SendData[SendDataLength - 1] = 0xA1;

		for (i = 0; i < SendDataLength; i++)
			uart_txbuf[i] = SendData[i] & 0x000000FF; 

		for (i = 1; i < SendDataLength - 1; i++) 
			uart_txbuf[SendDataLength - 1] ^= uart_txbuf[i]; // check sum

		camera_init_current_time = Board1MSTmr;
		*CameraProcessingStep = UART_TRANS;
		tx_ptr = 0;
		rx_ptr = 0;

	}
	else if (*CameraProcessingStep == UART_TRANS)
	{
		if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty
		{
			NFA_RS232_DATA_REG = uart_txbuf[tx_ptr++];
			if (tx_ptr == SendDataLength)
			{
				*CameraProcessingStep = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
		}
		else
		{
			if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)  // decrement in 1msec timer routine
			{
				Camera_Init_Error();
			}
		}
	}
	else if (*CameraProcessingStep == UART_RECEIVE)
	{
		if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
		{
			uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
			if(uart_rxbuf[0] == 0xA1) {
				rx_ptr++;
			} 
			if (rx_ptr == ReceiveDataLength)
			{
				// return command м
				
				for (i = 0; i < ReceiveDataLength; i++)
					ReceiveData[i] = uart_rxbuf[i];
				*CameraProcessingStep = UART_COMPLETE;	
			}
		}
		else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
		{
			Camera_Init_Error();
		}
	}
}

void MakeIdleStatusRS232Channel()
{
	int dummyBuffer;

	if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
	{
		dummyBuffer = NFA_RS232_DATA_REG;

		ExpectedRS232ReceiveDataCount--;
	}

	if(Board50usTimer > MakeIdleChannelProcessingStartTime + MAX_RS232_RECEIVE_WAITING_TIME_US)
	{
		// 500ms µ Ͱ   ʾҴٸ Ͱ  ʴ  
		ExpectedRS232ReceiveDataCount = 0;
	}

	if(ExpectedRS232ReceiveDataCount == 0)
	{
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);	
	}
}

void CameraSubSamplingMode_set()
{
	int i,camIndex;
	camera_cnt = 1;
	if(Uart_process == UART_READY)
	{
		//Tx for valid Line Number setting
		uart_txbuf[0] = 0xA1; uart_txbuf[1] = 0x01; uart_txbuf[2] = 0x00; uart_txbuf[3] = camera_cnt*16;
		uart_txbuf[4] = 0x6C; uart_txbuf[5] = 0x22; uart_txbuf[6] = 0x03; uart_txbuf[7] = 0xAE;
		uart_txbuf[8] = uart_txbuf[0];
		for (i = 1; i < 8; i++) uart_txbuf[8] ^= uart_txbuf[i]; // check sum

		camera_init_current_time = Board1MSTmr;
		Uart_process = UART_TRANS;
		tx_ptr = 0;
		rx_ptr = 0;

	}
	else if (Uart_process == UART_TRANS)
	{
		if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty ?
		{
			NFA_RS232_DATA_REG = uart_txbuf[tx_ptr++];
			if (tx_ptr>8)
			{
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
		}
	}
	else if (Uart_process == UART_RECEIVE)
	{
		if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
		{
			uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
			if(uart_rxbuf[0] == 0xA1) {
				rx_ptr++;
			}
			if (rx_ptr>8)
			{
				// return command м
				Uart_process = 5;
				rx_ptr = 0;
			}
		}
		else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
		{
			Uart_process = UART_READY;
		}
	}

	else if(Uart_process == 5)
	{
		camera_cnt++;
		if(camera_cnt > Selma200CameraCount){
			Uart_process = UART_COMPLETE;
		}
		else if((camera_init_current_time+(NFA_CAMERA_TIMEOUT/5))<Board1MSTmr)
		{
			Uart_process = UART_COMPLETE;
		}		
	
	}
	else if (Uart_process == UART_COMPLETE)
	{
		init_Process = NFA_INIT_CAMERA_SUBSAMPLING_DONE;	
		Uart_process = UART_READY;
	}	
}

void Camera_triger_change()
{
	int i,camIndex;
	NFA_CAMERA_CONTROL_TRIG = 0x0020;
	Sleep(100);// 1 -> 100
	NFA_CAMERA_CONTROL_TRIG = 0x0000;
	if(Uart_process == UART_READY)
	{
		//Tx for valid Line Number setting
		uart_txbuf[0] = 0xA1; uart_txbuf[1] = 0x06; uart_txbuf[2] = 0x00; uart_txbuf[3] = 0x10;
		uart_txbuf[4] = 0x6C; uart_txbuf[5] = 0x61; uart_txbuf[6] = 0x40; uart_txbuf[7] = 0x00;
		uart_txbuf[8] = 0x18; uart_txbuf[9] = 0x00; uart_txbuf[10] = 0x00; uart_txbuf[11] = 0x00; 
		uart_txbuf[12] = 0xAE; uart_txbuf[13] = uart_txbuf[0];
		for (i = 1; i < 13; i++) uart_txbuf[13] ^= uart_txbuf[i]; // check sum

		camera_init_current_time = Board1MSTmr;
		Uart_process = UART_TRANS;
		tx_ptr = 0;
		rx_ptr = 0;
	}
	else if (Uart_process == UART_TRANS)
	{
		if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty ?
		{
			NFA_RS232_DATA_REG = uart_txbuf[tx_ptr++];
			if (tx_ptr>13)
			{
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
		}
	}
	else if (Uart_process == UART_RECEIVE)
	{
		if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
		{
			uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
			if(uart_rxbuf[0] == 0xA1) {
				rx_ptr++;
			}
			if (rx_ptr>8)
			{
				// return command м
				Uart_process = UART_COMPLETE;
				rx_ptr = 0;
				NFA_CAMERA_CONTROL_TRIG = 0x0020;
				Sleep(100);
				NFA_CAMERA_CONTROL_TRIG = 0x0000;
			}
		}
		else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
		{
			Uart_process = UART_READY;
		}
	}
	else if (Uart_process == UART_COMPLETE)
	{

		NFA_CAMERA_CONTROL_TRIG = 0x0020;
		Sleep(100);
		NFA_CAMERA_CONTROL_TRIG = 0x0000;
		init_Process = NFA_INIT_CAMERA_TRIGER_CHANGE_DONE;	
		Uart_process = UART_READY;
	}	
}

void hwiCapture0(void)
{
	int camIndex = 0;
//	if(!(NFA_triger&(0x1<<camIndex))) return;
	test_cam_count[camIndex]++;
	if(!(NFA_FIFO_HALF_STATUS_REG&(0x1<<camIndex))) 
	{
		cam_int_err[camIndex]++;
	}
	else
	{
		if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) NFA_HALF_FIFO_SIZE;
		}
		else
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			
			if(ThreeDBufferCheckSW2)
			{
				NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) FIFOReadSize;
				dstShiftCount++;

				if(dstShiftCount >= 60)
				{
					NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) ImageBuffer1;
					dstShiftCount = 0;
				}				
			}
			else
			{
				NFACaptureInfo[camIndex].Capture_Temp_index = NFACaptureInfo[camIndex].Capture_Temp_index+1 & 1;
				NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) Capture_Temp_Buffer[NFACaptureInfo[camIndex].Capture_Temp_index];	
			}
		}
	}
}

void hwiCapture1(void)
{
	int camIndex = 1;
//	if(!(NFA_triger&(0x1<<camIndex))) return;
	test_cam_count[camIndex]++;
	if(!(NFA_FIFO_HALF_STATUS_REG&(0x1<<camIndex))) 
	{
		cam_int_err[camIndex]++;
	}
	else
	{
		if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) NFA_HALF_FIFO_SIZE;
		}
		else
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			
			if(ThreeDBufferCheckSW2)
			{
				NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) FIFOReadSize;
				dstShiftCount++;

				if(dstShiftCount >= 60)
				{
					NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) ImageBuffer1;
					dstShiftCount = 0;
				}				
			}
			else
			{
				NFACaptureInfo[camIndex].Capture_Temp_index = NFACaptureInfo[camIndex].Capture_Temp_index+1 & 1;
				NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) Capture_Temp_Buffer[NFACaptureInfo[camIndex].Capture_Temp_index];	
			}
		}
	}
}
void hwiCapture2(void)
{
	int camIndex = 2;
//	if(!(NFA_triger&(0x1<<camIndex))) return;
	test_cam_count[camIndex]++;
	if(!(NFA_FIFO_HALF_STATUS_REG&(0x1<<camIndex))) 
	{
		cam_int_err[camIndex]++;
	}
	else
	{
		if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) NFA_HALF_FIFO_SIZE;
		}
		else
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			
			if(ThreeDBufferCheckSW2)
			{
				NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) FIFOReadSize;
				dstShiftCount++;

				if(dstShiftCount >= 60)
				{
					NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) ImageBuffer1;
					dstShiftCount = 0;
				}				
			}
			else
			{
				NFACaptureInfo[camIndex].Capture_Temp_index = NFACaptureInfo[camIndex].Capture_Temp_index+1 & 1;
				NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) Capture_Temp_Buffer[NFACaptureInfo[camIndex].Capture_Temp_index];	
			}
		}
	}
}
void hwiCapture3(void)
{
	int camIndex = 3;
//	if(!(NFA_triger&(0x1<<camIndex))) return;	
	test_cam_count[camIndex]++;
	if(!(NFA_FIFO_HALF_STATUS_REG&(0x1<<camIndex))) 
	{
		cam_int_err[camIndex]++;
	}
	else
	{
		if (NFACaptureInfo[camIndex].CaptureKind == CAPTURE_KIND_FRAME)
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) NFA_HALF_FIFO_SIZE;
		}
		else
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
			
			if(ThreeDBufferCheckSW2)
			{
				NFACamEdmaParamSet[camIndex].dstAddr += (Uint32) FIFOReadSize;
				dstShiftCount++;

				if(dstShiftCount >= 60)
				{
					NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) ImageBuffer1;
					dstShiftCount = 0;
				}				
			}
			else
			{
				NFACaptureInfo[camIndex].Capture_Temp_index = NFACaptureInfo[camIndex].Capture_Temp_index+1 & 1;
				NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) Capture_Temp_Buffer[NFACaptureInfo[camIndex].Capture_Temp_index];	
			}
		}
	}
}

void ImageScaleConversion(unsigned char *srcImage)
{
	const int CapturedImageWidth = 656;
	const int OriginImageWidth = 640;
	const int OriginImageHeight = 480;
	int x, y;
	int BlankStartByte;

	BlankStartByte = 8;

	for(y = 0; y < OriginImageHeight; y++)
	{
		for(x = 0; x < CapturedImageWidth; x++)
		{
			*(srcImage + y * OriginImageWidth + x) = *(srcImage + y * CapturedImageWidth + BlankStartByte + x);
		}
	}
}
	
void GetImageAreaForPartialMode(int camIndex, int *topPos, int *ImgHeight, int MaxHeight)
{
	int RotateImageTopPos, RotateImageBottomPos;
	int imageTop, imageBottom;
	int minY, maxY;
	int tempCamIndex;
	int globalCameraIndex;
	int tempTop;
	int tempBottom;
	int rate;

	if(MaxHeight == SYSTEM_CAMERA_HD_HEIGHT)
	{
		rate = 2;	
	}
	else
	{
		rate = 1;	
	}

	minY = MaxHeight;
	maxY = 0;

	for (tempCamIndex = 0; tempCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; tempCamIndex++)
	{
		if(!CameraSetupData.CameraEnable[tempCamIndex]) continue;
		if(SystemSetupData.CameraKind[tempCamIndex] == CAMERA_KIND_NFA_2D)
		{
			globalCameraIndex = SystemSetupData.GlobalCameraIndex[tempCamIndex];

			if(minY > TabletCaptureSetupData.RangeTop[globalCameraIndex]) minY = TabletCaptureSetupData.RangeTop[globalCameraIndex];
			if(maxY < TabletCaptureSetupData.RangeBottom[globalCameraIndex]) maxY = TabletCaptureSetupData.RangeBottom[globalCameraIndex];
		}
	}

	imageTop = minY;
	imageBottom = maxY;

	globalCameraIndex = SystemSetupData.GlobalCameraIndex[camIndex];

	// SELMA200, ̹ 
	switch (globalCameraIndex + 1)
	{
		case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
		case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
		case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
		case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
		case SD1_2D_FRONT_FACE_CAMERA_INDEX:
		case SD2_2D_FRONT_FACE_CAMERA_INDEX:
		case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
		case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
		  imageTop = MaxHeight - imageTop;
		  imageBottom = MaxHeight - imageBottom;
		  break;

		default:
		  imageTop = imageTop;
		  imageBottom = imageBottom;
		  break;
	}

	if(imageTop > imageBottom)
	{
		tempTop = imageBottom;	
		tempBottom = imageTop;
	}
	else
	{
		tempTop = imageTop;
		tempBottom = imageBottom;
	}
	
	tempTop = (tempTop - 31) / 32 * 32;
	tempBottom = (tempBottom + 31) / 32 * 32;

	if(tempTop < 0) tempTop = 0;
	if(tempBottom > MaxHeight - 1) tempBottom = MaxHeight - 1;

	imageTop = tempTop;
	imageBottom = tempBottom;

	*topPos = imageTop;
	*ImgHeight = abs(imageTop - imageBottom);
}

void Set_3D_LineScanTime(int LineScanTime, int camIndex)
{

	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	
		//set command
		NFACommendTx[camIndex].Length[0] = 0x06;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= 0x6C;
		NFACommendTx[camIndex].Code2= 0x61; //  register set 61 write 62 read 
		NFACommendTx[camIndex].Data[0]= 0x0C; //  register addr 1
		NFACommendTx[camIndex].Data[1]= 0x01; //  register addr 2
		NFACommendTx[camIndex].Data[2]= LineScanTime&0x00FF;
		NFACommendTx[camIndex].Data[3]= (LineScanTime&0xFF00)>>8;
		NFACommendTx[camIndex].Data[4]= 0x00;
		NFACommendTx[camIndex].Data[5]= 0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[5];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[5];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
}

int SetSubSamplingMode(int camIndex, int mode)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SUBSAMPLING;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SUBSAMPLING_SET;
		NFACommendTx[camIndex].Data[0]= mode;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetSubSamplingMode(int camIndex, int* mode)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SUBSAMPLING;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SUBSAMPLING_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_SUBSAMPLING_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Tail= temp[7];
					NFACommendRx[camIndex].chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*mode = NFACommendRx[camIndex].Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitSubSamplingMode(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SUBSAMPLING;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SUBSAMPLING_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_SUBSAMPLING_INIT_MODE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetROIMode(int camIndex, int StartX, int EndX,int StartY, int EndY, int type)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		if(type==CAMERA_KIND_NFA_3D)
		{
			NFACommendTx[camIndex].Length[0] = 0x09;
			NFACommendTx[camIndex].Length[1] = 0x00;
			NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ROI;
			NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_ROI_SET;

			NFACommendTx[camIndex].Data[0]= 0x00;
			NFACommendTx[camIndex].Data[1]= StartX&0x00FF;
			NFACommendTx[camIndex].Data[2]= (StartX&0xFF00)>>8;
			NFACommendTx[camIndex].Data[3]= EndX&0x00FF;
			NFACommendTx[camIndex].Data[4]= (EndX&0xFF00)>>8;
			NFACommendTx[camIndex].Data[5]= StartY&0x00FF;
			NFACommendTx[camIndex].Data[6]= (StartY&0xFF00)>>8;
			NFACommendTx[camIndex].Data[7]= EndY&0x00FF;
			NFACommendTx[camIndex].Data[8]= (EndY&0xFF00)>>8;

			//make checksum
			NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[5];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[6];	
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[7];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[8];				
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

			//tx data transfer
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[5];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[6];	
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[7];	
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[8];	
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
			Sleep(300);
		}
		else
		{
			NFACommendTx[camIndex].Length[0] = 0x07;
			NFACommendTx[camIndex].Length[1] = 0x00;
			NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ROI;
			NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_2D_ROI_SET;
			NFACommendTx[camIndex].Data[0]= 0x00;
			NFACommendTx[camIndex].Data[1]= StartX;
			NFACommendTx[camIndex].Data[2]= EndX;
			NFACommendTx[camIndex].Data[3]= StartY&0x00FF;
			NFACommendTx[camIndex].Data[4]= (StartY&0xFF00)>>8;
			NFACommendTx[camIndex].Data[5]= EndY&0x00FF;
			NFACommendTx[camIndex].Data[6]= (EndY&0xFF00)>>8;

			//make checksum
			NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[5];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[6];		
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

			//tx data transfer
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[5];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[6];	
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;				
		}		
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetROIMode(int camIndex, int* GetSX,int* GetEX,int* GetSY,int* GetEY, int type)
{
	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ROI;
		
		if(type==CAMERA_KIND_NFA_3D)
		{
			NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_ROI_GET;
		}
		else
		{
			NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_2D_ROI_GET;
		}
		
		NFACommendTx[camIndex].Data[0]=  NFA_CAM_COMMEND_ROI_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>14)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Data[2]= temp[8];
					NFACommendRx[camIndex].Data[3]= temp[9];
					NFACommendRx[camIndex].Data[4]= temp[10];
					NFACommendRx[camIndex].Data[5]= temp[11];
					NFACommendRx[camIndex].Data[6]= temp[12];					
					NFACommendRx[camIndex].Tail= temp[13];
					NFACommendRx[camIndex].chksum= temp[14];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*GetSX = NFACommendRx[camIndex].Data[1];
	*GetEX = NFACommendRx[camIndex].Data[2];
	*GetSY = NFACommendRx[camIndex].Data[3];
	*GetSY |= (NFACommendRx[camIndex].Data[4]<<8);
	*GetEY = NFACommendRx[camIndex].Data[5];
	*GetEY |= (NFACommendRx[camIndex].Data[6]<<8);
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitROIMode(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x07;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ROI;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_2D_ROI_SET;
		NFACommendTx[camIndex].Data[0]= 0x00;
		NFACommendTx[camIndex].Data[1]= NFA_CAM_COMMEND_ROI_INIT_MODE_SX;
		NFACommendTx[camIndex].Data[2]= NFA_CAM_COMMEND_ROI_INIT_MODE_EX;
		NFACommendTx[camIndex].Data[3]= NFA_CAM_COMMEND_ROI_INIT_MODE_SY&0x00FF;
		NFACommendTx[camIndex].Data[4]= (NFA_CAM_COMMEND_ROI_INIT_MODE_SY&0xFF00)>>8;
		NFACommendTx[camIndex].Data[5]= NFA_CAM_COMMEND_ROI_INIT_MODE_EY&0x00FF;
		NFACommendTx[camIndex].Data[6]= (NFA_CAM_COMMEND_ROI_INIT_MODE_EY&0xFF00)>>8;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[5];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[6];		
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[5];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[6];	
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

/*init output image mode : Profile*/
int Init3DOutPutMode (int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_INIT1;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int Set3DOutPutMode (int camIndex, int mode)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_SET;
		NFACommendTx[camIndex].Data[0]= mode;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}


int Get3DOutPutMode(int camIndex, int* mode)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Tail= temp[7];
					NFACommendRx[camIndex].chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*mode = NFACommendRx[camIndex].Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

/*init output image mode : Profile*/
int InitTriggerMode (int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_TRIGGER_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_TRIGGER_MODE_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_TRIGGER_MODE_INIT;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int SetTriggerMode (int camIndex, int mode)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_TRIGGER_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_TRIGGER_MODE_SET;
		NFACommendTx[camIndex].Data[0]= mode;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}


int GetTriggerMode(int camIndex, int* mode)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_TRIGGER_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_TRIGGER_MODE_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_TRIGGER_MODE_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Tail= temp[7];
					NFACommendRx[camIndex].chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*mode = NFACommendRx[camIndex].Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
int SetAnalogGain (int camIndex, int gain)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_ANALOG_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= gain;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetAnalogGain(int camIndex, int* anal_gain)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_ANALOG_GAIN_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_ANALOG_GAIN_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Tail= temp[7];
					NFACommendRx[camIndex].chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*anal_gain = NFACommendRx[camIndex].Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitAnalogGain(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_ANALOG_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_ANALOG_GAIN_INIT;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetBinningMode (int camIndex, int mode)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_BINNING_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_BINNING_MODE_SET;
		NFACommendTx[camIndex].Data[0]= mode;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetBinningMode(int camIndex, int* mode)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_BINNING_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_BINNING_MODE_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_ANALOG_GAIN_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Tail= temp[7];
					NFACommendRx[camIndex].chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*mode = NFACommendRx[camIndex].Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitBinningMode(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_ANALOG_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_BINNING_MODE_INIT;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetDigitalGain (int camIndex, int gain1, int gain2)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x02;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_DIGITAL_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_DIGITAL_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= gain1;
		NFACommendTx[camIndex].Data[1]= gain2;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetDigitalGain(int camIndex, int* digit_gain1,int* digit_gain2)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_DIGITAL_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_DIGITAL_GAIN_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_DIGITAL_GAIN_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>9)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Tail= temp[8];
					NFACommendRx[camIndex].chksum= temp[9];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*digit_gain1 = NFACommendRx[camIndex].Data[0];
	*digit_gain2 = NFACommendRx[camIndex].Data[1];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitDigitalGain(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x02;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_DIGITAL_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_DIGITAL_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_DIGITAL_GAIN_INIT1;
		NFACommendTx[camIndex].Data[1]= NFA_CAM_COMMEND_DIGITAL_GAIN_INIT2;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetShutterSpeed2(int camIndex, int type, int us)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		if(type == CAMERA_KIND_NFA_3D)
		{
			//set command
			NFACommendTx[camIndex].Length[0] = 0x04;
			NFACommendTx[camIndex].Length[1] = 0x00;
			NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
			NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_SET;
			
			NFACommendTx[camIndex].Data[0]= us&0x000000FF;
			NFACommendTx[camIndex].Data[1]= (us&0x0000FF00)>>8;
			NFACommendTx[camIndex].Data[2]= (us&0x00FF0000)>>16;
			NFACommendTx[camIndex].Data[3]= (us&0xFF000000)>>24;
			

			//make checksum
			NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];			
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;
				
			//tx data transfer
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];			
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
			Sleep(300);
		}
		else
		{
			//set command
			NFACommendTx[camIndex].Length[0] = 0x02;
			NFACommendTx[camIndex].Length[1] = 0x00;
			NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
			NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_SET;
			
			NFACommendTx[camIndex].Data[0]= us&0x00FF;
			NFACommendTx[camIndex].Data[1]= (us&0xFF00)>>8;
			//make checksum
			NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;
				
			//tx data transfer
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;			
		}
	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetShutterSpeed(int camIndex, int type, int* us)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_SHUTTER_SPEED_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(type == CAMERA_KIND_NFA_3D)
				{
					if(i>11)
					{
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];
						NFACommendRx[camIndex].Data[1]= temp[7];
						NFACommendRx[camIndex].Data[2]= temp[8];
						NFACommendRx[camIndex].Data[3]= temp[9];						
						NFACommendRx[camIndex].Tail= temp[10];
						NFACommendRx[camIndex].chksum= temp[11];
						break;
					}					
				}
				else
				{
					if(i>9)
					{
						NFACommendRx[camIndex].Header = temp[0];
						NFACommendRx[camIndex].Length[0]= temp[1];
						NFACommendRx[camIndex].Length[1]= temp[2];
						NFACommendRx[camIndex].Id= temp[3];
						NFACommendRx[camIndex].Code1= temp[4];
						NFACommendRx[camIndex].Code2= temp[5];
						NFACommendRx[camIndex].Data[0]= temp[6];
						NFACommendRx[camIndex].Data[1]= temp[7];
						NFACommendRx[camIndex].Tail= temp[8];
						NFACommendRx[camIndex].chksum= temp[9];
						break;
					}
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	if(type == CAMERA_KIND_NFA_3D)
	{
		*us = NFACommendRx[camIndex].Data[0];
		*us |= (NFACommendRx[camIndex].Data[1]<<8);		
		*us |= (NFACommendRx[camIndex].Data[2]<<16);	
		*us |= (NFACommendRx[camIndex].Data[3]<<24);	
	}
	else 
	{
		*us = NFACommendRx[camIndex].Data[0];
		*us |= (NFACommendRx[camIndex].Data[1]<<8);		
	}

	
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitShutterSpeed(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x02;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_SET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_SHUTTER_SPEED_INIT1;
		NFACommendTx[camIndex].Data[1]= NFA_CAM_COMMEND_SHUTTER_SPEED_INIT2;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SaveCameraFlash(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= 0x6c;
		NFACommendTx[camIndex].Code2= 0x10;
		NFACommendTx[camIndex].Data[0]= 0x01;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(5000);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int LoadCameraFlash(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= 0x6c;
		NFACommendTx[camIndex].Code2= 0x11;
		NFACommendTx[camIndex].Data[0]= 0x01;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(3000);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetWaveTable(int camIndex, int table)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_WAVE_TABLE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_WAVE_TABLE_SET;
		NFACommendTx[camIndex].Data[0]= table;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(500);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}
int GetWaveTable(int camIndex, int* table)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_WAVE_TABLE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_WAVE_TABLE_GET;
		NFACommendTx[camIndex].Data[0]= NFA_CAM_COMMEND_WAVE_TABLE_NONE;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>9)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Tail= temp[8];
					NFACommendRx[camIndex].chksum= temp[9];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*table = NFACommendRx[camIndex].Data[0];
		
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int Set3DCameraConfig(int camIndex, int type, unsigned int data)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x05;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_CONFIG_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_CONFIG_MODE_SET;
		NFACommendTx[camIndex].Data[0]= type;
		NFACommendTx[camIndex].Data[1]= data&0x00FF;
		NFACommendTx[camIndex].Data[2]= (data&0xFF00)>>8;
		NFACommendTx[camIndex].Data[3]= 0;
		NFACommendTx[camIndex].Data[4]= 0;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;
			
		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int Get3DCameraConfig(int camIndex, int type, unsigned int* data)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_CONFIG_MODE;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_CONFIG_MODE_GET;
		NFACommendTx[camIndex].Data[0]= type;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>12)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Data[2]= temp[8];
					NFACommendRx[camIndex].Data[3]= temp[9];
					NFACommendRx[camIndex].Data[4]= temp[10];
					NFACommendRx[camIndex].Tail= temp[11];
					NFACommendRx[camIndex].chksum= temp[12];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*data = NFACommendRx[camIndex].Data[1];
	*data |= (NFACommendRx[camIndex].Data[2]<<8);
		
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

//20201106 cjg added 3d camera param
//2020-09-04 cjg added 3D camera param
int SetCamera3DOffSet(int camIndex, int* Data)
{
	int i;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 32;
		NFACommendTx[camIndex].Length[1] = 0;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_OFFSET;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_OFFSET_SET;
		NFACommendTx[camIndex].Data[0]= Data[0]&0x00FF;
		NFACommendTx[camIndex].Data[1]= (Data[0]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[2]= Data[1]&0x00FF;
		NFACommendTx[camIndex].Data[3]= (Data[1]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[4]= Data[2]&0x00FF;
		NFACommendTx[camIndex].Data[5]= (Data[2]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[6]= Data[3]&0x00FF;
		NFACommendTx[camIndex].Data[7]= (Data[3]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[8]= Data[4]&0x00FF;
		NFACommendTx[camIndex].Data[9]= (Data[4]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[10]= Data[5]&0x00FF;
		NFACommendTx[camIndex].Data[11]= (Data[5]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[12]= Data[6]&0x00FF;
		NFACommendTx[camIndex].Data[13]= (Data[6]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[14]= Data[7]&0x00FF;
		NFACommendTx[camIndex].Data[15]= (Data[7]&0xFF00)>>8;		
		NFACommendTx[camIndex].Data[16]= Data[8]&0x00FF;
		NFACommendTx[camIndex].Data[17]= (Data[8]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[18]= Data[9]&0x00FF;
		NFACommendTx[camIndex].Data[19]= (Data[9]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[20]= Data[10]&0x00FF;
		NFACommendTx[camIndex].Data[21]= (Data[10]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[22]= Data[11]&0x00FF;
		NFACommendTx[camIndex].Data[23]= (Data[11]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[24]= Data[12]&0x00FF;
		NFACommendTx[camIndex].Data[25]= (Data[12]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[26]= Data[13]&0x00FF;
		NFACommendTx[camIndex].Data[27]= (Data[13]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[28]= Data[14]&0x00FF;
		NFACommendTx[camIndex].Data[29]= (Data[14]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[30]= Data[15]&0x00FF;
		NFACommendTx[camIndex].Data[31]= (Data[15]&0xFF00)>>8;			
		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		for(i = 0 ; i < NFACommendTx[camIndex].Length[0] ; i++)
		{
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[i];
		}
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		for(i = 0 ; i < NFACommendTx[camIndex].Length[0]/4 ; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}	
		Sleep(50);
		for( ; i < NFACommendTx[camIndex].Length[0]/2; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}
		Sleep(50);
		for( ; i < NFACommendTx[camIndex].Length[0]*3/4; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}
		Sleep(50);
		for( ; i < NFACommendTx[camIndex].Length[0] ; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}		
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(50);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

//20201106 cjg added 3d camera param
//2020-09-04 cjg added 3D camera param
int GetCamera3DOffSet(int camIndex, int* Data)
{
	int temp[50] = {0};
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_OFFSET;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_OFFSET_GET;
		NFACommendTx[camIndex].Data[0]=  0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime  = Board1MSTmr;
		while(1)
		{	
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>39)
				{
					NFACommendRx[camIndex].Header   	= temp[0];
					NFACommendRx[camIndex].Length[0]	= temp[1];
					NFACommendRx[camIndex].Length[1]	= temp[2];
					NFACommendRx[camIndex].Id			= temp[3];
					NFACommendRx[camIndex].Code1		= temp[4];
					NFACommendRx[camIndex].Code2		= temp[5];
					NFACommendRx[camIndex].Data[0]		= temp[6];
					NFACommendRx[camIndex].Data[1]		= temp[7];
					NFACommendRx[camIndex].Data[2]		= temp[8];
					NFACommendRx[camIndex].Data[3]		= temp[9];
					NFACommendRx[camIndex].Data[4]		= temp[10];
					NFACommendRx[camIndex].Data[5]		= temp[11];
					NFACommendRx[camIndex].Data[6]		= temp[12];		
					NFACommendRx[camIndex].Data[7]		= temp[13];	
					NFACommendRx[camIndex].Data[8]		= temp[14];	
					NFACommendRx[camIndex].Data[9]		= temp[15];	
					NFACommendRx[camIndex].Data[10]	= temp[16];	
					NFACommendRx[camIndex].Data[11]	= temp[17];	
					NFACommendRx[camIndex].Data[12]	= temp[18];	
					NFACommendRx[camIndex].Data[13]	= temp[19];	
					NFACommendRx[camIndex].Data[14]	= temp[20];	
					NFACommendRx[camIndex].Data[15]	= temp[21];	
					NFACommendRx[camIndex].Data[16]	= temp[22];
					NFACommendRx[camIndex].Data[17]	= temp[23];
					NFACommendRx[camIndex].Data[18]	= temp[24];
					NFACommendRx[camIndex].Data[19]	= temp[25];
					NFACommendRx[camIndex].Data[20]	= temp[26];
					NFACommendRx[camIndex].Data[21]	= temp[27];
					NFACommendRx[camIndex].Data[22]	= temp[28];		
					NFACommendRx[camIndex].Data[23]	= temp[29];	
					NFACommendRx[camIndex].Data[24]	= temp[30];	
					NFACommendRx[camIndex].Data[25]	= temp[31];	
					NFACommendRx[camIndex].Data[26]	= temp[32];	
					NFACommendRx[camIndex].Data[27]	= temp[33];	
					NFACommendRx[camIndex].Data[28]	= temp[34];	
					NFACommendRx[camIndex].Data[29]	= temp[35];	
					NFACommendRx[camIndex].Data[30]	= temp[36];	
					NFACommendRx[camIndex].Data[31]	= temp[37];						
					NFACommendRx[camIndex].Tail			= temp[38];
					NFACommendRx[camIndex].chksum		= temp[39];
					break;
				}
			}

			if(Board1MSTmr -Read_StartTime > 5000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	Data[0]= NFACommendRx[camIndex].Data[0];
	Data[0] |= (NFACommendRx[camIndex].Data[1]<<8);	
	Data[1]= NFACommendRx[camIndex].Data[2];
	Data[1] |= (NFACommendRx[camIndex].Data[3]<<8);
	Data[2]= NFACommendRx[camIndex].Data[4];
	Data[2] |= (NFACommendRx[camIndex].Data[5]<<8);
	Data[3]= NFACommendRx[camIndex].Data[6];
	Data[3] |= (NFACommendRx[camIndex].Data[7]<<8);
	Data[4]= NFACommendRx[camIndex].Data[8];
	Data[4] |= (NFACommendRx[camIndex].Data[9]<<8);
	Data[5]= NFACommendRx[camIndex].Data[10];
	Data[5] |= (NFACommendRx[camIndex].Data[11]<<8);
	Data[6]= NFACommendRx[camIndex].Data[12];
	Data[6] |= (NFACommendRx[camIndex].Data[13]<<8);
	Data[7]= NFACommendRx[camIndex].Data[14];
	Data[7] |= (NFACommendRx[camIndex].Data[15]<<8);	
	Data[8]= NFACommendRx[camIndex].Data[16];
	Data[8] |= (NFACommendRx[camIndex].Data[17]<<8);	
	Data[9]= NFACommendRx[camIndex].Data[18];
	Data[9] |= (NFACommendRx[camIndex].Data[19]<<8);
	Data[10]= NFACommendRx[camIndex].Data[20];
	Data[10] |= (NFACommendRx[camIndex].Data[21]<<8);
	Data[11]= NFACommendRx[camIndex].Data[22];
	Data[11] |= (NFACommendRx[camIndex].Data[23]<<8);
	Data[12]= NFACommendRx[camIndex].Data[24];
	Data[12] |= (NFACommendRx[camIndex].Data[25]<<8);
	Data[13]= NFACommendRx[camIndex].Data[26];
	Data[13] |= (NFACommendRx[camIndex].Data[27]<<8);
	Data[14]= NFACommendRx[camIndex].Data[28];
	Data[14] |= (NFACommendRx[camIndex].Data[29]<<8);
	Data[15]= NFACommendRx[camIndex].Data[30];
	Data[15] |= (NFACommendRx[camIndex].Data[31]<<8);		
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
//20201106 cjg added 3d camera param
//2020-09-04 cjg added 3D camera param
int SetCamera3DSysGain(int camIndex, int* Data)
{
	int i;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 32;
		NFACommendTx[camIndex].Length[1] = 0;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= Data[0]&0x00FF;
		NFACommendTx[camIndex].Data[1]= (Data[0]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[2]= Data[1]&0x00FF;
		NFACommendTx[camIndex].Data[3]= (Data[1]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[4]= Data[2]&0x00FF;
		NFACommendTx[camIndex].Data[5]= (Data[2]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[6]= Data[3]&0x00FF;
		NFACommendTx[camIndex].Data[7]= (Data[3]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[8]= Data[4]&0x00FF;
		NFACommendTx[camIndex].Data[9]= (Data[4]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[10]= Data[5]&0x00FF;
		NFACommendTx[camIndex].Data[11]= (Data[5]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[12]= Data[6]&0x00FF;
		NFACommendTx[camIndex].Data[13]= (Data[6]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[14]= Data[7]&0x00FF;
		NFACommendTx[camIndex].Data[15]= (Data[7]&0xFF00)>>8;		
		NFACommendTx[camIndex].Data[16]= Data[8]&0x00FF;
		NFACommendTx[camIndex].Data[17]= (Data[8]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[18]= Data[9]&0x00FF;
		NFACommendTx[camIndex].Data[19]= (Data[9]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[20]= Data[10]&0x00FF;
		NFACommendTx[camIndex].Data[21]= (Data[10]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[22]= Data[11]&0x00FF;
		NFACommendTx[camIndex].Data[23]= (Data[11]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[24]= Data[12]&0x00FF;
		NFACommendTx[camIndex].Data[25]= (Data[12]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[26]= Data[13]&0x00FF;
		NFACommendTx[camIndex].Data[27]= (Data[13]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[28]= Data[14]&0x00FF;
		NFACommendTx[camIndex].Data[29]= (Data[14]&0xFF00)>>8;
		NFACommendTx[camIndex].Data[30]= Data[15]&0x00FF;
		NFACommendTx[camIndex].Data[31]= (Data[15]&0xFF00)>>8;	

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		for(i = 0 ; i < NFACommendTx[camIndex].Length[0] ; i++)
		{
			NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[i];
		}
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		for(i = 0 ; i < NFACommendTx[camIndex].Length[0]/4 ; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}	
		Sleep(50);
		for( ; i < NFACommendTx[camIndex].Length[0]/2; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}
		Sleep(50);
		for( ; i < NFACommendTx[camIndex].Length[0]*3/4; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}
		Sleep(50);
		for( ; i < NFACommendTx[camIndex].Length[0] ; i++)
		{
			NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[i];
		}		
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(50);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}
//20201106 cjg added 3d camera param
//2020-09-04 cjg added 3D camera param
int GetCamera3DSysGain(int camIndex, int* Data)
{
	int temp[50] = {0};
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_GAIN_GET;
		NFACommendTx[camIndex].Data[0]=  0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime  = Board1MSTmr;
		while(1)
		{	
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>39)
				{
					NFACommendRx[camIndex].Header   	= temp[0];
					NFACommendRx[camIndex].Length[0]	= temp[1];
					NFACommendRx[camIndex].Length[1]	= temp[2];
					NFACommendRx[camIndex].Id			= temp[3];
					NFACommendRx[camIndex].Code1		= temp[4];
					NFACommendRx[camIndex].Code2		= temp[5];
					NFACommendRx[camIndex].Data[0]		= temp[6];
					NFACommendRx[camIndex].Data[1]		= temp[7];
					NFACommendRx[camIndex].Data[2]		= temp[8];
					NFACommendRx[camIndex].Data[3]		= temp[9];
					NFACommendRx[camIndex].Data[4]		= temp[10];
					NFACommendRx[camIndex].Data[5]		= temp[11];
					NFACommendRx[camIndex].Data[6]		= temp[12];		
					NFACommendRx[camIndex].Data[7]		= temp[13];	
					NFACommendRx[camIndex].Data[8]		= temp[14];	
					NFACommendRx[camIndex].Data[9]		= temp[15];	
					NFACommendRx[camIndex].Data[10]	= temp[16];	
					NFACommendRx[camIndex].Data[11]	= temp[17];	
					NFACommendRx[camIndex].Data[12]	= temp[18];	
					NFACommendRx[camIndex].Data[13]	= temp[19];	
					NFACommendRx[camIndex].Data[14]	= temp[20];	
					NFACommendRx[camIndex].Data[15]	= temp[21];	
					NFACommendRx[camIndex].Data[16]	= temp[22];
					NFACommendRx[camIndex].Data[17]	= temp[23];
					NFACommendRx[camIndex].Data[18]	= temp[24];
					NFACommendRx[camIndex].Data[19]	= temp[25];
					NFACommendRx[camIndex].Data[20]	= temp[26];
					NFACommendRx[camIndex].Data[21]	= temp[27];
					NFACommendRx[camIndex].Data[22]	= temp[28];		
					NFACommendRx[camIndex].Data[23]	= temp[29];	
					NFACommendRx[camIndex].Data[24]	= temp[30];	
					NFACommendRx[camIndex].Data[25]	= temp[31];	
					NFACommendRx[camIndex].Data[26]	= temp[32];	
					NFACommendRx[camIndex].Data[27]	= temp[33];	
					NFACommendRx[camIndex].Data[28]	= temp[34];	
					NFACommendRx[camIndex].Data[29]	= temp[35];	
					NFACommendRx[camIndex].Data[30]	= temp[36];	
					NFACommendRx[camIndex].Data[31]	= temp[37];						
					NFACommendRx[camIndex].Tail			= temp[38];
					NFACommendRx[camIndex].chksum		= temp[39];
					break;
				}
			}

			if(Board1MSTmr -Read_StartTime > 5000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	Data[0]= NFACommendRx[camIndex].Data[0];
	Data[0] |= (NFACommendRx[camIndex].Data[1]<<8);	
	Data[1]= NFACommendRx[camIndex].Data[2];
	Data[1] |= (NFACommendRx[camIndex].Data[3]<<8);
	Data[2]= NFACommendRx[camIndex].Data[4];
	Data[2] |= (NFACommendRx[camIndex].Data[5]<<8);
	Data[3]= NFACommendRx[camIndex].Data[6];
	Data[3] |= (NFACommendRx[camIndex].Data[7]<<8);
	Data[4]= NFACommendRx[camIndex].Data[8];
	Data[4] |= (NFACommendRx[camIndex].Data[9]<<8);
	Data[5]= NFACommendRx[camIndex].Data[10];
	Data[5] |= (NFACommendRx[camIndex].Data[11]<<8);
	Data[6]= NFACommendRx[camIndex].Data[12];
	Data[6] |= (NFACommendRx[camIndex].Data[13]<<8);
	Data[7]= NFACommendRx[camIndex].Data[14];
	Data[7] |= (NFACommendRx[camIndex].Data[15]<<8);	
	Data[8]= NFACommendRx[camIndex].Data[16];
	Data[8] |= (NFACommendRx[camIndex].Data[17]<<8);	
	Data[9]= NFACommendRx[camIndex].Data[18];
	Data[9] |= (NFACommendRx[camIndex].Data[19]<<8);
	Data[10]= NFACommendRx[camIndex].Data[20];
	Data[10] |= (NFACommendRx[camIndex].Data[21]<<8);
	Data[11]= NFACommendRx[camIndex].Data[22];
	Data[11] |= (NFACommendRx[camIndex].Data[23]<<8);
	Data[12]= NFACommendRx[camIndex].Data[24];
	Data[12] |= (NFACommendRx[camIndex].Data[25]<<8);
	Data[13]= NFACommendRx[camIndex].Data[26];
	Data[13] |= (NFACommendRx[camIndex].Data[27]<<8);
	Data[14]= NFACommendRx[camIndex].Data[28];
	Data[14] |= (NFACommendRx[camIndex].Data[29]<<8);
	Data[15]= NFACommendRx[camIndex].Data[30];
	Data[15] |= (NFACommendRx[camIndex].Data[31]<<8);		
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int SetCutOffLevel (int camIndex, int* Cutoff_lvl)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x02;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF_SET;
		NFACommendTx[camIndex].Data[0]= *Cutoff_lvl&0x00FF;
		NFACommendTx[camIndex].Data[1]= ((*Cutoff_lvl)&0xFF00)>>8;
		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetCutOffLevel(int camIndex, int* Cutoff_lvl)
{

	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF_GET;
		NFACommendTx[camIndex].Data[0]= 0;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
//20201106 cjg added 3d camera param
				if(i>9)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Tail= temp[8];
					NFACommendRx[camIndex].chksum= temp[9];
					break;
				}	
			}
			
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*Cutoff_lvl = NFACommendRx[camIndex].Data[0];
	*Cutoff_lvl |= (NFACommendRx[camIndex].Data[1]<<8);	
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
int SetGainLevel (int camIndex, int* gain_lvl)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x02;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN_SET;
		NFACommendTx[camIndex].Data[0]= *gain_lvl&0x00FF;
		NFACommendTx[camIndex].Data[1]= ((*gain_lvl)&0xFF00)>>8;
		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetGainLevel(int camIndex, int* gain_lvl)
{

	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN_GET;
		NFACommendTx[camIndex].Data[0]= 0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
//20201106 cjg added 3d camera param
				if(i>9)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Tail= temp[8];
					NFACommendRx[camIndex].chksum= temp[9];
					break;
				}	
			}
						
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*gain_lvl = NFACommendRx[camIndex].Data[0];
	*gain_lvl |= (NFACommendRx[camIndex].Data[1]<<8);	
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int SetCOGThreshold (int camIndex, int* Cog_threshold, int* Cog_gain, int* Cog_offset)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x06;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_COG_THR;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_COG_THR_SET;
		NFACommendTx[camIndex].Data[0]= *Cog_threshold&0x00FF;
		NFACommendTx[camIndex].Data[1]= ((*Cog_threshold)&0xFF00)>>8;
		NFACommendTx[camIndex].Data[2]= *Cog_gain&0x00FF;
		NFACommendTx[camIndex].Data[3]= ((*Cog_gain)&0xFF00)>>8;
		NFACommendTx[camIndex].Data[4]= *Cog_offset&0x00FF;
		NFACommendTx[camIndex].Data[5]= ((*Cog_offset)&0xFF00)>>8;		
		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[4];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[5];		
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[4];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[5];		
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetCOGThreshold(int camIndex, int* Cog_threshold, int* Cog_gain, int* Cog_offset)
{

	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] = 0x01;
		NFACommendTx[camIndex].Length[1] = 0x00;
		NFACommendTx[camIndex].Code1= NFA_CAM_COMMEND_3D_SYS_COG_THR;
		NFACommendTx[camIndex].Code2= NFA_CAM_COMMEND_3D_SYS_COG_THR_GET;
		NFACommendTx[camIndex].Data[0]= 0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
//20201106 cjg added 3d camera param
				if(i>13)
				{
					NFACommendRx[camIndex].Header = temp[0];
					NFACommendRx[camIndex].Length[0]= temp[1];
					NFACommendRx[camIndex].Length[1]= temp[2];
					NFACommendRx[camIndex].Id= temp[3];
					NFACommendRx[camIndex].Code1= temp[4];
					NFACommendRx[camIndex].Code2= temp[5];
					NFACommendRx[camIndex].Data[0]= temp[6];
					NFACommendRx[camIndex].Data[1]= temp[7];
					NFACommendRx[camIndex].Data[2]= temp[8];
					NFACommendRx[camIndex].Data[3]= temp[9];
					NFACommendRx[camIndex].Data[4]= temp[10];
//20201106 cjg added 3d camera param
					NFACommendRx[camIndex].Data[5]= temp[11];
					NFACommendRx[camIndex].Tail= temp[12];
					NFACommendRx[camIndex].chksum= temp[13];
					break;
				}	
			}
						
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*Cog_threshold = NFACommendRx[camIndex].Data[0];
	*Cog_threshold |= (NFACommendRx[camIndex].Data[1]<<8);	
	*Cog_gain = NFACommendRx[camIndex].Data[2];
	*Cog_gain |= (NFACommendRx[camIndex].Data[3]<<8);	
	*Cog_offset = NFACommendRx[camIndex].Data[4];
	*Cog_offset |= (NFACommendRx[camIndex].Data[5]<<8);		
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

//20201106 cjg added 3d camera param
//20200901 cjg added command for 3D Camera Calibration Mode 
int SetCamCalibrationMode (int camIndex, int* Cam_calib_mode)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] 	= 0x04;
		NFACommendTx[camIndex].Length[1] 	= 0x00;
		NFACommendTx[camIndex].Code1		= NFA_CAM_COMMEND_3D_SYS_CAM_MODE;
		NFACommendTx[camIndex].Code2		= NFA_CAM_COMMEND_3D_SYS_CAM_MODE_SET;
		NFACommendTx[camIndex].Data[0]		= *Cam_calib_mode&0x000000FF;
		NFACommendTx[camIndex].Data[1]		= ((*Cam_calib_mode)&0x0000FF00)>>8;
		NFACommendTx[camIndex].Data[2]		= ((*Cam_calib_mode)&0x00FF0000)>>16;
		NFACommendTx[camIndex].Data[3]		= ((*Cam_calib_mode)&0xFF000000)>>24;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];

		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;

		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[2];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[3];	
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[2];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[3];		
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

//20200901 cjg added command for 3D Camera Calibration Mode
int GetCamCalibrationMode(int camIndex, int* Cam_calib_mode)
{
	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] 	= 0x01;
		NFACommendTx[camIndex].Length[1] 	= 0x00;
		NFACommendTx[camIndex].Code1		= NFA_CAM_COMMEND_3D_SYS_CAM_MODE;
		NFACommendTx[camIndex].Code2		= NFA_CAM_COMMEND_3D_SYS_CAM_MODE_GET;
		NFACommendTx[camIndex].Data[0]		= 0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>11)
				{
					NFACommendRx[camIndex].Header 		= temp[0];
					NFACommendRx[camIndex].Length[0]	= temp[1];
					NFACommendRx[camIndex].Length[1]	= temp[2];
					NFACommendRx[camIndex].Id			= temp[3];
					NFACommendRx[camIndex].Code1		= temp[4];
					NFACommendRx[camIndex].Code2		= temp[5];
					NFACommendRx[camIndex].Data[0]		= temp[6];
					NFACommendRx[camIndex].Data[1]		= temp[7];
					NFACommendRx[camIndex].Data[2]		= temp[8];
					NFACommendRx[camIndex].Data[3]		= temp[9];
					NFACommendRx[camIndex].Tail			= temp[10];
					NFACommendRx[camIndex].chksum		= temp[11];
					break;
				}	
			}
						
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*Cam_calib_mode = NFACommendRx[camIndex].Data[0];
	*Cam_calib_mode |= (NFACommendRx[camIndex].Data[1]<<8);	
	*Cam_calib_mode |= (NFACommendRx[camIndex].Data[2]<<16);	
	*Cam_calib_mode |= (NFACommendRx[camIndex].Data[3]<<24);	
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
//20201106 cjg added 3d camera param
//2020-09-02 cjg added 3D camera version check
int GetCamVersion(int camIndex, int* Cam_ver_major, int* Cam_ver_minor)
{
	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] 	= 0x01;
		NFACommendTx[camIndex].Length[1] 	= 0x00;
		NFACommendTx[camIndex].Code1		= NFA_CAM_COMMEND_3D_SYS_CAM_VER;
		NFACommendTx[camIndex].Code2		= NFA_CAM_COMMEND_3D_SYS_CAM_VER_GET;
		NFACommendTx[camIndex].Data[0]		= 0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>9)
				{
					NFACommendRx[camIndex].Header 		= temp[0];
					NFACommendRx[camIndex].Length[0]	= temp[1];
					NFACommendRx[camIndex].Length[1]	= temp[2];
					NFACommendRx[camIndex].Id			= temp[3];
					NFACommendRx[camIndex].Code1		= temp[4];
					NFACommendRx[camIndex].Code2		= temp[5];
					NFACommendRx[camIndex].Data[0]		= temp[6];
					NFACommendRx[camIndex].Data[1]		= temp[7];
					NFACommendRx[camIndex].Tail			= temp[8];
					NFACommendRx[camIndex].chksum		= temp[9];
					break;
				}	
			}
						
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*Cam_ver_minor = NFACommendRx[camIndex].Data[0];
	*Cam_ver_major = NFACommendRx[camIndex].Data[1];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
void Camera3D_Calibration_Offset_Read(TCamera3D_CalOffsetParam  *readParam)
{
	int spbCamIndex;
	int result,i;
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{
			result = GetCamera3DOffSet(spbCamIndex, readParam->Cam_Init_Offset);
			if(result < 0)
			{
				for(i = 0; i <16 ; i++)
				{
					 readParam->Cam_Init_Offset[i] = 0xFFFF;
				}
			}
			result = GetCamera3DSysGain(spbCamIndex, readParam->Cma_Sys_Gain);
			if(result < 0)
			{
				for(i = 0; i <16 ; i++)
				{
					 readParam->Cma_Sys_Gain[i] = 0xFFFF;
				}
			}			
			result = GetCamCalibrationMode(spbCamIndex, &readParam->Cam_Calib_Mode);
			if(result < 0)
			{
				 readParam->Cam_Calib_Mode = 0xFFFFFFFF;
			}	

		}
	}
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
void Camera3D_Calibration_Offset_Write(TCamera3D_CalOffsetParam *writeParam)
{
	int spbCamIndex;
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{
			SetCamera3DOffSet(spbCamIndex,writeParam->Cam_Init_Offset);
			Sleep(50);
			SetCamera3DSysGain(spbCamIndex,writeParam->Cma_Sys_Gain);
			Sleep(50);
			SetCamCalibrationMode(spbCamIndex,&writeParam->Cam_Calib_Mode); 
			Sleep(50);
		}
	}
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
void Camera3D_Calibration_COG_Read(TCamera3D_CalCOGParam  *readParam)
{
	int spbCamIndex;
	int result,i;
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{		
			result = GetCutOffLevel(spbCamIndex, &readParam->CutOff_Level);
			if(result < 0)
			{
				 readParam->CutOff_Level = 0xFFFF;
			}
			result = GetGainLevel(spbCamIndex, &readParam->Gain_Level);
			if(result < 0)
			{
				 readParam->Gain_Level = 0xFFFF;
			}
			result = GetCOGThreshold(spbCamIndex, &readParam->COG_Threshold, &readParam->COG_Gain, &readParam->COG_Offset);
			if(result < 0)
			{
				 readParam->COG_Threshold = 0xFFFF;
				 readParam->COG_Gain = 0xFFFF;
				 readParam->COG_Offset = 0xFFFF;
				 
			}	
		}
	}
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
void Camera3D_Calibration_COG_Write(TCamera3D_CalCOGParam *writeParam)
{
	int spbCamIndex;
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{
			SetCutOffLevel(spbCamIndex,&writeParam->CutOff_Level);
			Sleep(50);
			SetGainLevel(spbCamIndex,&writeParam->Gain_Level);
			Sleep(50);
			SetCOGThreshold(spbCamIndex,&writeParam->COG_Threshold, &writeParam->COG_Gain, &writeParam->COG_Offset);
			Sleep(50);
			SaveCameraFlash(spbCamIndex);
		}
	}
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
void Cam_ADC_Resolution_Write(T3DCamera_ADC_Resolution *writeParam)
{
	int spbCamIndex;
	for (spbCamIndex = 0; spbCamIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; spbCamIndex++)
	{
		if (SystemSetupData.CameraKind[spbCamIndex] == CAMERA_KIND_NFA_3D)
		{
			Set3D_Cam_ADC_Resolution(spbCamIndex,&writeParam->Cam_ADC_Resolution);
			Sleep(50);
		}
	}
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
int Set3D_Cam_ADC_Resolution (int camIndex, int* Cam_ADC_Resolution)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] 	= 0x01;
		NFACommendTx[camIndex].Length[1] 	= 0x00;
		NFACommendTx[camIndex].Code1		= NFA_CAM_COMMEND_3D_SYS_CAM_MODE;
		NFACommendTx[camIndex].Code2		= NFA_CAM_COMMEND_3D_RESOLUTION_SET;
		NFACommendTx[camIndex].Data[0]		= *Cam_ADC_Resolution&0x000000FF;
		
		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];

		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;

		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];	
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];		
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}
//---------------------------------------------------------------------------
//20201106 cjg added 3d camera param
int Get3D_ADC_CamResolution(int camIndex, int* Cam_ADC_Resolution)
{
	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx[camIndex].Length[0] 	= 0x01;
		NFACommendTx[camIndex].Length[1] 	= 0x00;
		NFACommendTx[camIndex].Code1		= NFA_CAM_COMMEND_3D_SYS_CAM_RESOLUTION;
		NFACommendTx[camIndex].Code2		= NFA_CAM_COMMEND_3D_RESOLUTION_GET;
		NFACommendTx[camIndex].Data[0]		= 0x00;

		//make checksum
		NFACommendTx[camIndex].chksum = NFACommendTx[camIndex].Header;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Length[1];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Id;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code1;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Code2;
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Data[0];
		NFACommendTx[camIndex].chksum ^= NFACommendTx[camIndex].Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Header;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Length[1];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Id;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code1;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Code2;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Data[0];
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].Tail;
		NFA_RS232_DATA_REG = NFACommendTx[camIndex].chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx[camIndex].Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx[camIndex].Header 		= temp[0];
					NFACommendRx[camIndex].Length[0]	= temp[1];
					NFACommendRx[camIndex].Length[1]	= temp[2];
					NFACommendRx[camIndex].Id			= temp[3];
					NFACommendRx[camIndex].Code1		= temp[4];
					NFACommendRx[camIndex].Code2		= temp[5];
					NFACommendRx[camIndex].Data[0]		= temp[6];
					NFACommendRx[camIndex].Tail			= temp[7];
					NFACommendRx[camIndex].chksum		= temp[8];
					break;
				}	
			}
						
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*Cam_ADC_Resolution = NFACommendRx[camIndex].Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
 
//---------------------------------------------------------------------------
void NFA3D_Streaming_Control_Clear(int camIndex)
{
	int rFrameIndex;
	TNFACaptureInfo *captureInfo;
	captureInfo = &NFACaptureInfo[camIndex];
	for (rFrameIndex = 0; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
	{
		captureInfo->RegisteredFrame[rFrameIndex].Registered = 0;
		captureInfo->RegisteredFrame[rFrameIndex].CaptureImagelength = 0;
		captureInfo->RegisteredFrame[rFrameIndex].CaptureStartTime = 0;
	}
}
//---------------------------------------------------------------------------
void NFA3D_Streaming_Control_Close(int camIndex)
{
	unsigned int ie;
	TNFACaptureInfo *captureInfo;
	captureInfo = &NFACaptureInfo[camIndex];
	captureInfo->CaptureStep = CAPTURE_STEP_NONE;
	Sensor_3D_triger = 3;
	CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_DISABLE,&nfaRegionIntr[camIndex]); 
	CaptureStopOne(captureInfo->HWCamIndex);
}
//---------------------------------------------------------------------------
void NFA3D_Streaming_Control_Open(int camIndex)
{
	TNFACaptureInfo *captureInfo;
	CSL_Edma3CmdIntr            regionIntr;
	CSL_Status                  status;
	CSL_IntcGlobalEnableState 	state;
	unsigned char *dstBuffer;
	
	switch(camIndex)
	{
		case 0:
			dstBuffer = ImageBuffer1;
			break;
		case 1:
			dstBuffer = ImageBuffer2;
			break;
		case 2:
			dstBuffer = ImageBuffer3;
			break;
		case 3:
			dstBuffer = ImageBuffer4;
			break;
		default:
			dstBuffer = ImageBuffer2;
			break;
	}
	
	captureInfo	= &NFACaptureInfo[camIndex];

//	CSL_intcGlobalDisable(&state);
	
	captureInfo->CaptureStep = CAPTURE_STEP_ON_CAPTURE;
	captureInfo->CurrentCaptureFrameIndex = 0;
	captureInfo->Capture_Temp_index = 0;
	captureInfo->ThreeDCaptureListIndex= 0;
	captureInfo->RegisteredFrame[0].ThreeDCaptureIndex = 0;
	captureInfo->RegisteredFrame[1].ThreeDCaptureIndex = 0;
	captureInfo->RegisteredFrame[2].ThreeDCaptureIndex = 0;
	captureInfo->RegisteredFrame[3].ThreeDCaptureIndex = 0;
	NFA_SET_BIT(NFA_triger,camIndex);
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;

	if(ThreeDBufferCheckSW)
	{
		NFACamEdmaParamSet[camIndex].aCntbCnt = CSL_EDMA3_CNT_MAKE(NFA_HALF_FIFO_SIZE, 1);

		FIFOReadSize = NFA_HALF_FIFO_SIZE;
		NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) dstBuffer;	

		ThreeDBufferCheckSW2 = 1;
	}
	else
	{
		NFACamEdmaParamSet[camIndex].aCntbCnt = CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);

		FIFOReadSize = NFA3D_HALF_FIFO_SIZE;
		NFACamEdmaParamSet[camIndex].dstAddr = (Uint32) Capture_Temp_Buffer[captureInfo->Capture_Temp_index];	
		ThreeDBufferCheckSW2 = 0;
	}
	CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
	CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_ENABLE,&nfaRegionIntr[camIndex]);
	start_3d_time[camIndex] = Board50usTimer;
	camera_ttt[3]=0;
//	CSL_intcGlobalEnable(&state);	
}
//---------------------------------------------------------------------------

int NFA3D_Streaming_Control_RegisterFrame(int camIndex, unsigned char *captureImage, int *ptrStatus)
{
	CSL_Edma3CmdIntr            regionIntr;
	CSL_Status                  status;
	CSL_IntcGlobalEnableState 	state;

	unsigned int ie;

	TNFACaptureInfo *captureInfo;
	int rFrameIndex = 0;
	int i;
	char *ip;
	captureInfo = &NFACaptureInfo[camIndex];
	
	if(0)//SystemSetupData.Laser_complexer_Enable==1)
	{
		for (rFrameIndex = 0; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
		{
			if(captureInfo->RegisteredFrame[rFrameIndex].Registered)
			{			
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32)Capture_Empty_Buffer;
				if(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain < 5 )
				{
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE*NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain, 1);
				}
				else
				{
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE*5, 1);
				}
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
				CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);		

				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr =(Uint32)Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];				
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);		
 	  			
				NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = (NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1) & (MAX_REGISTABLE_FRAME_COUNT-1);
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength=0;	
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain =0;
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
				cam_complete_count[camIndex]++;
				if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
				*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;	
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);				
				break;
			}
		}
			
		for (rFrameIndex = captureInfo->CurrentCaptureFrameIndex; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
		{
			if (!captureInfo->RegisteredFrame[rFrameIndex].Registered)
			{
				break;
			}
		}
	
		if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT)
		{
			for (rFrameIndex = 0; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
			{
				if (!captureInfo->RegisteredFrame[rFrameIndex].Registered) 
				{
					
					break;
				}
			}	
		}
		if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT)
		{
			camera_ttt[1]++;
			ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_CAPTURE_TIMEOUT, camIndex, captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain, cam_timeout_cnt[camIndex]++);
			return -1;

		}
	}
	else
	{
		for (rFrameIndex = 0; rFrameIndex < MAX_REGISTABLE_FRAME_COUNT; rFrameIndex++)
		{
			if (!captureInfo->RegisteredFrame[rFrameIndex].Registered) break;
		}

		if (rFrameIndex == MAX_REGISTABLE_FRAME_COUNT) return -1;
	}
	if(SystemSetupData.ThreeDCaptureMethod  == THREED_CAPTURE_RT_TRIGGER_MODE)
	{
		threed_time_check[camIndex][threed_time_check_count[camIndex]] = Board50usTimer - start_3d_time[camIndex];		

		if(threed_time_check[camIndex][threed_time_check_count[camIndex]] >  threed_capture_period[camIndex]*1.2)
		{
//			ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL,	ERROR_CODE_CAPTURE_TIMEOUT, 555 ,captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain,	cam_trig_count[3]++);
			NFA3D_Streaming_Control_Close(camIndex);
			NFA3D_Streaming_Control_Open(camIndex);
		}

		//CSL_intcGlobalDisable(&state);
		start_3d_time[camIndex] = Board50usTimer;
		for(i = 0 ; i < 100 ; i++)
		{
			if(threed_time_check[camIndex][threed_time_check_count[camIndex]] <= 0) break;
			threed_capture_sum[camIndex] += threed_time_check[camIndex][i]; 
		}

		threed_capture_period[camIndex]  = 	(threed_capture_sum[camIndex]/i);
		threed_capture_sum[camIndex] = 0;
		threed_time_check_count[camIndex]++;
		if(threed_time_check_count[camIndex] == 100) threed_time_check_count[camIndex] = 0; 
	}
	NFA_SetImageArea(camIndex);
	
	
	cam_trig_count[camIndex]++;	
	captureInfo->RegisteredFrame[rFrameIndex].CaptureImage = captureImage;
	captureInfo->RegisteredFrame[rFrameIndex].StatusPtr = ptrStatus;
//	Lamp2Toggle();

	captureInfo->RegisteredFrame[rFrameIndex].CaptureImagePtr = captureInfo->RegisteredFrame[rFrameIndex].CaptureImage;
	if(0)//(SystemSetupData.Laser_complexer_Enable==1)
	{
		captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain = (CameraSetupData.SensorLength*50/47*480/NFA3D_HALF_FIFO_SIZE)+1;
	}
	else
	{
		captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain = ((NFACaptureInfo[camIndex].FrameWidth * NFACaptureInfo[camIndex].FrameHeight) / NFA3D_HALF_FIFO_SIZE);
	}
	if(captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain >32)
	{
	captureInfo->RegisteredFrame[rFrameIndex].CaptureReadRemain = 32;
	}
	
	captureInfo->RegisteredFrame[rFrameIndex].CaptureTimeout1ms = 200;	
	captureInfo->RegisteredFrame[rFrameIndex].CaptureStep = CAPTURE_STEP_ON_CAPTURE;
	captureInfo->RegisteredFrame[rFrameIndex].CaptureStartTime = Board1MSTmr;
	captureInfo->RegisteredFrame[rFrameIndex].ThreeDCaptureIndex = (SPBTabletProcessInfo.NextCaptureListIndex-1)&SPB_TABLET_LIST_MASK;	
	captureInfo->RegisteredFrame[rFrameIndex].StatusPtr = ptrStatus; 
	captureInfo->RegisteredFrame[rFrameIndex].Registered = 1;
	if (captureInfo->RegisteredFrame[rFrameIndex].StatusPtr) 
		*(captureInfo->RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_ON_CAPTURE;

	camera_ttt[3]++;	
	return 0;
}

void NFA3D_Image_Check_Process(int camIndex)
{
	unsigned int i,j;
	int exist_count = 0;
	int exist_index = 0;
	int empty_index = 0;
	unsigned short* image_pointer;
	char* ip;
	int rFrameIndex;
	CSL_IntcGlobalEnableState 	state;
	rFrameIndex = NFACaptureInfo[camIndex].CurrentCaptureFrameIndex;
	image_pointer = Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];

	// ̹   üũ
	for(i = 0 ; i < NFA3D_HALF_FIFO_SIZE/NFA3D_PROFILE_SIZE; i++)
	{
		exist_count = 0;
		for(j = 0 ; j < NFA3D_PROFILE_SIZE/8 ; j++)
		{
			exist_count = exist_count + *image_pointer;
			image_pointer = image_pointer+4;
		}
		if(exist_count > 30000) 
		{
			exist_index = i;
			if(Sensor_3d_Status == SENSOR_3D_STATUS_OFF)
			{
				ThreedSensorDelayTime = (62.5 + (NFACaptureInfo[camIndex].LineScanTime * 11.111/1000))*exist_index;
				ThreedSensorDelayTime = 15+ThreedSensorDelayTime/75;
				ThreedSensorStartTime = Board50usTimer+ThreedSensorDelayTime; 
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureStartTime = Board50usTimer;
				if(ThreedSensorStartTime < ThreedSensorEndTime)
				{
					NFA3DCameraSensorOff();
				}
			}
			exist_index = i+1;
			NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength+=(NFA3D_HALF_FIFO_SIZE/NFA3D_PROFILE_SIZE-i);
			break;
		}
	}
	
	image_pointer = Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
	if(Sensor_3d_Status == SENSOR_3D_STATUS_ON)
	{
		for(i = 0 ; i < NFA3D_HALF_FIFO_SIZE/NFA3D_PROFILE_SIZE; i++)
		{
			exist_count = 0;
			for(j = 0 ; j < NFA3D_PROFILE_SIZE/8 ; j++)
			{
				exist_count = exist_count + *image_pointer;
				image_pointer = image_pointer+4;
			}
			if(exist_count <= 30000) 
			{
				empty_index = i+1;
				if(exist_index)
					{
						NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength-=(NFA3D_HALF_FIFO_SIZE/NFA3D_PROFILE_SIZE-i);
					}
				else
					{
						NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength+=empty_index;
					}
		
				ThreedSensorEndTime = ThreedSensorStartTime + ((62.5 + (NFACaptureInfo[camIndex].LineScanTime * 11.111/1000))*NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength)/50;
				break;
			}
		}
	}

	if(exist_index > 0 && empty_index ==0)
	{
		ip = (char *)Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
		if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
		{
			if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain == 0)
			{
				if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
					*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;
				NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = (NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1)&(MAX_REGISTABLE_FRAME_COUNT-1);
				NFACaptureInfo[camIndex].RegisteredFrame[NFACaptureInfo[camIndex].CurrentCaptureFrameIndex].CaptureTimeout1ms = 200;	
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
				Sensor_3d_Status = SENSOR_3D_STATUS_OFF;
				return ;
			}
			else
			{
				if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain == ((CameraSetupData.SensorLength*50/47*480/NFA3D_HALF_FIFO_SIZE)+1))
				{

					NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureTimeout1ms = 200;
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32)Capture_Empty_Buffer;
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE*3, 1);
					CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
					CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);					
					NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr+=(Uint32) (NFA3D_HALF_FIFO_SIZE*3);
				}
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32)(ip+NFA3D_PROFILE_SIZE*(exist_index-1));
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE -NFA3D_PROFILE_SIZE*(exist_index-1), 1);
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr += (Uint32) (NFA3D_HALF_FIFO_SIZE -NFA3D_PROFILE_SIZE*(exist_index-1));
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
				CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain--;
			}	
		}
		else
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
		}	
		Sensor_3d_Status = SENSOR_3D_STATUS_ON;
	}
	else if(empty_index > 0)
	{
		ip = (char *)Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];
		if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
		{		
			if(Sensor_3d_Status == SENSOR_3D_STATUS_ON)
			{
			
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32)(ip);
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_PROFILE_SIZE*empty_index, 1);
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr += (Uint32) (NFA3D_PROFILE_SIZE*empty_index);
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
				CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);
				
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].dstAddr = (unsigned int) NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagePtr;
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr = (Uint32)Capture_Empty_Buffer;
				if(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain < 5 )
				{
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE*NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain, 1);
				}
				else
				{
					NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE*5, 1);
				}
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFA3DCamEdmaParamSet[camIndex][rFrameIndex]);
				CSL_edma3HwChannelControl(hNFAChannel[camIndex],CSL_EDMA3_CMD_CHANNEL_SET,NULL);		

				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].srcAddr =(Uint32)Capture_Temp_Buffer[(NFACaptureInfo[camIndex].Capture_Temp_index+1&1)];				
				NFA3DCamEdmaParamSet[camIndex][rFrameIndex].aCntbCnt= CSL_EDMA3_CNT_MAKE(NFA3D_HALF_FIFO_SIZE, 1);		
				NFACaptureInfo[camIndex].CurrentCaptureFrameIndex = (NFACaptureInfo[camIndex].CurrentCaptureFrameIndex + 1) & (MAX_REGISTABLE_FRAME_COUNT-1);
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength=0;	
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureReadRemain =0;
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered = 0;
				cam_complete_count[camIndex]++;
				if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) 
				*(NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].StatusPtr) = CAPTURE_STATUS_COMPLETE;	
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			}
			else
			{
				CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
				NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureTimeout1ms = 200;			
			}
		}
		else
		{
			CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
			NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureImagelength=0;	
		}	
		Sensor_3d_Status = SENSOR_3D_STATUS_OFF;
	}		
	else
	{
		CSL_edma3ParamSetup(hNFACamEdmaParam[camIndex], &NFACamEdmaParamSet[camIndex]);
		if (NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].Registered)
		{
			NFACaptureInfo[camIndex].RegisteredFrame[rFrameIndex].CaptureTimeout1ms = 200;	
		}	
		Sensor_3d_Status = SENSOR_3D_STATUS_OFF;
	}
}

void NFA3DCameraSensorOn(void)
{
	if(Sensor_3D_triger&1 && BoardID == BOARD_ID_SPB(7))
	{
//		ErrorUnit_Put(BoardID, ERROR_TYPE_DEBUG, ERROR_CODE_PROCESS_RUNTIME,test_cam_count[9]++,ThreedSensorDelayTime, Board50usTimer-ThreedSensorStartTime);
	}
	if (BoardID == BOARD_ID_SPB(1) || BoardID == BOARD_ID_SPB(2) || BoardID == BOARD_ID_SPB(3)|| BoardID == BOARD_ID_SPB(7))
	{
		NFA_RESET_BIT(Sensor_3D_triger,THREED_CAMERA_SENSOR_SD1_BIT);
		THREED_CAMERA_SENSOR = Sensor_3D_triger;
	}
	else
	{
		NFA_RESET_BIT(Sensor_3D_triger,THREED_CAMERA_SENSOR_SD2_BIT);
		THREED_CAMERA_SENSOR = Sensor_3D_triger;
	}
}
void NFA3DCameraSensorOff(void)
{
	if (BoardID == BOARD_ID_SPB(1) || BoardID == BOARD_ID_SPB(2) || BoardID == BOARD_ID_SPB(3)|| BoardID == BOARD_ID_SPB(7))
	{
		NFA_SET_BIT(Sensor_3D_triger,THREED_CAMERA_SENSOR_SD1_BIT);
		THREED_CAMERA_SENSOR = Sensor_3D_triger;
	}
	else
	{
		NFA_SET_BIT(Sensor_3D_triger,THREED_CAMERA_SENSOR_SD2_BIT);
		THREED_CAMERA_SENSOR = Sensor_3D_triger;
	}	
}

void NFACmeraCheck3DOn(int camIndex)
{
	NFA3D_Streaming_Control_Close(camIndex);
	NFA3D_Streaming_Control_Clear(camIndex);
	SetBinningMode(camIndex,0);
	SetROIMode(camIndex, 0,479,0,127,CAMERA_KIND_NFA_3D);
	SetShutterSpeed2(camIndex,CAMERA_KIND_NFA_3D, 30000);
	SetAnalogGain(camIndex,0);
	Set3DOutPutMode(camIndex,2);
	SetTriggerMode(camIndex,1);
	SetWaveTable(camIndex,3);
	NFA_3D_CaptureSetup(camIndex,0,30000,4000);
	NFA3D_Streaming_Control_Open(camIndex);
	NFA3D_Streaming_Control_RegisterFrame(camIndex,InvalidImage,NULL);
}

void NFACmeraCheck3DOFF(int camIndex)
{
	Sensor_3d_Status = SENSOR_3D_STATUS_OFF;
	check_3d_image = 0; 
	NFA3D_Streaming_Control_Close(camIndex);
	NFA3D_Streaming_Control_Clear(camIndex);
}

int  NFACmeraBootCheck()
{
	int i;
	memset(cam_int_count, 0x00, sizeof(cam_int_count));
	for(i = 0; i < SYSTEM_SPB_CAMERA_MAX_COUNT ; i++)
	{
		if(init_camera_type[i]== CAMERA_KIND_NFA_2D)
		{
			NFA_Frame2DCaptureTrigger(i,InvalidImage,NULL);
		}

		if(init_camera_type[i] == CAMERA_KIND_NFA_3D)
		{
			NFACmeraCheck3DOn(i);
			Sleep(100);
			NFACmeraCheck3DOFF(i);								
		}	

		Sleep(200);

		if (SystemSetupData.CamMask & (0x01 << i))
		{
			if(SystemSetupData.CameraKind[i] != init_camera_type[i])
			{
				memset(cam_timeout_cnt, 0x00, sizeof(cam_timeout_cnt));
				return 0;
			}

			if(SystemSetupData.CamBootEnabled == 1)
			{			
				if(cam_int_count[i] < 5)
				{
					memset(cam_timeout_cnt, 0x00, sizeof(cam_timeout_cnt));
					NFA_CAMERA_RESET = 0x1;
					Sleep(5000);
					NFA_CAMERA_RESET = 0x0;
					FPGARELOAD = 0x00FA;				
					return 0;
				}
			}
		}		
		
	}	
	memset(cam_timeout_cnt, 0x00, sizeof(cam_timeout_cnt));
	return 1;
}

void NFACameraCheckProcess(void)
{
	int i;
	switch(NfaCamCheckInfo.main_Step)
	{
		case NFA_CAM_CHECK_INIT:
		{
			if((cam_init_complete!=1) || (NFA_triger!=0))
			{
				printf("Camera Init Error");
				NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_INIT_FAIL;
				NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
				NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_NONE;
			}
			else
			{
				NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SUB_NONE;
				NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_NONE;
				NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_LINK;
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_NONE;
				NfaCamCheckInfo.CamIndex = 0;
				NfaCamCheckInfo.CheckStartTime = 0;
			}
		}
		break;

		case NFA_CAM_CHECK_LINK:
		{
			if(NfaCamCheckInfo.CamIndex < link_camera_count)
			{
				Calib_Capture_Stop(NfaCamCheckInfo.CamIndex);
				cam_timeout_cnt[NfaCamCheckInfo.CamIndex] = 0;
				cam_trig_count[NfaCamCheckInfo.CamIndex] = 0;
				cam_int_count[NfaCamCheckInfo.CamIndex] = 0;
				cam_complete_count[NfaCamCheckInfo.CamIndex] = 0;				
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.StartX = 0;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.EndX = 160;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.StartY = 0;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.EndY = 960;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].AnalogGain = 1;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].DigitalGain[0] = 2;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].DigitalGain[1] = 0;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ShutterSpeed = 10;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].SubSampling = 3;
				NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].OutPutMode3D = 2;
				
				if(init_camera_type[NfaCamCheckInfo.CamIndex]!= SystemSetupData.CameraKind[NfaCamCheckInfo.CamIndex])
				{
					printf("Camera Link Error");
					NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_LINK_FAIL;
					NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
					NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_NONE;
				}
				else 
				{
					NfaCamCheckInfo.CamIndex++;
				}
			}
			else
			{
				NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_SET_PARAM;
				NfaCamCheckInfo.CamIndex = 0;
				
				if(init_camera_type[NfaCamCheckInfo.CamIndex]== CAMERA_KIND_NFA_2D)
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI; 
				}
				else if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_WAVETABLE;
				}
			}
		}
		break;
		
		case NFA_CAM_CHECK_SET_PARAM:
		{
			if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI)
			{
				SetROIMode(NfaCamCheckInfo.CamIndex,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.StartX,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.EndX,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.StartY,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.EndY,CAMERA_KIND_NFA_2D);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_SUBSAMPING;
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_SUBSAMPING)
			{
				SetSubSamplingMode(NfaCamCheckInfo.CamIndex,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].SubSampling);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ANALOGGAIN;
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_ANALOGGAIN)
			{
				SetAnalogGain(NfaCamCheckInfo.CamIndex,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].AnalogGain);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_DIGITALGAIN;
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_DIGITALGAIN)
			{
				SetDigitalGain(NfaCamCheckInfo.CamIndex,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].DigitalGain[0],NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].DigitalGain[1]);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_SHUTTERSPEED;
			}				
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_SHUTTERSPEED)
			{
				SetShutterSpeed2(NfaCamCheckInfo.CamIndex,init_camera_type[NfaCamCheckInfo.CamIndex], NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ShutterSpeed);				
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
			}

			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_OUTPUTMODE3D)
			{
				Set3DOutPutMode(NfaCamCheckInfo.CamIndex,NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].OutPutMode3D);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
			}	
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE)
			{
				
				if(init_camera_type[NfaCamCheckInfo.CamIndex]== CAMERA_KIND_NFA_2D)
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI; 
				}
				else if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_WAVETABLE;
				}
				NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_GET_PARAM;
			}
		}
		break;
		
		case NFA_CAM_CHECK_GET_PARAM:
		{	
			if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI)
			{
				GetROIMode(NfaCamCheckInfo.CamIndex,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.StartX,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.EndX,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.StartY,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.EndY,CAMERA_KIND_NFA_2D);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_SUBSAMPING;
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_SUBSAMPING)
			{
				GetSubSamplingMode(NfaCamCheckInfo.CamIndex,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].SubSampling);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ANALOGGAIN;
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_ANALOGGAIN)
			{
				GetAnalogGain(NfaCamCheckInfo.CamIndex,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].AnalogGain);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_DIGITALGAIN;
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_DIGITALGAIN)
			{
				GetDigitalGain(NfaCamCheckInfo.CamIndex,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].DigitalGain[0],&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].DigitalGain[1]);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_SHUTTERSPEED;
			}				
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_SHUTTERSPEED)
			{
				GetShutterSpeed(NfaCamCheckInfo.CamIndex,init_camera_type[NfaCamCheckInfo.CamIndex], &NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ShutterSpeed);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
			}

			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_OUTPUTMODE3D)
			{
				Get3DOutPutMode(NfaCamCheckInfo.CamIndex,&NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].OutPutMode3D);
				NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
			}	
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE)
			{
				
				if(init_camera_type[NfaCamCheckInfo.CamIndex]== CAMERA_KIND_NFA_2D)
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI; 
				}
				else if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_WAVETABLE;
				}
				NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_PARAM_MODIFY;
			}
		}
		break;
		
		case NFA_CAM_CHECK_PARAM_MODIFY:
		{	
			if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.StartX != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.StartX || NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.EndX != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.EndX  ||
					NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.StartY != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.StartY || NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ROI.EndY != (NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ROI.EndY)*5)
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_ROI;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_SUBSAMPING;
				}
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_SUBSAMPING)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].SubSampling != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].SubSampling ) 
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_SUBSAMPING;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ANALOGGAIN;
				}
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_ANALOGGAIN)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].AnalogGain != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].AnalogGain ) 
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_ANALOGGAIN;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_DIGITALGAIN;
				}
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_DIGITALGAIN)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].DigitalGain[0] != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].DigitalGain[0] ||  NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].DigitalGain[1] != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].DigitalGain[1] ) 
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_DIGITALGAIN;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_SHUTTERSPEED;
				}
			}				
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_SHUTTERSPEED)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].ShutterSpeed != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].ShutterSpeed ) 
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_SHUTTERSPEED;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_WAVETABLE)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].WaveTable != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].WaveTable ) 
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_WAVETABLE;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_OUTPUTMODE3D;
				}
			}
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_OUTPUTMODE3D)
			{
				if(NfaCamCheckInfo.CamSet[NfaCamCheckInfo.CamIndex].OutPutMode3D != NfaCamCheckInfo.CamGet[NfaCamCheckInfo.CamIndex].OutPutMode3D ) 
				{
					NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_SETPARM_OUTPUTMODE3D;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
				else
				{
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE;
				}
			}	
			else if(NfaCamCheckInfo.sub_Step == NFACAMCHECK_PROCESS_SUB_SETPARAM_COMPLETE)
			{
				if(NfaCamCheckInfo.CheckResult_sub == NFA_CAM_CHECK_RESULT_SUB_NONE)
				{
				
					if(init_camera_type[NfaCamCheckInfo.CamIndex]== CAMERA_KIND_NFA_2D)
					{
						NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_ROI; 
					}
					else if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
					{
						NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_SETPARAM_WAVETABLE;
					}
					
					if(NfaCamCheckInfo.CamIndex < link_camera_count)
					{
						NfaCamCheckInfo.CamIndex++;
						NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_SET_PARAM;
					}
					else
					{
						NfaCamCheckInfo.CamIndex = 0;
						NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_CAPTURE;
						NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_CAPTURE_INIT;
					}
					
				}
				else
				{
					NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
					NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_NONE;
					NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_SETPARM_FAIL;
					
				}
			}			
		}
		break;
		case NFA_CAM_CHECK_CAPTURE:
		{	
			if(NfaCamCheckInfo.sub_Step  == NFACAMCHECK_PROCESS_SUB_CAPTURE_INIT)
			{
				if(NfaCamCheckInfo.CamIndex < link_camera_count) 
				{
					if(cam_trig_count[NfaCamCheckInfo.CamIndex] != 0) NfaCamCheckInfo.CheckResult_sub =  NFA_CAM_CHECK_RESULT_CAPTURE_INIT;
					if(cam_int_count[NfaCamCheckInfo.CamIndex] != 0) NfaCamCheckInfo.CheckResult_sub =  NFA_CAM_CHECK_RESULT_CAPTURE_INIT;
					if(cam_complete_count[NfaCamCheckInfo.CamIndex] != 0) NfaCamCheckInfo.CheckResult_sub =  NFA_CAM_CHECK_RESULT_CAPTURE_INIT;
					if(cam_timeout_cnt[NfaCamCheckInfo.CamIndex] != 0) NfaCamCheckInfo.CheckResult_sub =  NFA_CAM_CHECK_RESULT_CAPTURE_INIT;
					NfaCamCheckInfo.CamIndex++;
				}
				else
				{
					if(NfaCamCheckInfo.CheckResult_sub == NFA_CAM_CHECK_RESULT_SUB_NONE)
					{
						NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_CAPTURE_START;
						NfaCamCheckInfo.CheckStartTime = Board1MSTmr;
					}
					else
					{
						NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
						NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_NONE;
						NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_CAPTURE_FAIL;
						NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_CAPTURE_TIMEOUT;					
					}
				}
			}
			else if(NfaCamCheckInfo.sub_Step  == NFACAMCHECK_PROCESS_SUB_CAPTURE_START)
			{
				if(init_camera_type[NfaCamCheckInfo.CamIndex]== CAMERA_KIND_NFA_2D)
				{
					NFA_Frame2DCaptureTrigger(NfaCamCheckInfo.CamIndex++,(void *)0xE0000000,NULL);
				}
				else if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
				{
					if(!(NFA_triger&(0x1<<NfaCamCheckInfo.CamIndex)))
					{
						NFACmeraCheck3DOn(NfaCamCheckInfo.CamIndex++);
					}
					else
					{
						NfaCamCheckInfo.CamIndex++;
					}
				}
				if(NfaCamCheckInfo.CamIndex == link_camera_count) NfaCamCheckInfo.CamIndex = 0;
				
				if(Board1MSTmr > NfaCamCheckInfo.CheckStartTime +  3000)//NFACAMCHECK_CAPTURE_TIME)
				{
					NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_CAPTURE_STOP;
					NfaCamCheckInfo.CamIndex = 0;
				}
					
			}
			else if(NfaCamCheckInfo.sub_Step  == NFACAMCHECK_PROCESS_SUB_CAPTURE_STOP)
			{
				if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
				{
					NFACmeraCheck3DOFF(NfaCamCheckInfo.CamIndex);
				}
				NfaCamCheckInfo.CamIndex++;
				if(NfaCamCheckInfo.CamIndex == link_camera_count)
				{
					NfaCamCheckInfo.CamIndex = 0;
					NfaCamCheckInfo.sub_Step = NFACAMCHECK_PROCESS_SUB_CAPTURE_MODIFY;
				}
			}
			else if(NfaCamCheckInfo.sub_Step  == NFACAMCHECK_PROCESS_SUB_CAPTURE_MODIFY)
			{
				if(init_camera_type[NfaCamCheckInfo.CamIndex]== CAMERA_KIND_NFA_2D)
				{	
					if(cam_timeout_cnt[NfaCamCheckInfo.CamIndex] > 0)
					{
						NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_CAPTURE_TIMEOUT;
					}
					else
					{
						if(cam_complete_count[NfaCamCheckInfo.CamIndex] != cam_trig_count[NfaCamCheckInfo.CamIndex])
						{
							NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_CAPTURE_COUNT;
						}
						else
						{
							if(cam_int_count[NfaCamCheckInfo.CamIndex] != (cam_trig_count[NfaCamCheckInfo.CamIndex] *18))
							{
								NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_CAPTURE_INTERRUPT;
							}
						}
					}					
				}
				else if(init_camera_type[NfaCamCheckInfo.CamIndex] == CAMERA_KIND_NFA_3D)
				{
					if(cam_timeout_cnt[NfaCamCheckInfo.CamIndex] > 0)
					{
						NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_CAPTURE_TIMEOUT;
					}
					else
					{
						if(cam_int_count[NfaCamCheckInfo.CamIndex] < NFACAMCHECK_CAPTURE_TIME)
						{	
							NfaCamCheckInfo.CheckResult_sub = NFA_CAM_CHECK_RESULT_CAPTURE_INTERRUPT;
						}
					}
				}
				if(NfaCamCheckInfo.CheckResult_sub == NFA_CAM_CHECK_RESULT_SUB_NONE)
				{
					NfaCamCheckInfo.CamIndex++;
					if(NfaCamCheckInfo.CamIndex == link_camera_count)
					{
						NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
						NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_NONE;
						NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_SUCCESS;
					}
				}
				else
				{
					NfaCamCheckInfo.main_Step = NFA_CAM_CHECK_NONE;
					NfaCamCheckInfo.sub_Step  = NFACAMCHECK_PROCESS_SUB_NONE;
					NfaCamCheckInfo.CheckResult = NFA_CAM_CHECK_RESULT_CAPTURE_FAIL;
				}
				
			}
		}
		break;		
		default:
			break;
	}
		
}
