#ifndef _SPB_SYSTEM_H_
#define _SPB_SYSTEM_H_

#include "common.h"
#include "environment.h"
#include "heap_control.h"


extern unsigned char G_SPB_INDEX;

//extern unsigned int CPB_Status[SYSTEM_CPB_MAX_COUNT];
extern unsigned int CPB_StatusList[SYSTEM_CPB_MAX_COUNT];	// read from cpb

#define PROCESSING_CAPTURE_STATUS_IDLE				1
#define PROCESSING_CAPTURE_STATUS_REQUESTED			2
#define PROCESSING_CAPTURE_STATUS_ON_CAPTURE		3
#define PROCESSING_CAPTURE_STATUS_FINISHED			4


#define CPB_BOOT_PROCESS_IDLE 					0
#define CPB_BOOT_PROCESS_READY				1
#define CPB_BOOT_PROCESS_LOAD_PROGRAM		2
#define CPB_BOOT_PROCESS_DOWNLOAD			3	
#define CPB_BOOT_PROCESS_RUN					4
#define CPB_BOOT_PROCESS_COMPLETE			5

#define CPB_HEX_FORMAT_L2SEG					0x1080
#define CPB_PROGRAM_TRANSFER_SIZE			(1024*2)			// 2k
#define CPB_BOOT_RETRY_COUNT					10
		
#define SRIO_BOOT_WAIT_TIME					5000			//5sec
typedef struct
{
	int Status;
	int Enabled;
	int CaptureHeight;
    int CapturedLineCount;
} TProcessingCaptureInfo;
extern TProcessingCaptureInfo ProcessingCaptureInfo[SYSTEM_SPB_CAMERA_MAX_COUNT];


typedef struct
{
	unsigned short CPUSpeed;
	unsigned int BaseL2Addr;
	unsigned int CPUKind;
	unsigned int CPBStatusAddr;
	unsigned int CPBWStateAddr;
	unsigned int CPBBuffer1Addr;
	unsigned int CPBBuffer2Addr;
	unsigned int CPBBuffer3Addr;
	unsigned int CPBBuffer4Addr;
	unsigned int HPIAddr_Addr;
	unsigned int HPIData_Inc_Addr;	
} TCPBInfo;
/*
typedef struct
{
	TCPBInfo CPBInfo[SYSTEM_CPB_COUNT];
	
} TSystemInfo;
*/

extern TCPBStatus CPBStatus[SYSTEM_CPB_COUNT];


//extern TSystemInfo SystemInfo;
extern TCPBRunStatus CPBRunStatus;

typedef struct
{
	unsigned int RunSW;
	unsigned int RunMode;
	unsigned int RunMask[2];
	TFFID RunCPB_FFID;
	unsigned char RunStep;
	unsigned char RunSubStep;
	char dummyChar[2];
	unsigned int WaitingStartTime;
	unsigned char RunSuccess[SYSTEM_CPB_COUNT];
	unsigned char Error[SYSTEM_CPB_COUNT];
	int CurrentCPBIndex;
	// for cpb download
	unsigned int TargetCPURev;
	int CPBProgramSize;
	unsigned char *CPBProgram;
	// for lru algorithm
	int LRUFileIndex;
	TFFID IDFile1;
	TFFID IDFile2;
	unsigned int TargetCPURev1;
	unsigned int TargetCPURev2;
	int CPBProgramSize1;
	int CPBProgramSize2;	
} TRunInfo;
extern TRunInfo RunInfo;

typedef struct
{
	unsigned int RunSW;
	unsigned int RunMode;
	TFFID RunCPB_FFID;
	unsigned char RunStep;
	char dummyChar[2];
	unsigned int WaitingStartTime;
	unsigned char RunSuccess[SYSTEM_CPB_COUNT];
	unsigned char Error[SYSTEM_CPB_COUNT];
	int CurrentCPBIndex;
	unsigned int TargetCPURev;
	int CPBProgramSize[SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT];
	unsigned char *CPBProgram[SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT];
} TSrioRunInfo;
extern TSrioRunInfo SrioRunInfo;

extern int CPBBootEnable;


typedef struct
{
	unsigned int CPBBuffer1Addr;
	unsigned int CPBBuffer2Addr;
	unsigned int CPBBuffer3Addr;
	unsigned int CPBBuffer4Addr;
	unsigned int DSPInt_Status_Addr;
	unsigned int CPBWStateAddr;
	unsigned int HPIData_Inc_Addr;
	unsigned int HPIAddr_Addr;
	unsigned int CPUKind;
	unsigned int CPBStatusAddr;
	unsigned int BaseL2Addr;
	unsigned int SrioBootStartAddr;
	unsigned int SrioBootRegisterAddr;
	unsigned int SrioCoreBootAddr;
	unsigned int SrioBootIntAddr;
	unsigned int SrioBootCompleteAddr;
	
} TCPBHWInfo;
extern TCPBHWInfo CPBHWInfo[SYSTEM_CPB_COUNT];

typedef struct
{
	unsigned char ProcessingState;
} TSSCPBInfo;

typedef struct
{
	TSSCPBInfo CPBInfo[SYSTEM_CPB_COUNT];
} TSPBSubSystem;

extern TSPBSubSystem SPBSubSystem;

extern TIdleProcessData IdleProcessData;

extern volatile int System_Reset_SW;
extern unsigned int System_Reset_Trigger_Time;

void ProcessingCapture_Init(void);
void ProcessingCapture_StatusReset(void);
void CPBProcessingCheckStart(int cpbIndex);
int Check_Process_Finished(int cpbIndex);
void Cpb_Boot_Process();

int Request_SendData(unsigned short indicator, void *data_address, int data_size, int cpbIndex, unsigned int dst_address);
int Request_SendPartialImage(int camIndex, int captureIndex, int left, int top, int width, int height, int cpbIndex);
int Request_ReceiveData(unsigned short indicator, void *data_address, unsigned int data_size, int cpbIndex);
void ThreeDImageFormatConversion(unsigned char *srcImage, unsigned char *dstImage);

#endif
