#ifndef _DMASCHEDULER_H_
#define _DMASCHEDULER_H_

// DMA Finish Value
#define DMA_FINISH_VALUE				1


#define DMA_CFG_COUNT					8
#define EDMA_CFG_NO_NONE_NO_NONE		0
#define EDMA_CFG_NO_NONE_NO_INC			1
#define EDMA_CFG_NO_INC_NO_NONE			2
#define EDMA_CFG_NO_INC_NO_INC			3
#define EDMA_CFG_YES_INC_NO_INC			4
#define EDMA_CFG_NO_INC_NO_DEC			5
#define EDMA_CFG_NO_IDX_NO_INC			6

#define DMA_ESIZE_COUNT					3

#define DMA_ESIZE_8BIT					0
#define DMA_ESIZE_16BIT					1
#define DMA_ESIZE_32BIT					2

#define DMA_SHIFT(ESIZE)				(ESIZE)


typedef struct
{
	unsigned int Opt;
	unsigned int Src;
	unsigned int Dst;
	unsigned int Cnt;
	unsigned int bytesize;
	unsigned int reduction;
	unsigned int Idx;	
	volatile unsigned int *Fin;
} TQDMARequestUnit;

int QDMA_QueueFull();
void QDMA_Request(TQDMARequestUnit *requestUnit);
void QDMA_Request_ScaleConversion(TQDMARequestUnit *requestUnit, int reduction, int byteSize);
void QDMAByteConversion(unsigned int srcAddr, unsigned int dstAddr, unsigned int srcLength);
unsigned int MakeDMAOpt(unsigned int eSize, unsigned int cfg);

#endif
