#include "DMAScheduler.h"
#include "timer.h"
#include "TPBcamera.h"
#include "hardware.h"
#include "environment.h"
#include "image_control.h"
#include "data_indicator.h"
#include "srio_master.h"

#define TIME_QUEUE_MASK						255
extern CSL_Edma3Handle 				hNFAEdma;
CSL_Edma3CmdDrae            		nfaRegionSetup;
int Capture_drae,Capture_draeh;

CSL_Edma3ChannelAttr        		nfaChannelSetup;
CSL_Edma3ChannelObj         		nfaChObj;
CSL_Edma3CmdIntr            		nfaRegionIntr;

CSL_Edma3ParamHandle			hNFACamEdmaParam;
CSL_Edma3ChannelHandle			hNFAChannel;
CSL_Edma3ParamSetup				NFACamEdmaParamSet;
int nfaCaptureEDMATCCNumber;

//camera init
int init_Process;
int Uart_process;
int Uart_Polarity;
int link_camera_count;
int camera_init_current_time;
int uart_txbuf[MAX_COMM_DATA_LENGTH], uart_rxbuf[MAX_COMM_DATA_LENGTH];
int tx_ptr, rx_ptr;
int camera_cnt;
char ReceivedData[MAX_COMM_DATA_LENGTH];
int camera_rData=0;
int test_trg_one=0;
int pola_cng_one = 0;
int init_camera_type = 0;
int ExpectedRS232ReceiveDataCount;
unsigned int MakeIdleChannelProcessingStartTime;

TNFACaptureInfo NFACaptureInfo;
TNFACamCommend NFACommendRx;
TNFACamCommend NFACommendTx;
TTBPProcessInfo TPBProcessInfo;
TTPBInsProcessInfo TPBInsProcessInfo;

unsigned short NFA_triger = 0;
unsigned short TpbToHcb_trig = 7;
TDefectData	DefectData_FromCPB;
TTPBTimeInfo TestDebug;
TTPBInspectionData InspectDataTbp;
int tes_ins_count[2]={0,0};
int isr_count = 0;
int test_isr = 0;
int test_cnnt[3] = {0,0,0};
void TPBCaptureComplete(void);
//---------------------------------------------------------------------------
void TPMisejectInit(void)
{
		TPB_CAMERA_INT = 0;
		TPB_CAMERA_INT = 0;
}


void TPBCameraInit(void)
{
	int	camIndex;
	CSL_Edma3Context            context;
	CSL_Status                  status; 
	NFA_triger = 0;
	CSL_intcInterruptEnable(CSL_INTC_VECTID_4);
	memset(NFACommendRx,0x00,sizeof(NFACommendRx));
	memset(NFACommendTx,0x00,sizeof(NFACommendRx));
	NFACaptureInfo.CaptureStep =	CAPTURE_STEP_NONE;
	NFACaptureInfo.CaptureTimeout1ms= 0;
	NFACaptureInfo.FrameWidth = SYSTEM_CAMERA_WIDTH;
	NFACaptureInfo.FrameHeight = SYSTEM_CAMERA_HEIGHT;
	NFACaptureInfo.CaptureTopPos = NFA_2D_CAPTURE_TOP_POS_FULL_CAPTURE;
	NFACaptureInfo.CaptureStartTime = 0;
	NFACaptureInfo.CaptureEndTime = 0;
	NFACaptureInfo.DMATriggerCount = 18;
	NFACaptureInfo.CaptureErrorCount = 0;
	NFACaptureInfo.CaptureStatus = TPB_CAPTURE_NONE;
	NFACaptureInfo.CaptureOption = TPB_OPTION_CAPTURE;
	NFACaptureInfo.CapturePeriod = 400;
	NFACaptureInfo.CaptureUploadOption = FREE_IMG_UPLOAD;
	
	NFACommendTx.Header = 0xA1;
	NFACommendTx.Tail = 0xAE;
	NFACommendTx.Id = 16;
	nfaChannelSetup.regionNum = CSL_EDMA3_REGION_1;
	nfaChannelSetup.chaNum = CSL_EDMA3_CHA_4;
	hNFAChannel = CSL_edma3ChannelOpen(&nfaChObj, CSL_EDMA3, &nfaChannelSetup, &status);
	CSL_edma3HwChannelControl(hNFAChannel,CSL_EDMA3_CMD_CHANNEL_ENABLE, NULL);
		
	nfaCaptureEDMATCCNumber = AllocEDMAInterruptHandler(TPBCaptureComplete,CSL_EDMA3_CHA_4);

	nfaRegionSetup.region = CSL_EDMA3_REGION_1;
	nfaRegionSetup.drae = 0xF0;
	nfaRegionSetup.draeh= 0x0;
	CSL_edma3HwControl(hNFAEdma,CSL_EDMA3_CMD_DMAREGION_ENABLE,&nfaRegionSetup);

	
	NFACamEdmaParamSet.option = CSL_EDMA3_OPT_MAKE( CSL_EDMA3_ITCCH_DIS, CSL_EDMA3_TCCH_DIS, CSL_EDMA3_ITCINT_DIS, CSL_EDMA3_TCINT_EN,\
                                              nfaCaptureEDMATCCNumber, CSL_EDMA3_TCC_NORMAL, CSL_EDMA3_FIFOWIDTH_64BIT, CSL_EDMA3_STATIC_DIS, CSL_EDMA3_SYNC_A, CSL_EDMA3_ADDRMODE_INCR, CSL_EDMA3_ADDRMODE_INCR); 

	NFACamEdmaParamSet.srcAddr= (Uint32) NFACAM_FIFO_ADDR(0);
	NFACamEdmaParamSet.aCntbCnt	=  CSL_EDMA3_CNT_MAKE(NFA_HALF_FIFO_SIZE, 1);				 						
	NFACamEdmaParamSet.srcDstBidx = CSL_EDMA3_BIDX_MAKE(8,0);     
	NFACamEdmaParamSet.linkBcntrld = CSL_EDMA3_LINKBCNTRLD_MAKE(CSL_EDMA3_LINK_NULL,0);     
	NFACamEdmaParamSet.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,0);     
	NFACamEdmaParamSet.cCnt = 1;
	
	if(nfaCaptureEDMATCCNumber < 32)
	{
		nfaRegionIntr.region = CSL_EDMA3_REGION_1;
		nfaRegionIntr.intr =  (0x1 << nfaCaptureEDMATCCNumber);
		nfaRegionIntr.intrh =  0x0;
	}
	else
	{
		nfaRegionIntr.region = CSL_EDMA3_REGION_1;
		nfaRegionIntr.intr =  0x0;		
		nfaRegionIntr.intrh = (0x1 << (nfaCaptureEDMATCCNumber - 32));
	}
	CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_ENABLE,&nfaRegionIntr); 
	hNFACamEdmaParam = CSL_edma3GetParamHandle(hNFAChannel, CSL_EDMA3_CHA_4, &status);
	TpbToHcb_trig = 7;
	TPB_CAMERA_INT = TpbToHcb_trig;
	TPBInspectInit();
	InspectDataTbp.TabletLength = 10;
	InspectDataTbp.TabletWidth= 4;

}

void TPBInspectInit()
{
	memset(TPBProcessInfo,0x00,sizeof(TPBProcessInfo));
	memset(TestDebug,0x00,sizeof(TestDebug));
	memset(DefectData_FromCPB,0x00,sizeof(DefectData_FromCPB));
	memset(tes_ins_count,0x00,sizeof(tes_ins_count));
	NomalImageInfo.cpbsendIndex = 0;
	NomalImageInfo.cpbsendIndex = 0;
	NomalImageInfo.uploadIndex = 0;
	NomalImageInfo.inspectionIndex = 0;
}	
int	TPBCaptureTrigger(unsigned char *captureImage)
{
	TNFACaptureInfo *captureInfo;
	CSL_Edma3CmdIntr            regionIntr;
	CSL_Status                  status;
	CSL_IntcGlobalEnableState 	state;

	captureInfo	= &NFACaptureInfo;
	if (captureInfo->CaptureStep !=	CAPTURE_STEP_NONE)
	{
		return -1;
	}
	
	CSL_intcGlobalDisable(&state);	

	captureInfo->CaptureTimeout1ms = CAPTURE_READ_TIMEOUT;
	captureInfo->CaptureStep = CAPTURE_STEP_ON_CAPTURE;
	captureInfo->DMATriggerCount = ((NFACaptureInfo.FrameWidth * (NFACaptureInfo.FrameHeight - NFACaptureInfo.CaptureTopPos)) / NFA_HALF_FIFO_SIZE)-1;

	NFACamEdmaParamSet.aCntbCnt = CSL_EDMA3_CNT_MAKE(NFA_HALF_FIFO_SIZE, 1);
	NFACamEdmaParamSet.dstAddr = (Uint32) (captureImage + captureInfo->CaptureTopPos * captureInfo->FrameWidth);
	CSL_edma3ParamSetup(hNFACamEdmaParam, &NFACamEdmaParamSet);

	captureInfo->CaptureStartTime = Board50usTimer;
	NomalImageInfo.Status[NomalImageInfo.currentIndex] = TPB_IMAGEBUFFER_STATUS_CAPTURE;
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = 0;
	NFA_SET_BIT(NFA_triger,0);
	NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
	CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_ENABLE,&nfaRegionIntr);
	CSL_intcGlobalEnable(&state);	
	return 0;
}

void TPBCaptureStop()
{
	NFA_RESET_BIT(NFA_triger,0);
	NFACaptureInfo.CaptureTimeout1ms	= 0;
	NFACaptureInfo.CaptureStep = CAPTURE_STEP_NONE;	
	NFACaptureInfo.CaptureStatus = TPB_CAPTURE_STOP;
}

void TPBCaptureAbort()
{
	if (NFACaptureInfo.CaptureStep != CAPTURE_STEP_NONE)
	{
		TPBCaptureStop();
	}
	NFACaptureInfo.CaptureTimeout1ms	= 0;
	NFACaptureInfo.CaptureStep = CAPTURE_STEP_NONE;
	NFACaptureInfo.CaptureErrorCount++;
	NFACaptureInfo.CaptureStatus = TPB_CAPTURE_START;
}
//---------------------------------------------------------------------------
// check capture timeout
void TPBCaptureTimeOutProcess(void)
{
	int	camIndex;
	TNFACaptureInfo *captureInfo;
	unsigned int frmCount;
	int rFrameIndex;
	
	captureInfo	= &NFACaptureInfo;
	if (captureInfo->CaptureStep !=	CAPTURE_STEP_NONE)
	{
		if (captureInfo->CaptureTimeout1ms)
		{
			captureInfo->CaptureTimeout1ms--;
		}
		else
		{		
			TPBCaptureAbort();
			ErrorUnit_Put(BoardID, ERROR_TYPE_CRITICAL,	ERROR_CODE_CAPTURE_TIMEOUT,__LINE__ , NFACaptureInfo.DMATriggerCount,	NFACaptureInfo.CaptureErrorCount);
			CSL_edma3HwControl(hNFAEdma ,CSL_EDMA3_CMD_INTR_DISABLE,&nfaRegionIntr); 
		}
	}
	
}

void TPBProcessCapture(void)
{
	if(NFACaptureInfo.CaptureStatus == TPB_CAPTURE_START) 
	{
		if(NFACaptureInfo.CapturePeriodCount <= 0)
		{
			NFACaptureInfo.CapturePeriodCount = NFACaptureInfo.CapturePeriod;
			TPBCaptureTrigger(NomalImageInfo.ImageBuffer[NomalImageInfo.currentIndex]);
			TestDebug.startTime[TestDebug.checkcount] = Board50usTimer;
			TestDebug.period[TestDebug.checkcount] = TestDebug.startTime[TestDebug.checkcount] - TestDebug.startTime[(TestDebug.checkcount-1)&TIME_QUEUE_MASK]  ;
			TestDebug.checkcount = (TestDebug.checkcount + 1) & TIME_QUEUE_MASK;				
		}
//		else if((NFACaptureInfo.CapturePeriodCount>5)&&(NFACaptureInfo.CapturePeriodCount < 8))
		else if((NFACaptureInfo.CapturePeriodCount > NFACaptureInfo.CaptureDelay_Min) && (NFACaptureInfo.CapturePeriodCount < NFACaptureInfo.CaptureDelay_Max))
		{
		  NFA_RESET_BIT(TpbToHcb_trig,1);
	    NFACaptureInfo.CapturePeriodCount--;			
		}
		else
		{
			NFA_SET_BIT(TpbToHcb_trig,1);
			NFACaptureInfo.CapturePeriodCount--;
		}
	}

	TPB_CAMERA_INT = TpbToHcb_trig;
}

void TPBProcess()
{
	int i;
	int index;
	int cpb_status;

	if(NFACaptureInfo.CaptureOption == TPB_OPTION_INSPECTION)
	{
		if((NomalImageInfo.Status[NomalImageInfo.cpbsendIndex] == TPB_IMAGEBUFFER_STATUS_CAPTURE_END))
		{					
			
			for(i = 1 ; i < TPB_CPB_MAX_COUNT;i++)
			{
				cpb_status = Check_CPBProcess(i);					
				TPBProcessInfo.cpbStatus[i] = cpb_status;
				if(TPBProcessInfo.ProcessStep[i] ==TPB_PROCESS_STEP_NONE)
				{
					//cpb_status = Check_CPBProcess(i);					
					if((cpb_status == CPB_PROCESSING_FINISHED) || (cpb_status == CPB_PROCESSING_READY))
					{				
						TPBProcessInfo.cpbIndex[i] = NomalImageInfo.cpbsendIndex;
						NomalImageInfo.Status[NomalImageInfo.cpbsendIndex] = TPB_IMAGEBUFFER_STATUS_INSPECTION;
						TPBProcessInfo.imagesendTime[i].startTime[TPBProcessInfo.imagesendTime[i].checkcount]= Board50usTimer;
						TPBProcessInfo.imagesendTime[i].cpbIndex[TPBProcessInfo.imagesendTime[i].checkcount] = i;
						TPBProcessInfo.ProcessStep[i] =TPB_PROCESS_STEP_SEND_IMAGE;
						break;
					}
				}
			}
		}
		for(index = 1; index < TPB_CPB_MAX_COUNT;index++)
		{
			if(TPBProcessInfo.ProcessStep[index] ==TPB_PROCESS_STEP_SEND_IMAGE)
			{
				  TPBProcessInfo.imagesendTime[i].startTime[TPBProcessInfo.imagesendTime[i].checkcount]= Board50usTimer;
				if(SRIO_SendData(PRI_IND_PROCESSING, IND_IMAGE_BUFFER_1, (unsigned char *)NomalImageInfo.ImageBuffer[NomalImageInfo.cpbsendIndex], 640/4, index, SRIO_TRANSFER_KIND_IMAGE, 480, 0, 0))
				{
					TPBProcessInfo.ProcessStep[index] =TPB_PROCESS_STEP_SEND_DATA;					
					TPBProcessInfo.imagesendTime[index].endTime[TPBProcessInfo.imagesendTime[index].checkcount]= Board50usTimer;
					TPBProcessInfo.imagesendTime[index].period[TPBProcessInfo.imagesendTime[index].checkcount]= TPBProcessInfo.imagesendTime[index].endTime[TPBProcessInfo.imagesendTime[index].checkcount]- TPBProcessInfo.imagesendTime[index].startTime[TPBProcessInfo.imagesendTime[index].checkcount];
					TPBProcessInfo.imagesendTime[index].checkcount = (TPBProcessInfo.imagesendTime[index].checkcount + 1) & TIME_QUEUE_MASK;						
					TPBProcessInfo.ProcessingTime[index].startTime[TPBProcessInfo.ProcessingTime[index].checkcount] = Board50usTimer;
					TPBProcessInfo.ProcessingTime[index].cpbIndex[TPBProcessInfo.ProcessingTime[index].checkcount] = index;
					NomalImageInfo.cpbsendIndex++;
					if(NomalImageInfo.cpbsendIndex >= NomalImageInfo.BlockCount) NomalImageInfo.cpbsendIndex = 0; 
				}
				else
				{
					//error
				}
			}
			else if(TPBProcessInfo.ProcessStep[index] ==TPB_PROCESS_STEP_SEND_DATA)
			{
				InspectDataTbp.CaptureUploadOption = 0;
				InspectDataTbp.CaptureDelay_Min = 5;
				InspectDataTbp.CaptureDelay_Max = 8;
		    if(SRIO_SendData(PRI_IND_PROCESSING, IND_TPB_INSPECTION, &InspectDataTbp, (sizeof(InspectDataTbp) + 3) / 4, index, SRIO_TRANSFER_KIND_DATA, 1, 0, 0))
				{
					TPBProcessInfo.ProcessStep[index] =TPB_PROCESS_STEP_WATING_RESULT;				
				}
				else
				{
				//error
				}
			}
			else if(TPBProcessInfo.ProcessStep[index] ==TPB_PROCESS_STEP_WATING_RESULT) 
			{
				if(Check_CPBProcess(index) == CPB_PROCESSING_FINISHED)
				{
					if (Request_ReceiveData(IND_INSPECTION_RESULT, &DefectData_FromCPB, sizeof(TDefectData), index))
					{
						TPBProcessInfo.ProcessStep[index] =TPB_PROCESS_STEP_END;
						TPBProcessInfo.ProcessingTime[index].endTime[TPBProcessInfo.ProcessingTime[index].checkcount] = Board50usTimer;

						if(DefectData_FromCPB.TPBInsDefect==1)
						{
								NomalImageInfo.Status[TPBProcessInfo.cpbIndex[index]] = TPB_IMAGEBUFFER_STATUS_DEFECT_IMAGE_LOAD;
								 NFA_RESET_BIT(TpbToHcb_trig,0);	
						}
						else
						{
								if(NFACaptureInfo.CaptureUploadOption == FREE_IMG_UPLOAD)
								{
									NomalImageInfo.Status[TPBProcessInfo.cpbIndex[index]] = TPB_IMAGEBUFFER_STATUS_DEFECT_IMAGE_LOAD;
								}
								else
								{
									NomalImageInfo.Status[TPBProcessInfo.cpbIndex[index]] = TPB_IMAGEBUFFER_STATUS_GOOD_IMAGE_LOAD;
								}

								NFA_SET_BIT(TpbToHcb_trig,0);	
						}
						TPBMonitorInsData.cpbSendIndex = TPBProcessInfo.cpbIndex[index];
						TPBMonitorInsData.workedCoreIndex = index;
						TPBMonitorInsData.inspection_result = DefectData_FromCPB.TPBInsDefect;
						TPBMonitorInsData.TPBMinX1 = DefectData_FromCPB.TPBMinX1;
						TPBMonitorInsData.TPBMaxX1 = DefectData_FromCPB.TPBMaxX1;
						TPBMonitorInsData.TPBMinY1 = DefectData_FromCPB.TPBMinY1;
						TPBMonitorInsData.TPBMaxY1 = DefectData_FromCPB.TPBMaxY1;
						TPBMonitorInsData.TPBMinX2 = DefectData_FromCPB.TPBMinX2;
						TPBMonitorInsData.TPBMinX3 = DefectData_FromCPB.TPBMinX3;
						TPBMonitorInsData.TPBMaxX3 = DefectData_FromCPB.TPBMaxX3;
						TPBMonitorInsData.TPBMinY3 = DefectData_FromCPB.TPBMinY3;
						TPBMonitorInsData.TPBMaxY3 = DefectData_FromCPB.TPBMaxY3;
					}
					else
					{
						//error
					}
				}
			}
			else if(TPBProcessInfo.ProcessStep[index] ==TPB_PROCESS_STEP_END)
			{
				//nozzle action
				TPBProcessInfo.ProcessingTime[index].period[TPBProcessInfo.ProcessingTime[index].checkcount] = TPBProcessInfo.ProcessingTime[index].endTime[TPBProcessInfo.ProcessingTime[index].checkcount]-TPBProcessInfo.ProcessingTime[index].startTime[TPBProcessInfo.ProcessingTime[index].checkcount];
				TPBProcessInfo.ProcessingTime[index].checkcount = (TPBProcessInfo.ProcessingTime[index].checkcount + 1) & TIME_QUEUE_MASK;
				NomalImageInfo.inspectionIndex++;
				if(NomalImageInfo.inspectionIndex >= NomalImageInfo.BlockCount) NomalImageInfo.inspectionIndex = 0; 
				TPBProcessInfo.ProcessStep[index] =TPB_PROCESS_STEP_NONE;

			}
		}
	}		
}

//---------------------------------------------------------------------------
void TPBCaptureComplete(void)
{
	int camIndex = 0;
	CSL_IntcGlobalEnableState 	state;
	if(NFACaptureInfo.CaptureStep == CAPTURE_STEP_ON_CAPTURE)
	{
		if (NFACaptureInfo.DMATriggerCount == 0)
		{
			NFA_CAMERA_CONTROL_HARDWARE_TRIG = 0;
			NFACaptureInfo.CaptureEndTime = Board50usTimer;
			NomalImageInfo.CapturePeriod[NomalImageInfo.currentIndex] = NFACaptureInfo.CaptureEndTime- NFACaptureInfo.CaptureStartTime;

		
			NFACaptureInfo.CaptureStep = CAPTURE_STEP_NONE;	
			if(NFACaptureInfo.CaptureOption == TPB_OPTION_INSPECTION)
			{
				NomalImageInfo.Status[NomalImageInfo.currentIndex] = TPB_IMAGEBUFFER_STATUS_CAPTURE_END;
			}
			else
			{
				NomalImageInfo.Status[NomalImageInfo.currentIndex] = TPB_IMAGEBUFFER_STATUS_DEFECT_IMAGE_LOAD;
			}
			NomalImageInfo.currentIndex++;
			if(NomalImageInfo.currentIndex >= NomalImageInfo.BlockCount) NomalImageInfo.currentIndex = 0; 

		}
		else
		{
			NFACaptureInfo.DMATriggerCount--;
		}
	}
}
void TPBCameraIsr(void)
{
	isr_count++;
	if(!(NFA_FIFO_HALF_STATUS_REG&0x1)) 
	{
		//error
	}
	else
	{
		CSL_edma3ParamSetup(hNFACamEdmaParam, &NFACamEdmaParamSet);
		CSL_edma3HwChannelControl(hNFAChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
		NFACamEdmaParamSet.dstAddr += (Uint32) NFA_HALF_FIFO_SIZE;
		
	}
}
void NFACamera_Init()
{	
	int i,j;
	int result = 0;
	
	NFA_RS232_Init(); // RS232 ʱȭ
	NFA_Hardware_Init(); // ϵ ʱȭ 
	Process_Parameter_clear();

	NFA_CAMERA_CONTROL_TRIG = 0x0010;
	NFA_FIFO_ENABLE = 0x0000;
	NFA_FIFO_RESET = 0x00FF;

	camera_cnt = 1;
		
	// Received Borad Camera ID Set
	for(i = 0 ; i < SYSTEM_SPB_CAMERA_MAX_COUNT;i ++)
	{
		NFA_CAMERA_ID(i) = 0x31+i;
	}

	
	if (NFA_CAMERA_RX_CONTROL_REG & ((0x1<<RX_CONTROL_HOT_PLUG_DETECT_1_BIT )|(0x1<<RX_CONTROL_HOT_PLUG_DETECT_2_BIT ))) // Cable Hot Plug Detection//0.1ms 
	{	
		if(!Uart_connectction_enable())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Camera_id_set())
			{
			Camera_Init_Error();
			return ;
			}
			
		if(!Camera_hardware_reset())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Camera_output_enable())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Polarity_request())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Polarity_set())
			{
			Camera_Init_Error();
			return ;
			}

		if(!Valid_line_number_set())
		{
			Camera_Init_Error();
			return ;
			}
		
		if(!Trigger_line_check())
			{
			Camera_Init_Error();
			return ;
		}			
		
		NFA_FIFO_ENABLE = 0x00;
		NFA_FIFO_RESET = 0x00;
		NFA_FIFO_RESET = 0xFF;
		NFA_FIFO_ENABLE = 0x00;		
		NFA_CAMERA_CONTROL_TRIG = 0x8000;

		TPBCaptureTrigger((void *)0xE0000000);
	}
	else
	{
		printf("Camera HOT_PLUG_DETECT Error!!\n");
	}	
}

void NFA_RS232_Init()
{
	int dummy;
	NFA_RS232_BAUDRATE_REG = (NFA_CAMERA_CLK / NFA_CAMERA_BAUDRATE) - 1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	
	NFA_RS232_STATUS_CONTROL_REG = 0x0;
	
	while(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT)) dummy = NFA_RS232_DATA_REG;
	while(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT));
}
void NFA_Hardware_Init()
{
	//RX
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_RESET_BIT);
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_VLN_RESET_BIT);
	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_PACKET_ERR_RESET_BIT);
	
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_RESET_BIT);
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_VLN_RESET_BIT);
	NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_PACKET_ERR_RESET_BIT);

	NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_ENABLE_BIT);

	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_RESET_BIT);     
	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_DISPARITY_ERR_RESET_BIT);  
	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_10TO8_ERR_RESET_BIT);  
	NFA_SET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_CHANNEL_BOND_ERR_BIT);

	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_RESET_BIT);     
	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_DISPARITY_ERR_RESET_BIT);  
	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_10TO8_ERR_RESET_BIT);  
	NFA_RESET_BIT(NFA_CAMERA_RX_CORE_REG,RX_CORE_CHANNEL_BOND_ERR_BIT);
}

void Process_Parameter_clear()
{
	camera_init_current_time = Board1MSTmr;
	init_Process = NFA_INIT_HOT_FLUG_DETECT_DONE;
	Uart_process = UART_READY;
	Uart_Polarity = 0;
}

int Uart_connectction_enable()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x05;
				NFACommendTx.Data[0]= 0x00;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];			
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if(camera_init_current_time + 10 < Board1MSTmr)
				{
					if(Uart_Polarity)
					{
						NFA_CAMERA_RX_POLARITY_REG &= 0x0fff;
						NFA_CAMERA_RX_POLARITY_REG |= 0x5000;
						Uart_process = UART_READY;
						Uart_Polarity = 0;
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
					}
					else
					{
						NFA_CAMERA_RX_POLARITY_REG &= 0x0fff;
						NFA_CAMERA_RX_POLARITY_REG |= 0xA000;
						Uart_process = UART_READY;
						Uart_Polarity = 1;
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
						NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
						NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);					
					}
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}


int Camera_id_set()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x7B;
				NFACommendTx.Data[0]= 0x01;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];			
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}


int Camera_hardware_reset()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x01;
				NFACommendTx.Data[0]= 0x00;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];			
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

int Camera_output_enable()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x10;
				NFACommendTx.Data[0]= 0x00;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];				
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(100);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

int Polarity_request()
{

	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				NFA_SET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
				Sleep(10);
				NFA_RESET_BIT(NFA_CAMERA_RX_CONTROL_REG, RX_CONTROL_POLARITY_RESET_BIT);
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x20;
				NFACommendTx.Data[0]=  0x00;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];				
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				camera_rData =(NFA_CAMERA_POLARITY_STATUS_REG >> 8) & 0x0F;
				NFA_CAMERA_RX_CORE_REG = (NFA_CAMERA_RX_CORE_REG & 0xFF0F)|(camera_rData << 4);
				NFA_CAMERA_RX_POLARITY_REG = ( NFA_CAMERA_RX_POLARITY_REG & 0xFFF0 ) | camera_rData;
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
	
}
int Polarity_set()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x22;
				NFACommendTx.Data[0]=  0x00;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];			
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_COMPLETE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}


int Valid_line_number_set()
{
	int temp[20];
	int i = 0;
	int int_start =1;
	int camIndex = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{
				//set command
				NFACommendTx.Length[0] = 0x01;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6A;
				NFACommendTx.Code2= 0x25;
				NFACommendTx.Data[0]=  0x00;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];	
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];
						Uart_process = UART_CAMERA_ID_CHECK;
						
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if(Uart_process == UART_CAMERA_ID_CHECK)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>9)
					{
						i =0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];
						NFACommendRx.Data[1]= temp[7];				
						NFACommendRx.Tail= temp[8];
						NFACommendRx.chksum= temp[9];
						if(NFACommendRx.Data[1] == CAMERA_KIND_NFA_2D)
						{ 
							init_camera_type = CAMERA_KIND_NFA_2D;
//							printf("%d Cam is 2D Cam\n",NFACommendRx[camIndex].Data1);
						}
						else
						{
							init_camera_type = CAMERA_KIND_NFA_3D;
//							printf("%d Cam is 3D Cam\n",NFACommendRx[camIndex].Data1);
						}						
						if(camera_cnt < 1)
						{
							camera_cnt++;
							camera_init_current_time = Board1MSTmr;
						}
						else
						{
							Uart_process = UART_COMPLETE;							
						}
					}
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT*3)<Board1MSTmr)
				{
					Uart_process = UART_COMPLETE;
					camera_cnt--;
				}
			}

			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;
				link_camera_count = camera_cnt;
				camera_cnt = 1;
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

int Trigger_line_check()
{
	int temp[20];
	int i = 0;
	int camIndex;
	int int_start =1;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_CAMERA_CONTROL_TRIG = 0x8000;

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return 0;
	}
	else
	{
		while(int_start)
		{
			camIndex = camera_cnt - 1;
			if(Uart_process == UART_READY)
			{				
				Lamp2Toggle();
				NFA_RESET_BIT(NFA_triger,camIndex);
				NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;
//				printf("%d camera Read current pola check\n", camera_cnt);
				Lamp2Toggle();
				NFA_SET_BIT(NFA_triger,camIndex);
				NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;				
				Lamp2Toggle();
				NFA_RESET_BIT(NFA_triger,camIndex);
				NFA_CAMERA_CONTROL_HARDWARE_TRIG = NFA_triger;				
				Sleep(100);
				NFACommendTx.Length[0] = 0x02;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6C;
				NFACommendTx.Code2= 0x62;
				NFACommendTx.Data[0]=  0x40;
				NFACommendTx.Data[1]=  0x90;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Data[1];
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Data[1];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>11)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];
						NFACommendRx.Data[1]= temp[7];	
						NFACommendRx.Data[2]= temp[8];	
						NFACommendRx.Data[3]= temp[9];	
						NFACommendRx.Tail= temp[10];
						NFACommendRx.chksum= temp[11];
						if(init_camera_type == 2){
							if( NFACommendRx.Data[1] != 0 && NFACommendRx.Data[1] != 32 )
							{
//								printf("%d camera pola change\n", camera_cnt);
								Uart_process = UART_CAMERA_POLARITY_CHANGE_SEND;
								if(NFACommendRx.Data[0]&0x02)
								{
									NFACommendTx.Data[2] = camIndex*16 + 0x8; //
									NFACommendTx.Data[3] = 0x00;
									NFACommendTx.Data[4] = 0x00;
									NFACommendTx.Data[5] = 0x00;
								}
								else
								{
									NFACommendTx.Data[2] = camIndex*16 + 0x8 + 0x02; //
									NFACommendTx.Data[3] = 0x00;
									NFACommendTx.Data[4] = 0x00;
									NFACommendTx.Data[5] = 0x00;
								}								
							}
							else 
							{					
								Uart_process = UART_CAMERA_POLARITY_CHANGE_SEND;
								if(NFACommendRx.Data[0]&0x02){
									NFACommendTx.Data[2] = camIndex*16 + 0x8+ 0x02; //
									NFACommendTx.Data[3] = 0x00;
									NFACommendTx.Data[4] = 0x00;
									NFACommendTx.Data[5] = 0x00;
								}
								else
								{
									NFACommendTx.Data[2] = camIndex*16 + 0x8; //
									NFACommendTx.Data[3] = 0x00;
									NFACommendTx.Data[4] = 0x00;
									NFACommendTx.Data[5] = 0x00;
								}
							}
						}
						else
						{
							Uart_process = UART_CAMERA_POLARITY_CHANGE_DONE;
						}
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if(Uart_process == UART_CAMERA_POLARITY_CHANGE_SEND)
			{
				//set command
				NFACommendTx.Length[0] = 0x06;
				NFACommendTx.Length[1] = 0x00;
				NFACommendTx.Code1= 0x6C;
				NFACommendTx.Code2= 0x61;
				NFACommendTx.Data[0]=  0x40;
				NFACommendTx.Data[1]=  0x90;

				//make checksum
				NFACommendTx.chksum = NFACommendTx.Header;
				NFACommendTx.chksum ^= NFACommendTx.Length[0];
				NFACommendTx.chksum ^= NFACommendTx.Length[1];
				NFACommendTx.chksum ^= NFACommendTx.Id;
				NFACommendTx.chksum ^= NFACommendTx.Code1;
				NFACommendTx.chksum ^= NFACommendTx.Code2;
				NFACommendTx.chksum ^= NFACommendTx.Data[0];
				NFACommendTx.chksum ^= NFACommendTx.Data[1];
				NFACommendTx.chksum ^= NFACommendTx.Data[2];
				NFACommendTx.chksum ^= NFACommendTx.Data[3];
				NFACommendTx.chksum ^= NFACommendTx.Data[4];
				NFACommendTx.chksum ^= NFACommendTx.Data[5];				
				NFACommendTx.chksum ^= NFACommendTx.Tail;

				//tx data transfer
				NFA_RS232_DATA_REG = NFACommendTx.Header;
				NFA_RS232_DATA_REG = NFACommendTx.Length[0];
				NFA_RS232_DATA_REG = NFACommendTx.Length[1];
				NFA_RS232_DATA_REG = NFACommendTx.Id;
				NFA_RS232_DATA_REG = NFACommendTx.Code1;
				NFA_RS232_DATA_REG = NFACommendTx.Code2;
				NFA_RS232_DATA_REG = NFACommendTx.Data[0];
				NFA_RS232_DATA_REG = NFACommendTx.Data[1];
				NFA_RS232_DATA_REG = NFACommendTx.Data[2];
				NFA_RS232_DATA_REG = NFACommendTx.Data[3];
				NFA_RS232_DATA_REG = NFACommendTx.Data[4];
				NFA_RS232_DATA_REG = NFACommendTx.Data[5];
				NFA_RS232_DATA_REG = NFACommendTx.Tail;
				NFA_RS232_DATA_REG = NFACommendTx.chksum;
				Uart_process = UART_CAMERA_POLARITY_CHANGE_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
			else if(Uart_process == UART_CAMERA_POLARITY_CHANGE_RECEIVE)
			{
				if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
				{
					temp[i] = NFA_RS232_DATA_REG;
					if(temp[0] == NFACommendTx.Header)
					{
						i++;
					}
					if(i>8)
					{
						i=0;
						NFACommendRx.Header = temp[0];
						NFACommendRx.Length[0]= temp[1];
						NFACommendRx.Length[1]= temp[2];
						NFACommendRx.Id= temp[3];
						NFACommendRx.Code1= temp[4];
						NFACommendRx.Code2= temp[5];
						NFACommendRx.Data[0]= temp[6];
						NFACommendRx.Tail= temp[7];
						NFACommendRx.chksum= temp[8];						
						Uart_process = UART_CAMERA_POLARITY_CHANGE_DONE;
					}	
				}
				else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
				{
					int_start =0;
					Uart_process = UART_READY;
					return 0;
				}
			}
			else if (Uart_process == UART_CAMERA_POLARITY_CHANGE_DONE)
			{
				if(camera_cnt == link_camera_count)
				{
					Uart_process = UART_COMPLETE;
				}
				else
				{
					camera_cnt++;
					Uart_process = UART_READY;
				}
			}
			else if (Uart_process == UART_COMPLETE)
			{
				int_start =0;
				Uart_process = UART_READY;	
				Sleep(500);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);			
			}
		}
	}
	return 1;
}

void Shutter_speed_change()
{
	int i;	
	camera_cnt = 1;
	while(1) 
	{
		if (!Uart_process)
		{		
			uart_txbuf[0] = 0xA1; uart_txbuf[1] = 0x02; uart_txbuf[2] = 0x00; uart_txbuf[3] = camera_cnt * 16;
			uart_txbuf[4] = 0x6C; uart_txbuf[5] = 0x46; uart_txbuf[6] = 0xE8; uart_txbuf[7] = 0x03;
			uart_txbuf[8] = 0xAE; uart_txbuf[9] = uart_txbuf[0];
			for (i = 1; i < 9; i++) uart_txbuf[9] ^= uart_txbuf[i];

			Uart_process = UART_TRANS;
			tx_ptr = 0;
			rx_ptr = 0;
		}
		else if (Uart_process == UART_TRANS)
		{
			if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty ?
			{
				NFA_RS232_DATA_REG = uart_txbuf[tx_ptr];
				tx_ptr++;
				if (tx_ptr>9)
				{
					Uart_process = UART_RECEIVE;
				}
			}
		}
		else if (Uart_process == UART_RECEIVE)
		{
			if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
			{
				uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
				if(uart_rxbuf[0] == 0xA1) {
					rx_ptr++;
				}
				if (rx_ptr>8)
				{
					Uart_process = UART_COMPLETE;	
//					printf("%d cam speed change\n", camera_cnt);				
				}
			}
			else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT/5)<Board1MSTmr)
			{
			Uart_process=UART_COMPLETE;
			}
		}
		else if (Uart_process == UART_COMPLETE)
		{
			if(camera_cnt == 1) 
			{
		 		init_Process = NFA_INIT_SHUTTER_SPEED_DONE;	
				Uart_process = UART_READY;	
		        break;
			}	
			else {
				
				camera_cnt++;
				Uart_process = UART_READY;
			}		
		}
	}
}

void Camera_Init_Error()
{
	Uart_process = UART_READY;
	NFA_RS232_Init();
	NFA_Hardware_Init();
	Process_Parameter_clear();
}
//---------------------------------------------------------------------------
void MakeIdleStatusRS232Channel()
{
	int dummyBuffer;

	if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
	{
		dummyBuffer = NFA_RS232_DATA_REG;

		ExpectedRS232ReceiveDataCount--;
	}

	if(Board50usTimer > MakeIdleChannelProcessingStartTime + MAX_RS232_RECEIVE_WAITING_TIME_US)
	{
		// 500ms µ Ͱ   ʾҴٸ Ͱ  ʴ  
		ExpectedRS232ReceiveDataCount = 0;
	}

	if(ExpectedRS232ReceiveDataCount == 0)
	{
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);	
	}
}

void CameraSubSamplingMode_set()
{
	int i,camIndex;
	camera_cnt = 1;
	if(Uart_process == UART_READY)
	{
		//Tx for valid Line Number setting
		uart_txbuf[0] = 0xA1; uart_txbuf[1] = 0x01; uart_txbuf[2] = 0x00; uart_txbuf[3] = camera_cnt*16;
		uart_txbuf[4] = 0x6C; uart_txbuf[5] = 0x22; uart_txbuf[6] = 0x03; uart_txbuf[7] = 0xAE;
		uart_txbuf[8] = uart_txbuf[0];
		for (i = 1; i < 8; i++) uart_txbuf[8] ^= uart_txbuf[i]; // check sum

		camera_init_current_time = Board1MSTmr;
		Uart_process = UART_TRANS;
		tx_ptr = 0;
		rx_ptr = 0;

	}
	else if (Uart_process == UART_TRANS)
	{
		if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty ?
		{
			NFA_RS232_DATA_REG = uart_txbuf[tx_ptr++];
			if (tx_ptr>8)
			{
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
		}
	}
	else if (Uart_process == UART_RECEIVE)
	{
		if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
		{
			uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
			if(uart_rxbuf[0] == 0xA1) {
				rx_ptr++;
			}
			if (rx_ptr>8)
			{
				// return command м
				Uart_process = 5;
				rx_ptr = 0;
			}
		}
		else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
		{
			Uart_process = UART_READY;
		}
	}

	else if(Uart_process == 5)
	{
		camera_cnt++;
		if(camera_cnt > 1){
			Uart_process = UART_COMPLETE;
		}
		else if((camera_init_current_time+(NFA_CAMERA_TIMEOUT/5))<Board1MSTmr)
		{
			Uart_process = UART_COMPLETE;
		}		
	
	}
	else if (Uart_process == UART_COMPLETE)
	{
		init_Process = NFA_INIT_CAMERA_SUBSAMPLING_DONE;	
		Uart_process = UART_READY;
	}	
}

void Camera_triger_change()
{
	int i,camIndex;
	NFA_CAMERA_CONTROL_TRIG = 0x0020;
	Sleep(100);// 1 -> 100
	NFA_CAMERA_CONTROL_TRIG = 0x0000;
	if(Uart_process == UART_READY)
	{
		//Tx for valid Line Number setting
		uart_txbuf[0] = 0xA1; uart_txbuf[1] = 0x06; uart_txbuf[2] = 0x00; uart_txbuf[3] = 0x10;
		uart_txbuf[4] = 0x6C; uart_txbuf[5] = 0x61; uart_txbuf[6] = 0x40; uart_txbuf[7] = 0x00;
		uart_txbuf[8] = 0x18; uart_txbuf[9] = 0x00; uart_txbuf[10] = 0x00; uart_txbuf[11] = 0x00; 
		uart_txbuf[12] = 0xAE; uart_txbuf[13] = uart_txbuf[0];
		for (i = 1; i < 13; i++) uart_txbuf[13] ^= uart_txbuf[i]; // check sum

		camera_init_current_time = Board1MSTmr;
		Uart_process = UART_TRANS;
		tx_ptr = 0;
		rx_ptr = 0;
	}
	else if (Uart_process == UART_TRANS)
	{
		if (!(NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_TX_FULL_BIT))) // Tx Buf Empty ?
		{
			NFA_RS232_DATA_REG = uart_txbuf[tx_ptr++];
			if (tx_ptr>13)
			{
				Uart_process = UART_RECEIVE;
				camera_init_current_time = Board1MSTmr;
			}
		}
	}
	else if (Uart_process == UART_RECEIVE)
	{
		if ((NFA_RS232_STATUS_CONTROL_REG & (0x1<<RS232_DATA_RX_EXIST_BIT))) // Rx Buf ready ?
		{
			uart_rxbuf[rx_ptr] = NFA_RS232_DATA_REG;
			if(uart_rxbuf[0] == 0xA1) {
				rx_ptr++;
			}
			if (rx_ptr>8)
			{
				// return command м
				Uart_process = UART_COMPLETE;
				rx_ptr = 0;
				NFA_CAMERA_CONTROL_TRIG = 0x0020;
				Sleep(100);
				NFA_CAMERA_CONTROL_TRIG = 0x0000;
			}
		}
		else if ((camera_init_current_time+NFA_CAMERA_TIMEOUT)<Board1MSTmr)
		{
			Uart_process = UART_READY;
		}
	}
	else if (Uart_process == UART_COMPLETE)
	{

		NFA_CAMERA_CONTROL_TRIG = 0x0020;
		Sleep(100);
		NFA_CAMERA_CONTROL_TRIG = 0x0000;
		init_Process = NFA_INIT_CAMERA_TRIGER_CHANGE_DONE;	
		Uart_process = UART_READY;
	}	
}

int SetSubSamplingMode(int camIndex, int mode)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_SUBSAMPLING;
		NFACommendTx.Code2= NFA_CAM_COMMEND_SUBSAMPLING_SET;
		NFACommendTx.Data[0]= mode;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetSubSamplingMode(int camIndex, int* mode)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_SUBSAMPLING;
		NFACommendTx.Code2= NFA_CAM_COMMEND_SUBSAMPLING_GET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_SUBSAMPLING_NONE;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx.Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx.Header = temp[0];
					NFACommendRx.Length[0]= temp[1];
					NFACommendRx.Length[1]= temp[2];
					NFACommendRx.Id= temp[3];
					NFACommendRx.Code1= temp[4];
					NFACommendRx.Code2= temp[5];
					NFACommendRx.Data[0]= temp[6];
					NFACommendRx.Tail= temp[7];
					NFACommendRx.chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*mode = NFACommendRx.Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitSubSamplingMode(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_SUBSAMPLING;
		NFACommendTx.Code2= NFA_CAM_COMMEND_SUBSAMPLING_SET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_SUBSAMPLING_INIT_MODE;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetROIMode(int camIndex, int StartX, int EndX,int StartY, int EndY, int type)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	
	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x07;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_ROI;
		if(type==CAMERA_KIND_NFA_3D)
		{
			NFACommendTx.Code2= NFA_CAM_COMMEND_3D_ROI_SET;
		}
		else
		{
			NFACommendTx.Code2= NFA_CAM_COMMEND_2D_ROI_SET;
		}
		NFACommendTx.Data[0]= 0x00;
		NFACommendTx.Data[1]= StartX;
		NFACommendTx.Data[2]= EndX;
		NFACommendTx.Data[3]= StartY&0x00FF;
		NFACommendTx.Data[4]= (StartY&0xFF00)>>8;
		NFACommendTx.Data[5]= EndY&0x00FF;
		NFACommendTx.Data[6]= (EndY&0xFF00)>>8;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Data[1];
		NFACommendTx.chksum ^= NFACommendTx.Data[2];
		NFACommendTx.chksum ^= NFACommendTx.Data[3];
		NFACommendTx.chksum ^= NFACommendTx.Data[4];
		NFACommendTx.chksum ^= NFACommendTx.Data[5];
		NFACommendTx.chksum ^= NFACommendTx.Data[6];		
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Data[1];
		NFA_RS232_DATA_REG = NFACommendTx.Data[2];
		NFA_RS232_DATA_REG = NFACommendTx.Data[3];
		NFA_RS232_DATA_REG = NFACommendTx.Data[4];
		NFA_RS232_DATA_REG = NFACommendTx.Data[5];
		NFA_RS232_DATA_REG = NFACommendTx.Data[6];	
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetROIMode(int camIndex, int* GetSX,int* GetEX,int* GetSY,int* GetEY, int type)
{
	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_ROI;
		
		if(type==CAMERA_KIND_NFA_3D)
		{
			NFACommendTx.Code2= NFA_CAM_COMMEND_3D_ROI_GET;
		}
		else
		{
			NFACommendTx.Code2= NFA_CAM_COMMEND_2D_ROI_GET;
		}
		
		NFACommendTx.Data[0]=  NFA_CAM_COMMEND_ROI_NONE;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx.Header)
				{
					i++;
				}
				if(i>14)
				{
					NFACommendRx.Header = temp[0];
					NFACommendRx.Length[0]= temp[1];
					NFACommendRx.Length[1]= temp[2];
					NFACommendRx.Id= temp[3];
					NFACommendRx.Code1= temp[4];
					NFACommendRx.Code2= temp[5];
					NFACommendRx.Data[0]= temp[6];
					NFACommendRx.Data[1]= temp[7];
					NFACommendRx.Data[2]= temp[8];
					NFACommendRx.Data[3]= temp[9];
					NFACommendRx.Data[4]= temp[10];
					NFACommendRx.Data[5]= temp[11];
					NFACommendRx.Data[0]= temp[12];					
					NFACommendRx.Tail= temp[13];
					NFACommendRx.chksum= temp[14];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*GetSX = NFACommendRx.Data[1];
	*GetEX = NFACommendRx.Data[2];
	*GetSY = NFACommendRx.Data[3];
	*GetSY |= (NFACommendRx.Data[4]<<8);
	*GetEY = NFACommendRx.Data[5];
	*GetEY |= (NFACommendRx.Data[6]<<8);
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitROIMode(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x07;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_ROI;
		NFACommendTx.Code2= NFA_CAM_COMMEND_2D_ROI_SET;
		NFACommendTx.Data[0]= 0x00;
		NFACommendTx.Data[1]= NFA_CAM_COMMEND_ROI_INIT_MODE_SX;
		NFACommendTx.Data[2]= NFA_CAM_COMMEND_ROI_INIT_MODE_EX;
		NFACommendTx.Data[3]= NFA_CAM_COMMEND_ROI_INIT_MODE_SY&0x00FF;
		NFACommendTx.Data[4]= (NFA_CAM_COMMEND_ROI_INIT_MODE_SY&0xFF00)>>8;
		NFACommendTx.Data[5]= NFA_CAM_COMMEND_ROI_INIT_MODE_EY&0x00FF;
		NFACommendTx.Data[6]= (NFA_CAM_COMMEND_ROI_INIT_MODE_EY&0xFF00)>>8;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Data[1];
		NFACommendTx.chksum ^= NFACommendTx.Data[2];
		NFACommendTx.chksum ^= NFACommendTx.Data[3];
		NFACommendTx.chksum ^= NFACommendTx.Data[4];
		NFACommendTx.chksum ^= NFACommendTx.Data[5];
		NFACommendTx.chksum ^= NFACommendTx.Data[6];		
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Data[1];
		NFA_RS232_DATA_REG = NFACommendTx.Data[2];
		NFA_RS232_DATA_REG = NFACommendTx.Data[3];
		NFA_RS232_DATA_REG = NFACommendTx.Data[4];
		NFA_RS232_DATA_REG = NFACommendTx.Data[5];
		NFA_RS232_DATA_REG = NFACommendTx.Data[6];	
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int SetAnalogGain (int camIndex, int gain)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx.Code2= NFA_CAM_COMMEND_ANALOG_GAIN_SET;
		NFACommendTx.Data[0]= gain;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetAnalogGain(int camIndex, int* anal_gain)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx.Code2= NFA_CAM_COMMEND_ANALOG_GAIN_GET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_ANALOG_GAIN_NONE;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx.Header)
				{
					i++;
				}
				if(i>8)
				{
					NFACommendRx.Header = temp[0];
					NFACommendRx.Length[0]= temp[1];
					NFACommendRx.Length[1]= temp[2];
					NFACommendRx.Id= temp[3];
					NFACommendRx.Code1= temp[4];
					NFACommendRx.Code2= temp[5];
					NFACommendRx.Data[0]= temp[6];
					NFACommendRx.Tail= temp[7];
					NFACommendRx.chksum= temp[8];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*anal_gain = NFACommendRx.Data[0];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitAnalogGain(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_ANALOG_GAIN;
		NFACommendTx.Code2= NFA_CAM_COMMEND_ANALOG_GAIN_SET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_ANALOG_GAIN_INIT;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetDigitalGain (int camIndex, int gain1, int gain2)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x02;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_DIGITAL_GAIN;
		NFACommendTx.Code2= NFA_CAM_COMMEND_DIGITAL_GAIN_SET;
		NFACommendTx.Data[0]= gain1&0x00FF;;
		NFACommendTx.Data[1]= gain2&0x00FF;;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Data[1];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Data[1];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetDigitalGain(int camIndex, int* digit_gain1,int* digit_gain2)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_DIGITAL_GAIN;
		NFACommendTx.Code2= NFA_CAM_COMMEND_DIGITAL_GAIN_GET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_DIGITAL_GAIN_NONE;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx.Header)
				{
					i++;
				}
				if(i>9)
				{
					NFACommendRx.Header = temp[0];
					NFACommendRx.Length[0]= temp[1];
					NFACommendRx.Length[1]= temp[2];
					NFACommendRx.Id= temp[3];
					NFACommendRx.Code1= temp[4];
					NFACommendRx.Code2= temp[5];
					NFACommendRx.Data[0]= temp[6];
					NFACommendRx.Data[1]= temp[7];
					NFACommendRx.Tail= temp[8];
					NFACommendRx.chksum= temp[9];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*digit_gain1 = NFACommendRx.Data[0];
	*digit_gain2 = NFACommendRx.Data[1];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitDigitalGain(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x02;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_DIGITAL_GAIN;
		NFACommendTx.Code2= NFA_CAM_COMMEND_DIGITAL_GAIN_SET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_DIGITAL_GAIN_INIT1;
		NFACommendTx.Data[1]= NFA_CAM_COMMEND_DIGITAL_GAIN_INIT2;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Data[1];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Data[1];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SetShutterSpeed(int camIndex, int us)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x02;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
		NFACommendTx.Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_SET;
		NFACommendTx.Data[0]= us&0x00FF;
		NFACommendTx.Data[1]= (us&0xFF00)>>8;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Data[1];
		NFACommendTx.chksum ^= NFACommendTx.Tail;
			
		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Data[1];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);

	}
	return 1;
}

int GetShutterSpeed(int camIndex, int* us)
{

	int temp[20];
	int i = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
		NFACommendTx.Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_GET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_SHUTTER_SPEED_NONE;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		// receive rx data
		if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
		{
			while(1)
			{
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx.Header)
				{
					i++;
				}
				if(i>9)
				{
					NFACommendRx.Header = temp[0];
					NFACommendRx.Length[0]= temp[1];
					NFACommendRx.Length[1]= temp[2];
					NFACommendRx.Id= temp[3];
					NFACommendRx.Code1= temp[4];
					NFACommendRx.Code2= temp[5];
					NFACommendRx.Data[0]= temp[6];
					NFACommendRx.Data[1]= temp[7];
					NFACommendRx.Tail= temp[8];
					NFACommendRx.chksum= temp[9];
					break;
				}
			}	
		}
		else
		{
			NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
			return -1;
		}
	}
	*us = NFACommendRx.Data[0];
	*us |= (NFACommendRx.Data[1]<<8);
		
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}

int InitShutterSpeed(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x02;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= NFA_CAM_COMMEND_SHUTTER_SPEED;
		NFACommendTx.Code2= NFA_CAM_COMMEND_SHUTTER_SPEED_SET;
		NFACommendTx.Data[0]= NFA_CAM_COMMEND_SHUTTER_SPEED_INIT1;
		NFACommendTx.Data[1]= NFA_CAM_COMMEND_SHUTTER_SPEED_INIT2;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Data[1];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Data[1];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(100);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int SaveCameraFlash(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= 0x6c;
		NFACommendTx.Code2= 0x10;
		NFACommendTx.Data[0]= 0x00;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(5000);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

int LoadCameraFlash(int camIndex)
{
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] = 0x01;
		NFACommendTx.Length[1] = 0x00;
		NFACommendTx.Code1= 0x6c;
		NFACommendTx.Code2= 0x11;
		NFACommendTx.Data[0]= 0x00;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Sleep(3000);
		NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
		NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	}
	return 1;
}

void TPBCameraConfig(TTPBCameraParams* camParams)
{
	if(camParams->mask && CAMERA_WRITE_MASK_2D_SH) 
	{
		SetShutterSpeed(0,camParams->ShutterSpeed);
	}

	if(camParams->mask && CAMERA_WRITE_MASK_2D_ROI)
	{
		SetROIMode(0, 0, 159, camParams->bounaryStartY * 2, camParams->bounaryEndY * 2, CAMERA_KIND_NFA_2D);
	}

	if(camParams->mask && CAMERA_WRITE_MASK_2D_SUBSAMPLING_MODE)
	{
		//640 * 480
		SetSubSamplingMode(0, NFA_CAM_COMMEND_SUBSAMPLING_INIT_MODE);
	}

	if(camParams->mask && CAMERA_WRITE_MASK_2D_ANALOG_GAIN)
	{
		SetAnalogGain(0, camParams->AnalogGain);
	}

	if(camParams->mask && CAMERA_WRITE_MASK_2D_DIGITALGAIN)
	{
		SetDigitalGain(0, camParams->DigitalGain,0);
	}
}
	
/*
int GetCamVersion(int camIndex, int* Cam_ver_major, int* Cam_ver_minor)
{
	int temp[20];
	int i = 0;
	int Read_StartTime = 0;
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_TX_RESET_BIT);

	if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_TX_FULL_BIT))
	{
		return -1;
	}
	else
	{
		//set command
		NFACommendTx.Length[0] 	= 0x01;
		NFACommendTx.Length[1] 	= 0x00;
		NFACommendTx.Code1		= NFA_CAM_COMMEND_3D_SYS_CAM_VER;
		NFACommendTx.Code2		= NFA_CAM_COMMEND_3D_SYS_CAM_VER_GET;
		NFACommendTx.Data[0]		= 0x00;

		//make checksum
		NFACommendTx.chksum = NFACommendTx.Header;
		NFACommendTx.chksum ^= NFACommendTx.Length[0];
		NFACommendTx.chksum ^= NFACommendTx.Length[1];
		NFACommendTx.chksum ^= NFACommendTx.Id;
		NFACommendTx.chksum ^= NFACommendTx.Code1;
		NFACommendTx.chksum ^= NFACommendTx.Code2;
		NFACommendTx.chksum ^= NFACommendTx.Data[0];
		NFACommendTx.chksum ^= NFACommendTx.Tail;

		//tx data transfer
		NFA_RS232_DATA_REG = NFACommendTx.Header;
		NFA_RS232_DATA_REG = NFACommendTx.Length[0];
		NFA_RS232_DATA_REG = NFACommendTx.Length[1];
		NFA_RS232_DATA_REG = NFACommendTx.Id;
		NFA_RS232_DATA_REG = NFACommendTx.Code1;
		NFA_RS232_DATA_REG = NFACommendTx.Code2;
		NFA_RS232_DATA_REG = NFACommendTx.Data[0];
		NFA_RS232_DATA_REG = NFACommendTx.Tail;
		NFA_RS232_DATA_REG = NFACommendTx.chksum;	
		Read_StartTime = Board1MSTmr;
		while(1)
		{
			if(NFA_RS232_STATUS_CONTROL_REG&(0x1<<RS232_DATA_RX_EXIST_BIT))
			{		
				temp[i] = NFA_RS232_DATA_REG;
				if(temp[0] == NFACommendTx.Header)
				{
					i++;
				}
				if(i>9)
				{
					NFACommendRx.Header 		= temp[0];
					NFACommendRx.Length[0]	= temp[1];
					NFACommendRx.Length[1]	= temp[2];
					NFACommendRx.Id			= temp[3];
					NFACommendRx.Code1		= temp[4];
					NFACommendRx.Code2		= temp[5];
					NFACommendRx.Data[0]		= temp[6];
					NFACommendRx.Data[1]		= temp[7];
					NFACommendRx.Tail			= temp[8];
					NFACommendRx.chksum		= temp[9];
					break;
				}	
			}
						
			if(Board1MSTmr -Read_StartTime > 2000)
			{
				NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
				return -1;
			}
		}
	}
	*Cam_ver_minor = NFACommendRx.Data[0];
	*Cam_ver_major = NFACommendRx.Data[1];
	NFA_SET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	NFA_RESET_BIT(NFA_RS232_STATUS_CONTROL_REG,RS232_DATA_RX_RESET_BIT);
	return 1;
}
*/
//---------------------------------------------------------------------------

