#ifndef _NFA_CAM_2D_H_
#define _NFA_CAM_2D_H_

#include <csl_intc.h>
#include <csl_edma2.h>
#include <stdio.h>
#include <csl_tmr.h>
#include <csl_tmrAux.h>
#include "common.h"

#define NFA_2D_CAPTURE_TOP_POS_FULL_CAPTURE		0
#define CAPTURE_STEP_NONE					0
#define CAPTURE_STEP_ON_CAPTURE			1
#define CAPTURE_READ_TIMEOUT				10
#define NFA_CAMERA_TIMEOUT	  				5000
#define NFA_HALF_FIFO_SIZE					(16	* 1024)


#define NFA_RS232_DATA_REG   					*(volatile short int *)(NFA_CAMERA_BASE+ 0x0200)
#define NFA_RS232_STATUS_CONTROL_REG 			*(volatile short int *)(NFA_CAMERA_BASE+ 0x0204)
#define NFA_RS232_BAUDRATE_REG   				*(volatile short int *)(NFA_CAMERA_BASE+ 0x0208)

#define NFA_CAMERA_RX_CONTROL_REG  			*(volatile short int *)(NFA_CAMERA_BASE+0x4000)
#define NFA_CAMERA_RX_POLARITY_REG   			*(volatile short int *)(NFA_CAMERA_BASE+0x4004)
#define NFA_CAMERA_POLARITY_STATUS_REG   		*(volatile short int *)(NFA_CAMERA_BASE+0x400C)
#define NFA_CAMERA_VALID_LINE_CONTROL_REG   	*(volatile short int *)(NFA_CAMERA_BASE+0x4010)
#define NFA_CAMERA_RX_CORE_REG 	  			*(volatile short int *)(NFA_CAMERA_BASE+0x4018)



//NFA Camera Debug REG

#define NFA_FIFO_RESET_STATUS_REG     	*(volatile short int *)(NFA_CAMERA_BASE+0x4030)
#define NFA_FIFO_ENABLE_STATUS_REG      	*(volatile short int *)(NFA_CAMERA_BASE+0x4034)
#define NFA_FIFO_HALF_STATUS_REG       	*(volatile short int *)(NFA_CAMERA_BASE+0x4038)

#define NFA_BOND_ERR_COUNT_REG  			*(volatile short int *)(NFA_CAMERA_BASE+0x401C) 
#define NFA_DISPARITY_ERR_COUNT_1_REG     *(volatile short int *)(NFA_CAMERA_BASE+0x4020) 
#define NFA_DISPARITY_ERR_COUNT_2_REG     *(volatile short int *)(NFA_CAMERA_BASE+0x4024) 
#define NFA_10TO8_ERR_COUNT_1_REG       	*(volatile short int *)(NFA_CAMERA_BASE+0x4028) 
#define NFA_10TO8_ERR_COUNT_2_REG       	*(volatile short int *)(NFA_CAMERA_BASE+0x402C)

//NFA Camera clk
#define NFA_CAMERA_CLK				95000000//106250000
#define NFA_CAMERA_BAUDRATE		921600

//NFA Camera ID
#define NFA_CAMERA_ID(n)   		*(volatile short int *)(0xD0000040+(n)*2) 

//NFA_CAMERA_RX_CONTROL_REG Bit Set
#define RX_CONTROL_RESET_BIT						0
#define RX_CONTROL_ENABLE_BIT						1
#define RX_CONTROL_HOT_PLUG_DETECT_1_BIT			2
#define RX_CONTROL_HOT_PLUG_DETECT_2_BIT			3
#define RX_CONTROL_POLARITY_RESET_BIT				4
#define RX_CONTROL_VLN_RESET_BIT					5
#define RX_CONTROL_PACKET_ERR_RESET_BIT				6
#define RX_CONTROL_PACK_ALIGN_ERR_COUNT_1_BIT		8
#define RX_CONTROL_PACK_ALIGN_ERR_COUNT_2_BIT		9
#define RX_CONTROL_PACK_ALIGN_ERR_COUNT_3_BIT		10
#define RX_CONTROL_PACK_ALIGN_ERR_COUNT_4_BIT		11
#define RX_CONTROL_PACK_ALIGN_OK_COUNT_1_BIT		12
#define RX_CONTROL_PACK_ALIGN_OK_COUNT_2_BIT		13
#define RX_CONTROL_PACK_ALIGN_OK_COUNT_3_BIT		14
#define RX_CONTROL_PACK_ALIGN_OK_COUNT_4_BIT		15


//NFA_CAMERA_RX_CORE_REG Bit Set
#define RX_CORE_RESET_BIT						0
#define RX_CORE_DISPARITY_ERR_RESET_BIT			4
#define RX_CORE_10TO8_ERR_RESET_BIT				5
#define RX_CORE_CHANNEL_BOND_ERR_BIT			6
#define RX_CORE_RX_RESET_DONE_1_BIT				8
#define RX_CORE_RX_RESET_DONE_2_BIT				9
#define RX_CORE_RX_RESET_DONE_3_BIT				10
#define RX_CORE_RX_RESET_DONE_4_BIT				11
#define RX_CORE_RX_CHNNEL_BONDED_DONE_1_BIT		12
#define RX_CORE_RX_CHNNEL_BONDED_DONE_2_BIT		13
#define RX_CORE_RX_CHNNEL_BONDED_DONE_3_BIT		14
#define RX_CORE_RX_CHNNEL_BONDED_DONE_4_BIT		15

//NFA_RS232_STATUS_CONTROL_REG Bit Set
#define RS232_DATA_PARITY_EN_BIT		0
#define RS232_DATA_PARITY_EVEN_BIT		1
#define RS232_DATA_INT_EN_BIT			2
#define RS232_DATA_INT_STATUS_BIT		3
#define RS232_DATA_TX_RESET_BIT			4
#define RS232_DATA_TX_FULL_BIT			5
#define RS232_DATA_RX_RESET_BIT			6
#define RS232_DATA_RX_EXIST_BIT			7
#define RS232_DATA_OVERRUN_ERR_BIT		8
#define RS232_DATA_FRAME_ERR_BIT		9
#define RS232_DATA_PARITY_ERR_BIT		10


//init processing status
#define NFA_INIT_START						0
#define NFA_INIT_HOT_FLUG_DETECT_DONE			1
#define NFA_INIT_UART_CONNECT_DETECT_DONE		2
#define NFA_INIT_ID_SET_DONE					3
#define NFA_INIT_HARDWARE_RESET_DONE			4
#define NFA_INIT_OUTPUT_ENABLE_DONE			5
#define NFA_INIT_POLARITY_REQ_DONE			6
#define NFA_INIT_POLARITY_SET_DONE			7
#define NFA_INIT_VALIDLINENUM_SET_DONE		8
#define NFA_INIT_TRIGGER_LINE_CHECK_DONE		9
#define NFA_INIT_CAMERA_SUBSAMPLING_DONE		10
#define NFA_INIT_SHUTTER_SPEED_DONE		11
#define NFA_INIT_CAMERA_TRIGER_CHANGE_DONE 12
#define NFA_INIT_COMPLETED					13
#define NFA_INIT_ERROR						0xFF

#define NFA_CAM_COMMEND_SUBSAMPLING					0x6C
#define NFA_CAM_COMMEND_SUBSAMPLING_SET			0x22
#define NFA_CAM_COMMEND_SUBSAMPLING_GET			0x23
#define NFA_CAM_COMMEND_SUBSAMPLING_XY_MODE		0x3
#define NFA_CAM_COMMEND_SUBSAMPLING_X_MODE		0x2
#define NFA_CAM_COMMEND_SUBSAMPLING_Y_MODE		0x1
#define NFA_CAM_COMMEND_SUBSAMPLING_NONE			0x0
#define NFA_CAM_COMMEND_SUBSAMPLING_INIT_MODE	NFA_CAM_COMMEND_SUBSAMPLING_XY_MODE

#define NFA_CAM_COMMEND_ROI							0x6C
#define NFA_CAM_COMMEND_2D_ROI_SET					0x26
#define NFA_CAM_COMMEND_3D_ROI_SET					0x24
#define NFA_CAM_COMMEND_2D_ROI_GET					0x27
#define NFA_CAM_COMMEND_3D_ROI_GET					0x25
#define NFA_CAM_COMMEND_ROI_INIT_MODE_SX			0
#define NFA_CAM_COMMEND_ROI_INIT_MODE_EX			159
#define NFA_CAM_COMMEND_ROI_INIT_MODE_SY			0
#define NFA_CAM_COMMEND_ROI_INIT_MODE_EY			959
#define NFA_CAM_COMMEND_ROI_NONE					0x00

#define NFA_CAM_COMMEND_ANALOG_GAIN				0x6C
#define NFA_CAM_COMMEND_ANALOG_GAIN_SET			0xCC
#define NFA_CAM_COMMEND_ANALOG_GAIN_GET			0xCD
#define NFA_CAM_COMMEND_ANALOG_GAIN_INIT			0
#define NFA_CAM_COMMEND_ANALOG_GAIN_NONE			0x00

#define NFA_CAM_COMMEND_DIGITAL_GAIN				0x6C
#define NFA_CAM_COMMEND_DIGITAL_GAIN_SET			0xC2
#define NFA_CAM_COMMEND_DIGITAL_GAIN_GET			0xC3
#define NFA_CAM_COMMEND_DIGITAL_GAIN_INIT1			2
#define NFA_CAM_COMMEND_DIGITAL_GAIN_INIT2			0
#define NFA_CAM_COMMEND_DIGITAL_GAIN_NONE			0x00

#define NFA_CAM_COMMEND_SHUTTER_SPEED				0x6C
#define NFA_CAM_COMMEND_SHUTTER_SPEED_SET			0x46
#define NFA_CAM_COMMEND_SHUTTER_SPEED_GET			0x47
#define NFA_CAM_COMMEND_SHUTTER_SPEED_INIT1		0x0
#define NFA_CAM_COMMEND_SHUTTER_SPEED_INIT2		0x0		//0x3E8 = 1000us
#define NFA_CAM_COMMEND_SHUTTER_SPEED_NONE		0x00

/*  3D TBP 
#define NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE				0x6C
#define NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_SET			0x74
#define NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_GET			0x75
#define NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_INIT1		0x2
#define NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_INIT2		0x0		
#define NFA_CAM_COMMEND_3D_IMAGE_OUTPUT_MODE_NONE		0x00

#define NFA_CAM_COMMEND_3D_CONFIG_MODE						0x6C
#define NFA_CAM_COMMEND_3D_CONFIG_MODE_SET					0x36
#define NFA_CAM_COMMEND_3D_CONFIG_MODE_GET					0x37

#define NFA_CAM_COMMEND_3D_CONFIG_DATA_BIT_CHANGE			0x01
#define NFA_CAM_COMMEND_3D_CONFIG_DATA_BIT_CHANGE_9BIT		128
#define NFA_CAM_COMMEND_3D_CONFIG_DATA_BIT_CHANGE_12BIT		1024

#define NFA_CAM_COMMEND_3D_CONFIG_DATA_COG_CUTOFF			0x02
#define NFA_CAM_COMMEND_3D_CONFIG_DATA_COG_CUTOFF_DEFAULT	0

#define NFA_CAM_COMMEND_3D_CONFIG_DATA_LEVEL					0x03
#define NFA_CAM_COMMEND_3D_CONFIG_DATA_LEVEL_DEFAULT			4000

#define NFA_CAM_COMMEND_3D_CONFIG_DATA_EDGE_CUTOFF			0x04
#define NFA_CAM_COMMEND_3D_CONFIG_DATA_EDGE_CUTOFF_DEFAULT	128


#define NFA_CAM_COMMEND_WAVE_TABLE					0x6C
#define NFA_CAM_COMMEND_WAVE_TABLE_SET				0x0A
#define NFA_CAM_COMMEND_WAVE_TABLE_GET				0x0B
#define NFA_CAM_COMMEND_WAVE_TABLE_NONE			0x00

#define NFA_CAM_COMMEND_3D_SYS_OFFSET				0x6C
#define NFA_CAM_COMMEND_3D_SYS_OFFSET_SET			0xD0
#define NFA_CAM_COMMEND_3D_SYS_OFFSET_GET			0xD1

#define NFA_CAM_COMMEND_3D_SYS_GAIN					0x6C
#define NFA_CAM_COMMEND_3D_SYS_GAIN_SET			0xD8
#define NFA_CAM_COMMEND_3D_SYS_GAIN_GET			0xD9

#define NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF		0x6C
#define NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF_SET	0xE0
#define NFA_CAM_COMMEND_3D_SYS_LEVEL_CUTOFF_GET	0xF0

#define NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN			0x6C
#define NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN_SET		0xE1
#define NFA_CAM_COMMEND_3D_SYS_LEVEL_GAIN_GET		0xF1

#define NFA_CAM_COMMEND_3D_SYS_COG_THR				0x6C
#define NFA_CAM_COMMEND_3D_SYS_COG_THR_SET		0xE2
#define NFA_CAM_COMMEND_3D_SYS_COG_THR_GET		0xF2

//20201106 cjg added 3d camera param
//20200901 cjg added command for 3D Camera Calibration Mode
#define NFA_CAM_COMMEND_3D_SYS_CAM_MODE				0x6C
#define NFA_CAM_COMMEND_3D_SYS_CAM_MODE_SET			0xE3
#define NFA_CAM_COMMEND_3D_SYS_CAM_MODE_GET			0xF3

//2020-09-02 cjg added 3D camera version check
#define NFA_CAM_COMMEND_3D_SYS_CAM_VER				0x6C
#define NFA_CAM_COMMEND_3D_SYS_CAM_VER_GET			0xFE

//2020-10-28 cjg added 3D camera resolution
#define NFA_CAM_COMMEND_3D_SYS_CAM_RESOLUTION		0x6C
#define NFA_CAM_COMMEND_3D_RESOLUTION_SET			0xF4
#define NFA_CAM_COMMEND_3D_RESOLUTION_GET			0xF5

*/

//Uart processing status
#define UART_READY				0
#define UART_TRANS				1
#define UART_RECEIVE			2
#define UART_COMPLETE			3
#define UART_CAMERA_ID_CHECK 	4

#define UART_CAMERA_POLARITY_CHANGE_SEND   5
#define UART_CAMERA_POLARITY_CHANGE_RECEIVE  6
#define UART_CAMERA_POLARITY_CHANGE_DONE  7
#define UART_CAMERA_POLARITY_CHANGE   5

//uart polarity
#define UART_POLARITY_NEGATIVE		0
#define UART_POLARITY_POSITIVE		1

//rs232 max packet length
#define MAX_COMM_DATA_LENGTH 20

// FPGA  Ʈ ִ° 2D / 3D  ϴ REG    1ī޶ 0x01 2ī޶ 0x02  
#define CHANGE_2D3D_REG  		*(volatile short int *)0xD0000030
#define MAX_RS232_RECEIVE_WAITING_TIME_US	500 // 500ms

#define TPB_CAPTURE_NONE 			0
#define TPB_CAPTURE_START 			1
#define TPB_CAPTURE_INSPECTION 	2
#define TPB_CAPTURE_STOP 			3

#define TPB_OPTION_CAPTURE			0
#define TPB_OPTION_INSPECTION		1

#define FREE_IMG_UPLOAD			0
#define DEFECT_IMG_UPLOAD_ONLY		1		


typedef enum
{
	TPB_IMAGEBUFFER_STATUS_NONE = 0,
	TPB_IMAGEBUFFER_STATUS_CAPTURE,
	TPB_IMAGEBUFFER_STATUS_CAPTURE_END,
	TPB_IMAGEBUFFER_STATUS_IMAGE_LOAD,
	TPB_IMAGEBUFFER_STATUS_INSPECTION,
	TPB_IMAGEBUFFER_STATUS_INSPECTION_END,
	TPB_IMAGEBUFFER_STATUS_GOOD_IMAGE_LOAD,
	TPB_IMAGEBUFFER_STATUS_DEFECT_IMAGE_LOAD	
} TPB_IMAGEBUFFER_STATUS;


 
typedef struct
{
	int Registered;
	int CaptureStep;
	int CaptureTimeout1ms;
	unsigned int CaptureStartTime;
	int *StatusPtr;
	int CaptureReadRemain;
	int CaptureImagelength;
	unsigned char *CaptureImage;
	unsigned char *CaptureImagePtr;
}
TStreamingFrameInfo;

typedef struct
{
	int CaptureStatus;
	int CaptureStep;
	int CaptureTimeout1ms;
	unsigned short CapturePeriod;
	short CapturePeriodCount;
	unsigned short FrameWidth;
	unsigned short FrameHeight;
	unsigned short CaptureTopPos;
	unsigned int CaptureStartTime;
	unsigned int CaptureEndTime;
	unsigned int DMATriggerCount;
	unsigned int CaptureErrorCount;
	int CaptureOption;
	int CaptureUploadOption;
	int CaptureDelay_Min;
	int CaptureDelay_Max;
} TNFACaptureInfo;

typedef struct
{
	unsigned int Header;
	unsigned int Length[2];
	unsigned int Id;
	unsigned int Code1;
	unsigned int Code2;
	unsigned int Data[50];
	unsigned int Tail;
	unsigned int chksum;
}TNFACamCommend;

typedef struct
{
	int topPosition;
	int bottomPosition;
}TNFA2DCameraAreaInfo;

typedef struct
{
	int startTime[256];
	int endTime[256];
	int period[256];
	int cpbIndex[256];
	int checkcount;
}TTPBTimeInfo;


typedef struct
{
	int ProcessStep[TPB_CPB_MAX_COUNT];
	int ProcessCount[TPB_CPB_MAX_COUNT];
	TTPBTimeInfo imagesendTime[TPB_CPB_MAX_COUNT];
	TTPBTimeInfo ProcessingTime[TPB_CPB_MAX_COUNT];
	int cpbIndex[TPB_CPB_MAX_COUNT];
	int cpbStatus[TPB_CPB_MAX_COUNT];
}TTBPProcessInfo;

typedef struct	
{	
	int currentCaptureIndex;
	int capturePeriod;
	int process_startTime;
	int process_period;
	int process_checkcount;
}TTPBInsProcessInfo;	

typedef enum
{
	TPB_PROCESS_STEP_NONE = 0,	
	TPB_PROCESS_STEP_SEND_IMAGE,
	TPB_PROCESS_STEP_SEND_DATA,
	TPB_PROCESS_STEP_WATING_RESULT,
	TPB_PROCESS_STEP_END
} TPB_PROCESS_STEP;


void TPBCameraInit(void);
int	TPBCaptureTrigger(unsigned char *captureImage);
void TPBCaptureStop();
void TPBCaptureAbort();
void TPBCaptureTimeOutProcess();
void TPBCameraIsr(void);
void IsrCapture(void);

void NFACamera_Init();
int Uart_connectction_enable();
int Camera_id_set();
int Camera_hardware_reset();
int Camera_output_enable();
int Polarity_request();
int Polarity_set();
int Valid_line_number_set();
int Camera_id_check();
int Trigger_line_check();
void Camera_Init_Error();
void NFA_RS232_Init();
void NFA_Hardware_Init();
void Process_Parameter_clear();
void CameraSubSamplingMode_set();
void Shutter_speed_change();
void Camera_triger_change();
void TPBInspectInit();
void TPBProcessCapture(void);
void TPMisejectInit(void);

extern TTPBInspectionData InspectDataTbp;
extern TNFACaptureInfo NFACaptureInfo;
extern TTBPProcessInfo TPBProcessInfo;
extern TTPBInsProcessInfo TPBInsProcessInfo;
extern TTPBTimeInfo TestDebug;

#endif

