EMIFA_CE2CFG	.equ  0x70000080  ;EMIF global control
EMIFA_CE3CFG	.equ  0x70000084  ;address of EMIF CE1 control reg.
EMIFA_CE4CFG	.equ  0x70000088  ;EMIF CE0control
EMIFA_CE5CFG	.equ  0x7000008C

DDR_SDCFG		.equ  0x78000008
DDR_SDRFC		.equ  0x7800000C
DDR_SDTIM1		.equ  0x78000010
DDR_SDRIM2		.equ  0x78000014
DDR_DDRPHYC		.equ  0x780000E4

EMIFA_CE2CFG_V	.equ  0x0FFFFFFC  ;
EMIFA_CE3CFG_V	.equ  0x0FFFFFFC  ; 8-bit async, 10 cycle read/write strobe
EMIFA_CE4CFG_V	.equ  0x0FFFFFFF  ;32-bit async, 10 cycle read/write strobe
EMIFA_CE5CFG_V	.equ  0x0FFFFFFC  ;32-bit async, 10 cycle read/write strobe

DDR_SDCFG_V0	.equ  0x00530A32
DDR_SDRFC_V		.equ  0x00000A0E
DDR_SDTIM1_V	.equ  0x832474DA
DDR_SDRIM2_V	.equ  0x0144C742
DDR_DDRPHYC_V	.equ  0x001802C6

DDR_SDCFG_V1	.equ  0x00538832
L2INV_CACHE		.equ  0x01845008
L1PINV_CACHE	.equ  0x01845028              
CACHE_CFG	.equ  0x00000001
COPY_TABLE      .equ  0xB0000400


            .sect ".boot_load"
            .global _boot

_boot:      
;************************************************************************
;* CONFIGURE EMIF
;************************************************************************

        ;****************************************************************
        ; *EMIFA_CE2CFG = EMIFA_CE2CFG_V
        ;****************************************************************

            mvkl  EMIFA_CE2CFG,A4       
      ||    mvkl  EMIFA_CE2CFG_V,B4     

            mvkh  EMIFA_CE2CFG,A4
      ||    mvkh  EMIFA_CE2CFG_V,B4

            stw   B4,*A4

        ;****************************************************************
        ; *EMIFA_CE3CFG = EMIFA_CE3CFG_V (setup for 8-bit async)
        ;****************************************************************

            mvkl  EMIFA_CE3CFG,A4       
      ||    mvkl  EMIFA_CE3CFG_V,B4

            mvkh  EMIFA_CE3CFG,A4
      ||    mvkh  EMIFA_CE3CFG_V,B4

            stw   B4,*A4
        

        ;****************************************************************
        ; *EMIFA_CE4CFG = EMIFA_CE4CFG_V
        ;****************************************************************
      ||    mvkl  EMIFA_CE4CFG,A4      
      ||    mvkl  EMIFA_CE4CFG_V,B4    

            mvkh  EMIFA_CE4CFG,A4
      ||    mvkh  EMIFA_CE4CFG_V,B4

            stw   B4,*A4

        ;****************************************************************
        ; *EMIFA_CE5CFG = EMIFA_CE5CFG_V
        ;****************************************************************
      ||    mvkl  EMIFA_CE5CFG,A4      
      ||    mvkl  EMIFA_CE5CFG_V,B4    

            mvkh  EMIFA_CE5CFG,A4
      ||    mvkh  EMIFA_CE5CFG_V,B4

            stw   B4,*A4

        ;****************************************************************
        ; INIT CACHE = L1P, L2 INIT
        ;****************************************************************

      ||    mvkl  L2INV_CACHE,A4      
      ||    mvkl  CACHE_CFG,B4    

            mvkh  L2INV_CACHE,A4
      ||    mvkh  CACHE_CFG,B4

            stw   B4,*A4

      ||    mvkl  L1PINV_CACHE,A4      
      ||    mvkl  CACHE_CFG,B4    

            mvkh  L1PINV_CACHE,A4
      ||    mvkh  CACHE_CFG,B4

            stw   B4,*A4

 	   nop  9

;****************************************************************************
; copy sections
;****************************************************************************
        mvkl  COPY_TABLE, a3 ; load table pointer
        mvkh  COPY_TABLE, a3

        ldw   *a3++, b1     ; Load entry point	(0x009C90E0)

copy_section_top:
        ldw   *a3++, b0     ; byte count (0x200)
        ldw   *a3++, a4     ; ram start address (0x009C9800)
        nop   3

 [!b0]  b copy_done         ; have we copied all sections?
        nop   5

copy_loop:
        ldb   *a3++,b5
        sub   b0,1,b0       ; decrement counter
 [ b0]  b     copy_loop     ; setup branch if not done
 [!b0]  b     copy_section_top
        zero  a1
 [!b0]  and   3,a3,a1
        stb   b5,*a4++
 [!b0]  and   -4,a3,a5      ; round address up to next multiple of 4
 [ a1]  add   4,a5,a3       ; round address up to next multiple of 4

;****************************************************************************
; jump to entry point
;****************************************************************************
copy_done:
        b    .S2 b1
        nop   5
