#ifndef _DATA_TRANSFER_H_
#define _DATA_TRANSFER_H_

#define MAX_SDRAM_COPY_SIZE		16 * 1024
#define MAX_HPI_PACKET_SIZE		518		// words
#define MAX_HPI_READ_SIZE		128
#define MAX_HPI_READ_SIZE_WORD	MAX_HPI_READ_SIZE/4

typedef struct
{
	int Step;
	unsigned char *DataAddress;
	int DataSize;
	unsigned int Checksum;
} TSendDataPC;

typedef struct
{
	int Step;
	unsigned char *DataAddress;
	int DataSize;
	int RespectedStep;
	unsigned int DataReceive_SW;
	unsigned int ReceiveTime;
} TReceiveDataPC;

extern TReceiveDataPC ReceiveDataPC;

void Request_CopyData(void *dst_address, void *src_address, int size);
void Request_ClearData_Aligned(void *dst_address, unsigned int fill_value, int size);
void Request_BayerImageScaleConversion(void *src_address, void *dst_address, int srcWidth, int dstWidth, int size, int reduction, int byteSize);

#endif

