#ifndef _ENVIRONMENT_H_
#define _ENVIRONMENT_H_

#include "common.h"
#include "command.h"
#include "flash.h"

extern unsigned short BoardID;
extern TSPBSetupInfo SetupInfo;

#define DOWNLOAD_MAX_SIZE					0x00C00000		// 12Mb
#define CPB_MAX_HEX_SIZE					0x00180000
#define CPB_MAX_CODE_SIZE					0x00180000		// 1.5Mb

extern unsigned char ProgramBuffer[DOWNLOAD_MAX_SIZE];

#define CAPTURE_STATUS_NONE					0
#define CAPTURE_STATUS_ON_CAPTURE			1
#define CAPTURE_STATUS_COMPLETE				2
#define CAPTURE_STATUS_TIMEOUT				3

#define THREED_CAMERA_SENSOR_OFF				3
#define THREED_CAMERA_SENSOR_SD1_BIT			0
#define THREED_CAMERA_SENSOR_SD2_BIT			1

#define CAMERA_STATUS_NONE					0
#define CAMERA_STATUS_READY					1
#define CAMERA_STATUS_ON_CAPTURE			2

#define MACHINE_CAPTURE_MODE_NONE				0
#define MACHINE_CAPTURE_MODE_CAPTURE			2
#define MACHINE_CAPTURE_MODE_PROCESSING			3


typedef struct
{
	unsigned char CameraEnable[4];
	unsigned short ShutterSpeed[4];
	unsigned short ShutterDelay[4];
	unsigned short TriggerFreq[4];
	unsigned char SubsamplingMode[4];
	unsigned int CaptureMode;	
	int FrameBufferCount;
	int TabletType;
} TCameraSetupData;

extern TCameraSetupData CameraSetupData;
extern TSPBProgramHeader SPBProgramHeader;
extern TSPBDBHeader SPBDBHeader;
extern TSPBFPGAVersion SPBFPGAVersion;
extern TProgramVersion ProgramVersion;
extern TSPBCompatibility TPBCompatibility;
extern TSPBFPGAVersion FPGAnewVersion2;
#endif