/*
 *  Copyright 2007 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *
 *  @(#) TCP/IP_Network_Developers_Kit 1.93.00.09 08-16-2007 (ndk-c09)
 */
/*^M
 *  ======== client.c ========^M
 *^M
 *
 */

//--------------------------------------------------------------------------
// IP Stack Client Demo
//--------------------------------------------------------------------------
// Client.c
//
// Stack initialization functions
//
// Author: Michael A. Denio
// Copyright 2000, 2001 by Texas Instruments Inc.
//--------------------------------------------------------------------------
#include <stdio.h>
#include <netmain.h>
#include <_stack.h>
#include <common/console/console.h>
#include <common/servers/servers.h>
#include <csl_intc.h>
//#include "client.h"

#include <mem.h>
#include <sys.h>
#include <tsk.h>
#include <log.h>

// When USE_OLD_SERVERS set to zero, server daemon is used
#define USE_OLD_SERVERS 0

extern void FA_TCPServer();
// Our NETCTRL callback functions

static void   NetworkOpen();
static void   NetworkClose();
static void   NetworkIPAddr( IPN IPAddr, uint IfIdx, uint fAdd );

// Fun reporting function
static void   ServiceReport( uint Item, uint Status, uint Report, HANDLE hCfgEntry );

//---------------------------------------------------------------------------
// External references
//
extern TSK_Obj TSK_idle;
extern LOG_Obj logTrace;

//---------------------------------------------------------------------------
// Configuration
//

typedef struct  {
char *HostName;			
char *LocalIPAddr;      // Set to "0.0.0.0" for DHCP
char *LocalIPMask;		// Not used when using DHCP
char *GatewayIP;        // Not used when using DHCP
char *DomainName;       // Not used when using DHCP
char *DNSServer;        // Used when set to anything but zero

} NDK_NETWORK_INFO;

UINT8 DHCP_OPTIONS[] = { DHCPOPT_SERVER_IDENTIFIER, DHCPOPT_ROUTER };

static void SendRawEth();
static void RecvRawEth();

#define    	TEST_RAW_NC
#define    	TEST_RAW_SEND
#undef    	TEST_RAW_RECV

#define     PACKET_SIZE     1000
#define     PACKET_COUNT    1

char *VerStr = "NetworkInit Start.\n";