/*
 *  Copyright 2007 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *
 *  @(#) TCP/IP_Network_Developers_Kit 1.93.00.09 08-16-2007 (ndk-c09)
 */
/*^M
 *  ======== client.c ========^M
 *^M
 *
 */

//--------------------------------------------------------------------------
// IP Stack Client Demo
//--------------------------------------------------------------------------
// Client.c
//
// Stack initialization functions
//
// Author: Michael A. Denio
// Copyright 2000, 2001 by Texas Instruments Inc.

#include <netmain.h>
#include <com.h>

#define REQUEST_SIZE    46720


// TCP Data Control infomation struct
typedef struct 
{
	unsigned short Command;
	unsigned char *SmallDataAddress;
	unsigned int SmallDataSize;
	unsigned char *LargeDataAddress;
	unsigned int LargeDataSize;
	unsigned char *ResultSmallDataAddress;
	unsigned int ResultSmallDataSize;
	unsigned char *ResultLargeDataAddress; 
	unsigned int ResultLargeDataSize;
	int Status;
	int rx_control;
	int tx_control;
} TCPControlInfo;

typedef struct 
{
	unsigned int SmallDataSize;
	unsigned int LargeDataSize;
} TCPReceiveData;



#define SERVER_STATUS_IDLE					0x01
#define SERVER_STATUS_RECEIVE				0x02
#define SERVER_STATUS_PROCESSING			0x04
#define SERVER_STATUS_PROCESSING_COMPLETE	0x05
#define SERVER_STATUS_SEND					0x03
#define SERVER_STATUS_ERROR					0xFF

#define SERVER_CONTROL_IDLE					0x01
#define SERVER_CONTROL_RECEIVE_HEADER		0x11
#define SERVER_CONTROL_RECEIVE_SMALL_DATA	0x12
#define SERVER_CONTROL_RECEIVE_LARGE_DATA	0x13
#define SERVER_CONTROL_RECEIVE_ALL_DATA		0x14
#define SERVER_CONTROL_RECEIVE_COMPLETE		0x15

#define SERVER_CONTROL_SEND_HEADER			0x21
#define SERVER_CONTROL_SEND_SMALL_DATA		0x22
#define SERVER_CONTROL_SEND_LARGE_DATA		0x23
#define SERVER_CONTROL_SEND_ALL_DATA			0x24
#define SERVER_CONTROL_SEND_COMPLETE			0x25



void FA_TCPServer();
SOCKET FA_connect();
void FA_disconnect();
void ReceiveTCPPacket(unsigned char *buf);
void SendTCPPacket(TCPControlInfo send);
void ReceiveTCPHeader(unsigned char *buf);
void ReceiveSmallData(unsigned char *buf, int size, int offset);
void ReceiveLagreData(unsigned char *buf, int size, int offset);
void SendTCPHeader();
void SendSmallData(unsigned char *buf, int size);
void SendLagreData(unsigned char *buf, int size);
void TCP_TransferComplete(void);
unsigned char *GetTCPBufferAddress(unsigned int *bufferMaxSize);
void Tcp_Processing();


