#include "hardware.h"
#include <csl_gpio.h>
#include <csl_gpioAux.h>
#include <csl_intc.h>
#include <soc.h>

static int lamp1, lamp2, lamp;

int valGpio;
unsigned int valGPEn;
CSL_IntcObj     gpioIntcObj_Disk1, gpioIntcObj_Disk2, gpioIntcObj_Cam4;
CSL_IntcHandle  gpioIntcHandle_Disk1, gpioIntcHandle_Disk2, gpioIntcHandle_Cam4;
CSL_IntcContext context_Disk1, context_Disk2, context_Cam4;

CSL_GpioHandle 				hGpio;
CSL_GpioObj             	gpioObj;

CSL_IntcEventHandlerRecord isr_gpio_Disk1, isr_gpio_Disk2, isr_gpio_Cam4;
CSL_IntcEventHandlerRecord gpioRecord[3];
void LampInit(void)
{
	lamp1 = 0;
	LAMP1 = 0;
	lamp2 = 0;
	LAMP2 = 0;
	lamp =0;
}

void Lamp1Off(void)
{
	lamp1 = 0;
	LAMP1 = 0;
}

void Lamp1On(void)
{
	lamp1 = 1;
	LAMP1 = 1;
}

void Lamp1Toggle(void)
{
  	if (lamp1) 
	{
		lamp1 = 0;
		LAMP1 = 0;
	} 
	else 
	{
		lamp1 = 1;
		LAMP1 = 1;
	}
}

void Lamp2Off(void)
{
	lamp2 = 0;
	LAMP2 = 0;
}

void Lamp2On(void)
{
	lamp2 = 1;
	LAMP2 = 1;
}

void Lamp2Toggle(void)
{
	if (lamp2) 
	{
		lamp2 = 0;
		LAMP2 = 0;
	} 
	else 
	{
		lamp2 = 1;
		LAMP2 = 1;
	}
}

void LampToggle(void)
{
	if (lamp) 
	{
		lamp = 0;
		LAMP1 = 1;
		LAMP2 = 0;

	} 
	else 
	{
		lamp = 1;
		LAMP1 = 0;
		LAMP2 = 1;
	}
}

int ReadDIP(void)
{
	return (~DIPSW >> 4) & 15;
}
/*
void CPBReset()
{
	int i;
	for (i = 0; i < 8; i++) REG_CPB_RESET = i & 1;
	//Sleep(1000);
	Sleep(1000);
	for (i = 0; i < 8; i++) REG_CPB_RESET = i | 2;
	//Sleep(700);
	Sleep(1000);
}
*/

void CPBReset_Low(void)
{
	volatile int i;
	for (i = 0; i < 3000; i++) 
	{
		REG_CPB_RESET = i & 1;
	}
}

void CPBReset_High(void)
{
	volatile int i;
	for (i = 0; i < 3000; i++) 
	{
		REG_CPB_RESET = (i&1) | 2;
	}	
}

// GPIO
void InitGPIO()
{
	CSL_GpioPinConfig          	config;

	CSL_GpioContext         	pContext;

	CSL_GpioHwSetup             hwSetup;

	CSL_Status              	status;

	status = CSL_gpioInit(&pContext);
	if (status != CSL_SOK) {
		return;
	}

	/* Open the CSL module */
	hGpio = CSL_gpioOpen(&gpioObj, CSL_GPIO, NULL, &status);
	if ((hGpio == NULL) || (status != CSL_SOK)) {
		return;
	}

	/* Setup hardware parameters */
	hwSetup.extendSetup = NULL;

	/* Setup the General Purpose IO */
	status = CSL_gpioHwSetup(hGpio, &hwSetup);
	status = CSL_gpioBankIntEnable(hGpio);

	//gpio pin 4,5,6,7,10 = camera1,2,3,4,5
	config.pinNum = CSL_GPIO_PIN0;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	//gpio pin 4,5,6,7,10 = camera1,2,3,4,5
	config.pinNum = CSL_GPIO_PIN4;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	config.pinNum = CSL_GPIO_PIN5;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	config.pinNum = CSL_GPIO_PIN6;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	config.pinNum = CSL_GPIO_PIN7;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}
	
	config.pinNum = CSL_GPIO_PIN3;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	
	config.pinNum = CSL_GPIO_PIN10;
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}
	
	//mcbsp0 on/off
	config.pinNum = GPIO_MCBSP_0;			//CSL_GPIO_PIN9
	config.trigger = CSL_GPIO_TRIG_CLEAR_EDGE;
	config.direction = CSL_GPIO_DIR_OUTPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	//mcbsp1 camera index (ex 00 = camera 1, 01 = camera 2)
	config.pinNum = GPIO_CAMERA_BIT0;		//CSL_GPIO_PIN11
	config.trigger = CSL_GPIO_TRIG_CLEAR_EDGE;
	config.direction = CSL_GPIO_DIR_OUTPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

 	config.pinNum = GPIO_CAMERA_BIT1;		//CSL_GPIO_PIN12
	config.trigger = CSL_GPIO_TRIG_CLEAR_EDGE;
	config.direction = CSL_GPIO_DIR_OUTPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	//capture start
	config.pinNum = GPIO_INT_CAPTURE_BIT0;	//CSL_GPIO_PIN14
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}

	config.pinNum = GPIO_INT_CAPTURE_BIT1;	//CSL_GPIO_PIN15
	config.trigger = CSL_GPIO_TRIG_RISING_EDGE;
	config.direction = CSL_GPIO_DIR_INPUT;
	status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);
	if (status != CSL_SOK) {
		return;
	}
/*
	valGpio = 0;
	valGPEn = GPIO_EN;
	GPIO_RSETH(hGpio, GPEN, valGPEn);
	GPIO_RSETH(hGpio, GPDIR, GPIO_DIR);
	GPIO_RSETH(hGpio, GPVAL, valGpio);	

	GPIO_RSETH(hGpio, GPDH, 0xC000);
	GPIO_RSETH(hGpio, GPDL, 0x0000);
//	GPIO_RSETH(hGpio, GPHM, 0x0400);
	GPIO_RSETH(hGpio, GPHM, 0xC000);
	GPIO_RSETH(hGpio, GPLM, 0x0000);
	GPIO_RSETH(hGpio, GPGC, 0x0030);
	GPIO_RSETH(hGpio, GPPOL,0x0000);
	*/
//	ResetGPIOVal(GPIO_MCBSP_0);
}

void SetGPIOVal(CSL_GpioPinNum pinNum)
{
	hGpio->regs->SET_DATA |= (0x1 << pinNum);
}
void ResetGPIOVal(CSL_GpioPinNum pinNum)
{
	hGpio->regs->CLR_DATA |= (0x1 << pinNum);	
}

void SetGPIO_DH(short val)
{
	hGpio->regs->SET_RIS_TRIG = val; 
}

void SetGPIO_HM(short val)
{	
	hGpio->regs->CLR_RIS_TRIG = val; 
}

unsigned int GetGPIO_DH(void)
{
	return hGpio->regs->IN_DATA;
}

