#ifndef _HARDWARE_H_
#define _HARDWARE_H_

#ifdef TARGET_SPB
#include <csl_gpio.h>
#endif

#define WHDOG 		  			*(volatile short int *)0xD0000026  	// bit 0 => whdog(0:disable or clear, 1:enable) 
#define LAMP1		  		*(volatile short int*)0xD0000022    // bit 0 //led3
#define LAMP2		  		*(volatile short int*)0xD0000024	// bit 0  //led4
#define TEMP		  		*(volatile short int *)0xD0000300	// bit 0  //led4
#define CPB_RESET_CONTROL		*(volatile short int *)0xD0000028
#define THREED_CAMERA_SENSOR		*(volatile short int *)0xD0000034				//bit 0 = disk1, bit1 = disk2
#define TPB_CAMERA_INT			*(volatile short int *)0xD0000038
#define MMIO_VERSION_INFO_L		*(volatile short int *)0xD0000002 	// [read-only] fpga 8bit low ver (two decimal digits of each 4bit)
#define MMIO_VERSION_INFO_H		*(volatile short int *)0xD0000004	// [read-only] fpga 8bit high ver (two decimal digits of each 4bit)

//NFA Camera FIFO
#define NFACAM_FIFO_ADDR(n)		(0xC0000000 + (n) * 0x00080000)
#define NFA_CAMERA_BASE   						0xD0090000
#define NFA_FIFO_RESET   			*(volatile short int *)0xD000002C
#define NFA_FIFO_ENABLE   		*(volatile short int *)0xD000002E
#define NFA_SET_BIT(dest_data,bit_num) dest_data = dest_data | (0x01 << bit_num)
#define NFA_RESET_BIT(dest_data,bit_num) dest_data = dest_data & ~(0x01 << bit_num)
#define NFA_CAMERA_CONTROL_TRIG   		*(volatile short int *)(NFA_CAMERA_BASE+0x4008)
#define NFA_CAMERA_CONTROL_HARDWARE_TRIG   		*(volatile short int *)0xD000001E

#define FPGA_CAMERA_MODE_2D		0
#define FPGA_CAMERA_MODE_3D		1

#define EMIF_CS2_BASE           0xA0000000		//use HPI
#define EMIF_CS3_BASE           0xB0000000		//use spansion flash memory 4Mbyte
#define EMIF_CS4_BASE           0xC0000000		//use FIFO
#define EMIF_CS5_BASE           0xD0000000		//use samsung flash memory 16Mbyte
#define CACHE_L1PINV              (CSL_CACHE_0_REGS + 0x5028) // L1PINV Control
#define CACHE_L2WBINV             (CSL_CACHE_0_REGS + 0x5004) // L2WBINV Control
#define CACHE_L2INV               (CSL_CACHE_0_REGS + 0x5008) // L2INV Control
#define CACHE_L1PINV              (CSL_CACHE_0_REGS + 0x5028) // L1PINV Control
#define CACHE_L1DWBINV            (CSL_CACHE_0_REGS + 0x5044) // L1DWBINV Control
#define CACHE_L1DINV              (CSL_CACHE_0_REGS + 0x5048) // L1DINV Control

void LampInit(void);

void Lamp1On(void);
void Lamp1Off(void);
void Lamp1Toggle(void);

void Lamp2On(void);
void Lamp2Off(void);
void Lamp2Toggle(void);

void HARDWARE_InitializeTimer0(void);


// DIP switch
#define DIPSW  		  		*(volatile short int *)0xD000002A  	// bit 7,6,5,4 dip switch, bit 3: cpu id, bit 2: M_prg, bit 1: flash busy
#define DIPSW_MPRG			0x0004
int ReadDIP(void);
/*

#include "..\common.h"



*/
// Flash memory 

#define FM_K9F2808
//#define S29GL032N
// Register for Flash control 
#define FLASH_CONTROL		*(volatile short int *)0xD0000020
#define FLASH_DATA	  		*(volatile short int *)0xD0040000
#define FLASH_STATUS  		*(volatile short int *)0xD000002A  

#define FLASH_ENVIRONMENT	0
//#define FLASH_PROGRAM		20
#define SDRAM_REFRESH_RATE         (0x0000079Eu)

#define CPB_DEVICE_INFO_ADDR	0x000003F0u

#define CPB_VECTOR_ADDR			0x02049008
#define CPB_BOOT_COMPLETE_ADDR	0x0204900C

#define CPU_KIND_C64								0
#define CPU_KIND_C64PLUS							1
#define CPU_KIND_6678								2
#define CPU_KIND_6678_MONITOR						3

#define CPB03_CPB_HPI_STATUSLIST_ADDR	0x000DF000
#define CPB03_CPB_HPI_WSTATE_ADDR		0x000DF00C
#define CPB03_CPB_BUFFER_ADDR1			0x000DD000	// 4K  packet size is 2048 + header size (5)
#define CPB03_CPB_BUFFER_ADDR2			0x000DE000	// 4K 

#define CPB04_CPB_HPI_STATUSLIST_ADDR	0x00000C00
#define CPB04_CPB_DSPINT_STATUS_ADDR	0x00000C04
#define CPB04_CPB_HPI_WSTATE_ADDR		0x00000C0C
#define CPB04_CPB_BUFFER_ADDR1			0x00001000	// 4K  packet size is 2048 + header size (5)
#define CPB04_CPB_BUFFER_ADDR2			0x00002000	// 4K 

// GPIO 

#define GPIO_MCBSP_0			CSL_GPIO_PIN9
//#define GPIO_MCBSP_2		GPIO_PIN10
//#define GPIO_INT_CAPTURE	GPIO_PIN10
#define GPIO_CAPTURE_HCB		CSL_GPIO_PIN3
//#define GPIO_CAMERA_1		GPIO_PIN11
//#define GPIO_CAMERA_2		GPIO_PIN12
//#define GPIO_CAMERA_3		GPIO_PIN13
#define GPIO_CAMERA_BIT0		CSL_GPIO_PIN11
#define GPIO_CAMERA_BIT1		CSL_GPIO_PIN12
#define GPIO_USB_DREQ			CSL_GPIO_PIN13
#define GPIO_INT_CAPTURE_BIT0	CSL_GPIO_PIN14
#define GPIO_INT_CAPTURE_BIT1	CSL_GPIO_PIN15

// GPIO 4,5,6,7 are enabed for USB

#define GPIO_EN				(CSL_GPIO_PIN4		| \
							CSL_GPIO_PIN5 		| \
							CSL_GPIO_PIN6 		| \
							CSL_GPIO_PIN7 		| \
							GPIO_MCBSP_0 	| \
							GPIO_INT_CAPTURE_BIT0 | \
							GPIO_INT_CAPTURE_BIT1 | \
							GPIO_CAMERA_BIT0 | \
							GPIO_CAMERA_BIT1 | \
							GPIO_CAPTURE_HCB | \
							GPIO_USB_DREQ)

#define GPIO_DIR			(GPIO_MCBSP_0 	| \
							 GPIO_CAMERA_BIT0 | \
							 GPIO_CAMERA_BIT1)

#ifdef TARGET_SPB
extern CSL_GpioHandle hGpio;
extern int valGpio;
#endif

typedef struct  {
    /** pointer to the event handler */
    int	enable;
    /** the argument to be passed to the handler when it is invoked */  
    int	disable;                                 
} Interrupt_status;

void InitGPIO();
#define	REG_CPB_RESET		*(volatile short int *)0xD0000028


// CPB - HPI

#define HPI_BASE(n)			(0xA0000000 + ((n) << 16))

#define HPI_CTRL(n)			(volatile unsigned int *)HPI_BASE(n)
#define HPI_ADDR(n)			(volatile unsigned int *)(HPI_BASE(n) + 0x8000)
#define HPI_DATA_INC(n)		(volatile unsigned int *)(HPI_BASE(n) + 0x4000)

//#define HPI_ADDR(n)			(volatile unsigned int *)(HPI_BASE(n) + 0x8000)
//#define HPI_DATA_INC(n)		(volatile unsigned int *)(HPI_BASE(n) + 0x4000)
#define HPI_DATA_FIX(n)		(volatile unsigned int *)(HPI_BASE(n) + 0xC000)


//unsigned int *SetHPI(int cpb, unsigned int addr);
void SetHPI(int cpb, unsigned int addr);

void SetGPIOVal(int val);
void ResetGPIOVal(int val);

void SetGPIO_DH(short val);
void SetGPIO_HM(short val);
unsigned int GetGPIO_DH(void);

void FPGA_SetCameraMode(unsigned short cameraMode);

#endif
