#ifndef _IMAGE_CONTROL_H_
#define _IMAGE_CONTROL_H_

#include "processing.h"

#define MAX_IMAGE_BLOCK_INDEX			1024		
#define TBB_IMAGE_BUFFER_SIZE		(100 * 1024 * 1024)  // ִ 253M 尡.


extern unsigned char nomalImageBuffer[TBB_IMAGE_BUFFER_SIZE];
extern unsigned char DefectImageBuffer[TBB_IMAGE_BUFFER_SIZE];
extern unsigned char DummyImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];

#define IMAGE_QUEUE_SIZE		256		// MAX_IMAGE_BLOCK_INDEX  ų ũ..
#define IMAGE_QUEUE_MASK		255

typedef struct
{
	int BlockSize;
	int BlockCount;
	int currentIndex;
	int cpbsendIndex;
	int uploadIndex;
	int inspectionIndex;
	unsigned char *ImageBuffer[MAX_IMAGE_BLOCK_INDEX];
	int CapturePeriod[MAX_IMAGE_BLOCK_INDEX];
	int Status[MAX_IMAGE_BLOCK_INDEX];
} TImageInfo;

extern TImageInfo NomalImageInfo;
extern TImageInfo DefectImageInfo;
extern TTPBMonitorInsData TPBMonitorInsData;


void AllocateImageBuffer(int imageBlockSize);
void ImageControl_ClearBuffer(void);
int ImageControlGetCapturedFrameCount(int type);
unsigned char* ImageControlGetFirstValidFrameBuffer(int type);

#endif

