#ifndef __SRIO_MASTER_H__
#define __SRIO_MATER_H__

#define SRIO_TRANSFER_RETRY_COUNT					5

#define SRIO_TX_PROCESS_STATUS_IDLE						0
#define SRIO_TX_PROCESS_STATUS_READY						1
#define SRIO_TX_PROCESS_STATUS_MAKE_IMAGE_PACKET		2
#define SRIO_TX_PROCESS_STATUS_MAKE_DATA_PACKET		3
#define SRIO_TX_PROCESS_STATUS_MAKE_CHECKSUM			4
#define SRIO_TX_PROCESS_STATUS_WRITE_PACKET				5
#define SRIO_TX_PROCESS_STATUS_READ_PACKET				6
#define SRIO_TX_PROCESS_STATUS_MAKE_LAST_PACKET		7
#define SRIO_TX_PROCESS_STATUS_SEND_LAST_PACKET		8
#define SRIO_TX_PROCESS_STATUS_READ_LAST_PACKET		9
#define SRIO_TX_PROCESS_STATUS_SEND_COMPLETE			10

#define SRIO_RX_PROCESS_STATUS_IDLE						0
#define SRIO_RX_PROCESS_STATUS_MAKE_HEADER_PACKET		1
#define SRIO_RX_PROCESS_STATUS_WRITE_HEADER				2
#define SRIO_RX_PROCESS_STATUS_READ_HEADER				3
#define SRIO_RX_PROCESS_STATUS_READ_DATA				4
#define SRIO_RX_PROCESS_STATUS_CHECKSUM					5
#define SRIO_RX_PROCESS_STATUS_COPY_DATA				6
#define SRIO_RX_PROCESS_STATUS_COPY_COMPLET				7
#define SRIO_RX_PROCESS_STATUS_RECEIVE_COMPLETE			100


#define SRIO_TX_PROCESS_STATUS_CHECK_CBP		1

#define ERROR_CODE_SRIO_TX_TIMEOUT						0x100
#define ERROR_CODE_SRIO_TX_MAKE_PACKET_TIMEOUT			0x101
#define ERROR_CODE_SRIO_TX_WRITE_TIMEOUT				0x102
#define ERROR_CODE_SRIO_TX_READ_TIMEOUT					0x103
#define ERROR_CODE_SRIO_TX_DATA_TRANS_FAIL				0x104

#define ERROR_CODE_SRIO_RX_TIMEOUT						0x200
#define ERROR_CODE_SRIO_RX_MAKE_PACKET_TIMEOUT			0x201
#define ERROR_CODE_SRIO_RX_WRITE_TIMEOUT				0x202
#define ERROR_CODE_SRIO_RX_READ_TIMEOUT					0x203
#define ERROR_CODE_SRIO_RX_DATA_TRANS_FAIL				0x204

#define SRIO_TRANSFER_STATUS_PENDING						0
#define SRIO_TRANSFER_STATUS_ON_TRANSFER				1
#define SRIO_TRANSFER_STATUS_COMPLETE					2

#define SRIO_TRANSFER_KIND_DATA							0
#define SRIO_TRANSFER_KIND_IMAGE							1

#define SRIO_PORT_MAX_COUNT								4
#define SRIO_PORT0_ENABLE_BIT								0x1
#define SRIO_PORT1_ENABLE_BIT								0x2
#define SRIO_PORT2_ENABLE_BIT								0x4
#define SRIO_PORT3_ENABLE_BIT								0x8

#define SRIO_CPB_WAIT_TIME									2

void Srio_Master_Init(void);
void Srio_Module_Init(void);
int SRIO_SendData(unsigned short pri_indicator, unsigned int sec_indicator, void *data_address, int elementLength_word, int cpbIndex, int transferKind, int frameCount, int frameIndex, int dstStartPosition);
int Request_ReceiveData(unsigned short indicator, void *data_address, unsigned int data_size, int cpbIndex);
typedef struct
{
	volatile unsigned char Status;
} TSRIOTransferStatus;

typedef struct
{
    Int32 blken; 
    Int32 port;
    Int32 portEnbit;
    Int32 srcID;
    Int32 dstID;
    Int32 portmode;
    Int32 portspeed;
    Int32 loopback;
    int srio_process_status;
    TSRIOTransferStatus *TransferStatus;	
} TSrioControl;



#endif /* __SRIO_MASTER_H__ */

