#include "system_setup.h"
#include "environment.h"
//#include "define.h"
#include "tpb_system.h"
#include "com.h"
#include <csl_emifa.h>

#define C64PLUS_L2_ADDR						0x00A00000u
#define C64_L2_ADDR								0x00000000u
#define C6678_L2_ADDR							0x10800000u
#define C6678_L2_CORE_INTERVAL					0x01000000u
#define C6678_BOOT_ADDRESS_INTERVAL			0x100
#define C6678_BOOT_REGISTER_ADDRESS			0x02620040
#define C6678_BOOT_CORE_ADDRESS				0x1087FFFC
#define C6678_BOOT_INT_ADDRESS				0x02620240
#define C6678_BOOT_COMPLETE_ADDRESS			0x0262013C


#pragma DATA_ALIGN(SPBSystemInfo, 8)


TSPBSystemInfo SPBSystemInfo;

TSPBSystemSetupData SystemSetupData;

void SystemSetup_InitDefault()
{
	int cpbIndex, camIndex;
	SystemSetupData.DefaultCPBProgramID = PID_CPB | ('0' << 8) | '0'; 

	for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
	{
		SystemSetupData.CPBEnabled[cpbIndex] = 0;
		SystemSetupData.CPBSDRSizeType[cpbIndex] = 0;
		SystemSetupData.CPBClockKind[cpbIndex] = CPB_CPU_CLOCK_KIND_900;
	}
/*
	for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; camIndex++)
    {
		SystemSetupData.CameraHardwarePosition[camIndex] = camIndex;
		SystemSetupData.CameraKind[camIndex]  = CAMERA_KIND_NFA_2D;
		SystemSetupData.InspectPosition[camIndex] = 0;
    }
*/
}


void SystemSetup_CameraKind()
{
	int cpbIndex, camIndex;
	for (camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_MAX_COUNT; camIndex++)
    {
		SystemSetupData.CameraHardwarePosition[camIndex] = camIndex;
		SystemSetupData.CameraKind[camIndex]  = CAMERA_KIND_NFA_2D;
		//SystemSetupData.InspectPosition[camIndex] = 0;
    }
}



void SystemInfo_InitDefault(void)
{
	int clientBoardIndex;

	for (clientBoardIndex = 0; clientBoardIndex < SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT; clientBoardIndex++)
	{
		SPBSystemInfo.CPBRevInfo[clientBoardIndex] = CPB_REV_004;
	}
	
}




void ApplySystemSetup()
{

	int cpbIndex,spbCamIndex; //ranger3DCamHWIndex; //camIndex
	for (cpbIndex = 0; cpbIndex < TPB_CPB_MAX_COUNT; cpbIndex++)
	{
		CPBStatus[cpbIndex].Enabled = TRUE;		// 'enabled' <=> 'use' <- not 'down'
		CPBStatus[cpbIndex].IsDown = FALSE;
		CPBStatus[cpbIndex].Status = CPB_STATUS_IDLE;
	}
	TPBCameraInit();
}

void ApplySystemInfo(void)
{
	int cpbIndex;
	for (cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
	{
		CPBHWInfo[cpbIndex].CPUKind = 			CPU_KIND_6678;
		CPBHWInfo[cpbIndex].BaseL2Addr = 			C6678_L2_ADDR+(C6678_L2_CORE_INTERVAL*(cpbIndex%8)); 
		CPBHWInfo[cpbIndex].CPBStatusAddr = 		SRIO_SLAVE_STATUS_BASE_ADDRESS+SRIO_SLAVE_L2_CORE_INTERVAL*(cpbIndex%8);
		CPBHWInfo[cpbIndex].CPBBuffer1Addr = 		SRIO_SLAVE_DATA_BASE_ADDRESS+SRIO_SLAVE_L2_CORE_INTERVAL*(cpbIndex%8);
		//srio  ʾ ӽ÷ ٸ 뵵 .  ý ʿ ּҰ ־ ýÿ . 
		CPBHWInfo[cpbIndex].SrioBootStartAddr = 		CPBHWInfo[cpbIndex].BaseL2Addr+C6678_BOOT_ADDRESS_INTERVAL;   //boot_start address
		CPBHWInfo[cpbIndex].SrioBootRegisterAddr = 		C6678_BOOT_REGISTER_ADDRESS+((cpbIndex%8)*4);					    //boot_register_address
		CPBHWInfo[cpbIndex].SrioCoreBootAddr =		C6678_BOOT_CORE_ADDRESS + (C6678_L2_CORE_INTERVAL*(cpbIndex%8));
		CPBHWInfo[cpbIndex].SrioBootIntAddr =			C6678_BOOT_INT_ADDRESS + ((cpbIndex%8)*4);	
		CPBHWInfo[cpbIndex].SrioBootCompleteAddr =	C6678_BOOT_COMPLETE_ADDRESS;
	
	}
}

void ModifySystemInfo(TSPBSystemInfo *spbSystemInfo)
{
	memcpy(&SPBSystemInfo, spbSystemInfo, sizeof(TSPBSystemInfo));
	WriteToFlash(PID_SYSTEM, (unsigned char *)&SPBSystemInfo, sizeof(TSPBSystemInfo), 0);
	ApplySystemInfo();
}

void ModifySystemSetup(TSPBSystemSetupData *spbSystemSetupData)
{
	memcpy(&SystemSetupData, spbSystemSetupData, sizeof(TSPBSystemSetupData));
	WriteToFlash(PID_ENVIRONMENT, (unsigned char *)&SystemSetupData, sizeof(TSPBSystemSetupData), 0);
	ApplySystemSetup();
}
