#include "timer.h"
#include "hardware.h"
//#include "define.h"
#include "environment.h"
#include "DMAScheduler.h"

#include <csl_chip.h>
#include <csl_tmr.h>
#include <csl_tmrAux.h>
#include <csl_intc.h>
#include <csl_intcAux.h>
#include <soc.h>

#define TIMER_EVENT_TABLE_SIZE_1MS			4
#define TIMER_EVENT_TABLE_SIZE_1S			4

CSL_IntcObj                 intcTimerObj;
CSL_TmrObj 			TmrObj;
CSL_IntcHandle              hIntcTimer;
CSL_IntcEventHandlerRecord  EventRecord;
CSL_IntcParam               vectId;
volatile unsigned int	 intrCnt_timer = 0;
int board50uSCounter; 
int timer200usCounter;
CSL_TmrHandle TimerHandle0;
CSL_TmrHandle TimerHandle1;
unsigned int timer20msCounter = 19;  // 20 - 1
unsigned int timer50msCounter = 49;  // 20 - 1
volatile unsigned int Board50usTimer = 0;
volatile unsigned int Board100usTmr = 0; 
volatile unsigned int Board1MSTmr = 0;
unsigned int Board100msCounter = 99;  // 100 - 1
volatile unsigned int Board100MSTmr = 0;
int timer1SCounter;
int sleep_lock;
unsigned int board1msCounter 			= 16; //sjm Add For RunTime

extern Interrupt_status int_status[15];
typedef void (* TFTimerEvent) (void);

int Timer0OverlapCount;
int OnTimer50usProcess;
int Timer1msEvent;
int Timer200usEvent;
int OnTimerProcess;
int tmr_debug_count;
int SysLock;

void IsrTimer0(void);
//----------------------------------------------------------
void InitTimer(void)
{
//	HARDWARE_InitializeTimer0();
	HARDWARE_InitializeTimer1();
	OnTimer50usProcess = 0;
	Timer0OverlapCount = 0;
	Timer1msEvent = 0;
	board50uSCounter = 19; 
	timer200usCounter = 3; //sjm chg For RunTime 3 => 2 ==> 3(2016.11.14 .)
	Timer200usEvent = 0;
	OnTimerProcess = 0;
	board1msCounter = 16;
	sleep_lock = 0;
	tmr_debug_count = 0;
	timer1SCounter = 999;
	CSL_intcInterruptEnable(CSL_INTC_VECTID_5);
}
//----------------------------------------------------------

void HARDWARE_InitializeTimer1(void)
{
	CSL_Status status;
	CSL_TmrHwSetup hwSetup = CSL_TMR_HWSETUP_DEFAULTS;
	CSL_TmrEnamode TimeCountMode = CSL_TMR_ENAMODE_CONT;
	Uint32 LoadValue = 0x1CB6;// 0.05ms  =  ((50us * 850MHz / 6) / 12)
	//0x208D;
	// Event Enable
	CSL_tmrInit(NULL);
	TimerHandle1 = CSL_tmrOpen (&TmrObj, CSL_TMR_1, NULL, &status);

	status = CSL_tmrHwSetup(TimerHandle1, &hwSetup);
	hwSetup.tmrClockPulseLo = CSL_TMR_CP_CLOCK;
	hwSetup.tmrTimerMode = CSL_TMR_TIMMODE_DUAL_UNCHAINED;
	hwSetup.tmrClksrcLo = CSL_TMR_CLKSRC_INTERNAL;
	status = CSL_tmrHwSetup(TimerHandle1, &hwSetup);
	status = CSL_tmrHwControl(TimerHandle1, CSL_TMR_CMD_RESET_TIMLO, NULL);
	status = CSL_tmrHwControl(TimerHandle1, CSL_TMR_CMD_LOAD_PRDLO, (void *)&LoadValue);

	status = CSL_tmrHwControl(TimerHandle1, CSL_TMR_CMD_START_TIMLO, (void *)&TimeCountMode);
}
void System_Sleep_ms(int millisecond)
{
	CSL_TmrObj TmrObj;
	CSL_Status status;
	int tPeriod;
	int remainTime;
	int newCount, oldCount;
	int period;
	remainTime = millisecond;
	tPeriod = 0;
	TimerHandle0 = CSL_tmrOpen (&TmrObj, CSL_TMR_0, NULL, &status);
	CSL_tmrGetTimLoCount(TimerHandle0,&oldCount);

	period = TimerHandle0->regs->PRDLO;	//TIMER_getPeriod(TimerHandle0);
	
	newCount = oldCount;
	while (remainTime > 0)
	{

		CSL_tmrGetTimLoCount(TimerHandle0,&newCount);
		if (oldCount > newCount)
		{
			tPeriod += (period + newCount - oldCount);
		}
		else
		{
			tPeriod += (newCount - oldCount);
		}
		oldCount = newCount;
		if (tPeriod >= 166666) // 0.5ms *20 = 1ms
		{
			tPeriod -= 166666;
			remainTime--;
		}
	}
}
//----------------------------------------------------------
void IsrTimer0(void)
{
	unsigned int irp, csr, ier, iemt, iemr, iect, iecr;//, iecp;
	int cpbIndex;
	if (OnTimer50usProcess)
	{
		Timer0OverlapCount++;
		Board50usTimer++;
		TPBProcessCapture();
	 	if (board50uSCounter)
	 	{
	 		board50uSCounter--;
			if (board50uSCounter & 1)
			{
				Board100usTmr++;
			}
	 	}
	 	else
	 	{
			Board1MSTmr++;
	 	 	board50uSCounter = 19;

			if (Board100msCounter)
			{
				Board100msCounter--;
			}
			else
			{
				Board100MSTmr++;
				Board100msCounter = 99;
			}

			Timer1msEvent = 1;
	 	}

		if (timer200usCounter)
		{
			timer200usCounter--;
		}
		else
		{
			timer200usCounter = 3; 
			Timer200usEvent = 1;			
		}
	}
	else
	{
		irp = CSL_chipReadReg(CSL_CHIP_IRP);
	 	if (board50uSCounter)
	 	{
	 		board50uSCounter--;
			if (board50uSCounter & 1)
			{
				Board100usTmr++;
			}
	 	}
	 	else
	 	{
			Board1MSTmr++;			
			board50uSCounter = 19;

			if (Board100msCounter)
			{
				Board100msCounter--;
			}
			else
			{
				Board100MSTmr++;
				Board100msCounter = 99;
			}
			Timer1msEvent = 1;
	 	}
		if (timer200usCounter)
		{
			
			timer200usCounter--;
		}
		else
		{
			timer200usCounter = 3;				
			Timer200usEvent = 1;
		}
		
		OnTimer50usProcess = 1;
		Board50usTimer++;
		TPBProcessCapture();		
	 	TPBProcess();
		OnTimer50usProcess = 0;
		if (OnTimerProcess == 0)
		{			
			OnTimerProcess = 1;
			if (Timer200usEvent != 0)
			{
				Timer200usEvent = 0;
			}

			if (Timer1msEvent != 0)
			{
				Timer1msEvent = 0;
				TPBCaptureTimeOutProcess();
				if (timer20msCounter == 0)
				{				
					timer20msCounter = 19;
				}							
				else
				{
					timer20msCounter--;
				}
			}
			OnTimerProcess = 0;
		}
		CSL_chipWriteReg(CSL_CHIP_IRP,irp);
	}
}
//----------------------------------------------------------
void Sleep(int miliSeconds)
{
	unsigned int st;
	st = Board1MSTmr;
	while(1)
	{
		if (Board1MSTmr - st > miliSeconds)
		{
			break;
		}
	} 	
}
//----------------------------------------------------------
