#ifndef _SPB_SYSTEM_H_
#define _SPB_SYSTEM_H_

#include "common.h"
#include "environment.h"

extern unsigned int CPB_StatusList[TPB_CPB_MAX_COUNT];	// read from cpb

#define PROCESSING_CAPTURE_STATUS_IDLE				1
#define PROCESSING_CAPTURE_STATUS_REQUESTED			2
#define PROCESSING_CAPTURE_STATUS_ON_CAPTURE		3
#define PROCESSING_CAPTURE_STATUS_FINISHED			4


#define CPB_BOOT_PROCESS_IDLE 					0
#define CPB_BOOT_PROCESS_READY				1
#define CPB_BOOT_PROCESS_LOAD_PROGRAM		2
#define CPB_BOOT_PROCESS_DOWNLOAD			3	
#define CPB_BOOT_PROCESS_RUN					4
#define CPB_BOOT_PROCESS_COMPLETE			5

#define CPB_HEX_FORMAT_L2SEG					0x1080
#define CPB_PROGRAM_TRANSFER_SIZE			(1024*2)			// 2k
#define CPB_BOOT_RETRY_COUNT					10
		
#define SRIO_BOOT_WAIT_TIME					5000			//5sec
typedef struct
{
	int Status;
	int Enabled;
	int CaptureHeight;
    int CapturedLineCount;
} TProcessingCaptureInfo;
extern TProcessingCaptureInfo ProcessingCaptureInfo[SYSTEM_SPB_CAMERA_MAX_COUNT];


typedef struct
{
	unsigned short CPUSpeed;
	unsigned int BaseL2Addr;
	unsigned int CPUKind;
	unsigned int CPBStatusAddr;
	unsigned int CPBWStateAddr;
	unsigned int CPBBuffer1Addr;
	unsigned int CPBBuffer2Addr;
	unsigned int CPBBuffer3Addr;
	unsigned int CPBBuffer4Addr;
	unsigned int HPIAddr_Addr;
	unsigned int HPIData_Inc_Addr;	
} TCPBInfo;

extern TCPBStatus CPBStatus[TPB_CPB_MAX_COUNT];


//extern TSystemInfo SystemInfo;
extern TCPBRunStatus CPBRunStatus;

typedef struct
{
	unsigned int RunSW;
	unsigned int RunMode;
	unsigned int RunMask[2];
	TFFID RunCPB_FFID;
	unsigned char RunStep;
	unsigned char RunSubStep;
	char dummyChar[2];
	unsigned int WaitingStartTime;
	unsigned char RunSuccess[TPB_CPB_MAX_COUNT];
	unsigned char Error[TPB_CPB_MAX_COUNT];
	int CurrentCPBIndex;
	// for cpb download
	unsigned int TargetCPURev;
	int CPBProgramSize;
	unsigned char *CPBProgram;
	// for lru algorithm
	int LRUFileIndex;
	TFFID IDFile1;
	TFFID IDFile2;
	unsigned int TargetCPURev1;
	unsigned int TargetCPURev2;
	int CPBProgramSize1;
	int CPBProgramSize2;	
} TRunInfo;
extern TRunInfo RunInfo;

typedef struct
{
	unsigned int RunSW;
	unsigned int RunMode;
	TFFID RunCPB_FFID;
	unsigned char RunStep;
	char dummyChar[2];
	unsigned int WaitingStartTime;
	unsigned char RunSuccess[TPB_CPB_MAX_COUNT];
	unsigned char Error[TPB_CPB_MAX_COUNT];
	int CurrentCPBIndex;
	unsigned int TargetCPURev;
	int CPBProgramSize[SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT];
	unsigned char *CPBProgram[SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT];
} TSrioRunInfo;
extern TSrioRunInfo SrioRunInfo;

extern int CPBBootEnable;


typedef struct
{
	unsigned int CPBBuffer1Addr;
	unsigned int CPBBuffer2Addr;
	unsigned int CPBBuffer3Addr;
	unsigned int CPBBuffer4Addr;
	unsigned int DSPInt_Status_Addr;
	unsigned int CPBWStateAddr;
	unsigned int HPIData_Inc_Addr;
	unsigned int HPIAddr_Addr;
	unsigned int CPUKind;
	unsigned int CPBStatusAddr;
	unsigned int BaseL2Addr;
	unsigned int SrioBootStartAddr;
	unsigned int SrioBootRegisterAddr;
	unsigned int SrioCoreBootAddr;
	unsigned int SrioBootIntAddr;
	unsigned int SrioBootCompleteAddr;
	
} TCPBHWInfo;
extern TCPBHWInfo CPBHWInfo[TPB_CPB_MAX_COUNT];

typedef struct
{
	unsigned char ProcessingState;
} TSSCPBInfo;

typedef struct
{
	TSSCPBInfo CPBInfo[TPB_CPB_MAX_COUNT];
} TSPBSubSystem;

typedef struct
{
    float   zoomMeasure;
    float   averageZoomMeasure;
    int     distanceFromCamera1X;
    int     distanceFromCamera1Y;
} TCameraInformation;

typedef struct
{
    unsigned short status;
    unsigned short speed;
} TCPBSystemSetup;

typedef struct {
    TCameraInformation camInfo;
	unsigned short countCPB;
	unsigned short minCPB;
	unsigned char captureSpeed;		// 0 : Half Capture Speed  1 : Full Capture Speed
	unsigned char dummy[3];

	TCPBSystemSetup CPB[SYSTEM_CPB_COUNT];
} TSPBSystemSetup;

extern TSPBSubSystem SPBSubSystem;

extern TIdleProcessData IdleProcessData;

extern volatile int System_Reset_SW;
extern unsigned int System_Reset_Trigger_Time;

void ProcessingCapture_Init(void);
void ProcessingCapture_StatusReset(void);
void CPBProcessingCheckStart(int cpbIndex);
int Check_Process_Finished(int cpbIndex);
void Cpb_Boot_Process();

int Request_SendData(unsigned short indicator, void *data_address, int data_size, int cpbIndex, unsigned int dst_address);
int Request_ReceiveData(unsigned short indicator, void *data_address, unsigned int data_size, int cpbIndex);

#endif
