/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ************************************************************************//**
 *
 * @file       EVM_EMIFHPI.h
 * 
 * @brief      Utility functions for writing/reading of the EVM's HPI through
 *                EMIF
 *  
 *
 * (c) 2008, Lyrtech RD Inc. All rights reserved.              
 *
 * @ingroup     EVM_EMIFHPI
 *
 ****************************************************************************
 *                                                                                          
 * "$Revision: 1.9 $"
 * "$Date: 2009/02/27 19:38:53 $"
 *
 ***************************************************************************/

#ifndef __EVM_EMIFHPI_H__
#define __EVM_EMIFHPI_H__

#ifdef __cplusplus
    extern "C" {
#endif // __cplusplus 

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/
#include <tistdtypes.h>

/****************************************************************************
 *                             Local constants                              *
 ****************************************************************************/


/****************************************************************************
 *                           Forward Declarations                           *
 ****************************************************************************/


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/

/****************************************************************************
*   NAME : EVM_EMIFHPI_readdata(Uint32 u32Address, Uint32 *pu32Data, Uint32 u32Length)
************************************************************************//**
*
*   This function will write a defined length in the slave device
*   To be called in Host
*
*   @param [in] u32Address
*      Address of the buffer to be read in slave
*
*   @param [out] pu32Data
*      Data read buffer in host
*
*   @param [in] u32Length
*      Length of the buffer in ints (4 bytes)
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_readdata(Uint32 u32Address, Uint32 *pu32Data, Uint32 u32Length);

/****************************************************************************
*   NAME : EVM_EMIFHPI_writedata(Uint32 u32Address, Uint32 *pu32Data, Uint32 u32Length)
************************************************************************//**
*
*   This function will write a defined length in the slave device
*   To be called in Host
*
*   @param [in] u32Address
*      Address of the buffer to be written in slave
*
*   @param [in] pu32Data
*      Data written buffer in host
*
*   @param [in] u32Length
*      Length of the buffer in ints (4 bytes)
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_writedata(Uint32 u32Address, Uint32 *pu32Data, Uint32 u32Length);

/****************************************************************************
*   NAME : EVM_EMIFHPI_initslavehpi
************************************************************************//**
*
*   This function initializes the slave HPI. 
*   To be called in Host
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_initslavehpi(void);

/****************************************************************************
*   NAME : EVM_EMIFHPI_interruptdsp
************************************************************************//**
*
*   This function interrupts the hpi device
*   To be called in Host
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_interruptdsp(void);

/****************************************************************************
*   NAME : EVM_EMIFHPI_clearsdspint
************************************************************************//**
*
*   This function clears the DSP interrupt
*   To be called in Host
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_clearsdspint(void);

/****************************************************************************
*   NAME : EVM_EMIFHPI_clearhpic
************************************************************************//**
*
*   This function clears the Hpi Control Register
*   To be called in Hpi device
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_clearhpic(void);

/****************************************************************************
*   NAME : EVM_EMIFHPI_interrupthost
************************************************************************//**
*
*   This function interrupts the host
*   To be called in Hpi device
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_interrupthost(void);

/****************************************************************************
*   NAME : EVM_EMIFHPI_interrupthost
************************************************************************//**
*
*   This function polls the device interrupt bit
*   To be called in Hpi device
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
Int32 EVM_EMIFHPI_getinterrupthost(void);

/****************************************************************************
*   NAME : EVM_EMIFHPI_clearshostint
************************************************************************//**
*
*   This function clears the interrupt from the host
*   To be called in Hpi device
*  
*   @return
*   
*   @ingroup EVM_EMIFHPI
*
***************************************************************************/ 
void EVM_EMIFHPI_clearshostint(void);



#ifdef __cplusplus
}
#endif //__cplusplus 
#endif //__EVM_EMIFHPI_H__


