/***************************************************************************
 *
 *
 *         **   **    **  ******  ********  ********  ********  **    **    
 *        **    **   **  **   ** ********  ********  ********  **    **
 *       **     *****   **   **    **     **        **        **    **
 *      **       **    ******     **     ****      **        ********
 *     **       **    **  **     **     **        **        **    **
 *    *******  **    **   **    **     ********  ********  **    **
 *   *******  **    **    **   **     ********  ********  **    **  
 *
 *            L Y R T E C H   S I G N A L   P R O C E S S I N G              
 *
 ************************************************************************//**
 *
 * Project     EVM
 * @file       EVM_LED.h
 * 
 * @brief      Utility functions for writing/reading the LEDs of the DSP.  
 *
 * (c) 2008, Lyrtech RD Inc. All rights reserved.              
 *
 * @ingroup     EVM_LED
 *
 ****************************************************************************
 *                                                                                          
 * "$Revision: 1.5 $"
 * "$Date: 2009/02/27 19:38:53 $"
 *
 ***************************************************************************/

#ifndef __EVM_LED_H__
#define __EVM_LED_H__

#ifdef __cplusplus
    extern "C" {
#endif // __cplusplus 

/****************************************************************************
 *                                 Includes                                 *
 ****************************************************************************/


/****************************************************************************
 *                             Local constants                              *
 ****************************************************************************/

/** @name EVM LEDs
 *  LEDs present on the EVM
 */
//@{
#define EVM_LED_DSP1_LED            0
#define EVM_LED_DSP2_LED            1
#define EVM_LED_DSP1_BICOLOR_LED    2
#define EVM_LED_DSP2_BICOLOR_LED    3
//@}

/** @name EVM LEDs colors
 *  LED colors 
 */
//@{
#define EVM_LED_LED_OFF             0
#define EVM_LED_LED_GREEN           1
#define EVM_LED_LED_RED             2
#define EVM_LED_LED_YELLOW          3
//@}


/** @name Error codes
 *  LED module error codes
 */
//@{
#define EVM_LED_WRONG_DSP           0x501
#define EVM_LED_OK                  0
//@}


/** @name LED Override definitions
 *  States for the CPLD led override
 */
//@{
#define EVM_LED_OVERRIDE            1
#define EVM_LED_DONTOVERRIDE        0
//@}


 
/****************************************************************************
 *                             Local variables                              *
 ****************************************************************************/

 
/****************************************************************************
 *                           Forward Declarations                           *
 ****************************************************************************/


/****************************************************************************
 *                             Private Functions                            *
 ****************************************************************************/


/****************************************************************************
 *                             Public Functions                             *
 ****************************************************************************/


/****************************************************************************
 *   NAME : EVM_LED_init
 ************************************************************************//**
 *
 *   This function will initialize all settings for the LED module. 
 *   It must be usually the first function called when using this module.
 *
 *   @return   Error code
 *   
 *   @ingroup EVM_GPIO
 *
 ***************************************************************************/ 
Int32 EVM_LED_init ();
                                                                             


 /****************************************************************************
 *   NAME : EVM_LED_setled(int Led, int LedState)
 ************************************************************************//**
 *
 *   This function will control private DSP LED.
 *
 *   @param [in] ledstate
 *      Status of the led to be set. (EVM_GPIO_LED_ON, EVM_GPIO_LED_OFF)
 *  
 *   @return   Error code
 *   
 *   @ingroup EVM_GPIO
 *
 ***************************************************************************/ 
Int32 EVM_LED_setled(int iLed, int iLedState);


 /****************************************************************************
 *   NAME : EVM_LED_overridebicolorled(int iOverrideState)
 ************************************************************************//**
 *
 *   This function will allow override of cpld jtag leds (dps 2 only).
 *
 *   @param [in] iOverrideState
 *      Status of the led to be set.
 *  
 *   @return   Error code
 *   
 *   @ingroup EVM_GPIO
 *
 ***************************************************************************/ 
Int32 EVM_LED_overridebicolorled(int iOverrideState);



#ifdef __cplusplus
}
#endif //__cplusplus 
#endif //__EVM_LED_H__

