/*  ============================================================================
 *  Copyright (c) Texas Instruments Inc 2002 - 2008
 *
 *  Use of this software is controlled by the terms and conditions found in the
 *  license agreement under which this software has been supplied.
 *  ============================================================================
 */
/** ============================================================================
 *   @file  csl_version.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the version number of different chips
 *
 */
/* =============================================================================
 *  Revision History
 *  ===============
 *  30-March-2009 CH First version to support  new chip c6457
 * =============================================================================
 */

#ifndef _CSL_VERSION_H_
#define _CSL_VERSION_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <tistdtypes.h>

/* 0xAABBCCDD -> Arch (AA); API Changes (BB); Major (CC); Minor (DD) */
#define CSL_VERSION_ID          (0x03040101)    
#define CSL_VERSION_STR         "@(#) CSL Revision: 03.04.01.01;"

#ifdef c6457
#define CSL_CHIP_ID             (0x6457)
#define CSL_CHIP_STR            "TMS320C6457 PG 1.0 (C6457)"
#endif

#ifdef c64xplus_intc
#define CSL_CHIP_ID             (0x64A)
#define CSL_CHIP_STR            "C64X PLUS"
#endif

/**
  @brief    Retrieves the version ID
*/
Uint32 CSL_versionGetID (
    void
);


/**
  @brief    Retrieves the version string
*/
const char *
    CSL_versionGetStr (
        void
);


#ifdef __cplusplus
}
#endif

#endif /* _CSL_VERSION_H_ */

