/* ===============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006, 2007, 2008
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 * ===============================================================================
 */
/** ==============================================================================
 *   @file  cslr_adtf2.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for DTF
 * ===============================================================================
 */

#ifndef _CSLR_ADTF2_H_
#define _CSLR_ADTF2_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/

typedef struct  {
    volatile Uint32 ADTFCSR;
    volatile Uint8 RSVD0[1020];
    volatile Uint32 ADTFTID;
    volatile Uint8 RSVD1[2804];
    volatile Uint32 INTOR;
    volatile Uint32 INTIR;
    volatile Uint32 INTCR;
    volatile Uint8 RSVD2[156];
    volatile Uint32 CTSR;
    volatile Uint32 CTCR;
    volatile Uint8 RSVD3[8];
    volatile Uint32 LAR;
    volatile Uint32 LSR;
    volatile Uint32 ASR;
    volatile Uint8 RSVD4[12];
    volatile Uint32 DCR;
    volatile Uint32 DTIR;
    volatile Uint32 PID4;
    volatile Uint8 RSVD5[12];
    volatile Uint32 PID0;
    volatile Uint32 PID1;
    volatile Uint32 PID2;
    volatile Uint32 PID3;
    volatile Uint32 CID0;
    volatile Uint32 CID1;
    volatile Uint32 CID2;
    volatile Uint32 CID3;
} CSL_Adtf2Regs;


/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_Adtf2Regs  *CSL_Adtf2RegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* ADTFCSR */


#define CSL_ADTF2_ADTFCSR_FLUSHTRACE_MASK (0x00000080u)
#define CSL_ADTF2_ADTFCSR_FLUSHTRACE_SHIFT (0x00000007u)
#define CSL_ADTF2_ADTFCSR_FLUSHTRACE_RESETVAL (0x00000000u)
/*----FLUSHTRACE Tokens----*/
#define CSL_ADTF2_ADTFCSR_FLUSHTRACE_FLUSH_TRACE (0x00000001u)

#define CSL_ADTF2_ADTFCSR_RESETTRACE_MASK (0x00000040u)
#define CSL_ADTF2_ADTFCSR_RESETTRACE_SHIFT (0x00000006u)
#define CSL_ADTF2_ADTFCSR_RESETTRACE_RESETVAL (0x00000000u)
/*----RESETTRACE Tokens----*/
#define CSL_ADTF2_ADTFCSR_RESETTRACE_RESET (0x00000001u)

#define CSL_ADTF2_ADTFCSR_INPUTWIDTH_MASK (0x00000020u)
#define CSL_ADTF2_ADTFCSR_INPUTWIDTH_SHIFT (0x00000005u)
#define CSL_ADTF2_ADTFCSR_INPUTWIDTH_RESETVAL (0x00000000u)
/*----INPUTWIDTH Tokens----*/
#define CSL_ADTF2_ADTFCSR_INPUTWIDTH_PORT_WIDTH_20 (0x00000001u)
#define CSL_ADTF2_ADTFCSR_INPUTWIDTH_PORT_WIDTH_10 (0x00000000u)

#define CSL_ADTF2_ADTFCSR_OVERFLOW_MASK (0x00000010u)
#define CSL_ADTF2_ADTFCSR_OVERFLOW_SHIFT (0x00000004u)
#define CSL_ADTF2_ADTFCSR_OVERFLOW_RESETVAL (0x00000000u)
/*----OVERFLOW Tokens----*/
#define CSL_ADTF2_ADTFCSR_OVERFLOW_CLEAR (0x00000001u)

#define CSL_ADTF2_ADTFCSR_TRIGGEREN_MASK (0x00000008u)
#define CSL_ADTF2_ADTFCSR_TRIGGEREN_SHIFT (0x00000003u)
#define CSL_ADTF2_ADTFCSR_TRIGGEREN_RESETVAL (0x00000000u)
/*----TRIGGEREN Tokens----*/
#define CSL_ADTF2_ADTFCSR_TRIGGEREN_TRIGGER (0x00000001u)
#define CSL_ADTF2_ADTFCSR_TRIGGEREN_NO_TRIGGER (0x00000000u)

#define CSL_ADTF2_ADTFCSR_MULTIPACKET_MASK (0x00000004u)
#define CSL_ADTF2_ADTFCSR_MULTIPACKET_SHIFT (0x00000002u)
#define CSL_ADTF2_ADTFCSR_MULTIPACKET_RESETVAL (0x00000001u)
/*----MULTIPACKET Tokens----*/
#define CSL_ADTF2_ADTFCSR_MULTIPACKET_3_TRACE_PACKETS (0x00000001u)
#define CSL_ADTF2_ADTFCSR_MULTIPACKET_1_TRACE_PACKET (0x00000000u)

#define CSL_ADTF2_ADTFCSR_NOP_DISCARD_MASK (0x00000002u)
#define CSL_ADTF2_ADTFCSR_NOP_DISCARD_SHIFT (0x00000001u)
#define CSL_ADTF2_ADTFCSR_NOP_DISCARD_RESETVAL (0x00000001u)
/*----NOP_DISCARD Tokens----*/
#define CSL_ADTF2_ADTFCSR_NOP_DISCARD_REMOVE_NOPS (0x00000001u)
#define CSL_ADTF2_ADTFCSR_NOP_DISCARD_DONT_REMOVE_NOPS (0x00000000u)

#define CSL_ADTF2_ADTFCSR_ADTFEN_MASK (0x00000001u)
#define CSL_ADTF2_ADTFCSR_ADTFEN_SHIFT (0x00000000u)
#define CSL_ADTF2_ADTFCSR_ADTFEN_RESETVAL (0x00000000u)
/*----ADTFEN Tokens----*/
#define CSL_ADTF2_ADTFCSR_ADTFEN_ADFT2_FUNCTIONAL (0x00000001u)
#define CSL_ADTF2_ADTFCSR_ADTFEN_DISABLED (0x00000000u)

#define CSL_ADTF2_ADTFCSR_RESETVAL (0x00000006u)

/* ADTFTID */


#define CSL_ADTF2_ADTFTID_ATID_MASK (0x0000007Fu)
#define CSL_ADTF2_ADTFTID_ATID_SHIFT (0x00000000u)
#define CSL_ADTF2_ADTFTID_ATID_RESETVAL (0x00000060u)

#define CSL_ADTF2_ADTFTID_RESETVAL (0x00000060u)

/* INTOR */


#define CSL_ADTF2_INTOR_NUMOUTPUTS_MASK (0x0FFF0000u)
#define CSL_ADTF2_INTOR_NUMOUTPUTS_SHIFT (0x00000010u)
#define CSL_ADTF2_INTOR_NUMOUTPUTS_RESETVAL (0x000001FFu)


#define CSL_ADTF2_INTOR_INTEGEN_MASK (0x00001000u)
#define CSL_ADTF2_INTOR_INTEGEN_SHIFT (0x0000000Cu)
#define CSL_ADTF2_INTOR_INTEGEN_RESETVAL (0x00000000u)
/*----INTEGEN Tokens----*/
#define CSL_ADTF2_INTOR_INTEGEN_ENABLE (0x00000001u)
#define CSL_ADTF2_INTOR_INTEGEN_DISABLE (0x00000000u)

#define CSL_ADTF2_INTOR_OUTBIT_SELECT_MASK (0x00000FFFu)
#define CSL_ADTF2_INTOR_OUTBIT_SELECT_SHIFT (0x00000000u)
#define CSL_ADTF2_INTOR_OUTBIT_SELECT_RESETVAL (0x00000000u)

#define CSL_ADTF2_INTOR_RESETVAL (0x01FF0000u)

/* INTIR */


#define CSL_ADTF2_INTIR_NUMINPUTS_MASK (0x0FFF0000u)
#define CSL_ADTF2_INTIR_NUMINPUTS_SHIFT (0x00000010u)
#define CSL_ADTF2_INTIR_NUMINPUTS_RESETVAL (0x000001FFu)


#define CSL_ADTF2_INTIR_VALUE_MASK (0x00001000u)
#define CSL_ADTF2_INTIR_VALUE_SHIFT (0x0000000Cu)
#define CSL_ADTF2_INTIR_VALUE_RESETVAL (0x00000000u)

#define CSL_ADTF2_INTIR_INBIT_SELECT_MASK (0x00000FFFu)
#define CSL_ADTF2_INTIR_INBIT_SELECT_SHIFT (0x00000000u)
#define CSL_ADTF2_INTIR_INBIT_SELECT_RESETVAL (0x00000000u)

#define CSL_ADTF2_INTIR_RESETVAL (0x01FF0000u)

/* INTCR */


#define CSL_ADTF2_INTCR_ITM_MASK (0x00000001u)
#define CSL_ADTF2_INTCR_ITM_SHIFT (0x00000000u)
#define CSL_ADTF2_INTCR_ITM_RESETVAL (0x00000000u)
/*----ITM Tokens----*/
#define CSL_ADTF2_INTCR_ITM_ENABLE (0x00000001u)
#define CSL_ADTF2_INTCR_ITM_DISABLE (0x00000000u)

#define CSL_ADTF2_INTCR_RESETVAL (0x00000000u)

/* CTSR */


#define CSL_ADTF2_CTSR_CLAIM_TAG_SET_MASK (0x00000001u)
#define CSL_ADTF2_CTSR_CLAIM_TAG_SET_SHIFT (0x00000000u)
#define CSL_ADTF2_CTSR_CLAIM_TAG_SET_RESETVAL (0x00000001u)
/*----CLAIM_TAG_SET Tokens----*/
#define CSL_ADTF2_CTSR_CLAIM_TAG_SET_SETCTV (0x00000001u)

#define CSL_ADTF2_CTSR_RESETVAL (0x00000001u)

/* CTCR */


#define CSL_ADTF2_CTCR_CLAIM_TAG_CLEAR_MASK (0x00000001u)
#define CSL_ADTF2_CTCR_CLAIM_TAG_CLEAR_SHIFT (0x00000000u)
#define CSL_ADTF2_CTCR_CLAIM_TAG_CLEAR_RESETVAL (0x00000000u)
/*----CLAIM_TAG_CLEAR Tokens----*/
#define CSL_ADTF2_CTCR_CLAIM_TAG_CLEAR_CLEARCTV (0x00000001u)

#define CSL_ADTF2_CTCR_RESETVAL (0x00000000u)

/* LAR */

#define CSL_ADTF2_LAR_WRITE_ACCESS_CODE_MASK (0xFFFFFFFFu)
#define CSL_ADTF2_LAR_WRITE_ACCESS_CODE_SHIFT (0x00000000u)
#define CSL_ADTF2_LAR_WRITE_ACCESS_CODE_RESETVAL (0x00000000u)
/*----WRITE_ACCESS_CODE Tokens----*/
#define CSL_ADTF2_LAR_WRITE_ACCESS_CODE_ENABLE (0xC5ACCE55u)

#define CSL_ADTF2_LAR_RESETVAL (0x00000000u)

/* LSR */


#define CSL_ADTF2_LSR_8_BIT_LOCK_MASK (0x00000004u)
#define CSL_ADTF2_LSR_8_BIT_LOCK_SHIFT (0x00000002u)
#define CSL_ADTF2_LSR_8_BIT_LOCK_RESETVAL (0x00000000u)
/*----8_BIT_LOCK Tokens----*/
#define CSL_ADTF2_LSR_8_BIT_LOCK_8_BIT (0x00000001u)
#define CSL_ADTF2_LSR_8_BIT_LOCK_32_BIT (0x00000000u)

#define CSL_ADTF2_LSR_LOCK_STATUS_MASK (0x00000002u)
#define CSL_ADTF2_LSR_LOCK_STATUS_SHIFT (0x00000001u)
#define CSL_ADTF2_LSR_LOCK_STATUS_RESETVAL (0x00000001u)
/*----LOCK_STATUS Tokens----*/
#define CSL_ADTF2_LSR_LOCK_STATUS_LOCKED (0x00000001u)
#define CSL_ADTF2_LSR_LOCK_STATUS_UNLOCKED (0x00000000u)

#define CSL_ADTF2_LSR_LOCK_IMPLEMENTED_MASK (0x00000001u)
#define CSL_ADTF2_LSR_LOCK_IMPLEMENTED_SHIFT (0x00000000u)
#define CSL_ADTF2_LSR_LOCK_IMPLEMENTED_RESETVAL (0x00000001u)
/*----LOCK_IMPLEMENTED Tokens----*/
#define CSL_ADTF2_LSR_LOCK_IMPLEMENTED_NO_LOCK (0x00000000u)
#define CSL_ADTF2_LSR_LOCK_IMPLEMENTED_LOCK_MECH (0x00000001u)

#define CSL_ADTF2_LSR_RESETVAL (0x00000003u)

/* ASR */


#define CSL_ADTF2_ASR_SEC_NI_DEBUG_STATUS_MASK (0x000000C0u)
#define CSL_ADTF2_ASR_SEC_NI_DEBUG_STATUS_SHIFT (0x00000006u)
#define CSL_ADTF2_ASR_SEC_NI_DEBUG_STATUS_RESETVAL (0x00000000u)

#define CSL_ADTF2_ASR_SEC_I_DEBUG_STATUS_MASK (0x00000030u)
#define CSL_ADTF2_ASR_SEC_I_DEBUG_STATUS_SHIFT (0x00000004u)
#define CSL_ADTF2_ASR_SEC_I_DEBUG_STATUS_RESETVAL (0x00000000u)

#define CSL_ADTF2_ASR_NON_SEC_NI_DEBUG_STATUS_MASK (0x0000000Cu)
#define CSL_ADTF2_ASR_NON_SEC_NI_DEBUG_STATUS_SHIFT (0x00000002u)
#define CSL_ADTF2_ASR_NON_SEC_NI_DEBUG_STATUS_RESETVAL (0x00000000u)

#define CSL_ADTF2_ASR_NON_SEC_I_DEBUG_STATUS_MASK (0x00000003u)
#define CSL_ADTF2_ASR_NON_SEC_I_DEBUG_STATUS_SHIFT (0x00000000u)
#define CSL_ADTF2_ASR_NON_SEC_I_DEBUG_STATUS_RESETVAL (0x00000000u)

#define CSL_ADTF2_ASR_RESETVAL (0x00000000u)

/* DCR */


#define CSL_ADTF2_DCR_MAJOR_REV_MASK (0x000000F0u)
#define CSL_ADTF2_DCR_MAJOR_REV_SHIFT (0x00000004u)
#define CSL_ADTF2_DCR_MAJOR_REV_RESETVAL (0x00000002u)

#define CSL_ADTF2_DCR_MINOR_REV_MASK (0x0000000Fu)
#define CSL_ADTF2_DCR_MINOR_REV_SHIFT (0x00000000u)
#define CSL_ADTF2_DCR_MINOR_REV_RESETVAL (0x00000000u)

#define CSL_ADTF2_DCR_RESETVAL (0x00000020u)

/* DTIR */


#define CSL_ADTF2_DTIR_SUB_TYPE_MASK (0x000000F0u)
#define CSL_ADTF2_DTIR_SUB_TYPE_SHIFT (0x00000004u)
#define CSL_ADTF2_DTIR_SUB_TYPE_RESETVAL (0x00000002u)

#define CSL_ADTF2_DTIR_MAIN_CLASS_MASK (0x0000000Fu)
#define CSL_ADTF2_DTIR_MAIN_CLASS_SHIFT (0x00000000u)
#define CSL_ADTF2_DTIR_MAIN_CLASS_RESETVAL (0x00000003u)

#define CSL_ADTF2_DTIR_RESETVAL (0x00000023u)

/* PID4 */


#define CSL_ADTF2_PID4_PID4_JEP106CC_MASK (0x0000000Fu)
#define CSL_ADTF2_PID4_PID4_JEP106CC_SHIFT (0x00000000u)
#define CSL_ADTF2_PID4_PID4_JEP106CC_RESETVAL (0x00000000u)

#define CSL_ADTF2_PID4_RESETVAL (0x00000000u)

/* PID0 */


#define CSL_ADTF2_PID0_PID0_MASK (0x000000FFu)
#define CSL_ADTF2_PID0_PID0_SHIFT (0x00000000u)
#define CSL_ADTF2_PID0_PID0_RESETVAL (0x000000DFu)

#define CSL_ADTF2_PID0_RESETVAL (0x000000DFu)

/* PID1 */


#define CSL_ADTF2_PID1_PID1_JEP106IC_MASK (0x000000F0u)
#define CSL_ADTF2_PID1_PID1_JEP106IC_SHIFT (0x00000004u)
#define CSL_ADTF2_PID1_PID1_JEP106IC_RESETVAL (0x00000007u)

#define CSL_ADTF2_PID1_PID1_PN1_MASK (0x0000000Fu)
#define CSL_ADTF2_PID1_PID1_PN1_SHIFT (0x00000000u)
#define CSL_ADTF2_PID1_PID1_PN1_RESETVAL (0x0000000Au)

#define CSL_ADTF2_PID1_RESETVAL (0x0000007Au)

/* PID2 */


#define CSL_ADTF2_PID2_PID2_REV_MASK (0x000000F0u)
#define CSL_ADTF2_PID2_PID2_REV_SHIFT (0x00000004u)
#define CSL_ADTF2_PID2_PID2_REV_RESETVAL (0x00000000u)

#define CSL_ADTF2_PID2_PID2_JEDEC_MASK (0x00000008u)
#define CSL_ADTF2_PID2_PID2_JEDEC_SHIFT (0x00000003u)
#define CSL_ADTF2_PID2_PID2_JEDEC_RESETVAL (0x00000001u)

#define CSL_ADTF2_PID2_PID2_JEP106IC_MASK (0x00000007u)
#define CSL_ADTF2_PID2_PID2_JEP106IC_SHIFT (0x00000000u)
#define CSL_ADTF2_PID2_PID2_JEP106IC_RESETVAL (0x00000001u)

#define CSL_ADTF2_PID2_RESETVAL (0x00000009u)

/* PID3 */


#define CSL_ADTF2_PID3_PID3_REVAND_MASK (0x000000F0u)
#define CSL_ADTF2_PID3_PID3_REVAND_SHIFT (0x00000004u)
#define CSL_ADTF2_PID3_PID3_REVAND_RESETVAL (0x00000000u)

#define CSL_ADTF2_PID3_PID3_CUSTOM_MASK (0x0000000Fu)
#define CSL_ADTF2_PID3_PID3_CUSTOM_SHIFT (0x00000000u)
#define CSL_ADTF2_PID3_PID3_CUSTOM_RESETVAL (0x00000000u)

#define CSL_ADTF2_PID3_RESETVAL (0x00000000u)

/* CID0 */


#define CSL_ADTF2_CID0_CID0_MASK (0x000000FFu)
#define CSL_ADTF2_CID0_CID0_SHIFT (0x00000000u)
#define CSL_ADTF2_CID0_CID0_RESETVAL (0x0000000Du)

#define CSL_ADTF2_CID0_RESETVAL (0x0000000Du)

/* CID1 */


#define CSL_ADTF2_CID1_CID1_MASK (0x000000FFu)
#define CSL_ADTF2_CID1_CID1_SHIFT (0x00000000u)
#define CSL_ADTF2_CID1_CID1_RESETVAL (0x00000090u)

#define CSL_ADTF2_CID1_RESETVAL (0x00000090u)

/* CID2 */


#define CSL_ADTF2_CID2_CID2_MASK (0x000000FFu)
#define CSL_ADTF2_CID2_CID2_SHIFT (0x00000000u)
#define CSL_ADTF2_CID2_CID2_RESETVAL (0x00000005u)

#define CSL_ADTF2_CID2_RESETVAL (0x00000005u)

/* CID3 */


#define CSL_ADTF2_CID3_CID3_MASK (0x000000FFu)
#define CSL_ADTF2_CID3_CID3_SHIFT (0x00000000u)
#define CSL_ADTF2_CID3_CID3_RESETVAL (0x000000B1u)

#define CSL_ADTF2_CID3_RESETVAL (0x000000B1u)

#endif
