/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_bwmngmt.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for BWMNGMT
 *  ============================================================================
 */
#ifndef _CSLR_BWMNGMT_H_
#define _CSLR_BWMNGMT_H_

#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 CPUARBE;
    volatile Uint32 IDMAARBE;
    volatile Uint32 SDMAARBE;
    volatile Uint32 MDMAARBE;
    volatile Uint8 RSVD0[134640];
    volatile Uint32 CPUARBU;
    volatile Uint32 IDMAARBU;
    volatile Uint32 SDMAARBU;
    volatile Uint32 UCARBU;
    volatile Uint8 RSVD1[48];
    volatile Uint32 CPUARBD;
    volatile Uint32 IDMAARBD;
    volatile Uint32 SDMAARBD;
    volatile Uint32 UCARBD;
} CSL_BwmngmtRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_BwmngmtRegs         *CSL_BwmngmtRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* CPUARBE */


#define CSL_BWMNGMT_CPUARBE_PRI_MASK (0x00070000u)
#define CSL_BWMNGMT_CPUARBE_PRI_SHIFT (0x00000010u)
#define CSL_BWMNGMT_CPUARBE_PRI_RESETVAL (0x00000001u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI0 (0x00000000u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI1 (0x00000001u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI2 (0x00000002u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI3 (0x00000003u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI4 (0x00000004u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI5 (0x00000005u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI6 (0x00000006u)
#define CSL_BWMNGMT_CPUARBE_PRI_PRI7 (0x00000007u)


#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_RESETVAL (0x00000010u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_CPUARBE_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_CPUARBE_RESETVAL (0x00010010u)

/* IDMAARBE */


#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_RESETVAL (0x00000010u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_IDMAARBE_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_IDMAARBE_RESETVAL (0x00000010u)

/* SDMAARBE */


#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_RESETVAL (0x00000001u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_SDMAARBE_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_SDMAARBE_RESETVAL (0x00000001u)

/* MDMAARBE */


#define CSL_BWMNGMT_MDMAARBE_PRI_MASK (0x00070000u)
#define CSL_BWMNGMT_MDMAARBE_PRI_SHIFT (0x00000010u)
#define CSL_BWMNGMT_MDMAARBE_PRI_RESETVAL (0x00000007u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI0 (0x00000000u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI1 (0x00000001u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI2 (0x00000002u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI3 (0x00000003u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI4 (0x00000004u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI5 (0x00000005u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI6 (0x00000006u)
#define CSL_BWMNGMT_MDMAARBE_PRI_PRI7 (0x00000007u)


#define CSL_BWMNGMT_MDMAARBE_RESETVAL (0x00070000u)

/* CPUARBU */


#define CSL_BWMNGMT_CPUARBU_PRI_MASK (0x00070000u)
#define CSL_BWMNGMT_CPUARBU_PRI_SHIFT (0x00000010u)
#define CSL_BWMNGMT_CPUARBU_PRI_RESETVAL (0x00000001u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI0 (0x00000000u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI1 (0x00000001u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI2 (0x00000002u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI3 (0x00000003u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI4 (0x00000004u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI5 (0x00000005u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI6 (0x00000006u)
#define CSL_BWMNGMT_CPUARBU_PRI_PRI7 (0x00000007u)


#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_RESETVAL (0x00000010u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_CPUARBU_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_CPUARBU_RESETVAL (0x00010010u)

/* IDMAARBU */


#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_RESETVAL (0x00000010u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_IDMAARBU_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_IDMAARBU_RESETVAL (0x00000010u)

/* SDMAARBU */


#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_RESETVAL (0x00000001u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_SDMAARBU_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_SDMAARBU_RESETVAL (0x00000001u)

/* UCARBU */


#define CSL_BWMNGMT_UCARBU_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_RESETVAL (0x00000020u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_UCARBU_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_UCARBU_RESETVAL (0x00000020u)

/* CPUARBD */


#define CSL_BWMNGMT_CPUARBD_PRI_MASK (0x00070000u)
#define CSL_BWMNGMT_CPUARBD_PRI_SHIFT (0x00000010u)
#define CSL_BWMNGMT_CPUARBD_PRI_RESETVAL (0x00000001u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI0 (0x00000000u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI1 (0x00000001u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI2 (0x00000002u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI3 (0x00000003u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI4 (0x00000004u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI5 (0x00000005u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI6 (0x00000006u)
#define CSL_BWMNGMT_CPUARBD_PRI_PRI7 (0x00000007u)


#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_RESETVAL (0x00000010u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_CPUARBD_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_CPUARBD_RESETVAL (0x00010010u)

/* IDMAARBD */


#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_RESETVAL (0x00000010u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_IDMAARBD_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_IDMAARBD_RESETVAL (0x00000010u)

/* SDMAARBD */


#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_RESETVAL (0x00000001u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_SDMAARBD_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_SDMAARBD_RESETVAL (0x00000001u)

/* UCARBD */


#define CSL_BWMNGMT_UCARBD_MAXWAIT_MASK (0x0000003Fu)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_SHIFT (0x00000000u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_RESETVAL (0x00000020u)
/*----MAXWAIT Tokens----*/
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT0 (0x00000000u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT1 (0x00000001u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT2 (0x00000002u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT4 (0x00000004u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT8 (0x00000008u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT16 (0x00000010u)
#define CSL_BWMNGMT_UCARBD_MAXWAIT_MAXWAIT32 (0x00000020u)

#define CSL_BWMNGMT_UCARBD_RESETVAL (0x00000020u)

#endif
