/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2008
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_dev.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for DEV
 */
#ifndef _CSLR_DEV_H_
#define _CSLR_DEV_H_

#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[2072];
    volatile Uint32 DEVID;
    volatile Uint8 RSVD1[4];
    volatile Uint32 DEVSTAT;
    volatile Uint8 RSVD2[20];
    volatile Uint32 KICK0;
    volatile Uint32 KICK1;
    volatile Uint32 DSP_BOOT_ADDR;
    volatile Uint8 RSVD3[204];
    volatile Uint32 DEVCFG;
    volatile Uint8 RSVD4[8];
    volatile Uint32 PRI_ALLOC;
    volatile Uint32 WDRSTSEL;
} CSL_DevRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DEVID */

#define CSL_DEV_DEVID_VARIANT_MASK (0xF0000000u)
#define CSL_DEV_DEVID_VARIANT_SHIFT (0x0000001Cu)
#define CSL_DEV_DEVID_VARIANT_RESETVAL (0x00000000u)

#define CSL_DEV_DEVID_PARTNUMBER_MASK (0x0FFFF000u)
#define CSL_DEV_DEVID_PARTNUMBER_SHIFT (0x0000000Cu)
#define CSL_DEV_DEVID_PARTNUMBER_RESETVAL (0x00000096u)

#define CSL_DEV_DEVID_MANUFACTURER_MASK (0x00000FFEu)
#define CSL_DEV_DEVID_MANUFACTURER_SHIFT (0x00000001u)
#define CSL_DEV_DEVID_MANUFACTURER_RESETVAL (0x00000017u)

#define CSL_DEV_DEVID_LSB_MASK (0x00000001u)
#define CSL_DEV_DEVID_LSB_SHIFT (0x00000000u)
#define CSL_DEV_DEVID_LSB_RESETVAL (0x00000001u)

#define CSL_DEV_DEVID_RESETVAL (0x0009602Fu)

/* DEVSTAT */

#define CSL_DEV_DEVSTAT_ECLKINSEL_MASK (0x00008000u)
#define CSL_DEV_DEVSTAT_ECLKINSEL_SHIFT (0x0000000Fu)
#define CSL_DEV_DEVSTAT_ECLKINSEL_RESETVAL (0x00000000u)
/*----ECLKINSEL Tokens----*/
#define CSL_DEV_DEVSTAT_ECLKINSEL_ECLKIN (0x00000000u)
#define CSL_DEV_DEVSTAT_ECLKINSEL_SYSCLK7 (0x00000001u)

#define CSL_DEV_DEVSTAT_HPIWIDTH_MASK (0x00004000u)
#define CSL_DEV_DEVSTAT_HPIWIDTH_SHIFT (0x0000000Eu)
#define CSL_DEV_DEVSTAT_HPIWIDTH_RESETVAL (0x00000000u)
/*----HPIWIDTH Tokens----*/
#define CSL_DEV_DEVSTAT_HPIWIDTH_16BIT (0x00000000u)
#define CSL_DEV_DEVSTAT_HPIWIDTH_32BIT (0x00000001u)

#define CSL_DEV_DEVSTAT_CFGGP_MASK (0x00003E00u)
#define CSL_DEV_DEVSTAT_CFGGP_SHIFT (0x00000009u)
#define CSL_DEV_DEVSTAT_CFGGP_RESETVAL (0x00000000u)

#define CSL_DEV_DEVSTAT_DEVNUM_MASK (0x000001E0u)
#define CSL_DEV_DEVSTAT_DEVNUM_SHIFT (0x00000005u)
#define CSL_DEV_DEVSTAT_DEVNUM_RESETVAL (0x00000000u)

#define CSL_DEV_DEVSTAT_BOOTMODE_MASK (0x0000001Eu)
#define CSL_DEV_DEVSTAT_BOOTMODE_SHIFT (0x00000001u)
#define CSL_DEV_DEVSTAT_BOOTMODE_RESETVAL (0x00000000u)
/*----BOOTMODE Tokens----*/
#define CSL_DEV_DEVSTAT_BOOTMODE_NONE (0x00000000u)
#define CSL_DEV_DEVSTAT_BOOTMODE_I2C_MASTER1 (0x00000001u)
#define CSL_DEV_DEVSTAT_BOOTMODE_I2C_MASTER2 (0x00000002u)
#define CSL_DEV_DEVSTAT_BOOTMODE_I2C_SLAVE (0x00000003u)
#define CSL_DEV_DEVSTAT_BOOTMODE_HPI (0x00000004u)
#define CSL_DEV_DEVSTAT_BOOTMODE_EMIFA (0x00000005u)
#define CSL_DEV_DEVSTAT_BOOTMODE_EMAC_MASTER (0x00000006u)
#define CSL_DEV_DEVSTAT_BOOTMODE_EMAC_SLAVE (0x00000007u)
#define CSL_DEV_DEVSTAT_BOOTMODE_EMAC_FORCED (0x00000008u)
#define CSL_DEV_DEVSTAT_BOOTMODE_RAPIDIO1 (0x0000000Au)
#define CSL_DEV_DEVSTAT_BOOTMODE_RAPIDIO2 (0x0000000Bu)
#define CSL_DEV_DEVSTAT_BOOTMODE_RAPIDIO3 (0x0000000Cu)
#define CSL_DEV_DEVSTAT_BOOTMODE_RAPIDIO4 (0x0000000Du)

#define CSL_DEV_DEVSTAT_LENDIAN_MASK (0x00000001u)
#define CSL_DEV_DEVSTAT_LENDIAN_SHIFT (0x00000000u)
#define CSL_DEV_DEVSTAT_LENDIAN_RESETVAL (0x00000001u)
/*----LENDIAN Tokens----*/
#define CSL_DEV_DEVSTAT_LENDIAN_BE (0x00000000u)
#define CSL_DEV_DEVSTAT_LENDIAN_LE (0x00000001u)

#define CSL_DEV_DEVSTAT_RESETVAL (0x00000001u)

/* KICK0 */

#define CSL_DEV_KICK0_KICK0_MASK (0xFFFFFFFFu)
#define CSL_DEV_KICK0_KICK0_SHIFT (0x00000000u)
#define CSL_DEV_KICK0_KICK0_RESETVAL (0x00000000u)

#define CSL_DEV_KICK0_RESETVAL (0x00000000u)

/* KICK1 */

#define CSL_DEV_KICK1_KICK1_MASK (0xFFFFFFFFu)
#define CSL_DEV_KICK1_KICK1_SHIFT (0x00000000u)
#define CSL_DEV_KICK1_KICK1_RESETVAL (0x00000000u)

#define CSL_DEV_KICK1_RESETVAL (0x00000000u)

/* DSP_BOOT_ADDR */

#define CSL_DEV_DSP_BOOT_ADDR_ISTP_RST_VAL_MASK (0xFFFFFC00u)
#define CSL_DEV_DSP_BOOT_ADDR_ISTP_RST_VAL_SHIFT (0x0000000Au)
#define CSL_DEV_DSP_BOOT_ADDR_ISTP_RST_VAL_RESETVAL (0x00000000u)


#define CSL_DEV_DSP_BOOT_ADDR_GEM_BOOT_RDY_MASK (0x00000001u)
#define CSL_DEV_DSP_BOOT_ADDR_GEM_BOOT_RDY_SHIFT (0x00000000u)
#define CSL_DEV_DSP_BOOT_ADDR_GEM_BOOT_RDY_RESETVAL (0x00000000u)

#define CSL_DEV_DSP_BOOT_ADDR_RESETVAL (0x00000000u)

/* DEVCFG */

#define CSL_DEV_DEVCFG_CLKS1_MASK (0x00000004u)
#define CSL_DEV_DEVCFG_CLKS1_SHIFT (0x00000002u)
#define CSL_DEV_DEVCFG_CLKS1_RESETVAL (0x00000000u)
/*----CLKS1 Tokens----*/
#define CSL_DEV_DEVCFG_CLKS1_CLKS1 (0x00000000u)
#define CSL_DEV_DEVCFG_CLKS1_CHIP_CLKS (0x00000001u)

#define CSL_DEV_DEVCFG_CLKS0_MASK (0x00000002u)
#define CSL_DEV_DEVCFG_CLKS0_SHIFT (0x00000001u)
#define CSL_DEV_DEVCFG_CLKS0_RESETVAL (0x00000000u)
/*----CLKS0 Tokens----*/
#define CSL_DEV_DEVCFG_CLKS0_CLKS0 (0x00000000u)
#define CSL_DEV_DEVCFG_CLKS0_CHIP_CLKS (0x00000001u)

#define CSL_DEV_DEVCFG_SYSCLKOUTEN_MASK (0x00000001u)
#define CSL_DEV_DEVCFG_SYSCLKOUTEN_SHIFT (0x00000000u)
#define CSL_DEV_DEVCFG_SYSCLKOUTEN_RESETVAL (0x00000001u)
/*----SYSCLKOUTEN Tokens----*/
#define CSL_DEV_DEVCFG_SYSCLKOUTEN_DISABLED (0x00000000u)
#define CSL_DEV_DEVCFG_SYSCLKOUTEN_ENABLED (0x00000001u)

#define CSL_DEV_DEVCFG_RESETVAL (0x00000001u)

/* PRI_ALLOC */

#define CSL_DEV_PRI_ALLOC_UHPI_MASK (0x000001C0u)
#define CSL_DEV_PRI_ALLOC_UHPI_SHIFT (0x00000006u)
#define CSL_DEV_PRI_ALLOC_UHPI_RESETVAL (0x00000002u)

#define CSL_DEV_PRI_ALLOC_RAPDIO_MASK (0x00000038u)
#define CSL_DEV_PRI_ALLOC_RAPDIO_SHIFT (0x00000003u)
#define CSL_DEV_PRI_ALLOC_RAPDIO_RESETVAL (0x00000001u)

#define CSL_DEV_PRI_ALLOC_EMAC_MASK (0x00000007u)
#define CSL_DEV_PRI_ALLOC_EMAC_SHIFT (0x00000000u)
#define CSL_DEV_PRI_ALLOC_EMAC_RESETVAL (0x00000001u)

#define CSL_DEV_PRI_ALLOC_RESETVAL (0x00000089u)

/* WDRSTSEL */

#define CSL_DEV_WDRSTSEL_WDRSTSEL_MASK (0x00000001u)
#define CSL_DEV_WDRSTSEL_WDRSTSEL_SHIFT (0x00000000u)
#define CSL_DEV_WDRSTSEL_WDRSTSEL_RESETVAL (0x00000000u)
/*----WDRSTSEL Tokens----*/
#define CSL_DEV_WDRSTSEL_WDRSTSEL_DISABLED (0x00000000u)
#define CSL_DEV_WDRSTSEL_WDRSTSEL_ENABLED (0x00000001u)

#define CSL_DEV_WDRSTSEL_RESETVAL (0x00000000u)

#endif

