/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2008
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_pllc.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for PLLC
 */
#ifndef _CSLR_PLLC_H_
#define _CSLR_PLLC_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[228];
    volatile Uint32 RSTYPE;
    volatile Uint32 RSTCTRL;
    volatile Uint32 RSTCFG;
    volatile Uint8 RSVD1[16];
    volatile Uint32 PLLCTL;
    volatile Uint8 RSVD2[12];
    volatile Uint32 PLLM;
    volatile Uint8  RSVD3[12];
	volatile Uint32 PLLDIV3;
	volatile Uint8  RSVD4[4];
	volatile Uint32 POSTDIV;
    volatile Uint8  RSVD5[12];
    volatile Uint32 PLLCMD;
    volatile Uint32 PLLSTAT;
    volatile Uint32 ALNCTL;
    volatile Uint32 DCHANGE;
    volatile Uint8  RSVD6[8];
    volatile Uint32 SYSTAT;    
    volatile Uint8  RSVD7[16];
    volatile Uint32 PLLDIV6;
    volatile Uint32 PLLDIV7;
    volatile Uint32 PLLDIV8;
} CSL_PllcRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_PllcRegs             *CSL_PllcRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* RSTYPE */

#define CSL_PLLC_RSTYPE_EMUSRST_MASK		(0x20000000u)
#define CSL_PLLC_RSTYPE_EMUSRST_SHIFT		(0x0000001Du)
#define CSL_PLLC_RSTYPE_EMUSRST_RESETVAL	(0x00000000u)

/*----EMUSRST Tokens----*/
#define CSL_PLLC_RSTYPE_EMUSRST_NO			(0x00000000u)
#define CSL_PLLC_RSTYPE_EMUSRST_YES			(0x00000001u)

#define CSL_PLLC_RSTYPE_EMUHRST_MASK		(0x10000000u)
#define CSL_PLLC_RSTYPE_EMUHRST_SHIFT		(0x0000001Cu)
#define CSL_PLLC_RSTYPE_EMUHRST_RESETVAL	(0x00000000u)

/*----EMUHRST Tokens----*/
#define CSL_PLLC_RSTYPE_EMUHRST_NO			(0x00000000u)
#define CSL_PLLC_RSTYPE_EMUHRST_YES			(0x00000001u)

#define CSL_PLLC_RSTYPE_SRIORST_MASK		(0x00000100u)
#define CSL_PLLC_RSTYPE_SRIORST_SHIFT		(0x00000008u)
#define CSL_PLLC_RSTYPE_SRIORST_RESETVAL	(0x00000000u)

/*----SRIORST Tokens----*/
#define CSL_PLLC_RSTYPE_SRIORST_NO			(0x00000000u)
#define CSL_PLLC_RSTYPE_SRIORST_YES			(0x00000001u)

#define CSL_PLLC_RSTYPE_PLLCTLRST_MASK		(0x00000004u)
#define CSL_PLLC_RSTYPE_PLLCTLRST_SHIFT		(0x00000002u)
#define CSL_PLLC_RSTYPE_PLLCTLRST_RESETVAL	(0x00000000u)

/*----PLLCTLRST Tokens----*/
#define CSL_PLLC_RSTYPE_PLLCTLRST_NO	 (0x00000000u)
#define CSL_PLLC_RSTYPE_PLLCTLRST_YES	 (0x00000001u)

#define CSL_PLLC_RSTYPE_WRST_MASK        (0x00000002u)
#define CSL_PLLC_RSTYPE_WRST_SHIFT       (0x00000001u)
#define CSL_PLLC_RSTYPE_WRST_RESETVAL    (0x00000000u)

/*----WRST Tokens----*/
#define CSL_PLLC_RSTYPE_WRST_NO          (0x00000000u)
#define CSL_PLLC_RSTYPE_WRST_YES         (0x00000001u)

#define CSL_PLLC_RSTYPE_POR_MASK         (0x00000001u)
#define CSL_PLLC_RSTYPE_POR_SHIFT        (0x00000000u)
#define CSL_PLLC_RSTYPE_POR_RESETVAL     (0x00000000u)

/*----POR Tokens----*/
#define CSL_PLLC_RSTYPE_POR_NO           (0x00000000u)
#define CSL_PLLC_RSTYPE_POR_YES          (0x00000001u)

#define CSL_PLLC_RSTYPE_RESETVAL         (0x00000000u)

/* RSTCTRL */

#define CSL_PLLC_RSTCTRL_SWRST_MASK		(0x00010000u)
#define CSL_PLLC_RSTCTRL_SWRST_SHIFT	(0x00000010u)
#define CSL_PLLC_RSTCTRL_SWRST_RESETVAL (0x00000001u)

/*----SWRST Tokens----*/
#define CSL_PLLC_RSTCTRL_SWRST_NO		(0x00000000u)
#define CSL_PLLC_RSTCTRL_SWRST_YES		(0x00000001u)

#define CSL_PLLC_RSTCTRL_KEY_MASK		(0x0000FFFFu)
#define CSL_PLLC_RSTCTRL_KEY_SHIFT		(0x00000000u)
#define CSL_PLLC_RSTCTRL_KEY_RESETVAL	(0x00000003u)

#define CSL_PLLC_RSTCTRL_RESETVAL		(0x00010003u)

/* RSTCFG */

#define CSL_PLLC_RSTCFG_PLLCTLRSTTYPE_MASK		(0x00002000u)
#define CSL_PLLC_RSTCFG_PLLCTLRSTTYPE_SHIFT		(0x0000000Du)
#define CSL_PLLC_RSTCFG_PLLCTLRSTTYPE_RESETVAL	(0x00000000u)

/*----PLLCTLRSTTYPE Tokens----*/
#define CSL_PLLC_RSTCFG_PLLCTLRSTTYPE_NO	 (0x00000000u)
#define CSL_PLLC_RSTCFG_PLLCTLRSTTYPE_YES	 (0x00000001u)


#define CSL_PLLC_RSTCFG_SRIORSTTYPE_MASK	 (0x00000001u)
#define CSL_PLLC_RSTCFG_SRIORSTTYPE_SHIFT	 (0x00000000u)
#define CSL_PLLC_RSTCFG_SRIORSTTYPE_RESETVAL (0x00000000u)

/*----SRIORSTTYPE Tokens----*/
#define CSL_PLLC_RSTCFG_SRIORSTTYPE_NO	 (0x00000000u)
#define CSL_PLLC_RSTCFG_SRIORSTTYPE_YES	 (0x00000001u)

#define CSL_PLLC_RSTCFG_RESETVAL		 (0x00000000u)

/* PLLCTL */
#define CSL_PLLC_PLLCTL_PLLENSRC_MASK      (0x00000020u)
#define CSL_PLLC_PLLCTL_PLLENSRC_SHIFT     (0x00000005u)
#define CSL_PLLC_PLLCTL_PLLENSRC_RESETVAL  (0x00000000u)

/*----PLLENSRC Tokens----*/
#define CSL_PLLC_PLLCTL_PLLENSRC_NO        (0x00000001u)
#define CSL_PLLC_PLLCTL_PLLENSRC_YES       (0x00000000u)

#define CSL_PLLC_PLLCTL_PLLRST_MASK      (0x00000008u)
#define CSL_PLLC_PLLCTL_PLLRST_SHIFT     (0x00000003u)
#define CSL_PLLC_PLLCTL_PLLRST_RESETVAL  (0x00000001u)

/*----PLLRST Tokens----*/
#define CSL_PLLC_PLLCTL_PLLRST_NO        (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLRST_YES       (0x00000001u)

#define CSL_PLLC_PLLCTL_PLLPWRDN_MASK    (0x00000002u)
#define CSL_PLLC_PLLCTL_PLLPWRDN_SHIFT   (0x00000001u)
#define CSL_PLLC_PLLCTL_PLLPWRDN_RESETVAL (0x00000000u)

/*----PLLPWRDN Tokens----*/
#define CSL_PLLC_PLLCTL_PLLPWRDN_NO      (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLPWRDN_YES     (0x00000001u)

#define CSL_PLLC_PLLCTL_PLLEN_MASK       (0x00000001u)
#define CSL_PLLC_PLLCTL_PLLEN_SHIFT      (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLEN_RESETVAL   (0x00000000u)

/*----PLLEN Tokens----*/
#define CSL_PLLC_PLLCTL_PLLEN_BYPASS     (0x00000000u)
#define CSL_PLLC_PLLCTL_PLLEN_PLL        (0x00000001u)

#define CSL_PLLC_PLLCTL_RESETVAL         (0x00000048u)

/* PLLM */

#define CSL_PLLC_PLLM_PLLM_MASK			 (0x0000001Fu)
#define CSL_PLLC_PLLM_PLLM_SHIFT         (0x00000000u)
#define CSL_PLLC_PLLM_PLLM_RESETVAL      (0x00000000u)

#define CSL_PLLC_PLLM_RESETVAL           (0x00000000u)

#define CSL_PLLC_PLLM_PLLM_RATE_1        (0x00000000u)
#define CSL_PLLC_PLLM_PLLM_RATE_15       (0x0000000Eu)
#define CSL_PLLC_PLLM_PLLM_RATE_20       (0x00000013u)
#define CSL_PLLC_PLLM_PLLM_RATE_25       (0x00000018u)
#define CSL_PLLC_PLLM_PLLM_RATE_30       (0x0000001Du)
#define CSL_PLLC_PLLM_PLLM_RATE_32       (0x0000001Fu)

/* POSTDIV */

#define CSL_PLLC_POSTDIV_POSTDEN_MASK      (0x00008000u)
#define CSL_PLLC_POSTDIV_POSTDEN_SHIFT     (0x0000000Fu)
#define CSL_PLLC_POSTDIV_POSTDEN_RESETVAL  (0x00000001u)

/*----PREDEN Tokens----*/
#define CSL_PLLC_POSTDIV_POSTDEN_DISABLE   (0x00000000u)
#define CSL_PLLC_POSTDIV_POSTDEN_ENABLE    (0x00000001u)

#define CSL_PLLC_POSTDIV_RATIO_MASK       (0x0000001Fu)
#define CSL_PLLC_POSTDIV_RATIO_SHIFT      (0x00000000u)
#define CSL_PLLC_POSTDIV_RATIO_RESETVAL   (0x00000002u)

#define CSL_PLLC_POSTDIV_RESETVAL         (0x00008002u)

/* PLLCMD */



#define CSL_PLLC_PLLCMD_GOSET_MASK       (0x00000001u)
#define CSL_PLLC_PLLCMD_GOSET_SHIFT      (0x00000000u)
#define CSL_PLLC_PLLCMD_GOSET_RESETVAL   (0x00000000u)

/*----GOSET Tokens----*/
#define CSL_PLLC_PLLCMD_GOSET_CLRBIT     (0x00000000u)
#define CSL_PLLC_PLLCMD_GOSET_SET        (0x00000001u)

#define CSL_PLLC_PLLCMD_RESETVAL         (0x00000000u)

/* PLLSTAT */

#define CSL_PLLC_PLLSTAT_GOSTAT_MASK     (0x00000001u)
#define CSL_PLLC_PLLSTAT_GOSTAT_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLSTAT_GOSTAT_RESETVAL (0x00000000u)

/*----GOSTAT Tokens----*/
#define CSL_PLLC_PLLSTAT_GOSTAT_NONE     (0x00000000u)
#define CSL_PLLC_PLLSTAT_GOSTAT_INPROG   (0x00000001u)

#define CSL_PLLC_PLLSTAT_RESETVAL        (0x00000000u)

/* ALNCTL */

#define CSL_PLLC_ALNCTL_ALN5_MASK        (0x00000010u)
#define CSL_PLLC_ALNCTL_ALN5_SHIFT       (0x00000004u)
#define CSL_PLLC_ALNCTL_ALN5_RESETVAL    (0x00000001u)

/*----ALN5 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN5_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN5_YES         (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN4_MASK        (0x00000008u)
#define CSL_PLLC_ALNCTL_ALN4_SHIFT       (0x00000003u)
#define CSL_PLLC_ALNCTL_ALN4_RESETVAL    (0x00000001u)

/*----ALN4 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN4_NO          (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN4_YES         (0x00000001u)


#define CSL_PLLC_ALNCTL_RESETVAL         (0x00000019u)

/* DCHANGE */

#define CSL_PLLC_DCHANGE_SYS5_MASK       (0x00000010u)
#define CSL_PLLC_DCHANGE_SYS5_SHIFT      (0x00000004u)
#define CSL_PLLC_DCHANGE_SYS5_RESETVAL   (0x00000000u)

/*----SYS5 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS5_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS5_YES        (0x00000001u)

#define CSL_PLLC_DCHANGE_SYS4_MASK       (0x00000008u)
#define CSL_PLLC_DCHANGE_SYS4_SHIFT      (0x00000003u)
#define CSL_PLLC_DCHANGE_SYS4_RESETVAL   (0x00000000u)

/*----SYS4 Tokens----*/
#define CSL_PLLC_DCHANGE_SYS4_NO         (0x00000000u)
#define CSL_PLLC_DCHANGE_SYS4_YES        (0x00000001u)


#define CSL_PLLC_DCHANGE_RESETVAL        (0x00000000u)

/* SYSTAT */

#define CSL_PLLC_SYSTAT_SYS5ON_MASK      (0x00000010u)
#define CSL_PLLC_SYSTAT_SYS5ON_SHIFT     (0x00000004u)
#define CSL_PLLC_SYSTAT_SYS5ON_RESETVAL  (0x00000001u)

/*----SYS5ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS5ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS5ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS4ON_MASK      (0x00000008u)
#define CSL_PLLC_SYSTAT_SYS4ON_SHIFT     (0x00000003u)
#define CSL_PLLC_SYSTAT_SYS4ON_RESETVAL  (0x00000001u)

/*----SYS4ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS4ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS4ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS3ON_MASK      (0x00000004u)
#define CSL_PLLC_SYSTAT_SYS3ON_SHIFT     (0x00000002u)
#define CSL_PLLC_SYSTAT_SYS3ON_RESETVAL  (0x00000001u)

/*----SYS3ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS3ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS3ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS2ON_MASK      (0x00000002u)
#define CSL_PLLC_SYSTAT_SYS2ON_SHIFT     (0x00000001u)
#define CSL_PLLC_SYSTAT_SYS2ON_RESETVAL  (0x00000001u)

/*----SYS2ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS2ON_OFF       (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS2ON_ON        (0x00000001u)


#define CSL_PLLC_SYSTAT_RESETVAL		 (0x0000001Fu)

/* PLLDIV3 */

#define CSL_PLLC_PLLDIV3_D3EN_MASK		 (0x00008000u)
#define CSL_PLLC_PLLDIV3_D3EN_SHIFT		 (0x0000000Fu)
#define CSL_PLLC_PLLDIV3_D3EN_RESETVAL	 (0x00000001u)

/*----D3EN Tokens----*/
#define CSL_PLLC_PLLDIV3_D3EN_DISABLE	 (0x00000000u)
#define CSL_PLLC_PLLDIV3_D3EN_ENABLE	 (0x00000001u)


#define CSL_PLLC_PLLDIV3_RATIO_MASK		 (0x0000001Fu)
#define CSL_PLLC_PLLDIV3_RATIO_SHIFT	 (0x00000000u)
#define CSL_PLLC_PLLDIV3_RATIO_RESETVAL  (0x00000002u)

#define CSL_PLLC_PLLDIV3_RESETVAL		 (0x00008002u)

/* PLLDIV6 */

#define CSL_PLLC_PLLDIV6_D6EN_MASK		 (0x00008000u)
#define CSL_PLLC_PLLDIV6_D6EN_SHIFT		 (0x0000000Fu)
#define CSL_PLLC_PLLDIV6_D6EN_RESETVAL	 (0x00000001u)

/*----D6EN Tokens----*/
#define CSL_PLLC_PLLDIV6_D6EN_DISABLE	 (0x00000000u)
#define CSL_PLLC_PLLDIV6_D6EN_ENABLE	 (0x00000001u)

#define CSL_PLLC_PLLDIV6_RATIO_MASK		 (0x0000001Fu)
#define CSL_PLLC_PLLDIV6_RATIO_SHIFT	 (0x00000000u)
#define CSL_PLLC_PLLDIV6_RATIO_RESETVAL  (0x00000009u)

#define CSL_PLLC_PLLDIV6_RESETVAL		 (0x00008009u)

/* PLLDIV7 */

#define CSL_PLLC_PLLDIV7_D7EN_MASK		(0x00008000u)
#define CSL_PLLC_PLLDIV7_D7EN_SHIFT		(0x0000000Fu)
#define CSL_PLLC_PLLDIV7_D7EN_RESETVAL	(0x00000001u)

/*----D7EN Tokens----*/
#define CSL_PLLC_PLLDIV7_D7EN_DISABLE	(0x00000000u)
#define CSL_PLLC_PLLDIV7_D7EN_ENABLE	(0x00000001u)


#define CSL_PLLC_PLLDIV7_RATIO_MASK		(0x0000001Fu)
#define CSL_PLLC_PLLDIV7_RATIO_SHIFT	(0x00000000u)
#define CSL_PLLC_PLLDIV7_RATIO_RESETVAL (0x00000009u)

#define CSL_PLLC_PLLDIV7_RESETVAL		(0x00008009u)

/* PLLDIV8 */

#define CSL_PLLC_PLLDIV8_D8EN_MASK		(0x00008000u)
#define CSL_PLLC_PLLDIV8_D8EN_SHIFT		(0x0000000Fu)
#define CSL_PLLC_PLLDIV8_D8EN_RESETVAL	(0x00000001u)

/*----D8EN Tokens----*/
#define CSL_PLLC_PLLDIV8_D8EN_DISABLE	(0x00000000u)
#define CSL_PLLC_PLLDIV8_D8EN_ENABLE	(0x00000001u)

#define CSL_PLLC_PLLDIV8_RATIO_MASK		(0x0000001Fu)
#define CSL_PLLC_PLLDIV8_RATIO_SHIFT	(0x00000000u)
#define CSL_PLLC_PLLDIV8_RATIO_RESETVAL (0x00000009u)

#define CSL_PLLC_PLLDIV8_RESETVAL		(0x00008009u)

#endif

