/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006, 2008
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_psc.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for PSC
 *
 */

#ifndef _CSLR_PSC_H_
#define _CSLR_PSC_H_

#include <cslr.h>

#include "tistdtypes.h"


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint8 RSVD0[284];
    volatile Uint32 PTCMD;
    volatile Uint8 RSVD1[4];
    volatile Uint32 PTSTAT;
    volatile Uint8 RSVD2[212];
    volatile Uint32 PDSTAT0;
    volatile Uint32 PDSTAT1;
    volatile Uint32 PDSTAT2;
    volatile Uint32 PDSTAT3;
    volatile Uint32 PDSTAT4;
    volatile Uint8 RSVD3[236];
    volatile Uint32 PDCTL0;
    volatile Uint32 PDCTL1;
    volatile Uint32 PDCTL2;
    volatile Uint32 PDCTL3;
    volatile Uint32 PDCTL4;
    volatile Uint8 RSVD4[1260];
    volatile Uint32 MDSTAT0;
    volatile Uint32 MDSTAT1;
    volatile Uint32 MDSTAT2;
    volatile Uint32 MDSTAT3;
    volatile Uint32 MDSTAT4;
    volatile Uint32 MDSTAT5;
    volatile Uint32 MDSTAT6;
    volatile Uint32 MDSTAT7;
    volatile Uint32 MDSTAT8;
    volatile Uint32 MDSTAT9;
    volatile Uint32 MDSTAT10;
    volatile Uint8 RSVD5[468];
    volatile Uint32 MDCTL0;
    volatile Uint32 MDCTL1;
    volatile Uint32 MDCTL2;
    volatile Uint32 MDCTL3;
    volatile Uint32 MDCTL4;
    volatile Uint32 MDCTL5;
    volatile Uint32 MDCTL6;
    volatile Uint32 MDCTL7;
    volatile Uint32 MDCTL8;
    volatile Uint32 MDCTL9;
    volatile Uint32 MDCTL10;
} CSL_PscRegs;


/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_PscRegs             *CSL_PscRegsOvly;


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */

#define CSL_PSC_PID_PID_MASK (0xFFFFFFFFu)
#define CSL_PSC_PID_PID_SHIFT (0x00000000u)
#define CSL_PSC_PID_PID_RESETVAL (0x44823A00u)

#define CSL_PSC_PID_RESETVAL (0x44823A00u)

/* PTCMD */


#define CSL_PSC_PTCMD_GO_MASK (0x0000003Fu)
#define CSL_PSC_PTCMD_GO_SHIFT (0x00000000u)
#define CSL_PSC_PTCMD_GO_RESETVAL (0x00000000u)
/*----GO Tokens----*/
#define CSL_PSC_PTCMD_GO_SET (0x00000001u)

#define CSL_PSC_PTCMD_RESETVAL (0x00000000u)

/* PTSTAT */


#define CSL_PSC_PTSTAT_GOSTAT_MASK (0x0000003Fu)
#define CSL_PSC_PTSTAT_GOSTAT_SHIFT (0x00000000u)
#define CSL_PSC_PTSTAT_GOSTAT_RESETVAL (0x00000000u)
/*----GOSTAT Tokens----*/
#define CSL_PSC_PTSTAT_GOSTAT_NO_PWRDMN_TRANS (0x00000000u)
#define CSL_PSC_PTSTAT_GOSTAT_PWRDMN_TRANS_PROG (0x00000001u)

#define CSL_PSC_PTSTAT_RESETVAL (0x00000000u)

/* PDSTAT0 */


#define CSL_PSC_PDSTAT0_STATE_MASK (0x00000003u)
#define CSL_PSC_PDSTAT0_STATE_SHIFT (0x00000000u)
#define CSL_PSC_PDSTAT0_STATE_RESETVAL (0x00000001u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT0_STATE_OFF (0x00000000u)
#define CSL_PSC_PDSTAT0_STATE_ON (0x00000001u)

#define CSL_PSC_PDSTAT0_RESETVAL (0x00000301u)

/* PDSTAT1 */


#define CSL_PSC_PDSTAT1_STATE_MASK (0x00000003u)
#define CSL_PSC_PDSTAT1_STATE_SHIFT (0x00000000u)
#define CSL_PSC_PDSTAT1_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT1_STATE_OFF (0x00000000u)
#define CSL_PSC_PDSTAT1_STATE_ON (0x00000001u)

#define CSL_PSC_PDSTAT1_RESETVAL (0x00000300u)

/* PDSTAT2 */


#define CSL_PSC_PDSTAT2_STATE_MASK (0x00000003u)
#define CSL_PSC_PDSTAT2_STATE_SHIFT (0x00000000u)
#define CSL_PSC_PDSTAT2_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT2_STATE_OFF (0x00000000u)
#define CSL_PSC_PDSTAT2_STATE_ON (0x00000001u)

#define CSL_PSC_PDSTAT2_RESETVAL (0x00000300u)

/* PDSTAT3 */


#define CSL_PSC_PDSTAT3_STATE_MASK (0x00000003u)
#define CSL_PSC_PDSTAT3_STATE_SHIFT (0x00000000u)
#define CSL_PSC_PDSTAT3_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT3_STATE_OFF (0x00000000u)
#define CSL_PSC_PDSTAT3_STATE_ON (0x00000001u)

#define CSL_PSC_PDSTAT3_RESETVAL (0x00000300u)

/* PDSTAT4 */


#define CSL_PSC_PDSTAT4_STATE_MASK (0x00000003u)
#define CSL_PSC_PDSTAT4_STATE_SHIFT (0x00000000u)
#define CSL_PSC_PDSTAT4_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_PDSTAT4_STATE_OFF (0x00000000u)
#define CSL_PSC_PDSTAT4_STATE_ON (0x00000001u)

#define CSL_PSC_PDSTAT4_RESETVAL (0x00000300u)

/* PDCTL0 */


#define CSL_PSC_PDCTL0_NEXT_MASK (0x00000001u)
#define CSL_PSC_PDCTL0_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_PDCTL0_NEXT_RESETVAL (0x00000001u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL0_NEXT_OFF (0x00000000u)
#define CSL_PSC_PDCTL0_NEXT_ON (0x00000001u)

#define CSL_PSC_PDCTL0_RESETVAL (0x0001B001u)

/* PDCTL1 */


#define CSL_PSC_PDCTL1_NEXT_MASK (0x00000001u)
#define CSL_PSC_PDCTL1_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_PDCTL1_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL1_NEXT_OFF (0x00000000u)
#define CSL_PSC_PDCTL1_NEXT_ON (0x00000001u)

#define CSL_PSC_PDCTL1_RESETVAL (0x00338000u)

/* PDCTL2 */


#define CSL_PSC_PDCTL2_NEXT_MASK (0x00000001u)
#define CSL_PSC_PDCTL2_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_PDCTL2_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL2_NEXT_OFF (0x00000000u)
#define CSL_PSC_PDCTL2_NEXT_ON (0x00000001u)

#define CSL_PSC_PDCTL2_RESETVAL (0x00338000u)

/* PDCTL3 */


#define CSL_PSC_PDCTL3_NEXT_MASK (0x00000001u)
#define CSL_PSC_PDCTL3_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_PDCTL3_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL3_NEXT_OFF (0x00000000u)
#define CSL_PSC_PDCTL3_NEXT_ON (0x00000001u)

#define CSL_PSC_PDCTL3_RESETVAL (0x00338000u)

/* PDCTL4 */


#define CSL_PSC_PDCTL4_NEXT_MASK (0x00000001u)
#define CSL_PSC_PDCTL4_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_PDCTL4_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_PDCTL4_NEXT_OFF (0x00000000u)
#define CSL_PSC_PDCTL4_NEXT_ON (0x00000001u)

#define CSL_PSC_PDCTL4_RESETVAL (0x00338000u)

/* MDSTAT0 */


#define CSL_PSC_MDSTAT0_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT0_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT0_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT0_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT0_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT0_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT0_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT0_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT0_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT0_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT0_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT0_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT0_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT0_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT0_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT0_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT0_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT0_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT0_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT0_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT0_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT0_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT0_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT0_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT0_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT0_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT0_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT0_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT0_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT0_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT0_RESETVAL (0x00000A00u)

/* MDSTAT1 */


#define CSL_PSC_MDSTAT1_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT1_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT1_MCKOUT_RESETVAL (0x00000001u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT1_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT1_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT1_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT1_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT1_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT1_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT1_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT1_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT1_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT1_MRST_RESETVAL (0x00000001u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT1_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT1_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT1_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT1_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT1_LRSTDONE_RESETVAL (0x00000000u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT1_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT1_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT1_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT1_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT1_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT1_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT1_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT1_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT1_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT1_STATE_RESETVAL (0x00000003u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT1_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT1_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT1_RESETVAL (0x00001D03u)

/* MDSTAT2 */


#define CSL_PSC_MDSTAT2_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT2_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT2_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT2_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT2_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT2_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT2_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT2_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT2_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT2_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT2_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT2_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT2_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT2_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT2_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT2_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT2_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT2_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT2_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT2_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT2_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT2_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT2_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT2_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT2_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT2_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT2_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT2_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT2_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT2_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT2_RESETVAL (0x00000A00u)

/* MDSTAT3 */


#define CSL_PSC_MDSTAT3_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT3_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT3_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT3_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT3_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT3_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT3_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT3_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT3_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT3_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT3_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT3_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT3_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT3_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT3_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT3_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT3_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT3_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT3_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT3_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT3_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT3_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT3_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT3_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT3_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT3_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT3_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT3_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT3_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT3_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT3_RESETVAL (0x00000A00u)

/* MDSTAT4 */


#define CSL_PSC_MDSTAT4_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT4_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT4_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT4_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT4_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT4_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT4_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT4_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT4_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT4_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT4_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT4_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT4_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT4_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT4_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT4_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT4_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT4_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT4_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT4_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT4_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT4_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT4_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT4_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT4_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT4_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT4_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT4_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT4_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT4_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT4_RESETVAL (0x00000A00u)

/* MDSTAT5 */


#define CSL_PSC_MDSTAT5_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT5_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT5_MCKOUT_RESETVAL (0x00000001u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT5_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT5_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT5_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT5_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT5_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT5_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT5_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT5_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT5_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT5_MRST_RESETVAL (0x00000001u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT5_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT5_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT5_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT5_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT5_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT5_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT5_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT5_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT5_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT5_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT5_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT5_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT5_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT5_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT5_STATE_RESETVAL (0x00000003u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT5_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT5_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT5_RESETVAL (0x00001F03u)

/* MDSTAT6 */


#define CSL_PSC_MDSTAT6_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT6_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT6_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT6_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT6_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT6_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT6_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT6_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT6_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT6_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT6_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT6_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT6_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT6_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT6_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT6_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT6_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT6_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT6_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT6_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT6_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT6_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT6_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT6_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT6_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT6_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT6_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT6_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT6_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT6_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT6_RESETVAL (0x00000A00u)

/* MDSTAT7 */


#define CSL_PSC_MDSTAT7_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT7_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT7_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT7_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT7_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT7_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT7_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT7_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT7_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT7_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT7_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT7_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT7_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT7_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT7_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT7_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT7_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT7_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT7_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT7_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT7_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT7_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT7_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT7_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT7_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT7_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT7_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT7_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT7_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT7_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT7_RESETVAL (0x00000A00u)

/* MDSTAT8 */


#define CSL_PSC_MDSTAT8_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT8_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT8_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT8_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT8_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT8_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT8_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT8_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT8_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT8_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT8_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT8_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT8_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT8_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT8_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT8_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT8_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT8_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT8_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT8_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT8_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT8_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT8_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT8_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT8_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT8_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT8_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT8_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT8_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT8_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT8_RESETVAL (0x00000A00u)

/* MDSTAT9 */


#define CSL_PSC_MDSTAT9_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT9_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT9_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT9_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT9_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT9_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT9_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT9_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT9_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT9_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT9_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT9_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT9_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT9_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT9_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT9_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT9_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT9_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT9_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT9_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT9_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT9_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT9_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT9_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT9_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT9_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT9_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT9_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT9_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT9_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT9_RESETVAL (0x00000A00u)

/* MDSTAT10 */


#define CSL_PSC_MDSTAT10_MCKOUT_MASK (0x00001000u)
#define CSL_PSC_MDSTAT10_MCKOUT_SHIFT (0x0000000Cu)
#define CSL_PSC_MDSTAT10_MCKOUT_RESETVAL (0x00000000u)
/*----MCKOUT Tokens----*/
#define CSL_PSC_MDSTAT10_MCKOUT_OFF (0x00000000u)
#define CSL_PSC_MDSTAT10_MCKOUT_ON (0x00000001u)

#define CSL_PSC_MDSTAT10_MRSTDONE_MASK (0x00000800u)
#define CSL_PSC_MDSTAT10_MRSTDONE_SHIFT (0x0000000Bu)
#define CSL_PSC_MDSTAT10_MRSTDONE_RESETVAL (0x00000001u)
/*----MRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT10_MRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT10_MRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT10_MRST_MASK (0x00000400u)
#define CSL_PSC_MDSTAT10_MRST_SHIFT (0x0000000Au)
#define CSL_PSC_MDSTAT10_MRST_RESETVAL (0x00000000u)
/*----MRST Tokens----*/
#define CSL_PSC_MDSTAT10_MRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT10_MRST_DE_ASSERT (0x00000001u)

#define CSL_PSC_MDSTAT10_LRSTDONE_MASK (0x00000200u)
#define CSL_PSC_MDSTAT10_LRSTDONE_SHIFT (0x00000009u)
#define CSL_PSC_MDSTAT10_LRSTDONE_RESETVAL (0x00000001u)
/*----LRSTDONE Tokens----*/
#define CSL_PSC_MDSTAT10_LRSTDONE_NO (0x00000000u)
#define CSL_PSC_MDSTAT10_LRSTDONE_YES (0x00000001u)

#define CSL_PSC_MDSTAT10_LRST_MASK (0x00000100u)
#define CSL_PSC_MDSTAT10_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDSTAT10_LRST_RESETVAL (0x00000000u)
/*----LRST Tokens----*/
#define CSL_PSC_MDSTAT10_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDSTAT10_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDSTAT10_STATE_MASK (0x0000003Fu)
#define CSL_PSC_MDSTAT10_STATE_SHIFT (0x00000000u)
#define CSL_PSC_MDSTAT10_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_PSC_MDSTAT10_STATE_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDSTAT10_STATE_ENABLE (0x00000003u)

#define CSL_PSC_MDSTAT10_RESETVAL (0x00000A00u)

/* MDCTL0 */


#define CSL_PSC_MDCTL0_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL0_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL0_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL0_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL0_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL0_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL0_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL0_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL0_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL0_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL0_RESETVAL (0x00000100u)

/* MDCTL1 */


#define CSL_PSC_MDCTL1_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL1_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL1_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL1_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL1_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL1_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL1_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL1_NEXT_RESETVAL (0x00000003u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL1_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL1_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL1_RESETVAL (0x00000103u)

/* MDCTL2 */


#define CSL_PSC_MDCTL2_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL2_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL2_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL2_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL2_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL2_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL2_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL2_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL2_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL2_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL2_RESETVAL (0x00000100u)

/* MDCTL3 */


#define CSL_PSC_MDCTL3_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL3_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL3_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL3_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL3_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL3_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL3_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL3_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL3_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL3_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL3_RESETVAL (0x00000100u)

/* MDCTL4 */


#define CSL_PSC_MDCTL4_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL4_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL4_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL4_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL4_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL4_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL4_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL4_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL4_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL4_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL4_RESETVAL (0x00000100u)

/* MDCTL5 */


#define CSL_PSC_MDCTL5_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL5_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL5_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL5_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL5_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL5_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL5_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL5_NEXT_RESETVAL (0x00000003u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL5_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL5_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL5_RESETVAL (0x00000103u)

/* MDCTL6 */


#define CSL_PSC_MDCTL6_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL6_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL6_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL6_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL6_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL6_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL6_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL6_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL6_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL6_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL6_RESETVAL (0x00000100u)

/* MDCTL7 */


#define CSL_PSC_MDCTL7_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL7_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL7_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL7_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL7_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL7_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL7_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL7_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL7_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL7_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL7_RESETVAL (0x00000100u)

/* MDCTL8 */


#define CSL_PSC_MDCTL8_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL8_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL8_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL8_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL8_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL8_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL8_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL8_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL8_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL8_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL8_RESETVAL (0x00000100u)

/* MDCTL9 */


#define CSL_PSC_MDCTL9_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL9_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL9_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL9_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL9_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL9_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL9_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL9_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL9_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL9_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL9_RESETVAL (0x00000100u)

/* MDCTL10 */


#define CSL_PSC_MDCTL10_LRST_MASK (0x00000100u)
#define CSL_PSC_MDCTL10_LRST_SHIFT (0x00000008u)
#define CSL_PSC_MDCTL10_LRST_RESETVAL (0x00000001u)
/*----LRST Tokens----*/
#define CSL_PSC_MDCTL10_LRST_ASSERT (0x00000000u)
#define CSL_PSC_MDCTL10_LRST_DE_ASSERT (0x00000001u)


#define CSL_PSC_MDCTL10_NEXT_MASK (0x0000001Fu)
#define CSL_PSC_MDCTL10_NEXT_SHIFT (0x00000000u)
#define CSL_PSC_MDCTL10_NEXT_RESETVAL (0x00000000u)
/*----NEXT Tokens----*/
#define CSL_PSC_MDCTL10_NEXT_SWRSTDISABLE (0x00000000u)
#define CSL_PSC_MDCTL10_NEXT_ENABLE (0x00000003u)

#define CSL_PSC_MDCTL10_RESETVAL (0x00000100u)

#endif
