/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_sgmii.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for SGMII
 *
 */
#ifndef _CSLR_SGMII_H_
#define _CSLR_SGMII_H_

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 IDVER;
    volatile Uint32 SOFT_RESET;
    volatile Uint8 RSVD0[8];
    volatile Uint32 CONTROL;
    volatile Uint32 STATUS;
    volatile Uint32 MR_ADV_ABILITY;
    volatile Uint8 RSVD1[4];
    volatile Uint32 MR_LP_ADV_ABILITY;
    volatile Uint8 RSVD2[12];
    volatile Uint32 TX_CFG;
    volatile Uint32 RX_CFG;
    volatile Uint32 AUX_CFG;
} CSL_SgmiiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IDVER */

#define CSL_SGMII_IDVER_TX_IDENT_MASK    (0xFFFF0000u)
#define CSL_SGMII_IDVER_TX_IDENT_SHIFT   (0x00000010u)
#define CSL_SGMII_IDVER_TX_IDENT_RESETVAL (0x0000002Cu)

#define CSL_SGMII_IDVER_RTL_VER_MASK     (0x0000F800u)
#define CSL_SGMII_IDVER_RTL_VER_SHIFT    (0x0000000Bu)
#define CSL_SGMII_IDVER_RTL_VER_RESETVAL (0x00000000u)

#define CSL_SGMII_IDVER_MAJOR_VER_MASK   (0x00000700u)
#define CSL_SGMII_IDVER_MAJOR_VER_SHIFT  (0x00000008u)
#define CSL_SGMII_IDVER_MAJOR_VER_RESETVAL (0x00000001u)

#define CSL_SGMII_IDVER_MINOR_VER_MASK   (0x000000FFu)
#define CSL_SGMII_IDVER_MINOR_VER_SHIFT  (0x00000000u)
#define CSL_SGMII_IDVER_MINOR_VER_RESETVAL (0x00000000u)

#define CSL_SGMII_IDVER_RESETVAL         (0x002C0100u)

/* SOFT_RESET */

#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_MASK (0x00000002u)
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_SHIFT (0x00000001u)
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_RESETVAL (0x00000000u)

/*----RT_SOFT_RESET Tokens----*/
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_YES (0x00000001u)
#define CSL_SGMII_SOFT_RESET_RT_SOFT_RESET_NO (0x00000000u)

#define CSL_SGMII_SOFT_RESET_SOFT_RESET_MASK (0x00000001u)
#define CSL_SGMII_SOFT_RESET_SOFT_RESET_SHIFT (0x00000000u)
#define CSL_SGMII_SOFT_RESET_SOFT_RESET_RESETVAL (0x00000000u)

/*----SOFT_RESET Tokens----*/
#define CSL_SGMII_SOFT_RESET_SOFT_RESET_YES (0x00000001u)

#define CSL_SGMII_SOFT_RESET_RESETVAL    (0x00000000u)

/* CONTROL */


#define CSL_SGMII_CONTROL_MASTER_MASK    (0x00000020u)
#define CSL_SGMII_CONTROL_MASTER_SHIFT   (0x00000005u)
#define CSL_SGMII_CONTROL_MASTER_RESETVAL (0x00000000u)

/*----MASTER Tokens----*/
#define CSL_SGMII_CONTROL_MASTER_MASTER  (0x00000001u)
#define CSL_SGMII_CONTROL_MASTER_SLAVE   (0x00000000u)

#define CSL_SGMII_CONTROL_LOOPBACK_MASK  (0x00000010u)
#define CSL_SGMII_CONTROL_LOOPBACK_SHIFT (0x00000004u)
#define CSL_SGMII_CONTROL_LOOPBACK_RESETVAL (0x00000000u)

/*----LOOPBACK Tokens----*/
#define CSL_SGMII_CONTROL_LOOPBACK_YES   (0x00000001u)
#define CSL_SGMII_CONTROL_LOOPBACK_NO    (0x00000000u)


#define CSL_SGMII_CONTROL_MR_AN_RESTART_MASK (0x00000002u)
#define CSL_SGMII_CONTROL_MR_AN_RESTART_SHIFT (0x00000001u)
#define CSL_SGMII_CONTROL_MR_AN_RESTART_RESETVAL (0x00000000u)

/*----MR_AN_RESTART Tokens----*/
#define CSL_SGMII_CONTROL_MR_AN_RESTART_YES (0x00000001u)

#define CSL_SGMII_CONTROL_MR_AN_ENABLE_MASK (0x00000001u)
#define CSL_SGMII_CONTROL_MR_AN_ENABLE_SHIFT (0x00000000u)
#define CSL_SGMII_CONTROL_MR_AN_ENABLE_RESETVAL (0x00000000u)

/*----MR_AN_ENABLE Tokens----*/
#define CSL_SGMII_CONTROL_MR_AN_ENABLE_YES (0x00000001u)

#define CSL_SGMII_CONTROL_RESETVAL       (0x00000000u)

/* STATUS */

#define CSL_SGMII_STATUS_FIB_SIG_DETECT_MASK (0x00000020u)
#define CSL_SGMII_STATUS_FIB_SIG_DETECT_SHIFT (0x00000005u)
#define CSL_SGMII_STATUS_FIB_SIG_DETECT_RESETVAL (0x00000000u)

#define CSL_SGMII_STATUS_LOCK_MASK       (0x00000010u)
#define CSL_SGMII_STATUS_LOCK_SHIFT      (0x00000004u)
#define CSL_SGMII_STATUS_LOCK_RESETVAL   (0x00000000u)


#define CSL_SGMII_STATUS_MR_AN_COMPLETE_MASK (0x00000004u)
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_SHIFT (0x00000002u)
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_RESETVAL (0x00000000u)

/*----MR_AN_COMPLETE Tokens----*/
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_DONE (0x00000001u)
#define CSL_SGMII_STATUS_MR_AN_COMPLETE_NOT_DONE (0x00000000u)

#define CSL_SGMII_STATUS_AN_ERROR_MASK   (0x00000002u)
#define CSL_SGMII_STATUS_AN_ERROR_SHIFT  (0x00000001u)
#define CSL_SGMII_STATUS_AN_ERROR_RESETVAL (0x00000000u)

/*----AN_ERROR Tokens----*/
#define CSL_SGMII_STATUS_AN_ERROR_OCCURED (0x00000001u)
#define CSL_SGMII_STATUS_AN_ERROR_NOT_OCCURED (0x00000000u)

#define CSL_SGMII_STATUS_LINK_MASK       (0x00000001u)
#define CSL_SGMII_STATUS_LINK_SHIFT      (0x00000000u)
#define CSL_SGMII_STATUS_LINK_RESETVAL   (0x00000000u)

/*----LINK Tokens----*/
#define CSL_SGMII_STATUS_LINK_UP         (0x00000001u)
#define CSL_SGMII_STATUS_LINK_NOT_UP     (0x00000000u)

#define CSL_SGMII_STATUS_RESETVAL        (0x00000000u)

/* MR_ADV_ABILITY */

#define CSL_SGMII_MR_ADV_ABILITY_MR_ADV_ABILITY_MASK (0x0000FFFFu)
#define CSL_SGMII_MR_ADV_ABILITY_MR_ADV_ABILITY_SHIFT (0x00000000u)
#define CSL_SGMII_MR_ADV_ABILITY_MR_ADV_ABILITY_RESETVAL (0x00000000u)

#define CSL_SGMII_MR_ADV_ABILITY_RESETVAL (0x00000000u)

/* MR_LP_ADV_ABILITY */


#define CSL_SGMII_MR_LP_ADV_ABILITY_MR_LP_ADV_ABILITY_MASK (0x0000FFFFu)
#define CSL_SGMII_MR_LP_ADV_ABILITY_MR_LP_ADV_ABILITY_SHIFT (0x00000000u)
#define CSL_SGMII_MR_LP_ADV_ABILITY_MR_LP_ADV_ABILITY_RESETVAL (0x00000000u)

#define CSL_SGMII_MR_LP_ADV_ABILITY_RESETVAL (0x00000000u)

/* TX_CFG */


#define CSL_SGMII_TX_CFG_ENFTP_MASK (0x00010000u)
#define CSL_SGMII_TX_CFG_ENFTP_SHIFT (0x00000010u)
#define CSL_SGMII_TX_CFG_ENFTP_RESETVAL (0x00000000u)

#define CSL_SGMII_TX_CFG_DE_MASK (0x0000F000u)
#define CSL_SGMII_TX_CFG_DE_SHIFT (0x0000000Cu)
#define CSL_SGMII_TX_CFG_DE_RESETVAL (0x00000000u)
/*----DE Tokens----*/
#define CSL_SGMII_TX_CFG_DE_0 (0x00000000u)
#define CSL_SGMII_TX_CFG_DE_4_76 (0x00000001u)
#define CSL_SGMII_TX_CFG_DE_9_52 (0x00000002u)
#define CSL_SGMII_TX_CFG_DE_14_28 (0x0000000Bu)
#define CSL_SGMII_TX_CFG_DE_19_04 (0x00000004u)
#define CSL_SGMII_TX_CFG_DE_23_80 (0x00000005u)
#define CSL_SGMII_TX_CFG_DE_28_56 (0x00000006u)
#define CSL_SGMII_TX_CFG_DE_33_32 (0x00000007u)
#define CSL_SGMII_TX_CFG_DE_38_08 (0x00000008u)
#define CSL_SGMII_TX_CFG_DE_42_85 (0x00000009u)
#define CSL_SGMII_TX_CFG_DE_47_61 (0x0000000Au)
#define CSL_SGMII_TX_CFG_DE_52_38 (0x0000000Bu)
#define CSL_SGMII_TX_CFG_DE_57_14 (0x0000000Cu)
#define CSL_SGMII_TX_CFG_DE_61_90 (0x0000000Du)
#define CSL_SGMII_TX_CFG_DE_66_66 (0x0000000Eu)
#define CSL_SGMII_TX_CFG_DE_71_42 (0x0000000Fu)

#define CSL_SGMII_TX_CFG_SWING_MASK (0x00000E00u)
#define CSL_SGMII_TX_CFG_SWING_SHIFT (0x00000009u)
#define CSL_SGMII_TX_CFG_SWING_RESETVAL (0x00000000u)
/*----SWING Tokens----*/
#define CSL_SGMII_TX_CFG_SWING_125 (0x00000000u)
#define CSL_SGMII_TX_CFG_SWING_250 (0x00000001u)
#define CSL_SGMII_TX_CFG_SWING_500 (0x00000002u)
#define CSL_SGMII_TX_CFG_SWING_625 (0x00000003u)
#define CSL_SGMII_TX_CFG_SWING_750 (0x00000004u)
#define CSL_SGMII_TX_CFG_SWING_1000 (0x00000005u)
#define CSL_SGMII_TX_CFG_SWING_1125 (0x00000006u)
#define CSL_SGMII_TX_CFG_SWING_1250 (0x00000007u)

#define CSL_SGMII_TX_CFG_CM_MASK (0x00000100u)
#define CSL_SGMII_TX_CFG_CM_SHIFT (0x00000008u)
#define CSL_SGMII_TX_CFG_CM_RESETVAL (0x00000000u)
/*----CM Tokens----*/
#define CSL_SGMII_TX_CFG_CM_NORMAL (0x00000000u)
#define CSL_SGMII_TX_CFG_CM_RAISED (0x00000001u)

#define CSL_SGMII_TX_CFG_INVPAIR_MASK (0x00000080u)
#define CSL_SGMII_TX_CFG_INVPAIR_SHIFT (0x00000007u)
#define CSL_SGMII_TX_CFG_INVPAIR_RESETVAL (0x00000000u)
/*----INVPAIR Tokens----*/
#define CSL_SGMII_TX_CFG_INVPAIR_NORMAL (0x00000000u)
#define CSL_SGMII_TX_CFG_INVPAIR_INVERTED (0x00000001u)

#define CSL_SGMII_TX_CFG_RATE_MASK (0x00000060u)
#define CSL_SGMII_TX_CFG_RATE_SHIFT (0x00000005u)
#define CSL_SGMII_TX_CFG_RATE_RESETVAL (0x00000000u)
/*----RATE Tokens----*/
#define CSL_SGMII_TX_CFG_RATE_FULL_LINE (0x00000000u)
#define CSL_SGMII_TX_CFG_RATE_HALF_LINE (0x00000001u)
#define CSL_SGMII_TX_CFG_RATE_QUARTER_LINE (0x00000002u)

#define CSL_SGMII_TX_CFG_BUSWIDTH_MASK (0x0000001Cu)
#define CSL_SGMII_TX_CFG_BUSWIDTH_SHIFT (0x00000002u)
#define CSL_SGMII_TX_CFG_BUSWIDTH_RESETVAL (0x00000000u)
/*----BUSWIDTH Tokens----*/
#define CSL_SGMII_TX_CFG_BUSWIDTH_10_BIT_WIDE (0x00000000u)


#define CSL_SGMII_TX_CFG_ENTX_MASK (0x00000001u)
#define CSL_SGMII_TX_CFG_ENTX_SHIFT (0x00000000u)
#define CSL_SGMII_TX_CFG_ENTX_RESETVAL (0x00000000u)
/*----ENTX Tokens----*/
#define CSL_SGMII_TX_CFG_ENTX_DISABLE (0x00000000u)
#define CSL_SGMII_TX_CFG_ENTX_ENABLE (0x00000001u)

#define CSL_SGMII_TX_CFG_RESETVAL        (0x00000000u)

/* RX_CFG */




#define CSL_SGMII_RX_CFG_EQ_MASK (0x00780000u)
#define CSL_SGMII_RX_CFG_EQ_SHIFT (0x00000013u)
#define CSL_SGMII_RX_CFG_EQ_RESETVAL (0x00000000u)
/*----EQ Tokens----*/
#define CSL_SGMII_RX_CFG_EQ_LFG_MAX (0x00000000u)
#define CSL_SGMII_RX_CFG_EQ_ADAPTIVE (0x00000001u)
#define CSL_SGMII_RX_CFG_EQ_LFG_ADAPIVE (0x00000008u)
#define CSL_SGMII_RX_CFG_EQ_ZF_1048 (0x00000008u)
#define CSL_SGMII_RX_CFG_EQ_ZF_805 (0x00000009u)
#define CSL_SGMII_RX_CFG_EQ_ZF_573 (0x0000000Au)
#define CSL_SGMII_RX_CFG_EQ_ZF_402 (0x0000000Bu)
#define CSL_SGMII_RX_CFG_EQ_ZF_304 (0x0000000Cu)
#define CSL_SGMII_RX_CFG_EQ_ZF_216 (0x0000000Du)
#define CSL_SGMII_RX_CFG_EQ_ZF_156 (0x0000000Eu)
#define CSL_SGMII_RX_CFG_EQ_ZF_135 (0x0000000Fu)

#define CSL_SGMII_RX_CFG_CDR_MASK (0x00070000u)
#define CSL_SGMII_RX_CFG_CDR_SHIFT (0x00000010u)
#define CSL_SGMII_RX_CFG_CDR_RESETVAL (0x00000000u)
/*----CDR Tokens----*/
#define CSL_SGMII_RX_CFG_CDR_FIRST_ORDER (0x00000000u)
#define CSL_SGMII_RX_CFG_CDR_SECOND_ORDER_HP (0x00000001u)
#define CSL_SGMII_RX_CFG_CDR_SECOND_ORDER_MP (0x00000002u)
#define CSL_SGMII_RX_CFG_CDR_SECOND_ORDER_BR (0x00000003u)
#define CSL_SGMII_RX_CFG_CDR_FIRST_ORDER_FL (0x00000004u)
#define CSL_SGMII_RX_CFG_CDR_SECOND_ORDER_FL_001 (0x00000005u)
#define CSL_SGMII_RX_CFG_CDR_SECOND_ORDER_FL_010 (0x00000006u)
#define CSL_SGMII_RX_CFG_CDR_SECOND_ORDER_FL_011 (0x00000007u)

#define CSL_SGMII_RX_CFG_LOS_MASK (0x0000C000u)
#define CSL_SGMII_RX_CFG_LOS_SHIFT (0x0000000Eu)
#define CSL_SGMII_RX_CFG_LOS_RESETVAL (0x00000000u)
/*----LOS Tokens----*/
#define CSL_SGMII_RX_CFG_LOS_DISABLED (0x00000000u)
#define CSL_SGMII_RX_CFG_LOS_HIGH_THRESH (0x00000001u)
#define CSL_SGMII_RX_CFG_LOS_LOW_THRESH (0x00000002u)

#define CSL_SGMII_RX_CFG_ALIGN_MASK (0x00003000u)
#define CSL_SGMII_RX_CFG_ALIGN_SHIFT (0x0000000Cu)
#define CSL_SGMII_RX_CFG_ALIGN_RESETVAL (0x00000000u)
/*----ALIGN Tokens----*/
#define CSL_SGMII_RX_CFG_ALIGN_DISABLED (0x00000000u)
#define CSL_SGMII_RX_CFG_ALIGN_ENABLED (0x00000001u)
#define CSL_SGMII_RX_CFG_ALIGN_JOG (0x00000002u)


#define CSL_SGMII_RX_CFG_TERM_MASK (0x00000700u)
#define CSL_SGMII_RX_CFG_TERM_SHIFT (0x00000008u)
#define CSL_SGMII_RX_CFG_TERM_RESETVAL (0x00000000u)
/*----TERM Tokens----*/
#define CSL_SGMII_RX_CFG_TERM_0_8_VDDT (0x00000001u)

#define CSL_SGMII_RX_CFG_INVPAIR_MASK (0x00000080u)
#define CSL_SGMII_RX_CFG_INVPAIR_SHIFT (0x00000007u)
#define CSL_SGMII_RX_CFG_INVPAIR_RESETVAL (0x00000000u)
/*----INVPAIR Tokens----*/
#define CSL_SGMII_RX_CFG_INVPAIR_NORMAL (0x00000000u)
#define CSL_SGMII_RX_CFG_INVPAIR_INVERTED (0x00000001u)

#define CSL_SGMII_RX_CFG_RATE_MASK (0x00000060u)
#define CSL_SGMII_RX_CFG_RATE_SHIFT (0x00000005u)
#define CSL_SGMII_RX_CFG_RATE_RESETVAL (0x00000000u)
/*----RATE Tokens----*/
#define CSL_SGMII_RX_CFG_RATE_FULL_LINE (0x00000000u)
#define CSL_SGMII_RX_CFG_RATE_HALF_LINE (0x00000001u)
#define CSL_SGMII_RX_CFG_RATE_QUARTER_LINE (0x00000002u)

#define CSL_SGMII_RX_CFG_BUSWIDTH_MASK (0x0000001Cu)
#define CSL_SGMII_RX_CFG_BUSWIDTH_SHIFT (0x00000002u)
#define CSL_SGMII_RX_CFG_BUSWIDTH_RESETVAL (0x00000000u)
/*----BUSWIDTH Tokens----*/
#define CSL_SGMII_RX_CFG_BUSWIDTH_10_BIT_WIDE (0x00000000u)


#define CSL_SGMII_RX_CFG_ENRX_MASK (0x00000001u)
#define CSL_SGMII_RX_CFG_ENRX_SHIFT (0x00000000u)
#define CSL_SGMII_RX_CFG_ENRX_RESETVAL (0x00000000u)
/*----ENRX Tokens----*/
#define CSL_SGMII_RX_CFG_ENRX_DISABLE (0x00000000u)
#define CSL_SGMII_RX_CFG_ENRX_ENABLE (0x00000001u)

#define CSL_SGMII_RX_CFG_RESETVAL (0x00000000u)

/* AUX_CFG */


#define CSL_SGMII_AUX_CFG_LB_MASK (0x000C0000u)
#define CSL_SGMII_AUX_CFG_LB_SHIFT (0x00000012u)
#define CSL_SGMII_AUX_CFG_LB_RESETVAL (0x00000000u)
/*----LB Tokens----*/
#define CSL_SGMII_AUX_CFG_LB_DISABLE (0x00000000u)
#define CSL_SGMII_AUX_CFG_LB_BUMP_PAD_LOOPBACK (0x00000002u)


#define CSL_SGMII_AUX_CFG_MPY_MASK (0x0000001Eu)
#define CSL_SGMII_AUX_CFG_MPY_SHIFT (0x00000001u)
#define CSL_SGMII_AUX_CFG_MPY_RESETVAL (0x00000000u)
/*----MPY Tokens----*/
#define CSL_SGMII_AUX_CFG_MPY_4_X (0x00000000u)
#define CSL_SGMII_AUX_CFG_MPY_5_X (0x00000001u)
#define CSL_SGMII_AUX_CFG_MPY_6_X (0x00000002u)
#define CSL_SGMII_AUX_CFG_MPY_8_X (0x00000004u)
#define CSL_SGMII_AUX_CFG_MPY_10_X (0x00000005u)
#define CSL_SGMII_AUX_CFG_MPY_12_X (0x00000006u)
#define CSL_SGMII_AUX_CFG_MPY_12_5_X (0x00000007u)
#define CSL_SGMII_AUX_CFG_MPY_15_X (0x00000008u)
#define CSL_SGMII_AUX_CFG_MPY_20_X (0x00000009u)
#define CSL_SGMII_AUX_CFG_MPY_25_X (0x0000000Au)

#define CSL_SGMII_AUX_CFG_ENPLL_MASK (0x00000001u)
#define CSL_SGMII_AUX_CFG_ENPLL_SHIFT (0x00000000u)
#define CSL_SGMII_AUX_CFG_ENPLL_RESETVAL (0x00000000u)
/*----ENPLL Tokens----*/
#define CSL_SGMII_AUX_CFG_ENPLL_DISABLE (0x00000000u)
#define CSL_SGMII_AUX_CFG_ENPLL_ENABLE (0x00000001u)

#define CSL_SGMII_AUX_CFG_RESETVAL (0x00000000u)

#endif
