/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2008
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_tetb.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for TETB
 */

#ifndef _CSLR_TETB_H_
#define _CSLR_TETB_H_

#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[4];
    volatile Uint32 RDP;
    volatile Uint8 RSVD1[4];
    volatile Uint32 STS;
    volatile Uint32 RRD;
    volatile Uint32 RRP;
    volatile Uint32 RWP;
    volatile Uint32 TRG;
    volatile Uint32 CTL;
    volatile Uint32 RWD;
    volatile Uint8 RSVD2[2520];
    volatile Uint32 RBD;
    volatile Uint8 RSVD3[1020];
    volatile Uint32 ISST;
    volatile Uint32 ICST;
    volatile Uint32 IEST;
    volatile Uint32 IESST;
    volatile Uint32 IECST;
    volatile Uint8 RSVD4[12];
    volatile Uint32 TCTL;
    volatile Uint8 RSVD5[420];
    volatile Uint32 DID;
    volatile Uint32 DTIR;
    volatile Uint32 PID4;
    volatile Uint8 RSVD6[12];
    volatile Uint32 PID0;
    volatile Uint32 PID1;
    volatile Uint32 PID2;
    volatile Uint32 PID3;
    volatile Uint32 CID0;
    volatile Uint32 CID1;
    volatile Uint32 CID2;
    volatile Uint32 CID3;
} CSL_TetbRegs;


/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_TetbRegs              *CSL_TetbRegsOvly;


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* RDP */

#define CSL_TETB_RDP_RDP_MASK (0xFFFFFFFFu)
#define CSL_TETB_RDP_RDP_SHIFT (0x00000000u)
#define CSL_TETB_RDP_RDP_RESETVAL (0x00000200u)

#define CSL_TETB_RDP_RESETVAL (0x00000200u)

/* STS */


#define CSL_TETB_STS_ACQCOMP_MASK (0x00000004u)
#define CSL_TETB_STS_ACQCOMP_SHIFT (0x00000002u)
#define CSL_TETB_STS_ACQCOMP_RESETVAL (0x00000000u)

#define CSL_TETB_STS_TRIGGERED_MASK (0x00000002u)
#define CSL_TETB_STS_TRIGGERED_SHIFT (0x00000001u)
#define CSL_TETB_STS_TRIGGERED_RESETVAL (0x00000000u)

#define CSL_TETB_STS_FULL_MASK (0x00000001u)
#define CSL_TETB_STS_FULL_SHIFT (0x00000000u)
#define CSL_TETB_STS_FULL_RESETVAL (0x00000000u)

#define CSL_TETB_STS_RESETVAL (0x00000000u)

/* RRD */

#define CSL_TETB_RRD_RRD_MASK (0xFFFFFFFFu)
#define CSL_TETB_RRD_RRD_SHIFT (0x00000000u)
#define CSL_TETB_RRD_RRD_RESETVAL (0x00000000u)

#define CSL_TETB_RRD_RESETVAL (0x00000000u)

/* RRP */


#define CSL_TETB_RRP_RRP_MASK (0x000003FFu)
#define CSL_TETB_RRP_RRP_SHIFT (0x00000000u)
#define CSL_TETB_RRP_RRP_RESETVAL (0x00000000u)

#define CSL_TETB_RRP_RESETVAL (0x00000000u)

/* RWP */


#define CSL_TETB_RWP_RWP_MASK (0x000003FFu)
#define CSL_TETB_RWP_RWP_SHIFT (0x00000000u)
#define CSL_TETB_RWP_RWP_RESETVAL (0x00000000u)

#define CSL_TETB_RWP_RESETVAL (0x00000000u)

/* TRG */


#define CSL_TETB_TRG_TRG_MASK (0x000003FFu)
#define CSL_TETB_TRG_TRG_SHIFT (0x00000000u)
#define CSL_TETB_TRG_TRG_RESETVAL (0x00000000u)

#define CSL_TETB_TRG_RESETVAL (0x00000000u)

/* CTL */


#define CSL_TETB_CTL_TRACECAPTEN_MASK (0x00000001u)
#define CSL_TETB_CTL_TRACECAPTEN_SHIFT (0x00000000u)
#define CSL_TETB_CTL_TRACECAPTEN_RESETVAL (0x00000000u)
/*----TRACECAPTEN Tokens----*/
#define CSL_TETB_CTL_TRACECAPTEN_DISABLE (0x00000000u)
#define CSL_TETB_CTL_TRACECAPTEN_ENABLE (0x00000001u)

#define CSL_TETB_CTL_RESETVAL (0x00000000u)

/* RWD */

#define CSL_TETB_RWD_RWD_MASK (0xFFFFFFFFu)
#define CSL_TETB_RWD_RWD_SHIFT (0x00000000u)
#define CSL_TETB_RWD_RWD_RESETVAL (0x00000000u)

#define CSL_TETB_RWD_RESETVAL (0x00000000u)

/* RBD */

#define CSL_TETB_RBD_RBD_MASK (0xFFFFFFFFu)
#define CSL_TETB_RBD_RBD_SHIFT (0x00000000u)
#define CSL_TETB_RBD_RBD_RESETVAL (0x00000000u)

#define CSL_TETB_RBD_RESETVAL (0x00000000u)

/* ISST */


#define CSL_TETB_ISST_ACQ_COMP_SET_MASK (0x00000010u)
#define CSL_TETB_ISST_ACQ_COMP_SET_SHIFT (0x00000004u)
#define CSL_TETB_ISST_ACQ_COMP_SET_RESETVAL (0x00000000u)
/*----ACQ_COMP_SET Tokens----*/
#define CSL_TETB_ISST_ACQ_COMP_SET_SET (0x00000001u)

#define CSL_TETB_ISST_UNDERFLOW_SET_MASK (0x00000008u)
#define CSL_TETB_ISST_UNDERFLOW_SET_SHIFT (0x00000003u)
#define CSL_TETB_ISST_UNDERFLOW_SET_RESETVAL (0x00000000u)
/*----UNDERFLOW_SET Tokens----*/
#define CSL_TETB_ISST_UNDERFLOW_SET_SET (0x00000001u)

#define CSL_TETB_ISST_OVERFLOW_SET_MASK (0x00000004u)
#define CSL_TETB_ISST_OVERFLOW_SET_SHIFT (0x00000002u)
#define CSL_TETB_ISST_OVERFLOW_SET_RESETVAL (0x00000000u)
/*----OVERFLOW_SET Tokens----*/
#define CSL_TETB_ISST_OVERFLOW_SET_SET (0x00000001u)

#define CSL_TETB_ISST_FULL_SET_MASK (0x00000002u)
#define CSL_TETB_ISST_FULL_SET_SHIFT (0x00000001u)
#define CSL_TETB_ISST_FULL_SET_RESETVAL (0x00000000u)
/*----FULL_SET Tokens----*/
#define CSL_TETB_ISST_FULL_SET_SET (0x00000001u)

#define CSL_TETB_ISST_HALFFULL_SET_MASK (0x00000001u)
#define CSL_TETB_ISST_HALFFULL_SET_SHIFT (0x00000000u)
#define CSL_TETB_ISST_HALFFULL_SET_RESETVAL (0x00000000u)
/*----HALFFULL_SET Tokens----*/
#define CSL_TETB_ISST_HALFFULL_SET_SET (0x00000001u)

#define CSL_TETB_ISST_RESETVAL (0x00000000u)

/* IRST */


#define CSL_TETB_IRST_ACQ_COMP_MASK (0x00000010u)
#define CSL_TETB_IRST_ACQ_COMP_SHIFT (0x00000004u)
#define CSL_TETB_IRST_ACQ_COMP_RESETVAL (0x00000000u)

#define CSL_TETB_IRST_UNDERFLOW_MASK (0x00000008u)
#define CSL_TETB_IRST_UNDERFLOW_SHIFT (0x00000003u)
#define CSL_TETB_IRST_UNDERFLOW_RESETVAL (0x00000000u)

#define CSL_TETB_IRST_OVERFLOW_MASK (0x00000004u)
#define CSL_TETB_IRST_OVERFLOW_SHIFT (0x00000002u)
#define CSL_TETB_IRST_OVERFLOW_RESETVAL (0x00000000u)

#define CSL_TETB_IRST_FULL_MASK (0x00000002u)
#define CSL_TETB_IRST_FULL_SHIFT (0x00000001u)
#define CSL_TETB_IRST_FULL_RESETVAL (0x00000000u)

#define CSL_TETB_IRST_HALFFULL_MASK (0x00000001u)
#define CSL_TETB_IRST_HALFFULL_SHIFT (0x00000000u)
#define CSL_TETB_IRST_HALFFULL_RESETVAL (0x00000000u)

#define CSL_TETB_IRST_RESETVAL (0x00000000u)

/* ICST */


#define CSL_TETB_ICST_ACQ_COMP_CLEAR_MASK (0x00000010u)
#define CSL_TETB_ICST_ACQ_COMP_CLEAR_SHIFT (0x00000004u)
#define CSL_TETB_ICST_ACQ_COMP_CLEAR_RESETVAL (0x00000000u)
/*----ACQ_COMP_CLEAR Tokens----*/
#define CSL_TETB_ICST_ACQ_COMP_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_ICST_UNDERFLOW_CLEAR_MASK (0x00000008u)
#define CSL_TETB_ICST_UNDERFLOW_CLEAR_SHIFT (0x00000003u)
#define CSL_TETB_ICST_UNDERFLOW_CLEAR_RESETVAL (0x00000000u)
/*----UNDERFLOW_CLEAR Tokens----*/
#define CSL_TETB_ICST_UNDERFLOW_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_ICST_OVERFLOW_CLEAR_MASK (0x00000004u)
#define CSL_TETB_ICST_OVERFLOW_CLEAR_SHIFT (0x00000002u)
#define CSL_TETB_ICST_OVERFLOW_CLEAR_RESETVAL (0x00000000u)
/*----OVERFLOW_CLEAR Tokens----*/
#define CSL_TETB_ICST_OVERFLOW_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_ICST_FULL_CLEAR_MASK (0x00000002u)
#define CSL_TETB_ICST_FULL_CLEAR_SHIFT (0x00000001u)
#define CSL_TETB_ICST_FULL_CLEAR_RESETVAL (0x00000000u)
/*----FULL_CLEAR Tokens----*/
#define CSL_TETB_ICST_FULL_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_ICST_HALFFULL_CLEAR_MASK (0x00000001u)
#define CSL_TETB_ICST_HALFFULL_CLEAR_SHIFT (0x00000000u)
#define CSL_TETB_ICST_HALFFULL_CLEAR_RESETVAL (0x00000000u)
/*----HALFFULL_CLEAR Tokens----*/
#define CSL_TETB_ICST_HALFFULL_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_ICST_RESETVAL (0x00000000u)

/* IEST */


#define CSL_TETB_IEST_ACQ_COMP_ENABLED_MASK (0x00000010u)
#define CSL_TETB_IEST_ACQ_COMP_ENABLED_SHIFT (0x00000004u)
#define CSL_TETB_IEST_ACQ_COMP_ENABLED_RESETVAL (0x00000000u)

#define CSL_TETB_IEST_UNDERFLOW_ENABLED_MASK (0x00000008u)
#define CSL_TETB_IEST_UNDERFLOW_ENABLED_SHIFT (0x00000003u)
#define CSL_TETB_IEST_UNDERFLOW_ENABLED_RESETVAL (0x00000000u)

#define CSL_TETB_IEST_OVERFLOW_ENABLED_MASK (0x00000004u)
#define CSL_TETB_IEST_OVERFLOW_ENABLED_SHIFT (0x00000002u)
#define CSL_TETB_IEST_OVERFLOW_ENABLED_RESETVAL (0x00000000u)

#define CSL_TETB_IEST_FULL_ENABLED_MASK (0x00000002u)
#define CSL_TETB_IEST_FULL_ENABLED_SHIFT (0x00000001u)
#define CSL_TETB_IEST_FULL_ENABLED_RESETVAL (0x00000000u)

#define CSL_TETB_IEST_HALFFULL_ENABLED_MASK (0x00000001u)
#define CSL_TETB_IEST_HALFFULL_ENABLED_SHIFT (0x00000000u)
#define CSL_TETB_IEST_HALFFULL_ENABLED_RESETVAL (0x00000000u)

#define CSL_TETB_IEST_RESETVAL (0x00000000u)

/* IESST */


#define CSL_TETB_IESST_ACQ_COMP_EN_SET_MASK (0x00000010u)
#define CSL_TETB_IESST_ACQ_COMP_EN_SET_SHIFT (0x00000004u)
#define CSL_TETB_IESST_ACQ_COMP_EN_SET_RESETVAL (0x00000000u)
/*----ACQ_COMP_EN_SET Tokens----*/
#define CSL_TETB_IESST_ACQ_COMP_EN_SET_SET (0x00000001u)

#define CSL_TETB_IESST_UNDERFLOW_EN_SET_MASK (0x00000008u)
#define CSL_TETB_IESST_UNDERFLOW_EN_SET_SHIFT (0x00000003u)
#define CSL_TETB_IESST_UNDERFLOW_EN_SET_RESETVAL (0x00000000u)
/*----UNDERFLOW_EN_SET Tokens----*/
#define CSL_TETB_IESST_UNDERFLOW_EN_SET_SET (0x00000001u)

#define CSL_TETB_IESST_OVERFLOW_EN_SET_MASK (0x00000004u)
#define CSL_TETB_IESST_OVERFLOW_EN_SET_SHIFT (0x00000002u)
#define CSL_TETB_IESST_OVERFLOW_EN_SET_RESETVAL (0x00000000u)
/*----OVERFLOW_EN_SET Tokens----*/
#define CSL_TETB_IESST_OVERFLOW_EN_SET_SET (0x00000001u)

#define CSL_TETB_IESST_FULL_EN_SET_MASK (0x00000002u)
#define CSL_TETB_IESST_FULL_EN_SET_SHIFT (0x00000001u)
#define CSL_TETB_IESST_FULL_EN_SET_RESETVAL (0x00000000u)
/*----FULL_EN_SET Tokens----*/
#define CSL_TETB_IESST_FULL_EN_SET_SET (0x00000001u)

#define CSL_TETB_IESST_HALFFULL_EN_SET_MASK (0x00000001u)
#define CSL_TETB_IESST_HALFFULL_EN_SET_SHIFT (0x00000000u)
#define CSL_TETB_IESST_HALFFULL_EN_SET_RESETVAL (0x00000000u)
/*----HALFFULL_EN_SET Tokens----*/
#define CSL_TETB_IESST_HALFFULL_EN_SET_SET (0x00000001u)

#define CSL_TETB_IESST_RESETVAL (0x00000000u)

/* IET */


#define CSL_TETB_IET_ACQ_COMP_ENABLE_MASK (0x00000010u)
#define CSL_TETB_IET_ACQ_COMP_ENABLE_SHIFT (0x00000004u)
#define CSL_TETB_IET_ACQ_COMP_ENABLE_RESETVAL (0x00000000u)

#define CSL_TETB_IET_UNDERFLOW_ENABLE_MASK (0x00000008u)
#define CSL_TETB_IET_UNDERFLOW_ENABLE_SHIFT (0x00000003u)
#define CSL_TETB_IET_UNDERFLOW_ENABLE_RESETVAL (0x00000000u)

#define CSL_TETB_IET_OVERFLOW_ENABLE_MASK (0x00000004u)
#define CSL_TETB_IET_OVERFLOW_ENABLE_SHIFT (0x00000002u)
#define CSL_TETB_IET_OVERFLOW_ENABLE_RESETVAL (0x00000000u)

#define CSL_TETB_IET_FULL_ENABLE_MASK (0x00000002u)
#define CSL_TETB_IET_FULL_ENABLE_SHIFT (0x00000001u)
#define CSL_TETB_IET_FULL_ENABLE_RESETVAL (0x00000000u)

#define CSL_TETB_IET_HALFFULL_ENABLE_MASK (0x00000001u)
#define CSL_TETB_IET_HALFFULL_ENABLE_SHIFT (0x00000000u)
#define CSL_TETB_IET_HALFFULL_ENABLE_RESETVAL (0x00000000u)

#define CSL_TETB_IET_RESETVAL (0x00000000u)

/* IECST */


#define CSL_TETB_IECST_ACQ_COMP_EN_CLEAR_MASK (0x00000010u)
#define CSL_TETB_IECST_ACQ_COMP_EN_CLEAR_SHIFT (0x00000004u)
#define CSL_TETB_IECST_ACQ_COMP_EN_CLEAR_RESETVAL (0x00000000u)
/*----ACQ_COMP_EN_CLEAR Tokens----*/
#define CSL_TETB_IECST_ACQ_COMP_EN_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_IECST_UNDERFLOW_EN_CLEAR_MASK (0x00000008u)
#define CSL_TETB_IECST_UNDERFLOW_EN_CLEAR_SHIFT (0x00000003u)
#define CSL_TETB_IECST_UNDERFLOW_EN_CLEAR_RESETVAL (0x00000000u)
/*----UNDERFLOW_EN_CLEAR Tokens----*/
#define CSL_TETB_IECST_UNDERFLOW_EN_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_IECST_OVERFLOW_EN_CLEAR_MASK (0x00000004u)
#define CSL_TETB_IECST_OVERFLOW_EN_CLEAR_SHIFT (0x00000002u)
#define CSL_TETB_IECST_OVERFLOW_EN_CLEAR_RESETVAL (0x00000000u)
/*----OVERFLOW_EN_CLEAR Tokens----*/
#define CSL_TETB_IECST_OVERFLOW_EN_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_IECST_FULL_EN_CLEAR_MASK (0x00000002u)
#define CSL_TETB_IECST_FULL_EN_CLEAR_SHIFT (0x00000001u)
#define CSL_TETB_IECST_FULL_EN_CLEAR_RESETVAL (0x00000000u)
/*----FULL_EN_CLEAR Tokens----*/
#define CSL_TETB_IECST_FULL_EN_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_IECST_HALFFULL_EN_CLEAR_MASK (0x00000001u)
#define CSL_TETB_IECST_HALFFULL_EN_CLEAR_SHIFT (0x00000000u)
#define CSL_TETB_IECST_HALFFULL_EN_CLEAR_RESETVAL (0x00000000u)
/*----HALFFULL_EN_CLEAR Tokens----*/
#define CSL_TETB_IECST_HALFFULL_EN_CLEAR_CLEAR (0x00000001u)

#define CSL_TETB_IECST_RESETVAL (0x00000000u)

/* TCTL */


#define CSL_TETB_TCTL_RST_MASK (0x00000004u)
#define CSL_TETB_TCTL_RST_SHIFT (0x00000002u)
#define CSL_TETB_TCTL_RST_RESETVAL (0x00000000u)
/*----RST Tokens----*/
#define CSL_TETB_TCTL_RST_RESET_NO (0x00000000u)
#define CSL_TETB_TCTL_RST_RESET_YES (0x00000001u)

#define CSL_TETB_TCTL_STOP_BUF_MASK (0x00000002u)
#define CSL_TETB_TCTL_STOP_BUF_SHIFT (0x00000001u)
#define CSL_TETB_TCTL_STOP_BUF_RESETVAL (0x00000000u)
/*----STOP_BUF Tokens----*/
#define CSL_TETB_TCTL_STOP_BUF_CIRCULAR_MODE (0x00000000u)
#define CSL_TETB_TCTL_STOP_BUF_STOP_MODE (0x00000001u)

#define CSL_TETB_TCTL_TI_MODE_MASK (0x00000001u)
#define CSL_TETB_TCTL_TI_MODE_SHIFT (0x00000000u)
#define CSL_TETB_TCTL_TI_MODE_RESETVAL (0x00000000u)

#define CSL_TETB_TCTL_RESETVAL (0x00000000u)

/* DID */


#define CSL_TETB_DID_ATCLK_SYNC_MASK (0x00000020u)
#define CSL_TETB_DID_ATCLK_SYNC_SHIFT (0x00000005u)
#define CSL_TETB_DID_ATCLK_SYNC_RESETVAL (0x00000001u)

#define CSL_TETB_DID_INPUT_MUXING_LEVEL_MASK (0x0000001Fu)
#define CSL_TETB_DID_INPUT_MUXING_LEVEL_SHIFT (0x00000000u)
#define CSL_TETB_DID_INPUT_MUXING_LEVEL_RESETVAL (0x00000000u)

#define CSL_TETB_DID_RESETVAL (0x00000020u)

/* DTIR */


#define CSL_TETB_DTIR_DTIR_MASK (0x000000FFu)
#define CSL_TETB_DTIR_DTIR_SHIFT (0x00000000u)
#define CSL_TETB_DTIR_DTIR_RESETVAL (0x00000021u)

#define CSL_TETB_DTIR_RESETVAL (0x00000021u)

/* PID4 */


#define CSL_TETB_PID4_NUMBER_BLOCKS_MASK (0x000000F0u)
#define CSL_TETB_PID4_NUMBER_BLOCKS_SHIFT (0x00000004u)
#define CSL_TETB_PID4_NUMBER_BLOCKS_RESETVAL (0x00000000u)

#define CSL_TETB_PID4_JEP106_CC_MASK (0x0000000Fu)
#define CSL_TETB_PID4_JEP106_CC_SHIFT (0x00000000u)
#define CSL_TETB_PID4_JEP106_CC_RESETVAL (0x00000000u)

#define CSL_TETB_PID4_RESETVAL (0x00000000u)

/* PID0 */


#define CSL_TETB_PID0_PART_NUMBER_0_MASK (0x000000FFu)
#define CSL_TETB_PID0_PART_NUMBER_0_SHIFT (0x00000000u)
#define CSL_TETB_PID0_PART_NUMBER_0_RESETVAL (0x00000090u)

#define CSL_TETB_PID0_RESETVAL (0x00000090u)

/* PID1 */


#define CSL_TETB_PID1_JEP106_ID_CODE_3_0_MASK (0x000000F0u)
#define CSL_TETB_PID1_JEP106_ID_CODE_3_0_SHIFT (0x00000004u)
#define CSL_TETB_PID1_JEP106_ID_CODE_3_0_RESETVAL (0x00000007u)

#define CSL_TETB_PID1_PART_NUMBER_1_MASK (0x0000000Fu)
#define CSL_TETB_PID1_PART_NUMBER_1_SHIFT (0x00000000u)
#define CSL_TETB_PID1_PART_NUMBER_1_RESETVAL (0x00000001u)

#define CSL_TETB_PID1_RESETVAL (0x00000071u)

/* PID2 */


#define CSL_TETB_PID2_REVISION_MASK (0x000000F0u)
#define CSL_TETB_PID2_REVISION_SHIFT (0x00000004u)
#define CSL_TETB_PID2_REVISION_RESETVAL (0x00000000u)

#define CSL_TETB_PID2_JEDEC_MASK (0x00000008u)
#define CSL_TETB_PID2_JEDEC_SHIFT (0x00000003u)
#define CSL_TETB_PID2_JEDEC_RESETVAL (0x00000001u)

#define CSL_TETB_PID2_JEP106_ID_CODE_6_4_MASK (0x00000007u)
#define CSL_TETB_PID2_JEP106_ID_CODE_6_4_SHIFT (0x00000000u)
#define CSL_TETB_PID2_JEP106_ID_CODE_6_4_RESETVAL (0x00000001u)

#define CSL_TETB_PID2_RESETVAL (0x00000009u)

/* PID3 */


#define CSL_TETB_PID3_REVISION_MASK (0x000000F0u)
#define CSL_TETB_PID3_REVISION_SHIFT (0x00000004u)
#define CSL_TETB_PID3_REVISION_RESETVAL (0x00000000u)

#define CSL_TETB_PID3_CUSTOMER_MODIFIED_MASK (0x0000000Fu)
#define CSL_TETB_PID3_CUSTOMER_MODIFIED_SHIFT (0x00000000u)
#define CSL_TETB_PID3_CUSTOMER_MODIFIED_RESETVAL (0x00000000u)

#define CSL_TETB_PID3_RESETVAL (0x00000000u)

/* CID0 */


#define CSL_TETB_CID0_CID_MASK (0x000000FFu)
#define CSL_TETB_CID0_CID_SHIFT (0x00000000u)
#define CSL_TETB_CID0_CID_RESETVAL (0x0000000Du)

#define CSL_TETB_CID0_RESETVAL (0x0000000Du)

/* CID1 */


#define CSL_TETB_CID1_CID_MASK (0x000000FFu)
#define CSL_TETB_CID1_CID_SHIFT (0x00000000u)
#define CSL_TETB_CID1_CID_RESETVAL (0x00000090u)

#define CSL_TETB_CID1_RESETVAL (0x00000090u)

/* CID2 */


#define CSL_TETB_CID2_CID_MASK (0x000000FFu)
#define CSL_TETB_CID2_CID_SHIFT (0x00000000u)
#define CSL_TETB_CID2_CID_RESETVAL (0x00000005u)

#define CSL_TETB_CID2_RESETVAL (0x00000005u)

/* CID3 */


#define CSL_TETB_CID3_CID_MASK (0x000000FFu)
#define CSL_TETB_CID3_CID_SHIFT (0x00000000u)
#define CSL_TETB_CID3_CID_RESETVAL (0x000000B1u)

#define CSL_TETB_CID3_RESETVAL (0x000000B1u)

#endif

