/*
 *  Copyright 2007 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *
 *  @(#) TCP/IP_Network_Developers_Kit 1.93.00.09 08-16-2007 (ndk-c09)
 */
//--------------------------------------------------------------------------
// IP Stack Console Demonstration Program
//--------------------------------------------------------------------------
// Console.h
//
// Example router console INCLUDE
//
// Author: Michael A. Denio
// Copyright 1999 by Texas Instruments Inc.
//-------------------------------------------------------------------------

//
// Functions Defined in Console routines
//

// CONSOLE.C
extern SOCKET ConsoleOpen( PSA pSinClient );
extern void ConsoleClose();

// The folloing io routines are used by console functions
extern int  ConPrintf(const char *format, ...);
extern void ConPrintIPN( IPN dwIP );
extern char ConGetCh();
extern int  ConGetString( char *buf, int max, int echo );
#define CGSECHO_NONE     0
#define CGSECHO_INPUT    1
#define CGSECHO_PASSWORD 2
extern IPN  ConGetIP();

// CONROUTE.C
extern void ConCmdRoute( int ntok, char *tok1, char *tok2,
                                   char *tok3, char *tok4 );

// CONACCT.C
extern void ConCmdAcct( int ntok, char *tok1, char *tok2,
                                  char *tok3, char *tok4 );

// CONNAT.C
extern void ConCmdNat( int ntok, char *, char *, char *, char *, char * );

// CONSTAT.C
extern void ConCmdStat( int ntok, char *tok1 );

// CONDNS.C
extern void ConCmdLookup( int ntok, char *tok1 );
extern int  ConStrToIPN( char *str, IPN *pIPN );

// CONPING.C
extern void ConCmdPing( int ntok, char *tok1, char *tok2 );

// CONECHO.C
extern void ConCmdEcho( int ntok, char *tok1, char *tok2 );

// CONSOCK.C
extern void ConCmdSocket( int ntok, char *tok1 );

// CONTFTP.C
extern void ConCmdTFTP( int ntok, char *tok1, char *tok2 );

// CONTEST.C
extern void ConCmdTest( int ntok, char *tok1, char *tok2 );

/* VLAN Support is available only if NIMU support is available. */
#ifdef _INCLUDE_NIMU_CODE
extern void ConCmdVLAN( int ntok, char *tok1, char *tok2, char *tok3, char* tok4 );
extern void ConCmdIPAddr( int ntok, char *tok1, char *tok2, char *tok3, char* tok4 );
#endif

#ifdef _INCLUDE_IPv6_CODE
extern void ConCmdIPv6(int ntok, char *tok1, char *tok2, char *tok3, char* tok4, char* tok5, char* tok6, char* tok7);
extern void ConCmdPing6 ( int ntok, char *tok1, char *tok2 );
extern void ConCmdLookupIPv6( int ntok, char *tok1 );
#endif

// CONLLI.C
void ConCmdLLI( int ntok, char *tok1, char *tok2, char *tok3 );
